/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     Windows NT System Services
  
     Type:     Include file
  
     Desc:     Task Management 
 
     File:     ns_task.x

     Sid:      ns_task.x@@/main/3 - Mon Nov 17 15:53:22 2008
  
     Prg:      ag
  
*********************************************************************21*/

#ifndef  __NSTASKX__
#define  __NSTASKX__

#ifdef __cplusplus
extern "C" {
#endif


/* typedefs */
   
#ifdef NK
typedef   KSEMAPHORE   SsSemaEntry;              /* semaphore */
#endif

#ifdef NU
typedef   HANDLE       SsSemaEntry;              /* semaphore */
#endif

#ifdef NK
typedef   KMUTEX       SsMutexEntry;              /* mutex */
#endif

#ifdef NU
typedef   HANDLE       SsMutexEntry;              /* mutex */
#endif

/* Typedef used for POSIX implementation */
typedef struct ssThrdEntry        Sspthread;
typedef struct ssCondEntry        SspthreadCond;
typedef        SsSemaEntry        SspthreadSem;
typedef        SsMutexEntry       SspthreadMutex;
typedef        SsSemaEntry        SsSemaId;
typedef struct sLockEntry         SLockId;


/* forward definitions */

/************************************************************************
        Common lock structure for NTSS
************************************************************************/
typedef struct sLockEntry
{
   union
   {
#ifdef NK
      FAST_MUTEX        mtx;         /* Mutex in kernel space */
      KSPIN_LOCK        sLock;       /* Spin Lock */
#endif

#ifdef NU
      CRITICAL_SECTION  cSec;        /* Critical section */
      HANDLE            mtx;         /* Mutex in user space */
#endif
   }osLock;                          /* Actual OS lock */

   U32         arg1;                 /* additional argumanet */
   U8          lType;                /* type of the lock */
}SLockEntry;


/************************************************************************
         Driver Task Specific Data 
************************************************************************/
typedef struct ssdDrvrTskEntry
{
   Bool    isFlag;             /* is the interrput pending */
}SsdDrvrTskEntry;


/************************************************************************
          Os specific TAPA task entry data
************************************************************************/
typedef struct  ssdTTskEntry
{
#ifdef NS_ENB_MGMT
   Cntr   actvCnt;                /* entity activation count */
#endif /* NS_ENB_MGMT */

   Buffer *permBuf;               /* buffer pointer for perm tasks */
}SsdTTskEntry;


/************************************************************************
         Os specific system task entry fields 
************************************************************************/
typedef struct ssdSTskEntry
{

#ifdef NU
   HANDLE    sTskHandle;          /* Sys task handle returned by OS */
#endif /* NU */
#ifdef NK
   PKTHREAD  sTskHandle;          /* Sys task object returned by OS */
#endif /* NK */

#ifdef NS_ENB_MGMT
   /* Permannet task related statistics */
   Cntr      loopActvCnt;         /* schedule loop activation count */
   Cntr      loopIdleCnt;         /* schedule loop Idle count */
   Cntr      loopPermCnt;         /* schedule loop Perm Task actv count */
   Cntr      loopNormCnt;         /* schedule loop Norm Task actv count */
   Cntr      loopTmrCnt;          /* schedule loop Timer Task actv count */

   /* demand queue related statistics */
   Cntr      emptyCnt;           /* demand queue empty count */
   Cntr      notEmptyCnt;        /* demand queue not empty count */

   Ent       crntEnt;            /* current entity processed by sys task */
   Inst      crntInst;           /* current instance processed by sys task */
   SLockId   stsLock;            /* lock for crntEnt and crntInst */
#endif /* NS_ENB_MGMT */

}SsdSTskEntry;


/************************************************************************
         Condtion entry structure
************************************************************************/
typedef struct ssCondEntry
{
#ifdef NK
   KSEMAPHORE   sigEvnt;             /* signal semaphore */
#endif

#ifdef NU
   HANDLE       sigEvnt;             /* signal semaphore */
#endif
   U8           condVal;             /* value which decide whether to signal */
}SsCondEntry;


/************************************************************************
           Time structure for POSIX
************************************************************************/
typedef struct  ssTime
{
  S32        tvSec;                /* seconds */
  S32        tvNsec;               /* nano seconds */
}SsTime;


/************************************************************************
           Thread structure in NTSS
************************************************************************/
typedef struct ssThrdEntry
{
#ifdef NU
   HANDLE    thrdHandle;                        /* thread */
#endif /* NU */
#ifdef NK
   PKTHREAD  thrdHandle;                        /* thread */
#endif /* NK */
   S32       prior;                             /* thread priority */
   Void     *attr;                              /* for posix only */
}SsThrdEntry;

/************************************************************************
           Thread attribute structure in POSIX
************************************************************************/

typedef struct sspthreadAttr 
{
   Void *sspthreadAttrp;
} SspthreadAttr;


typedef struct schedParam
{
   S32         schedPrior;
}SchedParam;

/* thread attribute structure */
typedef struct threadAttr
{
   S32          contentionScope;
   S32          detachState;

#ifdef _POSIX_THREAD_ATTR_STACKADDR
   S32          stackAddr;
#endif

#ifdef _POSIX_THREAD_ATTR_STACKSIZE
   S32          stackSize;
#endif

   S32          policy;
   SchedParam   param;
   S32          inheritSched;
}ThreadAttr;

/************************************************************************
              attributes for mutex, dynamically allocated 
************************************************************************/
typedef struct sspthreadMutexAttr 
{
   void   *sspthreadMutexAttrp;
} SspthreadMutexAttr;


typedef struct mutexAttr
{
   
#ifdef _POSIX_THREAD_PROCESS_SHARED
   S32         pshared;
#endif

#if (defined (_POSIX_THREAD_PRIO_PROTECT))
             &&(defined (_POSIX_THREAD_PRIOR_INHERIT))
   S32         prioceiling;
   S32         protocol;
#endif

   U8          dummy;
}MutexAttr;


/************************************************************************
          attributes for cond, dynamically allocated 
************************************************************************/
typedef struct sspthreadCondAttr 
{
   void   *sspthreadCondAttrp;
} SspthreadCondAttr;


typedef struct condAttr
{
#ifdef _POSIX_THREAD_PROCESS_SHARED
   S32         pshared;
#endif
   U8          dummy;
}CondAttr;

/* ns003.301 1. read write lock support */
#ifdef SS_LOCK_SUPPORT
typedef struct sLockInfo
{
	union
	{
#ifdef SS_RDWR_LOCK_SUPPORT
	  SLockId    rdWrLockId;
#endif /* SS_RDWR_LOCK_SUPPORT */
#ifdef SS_REC_LOCK_SUPPORT 
	  SLockId    recurLock;
#endif /* SS_RDWR_LOCK_SUPPORT */
	}l;
}SLockInfo;
#endif /* SS_LOCK_SUPPORT */


/* functions prototypes */

EXTERN S16 ssInitSema                  ARGS((SsSemaId *sema, U8 count));
EXTERN S16 ssDestroySema               ARGS((SsSemaId *sema));
EXTERN S16 ssPostSema                  ARGS((SsSemaId *sema));
EXTERN S16 ssWaitSema                  ARGS((SsSemaId *sema));

/* ns004.12: addition */
EXTERN S16 SInitSemaphore              ARGS((SsSemaId *sema, U8 count));
EXTERN S16 SDestroySemaphore           ARGS((SsSemaId *sema));
EXTERN S16 SPostSemaphore              ARGS((SsSemaId *sema));
EXTERN S16 SWaitSemaphore              ARGS((SsSemaId *sema));

EXTERN S32 sspthreadAttrInit           ARGS((SspthreadAttr *attr));
EXTERN S32 sspthreadAttrDestroy        ARGS((SspthreadAttr *attr));

EXTERN S32 sspthreadAttrSetStackSize   ARGS((SspthreadAttr *attr));
EXTERN S32 sspthreadAttrGetStackSize   ARGS((SspthreadAttr *attr,Size *ssize));

EXTERN S32 sspthreadAttrSetStackAddr   ARGS((SspthreadAttr *attr,void *saddr));
EXTERN S32 sspthreadAttrGetStackAddr   ARGS((SspthreadAttr *attr,void **saddr));

EXTERN S32 sspthreadAttrSetDetachState ARGS((SspthreadAttr *attr,S32 dstate));
EXTERN S32 sspthreadAttrGetDetachState ARGS((SspthreadAttr *attr,S32 *dstate));

EXTERN S32 sspthreadAttrSetScope       ARGS((SspthreadAttr *attr,S32 scope));
EXTERN S32 sspthreadAttrGetScope       ARGS((SspthreadAttr *attr,S32 *scope));

EXTERN S32 sspthreadAttrSetInheritSched ARGS((SspthreadAttr *attr,S32 isched));
EXTERN S32 sspthreadAttrGetInheritSched ARGS((SspthreadAttr *attr,S32 *isched));

EXTERN S32 sspthreadAttrSetSchedPolicy ARGS((SspthreadAttr *attr,S32 policy));
EXTERN S32 sspthreadAttrGetSchedPolicy ARGS((SspthreadAttr *attr,S32 *policy));

PUBLIC S32 sspthreadAttrSetSchedParam  ARGS((SspthreadAttr *attr,SchedParam *param));
PUBLIC S32 sspthreadAttrGetSchedParam  ARGS((SspthreadAttr *attr,SchedParam *param));

EXTERN S32  sspthreadCreate ARGS((Sspthread *thread, SspthreadAttr *attr,
                                 void* (*) (void*), void *arg));
EXTERN S32  sspthreadEqual  ARGS((Sspthread *thread1, Sspthread  *thread2));
EXTERN Void sspthreadExit ARGS((void  *valuePtr));
EXTERN S32  sspthreadJoin ARGS((Sspthread     *thread, void **valuePtr));
EXTERN Sspthread *sspthreadSelf  ARGS((void ));
EXTERN S32  sspthreadGetSchedParam ARGS((Sspthread *thread,S32 *policy,
                                            SchedParam    *param));
EXTERN S32  sspthreadSetSchedParam ARGS((Sspthread *thread,S32 policy,
                                            SchedParam    *param));
EXTERN Void sspthreadSchedYield ARGS((void));

EXTERN S32  sspthreadMutexAttrInit ARGS((SspthreadMutexAttr *attr));
EXTERN S32  sspthreadMutexAttrSetPshared ARGS((SspthreadMutexAttr *attr,
                                                S32 pshared));
EXTERN S32  sspthreadMutexAttrGetPshared ARGS((SspthreadMutexAttr *attr,
                                                S32 *pshared));
EXTERN S32  sspthreadMutexAttrSetPriorceiling ARGS((SspthreadMutexAttr *attr,
                                                S32 priorceiling));
EXTERN S32  sspthreadMutexAttrGetPriorceiling ARGS((SspthreadMutexAttr *attr,
                                                S32 *priorceiling));
EXTERN S32  sspthreadMutexAttrSetProtocol ARGS((SspthreadMutexAttr *attr,
                                                S32 protocol));
EXTERN S32  sspthreadMutexAttrGetProtocol ARGS((SspthreadMutexAttr *attr,
                                                S32 *protocol));
EXTERN S32  sspthreadMutexAttrDestroy     ARGS((SspthreadMutexAttr *attr));

EXTERN S32  sspthreadMutexGetpriorceiling ARGS((SspthreadMutex  *mutex,
                                                 S32 *priorceiling));
EXTERN S32  sspthreadMutexSetpriorceiling ARGS((SspthreadMutex  *mutex,
                                                 S32 priorceiling));
EXTERN S32  sspthreadMutexInit     ARGS((SspthreadMutex *mutex,
                                         SspthreadMutexAttr *attr));
EXTERN S32  sspthreadMutexLock     ARGS((SspthreadMutex  *mutex));
EXTERN S32  sspthreadMutexUnlock   ARGS((SspthreadMutex  *mutex));
EXTERN S32  sspthreadMutexDestroy  ARGS((SspthreadMutex  *mutex));


EXTERN S32  sspthreadCondAttrInit  ARGS((SspthreadCondAttr *attr));
EXTERN S32  sspthreadCondAttrSetPshared  ARGS((SspthreadCondAttr  *attr,
                                                  S32 pshared));
EXTERN S32  sspthreadCondAttrGetPshared  ARGS((SspthreadCondAttr  *attr,
                                                  S32 *pshared));
EXTERN S32  sspthreadCondAttrDestroy     ARGS((SspthreadCondAttr *attr));
EXTERN S32  sspthreadCondBroadcast       ARGS((SspthreadCond *cond));
EXTERN S32  sspthreadCondDestroy         ARGS((SspthreadCond *cond));
EXTERN S32  sspthreadCondInit            ARGS((SspthreadCond     *cond,
                                                  SspthreadCondAttr *attr));
EXTERN S32  sspthreadCondSignal          ARGS((SspthreadCond *cond));
EXTERN S32  sspthreadCondWait            ARGS((SspthreadCond  *cond,
                                                  SspthreadMutex *mutex));
EXTERN S32  sspthreadCondTimedWait  ARGS((SspthreadCond  *cond,
                                       SspthreadMutex *mutex, SsTime *abstime));

EXTERN S32  sspthreadSemDestroy  ARGS((SspthreadSem  *sem));
EXTERN S32  sspthreadSemInit     ARGS((SspthreadSem *sem, 
                                            S32 pshared, U32 value));
EXTERN S32  sspthreadSemPost     ARGS((SspthreadSem  *sem));
EXTERN S32  sspthreadSemTrywait  ARGS((SspthreadSem  *sem));
EXTERN S32  sspthreadSemWait     ARGS((SspthreadSem  *sem));

#ifdef NK
EXTERN S16 nsCreateThread        ARGS((Void *th, Void *sR, Void *sC, \
                                                            U32 sS, U32 tId));
EXTERN S16 nsWaitForSingleObject ARGS((Void *obj, U32 time));
EXTERN S16 nsCondTimeWait        ARGS((SsCondEntry *obj, SsTime *time));
#endif /* NK */
#ifndef SS_STSK_HANDLER
PUBLIC VOID  *sTskHandler ARGS((VOID   *context));
#endif /* SS_STSK_HANDLER */


#ifdef __cplusplus
}
#endif

#endif  /*  __NSTASKX__  */



/********************************************************************30**
 
         End of file:     ns_task.x@@/main/3 - Mon Nov 17 15:53:22 2008
 
*********************************************************************31*/
 

/********************************************************************40**
 
        Notes:
 
*********************************************************************41*/
 
/********************************************************************50**
 
*********************************************************************51*/
 

/********************************************************************60**
 
        Revision history:
 
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      ag   1. initial release
  
1.2          ---      ag   1. Changed U8 to Buffer* for ssdTTskEntry
             ---      sn   2. Modifications to C++ compile
            ns004.12 bdu   3. added prototypes for SInitSemaphore, 
                              SWaitSemaphore, SPostSemaphore, 
                              SDestroySemaphore. 
/main/3      ---      rp   1. Addition of Multicore support
/main/1+     ns003.301 rss  1. read write lock support
*********************************************************************91*/
