/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     Windows NT System Services
  
     Type:     Include file
  
     Desc:     Task Management 
 
     File:     ns_task.h

     Sid:      ns_task.h@@/main/3 - Mon Nov 17 15:53:21 2008
  
     Prg:      ag
  
*********************************************************************21*/

#ifndef __NSTASKH__
#define __NSTASKH__

/* tasking  related */
/* ns020.102: Multi Proc support added */
/* addition: multiple procs support related changes */
#ifdef SS_MULTIPLE_PROCS
#define SS_MAX_PROCS                    100 /* max entries for proc list */
#endif /* SS_MULTIPLE_PROCS */

#define SS_MAX_ENT                      255
#define SS_MAX_INST                     10

/* ns020.102: Multi Proc support added */
/* modification: multiple procs support related changes */
#ifndef SS_MULTIPLE_PROCS
#ifndef SS_MULTICORE_SUPPORT
#define SS_MAX_STSKS                    20
#else
#define SS_MAX_STSKS                    6
#endif
#ifndef SS_MULTICORE_SUPPORT
#define SS_MAX_TTSKS                    SS_MAX_STSKS
#else
#define SS_MAX_TTSKS                    20
#endif
#else /* SS_MULTIPLE_PROCS */
#define SS_MAX_TTSKS                    1000
#define SS_MAX_STSKS                    30
#endif /* SS_MULTIPLE_PROCS */

#ifdef SS_DRVR_SUPPORT
#define SS_MAX_DRVRTSKS                 128
#endif


/* POSIX related */
#ifdef _POSIX_THREAD_PRIO_INHERIT
#define _POSIX_THREAD_PRIORITY_SCHEDULING
#endif

#ifdef _POSIX_THREAD_PRIO_PROTECT
#define _POSIX_THREAD_PRIORITY_SCHEDULING
#endif

#ifdef _POSIX_THREAD_PRIORITY_SCHEDULING
#define _POSIX_THREADS
#endif

#ifdef _POSIX_THREADS
#define _POSIX_THREAD_SAFE_FUNCTIONS
#endif

#define PTHREAD_THREAD_MAX              

/* detach */
#define   PTHREAD_CREATE_DETACHED      0x40   
#define   PTHREAD_CREATE_JOINABLE      0

/* scope */
#define   PTHREAD_SCOPE_SYSTEM      0x01
#define   PTHREAD_SCOPE_PROCESS      0

/*
 * Other attributes which are not defined in thread.h
 */
/* inherit */
#define   PTHREAD_INHERIT_SCHED      1
#define   PTHREAD_EXPLICIT_SCHED      0

/*
 * Value of process-shared attribute
 */
#define   PTHREAD_PROCESS_SHARED      1   /* = USYNC_PROCESS */
#define   PTHREAD_PROCESS_PRIVATE      0   /* = USYNC_THREAD */
#define   DEFAULT_TYPE         PTHREAD_PROCESS_PRIVATE

/*
 * macros - default initializers
 */
#define   PTHREAD_MUTEX_INITIALIZER   {0, 0, 0}   /* = DEFAULTMUTEX */

#define   PTHREAD_COND_INITIALIZER   {0, 0}      /* = DEFAULTCV */

/* ns003.301 : Modifications 
 * These values are available in errno.h
 * No need to define explicitly
 * */
/* POSIX calls Error codes */ 
#define POSIX_ERR_BASE         100
#if 0
#define ESRCH                  POSIX_ERR_BASE +3 
#define EINTR                  POSIX_ERR_BASE +4
#define EAGAIN                 POSIX_ERR_BASE +11
#define ENOMEM                 POSIX_ERR_BASE +12
#define EFAULT                 POSIX_ERR_BASE +14
#define EINVAL                 POSIX_ERR_BASE +22
#define EDEADLK                POSIX_ERR_BASE +45
#endif /* 0 */
#define ENOTSUP                POSIX_ERR_BASE +48
#define ETIME                  POSIX_ERR_BASE +62
#define INVALID_POLICY         0xff
#define SCHED_OTHER            0
#define SCHED_FIFO             1
#define SCHED_RR               2


/* Common NTSS codes */

#define SS_STSKTBL_LOCK        SS_LOCK_MUTEX
#define SS_STSKENTRY_LOCK      SS_LOCK_MUTEX
#define SS_DRVRENTRY_LOCK      SS_LOCK_MUTEX
#define SS_DMNDQ_LOCK          SS_LOCK_MUTEX

#ifdef NU
#define NS_STS_LOCK            SS_LOCK_CRITSEC
#endif /* NU */

#ifdef NK
#define NS_STS_LOCK            SS_LOCK_SPIN
#endif /* NK */

#define NS_DFLT_PRIOR          13

/* Size of the priority lookup table */
#define NS_MAX_PRIOR           32

/* priority of the termination event message */
#define NS_TERM_EVNT_PRIOR     10

/* stack size for the thread to be created */
#define NS_DFLT_STACK_SIZE      0   /* specify 0 to make it system default */

/* semaphore related stuff */
#define NS_SEM_VALUE_MAX       0xffff

/* time related stuff */
#define NS_INFINITE            0xffffffff

/* some defines */
#define  WAIT_OK               ROK

#ifdef NK
#define WAIT_TIMEOUT           RFAILED +1
#endif /* NK */

/* some macros used on mBufs */
#define SS_GET_MSGTYPE_FROM_MBUF(x)  \
        (((SsMsgInfo *)(x->b_rptr))->eventInfo.event)

#define SS_GET_PST_FROM_MBUF(x)  \
        &((SsMsgInfo *)x->b_rptr)->pst

#define SS_GET_DENT_FROM_MBUF(x)  \
        (((SsMsgInfo *)x->b_rptr)->pst.dstEnt) 

/* ns020.102: Multi Proc support added */
#define SS_GET_DPROC_FROM_MBUF(x)  \
        (((SsMsgInfo *)x->b_rptr)->pst.dstProcId) 

#define SS_GET_SENT_FROM_MBUF(x)  \
        (((SsMsgInfo *)(x->b_rptr))->pst.srcEnt) 

#define SS_GET_DINST_FROM_MBUF(x)  \
        (((SsMsgInfo *)(x->b_rptr))->pst.dstInst) 

#define SS_GET_SINST_FROM_MBUF(x)  \
        (((SsMsgInfo *)(x->b_rptr))->pst.srcInst)

#define SS_GET_TMRIDX_FROM_MBUF(x)  \
        (((SsMsgInfo *)(x->b_rptr))->eventInfo.u.tmr.tmrIdx)

#define SS_GET_DYNBUF_FROM_MBUF(x)  \
        (((SsMsgInfo *)(x->b_rptr))->eventInfo.u.tmr.dynBuf)

#define SS_RESET_INUSE_IN_MBUF(x)  \
        ((SsMsgInfo *)(x->b_rptr))->eventInfo.u.tmr.inUse = FALSE;

/* macro */
#ifdef SS_SINGLE_THREADED
#define ssdPstTsk(pst, mBuf, tTsk)  SetEvent(osCp.dep.eventWaitArray[NS_MSD_EVNT_IDX])   
#else
#define ssdPstTsk(pst, mBuf, tTsk)    
#endif /* SS_SINGLE_THREADED */

/* for self thread checking */

#ifdef NU
#define SS_CHECK_CUR_STSK(s)     (GetCurrentThread() == (s)->dep.sTskHandle)
#endif

#ifdef NK
#define SS_CHECK_CUR_STSK(s) \
          (PsGetCurrentThread() == (PETHREAD)((s)->dep.sTskHandle))
#endif

#ifdef SS_SINGLE_THREADED
#define ssInitSema(sem, count)    (ROK)
#define ssDestroySema(sem)        (ROK)
#define ssPostSema(sem)           (ROK)
#define ssWaitSema(sem)           (ROK)
/* ns004.12: addition */
#define SInitSemaphore(sem, count)   (ROK)
#define SDestroySemaphore(sem)       (ROK)
#define SPostSemaphore(sem)          (ROK)
#define SWaitSemaphore(sem)          (ROK)
#endif /* SS_SINGLE_THREADED */

#ifdef NK
#define  nsGetCurrentThread() \
         KeGetCurrentThread()

#define  nsExitThread(status) \
         ASSERT(KeGetCurrentIrql() ==  PASSIVE_LEVEL);\
         PsTerminateSystemThread((NTSTATUS )(status))

#define  nsThreadJoin(thrd, valuePtr)\
         ASSERT(KeGetCurrentIrql() ==  PASSIVE_LEVEL);\
         KeWaitForSingleObject((PVOID)thrd, Executive, KernelMode, \
                                                          TRUE, NULL)
#define  nsCondWait(cond)\
         ASSERT(KeGetCurrentIrql() <=  DISPATCH_LEVEL);\
         KeWaitForSingleObject(&cond->sigEvnt, Executive, \
                                     KernelMode, TRUE, NULL)

#define  nsCondBroadcast(cond)\
         if(cond->condVal >0)       \
         {  \
            ASSERT(KeGetCurrentIrql() <=  DISPATCH_LEVEL);\
            KeReleaseSemaphore(&cond->sigEvnt, 0, cond->condVal, FALSE);\
         }

#define  nsThreadYield()
        
#define  nsSignalCond(cond)\
         if(cond->condVal >0)       \
         { \
            ASSERT(KeGetCurrentIrql() <=  DISPATCH_LEVEL);\
            KeReleaseSemaphore(&cond->sigEvnt, 0, 1, FALSE); \
         }

#define  nsSetThreadPriority(thrd, prior) \
         (KeSetPriorityThread(*thrd, (KPRIORITY)prior), ROK)

#define  nsCreateMutex(mtx)\
         (KeInitializeMutex((PKMUTEX)mtx,0), ROK)

#define  nsLockMutex(mtx)\
         ((KeWaitForSingleObject((PVOID)mtx, Executive, KernelMode,  \
                 FALSE, 0) == STATUS_SUCCESS)? ROK:RFAILED)

#define  nsUnlockMutex(mtx)\
         ((KeReleaseMutex((PKMUTEX)mtx, FALSE) == 0) ? ROK: RFAILED)

#define  nsDestroyMutex(mtx)  ROK
#define  nsDestroySema(sem)   ROK

#define  nsDestroyCond(cond)  ROK
        
#define  nsCreateCond(cond)\
         (KeInitializeSemaphore(&cond->sigEvnt, 0, NS_SEM_VALUE_MAX), ROK)

#define  nsCreateSema(sem, val, max)\
         (KeInitializeSemaphore(sem,val,max), ROK)

#define  nsPostSema(sem)\
         (KeReleaseSemaphore(sem,0, 1, FALSE), ROK) 

#endif /* NK */

#ifdef NU
#define  nsGetCurrentThread() \
         GetCurrentThread()

#define  nsExitThread(status) \
         ExitThread((DWORD)status)

/* ns016.102 - Modification for Windows CE Support */
#ifndef SS_WINCE
#define  nsGetThreadPriority(thrd, prior) \
         prior = GetThreadPriority(*(HANDLE *)thrd)
#else /* SS_WINCE */
#define  nsGetThreadPriority(thrd, prior) \
         prior = CeGetThreadPriority(*(HANDLE *)thrd)
#endif /* SS_WINCE */

#define  nsThreadJoin(thrd, valuePtr)\
         WaitForSingleObject((HANDLE)thrd, INFINITE); \
         GetExitCodeThread((HANDLE)thrd, (DWORD *) *valuePtr);

#define  nsCondWait(cond)\
         WaitForSingleObject(cond->sigEvnt, INFINITE);

/* ns016.102 - Modification for Windows CE Support */
#ifdef SS_WINCE
         #define  nsThreadYield() Sleep(0)
#else /* SS_WINCE */
         #define  nsThreadYield() SwitchToThread()
#endif /* SS_WINCE */

#define  nsCondBroadcast(cond)\
         if(cond->condVal > 0)   \
            ReleaseSemaphore(cond->sigEvnt, cond->condVal, 0);
        
#define  nsSignalCond(cond)\
         if(cond->condVal > 0)   \
            ReleaseSemaphore(cond->sigEvnt,1, 0); 

#define  nsCreateThread(tH, sR, sC, sS, tId)\
         ( ((*(HANDLE *)tH) = CreateThread(NULL, (DWORD)sS, \
             (LPTHREAD_START_ROUTINE)sR, sC, 0, (LPDWORD) &tId)) == NULLP ? RFAILED: ROK)

/* ns016.102 - Modification for Windows CE Support */
#ifndef SS_WINCE
#define  nsSetThreadPriority(thrd, prior) \
         (SetThreadPriority(*(HANDLE*)thrd, prior) == 0 ? RFAILED: ROK)
#else /* SS_WINCE */
#define  nsSetThreadPriority(thrd, prior) \
         (CeSetThreadPriority(*(HANDLE*)thrd, prior) == 0 ? RFAILED: ROK)
#endif /* SS_WINCE */

#define  nsCreateMutex(mtx)\
         (((*(HANDLE *)mtx) = CreateMutex(NULLP, FALSE, NULLP)) == NULLP \
                               ?RFAILED:ROK)
#define  nsLockMutex(mtx)\
         ((WaitForSingleObject(*(HANDLE*)mtx, INFINITE) == WAIT_TIMEOUT)?\
             RFAILED:ROK)

#define  nsUnlockMutex(mtx)\
         (ReleaseMutex(*(HANDLE*)mtx), ROK)

#define  nsDestroyMutex(mtx)\
         ((CloseHandle(*(HANDLE *)mtx) == 0)? RFAILED:ROK)

#define  nsDestroyCond(cond)\
         ((CloseHandle(cond->sigEvnt) == 0)? RFAILED:ROK)

#define  nsCreateCond(cond)\
         (cond->condVal = 0, \
         ((cond->sigEvnt  = \
           CreateSemaphore(NULL, 0, NS_SEM_VALUE_MAX, 0)) == 0)? RFAILED: ROK)
        
#define  nsCondTimeWait(cond, time)\
         ((WaitForSingleObject(cond->sigEvnt, \
             (DWORD)(time->tvSec*10^3 + time->tvNsec/10^6)) == WAIT_TIMEOUT)?\
                  WAIT_TIMEOUT: WAIT_OK)

#define  nsDestroySema(sem)\
         ((CloseHandle(*(HANDLE*)sem) == 0)?RFAILED:ROK)

#define  nsCreateSema(sem, val,max)\
         (((*(HANDLE *)sem = CreateSemaphore(NULL,val,max, NULL)) == NULLP)? \
                      RFAILED:ROK)

#define  nsPostSema(sem)\
         ((ReleaseSemaphore(*(HANDLE*)sem,1, NULL) == 0)? RFAILED: ROK)

#define  nsWaitForSingleObject(obj,time)\
         ((WaitForSingleObject(*(HANDLE*)obj,(DWORD)time) == WAIT_OBJECT_0)? \
                    WAIT_OK:WAIT_TIMEOUT)

#endif /* NU */

#endif /* __NSTASKH__ */


/********************************************************************30**
  
         End of file:     ns_task.h@@/main/3 - Mon Nov 17 15:53:21 2008
  
*********************************************************************31*/
  
  
/********************************************************************40**
  
        Notes: 
  
*********************************************************************41*/
  
/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      ag   1. initial release
  
1.2          ---      ag   1. Changed SS_MAX_STSKS to SS_MAX_TTSKS from 
                              a value 10
             ---      ag   2. Added NS_STS_LOCK for KNTSS
             ---      kr   3. Fixed a bug in nsThreadJoin for KNTSS
             ---      ag   4. Added macro ssdPstTsk for single and
                              multi-threaded case
             ---      sn   5. Modifications to C++ compile

1.2+         ns000.12 bsr  1. changed SS_MAX_DRVRTSKS to 128 (required for
                              relay operation )
             ns004.12 bdu  2. added SInitSemaphore, SWaitSemaphore,
                              SPostSemaphore, SDestroySemaphore.
1.2+        ns016.102 bjp  3. Addition of Windows CE Support
1.2+        ns020.102 ve   1.  Multi Proc support added
/main/3      ---      rp   1. Addition of Multicore support
*********************************************************************91*/
