/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/



/********************************************************************20**
  
     Name:     Windows NT System Services
  
     Type:     Include File
  
     Desc:     Initialization and miscellaneous functions
 
     File:     ns_gen.x

     Sid:      ns_gen.x@@/main/3 - Mon Nov 17 15:53:20 2008
  
     Prg:      ag
  
*********************************************************************21*/

#ifndef __NSGENX__
#define __NSGENX__

#ifdef __cplusplus
extern "C" {
#endif



/* typedefs */
typedef U8        SsdRegionEntry;
typedef U8        SsdPoolEntry;


/* forward definitions */

/************************************************************************
         Device Specific Data  and Interrupt description
************************************************************************/

#ifdef NK 

typedef S16       (*PFIOCTL)(U32 devId, PVOID context);
typedef S16       (*PFOPEN)(U32 devId, PIRP irp);
typedef S16       (*PFCLOSE)(U32 devId, PIRP irp);
typedef S16       (*PFUNLOAD)(U32 devId, PDEVICE_OBJECT devObj);

typedef S16       (*NSPIF)(Ptr devObj);
 
typedef struct nsDevCtl
{
   PFIOCTL  ioctl;
   PFOPEN   open;
   PFCLOSE  close;
   PFUNLOAD unload;
} NsDevCtl;

typedef struct nsDeviceExtension
{
   U32             devId;            /* device identifier */
   NsDevCtl        devCtl;           /* device control */
   UNICODE_STRING  win32DevName;     /* WIN32 device name */
   Ptr             isrDprContext;    /* context passed to ISR/DPR routines */
   PKINTERRUPT      intrObject;       /* interrupt object */
   NSPIF           isrFunct;         /* ISR function */
   NSPIF           dprFunct;         /* DPR function */
} NsDeviceExtension;

typedef struct nsIntr
{
   INTERFACE_TYPE  interfaceType;    /* type of the interface */
   U32 busNmb;                       /* system relative bus number */
   U32 busIntrLevel;                 /* bus specific interrupt level */
   U32 busIntrVect;                  /* bus specific interrupt vector */
   U8  intrMode;                     /* interrupt mode, latched or lvl sens */
   U8  intrShared;                   /* shared interrupt? */
} NsIntr;

#endif /* NK */


/************************************************************************
         Random Number Generation Specific Data 
************************************************************************/

#ifdef NK 
typedef struct ssdRand                /* pseudo random number control point */
{
   S16 count;                         /* count */
   Random seed;                       /* seed */
   S16 ia2;                           /* multiplier 2 */
   Random ix2;                        /* accumulator 2 */
   S16 ia1;                           /* multiplier 1 */
   Random ix1;                        /* accumulator 1 */
   Random random;                     /* random number */
   Random ixs[NPILES];                /* pile */
} SsdRand;

#endif /* NK */

/************************************************************************
         Os Specific Data 
************************************************************************/
typedef struct ssdOs
{
/* ns016.102 - Modifcation for Windows CE Support */
#ifndef SS_WINCE
   S8   wPriorLookup[NS_MAX_PRIOR];   /* priority lookup table for
                                       * priority conversion 
                                       */
#else /* SS_WINCE */
   S16   wPriorLookup[NS_MAX_PRIOR];   /* priority lookup table for
                                       * priority conversion 
                                       */
#endif /* SS_WINCE */
   U16  stkId;                        /* local stack id */
   U8   permTskCount;                 /* number of perm tasks */
/* ns016.102 - Modifcation for Windows CE Support */
#if (!defined(SS_SINGLE_THREADED) || defined(SS_WINCE))
#ifdef CONAVL
/* ns010.102 - Addition for CONRD support */
#ifndef CONRD
   Sspthread  conThrd;                /* thread for console */
#endif /* CONRD */
#endif /* CONAVL */

#ifdef SS_DRVR_SUPPORT
   Sspthread  intThrd;                /* thread for interrupts */
#endif /* SS_DRVR_SUPPORT */
/* ns016.102 - Modifcation for Windows CE Support */
#endif /* !SS_SINGLE_THREADED || SS_WINCE*/

#ifdef NK
   PDRIVER_OBJECT driverObject;       /* pointer to Driver Object */
   UNICODE_STRING regPath;            /* Registry Path */
   SsdRand        randCp;             /* pseudo random number control point */
   KEVENT         termComplete;       /* All thread are terminated */
   HANDLE         logFileHandle;      /* file handle for error logging */
   Bool           intThreadTermPend;  /* Interrupt thread termination pending*/
   KEVENT         intThreadTerminated;/* interrupt thread terminated */
#endif /* NK */

   Sspthread      tmrThrd;            /* timer thread handle */

   /* 
    * This array here includes timers as well as interrupt event and
    * message delivery event 
    * Following is the position of events:
    * 0 -   Interrupt event
    * 1 -   Message delivery event
    * 2 -   Console event (something in console input buffer)
    * 3 -   Timer addition or cancellation event
    * 4 onwards - All timers registered
    */

   ULONG        eventCount;          /* numbers of events */
   U8           eventIdx;            /* index of the event signaled */
   SLockId      waitArrayLock;
#ifdef NU
   HANDLE       eventWaitArray[NS_MAX_TMRS];
#endif /* NU */

#ifdef NK
   PKTIMER      eventWaitArray[NS_MAX_TMRS];
#endif /* NK */
   SsSemaId* ssStarted;
} SsdOs;

/************************************************************************
         Memory Configuration
************************************************************************/
typedef struct nsBktCfg
{
   Size     blkSize;       /* quantum block size in this bkt */
   Size     numBlks;       /* no. of blocks in this bkt */
} NsBktCfg;

typedef struct nsRegCfg
{
   Region    regionId;    /* Region Id */
   U8        numBkts;     /* No.of bkts configured in this region */
   U32       flags;       /* Flags to describe characteristics of the region */
   Size      heapSize;    /* heap size available in this region */
   NsBktCfg  bkt[SS_MAX_POOLS_PER_REG]; /* bkt configuration */
} NsRegCfg;

typedef struct nsMemCfg
{
   U8       numRegions;             /* no.of regions */
   NsRegCfg region[SS_MAX_REGS];    /* region configuration */
} NsMemCfg;

/************************************************************************
         Pool Specific Data 
************************************************************************/
typedef struct ssdDPoolEntry
{
#ifdef NS_ENB_MGMT
   Size    maxSize;                   /* maximun size */
   Size    crntSize;                  /* current size */
   Size    minSize;                   /* minimum size */
#endif /* NS_ENB_MGMT */

   U8      dummy;
}SsdDPoolEntry;

typedef struct ssdSPoolEntry
{ 
#ifdef NS_ENB_MGMT
   Size    maxSize;                   /* maximun size */
   Size    crntSize;                  /* current size */
   Size    minSize;                   /* minimum size */
   Size    bufSize;                   /* buffer size */ 
#endif /* NS_ENB_MGMT */

   U8      dummy;
} SsdSPoolEntry;



/* function prototypes */

/* Support functions */

#ifdef NK
EXTERN Void nsInitPiles  ARGS((void ));
EXTERN  NTSTATUS DriverEntry ARGS((PDRIVER_OBJECT DriverObject,
                                  PUNICODE_STRING RegistryPath));
EXTERN S16 nsRegDevice ARGS((U8 *name, U32 devId, PDRIVER_OBJECT  *driverObject,
                             PDEVICE_OBJECT  *deviceObject, 
                             PUNICODE_STRING *regPath, NsDevCtl *devCtl));

EXTERN S16 nsDeregDevice  ARGS((PDEVICE_OBJECT deviceObject));
EXTERN S16 nsReadRegistry ARGS((PUNICODE_STRING regPath, U32 code,
                                VOID *keyValue));
EXTERN S16 nsParseRegInfo ARGS((PUNICODE_STRING  regString, NsRegCfg *regCfg));
EXTERN S16 nsGetNext      ARGS((PUNICODE_STRING  uniStr, PULONG value));
EXTERN S16 nsRegIsrDpr    ARGS((PDEVICE_OBJECT devObj, NsIntr *intrDesc, 
                                Ptr context, NSPIF isrFunct, NSPIF dprFunct));
EXTERN S16 nsDeregIsrDpr  ARGS((PDEVICE_OBJECT devObj));
#endif /* NK */

#ifdef NU
#ifdef CONAVL
/* ns010.102 - Addition for CONRD support */
#ifndef CONRD
EXTERN Void *nsScanCon      ARGS((Void *context));
#endif /* CONRD */
#endif /* CONAVL */
#endif /* NU */

#ifdef SS_DRVR_SUPPORT
EXTERN Void *nsScanInt      ARGS((Void *context));
#endif /* SS_DRVR_SUPPORT */

EXTERN S16 nsGetSId ARGS((SystemId *s));
EXTERN S16 nsActvTsk        ARGS((Pst *pst, Buffer *mBuf));
  
/* external variables */
EXTERN TskInit nsInit;

#ifdef __cplusplus
}
#endif

#endif /* __NSGENX__ */


/********************************************************************30**
  
         End of file:     ns_gen.x@@/main/3 - Mon Nov 17 15:53:20 2008
  
*********************************************************************31*/
  
  
/********************************************************************40**
  
        Notes: 
  
*********************************************************************41*/
  
/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      ag   1. initial release
  
1.2          ---      ag   1. Added intThrd and tmrThrd in ssdOs
             ---      bsr  2. Added NsDevCtl structure declaration.
             ---      bsr  3. Added nsDeviceExtension structure
             ---      ag   4. Enabled function nsScanInt for UNTSS and
                              KNTSS
             ---      ag   5. Added permTskCount, eventCount, eventIdx,
                              waitArrayLock, and eventWaitArray in 
                              ssdOs 
             ---      bsr  6. Renamed nsDriverObject and nsRegPath
                              to driverObject and regPath respectively
             ---      bsr  7. Added logFileHandle and intThreadTermPend
                              to ssdOs
             ---      bsr  8. Added prototypes for nsReadRegistry, nsRegDevice,
                              nsDeregDevice, nsParseRegInfo, nsGetNext.
             ---      ag   9. Added stkId in ssdOs
             ---      bsr 10. Changed *Pool* to *Bkt* in NsMemCfg.
             ---      kr  11. Moved NT specific typedefs from ssi.x to ns_gen.x
             ---      kr  12. Introduced new typedefs to implement ISR/DPRs
             ---      sn  13. Modifications to C++ compile
             ns001.12 bsr  1. Fixed a C++ compile error
/main/3      ---      rp   1. Addition of Multicore support
*********************************************************************91*/
