/********************************************************************16**

                         (c) COPYRIGHT 2006 by 
                         Continuous Computing Corporation.
                         All rights reserved.

     This software is confidential and proprietary to Continuous Computing 
     Corporation (CCPU).  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written Software License 
     Agreement between CCPU and its licensee.

     CCPU warrants that for a period, as provided by the written
     Software License Agreement between CCPU and its licensee, this
     software will perform substantially to CCPU specifications as
     published at the time of shipment, exclusive of any updates or 
     upgrades, and the media used for delivery of this software will be 
     free from defects in materials and workmanship.  CCPU also warrants 
     that has the corporate authority to enter into and perform under the   
     Software License Agreement and it is the copyright owner of the software 
     as originally delivered to its licensee.

     CCPU MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE, SERVICE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL CCPU BE LIABLE FOR ANY INDIRECT, SPECIAL,
     CONSEQUENTIAL DAMAGES, OR PUNITIVE DAMAGES IN CONNECTION WITH OR ARISING
     OUT OF THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the use set
     forth in the written Software License Agreement between CCPU and
     its Licensee. Among other things, the use of this software
     may be limited to a particular type of Designated Equipment, as 
     defined in such Software License Agreement.
     Before any installation, use or transfer of this software, please
     consult the written Software License Agreement or contact CCPU at
     the location set forth below in order to confirm that you are
     engaging in a permissible use of the software.

                    Continuous Computing Corporation
                    9380, Carroll Park Drive
                    San Diego, CA-92121, USA

                    Tel: +1 (858) 882 8800
                    Fax: +1 (858) 777 3388

                    Email: support@trillium.com
                    Web: http://www.ccpu.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     Windows NT System Services
  
     Type:     Include file
  
     Desc:     Initialization and miscellaneous functions
 
     File:     ns_gen.h

     Sid:      ns_gen.h@@/main/3 - Mon Nov 17 15:53:19 2008
  
     Prg:      ag
  
*********************************************************************21*/



#ifndef __NSGENH__
#define __NSGENH__

#if 0 /* XXX this makes no sense and break code build on win32 XXX */
/* undeclare something windows defined */
#ifdef IN
#undef IN
#endif
#endif

/* default SS processor Id */
#define SS_PROC_ID             0

/* memory pools information */
#ifndef SS_MULTICORE_SUPPORT
#define SS_MAX_REGS            2         /* maximun no of regions in SS */
#define SS_MAX_POOLS_PER_REG   8         /* max pools per regions in SS */
#else
#define SS_MAX_REGS            SS_MAX_STSKS         /* maximun no of regions in SS */
#define SS_MAX_POOLS_PER_REG   5         /* max pools per regions in SS */
#endif

#define NS_CONTIGUOUS_MEM      1         /* Contiguous memory */
#define NS_NON_CONTIGUOUS_MEM  2         /* Non-contiguous memory */

/* ns002.12: addition */
#define SMemCpy(d, s, c) memcpy(d,s,c)
#define SMemSet(s, c, n) memset(s,c,n)

/* Specific lock types */
#define SS_RGNTBL_LOCK         SS_LOCK_MUTEX

/* ns003.12 addition */
#define SS_RTRENTRY_LOCK         SS_LOCK_MUTEX
#define SS_MAX_RTRTSKS           255

/* worker thread priorities */
#define NS_CON_THRD_PRIOR      20
#define NS_INT_THRD_PRIOR      15

/* Index of various events in waitArray */

#ifdef SS_SINGLE_THREADED
#ifdef SS_DRVR_SUPPORT
#define NS_INTR_EVNT_IDX       0
#define NS_MSD_EVNT_IDX        1
/* ns010.102 - Modification for CONRD support */
#if (defined(CONAVL) && ! defined(CONRD))
#define NS_CON_EVNT_IDX        2
#define NS_TMR_EVNT_IDX        3
#else  /* CONAVL */
#define NS_TMR_EVNT_IDX        2
#endif /* CONAVL */
#else  /* SS_DRVR_SUPPORT */
#define NS_MSD_EVNT_IDX        0
/* ns010.102 - Modification for CONRD support */
#if (defined(CONAVL) && ! defined(CONRD))
#define NS_CON_EVNT_IDX        1
#define NS_TMR_EVNT_IDX        2
#else  /* CONAVL */
#define NS_TMR_EVNT_IDX        1
#endif /* CONAVL */
#endif /* SS_DRVR_SUPPORT */
#else /* for multi-threaded */
#ifdef SS_DRVR_SUPPORT
#define NS_INTR_EVNT_IDX       0
#define NS_TMR_EVNT_IDX        1
#else  /* SS_DRVR_SUPPORT */
#define NS_TMR_EVNT_IDX        0
#endif /* SS_DRVR_SUPPORT */
#endif /* SS_SINGLE_THREADED */


#define NSPBUFSIZE            512       /* print buffer size */

#define NS_BASE_YEAR          1900      /* base year for SS */
#define NS_SYS_TICK           100       /* system tick value */

/* CMM initialization  parameters */
#define NS_DFLT_MEM_QUNT_SIZE 64

#define NS_MM_LOCK            SS_LOCK_MUTEX  /* CMM lock type */

#ifdef NK
/* device specific */
#define  NS_MAX_DEV_NAME_LEN   256  /* device name length */

/* Registry reading options */
#define NS_REG_READ_FILENAME   1
#define NS_REG_READ_MEM_CONFIG 2

/* values for random number generator */
#define NPILES                 121     /* number of piles */
#define IM1                    151     /* modulo 1 */
#define IM2                    137     /* modulo 2 */
#define IA1                    111     /* multiplier 1 */
#define IA2                    113     /* multiplier 2 */
#define IC1                    11      /* difference 1 */
#define IC2                    13      /* difference 2 */

/* values for bus types */
#define NS_INT_TYPE_PCIBUS     1       /* PCI Bus */
#define NS_INT_TYPE_ISABUS     2       /* ISA Bus */
#define NS_INT_TYPE_EISABUS    3       /* EISA Bus */

/* defines for interrupt modes */
#define NS_INTR_LATCHED        1       /* latched interrupt mode */
#define NS_INTR_LEVEL          2       /* level sensitive mode */

#endif /* NK */

/* macros for conditional parameter declarations */

/* Management interface macros */
#ifdef NS_ENB_MGMT
#define NS_MGMT(a)             a
#else
#define NS_MGMT(a)      
#endif /* NS_ENB_MGMT */

#ifdef NU
#define NU_PARAM(a)            a;
#else
#define NU_PARAM(a)    
#endif /* NU */

#ifdef NK
#define NK_PARAM(a)            a;
#else
#define NK_PARAM(a)    
#endif /* NK */

#ifdef SS_SINGLE_THREADED
#define STHRD_PARAM(a)         a;
#define MTHRD_PARAM(a)    
#else
#define STHRD_PARAM(a)    
#define MTHRD_PARAM(a)         a;
#endif /* SS_SINGLE_THREADED */

#endif /* __NSGENH__ */


/********************************************************************30**
  
         End of file:     ns_gen.h@@/main/3 - Mon Nov 17 15:53:19 2008
  
*********************************************************************31*/
  
  
/********************************************************************40**
  
        Notes: 
  
*********************************************************************41*/
  
/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.1          ---      ag   1. initial release
  
1.2          ---      ag   1. Added defines for worker thread 
                              priorities
             ---      ag   2. Added SS_PROC_ID
             ---      ag   3. Added defines for event indices for 
                              different cases
             ---      bsr  4. Added defines registry reading
             ---      kr   5. Added macros for conditional parameter
                              declarations
             ---      bsr  6. Deleted NS_MAX_REGS and moved bkt defines
                              to ns_space.c
             ---      kr   7. Introduced defines for ISR/DPR routines
1.2+        ns002.12  jn   8. Defined Macros SMemCPy & SMemSet for
                              multiple byte copy
/main/3      ---      rp   1. Addition of Multicore support
*********************************************************************91*/
