/********************************************************************16**

        (c) COPYRIGHT 1989-2000 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:     MAC layer
  
     Type:     C include file
  
     Desc:     Structures, variables and typedefs required by the
               MAC layer service user.
   
     File:     mac.x
  
     Sid:      mac.x@@/main/38_1 - Tue Jan  9 10:44:32 2001
  
     Prg:      na
  
*********************************************************************21*/

#ifndef __MACX__
#define __MACX__

#ifdef __cplusplus
extern "C" {
#endif
 
  
/*
*     The structures and variables declared in this file
*     correspond to structures and variables used by
*     the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000001     Physical Layer - SCC
*     1000034     Physical Layer - ISAC-S
*     1000035     68302 MOS/SCC
*
*/
  
/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000002     Data Link Layer - LAPB
*     1000003     Data Link Layer - LAPD
*     1000005     Data Link Layer - LAPB & LAPD
*     1000010     Application Layer - Asynchronous PAD
*     1000017     Data Link Layer - Basic Frame Relay
*     1000018     Data Link Layer - Extended Frame Relay
*     1000019     Data Link Layer - Logical Link Control 1
*     1000020     Data Link Layer - Logical Link Control 2
*     1000027     SS7 - MTP Level 2
*
*/
  

/* typedefs */

/* bndCfg structure defined in gen.x */

/* buffer structure defined in ss.x */

/* Post and buffer structure defined in ss_ms.x */
 
#ifdef BDVER2
#define DATVER2
#endif

#ifdef APVER2
#define DATVER2
#endif

#ifdef DATVER2
#define SuPost Pst           /* service user */
#else
#define SuPost BndCfg        /* service user */
#endif
 
#ifdef MACVER2
#define SpPost Pst           /* service provider */
#else
#define SpPost BndCfg        /* service provider */
#endif

/* macCfg structure */

typedef struct macCfg                  /* MAC configuration */
{
   Baud baud;                          /* baud */
   PhysIntType physIntType;            /* physical interface type */
   PathConnType pathConnType;          /* path connection type */
#ifndef MACINT3
   struct asyncCfg aCfg;               /* asynchronous configuration */
#endif
   Data padFlcOn;                      /* pad flow control on character */
   Data padFlcOff;                     /* pad flow control off character */
   Data devFlcOn;                      /* device flow control on character */
   Data devFlcOff;                     /* device flow control off character */
} MacCfg;

#ifdef MACINT4

/* typedef for MacConPar to passed in ConReq for MACINT4 */
typedef struct conPar
{
  U8   suermT;        /* threshold for suerm monitoring */
  U8   aermNT;        /* aerm normal threshold */
  U8   aermET;        /* aerm emergency threshold */
  U8   octN;          /* number of octets in octet counting mode */
  U16  framesToDec;   /* frames to rec before decrementing suerm cnt */
}MacConPar;

#else                 /* not MACINT4 */
#ifdef MACINTN

/* typedef for MacConPar to passed in ConReq */
typedef struct conPar
{
  U8   suermT;        /* threshold for suerm monitoring */
  U8   aermNT;        /* aerm normal threshold */
  U8   aermET;        /* aerm emergency threshold */
  U8   octN;          /* number of octets in octet counting mode */
  U16  framesToDec;   /* frames to rec before decrementing suerm cnt */
}MacConPar;

#endif /* MACINTN */
#endif /* MACINT4 */


/* typedefs of primitives */
#ifdef MACINT6
typedef S16 (*MacBndReq) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               SpId        spId,       /* MAC service provider sap id */
               BndCfg      *cfg));     /* source bind configuration */

typedef S16 (*MacUbndReq) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               Reason      reason));   /* reason for unbind */

typedef S16 (*MacConReq) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmQos      *qos,       /* quality of service for this conn */
               AtmTfcDesc *tfcDesc));  /* traffic descriptor for this conn */

typedef S16 (*MacConCfm) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci));      /* virtual channel id for this conn */

typedef S16 (*MacDatReq) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmLp       lp,         /* loss priority for data PDUs */
               AtmUu       uu,         /* mapped to CPCS user-to-user */
               Buffer      *mBuf));    /* data buffer */

typedef S16 (*MacDatInd) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmUu       uu,         /* mapped from CPCS user-to-user */
               AtmCi       ci,         /* congestion indication from rcvd PDU */
               AtmRs       rs,         /* reception status of rcvd PDU */
               Buffer      *mBuf));    /* data buffer */

typedef S16 (*MacDatCfm) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Status      status,     /* status of local tx */
               Buffer      *mBuf));    /* data buffer */

typedef S16 (*MacDiscReq) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

typedef S16 (*MacDiscInd) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

typedef S16 (*MacDiscCfm) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

typedef S16 (*MacRstReq) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               Reason      reason));   /* reason for reset */

typedef S16 (*MacRstInd) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               Reason      reason));   /* reason for reset */

typedef S16 (*MacRstCfm) ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId));     /* MAC service user sap id */
#else
#ifdef MACINTN
/*       Primitive declarations     */
typedef S16 (*MacBndReq) ARGS((Pst *pst, SuId suId, SpId spId));
typedef S16 (*MacBndCfm) ARGS((Pst *pst, SuId suId, U8 status));
typedef S16 (*MacUbndReq) ARGS((Pst *pst, SpId spId, Reason reason));
typedef S16 (*MacConReq) ARGS((Pst *pst, SpId spId, MacConPar *conPar));
typedef S16 (*MacConCfm) ARGS((Pst *pst, SuId suId));
typedef S16 (*MacDatReq) ARGS((Pst *pst, SpId spId, Buffer *mBuf));
typedef S16 (*MacDatCfm) ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status
                               status, U16 cntr));
typedef S16 (*MacDatInd) ARGS((Pst *pst, SuId suId, Buffer *mBuf));
typedef S16 (*MacDiscReq) ARGS((Pst *pst, SpId spId, Reason reason));
typedef S16 (*MacDiscCfm) ARGS((Pst *pst, SuId suId, Status status));
typedef S16 (*MacDiscInd) ARGS((Pst *pst, SuId suId, Reason reason));
typedef S16 (*MacRstReq) ARGS((Pst *pst, SpId spId, Reason reason));
typedef S16 (*MacRstCfm) ARGS((Pst *pst, SuId suId, Status status));
typedef S16 (*MacRstInd) ARGS((Pst *pst, SuId suId, Reason reason));
typedef S16 (*MacStaReq) ARGS((Pst *pst, SpId spId, Reason reason));
typedef S16 (*MacStaCfm) ARGS((Pst *pst, SuId suId, Status status));
typedef S16 (*MacStaInd) ARGS((Pst *pst, SuId suId, Reason reason));
typedef S16 (*MacFlcInd) ARGS((Pst *pst, SuId suId, Status status));

PUBLIC S16 cmPkMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
PUBLIC S16 cmPkMacBndCfm ARGS((Pst *pst, SuId suId, U8 status));
PUBLIC S16 cmPkMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
PUBLIC S16 cmPkMacConReq ARGS((Pst *pst, SpId spId, MacConPar *conPar));
PUBLIC S16 cmPkMacConCfm ARGS((Pst *pst, SuId suId));
PUBLIC S16 cmPkMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
PUBLIC S16 cmPkMacDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status
                               status, U16 cntr));
PUBLIC S16 cmPkMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
PUBLIC S16 cmPkMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
PUBLIC S16 cmPkMacDiscCfm ARGS((Pst *pst, SuId suId, Status status));
PUBLIC S16 cmPkMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
PUBLIC S16 cmPkMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
PUBLIC S16 cmPkMacRstCfm ARGS((Pst *pst, SuId suId, Status status));
PUBLIC S16 cmPkMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
PUBLIC S16 cmPkMacStaReq ARGS((Pst *pst, SpId spId, Reason reason));
PUBLIC S16 cmPkMacStaCfm ARGS((Pst *pst, SuId suId, Status status));
PUBLIC S16 cmPkMacStaInd ARGS((Pst *pst, SuId suId, Reason reason));
PUBLIC S16 cmPkMacFlcInd ARGS((Pst *pst, SuId suId, Status status));

PUBLIC S16 cmUnpkMacBndReq ARGS((MacBndReq bndReq, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacBndCfm ARGS((MacBndCfm bndCfm, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacUbndReq ARGS((MacUbndReq ubndReq, Pst *pst, Buffer
*mBuf));
PUBLIC S16 cmUnpkMacConReq ARGS((MacConReq conReq, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacConCfm ARGS((MacConCfm conCfm, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacDatReq ARGS((MacDatReq datReq, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacDatCfm ARGS((MacDatCfm datCfm, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacDatInd ARGS((MacDatInd datInd, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacDiscReq ARGS((MacDiscReq discReq, Pst *pst, Buffer
*mBuf));
PUBLIC S16 cmUnpkMacDiscCfm ARGS((MacDiscCfm discCfm, Pst *pst, Buffer
*mBuf));
PUBLIC S16 cmUnpkMacDiscInd ARGS((MacDiscInd discInd, Pst *pst, Buffer
*mBuf));
PUBLIC S16 cmUnpkMacRstReq ARGS((MacRstReq rstReq, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacRstCfm ARGS((MacRstCfm rstCfm, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacRstInd ARGS((MacRstInd rstInd, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacStaReq ARGS((MacStaReq staReq, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacStaCfm ARGS((MacStaCfm staCfm, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacStaInd ARGS((MacStaInd staInd, Pst *pst, Buffer *mBuf));
PUBLIC S16 cmUnpkMacFlcInd ARGS((MacFlcInd flcInd, Pst *pst, Buffer *mBuf));

#else /* not MACINT6 or MACINTN */

/* depending on the specific selector in the bndCfg structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */

#ifdef DATVER2
typedef S16 (*MacBndReq) ARGS((Pst *pst, SuId suId, SpId spId));
#else
typedef S16 (*MacBndReq) ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
#endif
typedef S16 (*MacUbndReq) ARGS((SuPost *pst, SpId spId, Reason reason));
typedef S16 (*MacCfgReq) ARGS((SuPost *pst, SpId spId, MacCfg *cfg));

#ifdef MACINT4
typedef S16 (*MacConReq) ARGS((SuPost *pst, SpId spId, MacConPar *conPar ));
typedef S16 (*MacDatCfm) ARGS((SpPost *pst, SuId suId, Status status, U16 cntr));
#else
typedef S16 (*MacConReq) ARGS((SuPost *pst, SpId spId));
typedef S16 (*MacDatCfm) ARGS((SpPost *pst, SuId suId, Buffer *mBuf, Status status));
#endif

typedef S16 (*MacDiscReq) ARGS((SuPost *pst, SpId spId, Reason reason));
typedef S16 (*MacDatChrReq) ARGS((SuPost *pst, SpId spId, Data data));
typedef S16 (*MacFlcReq) ARGS((SuPost *pst, SpId spId, Action action));
typedef S16 (*MacRstReq) ARGS((SuPost *pst, SpId spId, Reason reason));
typedef S16 (*MacConCfm) ARGS((SpPost *pst, SuId suId));
typedef S16 (*MacConInd) ARGS((SpPost *pst, SuId suId));
typedef S16 (*MacDiscCfm) ARGS((SpPost *pst, SuId suId));
typedef S16 (*MacDiscInd) ARGS((SpPost *pst, SuId suId, Reason reason));
typedef S16 (*MacDatChrInd) ARGS((SpPost *pst, SuId suId, Data data, Status status));
typedef S16 (*MacFlcInd) ARGS((SpPost *pst, SuId suId, Action action));
typedef S16 (*MacRstInd) ARGS((SpPost *pst, SuId suId, Reason reason));
#ifdef MACINT1
typedef S16 (*MacDatInd) ARGS((SpPost *pst, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT2
typedef S16 (*MacDatInd) ARGS((SpPost *pst, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#endif
#ifdef MACINT3
typedef S16 (*MacDatInd) ARGS((SpPost *pst, SuId suId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
#endif
#ifdef MACINT5
typedef S16 (*MacDatInd) ARGS((SpPost *pst, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT4
typedef S16 (*MacDatInd) ARGS((SpPost *pst, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT1
typedef S16 (*MacDatReq) ARGS((SuPost *pst, SpId spId, Buffer *mBuf));
#endif
#ifdef MACINT2
typedef S16 (*MacDatReq) ARGS((SuPost *pst, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#endif
#ifdef MACINT3
typedef S16 (*MacDatReq) ARGS((SuPost *pst, SpId spId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
#endif
#ifdef MACINT5
typedef S16 (*MacDatReq) ARGS((SuPost *pst, SpId spId, Buffer *mBuf));
#endif
#ifdef MACINT4
typedef S16 (*MacDatReq) ARGS((SuPost *pst, SpId spId, Buffer *mBuf));
#endif
typedef S16 (*MacStaCfm) ARGS((SpPost *pst, SuId suId, Status status));
#ifdef MACINT4
typedef S16 (*MacStaInd) ARGS((SpPost *pst, SuId suId, Status status, Cntr cntr));
#else
#ifdef MACINT5
typedef S16 (*MacStaInd) ARGS((SpPost *pst, SuId suId, Status status, Cntr cntr));
#else
typedef S16 (*MacStaInd) ARGS((SpPost *pst, SuId suId, Status status));
#endif
#endif
typedef S16 (*MacStaReq) ARGS((SuPost *pst, SpId spId, Status status));

#endif /* MACINTN */
#endif /* MACINT6 */

#ifdef M1

/* dummy mac (MACINT1) upper interface, mac discriminator */

extern  S16 M1UiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 M1UiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M1UiMacConInd ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M1UiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 M1UiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 M1UiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf));
extern  S16 M1UiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf));
extern  S16 M1UiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M1UiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 M1UiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M1UiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 M1UiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M1UiMacStaCfm ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 M1UiMacStaInd ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 M1UiMacStaReq ARGS((BndCfg *bndCfg, SpId spId, Status status));
#endif

#ifdef M2

/* dummy mac (MACINT2) upper interface, mac discriminator */

extern  S16 M2UiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 M2UiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M2UiMacConInd ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M2UiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 M2UiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 M2UiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 M2UiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 M2UiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M2UiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 M2UiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M2UiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 M2UiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M2UiMacStaCfm ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 M2UiMacStaInd ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 M2UiMacStaReq ARGS((BndCfg *bndCfg, SpId spId, Status status));
#endif

#ifdef M3

/* dummy mac (MACINT3) upper interface, mac discriminator */

extern  S16 M3UiMacBndReq ARGS((BndCfg *bndCfg, SpId spId, BndCfg *cfg));
extern  S16 M3UiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M3UiMacConInd ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M3UiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 M3UiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 M3UiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
extern  S16 M3UiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
extern  S16 M3UiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M3UiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 M3UiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M3UiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 M3UiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M3UiMacStaCfm ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 M3UiMacStaInd ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 M3UiMacStaReq ARGS((BndCfg *bndCfg, SpId spId, Status status));
#endif

#ifdef M4

/* dummy mac (MACINT4) upper interface, mac discriminator */

extern  S16 M4UiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 M4UiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M4UiMacConInd ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M4UiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 M4UiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 M4UiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf));
extern  S16 M4UiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf));
extern  S16 M4UiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M4UiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 M4UiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M4UiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 M4UiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M4UiMacStaCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 M4UiMacStaInd ARGS((BndCfg *bndCfg, SuId suId, Status status, Cntr cntr));
extern  S16 M4UiMacStaReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, Status status));
#endif

#ifdef M5

/* dummy mac (MACINT5) upper interface, mac discriminator */

extern  S16 M5UiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 M5UiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M5UiMacConInd ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M5UiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 M5UiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 M5UiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf));
extern  S16 M5UiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf));
extern  S16 M5UiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 M5UiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 M5UiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M5UiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 M5UiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 M5UiMacStaCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 M5UiMacStaInd ARGS((BndCfg *bndCfg, SuId suId, Status status, Cntr cntr));
extern  S16 M5UiMacStaReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, Status status));
#endif

#ifdef M6

/* dummy mac (MACINT6) upper interface, mac discriminator */

extern  S16 M6UiMacBndReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               SpId        spId,       /* MAC service provider sap id */
               BndCfg      *cfg));     /* source bind configuration */

extern  S16 M6UiMacUbndReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               Reason      reason));   /* reason for unbind */

extern  S16 M6UiMacConReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmQos      *qos,       /* quality of service for this conn */
               AtmTfcDesc *tfcDesc));  /* traffic descriptor for this conn */

extern  S16 M6UiMacConCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci));      /* virtual channel id for this conn */

extern  S16 M6UiMacDatReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmLp       lp,         /* loss priority for data PDUs */
               AtmUu       uu,         /* mapped to CPCS user-to-user */
               Buffer      *mBuf));    /* data buffer */

extern  S16 M6UiMacDatInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmUu       uu,         /* mapped from CPCS user-to-user */
               AtmCi       ci,         /* congestion indication from rcvd PDU */
               AtmRs       rs,         /* reception status of rcvd PDU */
               Buffer      *mBuf));    /* data buffer */

extern  S16 M6UiMacDatCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Status      status,     /* status of local tx */
               Buffer      *mBuf));    /* data buffer */

extern  S16 M6UiMacDiscReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 M6UiMacDiscInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 M6UiMacDiscCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 M6UiMacRstReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               Reason      reason));   /* reason for reset */

extern  S16 M6UiMacRstInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* MAC service user sap id */
               Reason      reason));   /* reason for reset */

extern  S16 M6UiMacRstCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId));     /* MAC service user sap id */
#endif
 
#ifdef OD

/* odi upper interface, mac discriminator */

extern  S16 OdUiMacBndReq ARGS((BndCfg *bndCfg, SpId spId, BndCfg *cfg));
extern  S16 OdUiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 OdUiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 OdUiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
extern  S16 OdUiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
#endif

#ifdef SC

#ifdef MACVER2
/* scc, upper interface, mac discriminator */

extern  S16 ScUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
extern  S16 ScUiMacCfgReq ARGS((Pst *pst, SpId spId, MacCfg *cfg));
extern  S16 ScUiMacConCfm ARGS((Pst *pst, SuId suId));
extern  S16 ScUiMacConInd ARGS((Pst *pst, SuId suId));
extern  S16 ScUiMacConReq ARGS((Pst *pst, SpId spId));
extern  S16 ScUiMacDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status status));
#ifdef MACINT2
extern  S16 ScUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 ScUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT2
extern  S16 ScUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 ScUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
#endif
extern  S16 ScUiMacDatChrReq ARGS((Pst *pst, SpId spId,Data data));
extern  S16 ScUiMacDatChrInd ARGS((Pst *pst, SuId suId,Data data, Status status));
extern  S16 ScUiMacDiscCfm ARGS((Pst *pst, SuId suId));
extern  S16 ScUiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 ScUiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 ScUiMacFlcInd ARGS((Pst *pst, SuId suId, Action action));
extern  S16 ScUiMacFlcReq ARGS((Pst *pst, SpId spId, Action action));
extern  S16 ScUiMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 ScUiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 ScUiMacStaInd ARGS((Pst *pst, SuId suId, Status status));
extern  S16 ScUiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
#else
/* scc, upper interface, mac discriminator */

extern  S16 ScUiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 ScUiMacCfgReq ARGS((BndCfg *bndCfg, SpId spId, MacCfg *cfg));
extern  S16 ScUiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 ScUiMacConInd ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 ScUiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 ScUiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
#ifdef MACINT2
extern  S16 ScUiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 ScUiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT2
extern  S16 ScUiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 ScUiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf));
#endif
extern  S16 ScUiMacDatChrReq ARGS((BndCfg *bndCfg, SpId spId,Data data));
extern  S16 ScUiMacDatChrInd ARGS((BndCfg *bndCfg, SuId suId,Data data, Status status));
extern  S16 ScUiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 ScUiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 ScUiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 ScUiMacFlcInd ARGS((BndCfg *bndCfg, SuId suId, Action action));
extern  S16 ScUiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 ScUiMacRstInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 ScUiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 ScUiMacStaInd ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 ScUiMacUbndReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
#endif
#endif

#ifdef IS

#ifdef MACVER2
/* isac-s, upper interface, mac discriminator */

extern  S16 IsUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
extern  S16 IsUiMacConCfm ARGS((Pst *pst, SuId suId));
extern  S16 IsUiMacConInd ARGS((Pst *pst, SuId suId));
#ifdef MACINT4
extern  S16 IsUiMacDatCfm ARGS((Pst *pst, SuId suId, Status status, U16 cntr));
extern  S16 IsUiMacConReq ARGS((Pst *pst, SpId spId, MacConPar *macConPar));
#else /* MACINT4 */
extern  S16 IsUiMacDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status status));
extern  S16 IsUiMacConReq ARGS((Pst *pst, SpId spId));
#endif /* MACINT4 */
#ifdef MACINT2
extern  S16 IsUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else /* MACINT2 */
extern  S16 IsUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
#endif /* MACINT2 */
#ifdef MACINT2
extern  S16 IsUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else /* MACINT2 */
extern  S16 IsUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
#endif /* MACINT2 */
extern  S16 IsUiMacDiscCfm ARGS((Pst *pst, SuId suId));
extern  S16 IsUiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 IsUiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 IsUiMacFlcInd ARGS((Pst *pst, SuId suId, Action action));
extern  S16 IsUiMacFlcReq ARGS((Pst *pst, SpId spId, Action action));
extern  S16 IsUiMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 IsUiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 IsUiMacStaInd ARGS((Pst *pst, SuId suId, Status status));
extern  S16 IsUiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
#else /* MACVER2 */
/* isac-s, upper interface, mac discriminator */

extern  S16 IsUiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 IsUiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 IsUiMacConInd ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 IsUiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 IsUiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
#ifdef MACINT2
extern  S16 IsUiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else /* MACINT2 */
extern  S16 IsUiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf));
#endif /* MACINT2 */
#ifdef MACINT2
extern  S16 IsUiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else /* MACINT2 */
extern  S16 IsUiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf));
#endif /* MACINT2 */
extern  S16 IsUiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 IsUiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 IsUiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 IsUiMacFlcInd ARGS((BndCfg *bndCfg, SuId suId, Action action));
extern  S16 IsUiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 IsUiMacRstInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 IsUiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 IsUiMacStaInd ARGS((BndCfg *bndCfg, SuId suId, Status status));
extern  S16 IsUiMacUbndReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
#endif /* MACVER2 */
#endif

#ifdef SE

/* sec, upper interface, mac discriminator */

#ifdef MACVER2
extern  S16 SeUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 SeUiMacBndReq ARGS((BndCfg *pst, SuId suId, SpId spId, BndCfg *cfg));
#endif
#ifdef MACINT4
extern  S16 SeUiMacConReq ARGS((SpPost *pst, SpId spId, MacConPar *conPar));
extern  S16 SeUiMacDatCfm ARGS((SpPost *pst, SuId suId, Status status, U16 cntr));
#else
extern  S16 SeUiMacConReq ARGS((SpPost *pst, SpId spId));
extern  S16 SeUiMacDatCfm ARGS((SpPost *pst, SuId suId, Buffer *mBuf, Status status));
#endif
extern  S16 SeUiMacCfgReq ARGS((SpPost *pst, SpId spId, MacCfg *cfg));
extern  S16 SeUiMacConCfm ARGS((SpPost *pst, SuId suId));
extern  S16 SeUiMacConInd ARGS((SpPost *pst, SuId suId));
#ifdef MACINT2
extern  S16 SeUiMacDatInd ARGS((SpPost *pst, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 SeUiMacDatInd ARGS((SpPost *pst, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT2
extern  S16 SeUiMacDatReq ARGS((SpPost *pst, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 SeUiMacDatReq ARGS((SpPost *pst, SpId spId, Buffer *mBuf));
#endif
extern  S16 SeUiMacDatChrInd ARGS((SpPost *pst, SuId suId,Data data, Status status));
extern  S16 SeUiMacDatChrReq ARGS((SpPost *pst, SpId spId,Data data));
extern  S16 SeUiMacDiscCfm ARGS((SpPost *pst, SuId suId));
extern  S16 SeUiMacDiscInd ARGS((SpPost *pst, SuId suId, Reason reason));
extern  S16 SeUiMacDiscReq ARGS((SpPost *pst, SpId spId, Reason reason));
extern  S16 SeUiMacFlcInd ARGS((SpPost *pst, SuId suId, Action action));
extern  S16 SeUiMacFlcReq ARGS((SpPost *pst, SpId spId, Action action));
extern  S16 SeUiMacRstInd ARGS((SpPost *pst, SuId suId, Reason reason));
extern  S16 SeUiMacRstReq ARGS((SpPost *pst, SpId spId, Reason reason));
#ifdef MACINT5
extern  S16 SeUiMacStaInd ARGS((SpPost *pst, SuId suId, Status status, Cntr cntr));
extern  S16 SeUiMacStaReq ARGS((SpPost *pst, SpId spId, Status status));
extern  S16 SeUiMacStaCfm ARGS((SpPost *pst, SuId suId, Status status));
#else
#ifdef MACINT4
extern  S16 SeUiMacStaInd ARGS((SpPost *pst, SuId suId, Status status, Cntr cntr));
extern  S16 SeUiMacStaReq ARGS((SpPost *pst, SpId spId, Status status));
extern  S16 SeUiMacStaCfm ARGS((SpPost *pst, SuId suId, Status status));
#else
extern  S16 SeUiMacStaInd ARGS((SpPost *pst, SuId suId, Status status));
extern  S16 SeUiMacStaReq ARGS((SpPost *pst, SpId spId, Status status));
extern  S16 SeUiMacStaCfm ARGS((SpPost *pst, SuId suId, Status status));
#endif
#endif
extern  S16 SeUiMacUbndReq ARGS((SpPost *pst, SpId spId, Reason reason));
#endif

#ifdef QI

/* sec, upper interface, mac discriminator */
 
#ifdef MACVER2
extern  S16 QiUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 QiUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId, BndCfg *cfg));
#endif
#ifdef MACINT4
extern  S16 QiUiMacConReq ARGS((Pst *pst, SpId spId, MacConPar *conPar));
extern  S16 QiUiMacDatCfm ARGS((Pst *pst, SuId suId, Status status, U16 cntr));
#else
extern  S16 QiUiMacConReq ARGS((Pst *pst, SpId spId));
extern  S16 QiUiMacDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status status));
#endif
extern  S16 QiUiMacCfgReq ARGS((Pst *pst, SpId spId, MacCfg *cfg));
extern  S16 QiUiMacConCfm ARGS((Pst *pst, SuId suId));
extern  S16 QiUiMacConInd ARGS((Pst *pst, SuId suId));
#ifdef MACINT2
extern  S16 QiUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 QiUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT2
extern  S16 QiUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 QiUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
#endif
extern  S16 QiUiMacDatChrInd ARGS((Pst *pst, SuId suId,Data data, Status status));
extern  S16 QiUiMacDatChrReq ARGS((Pst *pst, SpId spId,Data data));
extern  S16 QiUiMacDiscCfm ARGS((Pst *pst, SuId suId));
extern  S16 QiUiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 QiUiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 QiUiMacFlcInd ARGS((Pst *pst, SuId suId, Action action));
extern  S16 QiUiMacFlcReq ARGS((Pst *pst, SpId spId, Action action));
extern  S16 QiUiMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 QiUiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
#ifdef MACINT5
extern  S16 QiUiMacStaInd ARGS((Pst *pst, SuId suId, Status status, Cntr cntr));
extern  S16 QiUiMacStaReq ARGS((Pst *pst, SpId spId, Status status));
extern  S16 QiUiMacStaCfm ARGS((Pst *pst, SuId suId, Status status));
#else
#ifdef MACINT4
extern  S16 QiUiMacStaInd ARGS((Pst *pst, SuId suId, Status status, Cntr cntr));
extern  S16 QiUiMacStaReq ARGS((Pst *pst, SpId spId, Status status));
extern  S16 QiUiMacStaCfm ARGS((Pst *pst, SuId suId, Status status));
#else
extern  S16 QiUiMacStaInd ARGS((Pst *pst, SuId suId, Status status));
extern  S16 QiUiMacStaReq ARGS((Pst *pst, SpId spId, Status status));
extern  S16 QiUiMacStaCfm ARGS((Pst *pst, SuId suId, Status status));
#endif
#endif
extern  S16 QiUiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
#endif

#ifdef AT

/* atm, upper interface, mac discriminator */
 
extern  S16 AtUiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 AtUiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 AtUiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 AtUiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 AtUiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AtUiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AtUiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AtUiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AtUiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AtUiMacFlcInd ARGS((BndCfg *bndCfg, SuId suId, Action action));
extern  S16 AtUiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 AtUiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AtUiMacUbndReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
 
/* atm, lower interface, mac discriminator */
extern  S16 AtLiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 AtLiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 AtLiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 AtLiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 AtLiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AtLiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AtLiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AtLiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AtLiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AtLiMacFlcInd ARGS((BndCfg *bndCfg, SuId suId, Action action));
extern  S16 AtLiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 AtLiMacRstInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AtLiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AtLiMacUbndReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
#endif
 

#ifdef AC

/* cpcs, upper interface, mac discriminator */
 
extern  S16 AcUiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 AcUiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 AcUiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 AcUiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 AcUiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AcUiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AcUiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AcUiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AcUiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AcUiMacFlcInd ARGS((BndCfg *bndCfg, SuId suId, Action action));
extern  S16 AcUiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 AcUiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AcUiMacUbndReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
 
/* cpcs, lower interface, mac discriminator */
extern  S16 AcLiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
extern  S16 AcLiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 AcLiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 AcLiMacDatCfm ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, Status status));
extern  S16 AcLiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AcLiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
extern  S16 AcLiMacDiscCfm ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AcLiMacDiscInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AcLiMacDiscReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AcLiMacFlcInd ARGS((BndCfg *bndCfg, SuId suId, Action action));
extern  S16 AcLiMacFlcReq ARGS((BndCfg *bndCfg, SpId spId, Action action));
extern  S16 AcLiMacRstInd ARGS((BndCfg *bndCfg, SuId suId, Reason reason));
extern  S16 AcLiMacRstReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
extern  S16 AcLiMacUbndReq ARGS((BndCfg *bndCfg, SpId spId, Reason reason));
#endif
 
#ifdef LC

/* llc lower interface, mac discriminator */

extern  S16 LcLiMacBndReq ARGS((BndCfg *bndCfg, SpId spId, BndCfg *cfg));
extern  S16 LcLiMacConCfm ARGS((BndCfg *bndCfg, SuId suId));
extern  S16 LcLiMacConReq ARGS((BndCfg *bndCfg, SpId spId));
extern  S16 LcLiMacDatReq ARGS((BndCfg *bndCfg, SpId spId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
extern  S16 LcLiMacDatInd ARGS((BndCfg *bndCfg, SuId suId, Addrs *dstMacAddr, Addrs *srcMacAddr, U16 netType, Buffer *mBuf));
#endif

#ifdef LB

/* lapb, lower interface, mac discriminator */

#ifdef BDVER2
extern  S16 LbLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 LbLiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
#endif
extern  S16 LbLiMacCfgReq ARGS((SuPost *bndCfg, SpId spId, MacCfg *cfg));
extern  S16 LbLiMacConCfm ARGS((SuPost *bndCfg, SuId suId));
extern  S16 LbLiMacConReq ARGS((SuPost *bndCfg, SpId spId));
extern  S16 LbLiMacConInd ARGS((SuPost *bndCfg, SuId suId));
extern  S16 LbLiMacDatCfm ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf, Status status));
#ifdef MACINT2
extern  S16 LbLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 LbLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT2
extern  S16 LbLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 LbLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf));
#endif
extern  S16 LbLiMacDiscCfm ARGS((SuPost *bndCfg, SuId suId));
extern  S16 LbLiMacDiscInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 LbLiMacDiscReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 LbLiMacFlcInd ARGS((SuPost *bndCfg, SuId suId, Action action));
extern  S16 LbLiMacFlcReq ARGS((SuPost *bndCfg, SpId spId, Action action));
extern  S16 LbLiMacRstInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 LbLiMacRstReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 LbLiMacStaInd ARGS((SuPost *bndCfg, SuId suId, Status status));
extern  S16 LbLiMacUbndReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
#endif

#ifdef LD

/* lapd, lower interface, mac discriminator */

#ifdef BDVER2
extern  S16 LdLiMacBndReq  ARGS((Pst *pst, SuId suId, SpId spId));
#else /* BDVER2 */
extern  S16 LdLiMacBndReq  ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
#endif /* BDVER2 */
#ifdef MACINTN
extern  S16 LdLiMacBndCfm  ARGS((Pst *pst, SuId suId, U8 status));
#endif /* MACINTN */
extern  S16 LdLiMacCfgReq  ARGS((SuPost *bndCfg, SpId spId, MacCfg *cfg));
extern  S16 LdLiMacConCfm  ARGS((SuPost *bndCfg, SuId suId));
extern  S16 LdLiMacConInd  ARGS((SuPost *bndCfg, SuId suId));
#ifdef MACINTN
extern  S16 LdLiMacConReq  ARGS((SuPost *bndCfg, SpId spId, MacConPar *macConPar));
#else /* MACINTN */
#ifdef MACINT4
extern  S16 LdLiMacConReq  ARGS((SuPost *bndCfg, SpId spId, MacConPar *macConPar));
#else /* MACINT4 */
extern  S16 LdLiMacConReq  ARGS((SuPost *bndCfg, SpId spId));
#endif /* MACINT4 */
#endif /* MACINTN */
#ifdef MACINTN
extern  S16 LdLiMacDatCfm  ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf, Status status, U16 cntr));
#else /* MACINTN */
#ifdef MACINT4
extern  S16 LdLiMacDatCfm  ARGS((SuPost *bndCfg, SuId suId, Status status, U16 cntr));
#else /* MACINT4 */
extern  S16 LdLiMacDatCfm  ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf, Status status));
#endif /* MACINT4 */
#endif /* MACINTN */
#ifdef MACINT2
extern  S16 LdLiMacDatInd  ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else /* MACINT2 */
extern  S16 LdLiMacDatInd  ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf));
#endif /* MACINT2 */
#ifdef MACINT2
extern  S16 LdLiMacDatReq  ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else /* MACINT2 */
extern  S16 LdLiMacDatReq  ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf));
#endif /* MACINT2 */
#ifdef MACINTN
extern  S16 LdLiMacDiscCfm ARGS((SuPost *bndCfg, SuId suId, Status status));
#else /* MACINTN */
extern  S16 LdLiMacDiscCfm ARGS((SuPost *bndCfg, SuId suId));
#endif /* MACINTN */
extern  S16 LdLiMacDiscInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 LdLiMacDiscReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
#ifdef MACINTN
extern  S16 LdLiMacFlcInd  ARGS((SuPost *bndCfg, SuId suId, Status status));
#else /* MACINTN */
extern  S16 LdLiMacFlcInd  ARGS((SuPost *bndCfg, SuId suId, Action action));
#endif /* MACINTN */
extern  S16 LdLiMacFlcReq  ARGS((SuPost *bndCfg, SpId spId, Action action));
extern  S16 LdLiMacRstInd  ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 LdLiMacRstReq  ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 LdLiMacStaInd  ARGS((SuPost *bndCfg, SuId suId, Status status));
extern  S16 LdLiMacStaCfm  ARGS((SuPost *bndCfg, SuId suId, Status status));
extern  S16 LdLiMacUbndReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
#endif

#ifdef UM

extern  S16 UmLiMacBndReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* UME sap id */
               SpId        spId,       /* MAC service provider sap id */
               BndCfg      *cfg));     /* source bind configuration */

extern  S16 UmLiMacUbndReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               Reason      reason));   /* reason for unbind */

extern  S16 UmLiMacConReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmQos      *qos,       /* quality of service for this conn */
               AtmTfcDesc *tfcDesc));  /* traffic descriptor for this conn */

extern  S16 UmLiMacConCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* UME sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci));      /* virtual channel id for this conn */

extern  S16 UmLiMacDatReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmLp       lp,         /* loss priority for data PDUs */
               AtmUu       uu,         /* mapped to CPCS user-to-user */
               Buffer      *mBuf));    /* data buffer */

extern  S16 UmLiMacDatInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* UME sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmUu       uu,         /* mapped from CPCS user-to-user */
               AtmCi       ci,         /* congestion indication from rcvd PDU */
               AtmRs       rs,         /* reception status of rcvd PDU */
               Buffer      *mBuf));    /* data buffer */

extern  S16 UmLiMacDatCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* UME sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Status      status,     /* status of local tx */
               Buffer      *mBuf));    /* data buffer */

extern  S16 UmLiMacDiscReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 UmLiMacDiscInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* UME sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 UmLiMacDiscCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* UME sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 UmLiMacRstReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               Reason      reason));   /* reason for reset */

extern  S16 UmLiMacRstInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* UME sap id */
               Reason      reason));   /* reason for reset */

extern  S16 UmLiMacRstCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId));     /* UME sap id */
#endif

#ifdef AS

extern  S16 AsLiMacBndReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* Q.SAAL sap id */
               SpId        spId,       /* MAC service provider sap id */
               BndCfg      *cfg));     /* source bind configuration */

extern  S16 AsLiMacUbndReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               Reason      reason));   /* reason for unbind */

extern  S16 AsLiMacConReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmQos      *qos,       /* quality of service for this conn */
               AtmTfcDesc *tfcDesc));  /* traffic descriptor for this conn */

extern  S16 AsLiMacConCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* Q.SAAL sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci));      /* virtual channel id for this conn */

extern  S16 AsLiMacDatReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmLp       lp,         /* loss priority for data PDUs */
               AtmUu       uu,         /* mapped to CPCS user-to-user */
               Buffer      *mBuf));    /* data buffer */

extern  S16 AsLiMacDatInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* Q.SAAL sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               AtmUu       uu,         /* mapped from CPCS user-to-user */
               AtmCi       ci,         /* congestion indication from rcvd PDU */
               AtmRs       rs,         /* reception status of rcvd PDU */
               Buffer      *mBuf));    /* data buffer */

extern  S16 AsLiMacDatCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* Q.SAAL sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Status      status,     /* status of local tx */
               Buffer      *mBuf));    /* data buffer */

extern  S16 AsLiMacDiscReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 AsLiMacDiscInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* Q.SAAL sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 AsLiMacDiscCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* Q.SAAL sap id */
               AtmVpi      vpi,        /* virtual path id for this conn */
               AtmVci      vci,        /* virtual channel id for this conn */
               Reason      reason));   /* reason for disconnect */

extern  S16 AsLiMacRstReq ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SpId        spId,       /* MAC service provider sap id */
               Reason      reason));   /* reason for reset */

extern  S16 AsLiMacRstInd ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId,       /* Q.SAAL sap id */
               Reason      reason));   /* reason for reset */

extern  S16 AsLiMacRstCfm ARGS((
               BndCfg      *bndCfg,    /* destination bind configuration */
               SuId        suId));     /* Q.SAAL sap id */
#endif
 
#ifdef BD

/* lapb and lapd, lower interface, mac discriminator */

#ifdef BDVER2
extern  S16 BdLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 BdLiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId,
        BndCfg *cfg));
#endif
extern  S16 BdLiMacUbndReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 BdLiMacConReq ARGS((SuPost *bndCfg, SpId spId));
extern  S16 BdLiMacDiscReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 BdLiMacRstReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 BdLiMacCfgReq ARGS((SuPost *bndCfg, SpId spId, MacCfg *cfg));
#ifdef MACINT2
extern  S16 BdLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf,
        SrvClass *srvClass));
#else
extern  S16 BdLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf));
#endif
extern  S16 BdLiMacFlcReq ARGS((SuPost *bndCfg, SpId spId, Action action));
extern  S16 BdLiMacConInd ARGS((SuPost *bndCfg, SuId suId));
extern  S16 BdLiMacDiscInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 BdLiMacDiscCfm ARGS((SuPost *bndCfg, SuId suId));
#ifdef MACINT2
extern  S16 BdLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf,
        SrvClass *srvClass));
#else
extern  S16 BdLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf));
#endif
extern  S16 BdLiMacDatCfm ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf,
        Status status));
extern  S16 BdLiMacConCfm ARGS((SuPost *bndCfg, SuId suId));
extern  S16 BdLiMacRstInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 BdLiMacFlcInd ARGS((SuPost *bndCfg, SuId suId, Action action));
extern  S16 BdLiMacStaInd ARGS((SuPost *bndCfg, SuId suId, Status status));
#endif

#ifdef BR

/* basic frame relay, lower interface, mac discriminator */

#ifdef BDVER2
extern  S16 BrLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 BrLiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId,
        BndCfg *cfg));
#endif
extern  S16 BrLiMacUbndReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 BrLiMacConReq ARGS((SuPost *bndCfg, SpId spId));
extern  S16 BrLiMacDiscReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 BrLiMacRstReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 BrLiMacCfgReq ARGS((SuPost *bndCfg, SpId spId, MacCfg *cfg));
#ifdef MACINT2
extern  S16 BrLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf,
        SrvClass *srvClass));
#else
extern  S16 BrLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf));
#endif
extern  S16 BrLiMacFlcReq ARGS((SuPost *bndCfg, SpId spId, Action action));
extern  S16 BrLiMacConInd ARGS((SuPost *bndCfg, SuId suId));
extern  S16 BrLiMacDiscInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 BrLiMacDiscCfm ARGS((SuPost *bndCfg, SuId suId));
#ifdef MACINT2
extern  S16 BrLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf,
        SrvClass *srvClass));
#else
extern  S16 BrLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf));
#endif
extern  S16 BrLiMacDatCfm ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf,
        Status status));
extern  S16 BrLiMacConCfm ARGS((SuPost *bndCfg, SuId suId));
extern  S16 BrLiMacRstInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 BrLiMacFlcInd ARGS((SuPost *bndCfg, SuId suId, Action action));
extern  S16 BrLiMacStaInd ARGS((SuPost *bndCfg, SuId suId, Status status));
#endif

#ifdef ER

/* extended frame relay, lower interface, mac discriminator */

#ifdef BDVER2
extern  S16 ErLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 ErLiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
#endif
extern  S16 ErLiMacCfgReq ARGS((SuPost *bndCfg, SpId spId, MacCfg *cfg));
extern  S16 ErLiMacConCfm ARGS((SuPost *bndCfg, SuId suId));
extern  S16 ErLiMacConInd ARGS((SuPost *bndCfg, SuId suId));
extern  S16 ErLiMacConReq ARGS((SuPost *bndCfg, SpId spId));
extern  S16 ErLiMacDatCfm ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf, Status status));
#ifdef MACINT2
extern  S16 ErLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 ErLiMacDatInd ARGS((SuPost *bndCfg, SuId suId, Buffer *mBuf));
#endif
#ifdef MACINT2
extern  S16 ErLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 ErLiMacDatReq ARGS((SuPost *bndCfg, SpId spId, Buffer *mBuf));
#endif
extern  S16 ErLiMacDiscCfm ARGS((SuPost *bndCfg, SuId suId));
extern  S16 ErLiMacDiscInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 ErLiMacDiscReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 ErLiMacFlcInd ARGS((SuPost *bndCfg, SuId suId, Action action));
extern  S16 ErLiMacFlcReq ARGS((SuPost *bndCfg, SpId spId, Action action));
extern  S16 ErLiMacRstInd ARGS((SuPost *bndCfg, SuId suId, Reason reason));
extern  S16 ErLiMacRstReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
extern  S16 ErLiMacStaInd ARGS((SuPost *bndCfg, SuId suId, Status status));
extern  S16 ErLiMacUbndReq ARGS((SuPost *bndCfg, SpId spId, Reason reason));
#endif

#ifdef SD

/* SS7 mtp level 2, lower interface, mac discriminator */
#ifdef MACINTN
extern S16 SdLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
extern S16 SdLiMacBndCfm ARGS((Pst *pst, SuId suId, U8 status));
extern S16 SdLiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 SdLiMacConReq ARGS((Pst *pst, SpId spId, MacConPar *conPar));
extern S16 SdLiMacConCfm ARGS((Pst *pst, SuId suId));
extern S16 SdLiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
extern S16 SdLiMacDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status
                               status, U16 cntr));
extern S16 SdLiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
extern S16 SdLiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 SdLiMacDiscCfm ARGS((Pst *pst, SuId suId, Status status));
extern S16 SdLiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 SdLiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 SdLiMacRstCfm ARGS((Pst *pst, SuId suId, Status status));
extern S16 SdLiMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 SdLiMacStaReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 SdLiMacStaCfm ARGS((Pst *pst, SuId suId, Status status));
extern S16 SdLiMacStaInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 SdLiMacFlcInd ARGS((SuPost *pst, SpId spId, Status status));
#else /* not MACINTN */

#ifdef DATVER2
extern  S16 SdLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 SdLiMacBndReq ARGS((BndCfg *bndCfg, SuId suId, SpId spId, BndCfg *cfg));
#endif
extern  S16 SdLiMacUbndReq ARGS((SuPost *pst, SpId spId, Reason reason));
extern  S16 SdLiMacConCfm ARGS((SuPost *pst, SuId suId));
extern  S16 SdLiMacConInd ARGS((SuPost *pst, SuId suId));
#ifdef MACINT4
extern  S16 SdLiMacConReq ARGS((SuPost *pst, SpId spId, MacConPar *conPar));
extern  S16 SdLiMacDatCfm ARGS((SuPost *pst, SuId suId, Status status, U16 cntr));
#else
extern  S16 SdLiMacConReq ARGS((SuPost *pst, SpId spId));
extern  S16 SdLiMacDatCfm ARGS((SuPost *pst, SuId suId, Buffer *mBuf, Status status));
#endif
extern  S16 SdLiMacDatInd ARGS((SuPost *pst, SuId suId, Buffer *mBuf));
extern  S16 SdLiMacDatReq ARGS((SuPost *pst, SpId spId, Buffer *mBuf));
extern  S16 SdLiMacDiscInd ARGS((SuPost *pst, SuId suId, Reason reason));
extern  S16 SdLiMacDiscReq ARGS((SuPost *pst, SpId spId, Reason reason));
extern  S16 SdLiMacDiscCfm ARGS((Pst *pst, SuId suId));
extern  S16 SdLiMacFlcInd ARGS((SuPost *pst, SuId suId, Action action));
extern  S16 SdLiMacFlcReq ARGS((SuPost *pst, SpId spId, Action action));
extern  S16 SdLiMacRstInd ARGS((SuPost *pst, SuId suId, Reason reason));
extern  S16 SdLiMacRstReq ARGS((SuPost *pst, SpId spId, Reason reason));
extern  S16 SdLiMacStaCfm ARGS((SuPost *pst, SuId suId, Status status));
extern  S16 SdLiMacStaInd ARGS((SuPost *pst, SuId suId, Status status, Cntr cntr));
extern  S16 SdLiMacStaReq ARGS((SuPost *pst, SpId spId, Status status));
#endif /* MACINTN */
#endif /* SD */


#ifdef AP

/* asynchronous PAD, lower interface, mac discriminator */

extern  S16 ApLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
extern  S16 ApLiMacCfgReq ARGS((Pst *pst, SpId spId, MacCfg *cfg));
extern  S16 ApLiMacConCfm ARGS((Pst *pst, SuId suId));
extern  S16 ApLiMacConInd ARGS((Pst *pst, SuId suId));
extern  S16 ApLiMacConReq ARGS((Pst *pst, SpId spId));
extern  S16 ApLiMacDatChrInd ARGS((Pst *pst, SuId suId,Data data, Status status));
extern  S16 ApLiMacDatChrReq ARGS((Pst *pst, SpId spId,Data data));
extern  S16 ApLiMacDiscCfm ARGS((Pst *pst, SuId suId));
extern  S16 ApLiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 ApLiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 ApLiMacFlcInd ARGS((Pst *pst, SuId suId, Action action));
extern  S16 ApLiMacFlcReq ARGS((Pst *pst, SpId spId, Action action));
extern  S16 ApLiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 ApLiMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 ApLiMacStaInd ARGS((Pst *pst, SuId suId, Status status));
extern  S16 ApLiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
#endif

#ifdef AF
#ifdef AF_NI
extern S16 AfUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
extern S16 AfUiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 AfUiMacConReq ARGS((Pst *pst, SpId spId));
extern S16 AfUiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 AfUiMacDatChrReq ARGS((Pst *pst, SpId spId, Data data));
extern S16 AfUiMacFlcReq ARGS((Pst *pst, SpId spId, Action action));
extern S16 AfUiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 AfUiMacConCfm ARGS((Pst *pst, SuId suId));
extern S16 AfUiMacConInd ARGS((Pst *pst, SuId suId));
extern S16 AfUiMacDiscCfm ARGS((Pst *pst, SuId suId));
extern S16 AfUiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 AfUiMacDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status status));
extern S16 AfUiMacDatChrInd ARGS((Pst *pst, SuId suId, Data data, Status status));
extern S16 AfUiMacFlcInd ARGS((Pst *pst, SuId suId, Action action));
extern S16 AfUiMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 AfUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
extern S16 AfUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
#endif /* AF_NI */
#endif /* AF */
 
#ifdef FR

extern S16 FrLiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
extern S16 FrLiMacUbndReq ARGS((SuPost *pst, SpId spId, Reason reason));
extern S16 FrLiMacCfgReq ARGS((SuPost *pst, SpId spId, MacCfg *cfg));
extern S16 FrLiMacDiscReq ARGS((SuPost *pst, SpId spId, Reason reason));
extern S16 FrLiMacDatChrReq ARGS((SuPost *pst, SpId spId, Data data));
extern  S16 FrLiMacDatReq ARGS((SuPost *pst, SpId spId, Buffer *mBuf));
extern S16 FrLiMacFlcReq ARGS((SuPost *pst, SpId spId, Action action));
extern S16 FrLiMacRstReq ARGS((SuPost *pst, SpId spId, Reason reason));
extern S16 FrLiMacConCfm ARGS((SpPost *pst, SuId suId));
#ifdef MACINTN
extern S16 FrLiMacDiscCfm ARGS((SpPost *pst, SuId suId, Status status));
extern S16 FrLiMacDatCfm ARGS((SpPost *pst, SuId suId, Buffer *mBuf, Status status, U16 cntr));
extern S16 FrLiMacConReq ARGS((SuPost *pst, SpId spId, MacConPar *conPar));
#else /* MACINTN */
extern S16 FrLiMacConInd ARGS((SpPost *pst, SuId suId));
extern S16 FrLiMacDiscCfm ARGS((SpPost *pst, SuId suId));
extern S16 FrLiMacDatCfm ARGS((SpPost *pst, SuId suId, Buffer *mBuf, Status status));
extern S16 FrLiMacConReq ARGS((SuPost *pst, SpId spId));
#endif /* MACINTN */
extern S16 FrLiMacDiscInd ARGS((SpPost *pst, SuId suId, Reason reason));
extern S16 FrLiMacDatChrInd ARGS((SpPost *pst, SuId suId, Data data, Status status));
extern S16 FrLiMacFlcInd ARGS((SpPost *pst, SuId suId, Action action));
extern S16 FrLiMacRstInd ARGS((SpPost *pst, SuId suId, Reason reason));
extern S16 FrLiMacDatInd ARGS((SpPost *pst, SuId suId, Buffer *mBuf));

#endif /* FR */

#ifdef MC

/* MSOC, upper interface, mac discriminator */

#ifdef MACVER2
extern  S16 McUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
extern  S16 McUiMacBndReq ARGS((BndCfg *pst, SuId suId, SpId spId, BndCfg
*cfg));
#endif
#ifdef MACINT4
extern  S16 McUiMacConReq ARGS((SpPost *pst, SpId spId, MacConPar *conPar));
extern  S16 McUiMacDatCfm ARGS((SpPost *pst, SuId suId, Status status, U16
cntr));
#else
extern  S16 McUiMacConReq ARGS((SpPost *pst, SpId spId));
extern  S16 McUiMacDatCfm ARGS((SpPost *pst, SuId suId, Buffer *mBuf, Status
status));
#endif
extern  S16 McUiMacConCfm ARGS((SpPost *pst, SuId suId));
extern  S16 McUiMacConInd ARGS((SpPost *pst, SuId suId));
extern  S16 McUiMacDatInd ARGS((SpPost *pst, SuId suId, Buffer *mBuf));
extern  S16 McUiMacDatReq ARGS((SpPost *pst, SpId spId, Buffer *mBuf));
extern  S16 McUiMacDiscInd ARGS((SpPost *pst, SuId suId, Reason reason));
extern  S16 McUiMacDiscReq ARGS((SpPost *pst, SpId spId, Reason reason));
extern  S16 McUiMacFlcInd ARGS((SpPost *pst, SuId suId, Action action));
extern  S16 McUiMacFlcReq ARGS((SpPost *pst, SpId spId, Action action));
extern  S16 McUiMacRstInd ARGS((SpPost *pst, SuId suId, Reason reason));
extern  S16 McUiMacRstReq ARGS((SpPost *pst, SpId spId, Reason reason));
extern  S16 McUiMacUbndReq ARGS((SpPost *pst, SpId spId, Reason reason));
extern  S16 McUiMacStaReq ARGS((SpPost *pst, SpId spId, Status status));
extern  S16 McUiMacStaCfm ARGS((SpPost *pst, SuId suId, Status status));

#ifdef MACINT5
extern  S16 McUiMacStaInd ARGS((SpPost *pst, SuId suId, Status status, Cntr
cntr));
#else
#ifdef MACINT4
extern  S16 McUiMacStaInd ARGS((SpPost *pst, SuId suId, Status status, Cntr
cntr));
#else
extern  S16 McUiMacStaInd ARGS((SpPost *pst, SuId suId, Status status));
#endif
#endif

#endif  /* MC */


#ifdef BCUIMAC

/* tightly coupled, backward compatibility */

extern  S16 MAConCfm ARGS((SuId suId));
extern  S16 MAConInd ARGS((SuId suId));
extern  S16 MADatCfm ARGS((SuId suId, Buffer *mBuf, Status status));
#ifdef MACINT2
extern  S16 MADatInd ARGS((SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 MADatInd ARGS((SuId suId, Buffer *mBuf));
#endif
extern  S16 MADatChrInd ARGS((SuId suId,Data data, Status status));
extern  S16 MADiscInd ARGS((SuId suId, Reason reason));
extern  S16 MAFlcInd ARGS((SuId suId, Action action));
extern  S16 MARstInd ARGS((SuId suId, Reason reason));
extern  S16 MAStaInd ARGS((SuId suId, Status status));
#endif

#ifdef BCLIMAC
extern  S16 MABndReq ARGS((SuId suId, LnkNmb lnkNmb,BndCfg *cfg));
extern  S16 MACfgReq ARGS((SuId suId, MacCfg *cfg));
extern  S16 MAConReq ARGS((SuId suId));
#ifdef MACINT2
extern  S16 MADatReq ARGS((SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 MADatReq ARGS((SuId suId, Buffer *mBuf));
#endif
extern  S16 MADatChrReq ARGS((SuId suId,Data data));
extern  S16 MADiscReq ARGS((SuId suId, Reason reason));
extern  S16 MAFlcReq ARGS((SuId suId, Action action));
extern  S16 MARstReq ARGS((SuId suId, Reason reason));
extern  S16 MAStaReq ARGS((SuId suId, Status status));
extern  S16 MAUbndReq ARGS((SuId suId, Reason reason));
#endif

#ifdef BCDALIMAC
extern  S16 MABndReq ARGS((SuId suId, LnkNmb lnkNmb,BndCfg *cfg));
extern  S16 MACfgReq ARGS((SuId suId, MacCfg *cfg));
extern  S16 MAConReq ARGS((SuId suId));
#ifdef MACINT2
extern  S16 MADatReq ARGS((SuId suId, Buffer *mBuf, SrvClass *srvClass));
#else
extern  S16 MADatReq ARGS((SuId suId, Buffer *mBuf));
#endif
extern  S16 MADatChrReq ARGS((SuId suId,Data data));
extern  S16 MADiscReq ARGS((SuId suId, Reason reason));
extern  S16 MAFlcReq ARGS((SuId suId, Action action));
extern  S16 MARstReq ARGS((SuId suId, Reason reason));
extern  S16 MAStaReq ARGS((SuId suId, Status status));
extern  S16 MAUbndReq ARGS((SuId suId, Reason reason));
#endif

#ifdef EV
/* envelope function, lower interface, mac discriminator */

extern  S16 EvLiMacBndReq  ARGS((Pst *pst, SuId suId, SpId spId));
extern  S16 EvLiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 EvLiMacConReq  ARGS((Pst *pst, SpId spId));
extern  S16 EvLiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 EvLiMacConCfm  ARGS((Pst *pst, SuId suId));
extern  S16 EvLiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 EvLiMacDiscCfm ARGS((Pst *pst, SuId suId));
extern  S16 EvLiMacDatReq  ARGS((Pst *pst, SpId spId, Buffer *mBuf));
extern  S16 EvLiMacDatCfm  ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status status));
extern  S16 EvLiMacDatInd  ARGS((Pst *pst, SuId suId, Buffer *mBuf));
extern  S16 EvLiMacFlcInd ARGS((Pst *pst, SuId suId, Action action));
extern  S16 EvLiMacRstInd ARGS((Pst *pst, SuId suId, Action action));
#endif

#ifdef VM
/* V5-mac layer, upper interface, mac discriminator */

extern  S16 VmUiMacBndReq  ARGS((Pst *pst, SuId suId, SpId spId));
extern  S16 VmUiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 VmUiMacConReq  ARGS((Pst *pst, SpId spId));
extern  S16 VmUiMacConCfm  ARGS((Pst *pst, SuId suId));
extern  S16 VmUiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern  S16 VmUiMacDatReq  ARGS((Pst *pst, SpId spId, Buffer *mBuf));
extern  S16 VmUiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 VmUiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
extern  S16 VmUiMacDatCfm  ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status status));
extern  S16 VmUiMacDatInd  ARGS((Pst *pst, SuId suId, Buffer *mBuf));
extern  S16 VmUiMacDiscCfm ARGS((Pst *pst, SpId spId));
#endif

#ifdef VO
/* MPC8260 driver, upper interface, mac discriminator */
extern S16 VoUiMacBndReq ARGS((Pst *pst, SuId suId, SpId spId));
extern S16 VoUiMacBndCfm ARGS((Pst *pst, SuId suId, U8 status));
extern S16 VoUiMacUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 VoUiMacConReq ARGS((Pst *pst, SpId spId, MacConPar *conPar));
extern S16 VoUiMacConCfm ARGS((Pst *pst, SuId suId));
extern S16 VoUiMacDatReq ARGS((Pst *pst, SpId spId, Buffer *mBuf));
extern S16 VoUiMacDatCfm ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status
                               status, U16 cntr));
extern S16 VoUiMacDatInd ARGS((Pst *pst, SuId suId, Buffer *mBuf));
extern S16 VoUiMacDiscReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 VoUiMacDiscCfm ARGS((Pst *pst, SuId suId, Status status));
extern S16 VoUiMacDiscInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 VoUiMacRstReq ARGS((Pst *pst, SpId spId, Reason reason));
extern S16 VoUiMacRstCfm ARGS((Pst *pst, SuId suId, Status status));
extern S16 VoUiMacRstInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 VoUiMacStaReq ARGS((Pst *pst, SpId spId, Status status));
extern S16 VoUiMacStaCfm ARGS((Pst *pst, SuId suId, Status status));
extern S16 VoUiMacStaInd ARGS((Pst *pst, SuId suId, Reason reason));
extern S16 VoUiMacFlcInd ARGS((Pst *pst, SuId suId, Status status));
#endif /* VO */

#undef SuPost
#undef SpPost

#ifdef __cplusplus
}
#endif
#endif /* __MACX__ */

  
/********************************************************************30**
  
         End of file:     mac.x@@/main/38_1 - Tue Jan  9 10:44:32 2001
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  
  version    initials                   description
-----------  ---------  ------------------------------------------------
1.1.0.0         jrl     1. initial release.

1.2.0.0         jrl     1. miscellaneous changes.

1.3.0.0         jrl     1. text changes.

1.4.0.0         gp      1. text changes
 (21-MAY-91)            2. remove MSCDOS, MSCUNIX and not MSCDOS or MSCUNIX
                           prototypes and replace with single set of
                           prototypes using argument manipulation macro
                           for ansi or non ansi support to improve
                           portability

1.5             gp      1. added support of MACINT2 (service class added 
 (19-SEP-91)               to MADatReq and MADatInd primitives)
                jrl     2. trillium development system checkpoint (dvs)
                           at version: 1.4.0.0

2.1             jrl     1. add typedefs and function prototypes for new
                           interface

2.2             mma     1. add typedefs for MTP level 2

2.3             gp      1. replaced BCLIMAC with BCDALIMAC (backward
                           compatibility, da layer, lower interface, MAC
                           interface

2.4             lc      1. added ApLiMac prototypes
                nkk     2. add typedefs and function prototypes for llc
                kgi     3. add typedefs and function prototypes for se
                lc      4. add MacCfgReq typedef
                lc      5. add BCLIMAC prototypes

2.5             jl      1. add ApLiMacConCfm prototype

2.6             nkk     1. change in "typedef struct macCfg" 
                           from:
                                   struct asyncCfg aCfg;
                           to:
                                #ifndef ARP
                                   struct asyncCfg aCfg;
                                #endif
                           so that tcl2ptli.c does not need lm_pt.x.
                mc      2. add primitive for MacDiscCfm
                jrl     3. text changes

*********************************************************************71*/

/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
2.7          ---  jrl   1. text changes

2.8          ---  jrl   1. add DiscCfm primitives

2.9          ---  mma   1. change Status to MtpStatus in SdLiMacStaInd

2.10         ---  mma   1. add ifdef SD around StaInd

2.11         ---  lc    1. changed the name of MTP level 2 lower interface
                           from Smt to Mac

2.12         ---  nkk   1. add StaInd primitive
                           add StaReq primitive
                           add StaCfm primitive for SS7 microcode

2.13         ---  nkk   1. add MACINT4 qualifier for StaReq and
                           StaCfm.
             ---  nkk   2. change ARP to MACINT3 (lan interface).
             ---  nkk   3. rename UDat to Dat for MACINT3.
             ---  nkk   4. rename MaUiMac to OdUiMac for ODI.
             ---  nkk   5. add MACINT5 (StaInd counter field for SS7).
             ---  nkk   6. eliminate MtpStatus from StaInd.

2.14         ---  nkk   1. add LnkNmb to MACINT3 BndReq.
             ---  nkk   2. add prototypes for q.saal, atm and cpcs.
             ---  nkk   3. add reason to MACINT6 DiscCfm.
             ---  nkk   4. add MACINT6 DatReq and DatInd (identical to 
                           MACINT2).
             ---  nkk   5. add M6 support.

2.15         ---  nkk   1. deleted ^L characters in M6 and AS sections.

2.16         ---  mma   1. fixed MACINT4 and MACINT5 for SE section

2.17         ---  nkk   1. deleted ^L characters in AT and AC sections.

2.18         ---  nkk   1. added UME support.

2.19         ---  nkk   1. changed to support suId/spId mapping.

2.20         ---  mc    1. support new interfaces.

2.21         ---  rg    1. renamed AtmCellRate to AtmTfcDesc.
             ---  mc    2. renamed L2NEWINT to DATVER2 and L1NEWINT to 
                           MACVER2.

2.22         ---  mc    1. if define BDVER2, turn on DATVER2.
             ---  mc    2. support new interface for BD, LD, LB, BR, ER.
 
2.23         ---  rma   1. added support for QI interface

2.24         ---  mc    1. support new interface for AP.
             ---  mc    2. add MACVER2 to SE.

2.25         ---  ks    1. added prototype for SdLiMacUbndReq

2.26         ---  ks    1. added prototype for SdLiMacRstReq
             ---  ks    2. change copyright header

2.27         ---  sg    1. Added a new section for FR
2.28         ---  ada   1. Added FrLiMacDatReq for FR

2.29         ---  ada   1. Added FrLiMacDatReq for FR
 
2.30         ---  sg    1. Added a new section for AF

2.31         ---  ash   1. MACINT7 used to define new ConReq so that 
                           few error monitoring threshold parameters 
                           can be passed to driver , useful for the 
                           communication processors which support on 
                           chip error rate monitoring .
                        2. Existing MACINT4 completely removed 
                        3. ConCfm structure changed under MACINT7 for 
                           SD/QI/SE
                        4. MACINT7 renamed as MACINT4

2.32         ---  mc    1. added EV and VM to support V5 over the mac 
                           interface.

*********************************************************************81*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- -----------------------------------------------
2.33         ---      manb 1. included apporpiate prototypes for AF layer.
2.34         ---      krp  1. added EvLiMacDiscCfm prototype.
                           2. added EvLiMacRstInd and EvLiMacFlcInd
                              prototypes  
2.35         ---      sr   1. c++ prototypes added
             /main/38                 ash  1. #ifdef MC block added for MSOC
                      mrw   2. Added MACINTN pack/unpack declarations
/main/38_1     ---      mr   1. primiitve prototypes modified in "ifdef LD"
                              section to work with MACINTN, MACINT4.
*********************************************************************91*/

