/********************************************************************16**

        (c) COPYRIGHT 1989-2000 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


/********************************************************************20**
  
     Name:     mac layer
  
     Type:     C source file
  
     Desc:     Defines required by the MAC layer service user.
   
     File:     mac.h
  
     Sid:      mac.h@@/main/21 - Wed Oct 26 16:24:54 2005
  
     Prg:      na
  
*********************************************************************21*/

#ifndef __MAC_H__
#define __MAC_H__

  
/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000001     Physical Layer - SCC
*     1000034     Physical Layer - ISAC-S
*
*/
  
/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000002     Data Link Layer - LAPB
*     1000003     Data Link Layer - LAPD
*     1000005     Data Link Layer - LAPB & LAPD
*     1000010     Application Layer - Asynchronous PAD
*     1000017     Data Link Layer - Basic Frame Relay
*     1000018     Data Link Layer - Extended Frame Relay
*
*/


/* defines */

/* reason for MAUbndReq */

#define M_UBNDREQ      1     /* Requested */

/* reason for MADiscReq and MADiscInd */

#define M_DISCTMR      0     /* Timer Expired */
#define M_DEACTREQ     0     /* Deactivate Request */
#define M_DISCREQ      1     /* Disconnect Request */
#define M_DISCINT      2     /* Interface Signals Failed */
#define MAC_DISC_SM        3     /* stack management initiated disconnection */
#define MAC_DISC_LOCAL     4     /* locally initiated disconnection */
#define MAC_DISC_REMOTE    5     /* remotely initiated disconnection */
#define M_DISC_NOCD      6     /* No Carrier */
#define M_DISC_NOCTS     7     /* No Clear to Send */
#define M_DISC_LIDL      8     /* line idle changed */
#define M_DISC_REMNAME   9     /* remote host name not ok  */
#define M_DISC_SOCK      10    /* open socket failed  */

/* reason for MARstReq and MARstInd */

#define M_RSTREQ       1     /* Requested */

/* status for MADatCfm */

#define M_TXOK        0     /* Data buffer transmitted */
#define M_NOTTXRST    1     /* Data buffer not transmitted, reset */
#define M_NOTTXUNDR   2     /* Data buffer not transmitted, underrun */
#define M_NOTTXCTS    3     /* Data buffer not transmitted, cts lost */
#define M_NOTTXDISC   4     /* Data buffer not transmitted, disconnect */
#define M_NOTTXNOMEM  5     /* Data buffer not transmitted, no memory */

/* reception status (srvClass->s.cpcs.rs) for MacDatInd */

#define M_RXOK        0     /* Data buffer received without corruption */

/* status for MADatChrInd */

#define M_CHROK        0     /* Character Ok */
#define M_PARERR       1     /* Parity Error */
#define M_OVERRUN      2     /* Overrun */

/* action for MAFlcReq and MAFlcInd */

#define M_STARTFLC     0     /* Start Flow Control */
#define M_ENDFLC       1     /* End Flow Control */

/* status for MAStaReq and MAStaCfm */
#define M_NOSTAT       0     /* no status */
#define M_RETRANS      1     /* retransmit message */
#define M_RESET_FISU   2     /* reset fisu sequence number */
#define M_RESET_LSSU   3     /* reset lssu sequence number list */
#define M_AERM_NORM    4     /* start AERM for normal proving */
#define M_AERM_EMER    5     /* start AERM for emergency proving */
#define M_AERM_STOP    6     /* stop AERM */
#define M_SUERM_START  7     /* start SUERM monitroing */
#define M_SUERM_STOP   8     /* stop SUERM monitoring */
#define MAC_FLOW_REQ   9     /* flow control status request */

/* status for MAStaCfm and MAFlcInd */
#define MAC_FLOW_ON    20    /* flow control status confirm ON */

#define MAC_FLOW_OFF   21    /* flow control status confirm OFF */

#ifdef SD_HSL
#define M_EIM_THR      9     /* EIM threshold reached */
#define M_EIM_START    10     /* start EIM monitroing */
#define M_EIM_STOP     11    /* stop EIM  monitoring */
#endif 

/* status for MAStaInd */
/* #define M_NOSTAT    0      no status */
#define M_OCT_MODE     1     /* in octet counting mode */
#define M_RX_ABORT     2     /* received abort in mac */
#define M_RX_BAD_CRC   3     /* received bad crc in mac */
#define M_RX_GOOD_SU   4     /* received good signal unit in mac */
#define M_CTS_LOST     5     /* cts lost */
#define M_SUERM_THR    6     /* SUERM threshold reached */
#define M_AERM_THR     7     /* AERM threshold reached */
#define M_NSU_ERR_STS  8     /* Number of signal units in error statistic */

/* MAC SAP mode field codes */
#define MAC_DATCFM         1  /* every DatReq is confirmed with DatCfm */
#define MAC_CNTRDATCFM     2  /* one DatCfm per n messages or after timeout */
#define MAC_NODATCFM       3  /* no DatCfm under any circumstances */

/* LSSU status field codes */
#define SD_O_IND         0x00    /* indicator "O" */
#define SD_N_IND         0x01    /* indicator "N" */
#define SD_E_IND         0x02    /* indicator "E" */
#define SD_OS_IND        0x03    /* indicator "OS" */
#define SD_PO_IND        0x04    /* indicator "PO" */
#define SD_B_IND         0x05    /* indicator "B" */

/* offsets into message - assume flag is stripped out by MAC */
#define SD_BSN_OFF 0      /* offset to byte containing BSN */
#define SD_FSN_OFF 1      /* offset to byte containing FSN */
#define SD_LI_OFF  2      /* offset to byte containing Length indicator */
#define SD_SIO_OFF 3      /* offset to signal information octet */
#define SD_SIF_OFF 4      /* offset to signal information field */
#define SD_SF1_OFF 3      /* offset to status field byte 1 */
#define SD_SF2_OFF 4      /* offset to status field byte 2 */

/* Masking for Status field of LSSU */

#define SD_STAT_MASK     0x07    /* only use low 3 bits of status field */

/* event code for task to task header */
 
#define EVTMACBNDREQ       0x04             /* Bind request */

#ifdef MACINTN
#define EVTMACBNDCFM       0x05             /* Bind confirm */
#endif /* MACINTN */

#define EVTMACUBNDREQ      0x08             /* Unbind request */
  
#define EVTMACCONREQ       0x0C             /* Connect request */
#define EVTMACCONCFM       0x0D             /* Connect confirm */
#define EVTMACCONIND       0x0E             /* Connect indication */
  
#define EVTMACDISCREQ      0x10             /* Disconnect request */
#define EVTMACDISCCFM      0x11             /* Disconnect confirm */
#define EVTMACDISCIND      0x12             /* Disconnect indication */
 
#define EVTMACDATREQ       0x14             /* Data request */
#define EVTMACDATCFM       0x15             /* Data confirm */
#define EVTMACDATIND       0x16             /* Data indication */
  
#define EVTMACDATCHRREQ    0x20             /* Data character request */
#define EVTMACDATCHRIND    0x22             /* Data character indication */

#define EVTMACFLCREQ       0x28             /* Flow control request */
#define EVTMACFLCIND       0x2A             /* Flow control indication */
                     
#define EVTMACRSTREQ       0x2C             /* Reset request */
#define EVTMACRSTCFM       0x2D             /* Reset confirm */
#define EVTMACRSTIND       0x2E             /* Reset indication */

#define EVTMACCFGXXREQ     0x30             /* Configuration request */
#define EVTMACCFGXXCFM     0x31             /* Configuration confirm */

#define EVTMACCNTRLXXREQ   0x40             /* Configuration request */
#define EVTMACCNTRLXXCFM   0x41             /* Configuration confirm */

#define EVTMACSTAREQ       0x78             /* Status request */
#define EVTMACSTACFM       0x79             /* Status confirm */
#define EVTMACSTAIND       0x7A             /* Status indication */

/* error codes */

#define  EMACBASE     0               /* reserved */
#define  EMACXXX      (EMACBASE)      /* reserved */

#endif

  
/********************************************************************30**
  
         End of file:     mac.h@@/main/21 - Wed Oct 26 16:24:54 2005
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  
  version    initials                   description
-----------  ---------  ------------------------------------------------
1.1.0.0         jrl     1. initial release.

1.2.0.0         jrl     1. miscellaneous changes.  

1.3.0.0         jrl     1. text changes

1.4             jrl     1. trillium development system checkpoint (dvs)
                           at version: 1.3.0.0

1.5             jrl     1. text changes

1.6             mma     1. added M_OCT_MODE for MAStaInd for MTP 2

*********************************************************************71*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
1.7          ---      jrl  1. text changes


1.8          ---      jrl  1. text changes

1.9          ---      nkk  1. added LSSU status field constants, msg offsets,
                              and masks (moved from sd.h, share with 68302).
             ---      nkk  2. added M_NOTTXCTS data confirm status code.
             ---      nkk  3. added M_STARTFLC, M_ENDFLC codes.
             ---      nkk  4. added M_NOSTAT, M_RETRANS, M_RESET_FISU, 
                              M_RESET_LSSU, M_RX_ABORT, and M_RX_BAD_CRC codes 
                              for SS7 microcode.

1.10         ---      mma  1. added M_NOTTXNOMEM for DatCfm 
             ---      mma  2. added M_SUERM_THR, M_AERM_THR, M_NSU_ERR_STS 
                              for StaInd
             ---      mma  3. added M_AERM_NORM, M_AERM_EMER, M_AERM_STOP 
                              for StaReq/Cfm

1.11         ---      nkk  1. added MAC_DISC_SM, MAC_DISC_LOCAL, 
                              and MAC_DISC_REMOTE for Q.SAAL support.

1.12         ---      nkk  1. added M_RXOK for DatInd (cpcs reception status).

1.13         ---      mc   1. define event codes for sdt interdace.

1.14         ---      jrl  1. add deactivate request

1.15         ---      jrl  1. change value of M_DEACTREQ from 0 to 1

1.16         ---      jrl  1. change value of M_DEACTREQ from 1 to 0

1.17         ---      mc   1. add event EVTMACDISCCFM.

1.18         ---      mc   1. add event EVTMACDATCHRREQ and EVTMACDATCHRIND.

1.19         ---      kss  1. added  M_DISC_NOCD and  M_DISC_NOCTS for Mac DiscInd 

1.20         ---      ada  1. cosmetic change to remove lint warnings

1.21         ---      ash  1. added M_SUERM_START and M_SUERM_STOP
                           2. added M_DISC_LIDL

/main/20     ---      ash  1. added M_DISC_SOCK and M_DISC_REM_NAME
                      mrw  2. added mode and flow control supp for MACINTN

/main/21     ---      aks  1. addition M_EIM_THR  M_EIM_START  M_EIM_STOP  defines  
*********************************************************************91*/

