/*******************************************************************************
*
* Title: ll1.x
*
* Description:  Layer1 common externals
*
* Written By: David Yat Sin (dyatsin@sangoma.com)
* 				Konrad Hammel (konrad@sangoma.com)
*
* Date: 2010-06-06
*
*******************************************************************************/
#ifndef __LL1_X_
#define __LL1_X_
/******************************************************************************/

/* INCLUDES *******************************************************************/
/******************************************************************************/

/* DEFINES ********************************************************************/
typedef struct l1GenCfg
{
    S16     nmbLnks;
    Status  poolTrLower;          /* lower pool threshold */
    Status  poolTrUpper;          /* upper pool threshold */
    Pst     sm;                      /* stack manager */

} l1GenCfg;

typedef struct l1PSAPCfg
{
    SpId    spId;               /* service provider Id this is for */
    S32     sockfd;			/* file descriptor */
    U8	    type;
} l1PSAPCfg;

typedef struct L1Mngmt
{
    Header hdr;
    CmStatus cfm;

    union
    {

        /*configuration*/
        struct
        {
            union
            {
                l1GenCfg    l1Gen;
                l1PSAPCfg   l1PSAP;
            }s;
        }cfg;

        /*statistics*/
		struct
		{
			U32 rx_packets;
			U32 tx_packets;
			U32 rx_bytes;
			U32 tx_bytes;
			U32 rx_errors;
			U32 tx_errors;
			U32 rx_dropped;
			U32 tx_dropped;
			U32 rx_events;
			U32 rx_events_dropped;
			U32 multicast;
			U32 collisions;
			U32 rx_length_errors;
			U32 rx_over_errors;
			U32 rx_crc_errors;
			U32 rx_hdlc_abort_counter;
			U32 rx_frame_errors;
			U32 rx_fifo_errors;
			U32 rx_missed_errors;
			U32 tx_aborted_errors;
			U32 tx_carrier_errors;
			U32 tx_fifo_errors;
			U32 tx_heartbeat_errors;
			U32 tx_window_errors;
			U32 num_frames_in_tx_queue;
			U32 tx_queue_len;
			U32 num_frames_in_rx_queue;
			U32 rx_queue_len;
			U32 rx_events_in_queue;
			U32 event_queue_len;
		}sts;

        /*solicited status*/

        /*unsolicited status*/
        struct
        {
            CmAlarm alarm;         /* common alarm structure */
            U8 evntParm[8];        /* event parameters */
        } usta;                   /* unsolicited status */

        /*trace*/

        /*control*/
        struct
        {
            U8 action;             /* action */
            U8 subAction;          /* sub action */
	    	U8 sapId;
        } cntrl;

    }t;

} L1Mngmt;
/******************************************************************************/

/* GLOBALS ********************************************************************/
typedef S16 (*Ll1StaInd)        ARGS((Pst *pst,SuId, Reason reason));
typedef S16 (*Ll1TrcInd)        ARGS((Pst *pst,L1Mngmt *trc));
typedef S16 (*Ll1StaCfm)        ARGS((Pst *pst,L1Mngmt *sta));
typedef S16 (*Ll1StsCfm)        ARGS((Pst *pst, Action action,L1Mngmt *sts));
typedef S16 (*Ll1CfgReq)        ARGS((Pst *pst,L1Mngmt *cfg));
typedef S16 (*Ll1StaReq)        ARGS((Pst *pst,L1Mngmt *sta));
typedef S16 (*Ll1StsReq)        ARGS((Pst *pst,Action action,L1Mngmt *sts));
typedef S16 (*Ll1CntrlReq)      ARGS((Pst *pst,L1Mngmt *cntrl));
typedef S16 (*Ll1CfgCfm)        ARGS((Pst *pst,L1Mngmt *cfm));
typedef S16 (*Ll1CntrlCfm)      ARGS((Pst *pst,L1Mngmt *cfm));
/******************************************************************************/

/* FUNCTION PROTOTYPES ********************************************************/
EXTERN  S16 smL1ActvTsk         ARGS((Pst *pst, Buffer *mBuf));
EXTERN  S16 smL1ActvInit        ARGS((Ent ent, Inst inst, Region region, Reason reason));

EXTERN  S16 l1ActvInit          ARGS((Ent entity, Inst inst, Region region, Reason reason));
EXTERN  S16 l1ActvTsk           ARGS((Pst *pst, Buffer *mBuf));

/* upper (MAC) interface functions */
EXTERN  S16 L1UiMacBndReq       ARGS((Pst *pst, SuId suId, SpId spId));
EXTERN  S16 L1UiMacUbndReq      ARGS((Pst *pst, SpId spId, Reason reason));
EXTERN  S16 L1UiMacBndCfm       ARGS((Pst *pst, SuId suId, Status status));

EXTERN  S16 L1UiMacConReq       ARGS((Pst *pst, SpId spId, MacConPar *conPar));
EXTERN  S16 L1UiMacConCfm       ARGS((Pst *pst, SuId suId));
EXTERN  S16 L1UiMacConInd       ARGS((Pst *pst, SuId suId));

EXTERN  S16 L1UiMacDiscReq      ARGS((Pst *pst, SpId spId, Reason reason));
EXTERN  S16 L1UiMacDiscCfm      ARGS((Pst *pst, SuId suId, Status status));
EXTERN  S16 L1UiMacDiscInd      ARGS((Pst *pst, SuId suId, Reason reason));

EXTERN  S16 L1UiMacRstReq       ARGS((Pst *pst, SpId spId, Reason reason));
EXTERN  S16 L1UiMacRstInd       ARGS((Pst *pst, SuId suId, Reason reason));
EXTERN  S16 L1UiMacRstCfm       ARGS((Pst *pst, SpId spId, Status status));

EXTERN  S16 L1UiMacDatReq       ARGS((Pst *pst, SpId spId, Buffer *mBuf));
EXTERN  S16 L1UiMacDatInd       ARGS((Pst *pst, SuId suId, Buffer *mBuf));
EXTERN  S16 L1UiMacDatCfm       ARGS((Pst *pst, SuId suId, Buffer *mBuf, Status status, U16 cntr));

EXTERN  S16 L1UiMacStaReq       ARGS((Pst *pst, SpId spId, Status status));
EXTERN  S16 L1UiMacStaInd       ARGS((Pst *pst, SuId suId, Status status));
EXTERN  S16 L1UiMacStaCfm       ARGS((Pst *pst, SuId suId, Status status));

EXTERN  S16 L1UiMacFlcInd       ARGS((Pst *pst, SuId suId, Action action));

/* Layer Manager functions */
EXTERN  S16 L1MiLl1CfgReq       ARGS((Pst *pst, L1Mngmt *cfg));
EXTERN  S16 L1MiLl1CfgCfm       ARGS((Pst *pst, L1Mngmt *cfm));

EXTERN  S16 L1MiLl1StaReq       ARGS((Pst *pst, L1Mngmt *sta));
EXTERN  S16 L1MiLl1StaInd       ARGS((Pst *pst, SuId suId, Reason reason));
EXTERN  S16 L1MiLl1StaCfm       ARGS((Pst *pst, L1Mngmt *sta));

EXTERN  S16 L1MiLl1StsReq       ARGS((Pst *pst, Action action, L1Mngmt *sts));
EXTERN  S16 L1MiLl1StsCfm       ARGS((Pst *pst, Action action, L1Mngmt *sts));

EXTERN  S16 L1MiLl1TrcInd       ARGS((Pst *pst, L1Mngmt *trc));

EXTERN  S16 L1MiLl1CntrlReq     ARGS((Pst *pst, L1Mngmt *cntrl));
EXTERN  S16 L1MiLl1CntrlCfm     ARGS((Pst *pst, L1Mngmt *cfm));

EXTERN S16 cmPkLl1CfgReq        ARGS((Pst *pst, L1Mngmt *cfg));
EXTERN S16 cmUnpkLl1CfgReq      ARGS((Ll1CfgReq func, Pst *pst, Buffer *mBuf));

EXTERN S16 cmPkLl1CntrlReq        ARGS((Pst *pst, L1Mngmt *cfg));
EXTERN S16 cmUnpkLl1CntrlReq      ARGS((Ll1CntrlReq func, Pst *pst, Buffer *mBuf));

EXTERN  S16 cmPkLl1CfgCfm       ARGS((Pst *pst, L1Mngmt *cfm));
EXTERN  S16 cmUnpkLl1CfgCfm     ARGS((Ll1CfgCfm func, Pst *pst, Buffer *mBuf));

EXTERN  S16 cmPkLl1CntrlCfm       ARGS((Pst *pst, L1Mngmt *cfm));
EXTERN  S16 cmUnpkLl1CntrlCfm     ARGS((Ll1CntrlCfm func, Pst *pst, Buffer *mBuf));

EXTERN  S16 SmMiLl1CfgReq ARGS((Pst *pst, L1Mngmt *cfg));
EXTERN  S16 SmMiLl1CfgCfm ARGS((Pst *pst, L1Mngmt *cfm));

EXTERN  S16 SmMiLl1StaInd ARGS((Pst *pst, SuId suId, Reason reason));

EXTERN  S16 SmMiLl1CntrlReq ARGS((Pst *pst, L1Mngmt *cntrl));
EXTERN  S16 SmMiLl1CntrlCfm ARGS((Pst *pst, L1Mngmt *cfm));

/*EXTERN  S16 SmMiLl1StaCfm ARGS((Pst *pst, L1Mngmt *sta));*/
/*EXTERN  S16 SmMiLl1StsCfm ARGS((Pst *pst, Action action, L1Mngmt *sts));*/
/*EXTERN  S16 SmMiLl1TrcInd ARGS((Pst *pst, L1Mngmt *trc));*/
/*EXTERN  S16 SmMiLl1StaReq ARGS((Pst *pst, L1Mngmt *sta));*/
/*EXTERN  S16 SmMiLl1StsReq ARGS((Pst *pst, Action action, L1Mngmt *sts));*/


/******************************************************************************/

/******************************************************************************/
#endif /* __LL1_X_ */
/******************************************************************************/
