/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:     layer management - portable
  
     Type:     C include file
  
     Desc:     Structures, variables and typedefs required by the
               Layer Management service user.

     File:     lin.x
  
     Sid:      lin.x@@/main/10 - Wed May 23 17:03:50 2001
    
     Prg:      na
 
*********************************************************************21*/
  
#ifndef __LINTX__
#define __LINTX__


  
/*
*     The structures and variables declared in this file
*     correspond to structures and variables used by
*     the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000003     Data Link Layer - LAPD
*     1000005     Data Link Layer - LAPB & LAPD
*     1000009     Network Layer - Q.930/Q.931
*     1000011     Multiprocessor Operating System (MOS)
*     1000023     Network Layer - X.31
*     1000024     Signalling System 7
*     1000029     Signalling System 7 - ISUP
*     1000034     Physical Layer - ISAC-S
*
*/
   
  
/* public variable declarations */

  
/* Q.93x */

/* inGenCfg structure */

typedef struct inGenCfg         /* Q.93x general configuration */
{
   S16 nmbSaps;                 /* number of Network SAPs */
   S16 nmbLnks;                 /* number of Data Link SAPs */
   S16 nmbSigLnks;              /* number of Signalling Links */
   U16 nmbCes;                  /* number of CESs */
   U32 nmbCalRef;               /* number of global Call References */
   U32 nmbBearer;               /* number of bearer channels */
   U16 nmbRouts;                /* maximum number of routing entries */
   U16 nmbProfiles;             /* number of profiles */
   Status poolTrUpper;          /* upper pool threshold */
   S16 timeRes;                 /* time resolution */
   Pst sm;                      /* stack manager */
} InGenCfg; 

/* dLId structure */

typedef struct dLId             /* data link id */
{
   U8 lSap;                     /* logical sap */
   U8 cEs;                      /* connection endpoint suffix */
} DLId;

/* inBearProf structure */

typedef struct bearCfg          /* bearer configuration */
{
   Bool enb;                    /* enable */
   U8 val;                      /* value */
} BearCfg;

typedef struct inBearCfg        /* bearer configuration */
{
   U16 profNum;                 /* profile number */
   BearCfg infoTranCap;         /* information transfer capability */
   BearCfg codeStand0;          /* coding standard */
   BearCfg infoTranRate0;       /* information transfer rate */
   BearCfg tranMode;            /* transfer mode */
#ifndef ITUT88
   BearCfg rateMultiplier;      /* rate multiplier */
#else
   BearCfg establish;           /* establishment */
   BearCfg cfg;                 /* configuration */
   BearCfg chanStruct;          /* structure */
   BearCfg infoTranRate1;       /* information transfer rate */
   BearCfg symmetry;            /* symmetry */
#endif /* ITUT88 */
   BearCfg negot;               /* negotiation */
   BearCfg syncAsync;           /* synchronous/asynchronous */
   BearCfg interRate;           /* intermediate rate */
   BearCfg inOutBandNegot;      /* inband/outband negotiation */
   BearCfg asgnrAsgne;          /* assignor/assignee */
   BearCfg logLnkNegot;         /* logical link identifier negotiation */
   BearCfg mode;                /* mode of operation */
   BearCfg multiFrm;            /* multiple frame establishment support in data
                                   link */
   BearCfg parity;              /* parity information */
   BearCfg nmbDatBits;          /* number of data bits excluding parity bit */
   BearCfg nmbStopBits;         /* number of stop bits */
   BearCfg duplexMode;          /* duplex mode */
   BearCfg usrInfoLyr2Prot0;    /* user information layer 2 protocol */
   BearCfg usrInfoLyr3Prot0;    /* user information layer 3 protocol */
   BearCfg codeStand1;          /* coding standard for hlc */
   BearCfg presMethod;          /* presentation method of protocol profile */
   BearCfg interpret;           /* interpretation */
   BearCfg highLyrCharId;       /* high layer characteristics identification */
} InBearCfg;       

/* inSAPCfg structure */
   
typedef struct inSAPCfg         /* Q.930 Network SAP configuration */
{
#if (IN_LMINT3 || SMIN_LMINT3)
  SuId sapId;
#endif /* (IN_LMINT3 || SMIN_LMINT3) */
   SpId spId;                   /* service provider id */
   Swtch swtch;                 /* switch */
   Bool useSubAdr;              /* call routing on subaddress */
   Bool adrPref;                /* use of prefix for international calls */
   U8 nmbPrefDig;               /* number of digits used for prefix */
   U8 prefix[IN_MAXPREFDIG];    /* address prefix */
   Bool keyPad;                 /* call routing on keyPad */
   Bool wcRout;                 /* Wild Card Routing Flag */
   U8 wcMask[ADRLEN];           /* Wild Card Mask */
   Bool sidIns;                 /* SID insertion Flag */
   Addrs sid;                   /* SID */
   U8 sidTon;                   /* SID Type of Number */
   U8 sidNPlan;                 /* SID Numbering Plan */
   U8 sidPresInd;               /* default presentation indicator */
   TknStrS callId;              /* Default Call Identity */
   U8 minAdrDig;                /* Minimum number of address digits */
   Bool comptChck;              /* Validate compatibility */
   U8 nmbApplProf;              /* Number of application profiles */
   U8 profNmb[IN_MAX_NMB_PROF]; /* Application profiles */
   Selector selector;           /* upper layer selector */
   Priority prior;              /* priority */
   Route route;                 /* route */
   MemoryId mem;                /* memory region and pool id */
} InSAPCfg;

typedef struct inTmrCfg         /* timer configuration */
{
   TmrCfg t301;                 /* t301 timer - alert received */
   TmrCfg t302;                 /* t302 timer - setup ack sent */
   TmrCfg t303;                 /* t303 timer - setup sent */
   TmrCfg t304;                 /* t304 timer - setup ack received or info 
                                   sent */
   TmrCfg t305;                 /* t305 timer - disc w/ prog ind sent or disc 
                                   sent */
   TmrCfg t306;                 /* t306 timer - disc w/o prog ind sent */
   TmrCfg t307;                 /* t307 timer - susp ack sent */
   TmrCfg t308;                 /* t308 timer - rel sent */
   TmrCfg t310;                 /* t310 timer - call proc received */
   TmrCfg t312;                 /* t312 timer - setup sent on broadcast */
   TmrCfg t313;                 /* t313 timer - conn sent */
   TmrCfg t316c;                /* t316 timer - restart sent indiv channel */
   TmrCfg t316;                 /* t316 timer - restart sent interface */
   TmrCfg t318;                 /* t318 timer - resume sent */
   TmrCfg t319;                 /* t319 timer - suspend sent */
   TmrCfg t322;                 /* t322 timer - stat enq sent */
   TmrCfg t332;                 /* t332 timer - service request sent */
   TmrCfg tRst;                 /* timer - disc indic sent while restarting 
                                   interface */
   TmrCfg tAns;                 /* answer timer */
   TmrCfg t396;                 /* t396 timer - t303 expired */
   TmrCfg t397;                 /* t397 timer - info sent on perm signal */
   TmrCfg tProg;                /* tProg timer - Progress recvd */
#ifdef NI2
#ifdef NI2_TREST
   TmrCfg tRest;                /* tRest timer - Restart Timer for NI2 */
#endif /* NI2_TREST */
#endif /* NI2 */
#ifdef DAT2
   TmrCfg tIntTmr;              /* timer - bind confirm */
#endif /* DAT2 */
} InTmrCfg;
 
typedef struct inPhLnkCfg       /* Q.93x Physical data link configuration */
{
#if (IN_LMINT3 || SMIN_LMINT3)
  SuId sapId;
#endif /* (IN_LMINT3 || SMIN_LMINT3) */
   SpId spId;                   /* service provider id */
   Swtch swtch;                 /* switch */
   S16 intType;                 /* interface type - usr or network */
   Bool clrGlr;                 /* clear B chan glare flag */
   S16 intCfg;                  /* point to point or multipoint */
   S16 n201;                    /* N201 */
   U8 nmbRst;                   /* Number Restart  retransmitted */
   Bool tCbCfg;                 /* TSAP Id configured */
   U8 tCbId;                    /* TSAP Id */
   Bool nfasInt;                /* NFAS interface */
   S16 ctldInt[IN_MAX_NMB_INTRFS]; /* controlled interfaces' ids */
   Bool buIntPr;                /* Backup interface present */
   U16 intId;                   /* interface id */
   U16 sigInt;                  /* signalling interface sap id */
   U16 bupInt;                  /* backup interface sap id */
   U8 nmbNfasInt;               /* max number of interfaces */
   U8 numRstInd;                /* number simult disc indic to be sent for 
                                   restarting interface */
   Bool ackOpt;                 /* acknowledge option */
   Bool relOpt;                 /* release option if true release is generatd*/
   U8 facilityHandling;         /* Facility Handling: standard or GFT. */
   Bool statEnqOpt;             /* status enquiry option */
#ifdef ISDN_SRV
   Bool bcas;                   /* B channel availability subscribed */
   U16 maxBSrvCnt;              /* Max nmb of B chan SRV msg retransmission */
   U16 maxDSrvCnt;              /* Max nmb of D chan SRV msg retransmission */
#endif /* ISDN_SRV */
   U8 firstBChanNum;            /* first B channel number 0 or 1 */
   U16 nmbBearChan;             /* number of bearer channels */
   struct
   {              
      S16 profNmb;              /* profile number */
      Bool valid;               /* validate */
      U8 state;                 /* Provisioned/Not Provisioned */
   } bProf[IN_MAXBCHNL];        /* b channel profiles */
   S16 nmbCes;                  /* number of ces per link */
   U8 callRefLen;               /* call reference length */
   Bool useSubAdr;              /* call routing on subaddress */
   Bool adrPref;                /* use of prefix for international calls */
   U8 nmbPrefDig;               /* number of digits used for prefix */
   U8 prefix[IN_MAXPREFDIG];    /* address prefix */
   Bool keyPad;                 /* call routing on keyPad */
   Bool wcRout;                 /* Wild Card Routing Flag */
   U8 wcMask[ADRLEN];           /* Wild Card Mask */
   Bool sidIns;                 /* SID insertion Flag */
   Addrs sid;                   /* SID */
   U8 sidTon;                   /* SID Type of Number */
   U8 sidNPlan;                 /* SID Numbering Plan */
   U8 sidPresInd;               /* default presentation indicator */
   U8 teiAlloc;                 /* TEI Allocation */
   U8 minAdrDig;                /* Minimum number of address digits */
   Bool srvOpt;                 /* service option */
   Bool rstOpt;                 /* restart option */
#ifdef ATT
   Bool mimOpt;                 /* management/maintenance option */
#endif
#ifdef NT
   Bool ringOff;                /* subscription to non ringing terminal */
#endif
   TknStrS callId;              /* Default Call Identity */
   Bool redirSubsc;             /* subscription to call redirection */
   RedirNmb redirAdr;           /* redirect address */
   Bool forwSubsc;              /* programmed forwarding subscription */
   Bool cndSubsc;               /* calling address delivery service 
                                   subscription */
   U8 dChannelNum;              /* Time slot assigned for D-Channel. */
   InTmrCfg tmr;                /* timer configuration */
   Ent dstEnt;                  /* entity */
   Inst dstInst;                /* instance */
   ProcId dstProcId;            /* destination processor id */
   Priority prior;              /* priority */
   Route route;                 /* route */
   Selector selector;           /* lower layer selector */
   MemoryId mem;                /* memory region and pool id */
} InPhLnkCfg;

typedef struct inCBCfg          /* ces configuration */
{
#if (IN_LMINT3 || SMIN_LMINT3)
  SuId sapId;
  Ces ces;
#endif /* (IN_LMINT3 || SMIN_LMINT3) */
   Bool lnkUpDwnInd;            /* link up/down indication to be sent to 
                                   the upper layer */
   TmrCfg tCon;                 /* connect timer */
   TmrCfg tDisc;                /* disconnect timer */
   TmrCfg t314;                 /* t314 timer - segmenting timer */
   TmrCfg t332i;                /* t332 timer - service sent on nfas 
                                   signalling interface */
   TmrCfg tRstAck;              /* for sending restart ack on all interfaces */
#if (ISDN_NI1 || ISDN_NT || ISDN_ATT)
   TmrCfg tSpid;                /* SPID timer */
#endif
   TknStrS spid;                /* SPID */
   U8 usid;                     /* USID */
   U8 tid;                      /* TID */
} InCBCfg;

/* inRoutCfg structure */

typedef struct inRoutCfg        /* Q.93x routing table configuration */
{
   Addrs addr;                  /* route address */
   U16 sapId;                   /* service access point id */
   U8 sapType;                  /* sap type */
   DLId pLink;                  /* physical link  and CES */
} InRoutCfg;

typedef struct acntInfo         /* accounting information */
{
   Ticks calDura;               /* Call Duration */
   Addrs dstAdr;                /* Destination Address */
   Addrs srcAdr;                /* Source Address */
} AcntInfo;     

  
/* Q.93x */

typedef struct inSAPSts         /* Q.93x SAP statistics */
{
   Cntr alertingTx;             /* alerting messages transmitted */
   Cntr callProcTx;             /* call proceeding messages transmitted */
   Cntr connTx;                 /* connect messages transmitted */
   Cntr connAckTx;              /* connect acknowledge messages transmitted */
   Cntr progressTx;             /* progress messages transmitted */
   Cntr setupTx;                /* setup messages transmitted */
   Cntr setupAckTx;             /* setup acknowledge messages transmitted */
   Cntr rsmTx;                  /* resume messages transmitted */
   Cntr rsmAckTx;               /* resume acknowledge messages transmitted */
   Cntr rsmRejTx;               /* resume reject messages transmitted */
   Cntr suspTx;                 /* suspend messages transmitted */
   Cntr suspAckTx;              /* suspend acknowledge messages transmitted */
   Cntr suspRejTx;              /* suspend reject messages transmitted */
   Cntr usrInfoTx;              /* user information messages transmitted */
   Cntr holdTx;                 /* hold messages transmitted */
   Cntr holdAckTx;              /* hold acknowledge messages transmitted */
   Cntr holdRejTx;              /* hold reject messages transmitted */
   Cntr retTx;                  /* retrieve messages transmitted */
   Cntr retAckTx;               /* retrieve acknowledge messages transmitted */
   Cntr retRejTx;               /* retrieve reject messages transmitted */
   Cntr discTx;                 /* disconnect messages transmitted */
   Cntr relTx;                  /* release messages transmitted */
   Cntr relCmpltTx;             /* release complete messages transmitted */
   Cntr rstTx;                  /* restart messages transmitted */
   Cntr rstAckTx;               /* restart acknowledge messages transmitted */
   Cntr segmentTx;              /* segment messages transmitted */
   Cntr congCntrlTx;            /* congestion control messages transmitted */
   Cntr infoTx;                 /* information messages transmitted */
   Cntr notifyTx;               /* notify messages transmitted */
   Cntr statTx;                 /* status messages transmitted */
   Cntr statEnqTx;              /* status enquiry messages transmitted */
   Cntr servTx;                 /* service messages transmitted */
   Cntr servAckTx;              /* service Acknowledge messages transmitted */
   Cntr facilTx;                /* facility messages transmitted */
   Cntr facilAckTx;             /* facility Acknowledge messages transmitted */
   Cntr facilRejTx;             /* facility Reject messages transmitted */
   Cntr regTx;                  /* register messages transmitted */

   Cntr alertingRx;             /* alerting messages received */
   Cntr callProcRx;             /* call proceeding messages received */
   Cntr connRx;                 /* connect messages received */
   Cntr connAckRx;              /* connect acknowledge messages received */
   Cntr progressRx;             /* progress messages received */
   Cntr setupRx;                /* setup messages received */
   Cntr setupAckRx;             /* setup acknowledge messages received */
   Cntr rsmRx;                  /* resume messages received */
   Cntr rsmAckRx;               /* resume acknowledge messages received */
   Cntr rsmRejRx;               /* resume reject messages received */
   Cntr suspRx;                 /* suspend messages received */
   Cntr suspAckRx;              /* suspend acknowledge messages received */
   Cntr suspRejRx;              /* suspend reject messages received */
   Cntr usrInfoRx;              /* user information messages received */
   Cntr holdRx;                 /* hold messages received */
   Cntr holdAckRx;              /* hold acknowledge messages received */
   Cntr holdRejRx;              /* hold reject messages received */
   Cntr retRx;                  /* retrieve messages received */
   Cntr retAckRx;               /* retrieve acknowledge messages received */
   Cntr retRejRx;               /* retrieve reject messages received */
   Cntr discRx;                 /* disconnect messages received */
   Cntr relRx;                  /* release messages received */
   Cntr relCmpltRx;             /* release complete messages received */
   Cntr rstRx;                  /* restart messages received */
   Cntr rstAckRx;               /* restart acknowledge messages received */
   Cntr segmentRx;              /* segment messages received */
   Cntr congCntrlRx;            /* congestion control messages received */
   Cntr infoRx;                 /* information messages received */
   Cntr notifyRx;               /* notify messages received */
   Cntr statRx;                 /* status messages received */
   Cntr statEnqRx;              /* status enquiry messages received */
   Cntr servRx;                 /* service messages received */
   Cntr servAckRx;              /* service Acknowledge messages received */
   Cntr facilRx;                /* facility messages received */
   Cntr facilAckRx;             /* facility Acknowledge messages received */
   Cntr facilRejRx;             /* facility Reject messages received */
   Cntr regRx;                  /* register messages received */

   Cntr cons;                   /* connects */
   Cntr discs;                  /* disconnects */
   U16  aveCalls;               /* average number of open calls */
   Cause lstTxCause;            /* last transmit cause code */
   Dgn lstTxDgn;                /* last transmit diagnostic code */
   Cause lstRxCause;            /* last receive cause code */
   Dgn lstRxDgn;                /* last receive diagnostic code */
} InSAPSts;

  
/* Q.93x */

/* inSAPSta structure */
  
typedef struct inSAPSta         /* Q.93x - data link SAP status */
{
  S16 state;                   /* sap state */
  Bool flc;                    /* flow control state */
} InSAPSta;



/* InBChnSta structure */
  
typedef struct inBChnSta         /* Q.93x - bearer channel status */
{
#if (IN_LMINT3 || SMIN_LMINT3)
  U16 chanNum;
#endif /* (IN_LMINT3 || SMIN_LMINT3) */
  S16 state;                    /* b-channel state */
} InBChnSta;




typedef struct inDChnSta         /* Q.93x - D channel status */
{
#if (IN_LMINT3 || SMIN_LMINT3)
  Ces ces;
#endif /* (IN_LMINT3 || SMIN_LMINT3) */
  S16 state;                    /* data link state */
  S16 sigState;                    /* D-channel state */
} InDChnSta;

  

/***********************************************************************
                    Layer management structure
************************************************************************/
 

typedef struct inCfg
{
  union
  {
    InBearCfg inBear;   /* Q.93x - bearer capability */
    InGenCfg inGen;     /* Q.93x - general */        
    InSAPCfg inTSAP;    /* Q.93x - transport SAP */        
    InPhLnkCfg inDLSAP; /* Q.93x - data link SAP */
    InCBCfg inLCe;      /* Q.93x - data Link connection */        
    InRoutCfg inRout;   /* Q.93x - Routing table Entry */
    
  } s;
} InCfg;


/* statistics */
    
typedef struct inSts
{
  DateTime dt;           /* date and time */
  Duration dura;         /* duration */
#if (IN_LMINT3 || SMIN_LMINT3)
  SuId suId;
#endif
  union
  {    
    InSAPSts inDLSAP;   /* Q.93x - data link SAP */    
  } s;
} InSts;                    /* statistics */
    



/* solicited status */
    
typedef struct inSta
{
  DateTime dt;           /* date and time */
#if (IN_LMINT3 || SMIN_LMINT3)
  SuId sapId;
#endif
  union
  {    
    SystemId sysId;     /* system id */    
    InSAPSta inDLSAP;   /* Q.93x - data link SAP */    
    InBChnSta inBChSta; /* Q.93x -  bearer channel*/    
    InDChnSta inDChSta; /* Q.93x -  bearer channel*/
  } s;
}InSta;                   /* solicited status */
 


/* unsolicited status */

typedef struct inUsta
{
#if (IN_LMINT3 || SMIN_LMINT3)
  CmAlarm alarm;
  SuId suId;
#else
  DateTime dt;           /* date and time */
  U16 evnt;              /* event number */
#endif
  U8 evntParm[8];        /* event parameters */
} InUsta;                /* unsolicited status */



/* trace */
    
typedef struct inTrc
{
  DateTime dt;           /* date and time */
#if (IN_LMINT3 || SMIN_LMINT3)
  SuId suId;             /* service user id */
#endif
  U16 evnt;              /* event */
}InTrc;                  /* trace */

/* run-time control of debug information */

#ifdef DEBUGP
typedef struct inDbgCntrl
{
   U32 dbgMask;
} InDbgCntrl;
#endif /* DEBUGP */

/* control */

typedef struct inCntrl
{
  DateTime dt;           /* date and time */
  U8 action;             /* action */
  U8 subAction;          /* sub action */
#if (IN_LMINT3 || SMIN_LMINT3)
  SuId sapId;
  Ces ces;
  U8 chanNum;
  U8 clrCalls;
#endif /* (IN_LMINT3 || SMIN_LMINT3) */
  S16 trcLen;            /* interface message trace length */
  union
  {
    ProcId dstProcId;
    Route route;
    Priority priority;
#ifdef DEBUGP
    InDbgCntrl inDbg;
#endif /* DEBUGP */
  } par;
}InCntrl;                  /* control */



/* unit data */    
typedef struct inUdat
{
  Buffer *mBuf;          /* message buffer */
} InUdat;                /* unit data */

    
/* accounting */
typedef struct inAcnt    /* ISDN accounting info */
{
  DateTime dt;           /* date and time */
  AcntInfo acntRec;      /* accounting record */
}InAcnt;                 /* accounting */




typedef struct inMngmt
{
  Header hdr;                  /* header */
  
#if (IN_LMINT3 || SMIN_LMINT3)
  CmStatus cfm;
#endif /* (IN_LMINT3 || SMIN_LMINT3) */
  
  union {    
    InCfg cfg;                /* configuration */
    InSts sts;                /* Statistics */
    InSta ssta;               /* Status */
    InUsta usta;              /* Unsolicited Status */
    InCntrl cntrl;            /* Control */
    InTrc trc;                /* Trace */
    InUdat udat;              /* Unit Data */
    InAcnt inAcnt;            /* Accounting */
  }t;
} InMngmt;






/*
 * depending on the specific selector in the post structure,
 * a primitive originated from a service provider can be dispatched to
 * any service user. The assumption is that, even if every primitive has
 * a different name depending in which file it resides, every primitive
 * must have the same function prototype, i.e. the same identical set
 * of arguments. These arguments are defined here 
 */


typedef S16 (*LinStaInd)   ARGS((Pst *pst, InMngmt *sta));
typedef S16 (*LinAcntInd)  ARGS((Pst *pst, InMngmt *acnt));
typedef S16 (*LinTrcInd)   ARGS((Pst *pst, InMngmt *trc, Buffer *mBuf));
typedef S16 (*LinStaCfm)   ARGS((Pst *pst, InMngmt *sta));
typedef S16 (*LinStsCfm)   ARGS((Pst *pst, Action action, InMngmt *sts));
typedef S16 (*LinCfgCfm)   ARGS((Pst *pst, InMngmt *cfg));
typedef S16 (*LinCntrlCfm) ARGS((Pst *pst, InMngmt *cntrl));
typedef S16 (*LinCfgReq)   ARGS((Pst *pst, InMngmt *cfg));
typedef S16 (*LinStaReq)   ARGS((Pst *pst, InMngmt *sta));
typedef S16 (*LinStsReq)   ARGS((Pst *pst, Action action,InMngmt *sts));
typedef S16 (*LinCntrlReq) ARGS((Pst *pst, InMngmt *cntrl));

#ifdef __cplusplus
extern "C" {
#endif /* _cplusplus */

/* activation task for loose coupling */
EXTERN S16 lmActvTsk ARGS((Priority priority, Route route, Ent ent, Inst inst, 
                           Buffer  *mBuf));

 
EXTERN S16 SmMiLinStsCfm     ARGS((Pst *pst, Action action,InMngmt *sts));
EXTERN S16 SmMiLinStaInd     ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 SmMiLinAcntInd    ARGS((Pst *pst, InMngmt *acnt));
EXTERN S16 SmMiLinTrcInd     ARGS((Pst *pst, InMngmt *trc, Buffer *mBuf));
EXTERN S16 SmMiLinStaCfm     ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 SmMiLinCfgReq     ARGS((Pst *pst, InMngmt *cfgCfm));
EXTERN S16 SmMiLinCntrlReq   ARGS((Pst *pst, InMngmt *cntrlCfm));
EXTERN S16 SmMiLinStsReq     ARGS((Pst *pst, Action action,InMngmt *sts));
EXTERN S16 SmMiLinStaReq     ARGS((Pst *pst, InMngmt *sta));

#ifdef SMIN_LMINT3
EXTERN S16 SmMiLinCfgCfm     ARGS((Pst *pst, InMngmt *cfm));
EXTERN S16 SmMiLinCntrlCfm   ARGS((Pst *pst, InMngmt *cfm));
#endif /* SMIN_LMINT3 */


#ifdef IN                          /* ISDN */
EXTERN S16 InMiLinCfgReq     ARGS((Pst *pst, InMngmt *cfg));
EXTERN S16 InMiLinStaReq     ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 InMiLinStsReq     ARGS((Pst *pst, Action action,InMngmt *sts));
EXTERN S16 InMiLinCntrlReq   ARGS((Pst *pst, InMngmt *cntrl));
EXTERN S16 InMiLinStaInd     ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 InMiLinTrcInd     ARGS((Pst *pst, InMngmt *trc, Buffer *mBuf));
EXTERN S16 InMiLinAcntInd    ARGS((Pst *pst, InMngmt *acnt));
EXTERN S16 InMiLinStaCfm     ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 InMiLinStsCfm     ARGS((Pst *pst, Action action, InMngmt *sts));
EXTERN S16 InMiLinCfgCfm     ARGS((Pst *pst, InMngmt *cfm));
EXTERN S16 InMiLinCntrlCfm   ARGS((Pst *pst, InMngmt *cfm));
#endif


#ifdef LCLIN

EXTERN S16 cmPkLinStaInd ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 cmPkLinStaCfm ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 cmPkLinStsCfm ARGS((Pst *pst, Action action, InMngmt *sts));
EXTERN S16 cmPkLinAcntInd ARGS((Pst *pst, InMngmt *acnt));
EXTERN S16 cmPkLinTrcInd ARGS((Pst *pst, InMngmt *trc, Buffer *mBuf));
#if (IN_LMINT3 ||SMIN_LMINT3)
EXTERN S16 cmPkLinCfgCfm ARGS((Pst *pst, InMngmt *cfg));
EXTERN S16 cmPkLinCntrlCfm ARGS((Pst *pst, InMngmt *cntrl));
#endif /* In_LMINT3 */

EXTERN S16 cmPkLinCfgReq   ARGS((Pst *pst, InMngmt *cfg));
EXTERN S16 cmPkLinStaReq   ARGS((Pst *pst, InMngmt *sta));
EXTERN S16 cmPkLinStsReq   ARGS((Pst *pst, Action action, InMngmt *sts));
EXTERN S16 cmPkLinCntrlReq ARGS((Pst *pst, InMngmt *cntrl));

EXTERN S16 cmUnpkLinCntrlReq ARGS((LinCntrlReq linCntrlReq,
                                   Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinStsReq ARGS((LinStsReq linCntrlReq,
                                 Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinStaReq ARGS((LinStaReq linCntrlReq,
                                 Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinCfgReq ARGS((LinCfgReq linCntrlReq,
                                 Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinStaCfm ARGS((LinStaCfm linStaCfm,
                                 Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinStsCfm ARGS((LinStsCfm linStsCfm,
                                 Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinStaInd ARGS((LinStaInd linStaInd,
                                 Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinAcntInd ARGS((LinAcntInd linAcntInd,
                                  Pst *pst, Buffer *mBuf));
#if (SMIN_LMINT3 || IN_LMINT3)
EXTERN S16 cmUnpkLinCfgCfm ARGS((LinCfgCfm linCfgCfm,
                                  Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLinCntrlCfm ARGS((LinCntrlCfm linCntrlCfm,
                                  Pst *pst, Buffer *mBuf));
#endif /* SMIN_LMINT3 */
EXTERN S16 cmUnpkLinTrcInd ARGS((LinTrcInd linTrcInd,
                                  Pst *pst, Buffer *mBuf));

EXTERN S16 cmPkBearCfg ARGS((BearCfg *bear,Buffer *mBuf));
EXTERN S16 cmPkElmtRedirNmb ARGS((RedirNmb *m,Buffer *mBuf));

EXTERN S16 cmUnpkBearCfg ARGS((BearCfg *bear,Buffer *mBuf));
EXTERN S16 cmUnpkElmtRedirNmb ARGS((RedirNmb *m,Buffer *mBuf));

#endif /* LCLIN */

/* stack manager initialization function */
EXTERN S16 smInActvInit ARGS((Ent ent, Inst inst, Region region, 
       Reason reason));

/* stack manager activation function */
EXTERN S16 smInActvTsk ARGS((Pst *pst, Buffer *mBuf));

#ifdef __cplusplus
         }
#endif /* _cplusplus */

#endif
  
  
/********************************************************************30**
  
         End of file:     lin.x@@/main/10 - Wed May 23 17:03:50 2001
    
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---   bn   1. initial release.

3.1          ---   bn   1. text changes.

3.2          ---   bn   1. text changes.

3.3          ---   krp  1. modified ces config structure to include 
                           spid timer for ATT and DMS100B in addition
                           to NI1.

3.4          ---   bn   1. added statistics counters for service and service 
                           Ack messages.

*********************************************************************81*/

/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
3.5          ---      sb   1. Added dChannelNum for D-Channel slot assignment
                              in structure inPhLnkCfg.
3.6          ---      sb   1. Added field facilityHandling in structure 
                              inPhLnkCfg.  This field is used to denote the
                              type of facility handling.

3.7          ---      pk   1. Added tProg timer in inTmrCfg.

3.8          ---      sam  1. Added rateMultiplier in inBearCfg.
             ---      sam  2. Added delayBnd to inPhLnkCfg.
             ---      sb   3. Text changes
             ---      sam  4. Changed nmbBearChan from U8 to U16.

3.9          ---      pk   1. Modified struct inPhLnkCfg to include
                              variable for state.
3.10         ---      pk   2. Added  clrCalls field in the cntrlReq 
                              structure.This field is to be used for 
                              FT/HA architecture.
          in014.310   mm   2. Added tRest in Timer Configuration for
                              NI2 variant.
          in017.310   cy   3. Changed nmbCalRef and nmbBearer to U32 
                              value in InGenCfg.
/main/10     ---      cy   1. Updated for new release.
*********************************************************************91*/
