/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:     layer management - portable
  
     Type:     C include file
  
     Desc:     Defines required by the layer management service user.
  
     File:     lin.h
  
     Sid:      lin.h@@/main/10 - Wed May 23 17:03:44 2001
     
     Prg:      na
  
*********************************************************************21*/
  
#ifndef __LINH__
#define __LINH__

  
/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000009     Network Layer - Q.930/Q.931
*
*/
 
/*
*     this software may be combined with the following TRILLIUM
*     software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000003     Data Link Layer - LAPD
*     1000005     Data Link Layer - LAPB & LAPD
*     1000023     Network Layer - X.31
*     1000029     SS7 - ISUP
*     1000034     Physical Layer - ISAC-S
*
*/
    
  

#include "cm_q930.h"             /* common defines for both int.h and lin.h */

/* Management Report Defines */

#define IN_ENDPT_PINIT     0x1    /* Endpoint initialisation failed */
#define IN_ENDPT_MINIT     0x2    /* Endpoint initialisation Ok */
#define IN_FACREQ_FAILED   55     /* Facility Request Failed.       */

#define IN_CHN_ENABLED     1      /* b channel enabled through cntrl req */
#define IN_CHN_DISABLED    2      /* b channel disabled through cntrl req */

#define IN_CNTRLREQ_FAILED 3         /* Control Request Failed */
#define IN_CFGREQ_FAILED      4      /* Configuration Request Failed */
#define IN_STAREQ_FAILED      5      /* Configuration Request Failed */
#define IN_STSREQ_FAILED      6      /* Configuration Request Failed */


#define IN_DCHNL_OUT_SRV      56      /* Servive Timer Expiry */
#define IN_DISC_CFM_RCVD      57      /* Channel Disconnected */

/* reason for redirection */

#define IN_RR_UNKNOWN     0x00  /* reason unknown */
#define IN_RR_BUSY        0x01  /* call forwarding busy or called dte busy */
#define IN_RR_NOREPLY     0x02  /* call forwarding no reply */
#define IN_RR_CXFR        0x04  /* call transfer dms 250 */
#define IN_RR_CPCKUP      0x05  /* call pickup dms 250 */
#define IN_RR_OUTORD      0x09  /* called dte out of order */
#define IN_RR_CDDTE       0x0a  /* call forwarding by the called dte */
#define IN_RR_CTRSF       0x0d  /* call transfer */
#define IN_RR_PCKUP       0x0e  /* call pickup */
#define IN_RR_SYSTM       0x0f  /* call fowarding unconditional or systematic */

#define IN_MODULO_8         8           /* Modulo 8 */
#define IN_MODULO_128     128           /* Modulo 128 */

#define IN_PASSIVE          0           /* passive: wait for SABM */
#define IN_ACTIVE           1           /* active: send SABM */

#define IN_NON_AUTOMATIC    0           /* non automatic TEI assignment */
#define IN_AUTOMATIC        1           /* automatic TEI assignment */

#define IN_LOW_PRIOR        1           /* low priority */
#define IN_HI_PRIOR         2           /* high priority */

#define IN_TO_USER          0           /* interface to user */
#define IN_TO_NETWORK       1           /* interface to network */


/* defines for MINCfgReq */

#define IN_STATIC            1       /* static allocation of TEIs */
#define IN_DYNAMIC           2       /* dynamic allocation of TEIs */

/* isdn switch defines */

#define SW_TST           0           /* switch - test */
#define SW_CCITT         1           /* switch - ccitt */
#define SW_ATT5EB        2           /* switch - att 5ess BRA */
#define SW_ATT5EP        3           /* switch - att 5ess PRA */
#define SW_ATT4E         4           /* switch - att 4ess */
#define SW_NTDMS100B     5           /* switch - nt dms100 BRA */
#define SW_NTDMS100P     6           /* switch - nt dms100 PRA */
#define SW_VN2           7           /* switch - vn 2 */
#define SW_VN3           7           /* switch - vn 3 */
#define SW_INSNET        8           /* switch - ins - net */
#define SW_TR6MPC        9           /* switch - 1 - tr6mpc  */
#define SW_TR6PBX       10           /* switch - 1 - tr6pbx  */
#define SW_AUSB         11           /* switch - austel basic */
#define SW_AUSP         12           /* switch - austel primary */
#define SW_NI1          13           /* switch - national isdn-1 */
#define SW_ETSI         14           /* switch - etsi */
#define SW_BC303TMC     15           /* switch - bellcorp tr303 tmc */
#define SW_BC303CSC     16           /* switch - bellcorp tr303 csc */
#define SW_NTDMS250     17           /* switch - nt dms250 */
#define SW_NI2          18           /* switch - national isdn-2 */
#define SW_QSIG         19           /* switch - ETSI QSIG */
#define SW_NTMCI        20           /* switch - nt mci */
#define SW_NTNI         21           /* switch - nt ni */

#define IN_INTCFG_PTPT      0           /* interface configuration - point to 
                                        point */
#define IN_INTCFG_MULTI     1           /* interface configuration - multipoint */

#define IN_MAX_NMB_INTRFS  84           /* maximum of interfaces controlled by 
                                        one signalling interface */

#define IN_INT_NOT_CFGD    0xff         /* interface not configured */

#define IN_MAX_NMB_PROF     3           /* maximum of application profiles */

#define IN_MAXBCHNL         255         /* maximum number of B channels */

#define IN_MAXPREFDIG       4           /* maximum number of prefix digit */
#define IN_ANYCHAN          255         /* any B channel */
#define IN_DCHAN            2           /* D channel */
#define IN_BCHAN            3           /* specific B channel */
#define IN_BASICRATE        2           /* basic rate */
#define IN_INTERFACE        5           /* interface */

/* defines for initial state of B Channels */
#define IN_PROV             1           /* provisioned - OOS NE */
#define IN_NOT_PROV         2           /* not provisioned */
#define IN_PROV_AVAIL       3           /* provisioned and available */

#define IN_AVAIL             0          /* available */
#define IN_IN_SERVICE        1          /* in service */
#define IN_OUT_SERVICE_NE    2          /* out of service near end */
#define IN_OUT_SERVICE_FE    3          /* out of service far end */
#define IN_PINS_NE           4          /* pending inservice near end */
#define IN_PINS_FE           5          /* pending inservice far end */
#define IN_MAINT_NE          4          /* maintenance near end */
#define IN_MAINT_FE          5          /* maintenance far end */
#define IN_NOTPROVISIONED    6          /* Not Provisioned */
#ifdef NI2_BCAS
#define IN_NEWPROVISIONED    7          /* OOS Near End Suspend Both */
#define IN_NOVALUE           8          /* pendStat is not used */
#endif /* NI2_BCAS */

#define IN_INT_INV        0xff          /* Invalid Interface */

/* channel type */

#define IN_CHAN_B           0           /* channel - b */
#define IN_CHAN_H0          1           /* channel - h0 */
#define IN_CHAN_H11         2           /* channel - h11 */
#define IN_CHAN_H12         3           /* channel - h12 */
#define IN_CHAN_D           4           /* channel - D for X.31 */

/*      transfer mode    */

#define IN_CIRCUIT          0           /* circuit */
#define IN_PACKET           2           /* packet  */
#define IN_CIRPKT           3           /* circuit and packet */

/*      transfer capability    */

#define IN_SPEECH           1           /* speech */
#define IN_UNDIGIT          2           /* unrestricted digital */
#define IN_RESDIGIT         4           /* restricted digital */
#define IN_AUDIO3           8           /* 3.1 audio */
#define IN_AUDIO7           16          /* 7 audio */
#define IN_VIDEO            32          /* video */
#define IN_ANADIG           33          /* both voice and data */

/* information transfer capability */

#define IN_ITC_SPEECH     0x00  /* speech */
#define IN_ITC_UNRDIG     0x08  /* unrestricted digital information */
#define IN_ITC_RESDIG     0x09  /* restricted digital information */
#define IN_ITC_A31KHZ     0x10  /* 3.1kHz audio */
#define IN_ITC_A7KHZ      0x11  /* 7 kHz audio */
#define IN_ITC_A15KHZ     0x12  /* 15 kHz audio */
#define IN_ITC_VIDEO      0x18  /* video */

/* information transfer mode */

#define IN_TM_CALLIND     0x00  /* Call independent signalling */
#define IN_TM_CIRCUIT     0x00  /* circuit mode */
#define IN_TM_PACKET      0x02  /* packet mode */

/* information transfer rate */

#define IN_ITR_CALLIND    0x00  /* Call independent signalling connection. */
#define IN_ITR_PKT        0x00  /* packet mode */
#define IN_ITR_64KBIT     0x10  /* circuit mode - 64 kbits */
#define IN_ITR_2X64KBIT   0x11  /* circuit mode - 2 X 64 kbits */
#define IN_ITR_384KBIT    0x13  /* circuit mode - 384 kbits */
#define IN_ITR_1472KBIT   0x14  /* circuit mode - 1472 kbits */
#define IN_ITR_1536KBIT   0x15  /* circuit mode - 1536 kbits */
#define IN_ITR_1920KBIT   0x17  /* circuit mode - 1920 kbits */
#define IN_ITR_MULTIRATE  0x18  /* circuit mode - multi rate */

/* establishement */

#define IN_E_DEMAND       0x00  /* demand */
#define IN_E_PERM         0x01  /* permanent */

/* configuration */

#define IN_POINT          0x00  /* point to point */
#define IN_MULTIPOINT     0x01  /* multipoint */

/* structure */

#define IN_S_DEF          0x00  /* default */
#define IN_S_8KHZINTEG    0x01  /* 8 khz integrity */
#define IN_S_SDUINTEG     0x04  /* service data unit integrity */
#define IN_S_UNSTRUCT     0x07  /* unstructured */

/* symmetry */

#define IN_S_BISYM        0x00  /* bidirectional symmetry */

/* negotiation */

#define IN_N_IBNOTPOSS    0x00  /* inband not possible */
#define IN_N_IBPOSS       0x01  /* inband possible */

/* negotiation indicator */

#define IN_N_OBNOTPOSS    0x00  /* outband not possible */
#define IN_N_OBPOSS       0x01  /* outband possible */

/* synchronous/asynchronous */

#define IN_SA_SYNC        0x00  /* synchronous */
#define IN_SA_ASYNC       0x01  /* asynchronous */

/* intermediate rate */

#define IN_IR_NONE        0x00  /* none specified */
#define IN_IR_8KBIT       0x01  /* 8 kbits */
#define IN_IR_16KBIT      0x02  /* 16 kbits */
#define IN_IR_32KBIT      0x03  /* 32 kbits */

/* assignor/assignee */

#define IN_AA_ORGASGNEE   0x00  /* originator is assignee */
#define IN_AA_ORGASGNOR   0x01  /* originator is assignor */

/* number of stop bits */

#define IN_NSB_UNUSED     0x00  /* none specified */
#define IN_NSB_1          0x01  /* 1 stop bit */
#define IN_NSB_15         0x02  /* 1.5 stop bits */
#define IN_NSB_2          0x03  /* 2 stop bits */

/* number of data bits */

#define IN_NDB_UNUSED     0x00  /* none specified */
#define IN_NDB_5          0x01  /* 5 bits */
#define IN_NDB_7          0x02  /* 7 bits */
#define IN_NDB_8          0x03  /* 8 bits */

/* parity information */

#define IN_PARI_ODD       0x00  /* odd */
#define IN_PARI_EVEN      0x02  /* even */
#define IN_PARI_NONE      0x03  /* none */
#define IN_PARI_0         0x04  /* force to 0 */
#define IN_PARI_1         0x05  /* force to 1 */

/* duplex mode */

#define IN_DUPMODE_HALF   0x00  /* half duplex */
#define IN_DUPMODE_FULL   0x01  /* full duplex */

/* modem type */

#define IN_MODEM_V21      0x11  /* V.21 */
#define IN_MODEM_V22      0x12  /* V.21 */
#define IN_MODEM_V22BIS   0x13  /* V.21 */
#define IN_MODEM_V23      0x14  /* V.21 */
#define IN_MODEM_V26      0x15  /* V.21 */
#define IN_MODEM_V26BIS   0x16  /* V.21 */
#define IN_MODEM_V26TER   0x17  /* V.21 */
#define IN_MODEM_V27      0x18  /* V.21 */
#define IN_MODEM_V27BIS   0x19  /* V.21 */
#define IN_MODEM_V27TER   0x1a  /* V.21 */
#define IN_MODEM_V29      0x1b  /* V.21 */
#define IN_MODEM_V32      0x1c  /* V.21 */
#define IN_MODEM_V35      0x1d  /* V.21 */

/* modem types for Australian Telecom */

#define IN_MT_MODEM_UNDEF 0x00  /* undefined */
#define IN_MT_MODEM_V22   0x05  /* V.22      */

/* user information layer 1 */

#define IN_UIL1_CCITTV110 0x01  /* CCITT Standardized Rate Adaptation V.110/X.30. */
#define IN_UIL1_G711ULAW  0x02  /* Reccomendation G.711 u-Law */
#define IN_UIL1_G711ALAW  0x03  /* Recommendation G.711 A-Law */
#define IN_UIL1_G721ADCPM 0x04  /* Recommendation G.721 32 kbit/s ADCPM and */
                             /* Recommendation I.460 */
#define IN_UIL1_G722G725  0x05  /* Recommendation G.722 and G.725 - 7kHz Audio */
#define IN_UIL1_H261      0x06  /* Recommendation H.261 - 384 kbit/s Video */
#define IN_UIL1_NONCCITT  0x07  /* Non-CCITT  standardized Rate adaptation */
#define IN_UIL1_CCITTV120 0x08  /* CCITT Standardized Rate Adaptation V.120 */
#define IN_UIL1_CCITTX31  0x09  /* CCITT Standardized Rate Adaptation X.31 HDLC */

/* user information layer 2 protocol */

#define IN_UIL2_BASIC     0x01  /* basic mode - ISO 1745 */
#define IN_UIL2_Q921      0x02  /* CCITT Recommendation Q.921 */
#define IN_UIL2_X25SLP    0x06  /* CCITT Recommendation X.25, single link */
#define IN_UIL2_X25MLP    0x07  /* CCITT Recommendation X.25, multi link */
#define IN_UIL2_T71       0x08  /* extended LAPB for half duplex, */
                             /* CCITT Recommendation T.71 */
#define IN_UIL2_HDLCARM   0x09  /* HDLC ARM - ISO 4335 */
#define IN_UIL2_HDLCNRM   0x0a  /* HDLC NRM - ISO 4335 */
#define IN_UIL2_HDLCABM   0x0b  /* HDLC ABM - ISO 4335 */
#define IN_UIL2_LANLLC    0x0c  /* LAN LLC - ISO 8802/2 */
#define IN_UIL2_X75SLP    0x0d  /* CCITT Recommendation X.75, single link */
#define IN_UIL2_Q922      0x0e  /* CCITT Recommendation Q.922 */
#define IN_UIL2_Q922C     0x0f  /* Core aspects of CCITT Recommendation Q.922 */
#define IN_UIL2_USRSPEC   0x10  /* CCITT User specified */
#define IN_UIL2_T90       0x11  /* CCITT T.90 */

/* user information layer 3 protocol */

#define IN_UIL3_Q931      0x02  /* CCITT Recommendation Q.931 */
#define IN_UIL3_T90       0x05  /* CCITT T.90 */
#define IN_UIL3_X25PLP    0x06  /* CCITT Recommendation X.25, packet layer */
#define IN_UIL3_ISO8208   0x07  /* ISO 8208 */
#define IN_UIL3_ISO8348   0x08  /* ISO 8348 */
#define IN_UIL3_ISO8473   0x09  /* ISO 8473 */
#define IN_UIL3_T70       0x0a  /* CCITT Recommendation T.70 */
#define IN_UIL3_TR9577    0x0b  /* ISO/IEC TR 9577 */
#define IN_UIL3_USRSPEC   0x10  /* CCITT User specified */

/* mode of operation */

#define IN_MOO_BITTRANS   0x00  /* bit transparent */
#define IN_MOO_PROTSEN    0x01  /* protocol sensitive */

/* multiple frame establishment */

#define IN_MFE_NOTSUP     0x00  /* not supported */
#define IN_MFE_SUP        0x01  /* supported */

/* logical link identifier */

#define IN_LLI_DEF        0x00  /* default */
#define IN_LLI_FULLNEG    0x01  /* full protocol negotiation */

/* inband/outband negotiation */

#define IN_ION_USRINFO    0x00  /* negotiation with user info messages */
#define IN_ION_LL0        0x01  /* negotiation in band using logical link 0 */

/* connection type */

#define IN_CON_PERM       0x01  /* type of B or D channel connection - 
                                permanent */

/* Sn Management Events */

#define EVTLINCFGREQ     0x3c             /* Configuration request */
#define EVTLINSTAREQ     0x40             /* Status request */
#define EVTLINSTACFM     0x41             /* Status confirm */
#define EVTLINSTAIND     0x42             /* Status indication */
#define EVTLINSTSREQ     0x44             /* Statistics request */
#define EVTLINSTSCFM     0x45             /* Statistics confirm */
#define EVTLINTRCIND     0x48             /* Trace indication */
#define EVTLINCNTRLREQ   0x57             /* Control request */
#define EVTLINACNTIND    0x56             /* Accounting indication */
#define EVTLINCFGCFM     0x59             /* Configuration Confirm */
#define EVTLINCNTRLCFM   0x60             /* Configuration Confirm */

#define IN_FACILITY_QSIGGFT 0x01      /* Facility Q.SIG GFT handling */
#define IN_FACILITY_STANDRD 0x02      /* Facility standard handling */

/* Delay Binding */

#define IN_LIN_DELAY_BND        0x01      /* Delay Binding */
#define IN_LIN_NODELAY_BND      0x00      /* No Delay Binding */

/* Error Codes */
#define ELINBASE             0
#define ELINXXX              (ELINBASE + 0)

#define LCM_REASON_CALLS_PRSNT   257 /* Calls Present on Interface */
#define LCM_REASON_INVALID_CHAN  258 
#define LCM_REASON_BKUPINT_OOS   259
#define LCM_REASON_MISC          260

#define LCM_EVENT_DECODE         257
#define LCM_EVENT_THRSHLD        258
#define LCM_EVENT_MAINT_MSG      259
#define LCM_EVENT_UP             260
#define LCM_EVENT_DOWN           261
#define LCM_EVENT_DISC_CFM_RCVD  262
#define LCM_EVENT_INV_EVENT      263
#define LCM_EVENT_ENABLED        265
#define LCM_EVENT_DISABLED       266
#define LCM_EVENT_ENDPT_INIT     267
#define LCM_EVENT_INSERVICE      268
#ifdef NI2_BCAS
#define LCM_EVENT_BCAS           269
#endif /* NI2_BCAS */

#define LCM_CAUSE_INV_DCHAN           257 /* Invalid D Chan */
#define LCM_CAUSE_MEM_NOT_AVAIL       258 /* Memory */
#define LCM_CAUSE_INV_EVENTTYPE       259
#define LCM_CAUSE_INV_CES             260
#define LCM_CAUSE_INV_CES_STATE       261
#define LCM_CAUSE_INV_CES_ENDPT_STATE 262
#define LCM_CAUSE_INV_CES_SIG_STATE   263
#define LCM_CAUSE_INV_PCB             264
#define LCM_CAUSE_INV_PCB_STATE       265
#define LCM_CAUSE_INV_NTC_STATE       266
#define LCM_CAUSE_INV_BKUP            267
#define LCM_CAUSE_ENDPT_INIT_FAIL     268
#define LCM_CAUSE_TERM_INIT_FAIL      269
#define LCM_CAUSE_INV_INTID           270
#define LCM_CAUSE_SRVMSG_RETRY_FAIL   271
#define LCM_CAUSE_INV_TERM_INIT_FAIL  272
#define LCM_CAUSE_INV_SWTCH           273
#define LCM_CAUSE_INV_CALLREF         274
#define LCM_CAUSE_INV_EVENT           275

#define LCM_CAUSE_INCOMP_MSG          276
#define LCM_CAUSE_IGNORE              277

#define LCM_CAUSE_CFGREQ_FAIL         278
#define LCM_CAUSE_CNTRLREQ_FAIL       279
#define LCM_CAUSE_STSREQ_FAIL         280
#define LCM_CAUSE_STAREQ_FAIL         281
#define LCM_CAUSE_BNDENA_FAIL         282
#define LCM_CAUSE_UBNDDIS_DLSAP_FAIL  283
#define LCM_CAUSE_UBNDDIS_TSAP_FAIL   284

#define LCM_CAUSE_DCHAN               285
#define LCM_CAUSE_BCHAN               286
#define LCM_CAUSE_MEM_UNAVAIL         287
#ifdef NI2_BCAS
#define LCM_CAUSE_NOTSUPPORT          288
#define LCM_CAUSE_SRVREQ              289
#define LCM_CAUSE_AUDIT               290
#define LCM_CAUSE_INTERFACE           291
#define LCM_CAUSE_ALLINTERFACE        292
#endif /* NI2_BCAS */

#ifdef NI2_BCAS
#define STAUDIT                       125      /* Call Aduit Procedure */
#define SABAUDIT                      11       /* B-Chan audit */
#define SADS1AUDIT                    12       /* DS1 Audit */
#define SAPRIAUDIT                    13       /* PRI Audit */
#endif /* NI2_BCAS */


/* This part includes the old defines
   that are still used by the Layer
   Managers of some of the customers
   that uses the management interface
   of the Q.930/Q.930 layer. These
   Layer Managers should phase out the
   uses of these old defines in their
   future revisions */
#ifdef LIN_OLD_DEFINES

#define DCHNL_OUT_SRV      IN_DCHNL_OUT_SRV   /* Servive Timer Expiry */
#define DISC_CFM_RCVD      IN_DISC_CFM_RCVD   /* Channel Disconnected */

/* reason for redirection */

#define RR_UNKNOWN         IN_RR_UNKNOWN  /* reason unknown */
#define RR_BUSY            IN_RR_BUSY  /* call forwarding busy or called dte busy */
#define RR_NOREPLY         IN_RR_NOREPLY  /* call forwarding no reply */
#define RR_CXFR            IN_RR_CXFR  /* call transfer dms 250 */
#define RR_CPCKUP          IN_RR_CPCKUP  /* call pickup dms 250 */
#define RR_OUTORD          IN_RR_OUTORD  /* called dte out of order */
#define RR_CDDTE           IN_RR_CDDTE  /* call forwarding by the called dte */
#define RR_CTRSF           IN_RR_CTRSF  /* call transfer */
#define RR_PCKUP           IN_RR_PCKUP  /* call pickup */
#define RR_SYSTM           IN_RR_SYSTM  /* call fowarding unconditional or systematic */

#define MODULO_8           IN_MODULO_8        /* Modulo 8 */
#define MODULO_128         IN_MODULO_128      /* Modulo 128 */

#define PASSIVE            IN_PASSIVE         /* passive: wait for SABM */
#define ACTIVE             IN_ACTIVE          /* active: send SABM */

#define NON_AUTOMATIC      IN_NON_AUTOMATIC   /* non automatic TEI assignment */
#define AUTOMATIC          IN_AUTOMATIC       /* automatic TEI assignment */

#define LOW_PRIOR          IN_LOW_PRIOR       /* low priority */
#define HI_PRIOR           IN_HI_PRIOR        /* high priority */

#define TO_USER            IN_TO_USER         /* interface to user */
#define TO_NETWORK         IN_TO_NETWORK      /* interface to network */


/* defines for MINCfgReq */

#define STATIC             IN_STATIC           /* static allocation of TEIs */
#define DYNAMIC            IN_DYNAMIC          /* dynamic allocation of TEIs */

#define INTCFG_PTPT        IN_INTCFG_PTPT      /* interface configuration - point to 
                                                  point */
#define INTCFG_MULTI       IN_INTCFG_MULTI     /* interface configuration - multipoint */

#define MAX_NMB_INTRFS     IN_MAX_NMB_INTRFS   /* maximum of interfaces controlled by 
                                                  one signalling interface */

#define INT_NOT_CFGD       IN_INT_NOT_CFGD     /* interface not configured */

#define MAX_NMB_PROF       IN_MAX_NMB_PROF     /* maximum of application profiles */

#define MAXBCHNL           IN_MAXBCHNL         /* maximum number of B channels */

#define MAXPREFDIG         IN_MAXPREFDIG       /* maximum number of prefix digit */
#define ANYCHAN            IN_ANYCHAN          /* any B channel */
#define DCHAN              IN_DCHAN            /* D channel */
#define BCHAN              IN_BCHAN            /* specific B channel */
#define BASICRATE          IN_BASICRATE        /* basic rate */
#define INTERFACE          IN_INTERFACE        /* interface */

/* defines for initial state of B Channels */
#define PROV               IN_PROV             /* provisioned - OOS NE */
#define NOT_PROV           IN_NOT_PROV         /* not provisioned */
#define PROV_AVAIL         IN_PROV_AVAIL       /* provisioned and available */
#define AVAIL              IN_AVAIL            /* available */
#define IN_SERVICE         IN_IN_SERVICE       /* in service */
#define OUT_SERVICE_NE     IN_OUT_SERVICE_NE   /* out of service near end */
#define OUT_SERVICE_FE     IN_OUT_SERVICE_FE   /* out of service far end */
#define PINS_NE            IN_PINS_NE          /* pending inservice near end */
#define PINS_FE            IN_PINS_FE          /* pending inservice far end */
#define MAINT_NE           IN_MAINT_NE         /* maintenance near end */
#define MAINT_FE           IN_MAINT_FE         /* maintenance far end */
#define NOTPROVISIONED     IN_NOTPROVISIONED   /* Not Provisioned */
#ifdef NI2_BCAS
#define NEWPROVISIONED     IN_NEWPROVISIONED   /* Out of Service Near End Suspend Both */
#define NOVALUE            IN_NOVALUE          /* pendStat is not used */
#endif /* NI2_BCAS */
#define INT_INV            IN_INT_INV          /* Invalid Interface */

/* channel type */

#define CHAN_B         IN_CHAN_B      /* channel - b */
#define CHAN_H0        IN_CHAN_H0     /* channel - h0 */
#define CHAN_H11       IN_CHAN_H11    /* channel - h11 */
#define CHAN_H12       IN_CHAN_H12    /* channel - h12 */
#define CHAN_D         IN_CHAN_D      /* channel - D for X.31 */

/*      transfer mode    */

#define CIRCUIT        IN_CIRCUIT     /* circuit */
#define PACKET         IN_PACKET      /* packet  */
#define CIRPKT         IN_CIRPKT      /* circuit and packet */

/*      transfer capability    */

#define SPEECH         IN_SPEECH      /* speech */
#define UNDIGIT        IN_UNDIGIT     /* unrestricted digital */
#define RESDIGIT       IN_RESDIGIT    /* restricted digital */
#define AUDIO3         IN_AUDIO3      /* 3.1 audio */
#define AUDIO7         IN_AUDIO7      /* 7 audio */
#define VIDEO          IN_VIDEO       /* video */
#define ANADIG         IN_ANADIG      /* both voice and data */

/* information transfer capability */

#define ITC_SPEECH     IN_ITC_SPEECH  /* speech */
#define ITC_UNRDIG     IN_ITC_UNRDIG  /* unrestricted digital information */
#define ITC_RESDIG     IN_ITC_RESDIG  /* restricted digital information */
#define ITC_A31KHZ     IN_ITC_A31KHZ  /* 3.1kHz audio */
#define ITC_A7KHZ      IN_ITC_A7KHZ   /* 7 kHz audio */
#define ITC_A15KHZ     IN_ITC_A15KHZ  /* 15 kHz audio */
#define ITC_VIDEO      IN_ITC_VIDEO   /* video */

/* information transfer mode */

#define TM_CALLIND     IN_TM_CALLIND  /* Call independent signalling */
#define TM_CIRCUIT     IN_TM_CIRCUIT  /* circuit mode */
#define TM_PACKET      IN_TM_PACKET   /* packet mode */

/* information transfer rate */

#define ITR_CALLIND    IN_ITR_CALLIND    /* Call independent signalling connection. */
#define ITR_PKT        IN_ITR_PKT        /* packet mode */
#define ITR_64KBIT     IN_ITR_64KBIT     /* circuit mode - 64 kbits */
#define ITR_2X64KBIT   IN_ITR_2X64KBIT   /* circuit mode - 2 X 64 kbits */
#define ITR_384KBIT    IN_ITR_384KBIT    /* circuit mode - 384 kbits */
#define ITR_1472KBIT   IN_ITR_1472KBIT   /* circuit mode - 1472 kbits */
#define ITR_1536KBIT   IN_ITR_1536KBIT   /* circuit mode - 1536 kbits */
#define ITR_1920KBIT   IN_ITR_1920KBIT   /* circuit mode - 1920 kbits */
#define ITR_MULTIRATE  IN_ITR_MULTIRATE  /* circuit mode - multi rate */

/* establishement */

#define E_DEMAND       IN_E_DEMAND  /* demand */
#define E_PERM         IN_E_PERM    /* permanent */

/* configuration */

#define POINT          IN_POINT       /* point to point */
#define MULTIPOINT     IN_MULTIPOINT  /* multipoint */

/* symmetry */

#define S_BISYM        IN_S_BISYM  /* bidirectional symmetry */

/* negotiation */

#define N_IBNOTPOSS    IN_N_IBNOTPOSS  /* inband not possible */
#define N_IBPOSS       IN_N_IBPOSS     /* inband possible */

/* negotiation indicator */

#define N_OBNOTPOSS    IN_N_OBNOTPOSS  /* outband not possible */
#define N_OBPOSS       IN_N_OBPOSS     /* outband possible */

/* synchronous/asynchronous */

#define SA_SYNC        IN_SA_SYNC   /* synchronous */
#define SA_ASYNC       IN_SA_ASYNC  /* asynchronous */

/* intermediate rate */

#define IR_NONE        IN_IR_NONE    /* none specified */
#define IR_8KBIT       IN_IR_8KBIT   /* 8 kbits */
#define IR_16KBIT      IN_IR_16KBIT  /* 16 kbits */
#define IR_32KBIT      IN_IR_32KBIT  /* 32 kbits */

/* assignor/assignee */

#define AA_ORGASGNEE   IN_AA_ORGASGNEE  /* originator is assignee */
#define AA_ORGASGNOR   IN_AA_ORGASGNOR  /* originator is assignor */

/* number of stop bits */

#define NSB_UNUSED     IN_NSB_UNUSED  /* none specified */
#define NSB_1          IN_NSB_1       /* 1 stop bit */
#define NSB_15         IN_NSB_15      /* 1.5 stop bits */
#define NSB_2          IN_NSB_2       /* 2 stop bits */

/* number of data bits */

#define NDB_UNUSED     IN_NDB_UNUSED  /* none specified */
#define NDB_5          IN_NDB_5       /* 5 bits */
#define NDB_7          IN_NDB_7       /* 7 bits */
#define NDB_8          IN_NDB_8       /* 8 bits */

/* parity information */

#define PARI_ODD       IN_PARI_ODD   /* odd */
#define PARI_EVEN      IN_PARI_EVEN  /* even */
#define PARI_NONE      IN_PARI_NONE  /* none */
#define PARI_0         IN_PARI_0     /* force to 0 */
#define PARI_1         IN_PARI_1     /* force to 1 */

/* duplex mode */

#define DUPMODE_HALF   IN_DUPMODE_HALF  /* half duplex */
#define DUPMODE_FULL   IN_DUPMODE_FULL  /* full duplex */

/* modem type */

#define MODEM_V21      IN_MODEM_V21     /* V.21 */
#define MODEM_V22      IN_MODEM_V22     /* V.21 */
#define MODEM_V22BIS   IN_MODEM_V22BIS  /* V.21 */
#define MODEM_V23      IN_MODEM_V23     /* V.21 */
#define MODEM_V26      IN_MODEM_V26     /* V.21 */
#define MODEM_V26BIS   IN_MODEM_V26BIS  /* V.21 */
#define MODEM_V26TER   IN_MODEM_V26TER  /* V.21 */
#define MODEM_V27      IN_MODEM_V27     /* V.21 */
#define MODEM_V27BIS   IN_MODEM_V27BIS  /* V.21 */
#define MODEM_V27TER   IN_MODEM_V27TER  /* V.21 */
#define MODEM_V29      IN_MODEM_V29     /* V.21 */
#define MODEM_V32      IN_MODEM_V32     /* V.21 */
#define MODEM_V35      IN_MODEM_V35     /* V.21 */

/* modem types for Australian Telecom */

#define MT_MODEM_UNDEF IN_MT_MODEM_UNDEF /* undefined */
#define MT_MODEM_V22   IN_MT_MODEM_V22   /* V.22      */

/* user information layer 1 */

#define UIL1_CCITTV110 IN_UIL1_CCITTV110  /* CCITT Standardized Rate Adaptation V.110/X.30. */
#define UIL1_G711ULAW  IN_UIL1_G711ULAW   /* Reccomendation G.711 u-Law */
#define UIL1_G711ALAW  IN_UIL1_G711ALAW   /* Recommendation G.711 A-Law */
#define UIL1_G721ADCPM IN_UIL1_G721ADCPM  /* Recommendation G.721 32 kbit/s ADCPM and */
                                          /* Recommendation I.460 */
#define UIL1_G722G725  IN_UIL1_G722G725   /* Recommendation G.722 and G.725 - 7kHz Audio */
#define UIL1_H261      IN_UIL1_H261       /* Recommendation H.261 - 384 kbit/s Video */
#define UIL1_NONCCITT  IN_UIL1_NONCCITT   /* Non-CCITT  standardized Rate adaptation */
#define UIL1_CCITTV120 IN_UIL1_CCITTV120  /* CCITT Standardized Rate Adaptation V.120 */
#define UIL1_CCITTX31  IN_UIL1_CCITTX31   /* CCITT Standardized Rate Adaptation X.31 HDLC */

/* user information layer 2 protocol */

#define UIL2_BASIC     IN_UIL2_BASIC    /* basic mode - ISO 1745 */
#define UIL2_Q921      IN_UIL2_Q921     /* CCITT Recommendation Q.921 */
#define UIL2_X25SLP    IN_UIL2_X25SLP   /* CCITT Recommendation X.25, single link */
#define UIL2_X25MLP    IN_UIL2_X25MLP   /* CCITT Recommendation X.25, multi link */
#define UIL2_T71       IN_UIL2_T71      /* extended LAPB for half duplex, */
                                        /* CCITT Recommendation T.71 */
#define UIL2_HDLCARM   IN_UIL2_HDLCARM  /* HDLC ARM - ISO 4335 */
#define UIL2_HDLCNRM   IN_UIL2_HDLCNRM  /* HDLC NRM - ISO 4335 */
#define UIL2_HDLCABM   IN_UIL2_HDLCABM  /* HDLC ABM - ISO 4335 */
#define UIL2_LANLLC    IN_UIL2_LANLLC   /* LAN LLC - ISO 8802/2 */
#define UIL2_X75SLP    IN_UIL2_X75SLP   /* CCITT Recommendation X.75, single link */
#define UIL2_Q922      IN_UIL2_Q922     /* CCITT Recommendation Q.922 */
#define UIL2_Q922C     IN_UIL2_Q922C    /* Core aspects of CCITT Recommendation Q.922 */
#define UIL2_USRSPEC   IN_UIL2_USRSPEC  /* CCITT User specified */
#define UIL2_T90       IN_UIL2_T90      /* CCITT T.90 */

/* user information layer 3 protocol */

#define UIL3_Q931      IN_UIL3_Q931     /* CCITT Recommendation Q.931 */
#define UIL3_T90       IN_UIL3_T90      /* CCITT T.90 */
#define UIL3_X25PLP    IN_UIL3_X25PLP   /* CCITT Recommendation X.25, packet layer */
#define UIL3_ISO8208   IN_UIL3_ISO8208  /* ISO 8208 */
#define UIL3_ISO8348   IN_UIL3_ISO8348  /* ISO 8348 */
#define UIL3_ISO8473   IN_UIL3_ISO8473  /* ISO 8473 */
#define UIL3_T70       IN_UIL3_T70      /* CCITT Recommendation T.70 */
#define UIL3_TR9577    IN_UIL3_TR9577   /* ISO/IEC TR 9577 */
#define UIL3_USRSPEC   IN_UIL3_USRSPEC  /* CCITT User specified */

/* mode of operation */

#define MOO_BITTRANS   IN_MOO_BITTRANS  /* bit transparent */
#define MOO_PROTSEN    IN_MOO_PROTSEN   /* protocol sensitive */

/* multiple frame establishment */

#define MFE_NOTSUP     IN_MFE_NOTSUP  /* not supported */
#define MFE_SUP        IN_MFE_SUP     /* supported */

/* logical link identifier */

#define LLI_DEF        IN_LLI_DEF      /* default */
#define LLI_FULLNEG    IN_LLI_FULLNEG  /* full protocol negotiation */

/* inband/outband negotiation */

#define ION_USRINFO    IN_ION_USRINFO  /* negotiation with user info messages */
#define ION_LL0        IN_ION_LL0      /* negotiation in band using logical link 0 */

/* connection type */

#define CON_PERM       IN_CON_PERM  /* type of B or D channel connection - 
                                       permanent */

#define FACILITY_QSIGGFT IN_FACILITY_QSIGGFT      /* Facility Q.SIG GFT handling */
#define FACILITY_STANDRD IN_FACILITY_STANDRD      /* Facility standard handling */

/* Delay Binding */

#define LIN_DELAY_BND        IN_LIN_DELAY_BND        /* Delay Binding */
#define LIN_NODELAY_BND      IN_LIN_NODELAY_BND      /* No Delay Binding */

#endif /* LIN_OLD_DEFINES */

/* Error Codes */
#define ELINBASE       0
#define ERRLIN         ELINBASE
#define ELINXXX        (ELINBASE + 0)

#define   ELIN001      (ERRLIN +    1)    /*        lin.c: 172 */
#define   ELIN002      (ERRLIN +    2)    /*        lin.c: 174 */
#define   ELIN003      (ERRLIN +    3)    /*        lin.c: 175 */
#define   ELIN004      (ERRLIN +    4)    /*        lin.c: 177 */
#define   ELIN005      (ERRLIN +    5)    /*        lin.c: 178 */
#define   ELIN006      (ERRLIN +    6)    /*        lin.c: 180 */
#define   ELIN007      (ERRLIN +    7)    /*        lin.c: 231 */
#define   ELIN008      (ERRLIN +    8)    /*        lin.c: 233 */
#define   ELIN009      (ERRLIN +    9)    /*        lin.c: 235 */
#define   ELIN010      (ERRLIN +   10)    /*        lin.c: 236 */
#define   ELIN011      (ERRLIN +   11)    /*        lin.c: 285 */
#define   ELIN012      (ERRLIN +   12)    /*        lin.c: 288 */
#define   ELIN013      (ERRLIN +   13)    /*        lin.c: 291 */
#define   ELIN014      (ERRLIN +   14)    /*        lin.c: 292 */
#define   ELIN015      (ERRLIN +   15)    /*        lin.c: 297 */
#define   ELIN016      (ERRLIN +   16)    /*        lin.c: 299 */
#define   ELIN017      (ERRLIN +   17)    /*        lin.c: 301 */
#define   ELIN018      (ERRLIN +   18)    /*        lin.c: 306 */
#define   ELIN019      (ERRLIN +   19)    /*        lin.c: 309 */
#define   ELIN020      (ERRLIN +   20)    /*        lin.c: 312 */
#define   ELIN021      (ERRLIN +   21)    /*        lin.c: 315 */
#define   ELIN022      (ERRLIN +   22)    /*        lin.c: 362 */
#define   ELIN023      (ERRLIN +   23)    /*        lin.c: 363 */
#define   ELIN024      (ERRLIN +   24)    /*        lin.c: 364 */
#define   ELIN025      (ERRLIN +   25)    /*        lin.c: 365 */
#define   ELIN026      (ERRLIN +   26)    /*        lin.c: 366 */
#define   ELIN027      (ERRLIN +   27)    /*        lin.c: 367 */
#define   ELIN028      (ERRLIN +   28)    /*        lin.c: 368 */
#define   ELIN029      (ERRLIN +   29)    /*        lin.c: 369 */
#define   ELIN030      (ERRLIN +   30)    /*        lin.c: 370 */
#define   ELIN031      (ERRLIN +   31)    /*        lin.c: 371 */
#define   ELIN032      (ERRLIN +   32)    /*        lin.c: 372 */
#define   ELIN033      (ERRLIN +   33)    /*        lin.c: 373 */
#define   ELIN034      (ERRLIN +   34)    /*        lin.c: 374 */
#define   ELIN035      (ERRLIN +   35)    /*        lin.c: 375 */
#define   ELIN036      (ERRLIN +   36)    /*        lin.c: 376 */
#define   ELIN037      (ERRLIN +   37)    /*        lin.c: 377 */
#define   ELIN038      (ERRLIN +   38)    /*        lin.c: 378 */
#define   ELIN039      (ERRLIN +   39)    /*        lin.c: 379 */
#define   ELIN040      (ERRLIN +   40)    /*        lin.c: 380 */
#define   ELIN041      (ERRLIN +   41)    /*        lin.c: 381 */
#define   ELIN042      (ERRLIN +   42)    /*        lin.c: 382 */
#define   ELIN043      (ERRLIN +   43)    /*        lin.c: 383 */
#define   ELIN044      (ERRLIN +   44)    /*        lin.c: 384 */
#define   ELIN045      (ERRLIN +   45)    /*        lin.c: 385 */
#define   ELIN046      (ERRLIN +   46)    /*        lin.c: 386 */
#define   ELIN047      (ERRLIN +   47)    /*        lin.c: 387 */
#define   ELIN048      (ERRLIN +   48)    /*        lin.c: 388 */
#define   ELIN049      (ERRLIN +   49)    /*        lin.c: 389 */
#define   ELIN050      (ERRLIN +   50)    /*        lin.c: 390 */
#define   ELIN051      (ERRLIN +   51)    /*        lin.c: 391 */
#define   ELIN052      (ERRLIN +   52)    /*        lin.c: 392 */
#define   ELIN053      (ERRLIN +   53)    /*        lin.c: 393 */
#define   ELIN054      (ERRLIN +   54)    /*        lin.c: 394 */
#define   ELIN055      (ERRLIN +   55)    /*        lin.c: 395 */
#define   ELIN056      (ERRLIN +   56)    /*        lin.c: 396 */
#define   ELIN057      (ERRLIN +   57)    /*        lin.c: 397 */
#define   ELIN058      (ERRLIN +   58)    /*        lin.c: 398 */
#define   ELIN059      (ERRLIN +   59)    /*        lin.c: 399 */
#define   ELIN060      (ERRLIN +   60)    /*        lin.c: 400 */
#define   ELIN061      (ERRLIN +   61)    /*        lin.c: 401 */
#define   ELIN062      (ERRLIN +   62)    /*        lin.c: 402 */
#define   ELIN063      (ERRLIN +   63)    /*        lin.c: 403 */
#define   ELIN064      (ERRLIN +   64)    /*        lin.c: 404 */
#define   ELIN065      (ERRLIN +   65)    /*        lin.c: 405 */
#define   ELIN066      (ERRLIN +   66)    /*        lin.c: 406 */
#define   ELIN067      (ERRLIN +   67)    /*        lin.c: 407 */
#define   ELIN068      (ERRLIN +   68)    /*        lin.c: 408 */
#define   ELIN069      (ERRLIN +   69)    /*        lin.c: 409 */
#define   ELIN070      (ERRLIN +   70)    /*        lin.c: 410 */
#define   ELIN071      (ERRLIN +   71)    /*        lin.c: 411 */
#define   ELIN072      (ERRLIN +   72)    /*        lin.c: 412 */
#define   ELIN073      (ERRLIN +   73)    /*        lin.c: 413 */
#define   ELIN074      (ERRLIN +   74)    /*        lin.c: 414 */
#define   ELIN075      (ERRLIN +   75)    /*        lin.c: 415 */
#define   ELIN076      (ERRLIN +   76)    /*        lin.c: 416 */
#define   ELIN077      (ERRLIN +   77)    /*        lin.c: 417 */
#define   ELIN078      (ERRLIN +   78)    /*        lin.c: 418 */
#define   ELIN079      (ERRLIN +   79)    /*        lin.c: 419 */
#define   ELIN080      (ERRLIN +   80)    /*        lin.c: 420 */
#define   ELIN081      (ERRLIN +   81)    /*        lin.c: 421 */
#define   ELIN082      (ERRLIN +   82)    /*        lin.c: 422 */
#define   ELIN083      (ERRLIN +   83)    /*        lin.c: 423 */
#define   ELIN084      (ERRLIN +   84)    /*        lin.c: 424 */
#define   ELIN085      (ERRLIN +   85)    /*        lin.c: 425 */
#define   ELIN086      (ERRLIN +   86)    /*        lin.c: 426 */
#define   ELIN087      (ERRLIN +   87)    /*        lin.c: 427 */
#define   ELIN088      (ERRLIN +   88)    /*        lin.c: 428 */
#define   ELIN089      (ERRLIN +   89)    /*        lin.c: 429 */
#define   ELIN090      (ERRLIN +   90)    /*        lin.c: 430 */
#define   ELIN091      (ERRLIN +   91)    /*        lin.c: 431 */
#define   ELIN092      (ERRLIN +   92)    /*        lin.c: 432 */
#define   ELIN093      (ERRLIN +   93)    /*        lin.c: 433 */
#define   ELIN094      (ERRLIN +   94)    /*        lin.c: 434 */
#define   ELIN095      (ERRLIN +   95)    /*        lin.c: 435 */
#define   ELIN096      (ERRLIN +   96)    /*        lin.c: 436 */
#define   ELIN097      (ERRLIN +   97)    /*        lin.c: 437 */
#define   ELIN098      (ERRLIN +   98)    /*        lin.c: 438 */
#define   ELIN099      (ERRLIN +   99)    /*        lin.c: 439 */
#define   ELIN100      (ERRLIN +  100)    /*        lin.c: 440 */
#define   ELIN101      (ERRLIN +  101)    /*        lin.c: 441 */
#define   ELIN102      (ERRLIN +  102)    /*        lin.c: 442 */
#define   ELIN103      (ERRLIN +  103)    /*        lin.c: 444 */
#define   ELIN104      (ERRLIN +  104)    /*        lin.c: 446 */
#define   ELIN105      (ERRLIN +  105)    /*        lin.c: 447 */
#define   ELIN106      (ERRLIN +  106)    /*        lin.c: 448 */
#define   ELIN107      (ERRLIN +  107)    /*        lin.c: 451 */
#define   ELIN108      (ERRLIN +  108)    /*        lin.c: 454 */
#define   ELIN109      (ERRLIN +  109)    /*        lin.c: 498 */
#define   ELIN110      (ERRLIN +  110)    /*        lin.c: 500 */
#define   ELIN111      (ERRLIN +  111)    /*        lin.c: 504 */
#define   ELIN112      (ERRLIN +  112)    /*        lin.c: 507 */
#define   ELIN113      (ERRLIN +  113)    /*        lin.c: 511 */
#define   ELIN114      (ERRLIN +  114)    /*        lin.c: 513 */
#define   ELIN115      (ERRLIN +  115)    /*        lin.c: 514 */
#define   ELIN116      (ERRLIN +  116)    /*        lin.c: 559 */
#define   ELIN117      (ERRLIN +  117)    /*        lin.c: 560 */
#define   ELIN118      (ERRLIN +  118)    /*        lin.c: 602 */
#define   ELIN119      (ERRLIN +  119)    /*        lin.c: 603 */
#define   ELIN120      (ERRLIN +  120)    /*        lin.c: 750 */
#define   ELIN121      (ERRLIN +  121)    /*        lin.c: 751 */
#define   ELIN122      (ERRLIN +  122)    /*        lin.c: 752 */
#define   ELIN123      (ERRLIN +  123)    /*        lin.c: 753 */
#define   ELIN124      (ERRLIN +  124)    /*        lin.c: 754 */
#define   ELIN125      (ERRLIN +  125)    /*        lin.c: 755 */
#define   ELIN126      (ERRLIN +  126)    /*        lin.c: 756 */
#define   ELIN127      (ERRLIN +  127)    /*        lin.c: 758 */
#define   ELIN128      (ERRLIN +  128)    /*        lin.c: 760 */
#define   ELIN129      (ERRLIN +  129)    /*        lin.c: 761 */
#define   ELIN130      (ERRLIN +  130)    /*        lin.c: 764 */
#define   ELIN131      (ERRLIN +  131)    /*        lin.c: 765 */
#define   ELIN132      (ERRLIN +  132)    /*        lin.c: 766 */
#define   ELIN133      (ERRLIN +  133)    /*        lin.c: 767 */
#define   ELIN134      (ERRLIN +  134)    /*        lin.c: 768 */
#define   ELIN135      (ERRLIN +  135)    /*        lin.c: 770 */
#define   ELIN136      (ERRLIN +  136)    /*        lin.c: 771 */
#define   ELIN137      (ERRLIN +  137)    /*        lin.c: 772 */
#define   ELIN138      (ERRLIN +  138)    /*        lin.c: 777 */
#define   ELIN139      (ERRLIN +  139)    /*        lin.c: 779 */
#define   ELIN140      (ERRLIN +  140)    /*        lin.c: 780 */
#define   ELIN141      (ERRLIN +  141)    /*        lin.c: 781 */
#define   ELIN142      (ERRLIN +  142)    /*        lin.c: 782 */
#define   ELIN143      (ERRLIN +  143)    /*        lin.c: 783 */
#define   ELIN144      (ERRLIN +  144)    /*        lin.c: 786 */
#define   ELIN145      (ERRLIN +  145)    /*        lin.c: 787 */
#define   ELIN146      (ERRLIN +  146)    /*        lin.c: 788 */
#define   ELIN147      (ERRLIN +  147)    /*        lin.c: 791 */
#define   ELIN148      (ERRLIN +  148)    /*        lin.c: 792 */
#define   ELIN149      (ERRLIN +  149)    /*        lin.c: 793 */
#define   ELIN150      (ERRLIN +  150)    /*        lin.c: 796 */
#define   ELIN151      (ERRLIN +  151)    /*        lin.c: 797 */
#define   ELIN152      (ERRLIN +  152)    /*        lin.c: 798 */
#define   ELIN153      (ERRLIN +  153)    /*        lin.c: 799 */
#define   ELIN154      (ERRLIN +  154)    /*        lin.c: 801 */
#define   ELIN155      (ERRLIN +  155)    /*        lin.c: 802 */
#define   ELIN156      (ERRLIN +  156)    /*        lin.c: 803 */
#define   ELIN157      (ERRLIN +  157)    /*        lin.c: 805 */
#define   ELIN158      (ERRLIN +  158)    /*        lin.c: 808 */
#define   ELIN159      (ERRLIN +  159)    /*        lin.c: 809 */
#define   ELIN160      (ERRLIN +  160)    /*        lin.c: 810 */
#define   ELIN161      (ERRLIN +  161)    /*        lin.c: 811 */
#define   ELIN162      (ERRLIN +  162)    /*        lin.c: 812 */
#define   ELIN163      (ERRLIN +  163)    /*        lin.c: 813 */
#define   ELIN164      (ERRLIN +  164)    /*        lin.c: 818 */
#define   ELIN165      (ERRLIN +  165)    /*        lin.c: 820 */
#define   ELIN166      (ERRLIN +  166)    /*        lin.c: 821 */
#define   ELIN167      (ERRLIN +  167)    /*        lin.c: 822 */
#define   ELIN168      (ERRLIN +  168)    /*        lin.c: 823 */
#define   ELIN169      (ERRLIN +  169)    /*        lin.c: 824 */
#define   ELIN170      (ERRLIN +  170)    /*        lin.c: 825 */
#define   ELIN171      (ERRLIN +  171)    /*        lin.c: 826 */
#define   ELIN172      (ERRLIN +  172)    /*        lin.c: 827 */
#define   ELIN173      (ERRLIN +  173)    /*        lin.c: 828 */
#define   ELIN174      (ERRLIN +  174)    /*        lin.c: 829 */
#define   ELIN175      (ERRLIN +  175)    /*        lin.c: 832 */
#define   ELIN176      (ERRLIN +  176)    /*        lin.c: 833 */
#define   ELIN177      (ERRLIN +  177)    /*        lin.c: 834 */
#define   ELIN178      (ERRLIN +  178)    /*        lin.c: 835 */
#define   ELIN179      (ERRLIN +  179)    /*        lin.c: 836 */
#define   ELIN180      (ERRLIN +  180)    /*        lin.c: 838 */
#define   ELIN181      (ERRLIN +  181)    /*        lin.c: 840 */
#define   ELIN182      (ERRLIN +  182)    /*        lin.c: 841 */
#define   ELIN183      (ERRLIN +  183)    /*        lin.c: 842 */
#define   ELIN184      (ERRLIN +  184)    /*        lin.c: 844 */
#define   ELIN185      (ERRLIN +  185)    /*        lin.c: 846 */
#define   ELIN186      (ERRLIN +  186)    /*        lin.c: 848 */
#define   ELIN187      (ERRLIN +  187)    /*        lin.c: 850 */
#define   ELIN188      (ERRLIN +  188)    /*        lin.c: 852 */
#define   ELIN189      (ERRLIN +  189)    /*        lin.c: 855 */
#define   ELIN190      (ERRLIN +  190)    /*        lin.c: 857 */
#define   ELIN191      (ERRLIN +  191)    /*        lin.c: 861 */
#define   ELIN192      (ERRLIN +  192)    /*        lin.c: 863 */
#define   ELIN193      (ERRLIN +  193)    /*        lin.c: 865 */
#define   ELIN194      (ERRLIN +  194)    /*        lin.c: 867 */
#define   ELIN195      (ERRLIN +  195)    /*        lin.c: 869 */
#define   ELIN196      (ERRLIN +  196)    /*        lin.c: 870 */
#define   ELIN197      (ERRLIN +  197)    /*        lin.c: 871 */
#define   ELIN198      (ERRLIN +  198)    /*        lin.c: 873 */
#define   ELIN199      (ERRLIN +  199)    /*        lin.c: 877 */
#define   ELIN200      (ERRLIN +  200)    /*        lin.c: 879 */
#define   ELIN201      (ERRLIN +  201)    /*        lin.c: 880 */
#define   ELIN202      (ERRLIN +  202)    /*        lin.c: 884 */
#define   ELIN203      (ERRLIN +  203)    /*        lin.c: 886 */
#define   ELIN204      (ERRLIN +  204)    /*        lin.c: 888 */
#define   ELIN205      (ERRLIN +  205)    /*        lin.c: 892 */
#define   ELIN206      (ERRLIN +  206)    /*        lin.c: 893 */
#define   ELIN207      (ERRLIN +  207)    /*        lin.c: 894 */
#define   ELIN208      (ERRLIN +  208)    /*        lin.c: 896 */
#define   ELIN209      (ERRLIN +  209)    /*        lin.c: 897 */
#define   ELIN210      (ERRLIN +  210)    /*        lin.c: 898 */
#define   ELIN211      (ERRLIN +  211)    /*        lin.c: 899 */
#define   ELIN212      (ERRLIN +  212)    /*        lin.c: 900 */
#define   ELIN213      (ERRLIN +  213)    /*        lin.c: 902 */
#define   ELIN214      (ERRLIN +  214)    /*        lin.c: 905 */
#define   ELIN215      (ERRLIN +  215)    /*        lin.c: 908 */
#define   ELIN216      (ERRLIN +  216)    /*        lin.c: 910 */
#define   ELIN217      (ERRLIN +  217)    /*        lin.c: 912 */
#define   ELIN218      (ERRLIN +  218)    /*        lin.c: 913 */
#define   ELIN219      (ERRLIN +  219)    /*        lin.c: 914 */
#define   ELIN220      (ERRLIN +  220)    /*        lin.c: 916 */
#define   ELIN221      (ERRLIN +  221)    /*        lin.c: 918 */
#define   ELIN222      (ERRLIN +  222)    /*        lin.c: 920 */
#define   ELIN223      (ERRLIN +  223)    /*        lin.c: 922 */
#define   ELIN224      (ERRLIN +  224)    /*        lin.c: 924 */
#define   ELIN225      (ERRLIN +  225)    /*        lin.c: 926 */
#define   ELIN226      (ERRLIN +  226)    /*        lin.c: 928 */
#define   ELIN227      (ERRLIN +  227)    /*        lin.c: 930 */
#define   ELIN228      (ERRLIN +  228)    /*        lin.c: 932 */
#define   ELIN229      (ERRLIN +  229)    /*        lin.c: 934 */
#define   ELIN230      (ERRLIN +  230)    /*        lin.c: 936 */
#define   ELIN231      (ERRLIN +  231)    /*        lin.c: 938 */
#define   ELIN232      (ERRLIN +  232)    /*        lin.c: 940 */
#define   ELIN233      (ERRLIN +  233)    /*        lin.c: 942 */
#define   ELIN234      (ERRLIN +  234)    /*        lin.c: 944 */
#define   ELIN235      (ERRLIN +  235)    /*        lin.c: 946 */
#define   ELIN236      (ERRLIN +  236)    /*        lin.c: 948 */
#define   ELIN237      (ERRLIN +  237)    /*        lin.c: 950 */
#define   ELIN238      (ERRLIN +  238)    /*        lin.c: 952 */
#define   ELIN239      (ERRLIN +  239)    /*        lin.c: 954 */
#define   ELIN240      (ERRLIN +  240)    /*        lin.c: 956 */
#define   ELIN241      (ERRLIN +  241)    /*        lin.c: 958 */
#define   ELIN242      (ERRLIN +  242)    /*        lin.c: 960 */
#define   ELIN243      (ERRLIN +  243)    /*        lin.c: 964 */
#define   ELIN244      (ERRLIN +  244)    /*        lin.c: 969 */
#define   ELIN245      (ERRLIN +  245)    /*        lin.c: 972 */
#define   ELIN246      (ERRLIN +  246)    /*        lin.c: 973 */
#define   ELIN247      (ERRLIN +  247)    /*        lin.c: 975 */
#define   ELIN248      (ERRLIN +  248)    /*        lin.c: 976 */
#define   ELIN249      (ERRLIN +  249)    /*        lin.c: 977 */
#define   ELIN250      (ERRLIN +  250)    /*        lin.c: 979 */
#define   ELIN251      (ERRLIN +  251)    /*        lin.c: 981 */
#define   ELIN252      (ERRLIN +  252)    /*        lin.c: 982 */
#define   ELIN253      (ERRLIN +  253)    /*        lin.c: 986 */
#define   ELIN254      (ERRLIN +  254)    /*        lin.c: 989 */
#define   ELIN255      (ERRLIN +  255)    /*        lin.c: 990 */
#define   ELIN256      (ERRLIN +  256)    /*        lin.c: 991 */
#define   ELIN257      (ERRLIN +  257)    /*        lin.c: 992 */
#define   ELIN258      (ERRLIN +  258)    /*        lin.c: 993 */
#define   ELIN259      (ERRLIN +  259)    /*        lin.c: 997 */
#define   ELIN260      (ERRLIN +  260)    /*        lin.c: 998 */
#define   ELIN261      (ERRLIN +  261)    /*        lin.c:1000 */
#define   ELIN262      (ERRLIN +  262)    /*        lin.c:1001 */
#define   ELIN263      (ERRLIN +  263)    /*        lin.c:1002 */
#define   ELIN264      (ERRLIN +  264)    /*        lin.c:1003 */
#define   ELIN265      (ERRLIN +  265)    /*        lin.c:1004 */
#define   ELIN266      (ERRLIN +  266)    /*        lin.c:1006 */
#define   ELIN267      (ERRLIN +  267)    /*        lin.c:1008 */
#define   ELIN268      (ERRLIN +  268)    /*        lin.c:1010 */
#define   ELIN269      (ERRLIN +  269)    /*        lin.c:1011 */
#define   ELIN270      (ERRLIN +  270)    /*        lin.c:1012 */
#define   ELIN271      (ERRLIN +  271)    /*        lin.c:1015 */
#define   ELIN272      (ERRLIN +  272)    /*        lin.c:1017 */
#define   ELIN273      (ERRLIN +  273)    /*        lin.c:1019 */
#define   ELIN274      (ERRLIN +  274)    /*        lin.c:1021 */
#define   ELIN275      (ERRLIN +  275)    /*        lin.c:1023 */
#define   ELIN276      (ERRLIN +  276)    /*        lin.c:1027 */
#define   ELIN277      (ERRLIN +  277)    /*        lin.c:1029 */
#define   ELIN278      (ERRLIN +  278)    /*        lin.c:1031 */
#define   ELIN279      (ERRLIN +  279)    /*        lin.c:1033 */
#define   ELIN280      (ERRLIN +  280)    /*        lin.c:1035 */
#define   ELIN281      (ERRLIN +  281)    /*        lin.c:1038 */
#define   ELIN282      (ERRLIN +  282)    /*        lin.c:1041 */
#define   ELIN283      (ERRLIN +  283)    /*        lin.c:1043 */
#define   ELIN284      (ERRLIN +  284)    /*        lin.c:1045 */
#define   ELIN285      (ERRLIN +  285)    /*        lin.c:1047 */
#define   ELIN286      (ERRLIN +  286)    /*        lin.c:1049 */
#define   ELIN287      (ERRLIN +  287)    /*        lin.c:1051 */
#define   ELIN288      (ERRLIN +  288)    /*        lin.c:1053 */
#define   ELIN289      (ERRLIN +  289)    /*        lin.c:1055 */
#define   ELIN290      (ERRLIN +  290)    /*        lin.c:1057 */
#define   ELIN291      (ERRLIN +  291)    /*        lin.c:1059 */
#define   ELIN292      (ERRLIN +  292)    /*        lin.c:1061 */
#define   ELIN293      (ERRLIN +  293)    /*        lin.c:1063 */
#define   ELIN294      (ERRLIN +  294)    /*        lin.c:1065 */
#define   ELIN295      (ERRLIN +  295)    /*        lin.c:1067 */
#define   ELIN296      (ERRLIN +  296)    /*        lin.c:1069 */
#define   ELIN297      (ERRLIN +  297)    /*        lin.c:1071 */
#define   ELIN298      (ERRLIN +  298)    /*        lin.c:1073 */
#define   ELIN299      (ERRLIN +  299)    /*        lin.c:1075 */
#define   ELIN300      (ERRLIN +  300)    /*        lin.c:1081 */
#define   ELIN301      (ERRLIN +  301)    /*        lin.c:1132 */
#define   ELIN302      (ERRLIN +  302)    /*        lin.c:1137 */
#define   ELIN303      (ERRLIN +  303)    /*        lin.c:1143 */
#define   ELIN304      (ERRLIN +  304)    /*        lin.c:1145 */
#define   ELIN305      (ERRLIN +  305)    /*        lin.c:1146 */
#define   ELIN306      (ERRLIN +  306)    /*        lin.c:1195 */
#define   ELIN307      (ERRLIN +  307)    /*        lin.c:1197 */
#define   ELIN308      (ERRLIN +  308)    /*        lin.c:1199 */
#define   ELIN309      (ERRLIN +  309)    /*        lin.c:1200 */
#define   ELIN310      (ERRLIN +  310)    /*        lin.c:1201 */
#define   ELIN311      (ERRLIN +  311)    /*        lin.c:1251 */
#define   ELIN312      (ERRLIN +  312)    /*        lin.c:1255 */
#define   ELIN313      (ERRLIN +  313)    /*        lin.c:1258 */
#define   ELIN314      (ERRLIN +  314)    /*        lin.c:1261 */
#define   ELIN315      (ERRLIN +  315)    /*        lin.c:1264 */
#define   ELIN316      (ERRLIN +  316)    /*        lin.c:1265 */
#define   ELIN317      (ERRLIN +  317)    /*        lin.c:1266 */
#define   ELIN318      (ERRLIN +  318)    /*        lin.c:1267 */
#define   ELIN319      (ERRLIN +  319)    /*        lin.c:1269 */
#define   ELIN320      (ERRLIN +  320)    /*        lin.c:1270 */
#define   ELIN321      (ERRLIN +  321)    /*        lin.c:1271 */
#define   ELIN322      (ERRLIN +  322)    /*        lin.c:1272 */
#define   ELIN323      (ERRLIN +  323)    /*        lin.c:1413 */
#define   ELIN324      (ERRLIN +  324)    /*        lin.c:1414 */
#define   ELIN325      (ERRLIN +  325)    /*        lin.c:1416 */
#define   ELIN326      (ERRLIN +  326)    /*        lin.c:1417 */
#define   ELIN327      (ERRLIN +  327)    /*        lin.c:1419 */
#define   ELIN328      (ERRLIN +  328)    /*        lin.c:1420 */
#define   ELIN329      (ERRLIN +  329)    /*        lin.c:1421 */
#define   ELIN330      (ERRLIN +  330)    /*        lin.c:1422 */
#define   ELIN331      (ERRLIN +  331)    /*        lin.c:1424 */
#define   ELIN332      (ERRLIN +  332)    /*        lin.c:1428 */
#define   ELIN333      (ERRLIN +  333)    /*        lin.c:1432 */
#define   ELIN334      (ERRLIN +  334)    /*        lin.c:1435 */
#define   ELIN335      (ERRLIN +  335)    /*        lin.c:1480 */
#define   ELIN336      (ERRLIN +  336)    /*        lin.c:1481 */
#define   ELIN337      (ERRLIN +  337)    /*        lin.c:1482 */
#define   ELIN338      (ERRLIN +  338)    /*        lin.c:1484 */
#define   ELIN339      (ERRLIN +  339)    /*        lin.c:1486 */
#define   ELIN340      (ERRLIN +  340)    /*        lin.c:1528 */
#define   ELIN341      (ERRLIN +  341)    /*        lin.c:1529 */
#define   ELIN342      (ERRLIN +  342)    /*        lin.c:1531 */
#define   ELIN343      (ERRLIN +  343)    /*        lin.c:1539 */
#define   ELIN344      (ERRLIN +  344)    /*        lin.c:1544 */
#define   ELIN345      (ERRLIN +  345)    /*        lin.c:1590 */
#define   ELIN346      (ERRLIN +  346)    /*        lin.c:1595 */
#define   ELIN347      (ERRLIN +  347)    /*        lin.c:1597 */
#define   ELIN348      (ERRLIN +  348)    /*        lin.c:1599 */
#define   ELIN349      (ERRLIN +  349)    /*        lin.c:1601 */
#define   ELIN350      (ERRLIN +  350)    /*        lin.c:1603 */
#define   ELIN351      (ERRLIN +  351)    /*        lin.c:1605 */
#define   ELIN352      (ERRLIN +  352)    /*        lin.c:1607 */
#define   ELIN353      (ERRLIN +  353)    /*        lin.c:1609 */
#define   ELIN354      (ERRLIN +  354)    /*        lin.c:1611 */
#define   ELIN355      (ERRLIN +  355)    /*        lin.c:1613 */
#define   ELIN356      (ERRLIN +  356)    /*        lin.c:1615 */
#define   ELIN357      (ERRLIN +  357)    /*        lin.c:1617 */
#define   ELIN358      (ERRLIN +  358)    /*        lin.c:1619 */
#define   ELIN359      (ERRLIN +  359)    /*        lin.c:1621 */
#define   ELIN360      (ERRLIN +  360)    /*        lin.c:1623 */
#define   ELIN361      (ERRLIN +  361)    /*        lin.c:1625 */
#define   ELIN362      (ERRLIN +  362)    /*        lin.c:1627 */
#define   ELIN363      (ERRLIN +  363)    /*        lin.c:1629 */
#define   ELIN364      (ERRLIN +  364)    /*        lin.c:1634 */
#define   ELIN365      (ERRLIN +  365)    /*        lin.c:1636 */
#define   ELIN366      (ERRLIN +  366)    /*        lin.c:1637 */
#define   ELIN367      (ERRLIN +  367)    /*        lin.c:1638 */
#define   ELIN368      (ERRLIN +  368)    /*        lin.c:1640 */
#define   ELIN369      (ERRLIN +  369)    /*        lin.c:1644 */
#define   ELIN370      (ERRLIN +  370)    /*        lin.c:1647 */
#define   ELIN371      (ERRLIN +  371)    /*        lin.c:1649 */
#define   ELIN372      (ERRLIN +  372)    /*        lin.c:1651 */
#define   ELIN373      (ERRLIN +  373)    /*        lin.c:1653 */
#define   ELIN374      (ERRLIN +  374)    /*        lin.c:1655 */
#define   ELIN375      (ERRLIN +  375)    /*        lin.c:1657 */
#define   ELIN376      (ERRLIN +  376)    /*        lin.c:1659 */
#define   ELIN377      (ERRLIN +  377)    /*        lin.c:1662 */
#define   ELIN378      (ERRLIN +  378)    /*        lin.c:1664 */
#define   ELIN379      (ERRLIN +  379)    /*        lin.c:1666 */
#define   ELIN380      (ERRLIN +  380)    /*        lin.c:1669 */
#define   ELIN381      (ERRLIN +  381)    /*        lin.c:1671 */
#define   ELIN382      (ERRLIN +  382)    /*        lin.c:1673 */
#define   ELIN383      (ERRLIN +  383)    /*        lin.c:1676 */
#define   ELIN384      (ERRLIN +  384)    /*        lin.c:1678 */
#define   ELIN385      (ERRLIN +  385)    /*        lin.c:1680 */
#define   ELIN386      (ERRLIN +  386)    /*        lin.c:1682 */
#define   ELIN387      (ERRLIN +  387)    /*        lin.c:1684 */
#define   ELIN388      (ERRLIN +  388)    /*        lin.c:1686 */
#define   ELIN389      (ERRLIN +  389)    /*        lin.c:1689 */
#define   ELIN390      (ERRLIN +  390)    /*        lin.c:1696 */
#define   ELIN391      (ERRLIN +  391)    /*        lin.c:1698 */
#define   ELIN392      (ERRLIN +  392)    /*        lin.c:1700 */
#define   ELIN393      (ERRLIN +  393)    /*        lin.c:1702 */
#define   ELIN394      (ERRLIN +  394)    /*        lin.c:1704 */
#define   ELIN395      (ERRLIN +  395)    /*        lin.c:1706 */
#define   ELIN396      (ERRLIN +  396)    /*        lin.c:1708 */
#define   ELIN397      (ERRLIN +  397)    /*        lin.c:1710 */
#define   ELIN398      (ERRLIN +  398)    /*        lin.c:1713 */
#define   ELIN399      (ERRLIN +  399)    /*        lin.c:1718 */
#define   ELIN400      (ERRLIN +  400)    /*        lin.c:1722 */
#define   ELIN401      (ERRLIN +  401)    /*        lin.c:1724 */
#define   ELIN402      (ERRLIN +  402)    /*        lin.c:1726 */
#define   ELIN403      (ERRLIN +  403)    /*        lin.c:1728 */
#define   ELIN404      (ERRLIN +  404)    /*        lin.c:1730 */
#define   ELIN405      (ERRLIN +  405)    /*        lin.c:1732 */
#define   ELIN406      (ERRLIN +  406)    /*        lin.c:1734 */
#define   ELIN407      (ERRLIN +  407)    /*        lin.c:1736 */
#define   ELIN408      (ERRLIN +  408)    /*        lin.c:1738 */
#define   ELIN409      (ERRLIN +  409)    /*        lin.c:1740 */
#define   ELIN410      (ERRLIN +  410)    /*        lin.c:1742 */
#define   ELIN411      (ERRLIN +  411)    /*        lin.c:1744 */
#define   ELIN412      (ERRLIN +  412)    /*        lin.c:1746 */
#define   ELIN413      (ERRLIN +  413)    /*        lin.c:1748 */
#define   ELIN414      (ERRLIN +  414)    /*        lin.c:1750 */
#define   ELIN415      (ERRLIN +  415)    /*        lin.c:1752 */
#define   ELIN416      (ERRLIN +  416)    /*        lin.c:1754 */
#define   ELIN417      (ERRLIN +  417)    /*        lin.c:1756 */
#define   ELIN418      (ERRLIN +  418)    /*        lin.c:1758 */
#define   ELIN419      (ERRLIN +  419)    /*        lin.c:1760 */
#define   ELIN420      (ERRLIN +  420)    /*        lin.c:1762 */
#define   ELIN421      (ERRLIN +  421)    /*        lin.c:1764 */
#define   ELIN422      (ERRLIN +  422)    /*        lin.c:1766 */
#define   ELIN423      (ERRLIN +  423)    /*        lin.c:1768 */
#define   ELIN424      (ERRLIN +  424)    /*        lin.c:1770 */
#define   ELIN425      (ERRLIN +  425)    /*        lin.c:1772 */
#define   ELIN426      (ERRLIN +  426)    /*        lin.c:1774 */
#define   ELIN427      (ERRLIN +  427)    /*        lin.c:1776 */
#define   ELIN428      (ERRLIN +  428)    /*        lin.c:1779 */
#define   ELIN429      (ERRLIN +  429)    /*        lin.c:1783 */
#define   ELIN430      (ERRLIN +  430)    /*        lin.c:1786 */
#define   ELIN431      (ERRLIN +  431)    /*        lin.c:1788 */
#define   ELIN432      (ERRLIN +  432)    /*        lin.c:1790 */
#define   ELIN433      (ERRLIN +  433)    /*        lin.c:1792 */
#define   ELIN434      (ERRLIN +  434)    /*        lin.c:1794 */
#define   ELIN435      (ERRLIN +  435)    /*        lin.c:1796 */
#define   ELIN436      (ERRLIN +  436)    /*        lin.c:1798 */
#define   ELIN437      (ERRLIN +  437)    /*        lin.c:1802 */
#define   ELIN438      (ERRLIN +  438)    /*        lin.c:1805 */
#define   ELIN439      (ERRLIN +  439)    /*        lin.c:1807 */
#define   ELIN440      (ERRLIN +  440)    /*        lin.c:1811 */
#define   ELIN441      (ERRLIN +  441)    /*        lin.c:1814 */
#define   ELIN442      (ERRLIN +  442)    /*        lin.c:1816 */
#define   ELIN443      (ERRLIN +  443)    /*        lin.c:1821 */
#define   ELIN444      (ERRLIN +  444)    /*        lin.c:1825 */
#define   ELIN445      (ERRLIN +  445)    /*        lin.c:1827 */
#define   ELIN446      (ERRLIN +  446)    /*        lin.c:1829 */
#define   ELIN447      (ERRLIN +  447)    /*        lin.c:1831 */
#define   ELIN448      (ERRLIN +  448)    /*        lin.c:1833 */
#define   ELIN449      (ERRLIN +  449)    /*        lin.c:1839 */
#define   ELIN450      (ERRLIN +  450)    /*        lin.c:1841 */
#define   ELIN451      (ERRLIN +  451)    /*        lin.c:1843 */
#define   ELIN452      (ERRLIN +  452)    /*        lin.c:1847 */
#define   ELIN453      (ERRLIN +  453)    /*        lin.c:1849 */
#define   ELIN454      (ERRLIN +  454)    /*        lin.c:1852 */
#define   ELIN455      (ERRLIN +  455)    /*        lin.c:1854 */
#define   ELIN456      (ERRLIN +  456)    /*        lin.c:1856 */
#define   ELIN457      (ERRLIN +  457)    /*        lin.c:1859 */
#define   ELIN458      (ERRLIN +  458)    /*        lin.c:1861 */
#define   ELIN459      (ERRLIN +  459)    /*        lin.c:1863 */
#define   ELIN460      (ERRLIN +  460)    /*        lin.c:1865 */
#define   ELIN461      (ERRLIN +  461)    /*        lin.c:1867 */
#define   ELIN462      (ERRLIN +  462)    /*        lin.c:1869 */
#define   ELIN463      (ERRLIN +  463)    /*        lin.c:1871 */
#define   ELIN464      (ERRLIN +  464)    /*        lin.c:1873 */
#define   ELIN465      (ERRLIN +  465)    /*        lin.c:1875 */
#define   ELIN466      (ERRLIN +  466)    /*        lin.c:1877 */
#define   ELIN467      (ERRLIN +  467)    /*        lin.c:1882 */
#define   ELIN468      (ERRLIN +  468)    /*        lin.c:1885 */
#define   ELIN469      (ERRLIN +  469)    /*        lin.c:1887 */
#define   ELIN470      (ERRLIN +  470)    /*        lin.c:1889 */
#define   ELIN471      (ERRLIN +  471)    /*        lin.c:1891 */
#define   ELIN472      (ERRLIN +  472)    /*        lin.c:1893 */
#define   ELIN473      (ERRLIN +  473)    /*        lin.c:1895 */
#define   ELIN474      (ERRLIN +  474)    /*        lin.c:1897 */
#define   ELIN475      (ERRLIN +  475)    /*        lin.c:1899 */
#define   ELIN476      (ERRLIN +  476)    /*        lin.c:1901 */
#define   ELIN477      (ERRLIN +  477)    /*        lin.c:1903 */
#define   ELIN478      (ERRLIN +  478)    /*        lin.c:1906 */
#define   ELIN479      (ERRLIN +  479)    /*        lin.c:1912 */
#define   ELIN480      (ERRLIN +  480)    /*        lin.c:1914 */
#define   ELIN481      (ERRLIN +  481)    /*        lin.c:1916 */
#define   ELIN482      (ERRLIN +  482)    /*        lin.c:1918 */
#define   ELIN483      (ERRLIN +  483)    /*        lin.c:1922 */
#define   ELIN484      (ERRLIN +  484)    /*        lin.c:1924 */
#define   ELIN485      (ERRLIN +  485)    /*        lin.c:1928 */
#define   ELIN486      (ERRLIN +  486)    /*        lin.c:1929 */
#define   ELIN487      (ERRLIN +  487)    /*        lin.c:1930 */
#define   ELIN488      (ERRLIN +  488)    /*        lin.c:1935 */
#define   ELIN489      (ERRLIN +  489)    /*        lin.c:1939 */
#define   ELIN490      (ERRLIN +  490)    /*        lin.c:1941 */
#define   ELIN491      (ERRLIN +  491)    /*        lin.c:1943 */
#define   ELIN492      (ERRLIN +  492)    /*        lin.c:1945 */
#define   ELIN493      (ERRLIN +  493)    /*        lin.c:1947 */
#define   ELIN494      (ERRLIN +  494)    /*        lin.c:1949 */
#define   ELIN495      (ERRLIN +  495)    /*        lin.c:1952 */
#define   ELIN496      (ERRLIN +  496)    /*        lin.c:1954 */
#define   ELIN497      (ERRLIN +  497)    /*        lin.c:1960 */
#define   ELIN498      (ERRLIN +  498)    /*        lin.c:1962 */
#define   ELIN499      (ERRLIN +  499)    /*        lin.c:1964 */
#define   ELIN500      (ERRLIN +  500)    /*        lin.c:1966 */
#define   ELIN501      (ERRLIN +  501)    /*        lin.c:1968 */
#define   ELIN502      (ERRLIN +  502)    /*        lin.c:1970 */
#define   ELIN503      (ERRLIN +  503)    /*        lin.c:1972 */
#define   ELIN504      (ERRLIN +  504)    /*        lin.c:1974 */
#define   ELIN505      (ERRLIN +  505)    /*        lin.c:1976 */
#define   ELIN506      (ERRLIN +  506)    /*        lin.c:1978 */
#define   ELIN507      (ERRLIN +  507)    /*        lin.c:1980 */
#define   ELIN508      (ERRLIN +  508)    /*        lin.c:1982 */
#define   ELIN509      (ERRLIN +  509)    /*        lin.c:1984 */
#define   ELIN510      (ERRLIN +  510)    /*        lin.c:1986 */
#define   ELIN511      (ERRLIN +  511)    /*        lin.c:1988 */
#define   ELIN512      (ERRLIN +  512)    /*        lin.c:1990 */
#define   ELIN513      (ERRLIN +  513)    /*        lin.c:1992 */
#define   ELIN514      (ERRLIN +  514)    /*        lin.c:1994 */
#define   ELIN515      (ERRLIN +  515)    /*        lin.c:1997 */
#define   ELIN516      (ERRLIN +  516)    /*        lin.c:2000 */
#define   ELIN517      (ERRLIN +  517)    /*        lin.c:2002 */
#define   ELIN518      (ERRLIN +  518)    /*        lin.c:2004 */
#define   ELIN519      (ERRLIN +  519)    /*        lin.c:2006 */
#define   ELIN520      (ERRLIN +  520)    /*        lin.c:2008 */
#define   ELIN521      (ERRLIN +  521)    /*        lin.c:2011 */
#define   ELIN522      (ERRLIN +  522)    /*        lin.c:2013 */
#define   ELIN523      (ERRLIN +  523)    /*        lin.c:2015 */
#define   ELIN524      (ERRLIN +  524)    /*        lin.c:2017 */
#define   ELIN525      (ERRLIN +  525)    /*        lin.c:2019 */
#define   ELIN526      (ERRLIN +  526)    /*        lin.c:2024 */
#define   ELIN527      (ERRLIN +  527)    /*        lin.c:2074 */
#define   ELIN528      (ERRLIN +  528)    /*        lin.c:2076 */
#define   ELIN529      (ERRLIN +  529)    /*        lin.c:2078 */
#define   ELIN530      (ERRLIN +  530)    /*        lin.c:2080 */
#define   ELIN531      (ERRLIN +  531)    /*        lin.c:2087 */
#define   ELIN532      (ERRLIN +  532)    /*        lin.c:2090 */
#define   ELIN533      (ERRLIN +  533)    /*        lin.c:2094 */
#define   ELIN534      (ERRLIN +  534)    /*        lin.c:2096 */
#define   ELIN535      (ERRLIN +  535)    /*        lin.c:2100 */
#define   ELIN536      (ERRLIN +  536)    /*        lin.c:2102 */
#define   ELIN537      (ERRLIN +  537)    /*        lin.c:2105 */
#define   ELIN538      (ERRLIN +  538)    /*        lin.c:2154 */
#define   ELIN539      (ERRLIN +  539)    /*        lin.c:2156 */
#define   ELIN540      (ERRLIN +  540)    /*        lin.c:2158 */
#define   ELIN541      (ERRLIN +  541)    /*        lin.c:2159 */
#define   ELIN542      (ERRLIN +  542)    /*        lin.c:2160 */
#define   ELIN543      (ERRLIN +  543)    /*        lin.c:2162 */
#define   ELIN544      (ERRLIN +  544)    /*        lin.c:2164 */
#define   ELIN545      (ERRLIN +  545)    /*        lin.c:2165 */
#define   ELIN546      (ERRLIN +  546)    /*        lin.c:2166 */
#define   ELIN547      (ERRLIN +  547)    /*        lin.c:2167 */
#define   ELIN548      (ERRLIN +  548)    /*        lin.c:2168 */
#define   ELIN549      (ERRLIN +  549)    /*        lin.c:2169 */
#define   ELIN550      (ERRLIN +  550)    /*        lin.c:2170 */
#define   ELIN551      (ERRLIN +  551)    /*        lin.c:2171 */
#define   ELIN552      (ERRLIN +  552)    /*        lin.c:2172 */
#define   ELIN553      (ERRLIN +  553)    /*        lin.c:2173 */
#define   ELIN554      (ERRLIN +  554)    /*        lin.c:2174 */
#define   ELIN555      (ERRLIN +  555)    /*        lin.c:2175 */
#define   ELIN556      (ERRLIN +  556)    /*        lin.c:2176 */
#define   ELIN557      (ERRLIN +  557)    /*        lin.c:2177 */
#define   ELIN558      (ERRLIN +  558)    /*        lin.c:2178 */
#define   ELIN559      (ERRLIN +  559)    /*        lin.c:2179 */
#define   ELIN560      (ERRLIN +  560)    /*        lin.c:2180 */
#define   ELIN561      (ERRLIN +  561)    /*        lin.c:2182 */
#define   ELIN562      (ERRLIN +  562)    /*        lin.c:2183 */
#define   ELIN563      (ERRLIN +  563)    /*        lin.c:2184 */
#define   ELIN564      (ERRLIN +  564)    /*        lin.c:2185 */
#define   ELIN565      (ERRLIN +  565)    /*        lin.c:2186 */
#define   ELIN566      (ERRLIN +  566)    /*        lin.c:2187 */
#define   ELIN567      (ERRLIN +  567)    /*        lin.c:2188 */
#define   ELIN568      (ERRLIN +  568)    /*        lin.c:2189 */
#define   ELIN569      (ERRLIN +  569)    /*        lin.c:2190 */
#define   ELIN570      (ERRLIN +  570)    /*        lin.c:2191 */
#define   ELIN571      (ERRLIN +  571)    /*        lin.c:2192 */
#define   ELIN572      (ERRLIN +  572)    /*        lin.c:2193 */
#define   ELIN573      (ERRLIN +  573)    /*        lin.c:2194 */
#define   ELIN574      (ERRLIN +  574)    /*        lin.c:2195 */
#define   ELIN575      (ERRLIN +  575)    /*        lin.c:2196 */
#define   ELIN576      (ERRLIN +  576)    /*        lin.c:2197 */
#define   ELIN577      (ERRLIN +  577)    /*        lin.c:2198 */
#define   ELIN578      (ERRLIN +  578)    /*        lin.c:2199 */
#define   ELIN579      (ERRLIN +  579)    /*        lin.c:2200 */
#define   ELIN580      (ERRLIN +  580)    /*        lin.c:2201 */
#define   ELIN581      (ERRLIN +  581)    /*        lin.c:2202 */
#define   ELIN582      (ERRLIN +  582)    /*        lin.c:2203 */
#define   ELIN583      (ERRLIN +  583)    /*        lin.c:2204 */
#define   ELIN584      (ERRLIN +  584)    /*        lin.c:2205 */
#define   ELIN585      (ERRLIN +  585)    /*        lin.c:2206 */
#define   ELIN586      (ERRLIN +  586)    /*        lin.c:2207 */
#define   ELIN587      (ERRLIN +  587)    /*        lin.c:2208 */
#define   ELIN588      (ERRLIN +  588)    /*        lin.c:2209 */
#define   ELIN589      (ERRLIN +  589)    /*        lin.c:2210 */
#define   ELIN590      (ERRLIN +  590)    /*        lin.c:2211 */
#define   ELIN591      (ERRLIN +  591)    /*        lin.c:2212 */
#define   ELIN592      (ERRLIN +  592)    /*        lin.c:2213 */
#define   ELIN593      (ERRLIN +  593)    /*        lin.c:2214 */
#define   ELIN594      (ERRLIN +  594)    /*        lin.c:2215 */
#define   ELIN595      (ERRLIN +  595)    /*        lin.c:2216 */
#define   ELIN596      (ERRLIN +  596)    /*        lin.c:2217 */
#define   ELIN597      (ERRLIN +  597)    /*        lin.c:2218 */
#define   ELIN598      (ERRLIN +  598)    /*        lin.c:2220 */
#define   ELIN599      (ERRLIN +  599)    /*        lin.c:2221 */
#define   ELIN600      (ERRLIN +  600)    /*        lin.c:2222 */
#define   ELIN601      (ERRLIN +  601)    /*        lin.c:2223 */
#define   ELIN602      (ERRLIN +  602)    /*        lin.c:2224 */
#define   ELIN603      (ERRLIN +  603)    /*        lin.c:2225 */
#define   ELIN604      (ERRLIN +  604)    /*        lin.c:2226 */
#define   ELIN605      (ERRLIN +  605)    /*        lin.c:2227 */
#define   ELIN606      (ERRLIN +  606)    /*        lin.c:2228 */
#define   ELIN607      (ERRLIN +  607)    /*        lin.c:2229 */
#define   ELIN608      (ERRLIN +  608)    /*        lin.c:2230 */
#define   ELIN609      (ERRLIN +  609)    /*        lin.c:2231 */
#define   ELIN610      (ERRLIN +  610)    /*        lin.c:2232 */
#define   ELIN611      (ERRLIN +  611)    /*        lin.c:2233 */
#define   ELIN612      (ERRLIN +  612)    /*        lin.c:2234 */
#define   ELIN613      (ERRLIN +  613)    /*        lin.c:2235 */
#define   ELIN614      (ERRLIN +  614)    /*        lin.c:2236 */
#define   ELIN615      (ERRLIN +  615)    /*        lin.c:2237 */
#define   ELIN616      (ERRLIN +  616)    /*        lin.c:2238 */
#define   ELIN617      (ERRLIN +  617)    /*        lin.c:2239 */
#define   ELIN618      (ERRLIN +  618)    /*        lin.c:2240 */
#define   ELIN619      (ERRLIN +  619)    /*        lin.c:2241 */
#define   ELIN620      (ERRLIN +  620)    /*        lin.c:2242 */
#define   ELIN621      (ERRLIN +  621)    /*        lin.c:2243 */
#define   ELIN622      (ERRLIN +  622)    /*        lin.c:2244 */
#define   ELIN623      (ERRLIN +  623)    /*        lin.c:2245 */
#define   ELIN624      (ERRLIN +  624)    /*        lin.c:2246 */
#define   ELIN625      (ERRLIN +  625)    /*        lin.c:2293 */
#define   ELIN626      (ERRLIN +  626)    /*        lin.c:2295 */
#define   ELIN627      (ERRLIN +  627)    /*        lin.c:2296 */
#define   ELIN628      (ERRLIN +  628)    /*        lin.c:2298 */
#define   ELIN629      (ERRLIN +  629)    /*        lin.c:2299 */
#define   ELIN630      (ERRLIN +  630)    /*        lin.c:2302 */
#define   ELIN631      (ERRLIN +  631)    /*        lin.c:2348 */
#define   ELIN632      (ERRLIN +  632)    /*        lin.c:2349 */
#define   ELIN633      (ERRLIN +  633)    /*        lin.c:2352 */
#define   ELIN634      (ERRLIN +  634)    /*        lin.c:2354 */
#define   ELIN635      (ERRLIN +  635)    /*        lin.c:2359 */
#define   ELIN636      (ERRLIN +  636)    /*        lin.c:2361 */
#define   ELIN637      (ERRLIN +  637)    /*        lin.c:2363 */
#define   ELIN638      (ERRLIN +  638)    /*        lin.c:2405 */
#define   ELIN639      (ERRLIN +  639)    /*        lin.c:2406 */
#define   ELIN640      (ERRLIN +  640)    /*        lin.c:2449 */
#define   ELIN641      (ERRLIN +  641)    /*        lin.c:2450 */
#define   ELIN642      (ERRLIN +  642)    /*        lin.c:2493 */
#define   ELIN643      (ERRLIN +  643)    /*        lin.c:2494 */
#define   ELIN644      (ERRLIN +  644)    /*        lin.c:2496 */
#define   ELIN645      (ERRLIN +  645)    /*        lin.c:2498 */

#endif /* __LINH__ */

  
/********************************************************************30**
 
         End of file:     lin.h@@/main/10 - Wed May 23 17:03:44 2001
    
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---   bn   1. initial release.

3.1          ---   bn   1. text changes.

3.2          ---   bn   1. text changes.

3.3          ---   krp  1. Added defines for Unsolicited Management status 
                           report during terminal initialisation.

*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
3.4          ---      sb   1. Text changes.

3.5          ---      sb   2. Corrected error in comments. 

3.6          ---      sb   1. Added constants for facility handling
                              mechanisms.
             ---      sb   2. Defined constants for call independent 
                              signalling.

3.7          ---      sam  1. Added modem types for Australia Telecom.

3.8          ---      sam  1. Changed MAXBCHNL to 32.
             ---      sam  2. Added defines for SW_NTNI and SW_NTMCI.
             ---      sam  3. Added defines for enable/disable channel.
             ---      sb   4. Text changes
             ---      sam  5. Added defines for delay bind.
             ---      sam  6. Changed value of EVTLINCNTRLREQ to 57.

3.9          ---      pk   1. Added defines for D Chnl out of service
                              and disc confirm received.
                           2. Added define for interface.
                           3. Added defines for channel provisioned/not
                              provisioned.


3.10         ---      pk   1. Added LCM_EVENT_ENDPT_INIT.
            in021.310 cy   2. Changed MAXBCHNL to 255 to support VTOA.
                           3. Added LCM_EVENT_INSERVICE.
/main/10     ---      cy   1. Updated for new release.
            in009.311 bn   1. Corrected defines for modem types.

*********************************************************************91*/
