/*******************************************************************************
*
* Title: lcc.x
*
* Description:  call control layer externals
*
* Written By: Konrad Hammel (konrad@sangoma.com)
*
* Date: <date>
*
*******************************************************************************/
#ifndef __LCC_X__
#define __LCC_X__
/******************************************************************************/

/* INCLUDES *******************************************************************/
/******************************************************************************/

/* DEFINES ********************************************************************/
/******************************************************************************/

/* GLOBALS ********************************************************************/
typedef struct CcGenCfg
{
    /*Dpc     spc;*/
    Status  poolTrLower;          /* lower pool threshold */
    Status  poolTrUpper;          /* upper pool threshold */
    Pst     smPst;                      /* stack manager */
    U8	    nmbSaps;		/* Number of saps */
} CcGenCfg_t;

typedef struct cc_isap
{
    SpId    suId;
    SpId    spId;
    Pst     pst;
    U8	    swtch;
    U8	    sapType;
} CcIsapCfg_t;

typedef struct CcMngmt
{
    Header hdr;
    CmStatus cfm;

    union
    {

        /*configuration*/
        struct
        {
            union
            {
                CcGenCfg_t     ccGenCfg;
                CcIsapCfg_t       ccISAP; /* rename this to ccIsapCfg */
            }s;
        }cfg;

        /*statistics*/

        /*solicited status*/

        /*unsolicited status*/
        struct
        {
            CmAlarm alarm;         /* common alarm structure */
            U8 evntParm[8];        /* event parameters */
        } usta;                   /* unsolicited status */

        /*trace*/

        /*control*/
        struct
        {
            DateTime dt;           /* date and time */
            U8 action;             /* action */
            U8 subAction;          /* sub action */
	    U8 sapId;
        } cntrl;                  /* control */
    }t;
} CcMngmt;
/******************************************************************************/

/* FUNCTION PROTOTYPES ********************************************************/
EXTERN S16 ccActvInit      	ARGS((Ent entity,Inst inst,Region region,Reason reason));
EXTERN S16 ccActvTskNew    	ARGS(( Pst *pst, Buffer *mBuf));
EXTERN S16 smCcActvTsk      	ARGS((Pst *pst, Buffer *mBuf));
EXTERN S16 smCcActvInit     	ARGS((Ent ent, Inst inst, Region region, Reason reason));
EXTERN S16 smAlActvTsk      	ARGS((Pst *pst, Buffer *mBuf));

EXTERN S16 CcLiIntBndReq	ARGS((Pst *pst, SuId suId, SpId spId));
EXTERN S16 CcLiIntBndCfm	ARGS((Pst *pst, SuId suId, Status status));

EXTERN S16 CcLiIntConReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN S16 CcLiIntConCfm 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces));

EXTERN S16 CcLiIntConInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN S16 CcLiIntConRsp 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes, Ces ces));

EXTERN S16 CcLiIntCnStReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces ces));
EXTERN S16 CcLiIntCnStInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces ces));

EXTERN S16 CcLiIntSetupComp	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, CnStEvnt *cnStEvnt,SuId dChan, Ces ces));

EXTERN S16 CcLiIntDiscReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, DiscEvnt *discEvnt));
EXTERN S16 CcLiIntDiscInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, DiscEvnt *discEvnt));

EXTERN S16 CcLiIntRelReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, RelEvnt *relEvnt));
EXTERN S16 CcLiIntRelInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, RelEvnt *relEvnt));

EXTERN S16 CcLiIntDatReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN S16 CcLiIntDatInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, InfoEvnt *infoEvnt));

EXTERN S16 CcLiIntSsHlReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN S16 CcLiIntSsHlInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN S16 CcLiIntSsHlRsp 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN S16 CcLiIntSsHlCfm 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));

EXTERN S16 CcLiIntRmRtReq	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan, Ces ces));
EXTERN S16 CcLiIntRmRtInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN S16 CcLiIntRmRtRsp 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN S16 CcLiIntRmRtCfm 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));

EXTERN S16 CcLiIntFacReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));
EXTERN S16 CcLiIntFacInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));

EXTERN S16 CcLiIntFlcReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, StaEvnt *staEvnt));
EXTERN S16 CcLiIntFlcInd 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, StaEvnt *staEvnt));

EXTERN S16 CcLiIntStaReq 	ARGS((Pst *pst, SpId spId, UConnId suInstId, UConnId spInstId, StaEvnt *staEvnt, U8 evntType));
EXTERN S16 CcLiIntStaCfm 	ARGS((Pst *pst, SuId suId, UConnId suInstId, UConnId spInstId, StaEvnt *staEvnt));

EXTERN S16 CcLiIntSrvReq 	ARGS((Pst *pst, SpId spId, Srv *srvEvnt, SuId dChan, Ces ces));
EXTERN S16 CcLiIntSrvInd 	ARGS((Pst *pst, SuId suId, Srv *srvEvnt, SuId dChan, Ces ces));
EXTERN S16 CcLiIntSrvCfm 	ARGS((Pst *pst, SuId suId, Srv *srvEvnt, SuId dChan, Ces ces));

EXTERN S16 CcLiIntRstReq 	ARGS((Pst *pst, SpId spId, Rst *rstEvnt,SuId dChan, Ces ces, U8 reqType)); 
EXTERN S16 CcLiIntRstCfm 	ARGS((Pst *pst, SuId suId, Rst *rstEvnt, SuId dChan, Ces ces, U8 evtType)); 
EXTERN S16 CcLiIntRstInd 	ARGS((Pst *pst, SuId suId, Rst *rstEvnt, SuId dChan, Ces ces, U8 evtType)); 

typedef S16 (*LccCfgReq)    ARGS((Pst *pst,CcMngmt *cfg));
typedef S16 (*LccCfgCfm)    ARGS((Pst *pst,CcMngmt *cfm));
typedef S16 (*LccCntrlReq)  ARGS((Pst *pst,CcMngmt *cntrl));
typedef S16 (*LccCntrlCfm)  ARGS((Pst *pst,CcMngmt *cfm));
typedef S16 (*LccStaReq)    ARGS((Pst *pst,CcMngmt *sta));
typedef S16 (*LccStaInd)    ARGS((Pst *pst,CcMngmt *sta));
typedef S16 (*LccStaCfm)    ARGS((Pst *pst,CcMngmt *sta));
typedef S16 (*LccStsReq)    ARGS((Pst *pst, Action action,CcMngmt *sts));
typedef S16 (*LccStsCfm)    ARGS((Pst *pst, Action action, CcMngmt *sts));
typedef S16 (*LccTrcInd)    ARGS((Pst *pst,CcMngmt *trc));


/* Call Control Management ****************************************************/
EXTERN  S16 CcMiLccCfgReq   ARGS((Pst *pst, CcMngmt *cfg));
EXTERN  S16 CcMiLccCfgCfm   ARGS((Pst *pst, CcMngmt *cfm));

EXTERN  S16 CcMiLccCntrlReq ARGS((Pst *pst, CcMngmt *cntrl));
EXTERN  S16 CcMiLccCntrlCfm ARGS((Pst *pst, CcMngmt *cfm));

EXTERN  S16 CcMiLccStaReq	ARGS((Pst *pst, CcMngmt *sta));
EXTERN  S16 CcMiLccStaInd   ARGS((Pst *pst, CcMngmt *sta));
EXTERN  S16 CcMiLccStaCfm   ARGS((Pst *pst, CcMngmt *sta));

EXTERN  S16 CcMiLccStsReq   ARGS((Pst *pst, Action action, CcMngmt *sts));
EXTERN  S16 CcMiLccStsCfm   ARGS((Pst *pst, Action action, CcMngmt *sts));

EXTERN  S16 CcMiLccTrcInd   ARGS((Pst *pst, CcMngmt *trc));

/* Stack Manager Management ***************************************************/
EXTERN  S16 SmMiLccCfgReq       ARGS((Pst *pst, CcMngmt *cfg));
EXTERN  S16 SmMiLccCfgCfm       ARGS((Pst *pst, CcMngmt *cfm));

EXTERN  S16 SmMiLccCntrlReq     ARGS((Pst *pst, CcMngmt *cntrl));
EXTERN  S16 SmMiLccCntrlCfm     ARGS((Pst *pst, CcMngmt *cfm));

EXTERN  S16 SmMiLccStaInd       ARGS((Pst *pst, CcMngmt *sta));
/*EXTERN  S16 SmMiLccStaCfm     ARGS((Pst *pst, CcMngmt *sta));*/

/*EXTERN  S16 SmMiLccStsCfm     ARGS((Pst *pst, Action action, CcMngmt *sts));*/
/*EXTERN  S16 SmMiLccStaReq     ARGS((Pst *pst, CcMngmt *sta));*/
/*EXTERN  S16 SmMiLccStsReq     ARGS((Pst *pst, Action action, CcMngmt *sts));*/

/*EXTERN  S16 SmMiLccTrcInd     ARGS((Pst *pst, CcMngmt *trc));*/

/* pack ***********************************************************************/
EXTERN S16 cmPkLccCfgReq        ARGS((Pst *pst, CcMngmt *cfg));
EXTERN S16 cmPkLccCfgCfm        ARGS((Pst *pst, CcMngmt *cfm));

EXTERN S16 cmPkLccCntrlReq      ARGS((Pst *pst, CcMngmt *cntrl));
EXTERN S16 cmPkLccCntrlCfm      ARGS((Pst *pst, CcMngmt *cfm));

EXTERN S16 cmPkLccStaReq        ARGS((Pst *pst, CcMngmt *sta));
EXTERN S16 cmPkLccStaInd        ARGS((Pst *pst, CcMngmt *sta));
EXTERN S16 cmPkLccStaCfm        ARGS((Pst *pst, CcMngmt *sta));

EXTERN S16 cmPkLccStsReq        ARGS((Pst *pst, Action action, CcMngmt *sts));
EXTERN S16 cmPkLccStsCfm        ARGS((Pst *pst, Action action, CcMngmt *sts));

EXTERN S16 cmPkLccTrcInd        ARGS((Pst *pst, CcMngmt *trc));

/* unpack *********************************************************************/
EXTERN S16 cmUnpkLccCfgReq      ARGS((LccCfgReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLccCfgCfm      ARGS((LccCfgCfm func, Pst *pst, Buffer *mBuf));

EXTERN S16 cmUnpkLccCntrlReq    ARGS((LccCntrlReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLccCntrlCfm    ARGS((LccCntrlCfm func, Pst *pst, Buffer *mBuf));

EXTERN S16 cmUnpkLccStaReq      ARGS((LccStaReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLccStaInd      ARGS((LccStaInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLccStaCfm      ARGS((LccStaCfm func, Pst *pst, Buffer *mBuf));

EXTERN S16 cmUnpkLccStsReq      ARGS((LccStsReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLccStsCfm      ARGS((LccStsCfm func, Pst *pst, Buffer *mBuf));

EXTERN S16 cmUnpkLccTrcInd      ARGS((LccTrcInd func, Pst *pst, Buffer *mBuf));

/******************************************************************************/

/******************************************************************************/
#endif /* __LCC_X__ */
/******************************************************************************/

