/********************************************************************16**

        (c) COPYRIGHT 1989-2000 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:     layer management interface - data link layer
  
     Type:     C include file
  
     Desc:     Structures, variables and typedefs required by the
               layer management service user.
 
     File:     lbd.x
  
     Sid:      lbd.x@@/main/1 - Tue Jan  9 13:59:13 2001
    
     Prg:      mc
 
*********************************************************************21*/
  
#ifndef __LBDX__
#define __LBDX__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000002     Data Link Layer - LAPB 
*     1000003     Data Link Layer - LAPD 
*     1000005     Data Link Layer - LAPB & LAPD
*
*/
 

/* typedefs */

/* lapb and lapd */

/* bdGenCfg structure */
typedef struct bdGenCfg         /* lapb/lapd/frame relay
                                   general configuration */ 
{          
   S32 nmbPLnks;                /* number of Physical Links */
   S16 nmbLDLnks;               /* number of LAPD links */ 
   S16 nmbDLCs;                 /* total number of data link connections */
   S16 nmbASPLnks;              /* number of ASP links */
   Status poolTrLower;          /* lower pool threshold */
   Status poolTrUpper;          /* upper pool threshold */
#ifdef LAPD_3_4
   S16 timeRes;                 /* timer resolution */
#endif /* LAPD_3_4 */
   Pst sm;                      /* stack manager */
} BdGenCfg;
   
/* bdSAPCfg (DLSAP) structure */
typedef struct bdSAPCfg         /* lapb/lapd data link SAP configuration */
{
#if (SMBD_LMINT3 || BD_LMINT3)
   LnkNmb lnkNmb;               /* link number */
   Sapi sapi;                   /* SAPI number */
#endif /* _LMINT3 */
   S16 n201;                    /* frame length */
   U8 k;                        /* window size */
   S16 n200;                    /* retransmission count */
   S16 congTmr;                 /* congestion timer */
   S16 t200Tmr;                 /* t1 timer */
   S16 t203Tmr;                 /* t3 timer */
   S16 t2Tmr;                   /* t2 timer for lapb only */
   U8 mod;                      /* modulo */
   U8 teiAss;                   /* TEI Assignment */
   S16 noOfDlc;                 /* Number of DLCs */
   Tei tei[MAX_CES];            /* ces-tei association */
   Selector selector;           /* upper layer selector */
   MemoryId mem;                /* memory region and pool id */
   Priority prior;              /* priority */
   Route route;                 /* route */
} BdSAPCfg;

/* bdMSAPCfg (MSAP) structure */
typedef struct bdMSAPCfg        /* lapb/lapd MAC SAP configuration */
{
#if (SMBD_LMINT3 || BD_LMINT3)
   LnkNmb lnkNmb;               /* link number */
#endif /* _LMINT3 */
   U8 lap;                      /* lapb or lapd */
   U8 logInt;                   /* Logical interface */
   U8 setUpArb;                 /* Set Up Arbitration logic */
   U8 type;                     /* type of protocol */
   U8 maxOutsFrms;              /* maximum outstanding frames */
   QLen tQUpperTrs;             /* transmit queue upper threshold */
   QLen tQLowerTrs;             /* transmit queue lower threshold */
#ifdef MACINTN
   U8  bndRetryCnt;             /* bind retry counter */
   S16 tIntTmr;                 /* bind timer */
#endif /* MACINTN */
   S16 conTmr;                  /* connection timer */
   S32 t201Tmr;                 /* T201 timer */
   S32 t202Tmr;                 /* T202 timer */
   S32 teiChkTmr;               /* tei check procedure timer */
   S16 n202;                    /* N202 */
   Tei lowTei;                  /* lowest Dynamic TEI */
   Bool kpL1Up;                 /* flag to keep layer1 up or not */
   ProcId dstProcId;            /* destination processor id */
   Ent dstEnt;                  /* entity */
   Inst dstInst;                /* instance */
   Priority prior;              /* priority */
   Route route;                 /* route */
   Selector selector;           /* lower layer selector */
   MemoryId mem;                /* memory region and pool id */
} BdMSAPCfg;

  
/* lapb and lapd */

/* bdSAPSts structure */
typedef struct bdSAPSts         /* lapb/lapd statistics */
{
   Cntr iTx;                    /* information frames transmitted */
   Cntr rrTx;                   /* receive ready frames transmitted */
   Cntr rnrTx;                  /* receive not ready frames transmitted */
   Cntr rejTx;                  /* reject frames transmitted */
   Cntr sabmTx;                 /* set asynchronous balanced mode frames transmitted */
   Cntr discTx;                 /* disconnect frames transmitted */
   Cntr uaTx;                   /* unumbered acknowledge frames transmitted */
   Cntr dmTx;                   /* disconnect mode frames transmitted */
   Cntr frmrTx;                 /* frame reject frames transmitted */
   Cntr xidTx;                  /* exchange id frames transmitted */
   Cntr uiTx;                   /* unumbered information frames transmitted */
  
   Cntr iRx;                    /* information frames received */
   Cntr rrRx;                   /* receive ready frames received */
   Cntr rnrRx;                  /* receive not ready frames received */
   Cntr rejRx;                  /* reject frames received */
   Cntr sabmRx;                 /* set asynchronous balanced mode frames received */
   Cntr discRx;                 /* disconnect frames received */
   Cntr uaRx;                   /* unumbered acknowledge frames received */
   Cntr dmRx;                   /* disconnect mode frames received */
   Cntr frmrRx;                 /* frame reject frames received */
   Cntr xidRx;                  /* exchange id frames received */
   Cntr uiRx;                   /* unumbered information frames received */
  
   Cntr invRx;                  /* invalid frames received */
   Cntr sabmErr;                /* sabm errors */
   Cntr frmrErr;                /* frame reject errors */
} BdSAPSts;
   
  
/* lapb and lapd */

/* bdSAPSta structure */
typedef struct bdSAPSta         /* lapb / lapd - SAP status */
{
   U8 hlSt;                     /* sap state */
   U8 psOutsFrm;                /* outstanding frames to MAC */
   S16 cntMaDrop;               /* frames dropped by MAC */
   U8 lclBsy;                   /* local busy */
   Bool remBsy;                 /* remote busy */
   U8 vs;                       /* VS */
   U8 vr;                       /* VR */
   U8 llmSt;                    /* link level matrix state */
   U8 flcSt;                    /* flow control state */
   S16 rtxCnt;                  /* retransmission count */
   QLen qSize;                  /* queue size */
   S16 actSaps;                 /* active saps */
   S16 openDLC;                 /* open DLCs */
} BdSAPSta;

/* bdDbgCntrl structure - run time debug info print control */
#ifdef DEBUGP
typedef struct bdDbgCntrl
{
   U32 dbgMask;                 /* debug mask */
} BdDbgCntrl;
#endif /* DEBUGP */

  
/* management message */
typedef struct bdMngmt
{
   Header hdr;                  /* header */

#if (BD_LMINT3 || SMBD_LMINT3)
   CmStatus cfm;              /* confirmation status structure */
#endif /* _LMINT3 */

   union {

      /* configuration */
      struct
      {
         union
         {
            BdGenCfg  bdGen;    /* lapb/lapd/frame relay - general */
            BdSAPCfg  bdDLSAP;  /* lapb/lapd - data link SAP */
            BdMSAPCfg bdMSAP;   /* lapb/lapd - MAC SAP */
          } s;
      } cfg;                           /* configuration */
  
      /* statistics */
      struct
      {
         DateTime dt;           /* date and time */
         Duration dura;         /* duration */
#if (SMBD_LMINT3 || BD_LMINT3)
         LnkNmb lnkNmb;         /* link number */
#endif /* _LMINT3 */
         union
         {
            BdSAPSts bdMSAP;    /* lapb/lapd - MAC SAP */
        } s;
      } sts;                    /* statistics */
  
  
      /* solicited status */
      struct
      {
         DateTime dt;           /* date and time */
#if (SMBD_LMINT3 || BD_LMINT3)
         LnkNmb lnkNmb;         /* link number */
         Sapi sapi;             /* SAPI number */
         Tei tei;               /* TEI value */
#endif /* _LMINT3 */
         union
         {
            SystemId sysId;     /* system id */
            BdSAPSta bdDLSAP;   /* lapb / lapd - data link SAP */   
         } s;
      } ssta;                   /* solicited status */
  
  
      /* unsolicited status */
      struct
      {
#if (BD_LMINT3 || SMBD_LMINT3)
         CmAlarm alarm;         /* generic alarm information */
         LnkNmb lnkNmb;         /* link number */
#else /* _LMINT3 */
         DateTime dt;           /* date and time */
         U16 evnt;              /* event number */
#endif /* _LMINT3 */
         U8 evntParm[8];        /* event parameters */
      } usta;                   /* unsolicited status */

      /* trace */
      struct
      {
         DateTime dt;           /* date and time */
#if (BD_LMINT3 || SMBD_LMINT3)
         LnkNmb lnkNmb;         /* link number */
         Sapi sapi;             /* SAPI number */
         Tei tei;               /* TEI value */
#endif /* _LMINT3 */
         U16 evnt;              /* event */
      } trc;                    /* trace */

      /* control */
      struct
      {
         DateTime dt;           /* date and time */
         U8 action;             /* action */
         U8 subAction;          /* sub action */
#if (SMBD_LMINT3 || BD_LMINT3)
         LnkNmb lnkNmb;         /* link number */
         Sapi sapi;             /* SAPI number */
         Tei tei;               /* TEI value */
#endif /* _LMINT3 */
         U8  logInt;            /* logical interface type */
         S16 trcLen;            /* trace length */
         union
         {
            ProcId dstProcId;   /* destination processor id */
         }par;
#ifdef DEBUGP
         union
         {
            BdDbgCntrl bdDbg;   /* general control - debug */
         } s;
#endif /* DEBUGP */
      } cntrl;                  /* control */
 
   }t;
} BdMngmt;


/* depending on the specific selector in the post structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */
 
typedef S16 (*LbdStaInd)   ARGS((Pst *pst, BdMngmt *sta));
typedef S16 (*LbdStaCfm)   ARGS((Pst *pst, BdMngmt *sta));
typedef S16 (*LbdStsCfm)   ARGS((Pst *pst, Action action, BdMngmt *sts));
typedef S16 (*LbdCfgReq)   ARGS((Pst *pst, BdMngmt *cfg));
typedef S16 (*LbdStaReq)   ARGS((Pst *pst, BdMngmt *sta));
typedef S16 (*LbdStsReq)   ARGS((Pst *pst, Action action, BdMngmt *sts));
typedef S16 (*LbdCntrlReq) ARGS((Pst *pst, BdMngmt *cntrl));
typedef S16 (*LbdTrcInd)   ARGS((Pst *pst, BdMngmt *trc, Buffer *mBuf));
typedef S16 (*LbdXidReq)   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));
typedef S16 (*LbdXidRsp)   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));
typedef S16 (*LbdXidInd)   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));
typedef S16 (*LbdXidCfm)   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));

#if (BD_LMINT3 || SMBD_LMINT3)
typedef S16 (*LbdCntrlCfm) ARGS((Pst *pst, BdMngmt *cfm));
typedef S16 (*LbdCfgCfm)   ARGS((Pst *pst, BdMngmt *cfm));
#endif /* _LMINT3 */

EXTERN  S16 BdMiLbdCfgReq   ARGS((Pst *pst, BdMngmt *cfg));
EXTERN  S16 BdMiLbdStaReq   ARGS((Pst *pst, BdMngmt *sta));
EXTERN  S16 BdMiLbdStsReq   ARGS((Pst *pst, Action action, BdMngmt *sts));
EXTERN  S16 BdMiLbdCntrlReq ARGS((Pst *pst, BdMngmt *cntrl));
EXTERN  S16 BdMiLbdStaInd   ARGS((Pst *pst, BdMngmt *sta));
EXTERN  S16 BdMiLbdStaCfm   ARGS((Pst *pst, BdMngmt *sta));
EXTERN  S16 BdMiLbdStsCfm   ARGS((Pst *pst, Action action, BdMngmt *sts));
EXTERN  S16 BdMiLbdTrcInd   ARGS((Pst *pst, BdMngmt *trc, Buffer *mBuf));

#if (BD_LMINT3 || SMBD_LMINT3)
EXTERN S16 BdMiLbdCntrlCfm ARGS((Pst *pst, BdMngmt *cfm));
EXTERN S16 BdMiLbdCfgCfm   ARGS((Pst *pst, BdMngmt *cfm));
#endif /* _LMINT3 */

#ifdef BD       /* lapb and lapd */
EXTERN  S16 BdMiLbdXidReq ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidRsp ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidInd ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidCfm ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 MBDAssInd     ARGS((LnkNmb lnkNmb, Sapi sapi, Ces ces));
EXTERN  S16 MBDAssReq     ARGS((LnkNmb lnkNmb, Sapi sapi, Ces ces, Tei tei));
EXTERN  S16 MBDRemReq     ARGS((LnkNmb lnkNmb, Sapi sapi, Tei tei));
EXTERN  S16 MBDUDatReq    ARGS((LnkNmb lnkNmb, Buffer *mBuf));
EXTERN  S16 MBDUDatInd    ARGS((LnkNmb lnkNmb, Buffer *mBuf));
EXTERN  S16 MBDErrRsp     ARGS((LnkNmb lnkNmb, Sapi sapi, Ces ces));
#endif

#ifdef LD       /* lapd */
EXTERN  S16 BdMiLbdXidReq ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidRsp ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidInd ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidCfm ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 MBDAssInd     ARGS((LnkNmb lnkNmb, Sapi sapi, Ces ces));
EXTERN  S16 MBDVrfyReq    ARGS((LnkNmb lnkNmb, Sapi sapi, Ces ces));
EXTERN  S16 MBDAssReq     ARGS((LnkNmb lnkNmb, Sapi sapi, Ces ces, Tei tei));
EXTERN  S16 MBDRemReq     ARGS((LnkNmb lnkNmb, Sapi sapi, Tei tei));
EXTERN  S16 MBDUDatReq    ARGS((LnkNmb lnkNmb, Buffer *mBuf));
EXTERN  S16 MBDUDatInd    ARGS((LnkNmb lnkNmb, Buffer *mBuf));
EXTERN  S16 MBDErrRsp     ARGS((LnkNmb lnkNmb, Sapi sapi, Ces ces));
#ifdef LMLD
EXTERN  Void bdTeiChkProc ARGS((Tei tei));
EXTERN  Void bdTeiVrfyProc ARGS((Tei tei));
#endif /* LMLD */
#endif /* LD */

#ifdef LB       /* lapb */
/* following externs are for version 2.x and greater of lapb */
EXTERN  S16 BdMiLbdXidReq ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidRsp ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidInd ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN  S16 BdMiLbdXidCfm ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
#endif

#ifdef SM
EXTERN  S16 SmMiLbdCfgReq   ARGS((Pst *pst, BdMngmt *cfg));
EXTERN  S16 SmMiLbdStaReq   ARGS((Pst *pst, BdMngmt *sta));
EXTERN  S16 SmMiLbdStsReq   ARGS((Pst *pst, Action action, BdMngmt *sts));
EXTERN  S16 SmMiLbdCntrlReq ARGS((Pst *pst, BdMngmt *cntrl));
EXTERN  S16 SmMiLbdStaInd   ARGS((Pst *pst, BdMngmt *sta));
EXTERN  S16 SmMiLbdStaCfm   ARGS((Pst *pst, BdMngmt *sta));
EXTERN  S16 SmMiLbdStsCfm   ARGS((Pst *pst, Action action, BdMngmt *sts));
EXTERN  S16 SmMiLbdTrcInd   ARGS((Pst *pst, BdMngmt *trc, Buffer *mBuf));
EXTERN  S16 SmMiLbdXidReq   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));
EXTERN  S16 SmMiLbdXidRsp   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));
EXTERN  S16 SmMiLbdXidInd   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));
EXTERN  S16 SmMiLbdXidCfm   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Ces ces, Buffer *mBuf));
#if (BD_LMINT3 || SMBD_LMINT3)
EXTERN S16 SmMiLbdCfgCfm   ARGS((Pst *pst, BdMngmt *cfm));
EXTERN S16 SmMiLbdCntrlCfm ARGS((Pst *pst, BdMngmt *cfm));
#endif /* _LMINT3 */
#endif /* SM */

/* stack manager initialization function */
EXTERN S16 smBdActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));
EXTERN S16 smLdActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));
EXTERN S16 smLbActvInit ARGS((Ent ent, Inst inst, Region region, Reason reason));

/* stack manager activation function */
EXTERN S16 smBdActvTsk ARGS((Pst *pst, Buffer *mBuf));
EXTERN S16 smLdActvTsk ARGS((Pst *pst, Buffer *mBuf));
EXTERN S16 smLbActvTsk ARGS((Pst *pst, Buffer *mBuf));

#ifdef LCLBD
/* packing functions for primitives: LD to SM */
EXTERN S16 cmPkLbdStaInd ARGS((Pst *pst, BdMngmt *sta));
EXTERN S16 cmPkLbdStaCfm ARGS((Pst *pst, BdMngmt *sta));
EXTERN S16 cmPkLbdTrcInd ARGS((Pst *pst, BdMngmt *trc, Buffer *mBuf));
EXTERN S16 cmPkLbdStsCfm ARGS((Pst *pst, Action action, BdMngmt *sts));
EXTERN S16 cmPkLbdXidInd ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));
EXTERN S16 cmPkLbdXidCfm ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf));

/* packing functions for primitives: SM to LD */
EXTERN S16 cmPkLbdCfgReq   ARGS((Pst *pst, BdMngmt *cfg ));
EXTERN S16 cmPkLbdStaReq   ARGS((Pst *pst, BdMngmt *sta ));
EXTERN S16 cmPkLbdCntrlReq ARGS((Pst *pst, BdMngmt *cntrl ));
EXTERN S16 cmPkLbdStsReq   ARGS((Pst *pst, Action action, BdMngmt *sts ));
EXTERN S16 cmPkLbdXidReq   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf ));
EXTERN S16 cmPkLbdXidRsp   ARGS((Pst *pst, LnkNmb lnkNmb, Sapi sapi, Tei tei, Buffer *mBuf ));
#if (BD_LMINT3 || SMBD_LMINT3)
EXTERN S16 cmPkLbdCfgCfm   ARGS((Pst *pst, BdMngmt *cfm));
EXTERN S16 cmPkLbdCntrlCfm ARGS((Pst *pst, BdMngmt *cfm));
#endif /* (BD_LMINT3 || SMBD_LMINT3) */

/* unpacking functions for primitives: SM to LD */
EXTERN S16 cmUnpkLbdCfgReq   ARGS((LbdCfgReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdStaReq   ARGS((LbdStaReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdStsReq   ARGS((LbdStsReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdXidReq   ARGS((LbdXidReq func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdXidRsp   ARGS((LbdXidRsp func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdCntrlReq ARGS((LbdCntrlReq func, Pst *pst, Buffer *mBuf));

/* unpacking functions for primitives: LD to SM */
EXTERN S16 cmUnpkLbdStaCfm ARGS((LbdStaCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdStsCfm ARGS((LbdStsCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdStaInd ARGS((LbdStaInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdTrcInd ARGS((LbdTrcInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdXidInd ARGS((LbdXidInd func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdXidCfm ARGS((LbdXidCfm func, Pst *pst, Buffer *mBuf));

#if (SMBD_LMINT3 || BD_LMINT3)
EXTERN S16 cmUnpkLbdCfgCfm   ARGS((LbdCfgCfm func, Pst *pst, Buffer *mBuf));
EXTERN S16 cmUnpkLbdCntrlCfm ARGS((LbdCntrlCfm func, Pst *pst, Buffer *mBuf));
#endif /* SMBD_LMINT3 */
#endif /* LCLBD */

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __LBDX__ */
 

/********************************************************************30**
  
         End of file:     lbd.x@@/main/1 - Tue Jan  9 13:59:13 2001
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  mc    1. initial release

1.2          ---  mc    1. remove ifdefs

1.3          ---  mc    1. remove throughput from BrDlcCfg and ErDlcCfg.
             ---  mc    2. remove lap from ErMSAPCfg.
             ---  mc    3. correct ErSAPSta structure.

1.4          ---  mc    1. remove throughput

1.5          ---  mc    1. add congCnt to ErSAPSta.

1.6          ---  mc    1. remove ER and BR.
             ---  mc    1. added kpL1Up to BdMSAPCfg. (bd, ld)

1.7          ---  mc    1. removed nmbDLCperSAP and teiChkTmr from BdGenCfg
                           and teiAss and singleTei from BdMSAPCfg.
             ---  mc    2. removed LbdAlrtInd and br, er stuff.
1.7+    ld032.33  sam   1. Changes for ISDN stack testing. Included within
                           IN_FTHA_TEST. Same as ld031.33 in gen 01.
*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
/main/1      ---      mr   1. modified for 3.4 release.
  
*********************************************************************91*/

