/********************************************************************16**

        (c) COPYRIGHT 1989-2000 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**
  
     Name:     layer management interface - data link layer
  
     Type:     C include file
  
     Desc:     Defines required by the layer management service user.
  
     File:     lbd.h
  
     Sid:      lbd.h@@/main/1 - Tue Jan  9 13:59:07 2001
     
     Prg:      mc
  
*********************************************************************21*/
  
#ifndef __LBDH_
#define __LBDH_
 

/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000002     Data Link Layer - LAPB 
*     1000003     Data Link Layer - LAPD 
*     1000004     Data Link Layer - Multilink 
*     1000005     Data Link Layer - LAPB & LAPD
*
*/
 

/* defines */
  
/* isdn switch defines */

#define SW_TST           0           /* switch - test */
#define SW_CCITT         1           /* switch - ccitt */
#define SW_ATT5EB        2           /* switch - att 5ess BRA */
#define SW_ATT5EP        3           /* switch - att 5ess PRA */
#define SW_ATT4E         4           /* switch - att 4ess */
#define SW_NTDMS100B     5           /* switch - nt dms100 BRA */
#define SW_NTDMS100P     6           /* switch - nt dms100 PRA */
#define SW_VN2           7           /* switch - vn 2 */
#define SW_VN3           7           /* switch - vn 3 */
#define SW_INSNET        8           /* switch - ins - net */
#define SW_TR6MPC        9           /* switch - 1 - tr6mpc  */
#define SW_TR6PBX       10           /* switch - 1 - tr6pbx  */
#define SW_AUSB         11           /* switch - austel basic */
#define SW_AUSP         12           /* switch - austel primary */
#define SW_NI1          13           /* switch - national isdn-1 */
#define SW_ETSI         14           /* switch - etsi */
#define SW_BC303TMC     15           /* switch - bellcorp tr303 tmc */
#define SW_BC303CSC     16           /* switch - bellcorp tr303 csc */
#define SW_NTDMS250     17           /* switch - nt dms250 */
#define SW_NI2          18           /* switch - national isdn-2 */
#define SW_BELLCORE     22           /* switch - bellcore */
#define SW_GSM          23           /* used by GSM */

/* defines for MBDCfgReq */

#define MAX_HDR_SZ       4           /* maximum dlci size */
#define MAX_DLCI         8           /* maximum number of dlci per link */
#define MAX_MC_MEMBERS   8           /* maximum number of members 
                                     in a multicast group */
#define PNT_TO_PNT       1           /* point to point routing */
#define MULTICAST        2           /* multicast */
#define BROADCAST        3           /* broadcast */
#define NOT_CFG         -1           /* not configured */
#define LMI0990          1           /* lmi standard */
#define LMI              1           /* lmi standard */
#define ANNEX_D          2           /* Annex D standard */
#define LMI_HDR_FF   0x3ff           /* lmi dlci (all ones) */
#define LMI_HDR_00       0           /* lmi dlci (all zeros) */

#define BASIC            0           /* basic frame relay */
#define EXTENDED         1           /* extended frame relay */

#define MODULO_8         8           /* Modulo 8 */
#define MODULO_128     128           /* Modulo 128 */

#define PASSIVE          0           /* passive: wait for SABM */
#define ACTIVE           1           /* active: send SABM */

#define LGCL_DTE         0           /* Logical DTE */
#define LGCL_DCE         1           /* Logical DCE */

#define MULTIPLE_TEI     0           /* multiple TEI */
#define SINGLE_TEI       1           /* single TEI */
/* ld012.304 for GSM LD_48056 for dinamic TEI assignment below values has to be
   changed from 64 to 0 LOW_TEI_RNG  and MAX_CES to 127 from 64 */
#ifdef LD_48056
#define LOW_TEI_RNG      64          /* low tei range */
#define MAX_CES          64          /* maximum number of ces */
#else
#define LOW_TEI_RNG      64          /* low tei range */
#define MAX_CES          64          /* maximum number of ces */
#endif

#define NON_AUTOMATIC    0           /* non automatic TEI assignment */
#define AUTOMATIC        1           /* automatic TEI assignment */

#define LOW_PRIOR        1           /* low priority */
#define HI_PRIOR         2           /* high priority */

#define TO_USER          0           /* interface to user */
#define TO_NETWORK       1           /* interface to network */
 
/* defines for MBDStsReq */

#define NO_SAP           1           /* return code for MxxStsReq */

/* defines for MBDXidRxx */

#define XID_NOT_TX       1            /* XID not Transmitted */

/* defines for MBDTrcInd */

#define BD_CT            0
#define BD_CNT           1
#define BD_T200          2
#define BD_T203          3
#define BD_T2            4

/* defines for MBDAlrtInd */

#define NO_ROUTE         0       /* no route found */
#define INV_DLCI         1       /* invalid DLCI */
#define INV_MNGMT        2       /* invalide management frame */
#define FC_DE            3       /* flow control - DE frame */
#define DLC_NOT_UP       4       /* dlc not up */
#define LNK_NOT_UP       5       /* link not up */
#define SU_DOWN          6       /* Service User down */
#define SU_FC            7       /* Service User Flow Control */
#define LNK_DOWN         8       /* link down */
#define PHYS_LNK_DOWN    9       /* physical link down */
#define INV_HEADER      10       /* invalid header */
#define INV_PDU_BDY     11       /* invalid pdu body */
#define INV_MSG         12       /* invalid message */
#define INV_STA_MSG     13       /* invalid status message */
#define STA_NOT_EXP     14       /* status not expected */
#define INV_IE          15       /* invalid information elements */

/* Management Events */

#define EVTLBDCFGREQ     0x90             /* Configuration request */
#define EVTLBDSTAREQ     0x91             /* Status request */
#define EVTLBDSTACFM     0x92             /* Status confirm */
#define EVTLBDSTAIND     0x93             /* Status indication */
#define EVTLBDSTSREQ     0x94             /* Statistics request */
#define EVTLBDSTSCFM     0x95             /* Statistics confirm */
#define EVTLBDTRCIND     0x96             /* Trace indication */
#define EVTLBDCNTRLREQ   0x97             /* Control request */
#define EVTLBDXIDREQ     0x98             /* Exchange id request */
#define EVTLBDXIDCFM     0x99             /* Exchange id confirm */
#define EVTLBDXIDIND     0x9A             /* Exchange id indication */
#define EVTLBDXIDRSP     0x9B             /* Exchange id response */
#define EVTLBDALRTIND    0x9C             /* Alert indication */
#define EVTLBDCNTRLCFM   0x9D             /* Control Confirmation */
#define EVTLBDCFGCFM     0x9E             /* Configuration Confirmation */

/* This is changed because values 1 through 6 are already being used
 * by bdNmReport. These are in file gen.h.
 */
#define SAP_UNBOUND    14  /* to indicate to layer mgr that SAP is unbound */
#define T200_EXP_N200  15  /* Timer T200 Expired N200 Times */
#define FRMR_RXVD      16  /* FRMR frame received */
#define SABME_RST      17  /* SABME reset procedure started */

#define STGRMSAP      STGRDLSAP+256    /* group physical control block */
#define LBD_LOGICAL_INT_TYPE  SAGR_GENERIC_MAX+1 /* grouping criteria */

/* macro for logging errors */
#define LBDLOGERROR(errCls, errCode, errVal, errDesc) \
        SLogError( \
             (Ent) pst->srcEnt, \
             (Inst) pst->srcInst, \
             (ProcId) pst->srcProcId,\
             (Txt *) __FILE__, \
             (S32) __LINE__, \
             (ErrCls) errCls, \
             (ErrCode) errCode, \
             (ErrVal) errVal, \
             (Txt *) errDesc \
             )

/* reason values for solicited status confirmation */
#define LBD_REASON_INVALID_SAPI        LCM_REASON_LYR_SPECIFIC+1
#define LBD_REASON_INVALID_TEI         LCM_REASON_LYR_SPECIFIC+2
#define LBD_REASON_INVALID_DLC         LCM_REASON_LYR_SPECIFIC+3

/* cause values used by unsolicited status indication */
#define LBD_CAUSE_RXVD_UA_F0           LCM_CAUSE_LYR_SPECIFIC+1
#define LBD_CAUSE_RXVD_UA_F1           LCM_CAUSE_LYR_SPECIFIC+2
#define LBD_CAUSE_RXVD_SABM            LCM_CAUSE_LYR_SPECIFIC+3
#define LBD_CAUSE_T200_TIMEDOUT        LCM_CAUSE_LYR_SPECIFIC+4
#define LBD_CAUSE_LINK_ENTR_CONGESTION LCM_CAUSE_LYR_SPECIFIC+5
#define LBD_CAUSE_LINK_EXIT_CONGESTION LCM_CAUSE_LYR_SPECIFIC+6
#define LBD_CAUSE_DISCONNECT_INITIATED LCM_CAUSE_LYR_SPECIFIC+7
#define LBD_CAUSE_SABME_TXMITTED       LCM_CAUSE_LYR_SPECIFIC+8

/* Error Codes */
#define ERRLBD               0
#define ELBDXXX              (ERRLBD + 0)

#define   ELBD001      (ERRLBD +    1)    /*        lbd.c: 190 */
#define   ELBD002      (ERRLBD +    2)    /*        lbd.c: 200 */
#define   ELBD003      (ERRLBD +    3)    /*        lbd.c: 202 */
#define   ELBD004      (ERRLBD +    4)    /*        lbd.c: 203 */
#define   ELBD005      (ERRLBD +    5)    /*        lbd.c: 205 */
#define   ELBD006      (ERRLBD +    6)    /*        lbd.c: 206 */
#define   ELBD007      (ERRLBD +    7)    /*        lbd.c: 208 */
#define   ELBD008      (ERRLBD +    8)    /*        lbd.c: 256 */
#define   ELBD009      (ERRLBD +    9)    /*        lbd.c: 265 */
#define   ELBD010      (ERRLBD +   10)    /*        lbd.c: 266 */
#define   ELBD011      (ERRLBD +   11)    /*        lbd.c: 267 */
#define   ELBD012      (ERRLBD +   12)    /*        lbd.c: 268 */
#define   ELBD013      (ERRLBD +   13)    /*        lbd.c: 269 */
#define   ELBD014      (ERRLBD +   14)    /*        lbd.c: 270 */
#define   ELBD015      (ERRLBD +   15)    /*        lbd.c: 271 */
#define   ELBD016      (ERRLBD +   16)    /*        lbd.c: 272 */
#define   ELBD017      (ERRLBD +   17)    /*        lbd.c: 273 */
#define   ELBD018      (ERRLBD +   18)    /*        lbd.c: 274 */
#define   ELBD019      (ERRLBD +   19)    /*        lbd.c: 275 */
#define   ELBD020      (ERRLBD +   20)    /*        lbd.c: 276 */
#define   ELBD021      (ERRLBD +   21)    /*        lbd.c: 277 */
#define   ELBD022      (ERRLBD +   22)    /*        lbd.c: 278 */
#define   ELBD023      (ERRLBD +   23)    /*        lbd.c: 279 */
#define   ELBD024      (ERRLBD +   24)    /*        lbd.c: 329 */
#define   ELBD025      (ERRLBD +   25)    /*        lbd.c: 338 */
#define   ELBD026      (ERRLBD +   26)    /*        lbd.c: 339 */
#define   ELBD027      (ERRLBD +   27)    /*        lbd.c: 340 */
#define   ELBD028      (ERRLBD +   28)    /*        lbd.c: 341 */
#define   ELBD029      (ERRLBD +   29)    /*        lbd.c: 342 */
#define   ELBD030      (ERRLBD +   30)    /*        lbd.c: 343 */
#define   ELBD031      (ERRLBD +   31)    /*        lbd.c: 344 */
#define   ELBD032      (ERRLBD +   32)    /*        lbd.c: 345 */
#define   ELBD033      (ERRLBD +   33)    /*        lbd.c: 346 */
#define   ELBD034      (ERRLBD +   34)    /*        lbd.c: 347 */
#define   ELBD035      (ERRLBD +   35)    /*        lbd.c: 348 */
#define   ELBD036      (ERRLBD +   36)    /*        lbd.c: 349 */
#define   ELBD037      (ERRLBD +   37)    /*        lbd.c: 350 */
#define   ELBD038      (ERRLBD +   38)    /*        lbd.c: 351 */
#define   ELBD039      (ERRLBD +   39)    /*        lbd.c: 352 */
#define   ELBD040      (ERRLBD +   40)    /*        lbd.c: 353 */
#define   ELBD041      (ERRLBD +   41)    /*        lbd.c: 354 */
#define   ELBD042      (ERRLBD +   42)    /*        lbd.c: 355 */
#define   ELBD043      (ERRLBD +   43)    /*        lbd.c: 356 */
#define   ELBD044      (ERRLBD +   44)    /*        lbd.c: 357 */
#define   ELBD045      (ERRLBD +   45)    /*        lbd.c: 358 */
#define   ELBD046      (ERRLBD +   46)    /*        lbd.c: 359 */
#define   ELBD047      (ERRLBD +   47)    /*        lbd.c: 360 */
#define   ELBD048      (ERRLBD +   48)    /*        lbd.c: 361 */
#define   ELBD049      (ERRLBD +   49)    /*        lbd.c: 362 */
#define   ELBD050      (ERRLBD +   50)    /*        lbd.c: 363 */
#define   ELBD051      (ERRLBD +   51)    /*        lbd.c: 364 */
#define   ELBD052      (ERRLBD +   52)    /*        lbd.c: 365 */
#define   ELBD053      (ERRLBD +   53)    /*        lbd.c: 366 */
#define   ELBD054      (ERRLBD +   54)    /*        lbd.c: 367 */
#define   ELBD055      (ERRLBD +   55)    /*        lbd.c: 368 */
#define   ELBD056      (ERRLBD +   56)    /*        lbd.c: 370 */
#define   ELBD057      (ERRLBD +   57)    /*        lbd.c: 372 */
#define   ELBD058      (ERRLBD +   58)    /*        lbd.c: 373 */
#define   ELBD059      (ERRLBD +   59)    /*        lbd.c: 421 */
#define   ELBD060      (ERRLBD +   60)    /*        lbd.c: 433 */
#define   ELBD061      (ERRLBD +   61)    /*        lbd.c: 435 */
#define   ELBD062      (ERRLBD +   62)    /*        lbd.c: 436 */
#define   ELBD063      (ERRLBD +   63)    /*        lbd.c: 437 */
#define   ELBD064      (ERRLBD +   64)    /*        lbd.c: 439 */
#define   ELBD065      (ERRLBD +   65)    /*        lbd.c: 440 */
#define   ELBD066      (ERRLBD +   66)    /*        lbd.c: 483 */
#define   ELBD067      (ERRLBD +   67)    /*        lbd.c: 484 */
#define   ELBD068      (ERRLBD +   68)    /*        lbd.c: 485 */
#define   ELBD069      (ERRLBD +   69)    /*        lbd.c: 529 */
#define   ELBD070      (ERRLBD +   70)    /*        lbd.c: 530 */
#define   ELBD071      (ERRLBD +   71)    /*        lbd.c: 531 */
#define   ELBD072      (ERRLBD +   72)    /*        lbd.c: 578 */
#define   ELBD073      (ERRLBD +   73)    /*        lbd.c: 586 */
#define   ELBD074      (ERRLBD +   74)    /*        lbd.c: 587 */
#define   ELBD075      (ERRLBD +   75)    /*        lbd.c: 633 */
#define   ELBD076      (ERRLBD +   76)    /*        lbd.c: 641 */
#define   ELBD077      (ERRLBD +   77)    /*        lbd.c: 642 */
#define   ELBD078      (ERRLBD +   78)    /*        lbd.c: 694 */
#define   ELBD079      (ERRLBD +   79)    /*        lbd.c: 706 */
#define   ELBD080      (ERRLBD +   80)    /*        lbd.c: 707 */
#define   ELBD081      (ERRLBD +   81)    /*        lbd.c: 708 */
#define   ELBD082      (ERRLBD +   82)    /*        lbd.c: 709 */
#define   ELBD083      (ERRLBD +   83)    /*        lbd.c: 710 */
#define   ELBD084      (ERRLBD +   84)    /*        lbd.c: 711 */
#define   ELBD085      (ERRLBD +   85)    /*        lbd.c: 712 */
#define   ELBD086      (ERRLBD +   86)    /*        lbd.c: 713 */
#define   ELBD087      (ERRLBD +   87)    /*        lbd.c: 714 */
#define   ELBD088      (ERRLBD +   88)    /*        lbd.c: 715 */
#define   ELBD089      (ERRLBD +   89)    /*        lbd.c: 716 */
#define   ELBD090      (ERRLBD +   90)    /*        lbd.c: 717 */
#define   ELBD091      (ERRLBD +   91)    /*        lbd.c: 718 */
#define   ELBD092      (ERRLBD +   92)    /*        lbd.c: 719 */
#define   ELBD093      (ERRLBD +   93)    /*        lbd.c: 720 */
#define   ELBD094      (ERRLBD +   94)    /*        lbd.c: 725 */
#define   ELBD095      (ERRLBD +   95)    /*        lbd.c: 726 */
#define   ELBD096      (ERRLBD +   96)    /*        lbd.c: 728 */
#define   ELBD097      (ERRLBD +   97)    /*        lbd.c: 729 */
#define   ELBD098      (ERRLBD +   98)    /*        lbd.c: 730 */
#define   ELBD099      (ERRLBD +   99)    /*        lbd.c: 731 */
#define   ELBD100      (ERRLBD +  100)    /*        lbd.c: 732 */
#define   ELBD101      (ERRLBD +  101)    /*        lbd.c: 733 */
#define   ELBD102      (ERRLBD +  102)    /*        lbd.c: 734 */
#define   ELBD103      (ERRLBD +  103)    /*        lbd.c: 735 */
#define   ELBD104      (ERRLBD +  104)    /*        lbd.c: 736 */
#define   ELBD105      (ERRLBD +  105)    /*        lbd.c: 738 */
#define   ELBD106      (ERRLBD +  106)    /*        lbd.c: 739 */
#define   ELBD107      (ERRLBD +  107)    /*        lbd.c: 740 */
#define   ELBD108      (ERRLBD +  108)    /*        lbd.c: 741 */
#define   ELBD109      (ERRLBD +  109)    /*        lbd.c: 742 */
#define   ELBD110      (ERRLBD +  110)    /*        lbd.c: 743 */
#define   ELBD111      (ERRLBD +  111)    /*        lbd.c: 748 */
#define   ELBD112      (ERRLBD +  112)    /*        lbd.c: 750 */
#define   ELBD113      (ERRLBD +  113)    /*        lbd.c: 751 */
#define   ELBD114      (ERRLBD +  114)    /*        lbd.c: 752 */
#define   ELBD115      (ERRLBD +  115)    /*        lbd.c: 753 */
#define   ELBD116      (ERRLBD +  116)    /*        lbd.c: 754 */
#define   ELBD117      (ERRLBD +  117)    /*        lbd.c: 755 */
#define   ELBD118      (ERRLBD +  118)    /*        lbd.c: 756 */
#define   ELBD119      (ERRLBD +  119)    /*        lbd.c: 758 */
#define   ELBD120      (ERRLBD +  120)    /*        lbd.c: 759 */
#define   ELBD121      (ERRLBD +  121)    /*        lbd.c: 761 */
#define   ELBD122      (ERRLBD +  122)    /*        lbd.c: 762 */
#define   ELBD123      (ERRLBD +  123)    /*        lbd.c: 763 */
#define   ELBD124      (ERRLBD +  124)    /*        lbd.c: 764 */
#define   ELBD125      (ERRLBD +  125)    /*        lbd.c: 765 */
#define   ELBD126      (ERRLBD +  126)    /*        lbd.c: 766 */
#define   ELBD127      (ERRLBD +  127)    /*        lbd.c: 767 */
#define   ELBD128      (ERRLBD +  128)    /*        lbd.c: 768 */
#define   ELBD129      (ERRLBD +  129)    /*        lbd.c: 769 */
#define   ELBD130      (ERRLBD +  130)    /*        lbd.c: 770 */
#define   ELBD131      (ERRLBD +  131)    /*        lbd.c: 771 */
#define   ELBD132      (ERRLBD +  132)    /*        lbd.c: 772 */
#define   ELBD133      (ERRLBD +  133)    /*        lbd.c: 773 */
#define   ELBD134      (ERRLBD +  134)    /*        lbd.c: 774 */
#define   ELBD135      (ERRLBD +  135)    /*        lbd.c: 775 */
#define   ELBD136      (ERRLBD +  136)    /*        lbd.c: 780 */
#define   ELBD137      (ERRLBD +  137)    /*        lbd.c: 786 */
#define   ELBD138      (ERRLBD +  138)    /*        lbd.c: 834 */
#define   ELBD139      (ERRLBD +  139)    /*        lbd.c: 843 */
#define   ELBD140      (ERRLBD +  140)    /*        lbd.c: 844 */
#define   ELBD141      (ERRLBD +  141)    /*        lbd.c: 845 */
#define   ELBD142      (ERRLBD +  142)    /*        lbd.c: 846 */
#define   ELBD143      (ERRLBD +  143)    /*        lbd.c: 847 */
#define   ELBD144      (ERRLBD +  144)    /*        lbd.c: 848 */
#define   ELBD145      (ERRLBD +  145)    /*        lbd.c: 849 */
#define   ELBD146      (ERRLBD +  146)    /*        lbd.c: 850 */
#define   ELBD147      (ERRLBD +  147)    /*        lbd.c: 851 */
#define   ELBD148      (ERRLBD +  148)    /*        lbd.c: 852 */
#define   ELBD149      (ERRLBD +  149)    /*        lbd.c: 853 */
#define   ELBD150      (ERRLBD +  150)    /*        lbd.c: 854 */
#define   ELBD151      (ERRLBD +  151)    /*        lbd.c: 855 */
#define   ELBD152      (ERRLBD +  152)    /*        lbd.c: 857 */
#define   ELBD153      (ERRLBD +  153)    /*        lbd.c: 858 */
#define   ELBD154      (ERRLBD +  154)    /*        lbd.c: 859 */
#define   ELBD155      (ERRLBD +  155)    /*        lbd.c: 861 */
#define   ELBD156      (ERRLBD +  156)    /*        lbd.c: 862 */
#define   ELBD157      (ERRLBD +  157)    /*        lbd.c: 911 */
#define   ELBD158      (ERRLBD +  158)    /*        lbd.c: 920 */
#define   ELBD159      (ERRLBD +  159)    /*        lbd.c: 921 */
#define   ELBD160      (ERRLBD +  160)    /*        lbd.c: 922 */
#define   ELBD161      (ERRLBD +  161)    /*        lbd.c: 923 */
#define   ELBD162      (ERRLBD +  162)    /*        lbd.c: 924 */
#define   ELBD163      (ERRLBD +  163)    /*        lbd.c: 925 */
#define   ELBD164      (ERRLBD +  164)    /*        lbd.c: 926 */
#define   ELBD165      (ERRLBD +  165)    /*        lbd.c: 927 */
#define   ELBD166      (ERRLBD +  166)    /*        lbd.c: 928 */
#define   ELBD167      (ERRLBD +  167)    /*        lbd.c: 929 */
#define   ELBD168      (ERRLBD +  168)    /*        lbd.c: 930 */
#define   ELBD169      (ERRLBD +  169)    /*        lbd.c: 931 */
#define   ELBD170      (ERRLBD +  170)    /*        lbd.c: 932 */
#define   ELBD171      (ERRLBD +  171)    /*        lbd.c: 933 */
#define   ELBD172      (ERRLBD +  172)    /*        lbd.c: 934 */
#define   ELBD173      (ERRLBD +  173)    /*        lbd.c: 935 */
#define   ELBD174      (ERRLBD +  174)    /*        lbd.c: 936 */
#define   ELBD175      (ERRLBD +  175)    /*        lbd.c: 937 */
#define   ELBD176      (ERRLBD +  176)    /*        lbd.c: 938 */
#define   ELBD177      (ERRLBD +  177)    /*        lbd.c: 939 */
#define   ELBD178      (ERRLBD +  178)    /*        lbd.c: 940 */
#define   ELBD179      (ERRLBD +  179)    /*        lbd.c: 941 */
#define   ELBD180      (ERRLBD +  180)    /*        lbd.c: 942 */
#define   ELBD181      (ERRLBD +  181)    /*        lbd.c: 943 */
#define   ELBD182      (ERRLBD +  182)    /*        lbd.c: 944 */
#define   ELBD183      (ERRLBD +  183)    /*        lbd.c: 945 */
#define   ELBD184      (ERRLBD +  184)    /*        lbd.c: 947 */
#define   ELBD185      (ERRLBD +  185)    /*        lbd.c: 949 */
#define   ELBD186      (ERRLBD +  186)    /*        lbd.c: 950 */
#define   ELBD187      (ERRLBD +  187)    /*        lbd.c: 951 */
#define   ELBD188      (ERRLBD +  188)    /*        lbd.c: 952 */
#define   ELBD189      (ERRLBD +  189)    /*        lbd.c: 953 */
#define   ELBD190      (ERRLBD +  190)    /*        lbd.c: 954 */
#define   ELBD191      (ERRLBD +  191)    /*        lbd.c: 955 */
#define   ELBD192      (ERRLBD +  192)    /*        lbd.c:1002 */
#define   ELBD193      (ERRLBD +  193)    /*        lbd.c:1012 */
#define   ELBD194      (ERRLBD +  194)    /*        lbd.c:1014 */
#define   ELBD195      (ERRLBD +  195)    /*        lbd.c:1015 */
#define   ELBD196      (ERRLBD +  196)    /*        lbd.c:1017 */
#define   ELBD197      (ERRLBD +  197)    /*        lbd.c:1018 */
#define   ELBD198      (ERRLBD +  198)    /*        lbd.c:1019 */
#define   ELBD199      (ERRLBD +  199)    /*        lbd.c:1021 */
#define   ELBD200      (ERRLBD +  200)    /*        lbd.c:1022 */
#define   ELBD201      (ERRLBD +  201)    /*        lbd.c:1023 */
#define   ELBD202      (ERRLBD +  202)    /*        lbd.c:1024 */
#define   ELBD203      (ERRLBD +  203)    /*        lbd.c:1068 */
#define   ELBD204      (ERRLBD +  204)    /*        lbd.c:1069 */
#define   ELBD205      (ERRLBD +  205)    /*        lbd.c:1070 */
#define   ELBD206      (ERRLBD +  206)    /*        lbd.c:1114 */
#define   ELBD207      (ERRLBD +  207)    /*        lbd.c:1115 */
#define   ELBD208      (ERRLBD +  208)    /*        lbd.c:1116 */
#define   ELBD209      (ERRLBD +  209)    /*        lbd.c:1159 */
#define   ELBD210      (ERRLBD +  210)    /*        lbd.c:1163 */
#define   ELBD211      (ERRLBD +  211)    /*        lbd.c:1164 */
#define   ELBD212      (ERRLBD +  212)    /*        lbd.c:1165 */
#define   ELBD213      (ERRLBD +  213)    /*        lbd.c:1166 */
#define   ELBD214      (ERRLBD +  214)    /*        lbd.c:1167 */
#define   ELBD215      (ERRLBD +  215)    /*        lbd.c:1169 */
#define   ELBD216      (ERRLBD +  216)    /*        lbd.c:1170 */
#define   ELBD217      (ERRLBD +  217)    /*        lbd.c:1171 */
#define   ELBD218      (ERRLBD +  218)    /*        lbd.c:1172 */
#define   ELBD219      (ERRLBD +  219)    /*        lbd.c:1173 */
#define   ELBD220      (ERRLBD +  220)    /*        lbd.c:1174 */
#define   ELBD221      (ERRLBD +  221)    /*        lbd.c:1175 */
#define   ELBD222      (ERRLBD +  222)    /*        lbd.c:1176 */
#define   ELBD223      (ERRLBD +  223)    /*        lbd.c:1177 */
#define   ELBD224      (ERRLBD +  224)    /*        lbd.c:1178 */
#define   ELBD225      (ERRLBD +  225)    /*        lbd.c:1180 */
#define   ELBD226      (ERRLBD +  226)    /*        lbd.c:1181 */
#define   ELBD227      (ERRLBD +  227)    /*        lbd.c:1186 */
#define   ELBD228      (ERRLBD +  228)    /*        lbd.c:1187 */
#define   ELBD229      (ERRLBD +  229)    /*        lbd.c:1188 */
#define   ELBD230      (ERRLBD +  230)    /*        lbd.c:1189 */
#define   ELBD231      (ERRLBD +  231)    /*        lbd.c:1190 */
#define   ELBD232      (ERRLBD +  232)    /*        lbd.c:1191 */
#define   ELBD233      (ERRLBD +  233)    /*        lbd.c:1192 */
#define   ELBD234      (ERRLBD +  234)    /*        lbd.c:1193 */
#define   ELBD235      (ERRLBD +  235)    /*        lbd.c:1194 */
#define   ELBD236      (ERRLBD +  236)    /*        lbd.c:1195 */
#define   ELBD237      (ERRLBD +  237)    /*        lbd.c:1196 */
#define   ELBD238      (ERRLBD +  238)    /*        lbd.c:1197 */
#define   ELBD239      (ERRLBD +  239)    /*        lbd.c:1198 */
#define   ELBD240      (ERRLBD +  240)    /*        lbd.c:1199 */
#define   ELBD241      (ERRLBD +  241)    /*        lbd.c:1200 */
#define   ELBD242      (ERRLBD +  242)    /*        lbd.c:1202 */
#define   ELBD243      (ERRLBD +  243)    /*        lbd.c:1203 */
#define   ELBD244      (ERRLBD +  244)    /*        lbd.c:1205 */
#define   ELBD245      (ERRLBD +  245)    /*        lbd.c:1206 */
#define   ELBD246      (ERRLBD +  246)    /*        lbd.c:1207 */
#define   ELBD247      (ERRLBD +  247)    /*        lbd.c:1208 */
#define   ELBD248      (ERRLBD +  248)    /*        lbd.c:1209 */
#define   ELBD249      (ERRLBD +  249)    /*        lbd.c:1210 */
#define   ELBD250      (ERRLBD +  250)    /*        lbd.c:1211 */
#define   ELBD251      (ERRLBD +  251)    /*        lbd.c:1213 */
#define   ELBD252      (ERRLBD +  252)    /*        lbd.c:1218 */
#define   ELBD253      (ERRLBD +  253)    /*        lbd.c:1219 */
#define   ELBD254      (ERRLBD +  254)    /*        lbd.c:1220 */
#define   ELBD255      (ERRLBD +  255)    /*        lbd.c:1221 */
#define   ELBD256      (ERRLBD +  256)    /*        lbd.c:1222 */
#define   ELBD257      (ERRLBD +  257)    /*        lbd.c:1223 */
#define   ELBD258      (ERRLBD +  258)    /*        lbd.c:1224 */
#define   ELBD259      (ERRLBD +  259)    /*        lbd.c:1225 */
#define   ELBD260      (ERRLBD +  260)    /*        lbd.c:1226 */
#define   ELBD261      (ERRLBD +  261)    /*        lbd.c:1227 */
#define   ELBD262      (ERRLBD +  262)    /*        lbd.c:1228 */
#define   ELBD263      (ERRLBD +  263)    /*        lbd.c:1229 */
#define   ELBD264      (ERRLBD +  264)    /*        lbd.c:1230 */
#define   ELBD265      (ERRLBD +  265)    /*        lbd.c:1231 */
#define   ELBD266      (ERRLBD +  266)    /*        lbd.c:1232 */
#define   ELBD267      (ERRLBD +  267)    /*        lbd.c:1237 */
#define   ELBD268      (ERRLBD +  268)    /*        lbd.c:1281 */
#define   ELBD269      (ERRLBD +  269)    /*        lbd.c:1282 */
#define   ELBD270      (ERRLBD +  270)    /*        lbd.c:1284 */
#define   ELBD271      (ERRLBD +  271)    /*        lbd.c:1285 */
#define   ELBD272      (ERRLBD +  272)    /*        lbd.c:1286 */
#define   ELBD273      (ERRLBD +  273)    /*        lbd.c:1329 */
#define   ELBD274      (ERRLBD +  274)    /*        lbd.c:1330 */
#define   ELBD275      (ERRLBD +  275)    /*        lbd.c:1331 */
#define   ELBD276      (ERRLBD +  276)    /*        lbd.c:1332 */
#define   ELBD277      (ERRLBD +  277)    /*        lbd.c:1333 */
#define   ELBD278      (ERRLBD +  278)    /*        lbd.c:1334 */
#define   ELBD279      (ERRLBD +  279)    /*        lbd.c:1335 */
#define   ELBD280      (ERRLBD +  280)    /*        lbd.c:1337 */
#define   ELBD281      (ERRLBD +  281)    /*        lbd.c:1339 */
#define   ELBD282      (ERRLBD +  282)    /*        lbd.c:1379 */
#define   ELBD283      (ERRLBD +  283)    /*        lbd.c:1380 */
#define   ELBD284      (ERRLBD +  284)    /*        lbd.c:1381 */
#define   ELBD285      (ERRLBD +  285)    /*        lbd.c:1382 */
#define   ELBD286      (ERRLBD +  286)    /*        lbd.c:1384 */
#define   ELBD287      (ERRLBD +  287)    /*        lbd.c:1385 */
#define   ELBD288      (ERRLBD +  288)    /*        lbd.c:1386 */
#define   ELBD289      (ERRLBD +  289)    /*        lbd.c:1388 */
#define   ELBD290      (ERRLBD +  290)    /*        lbd.c:1389 */
#define   ELBD291      (ERRLBD +  291)    /*        lbd.c:1392 */
#define   ELBD292      (ERRLBD +  292)    /*        lbd.c:1435 */
#define   ELBD293      (ERRLBD +  293)    /*        lbd.c:1436 */
#define   ELBD294      (ERRLBD +  294)    /*        lbd.c:1437 */
#define   ELBD295      (ERRLBD +  295)    /*        lbd.c:1477 */
#define   ELBD296      (ERRLBD +  296)    /*        lbd.c:1478 */
#define   ELBD297      (ERRLBD +  297)    /*        lbd.c:1479 */
#define   ELBD298      (ERRLBD +  298)    /*        lbd.c:1522 */
#define   ELBD299      (ERRLBD +  299)    /*        lbd.c:1523 */
#define   ELBD300      (ERRLBD +  300)    /*        lbd.c:1524 */
#define   ELBD301      (ERRLBD +  301)    /*        lbd.c:1565 */
#define   ELBD302      (ERRLBD +  302)    /*        lbd.c:1566 */
#define   ELBD303      (ERRLBD +  303)    /*        lbd.c:1567 */
#define   ELBD304      (ERRLBD +  304)    /*        lbd.c:1608 */
#define   ELBD305      (ERRLBD +  305)    /*        lbd.c:1610 */
#define   ELBD306      (ERRLBD +  306)    /*        lbd.c:1654 */
#define   ELBD307      (ERRLBD +  307)    /*        lbd.c:1657 */
#define   ELBD308      (ERRLBD +  308)    /*        lbd.c:1698 */
#define   ELBD309      (ERRLBD +  309)    /*        lbd.c:1699 */
#define   ELBD310      (ERRLBD +  310)    /*        lbd.c:1700 */
#define   ELBD311      (ERRLBD +  311)    /*        lbd.c:1701 */
#define   ELBD312      (ERRLBD +  312)    /*        lbd.c:1702 */
#define   ELBD313      (ERRLBD +  313)    /*        lbd.c:1703 */
#define   ELBD314      (ERRLBD +  314)    /*        lbd.c:1704 */
#define   ELBD315      (ERRLBD +  315)    /*        lbd.c:1705 */
#define   ELBD316      (ERRLBD +  316)    /*        lbd.c:1706 */
#define   ELBD317      (ERRLBD +  317)    /*        lbd.c:1707 */
#define   ELBD318      (ERRLBD +  318)    /*        lbd.c:1708 */
#define   ELBD319      (ERRLBD +  319)    /*        lbd.c:1709 */
#define   ELBD320      (ERRLBD +  320)    /*        lbd.c:1710 */
#define   ELBD321      (ERRLBD +  321)    /*        lbd.c:1711 */
#define   ELBD322      (ERRLBD +  322)    /*        lbd.c:1712 */
#define   ELBD323      (ERRLBD +  323)    /*        lbd.c:1752 */
#define   ELBD324      (ERRLBD +  324)    /*        lbd.c:1753 */
#define   ELBD325      (ERRLBD +  325)    /*        lbd.c:1755 */
#define   ELBD326      (ERRLBD +  326)    /*        lbd.c:1757 */
#define   ELBD327      (ERRLBD +  327)    /*        lbd.c:1758 */
#define   ELBD328      (ERRLBD +  328)    /*        lbd.c:1759 */
#define   ELBD329      (ERRLBD +  329)    /*        lbd.c:1760 */
#define   ELBD330      (ERRLBD +  330)    /*        lbd.c:1761 */
#define   ELBD331      (ERRLBD +  331)    /*        lbd.c:1762 */
#define   ELBD332      (ERRLBD +  332)    /*        lbd.c:1763 */
#define   ELBD333      (ERRLBD +  333)    /*        lbd.c:1764 */
#define   ELBD334      (ERRLBD +  334)    /*        lbd.c:1765 */
#define   ELBD335      (ERRLBD +  335)    /*        lbd.c:1766 */
#define   ELBD336      (ERRLBD +  336)    /*        lbd.c:1767 */
#define   ELBD337      (ERRLBD +  337)    /*        lbd.c:1768 */
#define   ELBD338      (ERRLBD +  338)    /*        lbd.c:1769 */
#define   ELBD339      (ERRLBD +  339)    /*        lbd.c:1770 */
#define   ELBD340      (ERRLBD +  340)    /*        lbd.c:1771 */
#define   ELBD341      (ERRLBD +  341)    /*        lbd.c:1772 */
#define   ELBD342      (ERRLBD +  342)    /*        lbd.c:1773 */
#define   ELBD343      (ERRLBD +  343)    /*        lbd.c:1774 */
#define   ELBD344      (ERRLBD +  344)    /*        lbd.c:1775 */
#define   ELBD345      (ERRLBD +  345)    /*        lbd.c:1776 */
#define   ELBD346      (ERRLBD +  346)    /*        lbd.c:1777 */
#define   ELBD347      (ERRLBD +  347)    /*        lbd.c:1778 */
#define   ELBD348      (ERRLBD +  348)    /*        lbd.c:1779 */
#define   ELBD349      (ERRLBD +  349)    /*        lbd.c:1780 */
#define   ELBD350      (ERRLBD +  350)    /*        lbd.c:1781 */
#define   ELBD351      (ERRLBD +  351)    /*        lbd.c:1782 */
#define   ELBD352      (ERRLBD +  352)    /*        lbd.c:1783 */
#define   ELBD353      (ERRLBD +  353)    /*        lbd.c:1784 */
#define   ELBD354      (ERRLBD +  354)    /*        lbd.c:1785 */
#define   ELBD355      (ERRLBD +  355)    /*        lbd.c:1786 */
#define   ELBD356      (ERRLBD +  356)    /*        lbd.c:1787 */
#define   ELBD357      (ERRLBD +  357)    /*        lbd.c:1827 */
#define   ELBD358      (ERRLBD +  358)    /*        lbd.c:1829 */
#define   ELBD359      (ERRLBD +  359)    /*        lbd.c:1830 */
#define   ELBD360      (ERRLBD +  360)    /*        lbd.c:1832 */
#define   ELBD361      (ERRLBD +  361)    /*        lbd.c:1833 */
#define   ELBD362      (ERRLBD +  362)    /*        lbd.c:1836 */
#define   ELBD363      (ERRLBD +  363)    /*        lbd.c:1875 */
#define   ELBD364      (ERRLBD +  364)    /*        lbd.c:1876 */
#define   ELBD365      (ERRLBD +  365)    /*        lbd.c:1878 */
#define   ELBD366      (ERRLBD +  366)    /*        lbd.c:1879 */
#define   ELBD367      (ERRLBD +  367)    /*        lbd.c:1880 */
#define   ELBD368      (ERRLBD +  368)    /*        lbd.c:1882 */

#endif /* __LBDH_ */
 

/********************************************************************30**
  
         End of file:     lbd.h@@/main/1 - Tue Jan  9 13:59:07 2001
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/


/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.1          ---  mc    1. initial release

1.1+    ld001.33  iy    1. add SW_NI2 isdn switch type.
        ld015.33  sam   2. added SAP_UNBOUND.
        ld016.33  sam   3. changed define value for SAP_UNBOUND.
        ld023.33  ag    4. Additional define T200_EXP_N200 to indicate
                           Timer T200 expired N200 times.
        ld031.33  sam   5. changed event defines. 
        ld032.33  sam   6. Includes changes for stack testing of ISDN.
                           Added defines for control and configuration
                           confirms.
                           Same as patch ld031.33 in gen 01.
        ld012.304 bn    1. Change the value of LOW_TEI_RNG for GSM
*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
/main/1      ---      mr   1. modified for 3.4 release.
  
*********************************************************************91*/
