/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**

     Name:     ISDN network layer

     Type:     C include file

     Desc:     Structures, variables and typedefs required by the
               isdn network layer service user.

     File:     int.x
  
     Sid:      int.x@@/main/32 - Wed May 23 17:06:49 2001

     Prg:      bn

*********************************************************************21*/

#ifndef __INTX__
#define __INTX__
#ifdef __cplusplus
extern "C" {
#endif /* _cplusplus */


/*
*     The structures and variables declared in this file
*     correspond to structures and variables used by
*     the following TRILLIUM software:
*
*     part no.             description
*     --------     ----------------------------------------------
*     1000009      Network Layer - Q.930/Q.931
*
*/

/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.             description
*     --------     ----------------------------------------------
*     1000009     Network Layer - Q.930/Q.931
*     1000023     Network Layer - X.31
*
*/



/* typedefs */

/* bndCfg structure defined in gen.x */

/* buffer structure defined in ss.x */

/* addrs structure defined in gen.x */

/* token structures defined in gen.x */

/* header structures defined in gen.x */

#ifdef ANVER2
#define SuPst Pst
#else /* ANVER2 */
#define SuPst BndCfg 
#endif  /* ifdef ANVER2 */


#ifdef ISDN_3_8_PLUS 
typedef U32 InInstId;
#else
typedef U16 InInstId;
#endif




/***********************************************************************/
/*                  Information Element Structures                     */
/***********************************************************************/

typedef struct reserve          /* reserve tokens */
{
   ElmtHdr eh;                  /* element header */
} Reserve;

typedef struct shift            /* shift tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   codeSet;             /* code set */
   TknU8   shiftLock;           /* shift lock */
} Shift;

typedef struct repInd           /* repeat indicator tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   repInd;              /* repeat indication */
} RepInd;


typedef struct causeDgn         /* cause and diagnostic tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   location;            /* location */
   TknU8   codeStand3;          /* coding standard */
   TknU8   recommend;           /* recommendation */
   TknU8   causeVal;            /* cause value */
   TknStr  dgnVal;              /* diagnostic value */
} CauseDgn;

typedef struct callSte          /* call state tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   callGlblSte;         /* call state value */
   TknU8   codeStand2;          /* coding standard */
} CallSte;

typedef struct chanId           /* channel id tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   infoChanSel;         /* information channel selection */
   TknU8   dChanInd;            /* d channel indicator */
   TknU8   prefExc;             /* preferred/exclusive */
   TknU8   intType;             /* interface type */
   TknU8   intIdentPres;        /* interface identifier present */
   TknU16  intIdent;            /* interface identifier */
   TknU8   chanMapType;         /* channel type/map type */
   TknU8   nmbMap;              /* number/map */
   TknU8   codeStand1;          /* coding standard */
   TknStrM chanNmbSlotMap;      /* channel number/slot map */
} ChanId;

typedef struct progInd          /* progress indicator tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   location;            /* location */
   TknU8   codeStand0;          /* coding standard */
   TknU8   progDesc;            /* progress description */
} ProgInd;

typedef struct display          /* display tokens */
{
   ElmtHdr eh;                  /* element header */
   TknStr  dispInfo;            /* display information */
} Display;

typedef struct etoeDly          /* end to end transit delay tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU16  cumTranDly;          /* cumulative transit delay value */
   TknU16  reqEtoETranDly;      /* requested end to end transit delay value */
   TknU16  maxEtoETranDly;      /* maximum end to end transit delay value */
} EtoeDly;

typedef struct cgPtyNmb         /* calling/connected number tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   nmbPlanId;           /* numbering plan identification */
   TknU8   typeNmb1;            /* type of number */
   TknU8   screenInd;           /* screening indicator */
   TknU8   presInd0;            /* presentation indicator */
   TknStrM nmbDigits;           /* number digits */
} CgPtyNmb;

/* KRP */
typedef struct subAdrs          /* subaddress tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   oddEvenInd;          /* odd/even indicator */
   TknU8   typeSad;             /* type of subaddress */
   TknStrS sadInfo;             /* subaddress information */
} SubAdrs;

typedef struct trnstNtw         /* transit network selection tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   netIdPlan;             /* network identification plan */
   TknU8   typeNetId;             /* type of network identification */
   TknStr  netId;                /* network identification */
} TrnstNtw;

typedef struct rstInd           /* restart indicator tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   rstClass;            /* restart class */
} RstInd;

typedef struct hlComp           /* high layer compatibility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   presMethod;          /* presentation method of protocol profile */
   TknU8   interpret;           /* interpretation */
   TknU8   codeStand0;          /* coding standard */
   TknU8   highLyrCharId;       /* high layer characteristics identification */
   TknU8   extHighLyrCharId;    /* extended high layer characteristics 
                                   identification */
} HlComp;

typedef struct usrUsr           /* user - user tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   protocolDisc;        /* protocol discriminator */
   TknStr  usrInfo;             /* user information */
} UsrUsr;

typedef struct nullElmt         /* null tokens */
{
   ElmtHdr eh;                  /* element header */
} NullElmt;

typedef struct pduHdr           /* pdu header */
{
   ElmtHdr eh;                  /* element header */
   TknU8   protDisc;            /* Protocol Discriminator */
   TknU8   callRefLen;          /* Call Reference Length */
   TknStr  callRefVal;          /* Call Reference Value */
   TknU8   escNat;              /* Escape To National */
   TknU8   msgType;             /* Message Type */
} PduHdr;


typedef struct moreData         /* more data tokens */
{
   ElmtHdr eh;                  /* element header */
} MoreData;

typedef struct sndCmplt         /* sending complete tokens */
{
   ElmtHdr eh;                  /* element header */
} SndCmplt;

typedef struct congLvl          /* congestion level tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 congLvl;               /* congestion level */
} CongLvl;

typedef struct bearCap          /* bearer capability tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 infoTranCap;           /* information transfer capability */
   TknU8 codeStand0;            /* coding standard */
   TknU8 infoTranRate0;         /* information transfer rate */
   TknU8 tranMode;              /* transfer mode */
#ifdef ITUT88
   TknU8 establish;             /* establishment */
   TknU8 cfg;                   /* configuration */
   TknU8 chanStruct;            /* structure */
   TknU8 infoTranRate1;         /* information transfer rate */
   TknU8 symmetry;              /* symmetry */
#else
   TknU8 rateMultiplier;        /* rate multiplier */
#endif
   TknU8 lyr1Ident;             /* layer 1 identity */
   TknU8 usrInfoLyr1Prot;       /* usr information layer 1 protocol */
   TknU8 usrRate;               /* user rate */
   TknU8 negot;                 /* negotiation */
   TknU8 syncAsync;             /* synchronous/asynchronous */
   TknU8 flcOnRx;               /* flow control on reception */
   TknU8 flcOnTx;               /* flow control on transmission */
   TknU8 nicOnRx;               /* network independent clock on reception */
   TknU8 nicOnTx;               /* network independent clock on transmission */
   TknU8 interRate;             /* intermediate rate */
   TknU8 inOutBandNegot;        /* inband/outband negotiation */
   TknU8 asgnrAsgne;            /* assignor/assignee */
   TknU8 logLnkNegot;           /* logical link identifier negotiation */
   TknU8 mode;                  /* mode of operation */
   TknU8 multiFrm;              /* multiple frame establishment support in 
                                   data link */
   TknU8 hdrNoHdr;              /* rate adaption header/no header */
   TknU8 parity;                /* parity information */
   TknU8 nmbDatBits;            /* number of data bits excluding parity bit */
   TknU8 nmbStopBits;           /* number of stop bits */
   TknU8 modemType;             /* modem type */
   TknU8 duplexMode;            /* duplex mode */
   TknU8 lyr2Ident;             /* layer 2 identity */
   TknU8 usrInfoLyr2Prot0;      /* user information layer 2 protocol */
   TknU8 lyr3Ident0;            /* layer 3 identity */
   TknU8 usrInfoLyr3Prot0;      /* user information layer 3 protocol */
} BearCap;

#ifdef INTR6
typedef struct trCause          /* cause and diagnostic tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 causeVal;              /* cause value */
   TknU8 location;              /* location */
   TknU8 codeStand3;            /* coding standard */
} TrCause;

typedef struct trServIndic6     /* tr6 service indicator tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 service;               /* service */
   TknU8 addInfo;               /* additional information */
} TrServIndic6;

typedef struct trChgeInfo6      /* tr6 charging information tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 quantity;              /* quantity of accumulated units */
   TknStr chargeInfo;           /* charging info */
} TrChgeInfo6;

typedef struct trDate6          /* tr6 date */
{
   ElmtHdr eh;                  /* element header */
   TknStrS trDate;              /* date */
} TrDate6;

typedef struct trFacSelect6     /* tr6 facility select tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 trFacSpec;             /* network specific facility specification */
   TknU8 service;               /* service */
} TrFacSelect6;

typedef struct trStatFac6       /* tr6 status of facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknStrS actvFac;             /* activated facility */
} TrStatFac6;

typedef struct trCdPtyStat6     /* tr6 status of called party tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 status;                /* status */
} TrCdPtyStat6;

typedef struct trAdTrmAttrb6    /* tr6 additional trsmssn attrbts tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 attrbts;               /* attributes */
   TknU8 flag;                  /* flag */
} TrAdTrmAttrb6;

typedef struct trNetFac         /* tr6 network specific facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 lenNetId;              /* length of network identification */
   TknStrS trFacSpec;           /* network specific facility specification */
} TrNetFac;
#endif

typedef struct callId           /* call identity tokens */
{
   ElmtHdr eh;                  /* element header */
   TknStrS callIdent;           /* call identity */
} CallId;


typedef struct facility         /* facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 srvDisc;               /* service discriminator */
   TknU8 compTag;               /* component tag */
   TknU8 form;                  /* form */
   TknU8 facClass;              /* facility class */
   TknU8 lenComp;               /* length of component */
   TknU8 lenForm;               /* length format */
   TknStr comp;                 /* component */
} Facility;

typedef struct facilityStr      /* facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknStrE  facilityStr;        /* Facility information */
} FacilityStr;

#ifdef QSIG
typedef struct qFacility         /* facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 protProfile;           /* Protocol Profile */
   TknStr qFacil;              /* component */
} QFacility;
#endif

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
typedef struct ntFacility       /* facility tokens for NT */
{
   ElmtHdr eh;                  /* element header */
   TknU8 srvDisc;               /* service discriminator */
   TknU8 srvIdent;              /* service identifier */
   TknStrS usrData;             /* user data */
} NtFacility;
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI */


#ifdef NTNI
typedef struct ntniFacility     /* facility tokens for NT-NI */
{
   ElmtHdr eh;                  /* element header */
   TknU8 protProf;              /* protocol profile */
   TknStrE usrData;             /* user data */
} NtNiFacility;
#endif /* NTNI */

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI) 
typedef struct tscFacility
{
  ElmtHdr eh;                  /* element header */
  TknU8 procId;                /* Process Identifier */
  TknU8 cntrlType;             /* Control Type */
  TknStrE srvElmts;            /* service elemnts */
} TscFacility;
#endif /* (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI) */


#ifdef VN2
typedef struct vnNetFac         /* vn3 network specific facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 lenNetId;              /* length of network identification */
   TknStr vnFacSpec;            /* network specific facility specification */
} VnNetFac;
#endif

#ifdef ETSI
typedef struct etsiNetFac       /* etsi network specific facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 lenNetId;              /* length of network identification */
   TknU8 netIdPlan;             /* network identification plan */
   TknU8 typeNetId;             /* type of network identification */
   TknStr netId;                /* network identification */
   TknStr etsiNetFacSpec;       /* network specific facility specification */
} EtsiNetFac;
#endif

#ifdef QSIG
typedef struct qPtyCat          /* party category tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 category;              /* party category */
} QPtyCat;

typedef struct qTranCntr        /* transit counter tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 counter;               /* counter */
} QTranCntr;
#endif

typedef struct netFac           /* network specific facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 lenNetId;              /* length of network identification */
   TknU8 netIdPlan;             /* network identification plan */
   TknU8 typeNetId;             /* type of network identification */
   TknStr netId;                /* network identification */
   TknU8 facCode;               /* facility coding value */
   TknU8 featServ;              /* feature or service */
   TknU8 exp;                   /* expansion bit */
   /* changed from TknU8 to TknStr for testing NTDMS250 */
   TknStr netFacSpec;           /* network specific facility specification */
} NetFac;

typedef struct notInd           /* notification indicator tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 notDesc;               /* notification description */
#if (ISDN_QSIG || ISDN_NTNI)
   TknStrE notDatStr;            /* notification data structure */
#endif
} NotInd;

#ifdef QSIG
typedef struct qSigInfoTran
{
   ElmtHdr eh;
   TknU8 qSigInfoTranType;
} QSigInfoTran;
#endif /* QSIG */

typedef struct facElmt          /* facility message element tokens */
{
   ElmtHdr eh;                  /* element header */
   TknStr facStr;               /* string for facility information */
} FacElmt;

typedef struct datTim           /* date time tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 year;                  /* year */
   TknU8 month;                 /* month */
   TknU8 day;                   /* day */
   TknU8 hour;                  /* hour */
   TknU8 minute;                /* minute */
   TknU8 second;                /* second */
} DatTim;

typedef struct keyFac           /* keypad facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknStr keyInfo;              /* keypad information */
} KeyFac;

typedef struct signal           /* signal tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 signal;                /* signal value */
} Signal;

typedef struct swtchk           /* switchook tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 swtchk;                /* switchook value */
} Swtchk;

typedef struct feaAct           /* feature activation tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   feaIdentNmb;         /* feature identifier number */
   TknU8   feaIdentNmb1;        /* feature identifier number */
} FeaAct;

typedef struct feaInd           /* feature indication tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8   feaIdentNmb;         /* feature identifier number */
   TknU8   feaIdentNmb1;        /* feature identifier number */
   TknU8   statInd;             /* status indicator */
} FeaInd;

typedef struct infoRate         /* information rate tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 incInfoRate;           /* incoming information rate */
   TknU8 outInfoRate;           /* outgoing information rate */
   TknU8 minIncInfoRate;        /* minimum incoming information rate */
   TknU8 minOutInfoRate;        /* minimum outgoing information rate */
} InfoRate;

typedef struct tranDlySel       /* transit delay selection and indication 
                                   tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU16 tranDlySelInd;        /* transit delay selection and indication 
                                   value */
} TranDlySel;

typedef struct pktBin           /* packet layer binary tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 fastSelect;            /* fast select */
   TknU8 expData;               /* expedited data */
   TknU8 deliveryCfm;           /* delivery confirmation */
   TknU8 modulo;                /* modulo */
} PktBin;

typedef struct pktWin           /* packet layer window size tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 fwdWdwSze;             /* forward window size value */
   TknU8 bckWdwSze;             /* backward window size value */
} PktWin;

typedef struct pktSze           /* packet layer packet size tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 fwdPktSze;             /* forward packet size value */
   TknU8 bckPktSze;             /* backward packet size value */
} PktSze;

typedef struct ntOrgCdNmb       /* NT original called party number tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 nmbPlanId;             /* numbering plan identification */
   TknU8 typeNmb;               /* type of number */
   TknU8 screenInd;             /* screening indicator */
   TknU8 presInd;               /* presentation indicator */
   TknU8 rsnRedirect;           /* reason for redirection */
   TknU8 redirCntr;             /* redirection counter */
   TknU8 cfwNoRply;             /* call forwarding no reply indicator */
   TknStrS nmbDigits;           /* number digits */
} NtOrgCdNmb;

typedef struct genericDig       /* Generic Digit tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 typeDigit;             /* type of digits */
   TknU8 encScheme;             /* encoding scheme */
   TknStrS genDig;              /* generic digits */
} GenericDig;

typedef struct busGrp           /* Business Group tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 ptySel;                /* party selector */
   TknU8 lpii;                  /* line privilege info indicator */
   TknU8 attSt;                 /* attendant status */
   TknU32 busGrpId;             /* business group identifier */
   TknU16 subGrpId;             /* sub group identifier */
   TknU8 linePriv;              /* line privileges */
} BusGrp;

typedef struct ni1RedirnNmb     /* redirection number tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 nmbPlanId;             /* numbering plan identification */
   TknU8 typeNmb;               /* type of number */
   TknStrS nmbDigits;           /* number digits */
} NI1RedirNmb;

#ifdef NI1
typedef struct redirSad         /* redirecting subaddress tokens */
{
  ElmtHdr eh;
  TknU8 reserved;               /* reserved */
  TknStrS sadInfo;              /* subaddress information */
} RedirSad;

typedef struct displayTxt       /* display text tokens */
{
  ElmtHdr eh;
  TknU8 dispType;               /* display type */
  TknStr txtInfo;               /* text information */
} DisplayTxt;
#endif

#ifdef NI2
typedef struct cug              /* CUG tokens */
{
  ElmtHdr eh;
  TknU8 cugInd;                 /* cug indication */
  TknStrS cugIndCode;           /* cug index code */
} Cug;

typedef struct rvsChrg          /* reverse charge indicator tokens */
{
  ElmtHdr eh;
  TknU8 rvsChrgInd;             /* reverse charge indication */
} RvsChrg;
#endif

typedef struct cnPtyNmb         /* called number tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 nmbPlanId;             /* numbering plan identification */
   TknU8 typeNmb1;              /* type of number */
   TknU8 screenInd;             /* screening indicator */
   TknU8 presInd0;              /* presentation indicator */
   TknStrS nmbDigits;           /* number digits */
} CnPtyNmb;

#define CgPtySad SubAdrs
#define CdPtySad SubAdrs

typedef struct llComp           /* low layer compatibility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 infoTranCap;           /* information transfer capability */
   TknU8 codeStand0;            /* coding standard */
   TknU8 negInd;                /* negotiation indicator */
   TknU8 infoTranRate0;         /* information transfer rate */
   TknU8 tranMode;              /* transfer mode */
#ifdef ITUT88
   TknU8 establish;             /* establishment */
   TknU8 cfg;                   /* configuration */
   TknU8 chanStruct;            /* structure */
   TknU8 infoTranRate1;         /* information transfer rate */
   TknU8 symmetry;              /* symmetry */
#else
   TknU8 rateMultiplier;        /* rate multiplier */
#endif
   TknU8 lyr1Ident;             /* layer 1 identity */
   TknU8 usrInfoLyr1Prot;       /* usr information layer 1 protocol */
   TknU8 usrRate;               /* user rate */
   TknU8 negot;                 /* negotiation */
   TknU8 syncAsync;             /* synchronous/asynchronous */
   TknU8 flcOnRx;               /* flow control on reception */
   TknU8 flcOnTx;               /* flow control on transmission */
   TknU8 nicOnRx;               /* network independent clock on reception */
   TknU8 nicOnTx;               /* network independent clock on transmission */
   TknU8 interRate;             /* intermediate rate */
   TknU8 inOutBandNegot;        /* inband/outband negotiation */
   TknU8 asgnrAsgne;            /* assignor/assignee */
   TknU8 logLnkNegot;           /* logical link identifier negotiation */
   TknU8 mode;                  /* mode of operation */
   TknU8 multiFrm;              /* multiple frame establishment support in 
                                   data link */
   TknU8 hdrNoHdr;              /* rate adaption header/no header */
   TknU8 parity;                /* parity information */
   TknU8 nmbDatBits;            /* number of data bits excluding parity bit */
   TknU8 nmbStopBits;           /* number of stop bits */
   TknU8 modemType;             /* modem type */
   TknU8 duplexMode;            /* duplex mode */
   TknU8 lyr2Ident;             /* layer 2 identity */
   TknU8 usrInfoLyr2Prot1;      /* user information layer 2 protocol */
   TknU8 optLyr2ProtInfo;       /* optional layer 2 protocol information */
   TknU8 lyr3Ident1;            /* layer 3 identity */
   TknU8 usrInfoLyr3Prot1;      /* user information layer 3 protocol */
   TknU8 optLyr3ProtInfo;       /* optional layer 3 protocol information */
} LlComp;



#ifdef VN2
typedef struct llCompF           /* low layer compatibility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 infoTranCap;           /* information transfer capability */
   TknU8 codeStand0;            /* coding standard */
   TknU8 negInd;                /* negotiation indicator */
   TknU8 infoTranRate0;         /* information transfer rate */
   TknU8 tranMode;              /* transfer mode */
   TknU8 establish;             /* establishment */
   TknU8 cfg;                   /* configuration */
   TknU8 chanStruct;            /* structure */
   TknU8 infoTranRate1;         /* information transfer rate */
   TknU8 symmetry;              /* symmetry */
   TknU8 lyr1Ident;             /* layer 1 identity */
   TknU8 usrInfoLyr1Prot;       /* usr information layer 1 protocol */
   TknU8 usrRate;               /* user rate */
   TknU8 negot;                 /* negotiation */
   TknU8 syncAsync;             /* synchronous/asynchronous */
   TknU8 flcOnRx;               /* flow control on reception */
   TknU8 flcOnTx;               /* flow control on transmission */
   TknU8 nicOnRx;               /* network independent clock on reception */
   TknU8 nicOnTx;               /* network independent clock on transmission */
   TknU8 interRate;             /* intermediate rate */
   TknU8 inOutBandNegot;        /* inband/outband negotiation */
   TknU8 asgnrAsgne;            /* assignor/assignee */
   TknU8 logLnkNegot;           /* logical link identifier negotiation */
   TknU8 mode;                  /* mode of operation */
   TknU8 multiFrm;              /* multiple frame establishment support in 
                                   data link */
   TknU8 hdrNoHdr;              /* rate adaption header/no header */
   TknU8 parity;                /* parity information */
   TknU8 nmbDatBits;            /* number of data bits excluding parity bit */
   TknU8 nmbStopBits;           /* number of stop bits */
   TknU8 modemType;             /* modem type */
   TknU8 duplexMode;            /* duplex mode */
   TknU8 usrInfoLyr2Prot1;      /* user information layer 2 protocol */
   TknU8 lyr2Ident;             /* layer 2 identity */
   TknU8 optLyr2ProtInfo;       /* optional layer 2 protocol information */
   TknU8 usrInfoLyr3Prot1;      /* user information layer 3 protocol */
   TknU8 lyr3Ident1;            /* layer 3 identity */
   TknU8 optLyr3ProtInfo;       /* optional layer 3 protocol information */
} LlCompF;
#endif


typedef struct usrUsrE          /* user - user tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 protocolDisc;          /* protocol discriminator */
   TknStrE usrInfo;             /* user information */
} UsrUsrE;

#ifdef INTR6
typedef struct trUsrUsr         /* user - user tokens */
{
   ElmtHdr eh;                  /* element header */
   TknStr usrInfo;              /* user information */
} TrUsrUsr;
#endif

#ifdef VN2
typedef struct vnUsrFac         /* user - user facility tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 usrProtclDisc;         /* protocol discriminator */
   TknStr usrFacil;             /* user facility */
} VnUsrFac;
#endif

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI || ISDN_NTNI)
typedef struct ntDisplay        /* display tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 dispTypeNt;            /* display type */
   TknU8 assocInfo;             /* associate information */
   TknStr dispInfo;             /* display information */
} NtDisplay;
#endif

typedef struct infoReq          /* information request tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 infoType;              /* type of information */
   TknU8 infoReqInd;            /* info request indicator */
#if (ISDN_NT || ISDN_NTDMS250)
   TknU8 infoSpec;              /* info specific */
#endif
} InfoReq;

typedef struct servProf         /* service profile tokens */
{                         
   ElmtHdr eh;                  /* element header */
   TknStr servProfIdent;        /* service profile identifier */
} ServProf;

typedef struct endpoint         /* endpoint tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 usrServIdent;          /* user service identifier */
   TknU8 termIdent;             /* terminal identifier */
   TknU8 interpr;               /* interpritor */
} Endpoint;

typedef struct termCapab        /* terminal capabilities tokens*/
{
   ElmtHdr eh;                  /* element header */
   TknU8 capabDescr;            /* capability description */
   TknU8 codeStand;             /* coding standard */
}TermCapab;

typedef struct chStatus         /* change status tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 newStatus;             /* new status */
   TknU8 preference;            /* preference */
} ChStatus;

#ifdef NTT
typedef struct nttAdvChrge6     /* NTT advice of charge tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 indicType;             /* indication type */
   TknStr chrgeData;            /* charging data */
}NttAdvChrge6;

typedef struct nttBlkChanId     /* blocking channel tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 infoChanSel;           /* information channel selection */
   TknU8 intType;               /* interface type */
   TknU8 intIdentPres;          /* interface identifier present */
   TknU16 intIdent;              /* interface identifier */
   TknU8 chanMapType;           /* channel type/map type */
   TknU8 nmbMap;                /* number/map */
   TknU8 codeStand1;            /* coding standard */
   TknStrM chanNmbSlotMap;      /* channel number/slot map */
} NttBlkChanId;
#endif

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTNI)
typedef struct ntOperSysAcc5    /* NT operator system access tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 typeAcc;               /* type of service */
   TknU8 typeServ;              /* type of access */
#ifdef ISDN_NTSPRINT
   TknU8 intTypeAcc;            /* international type of access */
   TknU8 cgPtyCtg;              /* calling party category */
#endif /* ISDN_NTSPRINT */
} NtOperSysAcc5;
#endif

#if (ISDN_NI1 || ISDN_NI2)
typedef struct niOperSysAcc     /* NI operator system access tokens */
{
   ElmtHdr eh;                  /* element header */
   TknU8 typeAcc;               /* type of service */
   TknU8 typeServ;              /* type of access */
} NIOperSysAcc;
#endif

#ifdef ATT
typedef struct manInfo6         /* Management Information element */
{
   ElmtHdr eh;                  /* element header */
   TknU8 protDisc;              /* transaction reference */
   TknU8 transRef;              /* transaction reference */
   TknU8 operType;              /* operation type */
   TknU8 operClass;             /* operation class */
   TknU8 code;                  /* code */
   TknU8 paramId;               /* parameter ID */
   TknU8 paramLen;              /* parameter length */
   TknStrS params;              /* parameters */
} ManInfo6;
#endif

#if (ISDN_303TMC || ISDN_303CSC)
typedef struct bcCallRef        /* Call Reference */
{
   ElmtHdr eh;                  /* element header */
   TknU16 reference;            /* Call Reference */
} BCCallRef;
#endif

#ifdef ATT
typedef struct attOrigLineInfo    /* Originating Line Information */
{
   ElmtHdr eh;
   TknU8 infoIndicator;      /* Information Indicator */
} AttOrigLineInfo;
#endif /* ATT */

#if (ISDN_NT || ISDN_NTSPRINT || ISDN_NTMCI)
typedef struct ntOrig           /* Origination */
{
   ElmtHdr eh;                  /* element header */
   TknU8 encoding;              /* encoding */
   TknU8 routing;               /* routing */
   TknU32 pvtNetIdent;          /* private network identifier */
   TknU8 length;                /* length of routing information */
   TknStr routingInfo;          /* routing information */
}NtOrig;

typedef struct ntDest           /* Destination */
{
   ElmtHdr eh;                  /* element header */
   TknU8 encoding;              /* encoding */
   TknU8 routing;               /* routing */
   TknU32 pvtNetIdent;          /* private network identifier */
   TknU8 length;                /* length of routing information */
   TknStr routingInfo;          /* routing information */
}NtDest;
#endif /* (ISDN_NT || ISDN_NTSPRINT || ISDN_NTMCI) */

#ifdef NT
typedef struct ntOpt            /* Options */
{
   ElmtHdr eh;                  /* element header */
   TknU8 options;               /* options */
}NtOpt;

typedef struct ntRsnRet         /* Reason for Return */
{
   ElmtHdr eh;                  /* element header */
   TknU8 diagnostics;           /* diagnostic */
}NtRsnRet;
#endif /* NT */


/***********************************************************************/
/*                      Message Element Lists*/
/***********************************************************************/


typedef struct alerting         /* Alerting message */
{
#ifdef VN2
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
#endif
#ifdef INTR6
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#endif
   ChanId chanId;               /* Channel Identification Element */
   Facility facility;           /* Facility Element */
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];      /* Facility Element */
#endif
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   NtFacility ntFacility;       /* Facility Element */
#endif
#ifdef NTMCI
   NtFacility ntFacility1;      /* Facility Element */
#endif /* NTMCI */

   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Repeated Progress Indication. */
   ProgInd progInd2;            /* Repeated Progress Indication. */
   ProgInd progInd3;            /* Repeated Progress Indication. */
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
#ifdef ATT
   TermCapab termCapab;         /* Terminal Capability */
#endif
#ifdef QSIG
   NotInd notInd;               /* Notification Indication Element */
#endif
   Display display;             /* Display Element */
   Signal signal;               /* Signal Element */
   FeaAct feaAct;               /* Feature Activation Element */
   FeaInd feaInd;               /* Feature Indication Element */
   RedirNmb redirNmb;           /* Redirecting Number Element */
#ifdef NTMCI
   NtDisplay ntDisplay1;        /* Display Element */
#endif
#ifdef VN2
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
#if (ISDN_NT || ISDN_NTSPRINT)
   RedirNmb redirNmn;           /* NT Re-direction Number element */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NTMCI
   Shift shift9;                /* Shift Element */
   ElmtStr ntOctStr;             /* NT Octet String */
#endif
#ifdef NI1
   Shift shift5;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
#ifdef QSIG
   Shift shift6;                /* Shift Element */
   QPtyCat qPtyCat;             /* Party Category  Element */
#endif
#ifdef INTR6
   Shift shift4;                /* Shift Element */
   TrCdPtyStat6 trCdPtyStat6;   /* INTR6 Called Party Status */
#endif
#ifdef ATT 
   Shift shift2;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attLlcId6;           /* ATT Logical Link Id */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift3;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} Alerting;



typedef struct callProc         /* Call Proceeding message */
{
   ChanId chanId;               /* Channel Identification Element */
   Facility facility;           /* Facility Element */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Repeated Progress Indication. */
   ProgInd progInd2;            /* Repeated Progress Indication. */
   ProgInd progInd3;            /* Repeated Progress Indication. */
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
#ifdef ATT
   TermCapab termCapab;         /* Terminal Capability */
#endif
   NotInd notInd;               /* Notification Indication Element */
   Display display;             /* Display Element */
#ifdef NI1
   InfoReq infoReq;             /* Information Request element */
#endif
   Signal signal;               /* Signal Element */
   FeaInd feaInd;               /* Feature Indication Element */
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
#ifdef NI1
   /*   CdPtySad cdPtySad;*/           /* Called Party Subaddress Element */
   SubAdrs cdPtySad;
   NI1RedirNmb redirNmb;        /* redirecting Number Element */
   Shift shift2;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift3;                /* Shift Element */
   NI1RedirNmb ni1RedirNmb7;    /* redirecting Number Element */
#endif
#ifdef NTMCI
   UsrUsr usrUsr;               /* User to User Element */
   Shift shift10;               /* Shift Element */
   ElmtStr nOctStr;             /* NT Octet String */
#endif
#ifdef ATT
   Shift shift1;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attLlcId6;           /* ATT Logical Link Id */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} CallProc;


typedef struct conn             /* Connect message */
{
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
   ChanId chanId;               /* Channel Identification Element */
   Facility facility;           /* Facility Element */
#if 1 /* Boris Facility IE for ETSI */
   FacilityStr facilityStr; 	/*Facility String Element */
#endif
#ifdef NTNI
   NtNiFacility ntniFacility;   /* Facility Element */
#endif
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];      /* Facility Element */
#endif
#ifdef NTMCI
   NtFacility ntFacility[IN_MF_MAX_REPELMT];    /* Nt Facility ELement */
#endif /* NTMCI */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
   NotInd notInd;               /* Notification Indication Element */
#ifdef INTR6
   TrNetFac trNetFac;           /* TR Network Specific Facilities Element */
#endif
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
#ifdef ATT
   TermCapab termCapab;         /* Terminal Capability */
#endif
   Display display;             /* Display Element */
#ifdef NTMCI
   NtDisplay ntDisplay;         /* Display Element */
#endif
#ifdef ETSI
   DatTim datTim;               /* Date/Time Element */
#endif
   Signal signal;               /* Signal Element */
   Swtchk swtchk;               /* Switchook Element */
   FeaAct feaAct;               /* Feature Activation Element */
   FeaInd feaInd;               /* Feature Indication Element */
#if (ISDN_ETSI || ISDN_QSIG || ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb cnPtyNmb1;          /* Connected Number Element */
#endif /* (ETSI || QSIG || NTMCI || NT || NTDMS250 || ATT) */
#if (ISDN_ETSI || ISDN_QSIG || ISDN_NTMCI)
   SubAdrs cgPtySad;            /* Connected subaddress Element */
#endif
   RedirNmb redirNmb;           /* redirecting Number Element */
   LlComp llComp;               /* Low Layer Compatibility Element */
#ifdef VN2
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NTMCI
   Shift shift7;                /* Shift Element */
   ElmtStr ntOctStr;            /* NT Octet String */
#endif
#ifdef NI1
   Shift shift5;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
#ifdef QSIG
   Shift shift6;                /* Shift Element */
   QPtyCat qPtyCat;             /* Party Category  Element */
#endif
#ifdef INTR6
   Shift shift4;                /* Shift Element */
   TrServIndic6 trServIndic6;   /* Service Indicator */
   Shift shift41;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
   Shift shift42;                /* Shift Element */
   TrDate6 trDate6;             /* Date */
#endif
#ifdef ATT
   Shift shift2;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attLlcId6;           /* ATT Logical Link Id */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attPktLyrParms6;     /* ATT Packet Layer Parameters */
   ElmtStr attLnkLyrParms6;     /* ATT Link Layer Parameters */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attThrptCls6;        /* ATT Throughput Class */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift3;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} Conn;


typedef struct connAck          /* Connect Acknowledge message */
{
#ifdef NT
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#endif
   ChanId chanId;               /* Channel Identification Element */
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
   NotInd notInd;               /* Notification Indication Element */
   Display display;             /* Display Element */
   Signal signal;               /* Signal Element */
#ifdef VN2
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NI1
   Shift shift4;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
#ifdef INTR6
   Shift shift3;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
   Shift shift31;                /* Shift Element */
   TrDate6 trDate6;             /* Date */
#endif
#ifdef ATT
   Shift shift2;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attDsplFld6;         /* ATT Display Field */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} ConnAck;


typedef struct progress         /* Progress message */
{
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
#ifdef ATT 
   ChanId chanId;               /* Channel Identification Element */
#endif
#ifdef NT
   Facility facility;           /* Facility Element */
#endif
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];      /* Facility Element */
#endif
#if (ISDN_NTMCI || ISDN_NTDMS250)
   NtFacility ntFacility[IN_MF_MAX_REPELMT];    /* Nt Facility ELement */
#endif /* (ISDN_NTMCI || ISDN_NTDMS250) */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
   NotInd notInd;               /* Notification Indication Element */
   Display display;             /* Display Element */
#ifdef NTMCI
   NtDisplay ntDisplay;         /* Display Element */
#endif
   Signal signal;               /* Signal Element */
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NI1
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
#ifdef ATT 
   Shift shift;                 /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attDsplFld6;         /* ATT Display Field */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} Progress;


typedef struct setup            /* Setup message */
{
   SndCmplt sndCmplt;           /* Sending Complete Element */
   RepInd repInd;               /* Repeat Indicator Element */
   BearCap bearCap[IN_MF_MAX_REPELMT];/* Bearer Capability Element */
#ifdef ATT
   CallId callId;               /* Call Identification Element */
#endif
   ChanId chanId;               /* Channel Identification Element */
   Facility facility;           /* Facility Element */
   Facility facility1;           /* Facility Element */
   FacilityStr facilityStr;     /* Facility Element */

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   NtFacility ntFacility;       /* Facility Element */
#endif

#ifdef NTMCI
   NtFacility ntFacility1;      /* Facility Element */
#endif /* NTMCI */

#ifdef NTNI
   NtNiFacility ntniFacility;   /* Facility Element */
#endif

#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];      /* Facility Element */
#endif
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;             /* Progress Indication Element */
   ProgInd progInd2;             /* Progress Indication Element */
   ProgInd progInd3;             /* Progress Indication Element */
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
#endif
#ifdef INTR6
   TrNetFac trNetFac;           /* Network Specific Facilities Element */
#endif
#ifdef ETSI
   EtsiNetFac etsiNetFac;       /* etsi Network Specific Facilities Element */
#endif
   NetFac netFac[IN_MF_MAX_IE];    /* Network Specific Facilities Element */
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
#ifdef ATT
   TermCapab termCapab;         /* Terminal Capability */
#endif
#ifdef QSIG
   NotInd notInd;               /* Notification Indication Element */
#endif
   Display display;             /* Display Element */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   NtDisplay ntDisplay[IN_MAX_DISPLAY];   /* Display Element */
#endif
   KeyFac keyFac;               /* Keypad Facilities Element */
   Signal signal;               /* Signal Element */
#ifdef BC303CSC
   Signal signal1;              /* Signal Element */
#endif
   Swtchk swtchk;               /* Switchook Element */
   FeaAct feaAct;               /* Feature Activation Element */
   FeaInd feaInd;               /* Feature Indication Element */
   Endpoint endPoint;           /* Endpoint Identifier element */
   InfoRate infoRate;           /* information rate tokens */
   EtoeDly etoeDly;             /* end to end transit delay tokens */
   TranDlySel tranDlySel;       /* transit delay selection and indictn tokens*/
   PktBin pktBin;               /* packet layer binary tokens */
   PktWin pktWin;               /* packet layer window size tokens */
   PktSze pktSze;               /* packet layer packet size tokens */
#ifdef NI2
   Cug cug;                     /* closed user group */
   RvsChrg rvsChrg;             /* reverse charge indicator */
#endif
#if (ISDN_ETSI || ISDN_QSIG)
   CgPtySad cgPtySad1;          /* Calling Party Subaddress Element */
#endif
   CgPtyNmb cgPtyNmb;           /* Calling Party Number Element */
#ifdef INTR6
   CgPtyNmb cgPtyNmb1;          /* Calling Party Number Element */
#endif
#if 1 /* Boris added second calling party Number */
   CgPtyNmb cgPtyNmb2;          /* Calling Party Number Element */
#endif
   CgPtySad cgPtySad;           /* Calling Party Subaddress Element */
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
   CdPtySad cdPtySad;           /* Called Party Subaddress Element */
   NtOrgCdNmb ntOrgCdNmb;       /* NT Called Party Number element */
   RedirNmb redirNmb;           /* redirecting Number Element */
#if (ISDN_NI2 || ISDN_NTNI)
   RedirNmb redirNmb1;           /* redirecting Number Element */
#endif /* (ISDN_NI2 || ISDN_NTNI) */
   TrnstNtw trnstNtw;           /* Transit Network Element */
#ifdef VN2
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
   LlCompF llComp1;              /* Low Layer Compatibility Element */
#endif
   LlComp llComp;               /* Low Layer Compatibility Element */
   HlComp hlComp;               /* High Layer Compatibility Element */
   UsrUsr usrUsr;               /* User to User Element */
#ifdef INTR6
   Shift shift6;                /* Shift Element */
   TrServIndic6 trServIndic6;   /* Service Indicator */
   Shift shift61;                /* Shift Element */
   TrAdTrmAttrb6 trAdTrmAttrb6; /* Service Indicator */
#endif
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTNI)
   Shift shift7;                /* Shift5 Element */
#ifdef DECODCDSET
   NtOperSysAcc5 operSysAcc5;   /* Operator System Access Element */
#ifdef ISDN_NTSPRINT
   BusGrp busGrp;               /* Business Group Element */
#endif /* ISDN_NTSPRINT */
#else
   ElmtStr ntOctStr;             /* octet string */
#endif /* DECODCDSET */
#endif /* ISDN_NT || ISDN_NTNI || ISDN_NTDMS250 */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   Shift shift8;                /* Shift6 Element */
#if ISDN_NTMCI
   ElmtStr ntMCIOctStr;         /* octet string */
#endif /* ISDN_NTMCI */
#ifdef DECODCDSET
#ifdef ISDN_NT
   ElmtStr ntCallApear6;        /* NT Call Apearance element */
#endif
#ifdef ISDN_NTSPRINT
   GenericDig genericDig;       /* Generic Digit */
#endif
#else
   ElmtStr ntOctStr1;             /* octet string */
#endif /* DECODCDSET */
   Shift shift13;               /* Shift7 Element */
   ElmtStr ntOctStr2;           /* NT Octet String */
#endif /* (ISDN_NT || ISDN_NTNI || ISDN_NTDMS250) */
#if (ISDN_NI1 || ISDN_NI2)
   Shift shift9;                /* Shift Element */
   NIOperSysAcc operSysAcc;     /* Operator System Access Element */
#endif
#ifdef NI1
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift3;                /* Shift Element */
   RedirSad redirSad;           /* Redirecting Subaddress */
   ElmtStr niCallApear;         /* NI1 Call Apearance element */
#endif
#ifdef QSIG
   Shift shift10;               /* Shift Element */
   QTranCntr qTranCntr;         /* Transit Counter  Element */
   QPtyCat qPtyCat;             /* Party Category  Element */
#endif
   /* Sangoma add new code set 6 IEs */
#ifdef NI2
  Shift shift11;                 /* Shift Element */
  ElmtStr ni2OctStr;            /* Octet String */
#endif   
#ifdef ATT
   Shift shift4;                /* Shift Element */
/*   AttOrigLineInfo attOrigLineInfo;*/ /* ATT Originating Line Info */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attUsrCode6;         /* ATT User Code */
   ElmtStr attLlcId6;           /* ATT Logical Link Id */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attSelCllApp6;       /* ATT Selected Call Appearence */
   ElmtStr attOrgCllApp6;       /* ATT Origination Call Appearence */
   ElmtStr attDstCllApp6;       /* ATT Destination Call Appearence */
   ElmtStr attEndpoint6;        /* ATT Endpoint Identifier */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attFeaAct6;          /* ATT Feature Activation */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attPktLyrParms6;     /* ATT Packet Layer Parameters */
   ElmtStr attLnkLyrParms6;     /* ATT Link Layer Parameters */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attThrptCls6;        /* ATT Throughput Class */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift5;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} Setup;


typedef struct setupAck         /* Setup Acknowledge message */
{
   ChanId chanId;               /* Channel Identification Element */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
   Display display;             /* Display Element */
#ifdef NT
   NotInd notInd;               /* Notification Indication Element */
#endif
#ifdef NI1
   InfoReq infoReq;             /* Information Request element */
#endif
   Signal signal;               /* Signal Element */
#ifdef NI1
   FeaInd feaInd;               /* Feature Indication Element */
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
#ifdef ATT
   Shift shift;                 /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attDsplFld6;         /* ATT Display Field */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} SetupAck;


typedef struct rsm              /* Resume message */
{
   CallId callId;               /* Call Identification Element */
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
#ifdef INTR6
   Shift shift1;                /* Shift Element */
   TrServIndic6 trServIndic6;   /* Service Indicator */
#endif
} Rsm;


typedef struct rsmAck           /* Resume Acknowledge message */
{
   ChanId chanId;               /* Channel Identification  Element */
   Display display;             /* Display Element */
#ifdef INTR6
   Shift shift;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
#endif
} RsmAck;


typedef struct rsmRej           /* Resume Reject message */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   Display display;             /* Display Element */
#ifdef NTT
   Shift shift;                 /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
#endif
} RsmRej;


typedef struct susp             /* Suspend message */
{
   CallId callId;               /* Call Identification Element */
} Susp;


typedef struct suspAck          /* Suspend Acknowledge message */
{
   Display display;             /* Display Element */
} SuspAck;


typedef struct suspRej          /* Suspend Reject message */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   Display display;             /* Display Element */
} SuspRej;


typedef struct usrInfo          /* User Information message */
{
#ifdef VN2
   Shift shift;                 /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
   MoreData moreData;           /* More Data Element */
   UsrUsrE usrUsr;              /* User to User Element */
#ifdef INTR6
   TrUsrUsr trUsrUsr;           /* User to User Element */
#endif
#ifdef ATT
   Shift shift1;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift2;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} UsrInfo;


#ifdef ISDN_HOLD
typedef struct hold             /* Hold message */
{
   Display display;             /* Display Element */
#ifdef NI1
   Signal signal;               /* Signal Element */
   FeaInd feaInd;               /* Feature Indication Element */
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} Hold;


typedef struct holdAck          /* Hold Acknowledge message */
{
#if (ISDN_NI1 || ISDN_NT)
   NotInd notInd;               /* Notification Indication Element */
#endif /* ISDN_NI1 || ISDN_NT */
   Display display;             /* Display Element */
#if (ISDN_NI1 || ISDN_NT)
   Signal signal;               /* Signal Element */
#endif /* ISDN_NI1 || ISDN_NT */
#ifdef NI1
   FeaInd feaInd;               /* Feature Indication Element */
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} HoldAck;


typedef struct holdRej          /* Hold Reject message */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn;           /* Cause and Diagnostic Element */
   Display display;             /* Display Element */
#ifdef NI1
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} HoldRej;


typedef struct ret              /* Retrieve message */
{
   ChanId chanId;               /* Channel Identification Element */
   Display display;             /* Display Element */
} Ret;


typedef struct retAck           /* Retrieve Acknowledge message */
{
   ChanId chanId;               /* Channel Identification Element */
#if (ISDN_NT || ISDN_NI1)
   NotInd notInd;               /* Notification Indication Element */
#endif /* (ISDN_NT || ISDN_NI1) */
#ifdef NT
   NotInd notInd5;               /* Notification Indication Element */
#endif /* NT */
   Display display;             /* Display Element */
#ifdef NI1
   Signal signal;               /* Signal Element */
   FeaInd feaInd;               /* Feature Indication Element */
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} RetAck;


typedef struct retRej           /* Retrieve Reject message */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn;           /* Cause and Diagnostic Element */
   Display display;             /* Display Element */
#ifdef NI1
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} RetRej;
#endif


typedef struct disc             /* Disconnect message */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   Facility facility;           /* Facility Element */
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif
#ifdef NTMCI
   NtFacility ntFacility[IN_MF_MAX_REPELMT];      /* Facility Element */
#endif /* NTMCI */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
#endif
#ifdef INTR6
   TrNetFac trNetFac;           /* INTR6 Network Specific Facilities Element */
#endif
#ifdef QSIG
   NotInd notInd;               /* Notification Indication Element */
#endif
   Display display;             /* Display Element */

#if (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#endif /* (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT) */

#ifdef NTMCI
   NtDisplay ntDisplay1;        /* Display Element */
   CgPtySad cnPtySad;           /* Connected Party Subaddress Element */
#endif
#ifdef NI1
   InfoReq infoReq;             /* Information Request element */
#endif
   Signal signal;               /* Signal Element */
#ifdef ATT
   Swtchk swtchk;               /* Switchook Element */
#endif
   FeaInd feaInd;               /* Feature Indication Element */
#ifdef VN2
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
#ifdef NI1
   NI1RedirNmb redirNmb;        /* redirecting Number Element */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NTMCI
   Shift shift7;                /* Shift Element */
   ElmtStr ntOctStr;            /* NT Octet String Element */
#endif 
#ifdef NI1
   Shift shift5;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift6;                /* Shift Element */
   NI1RedirNmb ni1RedirNmb7;    /* redirecting Number Element */
#endif
#ifdef INTR6
   Shift shift4;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
   Shift shift41;               /* Shift Element */
   TrDate6 trDate6;             /* Date */
#endif
#ifdef ATT
   Shift shift;                 /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift2;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
#ifdef NTT
   Shift shift3;                /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
#endif
} Disc;


typedef struct rel              /* Release message */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
#ifdef INTR6
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#endif
#ifdef NI1
   ChanId chanId;               /* Channel Identification Element */
#endif
   Facility facility;           /* Facility Element */
#ifdef NTNI
   NtNiFacility ntniFacility;   /* Facility Element */
#endif
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
   Display display;             /* Display Element */
#ifdef NTMCI
   NtDisplay ntDisplay1;        /* Display Element */
#endif
#ifdef NI1
   InfoReq infoReq;             /* Information Request element */
#endif
   Signal signal;               /* Signal Element */
   FeaInd feaInd;               /* Feature Indication Element */

#if (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb cnPtyNmb2;           /* Connected Number Element */
#endif /* (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT) */

#ifdef NTMCI
   CgPtySad cnPtySad;           /* Connected Party Subaddress Element */
#endif

#ifdef VN2
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
   CdPtySad cdPtySad;           /* Called Party Subaddress Element */
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
#ifdef NI1
   NI1RedirNmb redirNmb;        /* redirecting Number Element */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NI1
   Shift shift6;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift7;                /* Shift Element */
   NI1RedirNmb ni1RedirNmb7;    /* redirecting Number Element */
#endif
#ifdef NTMCI
   Shift shift8;                /* Shift Element */
   ElmtStr ntOctStr;            /* NT Octet String */
#endif
#ifdef INTR6
   Shift shift5;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
   /* commented out as not there in pack/unpack */
   Shift shift51;               /* Shift Element */
   TrDate6 trDate6;             /* Date */
#endif
#ifdef NTT
   Shift shift4;                /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
#endif
#ifdef ATT
   Shift shift2;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attSelCllApp6;       /* ATT Selected Call Appearence */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attKeyPadCtl6;       /* ATT Keypad Control */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift3;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} Rel;


typedef struct relCmplt         /* Release Complete message */
{
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   Facility facility;           /* Facility Element */
#ifdef NTNI
   NtNiFacility ntniFacility;   /* Facility Element */
#endif
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
   Display display;             /* Display Element */
#ifdef NTMCI
   NtDisplay ntDisplay1;        /* Display Element */
#endif
#ifdef NI1
   InfoReq infoReq;             /* Information Request element */
#endif
   Signal signal;               /* Signal Element */
   FeaInd feaInd;               /* Feature Indication Element */

#if (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#endif /* (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT) */

#ifdef NTMCI
   CgPtySad cnPtySad;           /* Connected Party Subaddress Element */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NI1
   NI1RedirNmb redirNmb;        /* NT Re-direction Number element */
   Shift shift4;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift5;                /* Shift Element */
   NI1RedirNmb redirNmb1;       /* redirecting Number Element */
#endif
#ifdef NTMCI 
   Shift shift8;                /* Shift Element */
   ElmtStr ntOctStr;            /* NT Octet String */
#endif
#ifdef NTT
   Shift shift3;                /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
#endif
#ifdef ATT
   Shift shift1;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attSelCllApp6;       /* ATT Selected Call Appearence */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */

   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift2;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
#ifdef ISDN_NTSPRINT
   Shift shift9;                 /* Shift 6 Element */
   TscFacility tscFacility;     /* Temporary signalling facility Element */
#endif /* ISDN_NTSPRINT */
} RelCmplt;


typedef struct rst              /* Restart message */
{
   ChanId chanId;               /* Channel Identification Element */
   Display display;             /* Display Element */
   RstInd rstInd;               /* Restart Indicator Element */
} Rst;


typedef struct rstAck           /* Restart Acknowledge message */
{
   ChanId chanId;               /* Channel Identification Element */
   Display display;             /* Display Element */
   RstInd rstInd;               /* Restart Indicator Element */
} RstAck;


typedef struct segment          /* Segment message */
{
   NullElmt nullElmt;           /* Null Element */
} Segment;


typedef struct congCntrl        /* Congestion Control message */
{
   CongLvl congLvl;             /* Congestion Level Element */
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   Display display;             /* Display Element */
} CongCntrl;


typedef struct info             /* Information message */
{
   SndCmplt sndCmplt;           /* Sending Complete Element */
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   ChanId chanId;               /* Channel Identification Element */
#ifdef NI1
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
#endif
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
#endif
#ifdef INTR6
   TrNetFac trNetFac;           /* INTR6 Network Specific Facilities Element */
#endif
   Display display;             /* Display Element */
   KeyFac keyFac;               /* Keypad Facilities Element */
   InfoReq infoReq;             /* Information Request element */
   Signal signal;               /* Signal Element */
   Swtchk swtchk;               /* Switchook Element */
   FeaAct feaAct;               /* Feature Activation Element */
   FeaInd feaInd;               /* Feature Indication Element */
   ServProf servProf;           /* Service Profile Identification element */
   Endpoint endPoint;           /* Endpoint Identifier element */
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
#ifdef NI1
   NI1RedirNmb redirNmb;        /* redirecting Number Element */
   Shift shift3;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift4;                /* Shift Element */
   NI1RedirNmb redirNmb1;       /* redirecting Number Element */
#endif
#ifdef INTR6
   Shift shift2;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
#endif
#ifdef NT
   Shift shift;                 /* Shift Element */
#ifdef DECODCDSET
   ElmtStr ntPrVerCtrl6;        /* NT protocol version control element */
#else
   ElmtStr nOctStr;             /* octet string */
#endif
#endif
#ifdef ATT
   Shift shift1;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attSelCllApp6;       /* ATT Selected Call Appearence */
   ElmtStr attKeyPadCtl6;       /* ATT Keypad Control */
   ElmtStr attOthrCllRef6;      /* ATT Other Call Reference */
   ElmtStr attFeaAct6;          /* ATT Feature Activation */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplCtrl6;        /* ATT Display Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
#else
   ElmtStr octStr;              /* Octet String */
#endif
#endif
#ifdef NTT
   Shift        nttshift2;         /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
   NttBlkChanId bChanId;        /* Blocking Channel Identifier */
#endif
} Info;


typedef struct notify           /* Notify message */
{
   BearCap bearCap[IN_MF_MAX_REPELMT];/* Bearer Capability Element */
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
   Facility facility;           /* Facility Element */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
   NotInd notInd;               /* Notification Indication Element */
#ifdef QSIG
   NotInd notInd1;              /* Notification Indication Element */
   NotInd notInd2;              /* Notification Indication Element */
   NotInd notInd3;              /* Notification Indication Element */
   NotInd notInd4;              /* Notification Indication Element */
#endif
   Display display;             /* Display Element */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   NtDisplay ntDisplay[IN_MAX_DISPLAY];         /* Display Element */
#endif
   InfoReq infoReq;             /* Information Request element */
#ifdef NI1
   Signal signal;               /* Signal Element */
#endif
   FeaInd feaInd;               /* Feature Indication Element */
#ifdef NI1
   Endpoint endPoint;           /* Endpoint Identifier element */
#endif

#if (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb conNmb;           /* Connected Number Element */
#endif /* (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT) */

   CgPtyNmb cgPtyNmb;           /* Calling Party Number Element */
#ifdef NI1
   CgPtySad cgPtySad;           /* Calling Party Subaddress Element */
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
   CdPtySad cdPtySad;           /* Called Party Subaddress Element */
#endif
#if (ISDN_NTDMS250 || ISDN_NTMCI)
   RedirNmb redirNmb;           /* NT Re-directing Number element */
#endif
   RedirNmb redirNmb1;          /* NT Re-direction Number element */
#ifdef NI1
   UsrUsr usrUsr;               /* User to User Element */
   Shift shift;                 /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift1;                /* Shift Element */
   ElmtStr niCallApear;         /* NI1 Call Apearance element */
#endif
} Notify;


typedef struct status           /* Status message */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   CallSte callSte;             /* Call State Element */
   Display display;             /* Display Element */
#ifdef NI1
   Shift shift;                 /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} Stat;


typedef struct statEnq          /* Status Enquiry message */
{
   Display display;             /* Display Element */
#ifdef NI1
   Shift shift;                 /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} StatEnq;


typedef struct facil            /* Facility message */
{
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif /* QSIG */
#if (ISDN_NTNI)
   NtNiFacility ntniFacility;   /* Facility Element for NTSPRINT */
#endif /* ISDN_NTNI */
#if (ISDN_NTDMS250 || ISDN_NTMCI)
   NtFacility ntFacility1;       /* Facility Element for NTSPRINT */
#endif /*(ISDN_NTDMS250 || ISDN_NTMCI)*/

#ifdef NTMCI
   NtFacility ntFacility2;      /* Facility Element for NTSPRINT */
#endif /* NTMCI */

#ifdef QSIG
   NotInd notInd;               /* Notification indicator.  */
   CgPtyNmb cgPtyNmb;           /* Calling party number.    */
   CdPtyNmb cdPtyNmb;           /* Called party number.     */
#endif /* QSIG */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   Shift shift;                 /* Shift 6 Element */
   NtOrig ntOrig;               /* Origination Element */
   NtDest ntDest;               /* Destination Element */
#endif /* (ISDN_NT || ISDN_NTSPRINT || ISDN_NTMCI) */
#ifdef NT
   NtRsnRet ntRsnRet;           /* Reason for Return Element */
   NtOpt ntOptions;             /* Options Element */
#endif /* NT */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
  TscFacility tscFacility;
#endif /* (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI) */
#if !(ISDN_QSIG || ISDN_NT || ISDN_NTDMS250)
   NullElmt nullElmt;           /* Null Element */
#endif /* !(ISDN_QSIG || ISDN_NT || ISDN_NTDMS250) */

} Facil;


typedef struct reg              /* Register message */
{
#ifdef ISDN_NTSPRINT 
   Shift shift;                 /* Shift 6 Element */
   TscFacility tscFacility;     /* Temporary signalling facility Element */
#else
   NullElmt nullElmt;           /* Null Element */
#endif /* ISDN_NTSPRINT */
} Reg;


typedef struct srv              /* service event */
{
   ChStatus chStatus;           /* Change Status Element */
   ChanId chanId;               /* Channel Id Element */
} Srv;


typedef struct srvAck           /* Service Acknowledge message */
{
   ChStatus chStatus;           /* Change Status Element */
   ChanId chanId;               /* Channel Identification Element */
} SrvAck;


typedef struct mim              /* Management Information message */
{
#ifdef ATT
   Shift shift;                 /* Shift Element */
   ManInfo6 manInfo6;           /* Management Information Element */
#endif
   NullElmt nullElmt;           /* Null Element */
} Mim;


   
/***********************************************************************/
/*                 All PDU Structure*/
/***********************************************************************/


typedef struct allPdus          /* all pdu messages */
{
   union
   {
      Alerting alerting;        /* Alerting message */
      CallProc callProc;        /* Call Proceeding message */
      Conn conn;                /* Connect message */
      ConnAck connAck;          /* Connect Acknowledge message */
      Progress progress;        /* Progress message */
      Setup setup;              /* Setup message */
      SetupAck setupAck;        /* Setup Acknowledge message */
      Rsm rsm;                  /* Resume message */
      RsmAck rsmAck;            /* Resume Acknowledge message */
      RsmRej rsmRej;            /* Resume Reject message */
      Susp susp;                /* Suspend message */
      SuspAck suspAck;          /* Suspend Acknowledge message */
      SuspRej suspRej;          /* Suspend Reject message */
      UsrInfo usrInfo;          /* User Information message */
      Disc disc;                /* Disconnect message */
      Rel rel;                  /* Release message */
      RelCmplt relCmplt;        /* Release Complete message */
      Segment segment;          /* Segment message */
      CongCntrl congCntrl;      /* Congestion Control message */
      Info info;                /* Information message */
      Info info1;                /* Information message */
      Notify notify;            /* Notify message */
      Stat stat;                /* Status message */
      StatEnq statEnq;          /* Status Enquiry message */
      Facil facil;              /* Facility message */
      Srv srv;                  /* Service message */
      SrvAck srvAck;            /* Service Acknowledge message */
      Rst rst;                  /* Restart message */
      RstAck rstAck;            /* Restart Acknowledge message */
#ifdef ATT
      Mim mim;                  /* Management Information message */
#endif
#ifdef ISDN_HOLD
      Hold hold;                /* Hold message */
      HoldAck holdAck;          /* Hold Acknowledge message */
      HoldRej holdRej;          /* Hold Reject message */
      Ret ret;                  /* Retrieve message */
      RetAck retAck;            /* Retrieve Acknowledge message */
      RetRej retRej;            /* Retrieve Reject message */
#endif
#ifdef Q932
      Reg reg;                  /* Register message */
#endif
   } m;
} AllPdus;



/***********************************************************************/
/*                 Event Structures*/
/***********************************************************************/

typedef struct conEvnt          /* connect event */
{
#if(ISDN_303TMC || ISDN_303CSC)
   BCCallRef callRef;           /* Call Reference */
#endif
   SndCmplt sndCmplt;           /* Sending Complete Element */
   RepInd repInd;               /* Repeat Indicator Element */
   BearCap bearCap[IN_MF_MAX_REPELMT];/* Bearer Capability Element */
#ifdef ATT
   CallId callId;               /* Call Identification Element */
#endif
   ChanId chanId;               /* Channel Identification Element */
   Facility facility;           /* Facility Element */
   Facility facility1;           /* Facility Element */
   FacilityStr facilityStr;     /* Facility String Element */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   NtFacility ntFacility;       /* Facility Element */
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI*/
#ifdef NTMCI
   NtFacility ntFacility1;      /* Facility Element */
#endif /* NTMCI */
#ifdef NTNI
   NtNiFacility ntniFacility;   /* Facility Element */
#endif /* NTNI */
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
#endif
#ifdef INTR6
   TrNetFac trNetFac;           /* INTR6 Network Specific Facilities Element */
#endif
#ifdef ETSI
   EtsiNetFac etsiNetFac;       /* etsi Network Specific Facilities Element */
#endif
   NetFac netFac[IN_MF_MAX_IE];    /* Network Specific Facilities Element */
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
#ifdef ATT
   TermCapab termCapab;         /* Terminal Capability */
#endif
#ifdef QSIG
   NotInd notInd;               /* Notification Indication Element */
#endif
   Display display;             /* Display Element */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   NtDisplay ntDisplay[IN_MAX_DISPLAY];         /* Display Element */
#endif
   KeyFac keyFac;               /* Keypad Facilities Element */
   Signal signal;               /* Signal Element */
#ifdef BC303CSC
   Signal signal1;              /* Signal Element */
#endif
   Swtchk swtchk;               /* Switchook Element */
   FeaAct feaAct;               /* Feature Activation Element */
   FeaInd feaInd;               /* Feature Indication Element */
   Endpoint endPoint;           /* Endpoint Identifier element */
   InfoRate infoRate;           /* information rate tokens */
   EtoeDly etoeDly;             /* end to end transit delay tokens */
   TranDlySel tranDlySel;       /* transit delay selection and indication 
                                   tokens */
   PktBin pktBin;               /* packet layer binary tokens */
   PktWin pktWin;               /* packet layer window size tokens */
   PktSze pktSze;               /* packet layer packet size tokens */
#ifdef NI2
   Cug cug;                     /* closed user group */
   RvsChrg rvsChrg;             /* reverse charge indicator */
#endif
#if (ISDN_ETSI || ISDN_QSIG)
   CgPtySad cgPtySad1;          /* Calling Party Subaddress Element */
#endif
   CgPtyNmb cgPtyNmb;           /* Calling Party Number Element */
#ifdef INTR6
   CgPtyNmb cgPtyNmb1;          /* Calling Party Number Element */
#endif
#if 1 /* Boris added second calling party number */
   CgPtyNmb cgPtyNmb2;          /* Calling Party Number Element */
#endif
#ifdef IN_NW_NMB
#ifdef NI2
                                /* the nwNmb IE is used only for passing the
                                   station ID to upper layer. It is not in 
                                   any message. refer to TR-NWT-000444 */
   CgPtyNmb nwNmb;              /* Network Number Element */
#endif /* NI2 */
#endif /* IN_NW_NMB */
   CgPtySad cgPtySad;           /* Calling Party Subaddress Element */
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
   CdPtySad cdPtySad;           /* Called Party Subaddress Element */
   NtOrgCdNmb ntOrgCdNmb;       /* NT Called Party Number element */
   RedirNmb redirNmb;           /* Redirecting Number element */
#if (ISDN_NI2 || ISDN_NTNI)
   RedirNmb redirNmb1;           /* redirecting Number Element */
#endif /* (ISDN_NI2 || ISDN_NTNI) */
   TrnstNtw trnstNtw;           /* Transit Network Element */
#ifdef VN2
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
   LlCompF llComp1;              /* Low Layer Compatibility Element */
#endif
   LlComp llComp;               /* Low Layer Compatibility Element */
   HlComp hlComp;               /* High Layer Compatibility Element */
   UsrUsr usrUsr;               /* User to User Element */
#ifdef INTR6
   Shift shift6;                /* Shift Element */
   TrServIndic6 trServIndic6;   /* Service Indicator */
   Shift shift61;               /* Shift Element */
   TrAdTrmAttrb6 trAdTrmAttrb6; /* Additional Call Attributes */
#endif
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTNI)
   Shift shift2;                /* Shift Element */
#ifdef DECODCDSET
   NtOperSysAcc5 ntOperSysAcc5; /* NT Operator System Access element */
#if  ISDN_NTSPRINT
   BusGrp busGrp;               /* Business Group Element */
#endif /* ISDN_NTSRPINT */
#else
   ElmtStr ntOctStr;             /* octet string */
#endif /* DECODCDSET */
#endif /* ISDN_NT || ISDN_NTNI || ISDN_NTDMS250 */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   Shift shift3;                /* Shift Element */
#if ISDN_NTMCI
   ElmtStr ntMCIOctStr;         /* octet string */
#endif /* ISDN_NTMCI */
#ifdef DECODCDSET
#ifdef ISDN_NT
   ElmtStr ntCallApear6;        /* NT Call Apearance element */
#endif
#ifdef ISDN_NTSPRINT
   GenericDig genericDig;       /* Generic Digit */
#endif
#else
   ElmtStr ntOctStr1;             /* octet string */
#endif   /* DECODCDSET */
   Shift shift13;               /* Shift Element */
   ElmtStr ntOctStr2;            /* NT Octet String */
#endif /* ISDN_NT || ISDN_NTNI || ISDN_NTDMS250 */
#if (ISDN_NI1 || ISDN_NI2)
   Shift shift8;                /* Shift Element */
   NIOperSysAcc niOperSysAcc;   /* Operator System Access Element */
#endif
#ifdef NI1
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift7;                /* Shift Element */
   RedirSad redirSad;           /* Redirecting Subaddress */
   ElmtStr niCallApear;         /* NI1 Call Apearance element */
#endif
#ifdef QSIG
   Shift shift10;               /* Shift Element */
   QTranCntr qTranCntr;         /* Transit Counter  Element */
   QPtyCat qPtyCat;             /* Party Category  Element */
#endif
   /* Sangoma add new code set 6 IEs */
#ifdef NI2
  Shift shift11;                /* Shift Element */
  ElmtStr ni2OctStr;            /* Octet String */
#endif   
#ifdef ATT
   Shift shift4;                /* Shift Element */
   /* Not present in qn_db2.c */
/*   AttOrigLineInfo attOrigLineInfo;*/ /* ATT Originating Line Info */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attUsrCode6;         /* ATT User Code */
   ElmtStr attLlcId6;           /* ATT Logical Link Id */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attSelCllApp6;       /* ATT Selected Call Appearence */
   ElmtStr attOrgCllApp6;       /* ATT Origination Call Appearence */
   ElmtStr attDstCllApp6;       /* ATT Destination Call Appearence */
   ElmtStr attEndpoint6;        /* ATT Endpoint Identifier */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attFeaAct6;          /* ATT Feature Activation */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attPktLyrParms6;     /* ATT Packet Layer Parameters */
   ElmtStr attLnkLyrParms6;     /* ATT Link Layer Parameters */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attThrptCls6;        /* ATT Throughput Class */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift5;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif /* ATT */
} ConEvnt;



typedef struct discEvnt         /* disconnect event */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   Facility facility;           /* Facility Element */
#if 1 /* Boris Facility IE for ETSI */
   FacilityStr facilityStr;     /* Facility String Element */
#endif
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif
#ifdef NTMCI
   NtFacility ntFacility[IN_MF_MAX_REPELMT];       /* Nt Facility ELement */
#endif /* NTMCI */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
#endif
#ifdef INTR6
   TrNetFac trNetFac;           /* INTR6 Network Specific Facilities Element */
#endif
#ifdef QSIG
   NotInd notInd;               /* Notification Indication Element */
#endif
   Display display;             /* Display Element */
#if (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#endif /* (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT) */
#ifdef NTMCI
   NtDisplay ntDisplay1;        /* Display Element */
   CgPtySad cnPtySad;           /* Connected Party Subaddress Element */
#endif
#ifdef NI1
   InfoReq infoReq;             /* Information Request element */
#endif
   Signal signal;               /* Signal Element */
#ifdef ATT   
   Swtchk swtchk;               /* Switchook Element */
#endif  
   FeaInd feaInd;               /* Feature Indication Element */
#ifdef VN2
   Shift shift1;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
#ifdef NI1
   NI1RedirNmb redirNmb;        /* Redirecting Number element */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NTMCI
   Shift shift7;                /* Shift Element */
   ElmtStr ntOctStr;            /* NT Octet String */
#endif
#ifdef NI1
   Shift shift5;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift6;                /* Shift Element */
   NI1RedirNmb redirNmb1;       /* redirecting Number Element */
#endif
#ifdef INTR6
   Shift shift4;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
   TrDate6 trDate6;             /* Date */
#endif
#ifdef ATT
   Shift shift;                 /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift2;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
#ifdef NTT
   Shift shift3;                /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
#endif
} DiscEvnt;


typedef struct infoEvnt         /* information event */
{
#ifdef VN2
   Shift shift;                 /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
   MoreData moreData;           /* More Data Element */
   UsrUsrE usrUsr;              /* User to User Element */
#ifdef INTR6
   TrUsrUsr trUsrUsr;           /* User to User Element */
#endif
#ifdef ATT
   Shift shift1;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift2;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
} InfoEvnt;



typedef struct rmRtEvnt         /* resume/retrieve event */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   CallId callId;               /* Call Identification Element */
#ifdef VN2
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
   ChanId chanId;               /* Channel Identification  Element */
#if (ISDN_NT || ISDN_NI1)
   NotInd notInd;               /* Notification Indication Element */
#endif /* (ISDN_NT || ISDN_NI1) */
#ifdef NT
   NotInd notInd5;               /* Notification Indication Element */
#endif /* NT */
   Display display;             /* Display Element */
#ifdef NI1
   Signal signal;               /* Signal Element */
   FeaInd feaInd;               /* Feature Indication Element */
   Shift shift3;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
#ifdef NTT
   Shift shift1;                /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
#endif
#ifdef INTR6
   Shift shift2;                /* Shift Element */
   TrServIndic6 trServIndic6;   /* Service Indicator */
#endif
} RmRtEvnt;



typedef struct staEvnt          /* status event */
{
  CongLvl congLvl;              /* Congestion Level Element */
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   CallSte callSte;             /* Call State Element */
   Display display;             /* Display Element */
#ifdef NI1
   Shift shift;                 /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif
} StaEvnt;

typedef struct cnStEvnt         /* connect status event */
{
   SndCmplt sndCmplt;           /* Sending Complete Element */
   BearCap bearCap[IN_MF_MAX_REPELMT];/* Bearer Capability Element */
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#ifdef INTR6
   CnPtyNmb cnPtyNmb1;          /* Connected Number Element */
#endif
   ChanId chanId;               /* Channel Identification Element */
   Facility facility;           /* Facility Element */
#if 1 /* Boris Facility IE for ETSI */
   FacilityStr facilityStr;
#endif
#ifdef NTNI
   NtNiFacility ntniFacility;   /* Facility Element */
#endif /* NTNI */
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   NtFacility ntFacility;       /* Facility Element */
#endif
#if (ISDN_NTMCI || ISDN_NTDMS250)
   NtFacility ntFacility1;      /* Facility Element */
#endif /* (ISDN_NTMCI || ISDN_NTDMS250) */
   ProgInd progInd;             /* Progress Indication Element */
   ProgInd progInd1;            /* Progress Indication Element */
   ProgInd progInd2;            /* Progress Indication Element */
   ProgInd progInd3;            /* Progress Indication Element */
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
#ifdef INTR6
   TrNetFac trNetFac;           /* INTR6 Network Specific Facilities Element */
#endif
#ifdef ATT
   TermCapab termCapab;         /* Terminal Capability */
#endif
   NotInd notInd;               /* Notification Indication Element */
#ifdef QSIG
   NotInd notInd1;              /* Notification Indication Element */
   NotInd notInd2;              /* Notification Indication Element */
   NotInd notInd3;              /* Notification Indication Element */
   NotInd notInd4;              /* Notification Indication Element */
#endif
   Display display;             /* Display Element */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI) 
   NtDisplay ntDisplay[IN_MAX_DISPLAY];      /* Display Element */
#endif /* (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)  */
#ifdef ETSI
   DatTim  datTim;              /* Date/Time Element */
#endif
   KeyFac keyFac;               /* Keypad Facilities Element */
   InfoReq infoReq;             /* Information Request element */
   Signal signal;               /* Signal Element */
   Swtchk swtchk;               /* Switchook Element */
   FeaAct feaAct;               /* Feature Activation Element */
   FeaInd feaInd;               /* Feature Indication Element */
   Endpoint endPoint;           /* Endpoint Identifier element */
   ServProf servProf;           /* Service Profile Identification element */
#if (ISDN_ETSI || ISDN_QSIG || ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb cnPtyNmb2;          /* Connected Number Element */
#endif /* (ETSI || QSIG || NTMCI || NT || NTDMS250 || ATT) */
#if (ISDN_ETSI || ISDN_QSIG || ISDN_NTMCI)
   CgPtySad cgPtySad1;          /* Connected Party Subaddress Element */
#endif
   CgPtyNmb cgPtyNmb;           /* Calling Party Number Element */
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
#ifdef VN2
   Shift shift4;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
   RedirNmb redirNmb;           /* Re-directing Number element */
   RedirNmb redirNmb2;          /* Re-direction Number element */
   LlComp llComp;               /* Low Layer Compatibility Element */
   UsrUsr usrUsr;               /* User to User Element */
#if (ISDN_NT || ISDN_NTMCI)
   Shift shift1;                /* Shift Element */
#if ISDN_NTMCI
   ElmtStr ntMCIOctStr;         /* octet string */
#endif /* ISDN_NTMCI */
#if (ISDN_DECODCDSET & ISDN_NT)
   ElmtStr ntPrVerCtrl6;        /* NT protocol version control element */
#else
   ElmtStr nOctStr;             /* octet string */
#endif
#endif /* ISDN_NT || ISDN_NTMCI */
#ifdef NI1
   CgPtySad cgPtySad;           /* Calling Party Subaddress Element */
   CdPtySad cdPtySad;           /* Called Party Subaddress Element */
   NI1RedirNmb redrNmb;         /* Re-directing Number element */
   Shift shift6;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift7;                /* Shift Element */
   NI1RedirNmb redrNmb1;        /* Re-directing Number element */
   ElmtStr niCallApear;         /* NI1 Call Apearance element */
#endif
#ifdef QSIG
   Shift shift8;                /* Shift Element */
   QPtyCat qPtyCat;             /* Party Category  Element */
#endif
#ifdef INTR6
   Shift shift5;                /* Shift Element */
   TrCdPtyStat6 trCdPtyStat6;   /* INTR6 Called Party Status */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
   TrDate6 trDate6;             /* Date */
#endif
#ifdef ATT
   Shift shift2;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attLlcId6;           /* ATT Logical Link Id */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attSelCllApp6;       /* ATT Selected Call Appearence */
   ElmtStr attKeyPadCtl6;       /* ATT Keypad Control */
   ElmtStr attOthrCllRef6;      /* ATT Other Call Reference */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attFeaAct6;          /* ATT Feature Activation */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplCtrl6;        /* ATT Display Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */

   ElmtStr attPktLyrParms6;     /* ATT Packet Layer Parameters */
   ElmtStr attLnkLyrParms6;     /* ATT Link Layer Parameters */
   ElmtStr attFeature6;         /* ATT Feature */

   ElmtStr attThrptCls6;        /* ATT Throughput Class */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift3;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif /* ATT */
#ifdef NTT
   Shift        nttShft6;         /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
   /* Blocking Channel Identifier */
   NttBlkChanId    nttBlkChanId;
#endif /* NTT */
} CnStEvnt;



typedef struct facEvnt          /* facility event */
{
   FacElmt facElmt;             /* facility message Element */
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif /* QSIG */
#if (ISDN_NTNI)
   NtNiFacility ntniFacility;       /* Facility Element */
#endif /* ISDN_NTNI */
#if (ISDN_NTDMS250 || ISDN_NTMCI)
   NtFacility ntFacility1;       /* Facility Element for NTSPRINT */
#endif /* ISDN_NTDMS250  || ISDN_NTMCI*/
#ifdef NTMCI
   NtFacility ntFacility2;      /* Facility Element for NTSPRINT */
#endif /* NTMCI */
#ifdef QSIG
   NotInd notInd;               /* Notification indicator.  */
   CgPtyNmb cgPtyNmb;           /* Calling party number.    */
   CdPtyNmb cdPtyNmb;           /* Called party number.     */
   QSigInfoTran qSigInfoTran;   /* QSig Information Transfer type */
                                /* Used for layer 3 tolayer 4 communication */
#endif /* QSIG */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
   Shift shift;                 /* Shift 6 Element */
   NtOrig ntOrig;               /* Origination Element */
   NtDest ntDest;               /* Destination Element */
#endif /* (ISDN_NT || ISDN_NTSPRINT || ISDN_NTMCI) */
#ifdef NT
   NtRsnRet ntRsnRet;           /* Reason for Return Element */
   NtOpt ntOptions;             /* Options Element */
#endif /* NT */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
  TscFacility tscFacility;      /* TSC Facility Element*/
#endif /* (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI) */
} FacEvnt;



typedef struct relEvnt          /* release event */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
#ifdef INTR6
   CnPtyNmb cnPtyNmb;           /* Connected Number Element */
#endif
#ifdef NI1
   ChanId chanId;               /* Channel Identification Element */
#endif
   Facility facility;           /* Facility Element */
#if 1 /* Boris Facility IE for ETSI */
   FacilityStr facilityStr;     /* Facility String Element */
#endif
#ifdef NTNI
   NtNiFacility ntniFacility;   /* Facility Element */
#endif /* NTNI */
#ifdef QSIG
   QFacility qFacility[IN_MF_MAX_FACIE];         /* Facility Element */
#endif
#ifdef VN2
   VnNetFac vnNetFac;           /* VN2 Network Specific Facilities Element */
   Shift shift;                 /* Shift Element */
   TermCapab vnTermCapab6;      /* Terminal Capability */
#endif
   Display display;             /* Display Element */
#ifdef NTMCI
   NtDisplay ntDisplay;         /* Display Element */
#endif
#ifdef NI1
   InfoReq infoReq;             /* Information Request element */
#endif
   Signal signal;               /* Signal Element */
   FeaInd feaInd;               /* Feature Indication Element */
#if (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT)
   CnPtyNmb cnPtyNmb2;          /* Connected Number Element */
#endif /* (ISDN_NTMCI || ISDN_NT || ISDN_NTDMS250 || ISDN_ATT) */
#ifdef NTMCI
   CgPtySad cnPtySad;           /* Connected Party Subaddress Element */
#endif
#ifdef VN2
   CdPtyNmb cdPtyNmb;           /* Called Party Number Element */
   CdPtySad cdPtySad;           /* Called Party Subaddress Element */
   Shift shift7;                /* Shift Element */
   VnUsrFac vnUsrFac;           /* user facility */
#endif
#ifdef NI1
   NI1RedirNmb redirNmb;        /* Redirection Number element */
#endif
   UsrUsr usrUsr;               /* User to User Element */
#ifdef NI1
   Shift shift5;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
   Shift shift6;                /* Shift Element */
   NI1RedirNmb redirNmb1;       /* Redirection Number element */
#endif
#ifdef NTMCI
   Shift shift8;                /* Shift Element */
   ElmtStr ntOctStr;            /* NT Octet String */
#endif
#ifdef INTR6
   Shift shift4;                /* Shift Element */
   TrChgeInfo6 trChgeInfo6;     /* Charging Information */
   TrDate6 trDate6;             /* Date */
#endif
#ifdef NTT
   Shift shift3;                /* Shift Element */
   NttAdvChrge6 nttAdvChrge6;   /* NTT Advice of Charge */   
#endif
#ifdef ATT
   Shift shift1;                /* Shift Element */
#ifdef DECODCDSET
   ElmtStr attUsrEntCode6;      /* ATT User Entered Code */
   ElmtStr attTrvClsMrk6;       /* ATT Traveling Class Mark */
   ElmtStr attTrkGrpId6;        /* ATT Trunk Group/Trunk Id */
   ElmtStr attTrkGrpStat6;      /* ATT Trunk Group/Trunk Status */
   ElmtStr attSubNetTrk6;       /* ATT Subnetwork Trunking */
   ElmtStr attStndFac6;         /* ATT Standardized Facility Element */
   ElmtStr attSelCllApp6;       /* ATT Selected Call Appearence */
   ElmtStr attDisplay6;         /* ATT Display Element */
   ElmtStr attConnDesc6;        /* ATT Connection Description */
   ElmtStr attSubChnId6;        /* ATT Subchannel Id */
   ElmtStr attKeyPadCtl6;       /* ATT Keypad Control */
   ElmtStr attFeaInd6;          /* ATT Feature Indication */
   ElmtStr attAdjCtrl;          /* ATT Adjunct Control */
   ElmtStr attDsplFld6;         /* ATT Display Field */
   ElmtStr attFeature6;         /* ATT Feature */
   ElmtStr attLkAhdIntFlw6;     /* ATT Lookahead Interflow */
   Shift shift2;                /* Shift Element */
   ElmtStr attTrvClsMrk7;       /* ATT User Specific Traveling Class Mark */
   ElmtStr attDisplay7;         /* ATT User Specific Display */
   ElmtStr attLkAhdIntFlw7;     /* ATT User Specific Lookahead Interflow */
#else
   ElmtStr octStr;              /* octet string */
#endif
#endif
#ifdef ISDN_NTSPRINT 
   Shift shift9;                /* Shift Element */
   TscFacility tscFacility;     /* Temporary signalling facility Element */
#endif /* ISDN_NTSPRINT */
} RelEvnt;



typedef struct ssHlEvnt         /* suspend/hold event */
{
#ifdef INTR6
   TrCause trCause;             /* Cause and Diagnostic Element */
#endif
   CauseDgn causeDgn[IN_MF_MAX_IE];/* Cause and Diagnostic Element */
   CallId callId;               /* Call Identification Element */
#if (ISDN_NI1 || ISDN_NT)
   NotInd notInd;               /* Notification Indication Element */
#endif /* (ISDN_NI1 || ISDN_NT) */
   Display display;             /* Display Element */
#if (ISDN_NI1 || ISDN_NT)
   Signal signal;               /* Signal Element */
#endif /* (ISDN_NI1 || ISDN_NT) */
#ifdef NI1
   FeaInd feaInd;               /* Feature Indication Element */
   Shift shift1;                /* Shift Element */
   DisplayTxt displayTxt;       /* Display Text Element */
#endif /* NI1 */
} SsHlEvnt;

/***********************************************************************/
/*                   All Sdus Structure*/
/***********************************************************************/

typedef struct allSdus          /* all sdu messages */
{
   union
   {
      ConEvnt    conEvnt;         /* connect event */
      DiscEvnt   discEvnt;        /* disconnect event */
      InfoEvnt   infoEvnt;        /* information event */
      RmRtEvnt   rmRtEvnt;        /* resume/retrieve event */
      StaEvnt    staEvnt;         /* status event */
      CnStEvnt   cnStEvnt;        /* connect status event */
      FacEvnt    facEvnt;         /* facility event */
      RelEvnt    relEvnt;         /* release event */
      SsHlEvnt   ssHlEvnt;        /* suspend/halt event */
      Srv        srvEvnt;         /* service event */
   } m;
} AllSdus;



/***********************************************************************/
/*             Typedefs for Primitives*/
/***********************************************************************/


/* Depending on the specific selector in the bndCfg structure,
a primitive originated from a service provider can be dispatched to
any service user. The assumption is that, even if every primitive has
a different name depending in which file it resides, every primitive
must have the same function prototype, i.e. the same identical set
of arguments. These arguments are defined here */


#ifdef INVER2
typedef S16 (*IntBndReq) ARGS((Pst *pst, SuId suId, SpId spId)); 
#else
typedef S16 (*IntBndReq) ARGS((Pst *pst, SuId suId, Pst *cfg)); 
#endif /*INVER2*/

#ifdef INT2
typedef S16 (*IntBndCfm) ARGS((Pst *pst, SuId suId, U8 status)); 
#endif /* INT2 */

typedef S16 (*IntUbndReq) ARGS((SuPst *pst, SpId spId, Reason reason)); 

#ifdef IN
EXTERN  S16 InUiIntBndReq ARGS((Pst *pst, SuId suId, SpId spId));
EXTERN  S16 InUiIntUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
#ifdef INT2
EXTERN  S16 InUiIntBndCfm ARGS((Pst *pst, SuId suId, U8 status)); 
#endif /* INT2 */
#endif /* IN */

#ifdef IX
EXTERN  S16 IxLiIntBndReq ARGS((Pst *pst,SuId suId, SpId spId));
EXTERN  S16 IxLiIntUbndReq ARGS((Pst *pst,SuId suId, Reason reason));
#ifdef INT2
EXTERN  S16 IxLiIntBndCfm ARGS((Pst *pst, SuId suId, U8 status)); 
#endif /* INT2 */
#endif /* IX */

#ifdef AN
#ifdef ANVER2
EXTERN  S16 AnLiIntBndReq ARGS((Pst *pst, SuId suId, SpId spId));
#else
EXTERN  S16 AnLiIntBndReq ARGS((Pst *pst, SuId suId, Pst *cfg));
#endif /*ANVER2*/
#ifdef INT2
EXTERN  S16 AnLiIntBndCfm ARGS((Pst *pst, SuId suId, U8 status)); 
#endif /* INT2 */
EXTERN  S16 AnLiIntUbndReq ARGS((SuPst *pst, SpId spId, Reason reason));
#endif /* AN */

#ifdef QW
EXTERN  S16 QwLiIntBndReq ARGS((Pst *pst, SuId suId, SpId spId));
EXTERN  S16 QwLiIntUbndReq ARGS((Pst *pst, SpId spId, Reason reason));
#ifdef INT2
EXTERN  S16 QwLiIntBndCfm ARGS((Pst *pst, SuId suId, U8 status)); 
#endif /* INT2 */
#endif /* QW */

#ifdef LCINT
EXTERN S16 cmPkIntBndReq ARGS((Pst *pst,SuId suId,SpId spId));
EXTERN S16 cmPkIntUbndReq ARGS((Pst *pst,SpId spId,Reason reason));

#ifdef INT2
EXTERN  S16 cmPkIntBndCfm ARGS((Pst *pst, SuId suId, U8 status)); 
#endif /* INT2 */
#endif /* LCINT */

#ifdef ISDN_3_8_PLUS

typedef S16 (*IntConInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, ConEvnt *conEvnt, SuId dChan, Ces ces)); 
typedef S16 (*IntConCfm) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces)); 
typedef S16 (*IntCnStInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, 
        Ces ces)); 
typedef S16 (*IntDiscInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt)); 
typedef S16 (*IntRelInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt)); 
typedef S16 (*IntDatInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt)); 
typedef S16 (*IntSsHlInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntSsHlCfm) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntRmRtInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action)); 
typedef S16 (*IntRmRtCfm) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action)); 
typedef S16 (*IntFlcInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
typedef S16 (*IntFacInd) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces)); 
typedef S16 (*IntStaCfm) ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt)); 
typedef S16 (*IntSrvInd) ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces)); 
typedef S16 (*IntSrvCfm) ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces)); 
typedef S16 (*IntRstCfm) ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 
typedef S16 (*IntRstInd) ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType));

typedef S16 (*IntConReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        ConEvnt *conEvnt, SuId dChan, Ces ces)); 
typedef S16 (*IntConRsp) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes, Ces ces)); 
typedef S16 (*IntCnStReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces
                ces)); 
#ifdef NETSIDE
#ifdef ISDN_PTMPT
typedef S16 (*IntSetupComp) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces)); 
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */


typedef S16 (*IntDiscReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt)); 
typedef S16 (*IntRelReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt)); 
typedef S16 (*IntDatReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt)); 
typedef S16 (*IntSsHlReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntSsHlRsp) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntRmRtReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan, Ces
                ces)); 
typedef S16 (*IntRmRtRsp) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));

typedef S16 (*IntFlcReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt)); 

typedef S16 (*IntFacReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces)); 

typedef S16 (*IntStaReq) ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt, U8 evntType)); 

typedef S16 (*IntSrvReq) ARGS((SuPst *pst, SpId spId, Srv *srvEvnt, 
        SuId dChan, Ces ces)); 
typedef S16 (*IntRstReq) ARGS((SuPst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 reqType)); 
#ifdef QW
#ifdef IN_RSCIND
typedef S16 (*IntRscStaInd) ARGS((Pst *pst, SuId suId, U16 event, U16 cause,
                                  SuId linkId, U8 chanNum));
#endif /* IN_RSCIND */
#endif /* QW */


#ifdef IN
/* q.930/q.931, upper interface, isdn network discriminator */

EXTERN  S16 InUiIntConReq ARGS((Pst *pst, SpId spId, UConnId suInstId, 
        ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 InUiIntConRsp ARGS((Pst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes, Ces ces));
EXTERN  S16 InUiIntCnStReq ARGS((Pst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces
                ces));
#ifdef NETSIDE
#ifdef ISDN_PTMPT 
EXTERN  S16 InUiIntSetupComp ARGS((Pst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces));
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */

EXTERN  S16 InUiIntDiscReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 InUiIntRelReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt));
EXTERN  S16 InUiIntDatReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 InUiIntSsHlReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 InUiIntSsHlRsp ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 InUiIntRmRtReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan, Ces
                ces));
EXTERN  S16 InUiIntRmRtRsp ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 InUiIntFlcReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 InUiIntFacReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));
EXTERN  S16 InUiIntStaReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt, U8 evntType));
EXTERN  S16 InUiIntSrvReq ARGS((Pst *pst,SpId spId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 InUiIntRstReq ARGS((Pst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 reqType)); 

#endif /* IN */

#ifdef IX
/* x.31, lower interface, isdn network discriminator */

EXTERN  S16 IxLiIntConReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 IxLiIntConRsp ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes, Ces ces));
EXTERN  S16 IxLiIntCnStReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces
                ces));
EXTERN  S16 IxLiIntDiscReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 IxLiIntRelReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt));
EXTERN  S16 IxLiIntDatReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 IxLiIntSsHlReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntSsHlRsp ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntRmRtReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan));
EXTERN  S16 IxLiIntRmRtRsp ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 IxLiIntFlcReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 IxLiIntFacReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));

EXTERN  S16 IxLiIntStaReq ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt, U8 evntType));

EXTERN  S16 IxLiIntSrvReq ARGS((Pst *pst,SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 IxLiIntRstReq ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 reqType)); 

EXTERN  S16 IxLiIntConInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 IxLiIntConCfm ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces));
EXTERN  S16 IxLiIntCnStInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces
                ces));
EXTERN  S16 IxLiIntDiscInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 IxLiIntRelInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt));
EXTERN  S16 IxLiIntDatInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 IxLiIntSsHlInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntSsHlCfm ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntRmRtInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 IxLiIntRmRtCfm ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 IxLiIntFlcInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 IxLiIntFacInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));
EXTERN  S16 IxLiIntStaCfm ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 IxLiIntSrvInd ARGS((Pst *pst,SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 IxLiIntSrvCfm ARGS((Pst *pst,SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 IxLiIntRstCfm ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 
EXTERN  S16 IxLiIntRstInd ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 
EXTERN  S16 IxLiIntStaInd ARGS ((Pst *pst, SuId suId, UConnId suInstId, 
                                 UConnId spInstId,StaEvnt *staEvnt));

#endif /* IX */

#ifdef AN

/* application program, lower interface, isdn network discriminator */

EXTERN  S16 AnLiIntConInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 AnLiIntConCfm ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces));
EXTERN  S16 AnLiIntCnStInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces
                ces));
EXTERN  S16 AnLiIntDiscInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 AnLiIntRelInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt));
EXTERN  S16 AnLiIntDatInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 AnLiIntSsHlInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntSsHlCfm ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntRmRtInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 AnLiIntRmRtCfm ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 AnLiIntFlcInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 AnLiIntFacInd ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));

EXTERN  S16 AnLiIntStaCfm ARGS((SuPst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 AnLiIntSrvInd ARGS((SuPst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 AnLiIntSrvCfm ARGS((SuPst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 AnLiIntRstCfm ARGS((SuPst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 
EXTERN  S16 AnLiIntRstInd ARGS((SuPst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 

EXTERN  S16 AnLiIntConReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 AnLiIntConRsp ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes, Ces ces));
EXTERN  S16 AnLiIntCnStReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces
                ces));
#ifdef NETSIDE
#ifdef ISDN_PTMPT
EXTERN  S16 AnLiIntSetupComp ARGS((SuPst *pst, SpId spId, 
                                      UConnId suInstId, UConnId spInstId, 
                                      CnStEvnt *cnStEvnt,SuId dChan, Ces ces));
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */

EXTERN  S16 AnLiIntDiscReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 AnLiIntRelReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt));
EXTERN  S16 AnLiIntDatReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 AnLiIntSsHlReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntSsHlRsp ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntRmRtReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan, Ces
        ces));
EXTERN  S16 AnLiIntRmRtRsp ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 AnLiIntFlcReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 AnLiIntFacReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));

EXTERN  S16 AnLiIntStaReq ARGS((SuPst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt, U8 evntType));

EXTERN  S16 AnLiIntSrvReq ARGS((SuPst *pst, SpId spId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 AnLiIntRstReq ARGS((SuPst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 reqType)); 
#endif /* AN */

#ifdef BCUIINT

/* tightly coupled, backward compatibility */

EXTERN  S16 NConInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 NConCfm ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        CnStEvnt *cnStEvnt, SuId dChan, Ces ces));
EXTERN  S16 NCnStInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces ces));
EXTERN  S16 NDiscInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        DiscEvnt *discEvnt));
EXTERN  S16 NRelInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        RelEvnt *relEvnt));
EXTERN  S16 NDatInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        InfoEvnt *infoEvnt));
EXTERN  S16 NSsHlInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 NSsHlCfm ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        SsHlEvnt *ssHlEvnt));
EXTERN  S16 NRmRtInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 NRmRtCfm ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        RmRtEvnt *rmRtEvnt));
EXTERN  S16 NFlcInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        StaEvnt *staEvnt));
EXTERN  S16 NFacInd ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        FacEvnt *facEvnt, U8 evntType));
EXTERN  S16 NStaCfm ARGS((SuId suId, UConnId suInstId, UConnId spInstId, 
        StaEvnt *staEvnt));
EXTERN  S16 NSrvInd ARGS((SuId suId, Srv *srvEvnt, SuId dChan, Ces ces));
EXTERN  S16 NSrvCfm ARGS((SuId suId, Srv *srvEvnt, SuId dChan, Ces ces));

#endif /* BCUIINT */



#ifdef QW

/* q.930/q.931 PSIF upper interface, isdn network discriminator */

EXTERN  S16 QwLiIntConInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 QwLiIntConCfm ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces));
EXTERN  S16 QwLiIntCnStInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, 
        Ces ces));
EXTERN  S16 QwLiIntDiscInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 QwLiIntRelInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt));
EXTERN  S16 QwLiIntDatInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 QwLiIntSsHlInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntSsHlCfm ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntRmRtInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 QwLiIntRmRtCfm ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 QwLiIntFlcInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 QwLiIntFacInd ARGS((Pst *pst,SuId suId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan,
        Ces ces));
EXTERN  S16 QwLiIntStaCfm ARGS((Pst *pst, SuId suId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 QwLiIntSrvInd ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 QwLiIntSrvCfm ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 QwLiIntRstCfm ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 
EXTERN  S16 QwLiIntRstInd ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType));


EXTERN  S16 QwLiIntConReq ARGS((Pst *pst, SpId spId, UConnId suInstId, 
        ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 QwLiIntConRsp ARGS((Pst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes, Ces ces));
EXTERN  S16 QwLiIntCnStReq ARGS((Pst *pst, SpId spId, UConnId suInstId, 
        UConnId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, 
        Ces ces));
EXTERN  S16 QwLiIntDiscReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 QwLiIntRelReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, RelEvnt *relEvnt));
EXTERN  S16 QwLiIntDatReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 QwLiIntSsHlReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntSsHlRsp ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntRmRtReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan));
EXTERN  S16 QwLiIntRmRtRsp ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 QwLiIntFlcReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt));
EXTERN  S16 QwLiIntFacReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));
EXTERN  S16 QwLiIntStaReq ARGS((Pst *pst,SpId spId, UConnId suInstId, 
        UConnId spInstId, StaEvnt *staEvnt, U8 evntType));
EXTERN  S16 QwLiIntSrvReq ARGS((Pst *pst,SpId spId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 QwLiIntRstReq ARGS((Pst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 reqType)); 
#ifdef IN_RSCIND 
EXTERN  S16 QwLiIntRscStaInd ARGS((Pst *pst, SuId suId, U16 event, U16 cause,
                                   SuId linkId, U8 chanNum));
#endif /* IN_RSCIND */
#endif /* QW */


/* Packing functions */

/* Request Packing Functions */

#ifdef LCINT

EXTERN S16 cmPkIntConReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                               ConEvnt *conEvnt,SuId dChan, Ces ces));
EXTERN S16 cmPkIntConRsp ARGS((Pst *pst,SpId spId,UConnId suInstId,
                               UConnId spInstId,CnStEvnt *cnStEvnt,
                               SuId dChanCes, Ces ces));
EXTERN S16 cmPkIntCnStReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                                UConnId spInstId,CnStEvnt *cnStEvnt,
                                U8 evntType,SuId dChan, Ces ces));
#ifdef NETSIDE
#ifdef ISDN_PTMPT
EXTERN S16 cmPkIntSetupComp ARGS((Pst *pst,SpId spId,UConnId suInstId,
                                  UConnId spInstId,CnStEvnt *cnStEvnt,
                                  SuId dChan,Ces ces));
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */

EXTERN S16 cmPkIntDiscReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                                UConnId spInstId,DiscEvnt *discEvnt));
EXTERN S16 cmPkIntRelReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                               UConnId spInstId,RelEvnt *relEvnt));

#ifdef ISDN_UTU
EXTERN S16 cmPkIntDatReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                               UConnId spInstId,InfoEvnt *infoEvnt));
EXTERN S16 cmPkIntFlcReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                               UConnId spInstId, StaEvnt *staEvnt));

EXTERN S16  cmPkIntDatInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                UConnId spInstId,InfoEvnt *infoEvnt));
EXTERN S16  cmPkIntFlcInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                UConnId spInstId,StaEvnt *staEvnt));
#endif /* ISDN_UTU */

#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmPkIntSsHlReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                                UConnId spInstId,SsHlEvnt *ssHlEvnt,
                                Action action));

EXTERN S16 cmPkIntSsHlRsp ARGS((Pst *pst,SpId spId,UConnId suInstId,
                                 UConnId spInstId,SsHlEvnt *ssHlEvnt,
                                 Action action));

EXTERN S16 cmPkIntRmRtReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                                 UConnId spInstId,RmRtEvnt *rmRtEvnt,
                                 Action action,SuId dChan,Ces ces));

EXTERN S16 cmPkIntRmRtRsp ARGS((Pst *pst,SpId spId,UConnId suInstId,
                                UConnId spInstId,RmRtEvnt *rmRtEvnt,
                                Action action));
#endif


#ifdef ISDN_FACILITY
EXTERN S16 cmPkIntFacReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                               UConnId spInstId,FacEvnt  *facEvnt,
                               U8 evntType,SuId dChan,Ces ces));
#endif

EXTERN S16 cmPkIntStaReq ARGS((Pst *pst,SpId spId,UConnId suInstId,
                               UConnId spInstId,StaEvnt *staEvnt,U8 evntType));

#ifdef ISDN_SRV
EXTERN S16 cmPkIntSrvReq ARGS((Pst *pst,SpId spId,Srv *srvEvnt,SuId dChan,
                               Ces ces));
#endif

EXTERN S16 cmPkIntRstReq ARGS((Pst *pst,SpId spId,Rst *rstEvnt,
                               SuId dChan,Ces ces,U8 reqType));


/* Indication/Response Packing Functions */

EXTERN S16 cmPkIntConInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                               UConnId spInstId,ConEvnt *conEvnt,
                               SuId dChan, Ces ces));
EXTERN S16 cmPkIntConCfm ARGS((Pst *pst,SuId suId,UConnId suInstId,
                               UConnId spInstId,CnStEvnt *cnStEvnt,
                               SuId dChan, Ces ces));
EXTERN S16  cmPkIntCnStInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                 UConnId spInstId,CnStEvnt *cnStEvnt,
                                 U8 evntType,SuId dChan, Ces ces));
EXTERN S16  cmPkIntDiscInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                 UConnId spInstId,DiscEvnt *discEvnt));
EXTERN S16  cmPkIntRelInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                UConnId spInstId,RelEvnt *relEvnt));

#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmPkIntSsHlInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                UConnId spInstId,SsHlEvnt *ssHlEvnt,
                                Action action));

EXTERN S16 cmPkIntSsHlCfm ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                UConnId spInstId,SsHlEvnt *ssHlEvnt,
                                Action action));

EXTERN S16 cmPkIntRmRtInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                UConnId spInstId,RmRtEvnt *rmRtEvnt,
                                Action action));

EXTERN S16 cmPkIntRmRtCfm ARGS((Pst *pst,SuId suId,UConnId suInstId,
                                UConnId spInstId,RmRtEvnt *rmRtEvnt,
                                Action action));
#endif



#ifdef ISDN_FACILITY
EXTERN S16 cmPkIntFacInd ARGS((Pst *pst,SuId suId,UConnId suInstId,
                               UConnId spInstId,FacEvnt  *facEvnt,
                               U8 evntType,SuId dChan,Ces ces));
#endif

#ifdef ISDN_SRV
EXTERN S16 cmPkIntSrvInd ARGS((Pst *pst,SuId suId,Srv *srvEvnt,
                               SuId dChan,Ces ces));

EXTERN S16 cmPkIntSrvCfm ARGS((Pst *pst,SuId suId,Srv *srvEvnt,SuId dChan,
                               Ces ces));
#endif

EXTERN S16 cmPkIntStaCfm ARGS((Pst *pst,SuId suId,UConnId suInstId,
                               UConnId spInstId,StaEvnt *staEvnt));
EXTERN S16 cmPkIntRstCfm ARGS((Pst *pst,SuId suId,Rst *rstEvnt,SuId dChan,
                               Ces ces, U8 evtType));
EXTERN S16 cmPkIntRstInd ARGS((Pst *pst,SuId suId,Rst *rstEvnt,SuId dChan,
                               Ces ces, U8 evtType));
#ifdef QW
#ifdef IN_RSCIND
EXTERN S16 cmPkIntRscStaInd ARGS((Pst *pst, SuId suId, U16 event, U16 cause,
                                  SuId linkId, U8 chanNum));
#endif /* IN_RSCIND */
#endif /* QW */
#endif /*LCINT */
#else /* ISDN_3_8_PLUS */

/* Backward Compatible with v 3.8 */

typedef S16 (*IntConInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, ConEvnt *conEvnt, SuId dChan)); 
typedef S16 (*IntConCfm) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChan)); 
typedef S16 (*IntCnStInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan)); 
typedef S16 (*IntDiscInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt)); 
typedef S16 (*IntRelInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt)); 
typedef S16 (*IntDatInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt)); 
typedef S16 (*IntSsHlInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntSsHlCfm) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntRmRtInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action)); 
typedef S16 (*IntRmRtCfm) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action)); 
typedef S16 (*IntFlcInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, Action action)); 
typedef S16 (*IntFacInd) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan)); 
typedef S16 (*IntStaCfm) ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt)); 
typedef S16 (*IntSrvInd) ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan)); 
typedef S16 (*IntSrvCfm) ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan)); 
typedef S16 (*IntRstCfm) ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, U8 evtType)); 


typedef S16 (*IntConReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        ConEvnt *conEvnt, SuId dChan)); 
typedef S16 (*IntConRsp) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes)); 
typedef S16 (*IntCnStReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan)); 


#ifdef NETSIDE
#ifdef ISDN_PTMPT
typedef S16 (*IntSetupComp) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChan)); 
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */

typedef S16 (*IntDiscReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt)); 
typedef S16 (*IntRelReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt)); 
typedef S16 (*IntDatReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt)); 
typedef S16 (*IntSsHlReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntSsHlRsp) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action)); 
typedef S16 (*IntRmRtReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan)); 
typedef S16 (*IntRmRtRsp) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action)); 
typedef S16 (*IntFlcReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, Action action)); 
typedef S16 (*IntFacReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan)); 

typedef S16 (*IntStaReq) ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt, U8 evntType)); 

typedef S16 (*IntSrvReq) ARGS((SuPst *pst, SpId spId, Srv *srvEvnt, 
        SuId dChan)); 
typedef S16 (*IntRstReq) ARGS((SuPst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, U8 reqType)); 

#ifdef IN
/* q.930/q.931, upper interface, isdn network discriminator */

EXTERN  S16 InUiIntConReq ARGS((Pst *pst, SpId spId, SuInstId suInstId, 
        ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 InUiIntConRsp ARGS((Pst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes));
EXTERN  S16 InUiIntCnStReq ARGS((Pst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));

#ifdef NETSIDE
#ifdef ISDN_PTMPT 
EXTERN  S16 InUiIntSetupComp ARGS((Pst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChan));
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */

EXTERN  S16 InUiIntDiscReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 InUiIntRelReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 InUiIntDatReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 InUiIntSsHlReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 InUiIntSsHlRsp ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 InUiIntRmRtReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan));
EXTERN  S16 InUiIntRmRtRsp ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 InUiIntFlcReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, Action action));
EXTERN  S16 InUiIntFacReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan));
EXTERN  S16 InUiIntStaReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt, U8 evntType));
EXTERN  S16 InUiIntSrvReq ARGS((Pst *pst,SpId spId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 InUiIntRstReq ARGS((Pst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, U8 reqType)); 

#endif /* IN */

#ifdef IX

/* x.31, lower interface, isdn network discriminator */
EXTERN  S16 IxLiIntConReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 IxLiIntConRsp ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes));
EXTERN  S16 IxLiIntCnStReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));
EXTERN  S16 IxLiIntDiscReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 IxLiIntRelReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 IxLiIntDatReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 IxLiIntSsHlReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntSsHlRsp ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntRmRtReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan));
EXTERN  S16 IxLiIntRmRtRsp ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 IxLiIntFlcReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, Action action));
EXTERN  S16 IxLiIntFacReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan));

EXTERN  S16 IxLiIntStaReq ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt, U8 evntType));

EXTERN  S16 IxLiIntSrvReq ARGS((Pst *pst,SuId suId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 IxLiIntRstReq ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, U8 reqType)); 

EXTERN  S16 IxLiIntConInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 IxLiIntConCfm ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChan));
EXTERN  S16 IxLiIntCnStInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));
EXTERN  S16 IxLiIntDiscInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 IxLiIntRelInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 IxLiIntDatInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 IxLiIntSsHlInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntSsHlCfm ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 IxLiIntRmRtInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 IxLiIntRmRtCfm ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 IxLiIntFlcInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, Action action));
EXTERN  S16 IxLiIntFacInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan));
EXTERN  S16 IxLiIntStaCfm ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt));
EXTERN  S16 IxLiIntSrvInd ARGS((Pst *pst,SuId suId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 IxLiIntSrvCfm ARGS((Pst *pst,SuId suId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 IxLiIntRstCfm ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, U8 evtType)); 
EXTERN  S16 IxLiIntStaInd ARGS ((Pst *pst, SuId suId, SuInstId suInstId, 
                                 SpInstId spInstId,StaEvnt *staEvnt));

#endif /*IX*/

#ifdef AN

/* application program, lower interface, isdn network discriminator */

EXTERN  S16 AnLiIntConInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 AnLiIntConCfm ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChan));
EXTERN  S16 AnLiIntCnStInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));
EXTERN  S16 AnLiIntDiscInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 AnLiIntRelInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 AnLiIntDatInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 AnLiIntSsHlInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntSsHlCfm ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntRmRtInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 AnLiIntRmRtCfm ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 AnLiIntFlcInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, Action action));
EXTERN  S16 AnLiIntFacInd ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan));
EXTERN  S16 AnLiIntStaCfm ARGS((SuPst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt));
EXTERN  S16 AnLiIntSrvInd ARGS((SuPst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 AnLiIntSrvCfm ARGS((SuPst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 AnLiIntRstCfm ARGS((SuPst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, U8 evtType)); 

EXTERN  S16 AnLiIntConReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 AnLiIntConRsp ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes));
EXTERN  S16 AnLiIntCnStReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));
#ifdef NETSIDE
#ifdef ISDN_PTMPT
EXTERN  S16 AnLiIntSetupComp ARGS((SuPst *pst, SpId spId, 
                                      SuInstId suInstId, SpInstId spInstId, 
                                      CnStEvnt *cnStEvnt,SuId dChan));
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */

EXTERN  S16 AnLiIntDiscReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 AnLiIntRelReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 AnLiIntDatReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 AnLiIntSsHlReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntSsHlRsp ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 AnLiIntRmRtReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan));
EXTERN  S16 AnLiIntRmRtRsp ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 AnLiIntFlcReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, Action action));
EXTERN  S16 AnLiIntFacReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan));

EXTERN  S16 AnLiIntStaReq ARGS((SuPst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt, U8 evntType));

EXTERN  S16 AnLiIntSrvReq ARGS((SuPst *pst, SpId spId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 AnLiIntRstReq ARGS((SuPst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, U8 reqType)); 
#endif /* AN */

#ifdef BCUIINT

/* tightly coupled, backward compatibility */

EXTERN  S16 NConInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 NConCfm ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        CnStEvnt *cnStEvnt, SuId dChan));
EXTERN  S16 NCnStInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));
EXTERN  S16 NDiscInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        DiscEvnt *discEvnt));
EXTERN  S16 NRelInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        RelEvnt *relEvnt));
EXTERN  S16 NDatInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        InfoEvnt *infoEvnt));
EXTERN  S16 NSsHlInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 NSsHlCfm ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        SsHlEvnt *ssHlEvnt));
EXTERN  S16 NRmRtInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 NRmRtCfm ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        RmRtEvnt *rmRtEvnt));
EXTERN  S16 NFlcInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        Action action));
EXTERN  S16 NFacInd ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        FacEvnt *facEvnt, U8 evntType));
EXTERN  S16 NStaCfm ARGS((SuId suId, SuInstId suInstId, SpInstId spInstId, 
        StaEvnt *staEvnt));
EXTERN  S16 NSrvInd ARGS((SuId suId, Srv *srvEvnt, SuId dChan));
EXTERN  S16 NSrvCfm ARGS((SuId suId, Srv *srvEvnt, SuId dChan));
#endif /*BCUIINT*/



#ifdef QW

/* q.930/q.931 PSIF upper interface, isdn network discriminator */

EXTERN  S16 QwLiIntConInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 QwLiIntConCfm ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChan));
EXTERN  S16 QwLiIntCnStInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));
EXTERN  S16 QwLiIntDiscInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 QwLiIntRelInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 QwLiIntDatInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 QwLiIntSsHlInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntSsHlCfm ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntRmRtInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 QwLiIntRmRtCfm ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 QwLiIntFlcInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, Action action));
EXTERN  S16 QwLiIntFacInd ARGS((Pst *pst,SuId suId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan));
EXTERN  S16 QwLiIntStaCfm ARGS((Pst *pst, SuId suId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt));
EXTERN  S16 QwLiIntSrvInd ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 QwLiIntSrvCfm ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 QwLiIntRstCfm ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, U8 evtType)); 
EXTERN  S16 QwLiIntConReq ARGS((Pst *pst, SpId spId, SuInstId suInstId, 
        ConEvnt *conEvnt, SuId dChan));
EXTERN  S16 QwLiIntConRsp ARGS((Pst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, SuId dChanCes));
EXTERN  S16 QwLiIntCnStReq ARGS((Pst *pst, SpId spId, SuInstId suInstId, 
        SpInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan));
EXTERN  S16 QwLiIntDiscReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 QwLiIntRelReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 QwLiIntDatReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 QwLiIntSsHlReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntSsHlRsp ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 QwLiIntRmRtReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action, SuId dChan));
EXTERN  S16 QwLiIntRmRtRsp ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 QwLiIntFlcReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, Action action));
EXTERN  S16 QwLiIntFacReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan));
EXTERN  S16 QwLiIntStaReq ARGS((Pst *pst,SpId spId, SuInstId suInstId, 
        SpInstId spInstId, StaEvnt *staEvnt, U8 evntType));
EXTERN  S16 QwLiIntSrvReq ARGS((Pst *pst,SpId spId, Srv *srvEvnt, 
        SuId dChan));
EXTERN  S16 QwLiIntRstReq ARGS((Pst *pst, SpId spId, Rst *rstEvnt, 
        SuId dChan, U8 reqType)); 
#endif /* QW */


/* Packing functions */

/* Request Packing Functions */

#ifdef LCINT

EXTERN S16 cmPkIntConReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                               ConEvnt *conEvnt,SuId dChan));
EXTERN S16 cmPkIntConRsp ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                               SpInstId spInstId,CnStEvnt *cnStEvnt,
                               SuId dChanCes));
EXTERN S16 cmPkIntCnStReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                                SpInstId spInstId,CnStEvnt *cnStEvnt,
                                U8 evntType,SuId dChan));
#ifdef NETSIDE
#ifdef ISDN_PTMPT
EXTERN S16 cmPkIntSetupComp ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                                  SpInstId spInstId,CnStEvnt *cnStEvnt,
                                  SuId dChan));
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */


EXTERN S16 cmPkIntDiscReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                                SpInstId spInstId,DiscEvnt *discEvnt));
EXTERN S16 cmPkIntRelReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                               SpInstId spInstId,RelEvnt *relEvnt));

#ifdef ISDN_UTU
EXTERN S16 cmPkIntDatReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                               SpInstId spInstId,InfoEvnt *infoEvnt));

EXTERN S16 cmPkIntFlcReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                               SpInstId spInstId,Action action));

EXTERN S16  cmPkIntDatInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,InfoEvnt *infoEvnt));

EXTERN S16  cmPkIntFlcInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,Action action));
#endif /* ISDN_UTU */

#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmPkIntSsHlReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                                SpInstId spInstId,SsHlEvnt *ssHlEvnt,
                                Action action));

EXTERN S16 cmPkIntSsHlRsp ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                                 SpInstId spInstId,SsHlEvnt *ssHlEvnt,
                                 Action action));

EXTERN S16 cmPkIntRmRtReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                                 SpInstId spInstId,RmRtEvnt *rmRtEvnt,
                                 Action action,SuId dChan));

EXTERN S16 cmPkIntRmRtRsp ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                                SpInstId spInstId,RmRtEvnt *rmRtEvnt,
                                Action action));
#endif



#ifdef ISDN_FACILITY
EXTERN S16 cmPkIntFacReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                               SpInstId spInstId,FacEvnt  *facEvnt,
                               U8 evntType,SuId dChan));
#endif

EXTERN S16 cmPkIntStaReq ARGS((Pst *pst,SpId spId,SuInstId suInstId,
                               SpInstId spInstId,StaEvnt *staEvnt,
                               U8 evntType));

#ifdef ISDN_SRV
EXTERN S16 cmPkIntSrvReq ARGS((Pst *pst,SpId spId,Srv *srvEvnt,SuId dChan));
#endif

EXTERN S16 cmPkIntRstReq ARGS((Pst *pst,SpId spId,Rst *rstEvnt,
                               SuId dChan, U8 reqType));



/* Indication/Response Packing Functions */

EXTERN S16 cmPkIntConInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                               SpInstId spInstId,ConEvnt *conEvnt,
                               SuId dChan));
EXTERN S16 cmPkIntConCfm ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                               SpInstId spInstId,CnStEvnt *cnStEvnt,
                               SuId dChan));
EXTERN S16  cmPkIntCnStInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                 SpInstId spInstId,CnStEvnt *cnStEvnt,
                                 U8 evntType,SuId dChan));
EXTERN S16  cmPkIntDiscInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                 SpInstId spInstId,DiscEvnt *discEvnt));
EXTERN S16  cmPkIntRelInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,RelEvnt *relEvnt));


#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmPkIntSsHlInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,SsHlEvnt *ssHlEvnt,
                                Action action));

EXTERN S16 cmPkIntSsHlCfm ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,SsHlEvnt *ssHlEvnt,
                                Action action));

EXTERN S16 cmPkIntRmRtInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,RmRtEvnt *rmRtEvnt,
                                Action action));

EXTERN S16 cmPkIntRmRtCfm ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,RmRtEvnt *rmRtEvnt,
                                Action action));
#endif



#ifdef ISDN_FACILITY
EXTERN S16 cmPkIntFacInd ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                               SpInstId spInstId,FacEvnt  *facEvnt,
                               U8 evntType,SuId dChan));
#endif

#ifdef ISDN_SRV
EXTERN S16 cmPkIntSrvInd ARGS((Pst *pst,SuId suId,Srv *srvEvnt,
                               SuId dChan));

EXTERN S16 cmPkIntSrvCfm ARGS((Pst *pst,SuId suId,Srv *srvEvnt,SuId dChan));
#endif

EXTERN S16  cmPkIntStaCfm ARGS((Pst *pst,SuId suId,SuInstId suInstId,
                                SpInstId spInstId,StaEvnt *staEvnt));
EXTERN S16 cmPkIntRstCfm ARGS((Pst *pst,SuId suId,Rst *rstEvnt,SuId dChan,
                               U8 evtType));
#endif /*LCINT */
#endif /* ISDN_3_8_PLUS */

#ifdef IN

/* q.930/q.931, upper interface, isdn network discriminator */

EXTERN  S16 InUiIntConInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, ConEvnt *conEvnt, SuId dChan, Ces ces));
EXTERN  S16 InUiIntConCfm ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, CnStEvnt *cnStEvnt, SuId dChan, Ces ces));
EXTERN  S16 InUiIntCnStInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, CnStEvnt *cnStEvnt, U8 evntType, SuId dChan, Ces
                ces));
EXTERN  S16 InUiIntDiscInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, DiscEvnt *discEvnt));
EXTERN  S16 InUiIntRelInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, RelEvnt *relEvnt));
EXTERN  S16 InUiIntDatInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, InfoEvnt *infoEvnt));
EXTERN  S16 InUiIntSsHlInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 InUiIntSsHlCfm ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, SsHlEvnt *ssHlEvnt, Action action));
EXTERN  S16 InUiIntRmRtInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
EXTERN  S16 InUiIntRmRtCfm ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, RmRtEvnt *rmRtEvnt, Action action));
#ifdef ISDN_3_8_PLUS
EXTERN  S16 InUiIntFlcInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, StaEvnt *staEvnt));
#else /* ISDN_3_8_PLUS */
EXTERN  S16 InUiIntFlcInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, Action action));
#endif /* ISDN_3_8_PLUS */
EXTERN  S16 InUiIntFacInd ARGS((Pst *pst,SuId suId, InInstId suInstId, 
        InInstId spInstId, FacEvnt *facEvnt, U8 evntType, SuId dChan, Ces ces));
EXTERN  S16 InUiIntStaCfm ARGS((Pst *pst, SuId suId, InInstId suInstId, 
        InInstId spInstId, StaEvnt *staEvnt));
EXTERN  S16 InUiIntSrvInd ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 InUiIntSrvCfm ARGS((Pst *pst, SuId suId, Srv *srvEvnt, 
        SuId dChan, Ces ces));
EXTERN  S16 InUiIntRstCfm ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 
EXTERN  S16 InUiIntRstInd ARGS((Pst *pst, SuId suId, Rst *rstEvnt, 
        SuId dChan, Ces ces, U8 evtType)); 
#ifdef ISDN_3_8_PLUS
#ifdef QW
#ifdef IN_RSCIND
EXTERN  S16 InUiIntRscStaInd ARGS((Pst *pst, SuId suId, U16 event,
        U16 cause, SuId linkId, U8 chanNum));
#endif /* IN_RSCIND */
#endif /* QW */ 
#endif /* ISDN_3_8_PLUS */
#endif /* IN */


/***********************************************************************/
/*                    Event  Packing functions                        */
/***********************************************************************/


EXTERN S16 cmPkConEvnt ARGS((ConEvnt *conEvnt,Buffer *mBuf));
EXTERN S16 cmPkCnStEvnt ARGS((CnStEvnt *cnStEvnt,Buffer *mBuf));
EXTERN S16 cmPkDiscEvnt ARGS((DiscEvnt *discEvnt,Buffer *mBuf));
EXTERN S16 cmPkRelEvnt ARGS((RelEvnt *relEvnt,Buffer *mBuf));

#ifdef ISDN_UTU
EXTERN S16 cmPkInfoEvnt ARGS((InfoEvnt *infoEvnt,Buffer *mBuf));
#endif /* ISDN_UTU */

EXTERN S16 cmPkStaEvnt ARGS((StaEvnt *staEvnt,Buffer *mBuf));

#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmPkSsHlEvnt ARGS((SsHlEvnt *ssHlEvnt,Buffer *mBuf));
EXTERN S16 cmPkRmRtEvnt ARGS((RmRtEvnt *rmRtEvnt,Buffer *mBuf));
#endif

#ifdef ISDN_FACILITY
EXTERN S16 cmPkFacEvnt ARGS((FacEvnt *facEvnt,Buffer *mBuf));
#endif

#ifdef ISDN_SRV
EXTERN S16 cmPkSrvEvnt ARGS((Srv *srvEvnt,Buffer *mBuf));
#endif

EXTERN S16 cmPkRstEvnt ARGS((Rst *rstEvnt,Buffer *mBuf));


/***********************************************************************/
/*            Packing functions for Common Structures                  */
/***********************************************************************/

EXTERN S16 cmIntPkElmtHdr ARGS((ElmtHdr *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtUsrUsrE ARGS((UsrUsrE *m,Buffer *mBuf));

#ifdef VN2
EXTERN S16 cmIntPkElmtVnUsrFac ARGS((VnUsrFac *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtVnNetFac ARGS((VnNetFac *m,Buffer *mBuf));
#endif


#ifdef NTT
EXTERN S16 cmIntPkElmtNttAdvChrge6 ARGS((NttAdvChrge6 *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtNttBlkChanId ARGS((NttBlkChanId *m, Buffer *mBuf));
#endif

#ifdef QSIG
EXTERN S16 cmIntPkElmtQSigInfoTran ARGS((QSigInfoTran *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtQPtyCat ARGS((QPtyCat *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtQTranCntr ARGS((QTranCntr *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtQFacility ARGS((QFacility *m,Buffer *mBuf));
#endif

EXTERN S16 cmIntPkElmtLlComp ARGS((LlComp *m,Buffer *mBuf));

#ifdef VN2 
EXTERN S16 cmIntPkElmtLlCompF ARGS((LlCompF *m,Buffer *mBuf));
#endif /* VN2 */

EXTERN S16 cmIntPkElmtSndCmplt ARGS((SndCmplt *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtBearCap ARGS((BearCap *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtFacility ARGS((Facility *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtCnPtyNmb ARGS((CnPtyNmb *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtCgPtySad ARGS((CgPtySad *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtCdPtySad ARGS((CdPtySad *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtRedirNmb ARGS((RedirNmb *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtFacilityStr ARGS((FacilityStr *m,Buffer *mBuf));

#if (ISDN_303TMC || ISDN_303CSC)
EXTERN S16 cmIntPkElmtBCCallRef ARGS((BCCallRef *m,Buffer *mBuf));
#endif

#ifdef INTR6
EXTERN S16 cmIntPkElmtTrNetFac ARGS((TrNetFac *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrCause ARGS((TrCause *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrServIndic6 ARGS((TrServIndic6 *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrAdTrmAttrb6 ARGS((TrAdTrmAttrb6 *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrCdPtyStat6 ARGS((TrCdPtyStat6 *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrChgeInfo6 ARGS((TrChgeInfo6 *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrDate6 ARGS((TrDate6 *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrUsrUsr ARGS((TrUsrUsr *m, Buffer *mBuf));
#endif
#ifdef ETSI
EXTERN S16 cmIntPkElmtEtsiNetFac ARGS((EtsiNetFac *m,Buffer *mBuf));
#endif

EXTERN S16 cmIntPkElmtNetFac ARGS((NetFac *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtDatTim ARGS((DatTim *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtKeyFac ARGS((KeyFac *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtSignal ARGS((Signal *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtSwtchk ARGS((Swtchk *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtFeaAct ARGS((FeaAct *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtFeaInd ARGS((FeaInd *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtInfoRate ARGS((InfoRate *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtTranDlySel ARGS((TranDlySel *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtPktBin ARGS((PktBin *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtPktWin ARGS((PktWin *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtPktSze ARGS((PktSze *m,Buffer *mBuf));

EXTERN S16 cmIntPkElmtMoreData ARGS((MoreData *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtNotInd ARGS((NotInd *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtCallId ARGS((CallId *m,Buffer *mBuf));

EXTERN S16 cmIntPkElmtFacElmt ARGS((FacElmt *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtOctStr ARGS((ElmtStr *tknStr,Buffer *mBuf));
EXTERN S16 cmIntPkElmtInfoReq ARGS((InfoReq *m, Buffer *mBuf));

EXTERN S16 cmIntPkElmtServProf ARGS((ServProf *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtEndpoint ARGS((Endpoint *m, Buffer *mBuf));

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTNI) 
EXTERN S16 cmIntPkElmtNtOperSysAcc5 ARGS((NtOperSysAcc5 *m, Buffer *mBuf));
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTNI */ 


#ifdef NI2
EXTERN S16 cmIntPkElmtRvsChrg ARGS((RvsChrg *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtCug ARGS((Cug *m, Buffer *mBuf));
#endif

#if (ISDN_NI1 || ISDN_NI2)
EXTERN S16 cmIntPkElmtNIOperSysAcc ARGS((NIOperSysAcc *m, Buffer *mBuf));
#endif


#ifdef NI1
EXTERN S16 cmIntPkElmtNI1RedirNmb ARGS((NI1RedirNmb *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtRedirSad ARGS((RedirSad *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtDisplayTxt ARGS((DisplayTxt *m, Buffer *mBuf));
#endif

EXTERN S16 cmIntPkElmtChanStat ARGS((ChStatus *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtTermCapab ARGS((TermCapab *m, Buffer *mBuf));

EXTERN S16 cmIntPkElmtNtOrgCdNmb ARGS((NtOrgCdNmb *m, Buffer *mBuf));


EXTERN S16 cmIntPkElmtCdPtyNmb ARGS((CdPtyNmb *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtShift ARGS((Shift *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtRepInd ARGS((RepInd *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtCauseDgn ARGS((CauseDgn *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtCallSte ARGS((CallSte *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtChanId ARGS((ChanId *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtProgInd ARGS((ProgInd *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtDisplay ARGS((Display *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtEtoeDly ARGS((EtoeDly *m,Buffer *mBuf));
EXTERN S16 cmIntPkElmtCgPtyNmb ARGS((CgPtyNmb *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtRstInd ARGS((RstInd *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtSubAdrs ARGS((SubAdrs *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtTrnstNtw ARGS((TrnstNtw *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtHlComp ARGS((HlComp *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtUsrUsr ARGS((UsrUsr *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtNullElmt ARGS((NullElmt *m, Buffer *mBuf));


#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
EXTERN S16 cmIntPkElmtNtFacility ARGS((NtFacility *m, Buffer *mBuf));
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI || ISDN_NTNI)
EXTERN S16 cmIntPkElmtNtDisplay ARGS((NtDisplay *m, Buffer *mBuf));
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI || ISDN_NTNI */

#ifdef ISDN_NTSPRINT
EXTERN S16 cmIntPkElmtBusGrp ARGS((BusGrp *m,Buffer *mBuf));
#endif

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
EXTERN S16 cmIntPkElmtTscFacility ARGS((TscFacility *m,Buffer *mBuf));
#endif

#ifdef NTDMS250
EXTERN S16 cmIntPkElmtGenDig ARGS((GenericDig *m,Buffer *mBuf));
#endif

#ifdef NTNI
EXTERN S16 cmIntPkElmtNtNiFacility ARGS((NtNiFacility *m, Buffer *mBuf));
#endif /* NTNI */

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
EXTERN S16 cmIntPkElmtNtOrig ARGS((NtOrig *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtNtDest ARGS((NtDest *m, Buffer *mBuf));
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI */

#ifdef NT
EXTERN S16 cmIntPkElmtNtOpt ARGS((NtOpt *m, Buffer *mBuf));
EXTERN S16 cmIntPkElmtNtRsnRet ARGS((NtRsnRet *m, Buffer *mBuf));
#endif /* NT */
EXTERN S16 cmIntPkElmtCongLvl ARGS((CongLvl *m, Buffer *mBuf));

/***********************************************************************/
/*             Unpacking Functions                                     */
/***********************************************************************/

#ifdef LCINT
EXTERN S16 cmUnpkIntBndReq ARGS((IntBndReq intBndReq,Pst *pst,Buffer *mBuf));
EXTERN S16 cmUnpkIntUbndReq ARGS((IntUbndReq intUbndReq,Pst *pst,
                                  Buffer *mBuf));
#ifdef INT2
EXTERN S16 cmUnpkIntBndCfm ARGS((IntBndCfm intBndCfm,Pst *pst,Buffer *mBuf));
#endif /* INT2 */

EXTERN S16 cmUnpkIntConReq ARGS((IntConReq intConReq,Pst *pst,Buffer *mBuf));
EXTERN S16 cmUnpkIntConRsp ARGS((IntConRsp intConRsp,Pst *pst,Buffer *mBuf));
EXTERN S16 cmUnpkIntCnStReq ARGS((IntCnStReq intCnStReq,Pst *pst,
                                  Buffer *mBuf));
#ifdef NETSIDE
#ifdef ISDN_PTMPT
EXTERN S16 cmUnpkIntSetupComp ARGS((IntSetupComp intSetupComp, Pst *pst,
                                    Buffer *mBuf));
#endif /* ISDN_PTMPT */
#endif /* NETSIDE */
EXTERN S16 cmUnpkIntDiscReq ARGS((IntDiscReq intDiscReq,Pst *pst,
                                  Buffer *mBuf));
EXTERN S16 cmUnpkIntRelReq ARGS((IntRelReq intRelReq,Pst *pst,Buffer *mBuf));

#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmUnpkIntSsHlReq ARGS((IntSsHlReq intSsHlReq,Pst *pst,
                                  Buffer *mBuf));

EXTERN S16 cmUnpkIntSsHlRsp ARGS((IntSsHlRsp intSsHlRsp,Pst *pst,
                                  Buffer *mBuf));

EXTERN S16 cmUnpkIntRmRtReq ARGS((IntRmRtReq intRmRtReq,Pst *pst,
                                  Buffer *mBuf));

EXTERN S16 cmUnpkIntRmRtRsp ARGS((IntRmRtRsp intRmRtRsp,Pst *pst,
                                  Buffer *mBuf));
#endif

EXTERN S16 cmUnpkIntStaReq ARGS((IntStaReq intStaReq,Pst *pst,Buffer *mBuf)); 

#ifdef ISDN_UTU
EXTERN S16 cmUnpkIntDatReq ARGS((IntDatReq intDatReq,Pst *pst,Buffer *mBuf));
EXTERN S16 cmUnpkIntFlcReq ARGS((IntFlcReq intFlcReq,Pst *pst,Buffer *mBuf));
#endif /* ISDN_UTU */

#ifdef ISDN_FACILITY
EXTERN S16 cmUnpkIntFacReq ARGS((IntFacReq intFacReq,Pst *pst,Buffer *mBuf));
#endif

#ifdef ISDN_SRV
EXTERN S16 cmUnpkIntSrvReq ARGS((IntSrvReq intSrvReq,Pst *pst,Buffer *mBuf));
#endif

EXTERN S16 cmUnpkIntRstReq ARGS((IntRstReq intRstReq,Pst *pst,Buffer *mBuf));

EXTERN S16 cmUnpkIntConInd ARGS((IntConInd intConInd,Pst *pst,Buffer *mBuf)); 
EXTERN S16 cmUnpkIntConCfm ARGS((IntConCfm intConCfm,Pst *pst,Buffer *mBuf));
EXTERN S16 cmUnpkIntCnStInd ARGS((IntCnStInd intCnStInd,Pst *pst,
                                  Buffer *mBuf));
EXTERN S16 cmUnpkIntDiscInd ARGS((IntDiscInd intDiscInd,Pst *pst,
                                  Buffer *mBuf));
EXTERN S16 cmUnpkIntRelInd ARGS((IntRelInd intRelInd,Pst *pst,Buffer *mBuf));

#ifdef ISDN_UTU 
EXTERN S16 cmUnpkIntDatInd ARGS((IntDatInd intDatInd,Pst *pst,Buffer *mBuf));
#endif /* ISDN_UTU */

#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmUnpkIntSsHlInd ARGS((IntSsHlInd intSsHlInd,Pst *pst,
                                  Buffer *mBuf));
EXTERN S16 cmUnpkIntSsHlCfm ARGS((IntSsHlCfm intSsHlCfm,Pst *pst,
                                  Buffer *mBuf));
EXTERN S16 cmUnpkIntRmRtInd ARGS((IntRmRtInd intRmRtInd,Pst *pst,
                                  Buffer *mBuf));
EXTERN S16 cmUnpkIntRmRtCfm ARGS((IntRmRtCfm intRmRtCfm,Pst *pst,
                                  Buffer *mBuf));
#endif 

#ifdef ISDN_FACILITY
EXTERN S16 cmUnpkIntFacInd ARGS((IntFacInd intFacInd, Pst *pst,Buffer *mBuf));
#endif


EXTERN S16 cmUnpkIntStaCfm ARGS((IntStaCfm intStaCfm,Pst *pst,Buffer *mBuf));

#ifdef ISDN_SRV
EXTERN S16 cmUnpkIntSrvInd ARGS((IntSrvInd intSrvInd, Pst *pst,Buffer *mBuf));
EXTERN S16 cmUnpkIntSrvCfm ARGS((IntSrvCfm intSrvCfm, Pst *pst,Buffer *mBuf));
#endif

EXTERN S16 cmUnpkIntRstCfm ARGS((IntRstCfm intRstCfm,Pst *pst,Buffer *mBuf));

#ifdef ISDN_3_8_PLUS 
EXTERN S16 cmUnpkIntRstInd ARGS((IntRstInd intRstInd,Pst *pst,Buffer *mBuf));
#ifdef QW
#ifdef IN_RSCIND 
EXTERN S16 cmUnpkIntRscStaInd ARGS((IntRscStaInd intRscStaInd, Pst *pst,
                                    Buffer *mBuf));
#endif /* IN_RSCIND */
#endif /* QW */
#endif /* ISDN_3_8_PLUS */

EXTERN S16 cmUnpkConEvnt ARGS((ConEvnt *conEvnt,Buffer *mBuf));
EXTERN S16 cmUnpkCnStEvnt ARGS((CnStEvnt *cnStEvnt,Buffer *mBuf)); 
EXTERN S16 cmUnpkDiscEvnt ARGS((DiscEvnt *discEvnt,Buffer *mBuf));
EXTERN S16 cmUnpkRelEvnt ARGS((RelEvnt *relEvnt,Buffer *mBuf));
EXTERN S16 cmUnpkStaEvnt ARGS((StaEvnt *staEvnt,Buffer *mBuf)); 
EXTERN S16 cmUnpkRstEvnt ARGS((Rst *rstEvnt,Buffer *mBuf));

#ifdef ISDN_UTU
EXTERN S16 cmUnpkInfoEvnt ARGS((InfoEvnt *infoEvnt,Buffer *mBuf));
#endif /* ISDN_UTU */

#if (ISDN_SUSPEND || ISDN_HOLD)
EXTERN S16 cmUnpkSsHlEvnt ARGS((SsHlEvnt *ssHlEvnt,Buffer *mBuf));
EXTERN S16 cmUnpkRmRtEvnt ARGS((RmRtEvnt *rmRtEvnt,Buffer *mBuf));
#endif

#ifdef ISDN_FACILITY
EXTERN S16 cmUnpkFacEvnt ARGS((FacEvnt *facEvnt,Buffer *mBuf));
#endif

#ifdef ISDN_SRV
EXTERN S16 cmUnpkSrvEvnt ARGS((Srv *srvEvnt,Buffer *mBuf));
#endif




/***********************************************************************/
/*            Unpacking functions for Common Structures                  */
/***********************************************************************/


EXTERN S16 cmIntUnpkElmtHdr ARGS((ElmtHdr *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtNullElmt ARGS((NullElmt *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtUsrUsrE ARGS((UsrUsrE *m,Buffer *mBuf));

#ifdef VN2
EXTERN S16 cmIntUnpkElmtVnUsrFac ARGS((VnUsrFac *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtVnNetFac ARGS((VnNetFac *m,Buffer *mBuf));
#endif
#ifdef NTT
EXTERN S16 cmIntUnpkElmtNttAdvChrge6 ARGS((NttAdvChrge6 *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtNttBlkChanId ARGS((NttBlkChanId *m, Buffer *mBuf));
#endif

#ifdef QSIG
EXTERN S16 cmIntUnpkElmtQSigInfoTran ARGS((QSigInfoTran *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtQPtyCat ARGS((QPtyCat *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtQTranCntr ARGS((QTranCntr *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtQFacility ARGS((QFacility *m,Buffer *mBuf));
#endif

EXTERN S16 cmIntUnpkElmtLlComp ARGS((LlComp *m,Buffer *mBuf));

#ifdef VN2
EXTERN S16 cmIntUnpkElmtLlCompF ARGS((LlCompF *m,Buffer *mBuf));
#endif /* VN2 */

EXTERN S16 cmIntUnpkElmtSndCmplt ARGS((SndCmplt *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtBearCap ARGS((BearCap *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtFacility ARGS((Facility *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCnPtyNmb ARGS((CnPtyNmb *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCgPtySad ARGS((CgPtySad *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCdPtySad ARGS((CdPtySad *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtRedirNmb ARGS((RedirNmb *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtFacilityStr ARGS((FacilityStr *m,Buffer *mBuf));

#if (ISDN_303TMC || ISDN_303CSC)
EXTERN S16 cmIntUnpkElmtBCCallRef ARGS((BCCallRef *m,Buffer *mBuf));
#endif

#ifdef INTR6
EXTERN S16 cmIntUnpkElmtTrNetFac ARGS((TrNetFac *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrCause ARGS((TrCause *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrServIndic6 ARGS((TrServIndic6 *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrAdTrmAttrb6 ARGS((TrAdTrmAttrb6 *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrCdPtyStat6 ARGS((TrCdPtyStat6 *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrChgeInfo6 ARGS((TrChgeInfo6 *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrDate6 ARGS((TrDate6 *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrUsrUsr ARGS((TrUsrUsr *m, Buffer *mBuf));
#endif
#ifdef ETSI
EXTERN S16 cmIntUnpkElmtEtsiNetFac ARGS((EtsiNetFac *m,Buffer *mBuf));
#endif

EXTERN S16 cmIntUnpkElmtNetFac ARGS((NetFac *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtDatTim ARGS((DatTim *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtKeyFac ARGS((KeyFac *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtSignal ARGS((Signal *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtSwtchk ARGS((Swtchk *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtFeaAct ARGS((FeaAct *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtFeaInd ARGS((FeaInd *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtInfoRate ARGS((InfoRate *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTranDlySel ARGS((TranDlySel *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtPktBin ARGS((PktBin *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtPktWin ARGS((PktWin *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtPktSze ARGS((PktSze *m,Buffer *mBuf));

EXTERN S16 cmIntUnpkElmtMoreData ARGS((MoreData *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtNotInd ARGS((NotInd *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCallId ARGS((CallId *m,Buffer *mBuf));

EXTERN S16 cmIntUnpkElmtFacElmt ARGS((FacElmt *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtOctStr ARGS((ElmtStr *tknStr,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtInfoReq ARGS((InfoReq *m, Buffer *mBuf));

EXTERN S16 cmIntUnpkElmtServProf ARGS((ServProf *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtEndpoint ARGS((Endpoint *m, Buffer *mBuf));

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTNI)
EXTERN S16 cmIntUnpkElmtNtOperSysAcc5 ARGS((NtOperSysAcc5 *m, Buffer *mBuf));
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTNI */


#ifdef NI2
EXTERN S16 cmIntUnpkElmtRvsChrg ARGS((RvsChrg *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCug ARGS((Cug *m, Buffer *mBuf));
#endif

#if (ISDN_NI1 || ISDN_NI2)
EXTERN S16 cmIntUnpkElmtNIOperSysAcc ARGS((NIOperSysAcc *m, Buffer *mBuf));
#endif


#ifdef NI1
EXTERN S16 cmIntUnpkElmtNI1RedirNmb ARGS((NI1RedirNmb *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtRedirSad ARGS((RedirSad *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtDisplayTxt ARGS((DisplayTxt *m, Buffer *mBuf));
#endif

EXTERN S16 cmIntUnpkElmtChanStat ARGS((ChStatus *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTermCapab ARGS((TermCapab *m, Buffer *mBuf));

EXTERN S16 cmIntUnpkElmtNtOrgCdNmb ARGS((NtOrgCdNmb *m, Buffer *mBuf));

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
EXTERN S16 cmIntUnpkElmtNtFacility ARGS((NtFacility *m, Buffer *mBuf));
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI */
#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI || ISDN_NTNI)
EXTERN S16 cmIntUnpkElmtNtDisplay ARGS((NtDisplay *m, Buffer *mBuf));
#endif /* ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI || ISDN_NTNI */

#ifdef ISDN_NTSPRINT
EXTERN S16 cmIntUnpkElmtBusGrp ARGS((BusGrp *m,Buffer *mBuf));
#endif

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
EXTERN S16 cmIntUnpkElmtTscFacility ARGS((TscFacility *m,Buffer *mBuf));
#endif

#ifdef NTDMS250
EXTERN S16 cmIntUnpkElmtGenDig ARGS((GenericDig *m,Buffer *mBuf));
#endif

#ifdef NTNI
EXTERN S16 cmIntUnpkElmtNtNiFacility ARGS((NtNiFacility *m, Buffer *mBuf));
#endif /* NTNI */

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
EXTERN S16 cmIntUnpkElmtNtOrig ARGS((NtOrig *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtNtDest ARGS((NtDest *m, Buffer *mBuf));
#endif /*(ISDN_NT || ISDN_NTSPRINT|| ISDN_NTMCI) */

#ifdef NT
EXTERN S16 cmIntUnpkElmtNtOpt ARGS((NtOpt *m, Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtNtRsnRet ARGS((NtRsnRet *m, Buffer *mBuf));
#endif /* NT */

EXTERN S16 cmIntUnpkElmtCdPtyNmb ARGS((CdPtyNmb *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtShift ARGS((Shift *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtRepInd ARGS((RepInd *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCauseDgn ARGS((CauseDgn *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCallSte ARGS((CallSte *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtChanId ARGS((ChanId *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtProgInd ARGS((ProgInd *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtDisplay ARGS((Display *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtEtoeDly ARGS((EtoeDly *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCgPtyNmb ARGS((CgPtyNmb *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtRstInd ARGS((RstInd *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtSubAdrs  ARGS((SubAdrs *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtTrnstNtw ARGS((TrnstNtw *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtHlComp ARGS((HlComp *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtUsrUsr ARGS((UsrUsr *m,Buffer *mBuf));
EXTERN S16 cmIntUnpkElmtCongLvl ARGS((CongLvl *m, Buffer *mBuf));
#endif /* LCINT */

#undef SuPst

#ifdef __cplusplus
         }
#endif /* _cplusplus */

#endif


/********************************************************************30**
  
         End of file:     int.x@@/main/32 - Wed May 23 17:06:49 2001
   
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  
  version    initials                   description
-----------  ---------  ------------------------------------------------
1.1.0.0         lc      1. initial release.

1.2.0.0         lc      1. add spares to token and element header for
                           structure alignment
                        2. change call reference, call identity, channel
                           number/slot map, component, network specific
                           facility, keypad information, transit delay,
                           number digits, subaddress information token types

1.3.0.0         lc      1. add att specific information elements, remove
                           token and header typedefs

1.4.0.0         lc      1. change progInd, netFac, cdPtyNmb information
                           elements
                        2. change infoEvnt event
                        3. remove sduType from allSdus
                        4. text changes

1.5.0.0         lc      1. add AttStndFac6, AttLkAhdIntFlw6, AttTrvClsMrk6,
                           AttSubNetTrk6, AttTrkGrpId6, AttTrkGrpStat6,
                           AttUsrEntCode6, AttDisplay6 typdefs
                        2. text changes

1.6.0.0         jkm     1. add ElmtStr typedefs
                        2. remove AttStndFac6, AttLkAhdIntFlw6, AttTrvClsMrk6,
                           AttSubNetTrk6, AttTrkGrpId6, AttTrkGrpStat6,
                           AttUsrEntCode6, AttDisplay6, usrSpec typdefs
                        3. change ATT elements in Alerting, CallProc,
                           Conn, Setup, UsrInfo, Disc, Rel, RelCmplt,
                           ConEvnt, DiscEvnt, InfoEvnt, CnStEvnt, RelEvnt,
                           typedefs
                        4. change NConRsp, NConCfm, pkNConRsp, pkNConCfm
                           prototypes to use CnStEvnt typdef instead of
                           ConEvnt typedef

1.7.0.0         lc      1. add srvEvnt to AllSdus typedef
                        2. add protDiscPres and callRefPres to AllPdus
                           typedef
                        3. add bearCap and notInd to CnStEvnt typedef
                        4. add prototypes for NSrvReq, NSrvInd and
                           NSrvCfm primitives
                        5. remove MSCDOS, MSCUNIX and not MSCDOS or MSCUNIX
                           prototypes and replace with single set of
                           prototypes using argument manipulation macro
                           for ansi or non ansi support to improve
                           portability

1.8             lc      1. Shift Element structure has been changed
                lc      2. new elements were added to support NT DMS-100 
                lc      3. new elements were added to support VN3 
                lc      4. new elements were added to support ATT5E
                jrl     5  text changes
                jrl     6. trillium development system checkpoint (dvs)
                           at version: 1.7.0.0

2.1             lc      1. MsgDef allSduDefs[] has been moved from in.x
                        2. typedefs for new upper interface are included
                        3. prototypes for new upper interface are included
                        4. remove allSduDefs and meCdPtyNmb, moved to
                           qn_db.x

2.2             jrl     1. add dChan to NCnStInd prototype

2.3             bn      1. add vnNetFac to messages and events to conform
                           with VN3 specification.
                        2. add vnUsrFac and shift4 to cnStEvnt.

2.4             bn      1. new elements were added to support INTR6.

2.5             bn      1. corrected definition of alertinng message.

*********************************************************************71*/

/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
2.6          ---  jrl   1. text changes

2.7          ---  bn    1. added prototipes for primitives from application
                           layer to ISDN.

2.8          ---  rg    1. added Date/Time element to Conn & CnStEvnt
                           typedefs, for etsi.

2.9          ---  rg    1. added support for Facility message.
                        2. modified NetFac for etsi support.
                        3. added corrections for VN3.
                        4. added parameter, dChan, to RmRtReq primitives.

2.10         ---  bn    1. corrected codeset 6 and codeset 7 elements defs.

2.11         ---  bn    1. change VN3 define to VN2 define

2.12         ---  bn    1. added connected number and subaddress for etsi
                           in connect message and cnStEvnt.
             ---  bn    2. corrected order of the elements in cnStEvnt
                           and added missing att codeset 6 elements.

2.13         ---  bn    1. add support for tr 303 tmc.

2.14         ---  bn    1. change IN_BC303 to ISDN_BC303, etc.

2.15         ---  bn    1. added prototypes for IntRstReq and IntRstCfm.

2.16         ---  bn    1. changed TknStr to TknStrS in ManIndo6.  

2.17         ---  bn    1. added support for Q.932.
             ---  bn    2. added action to IntSsHlCfm, IntRmRtCfm, IntRmRtRsp
                           and IntSsHlRsp.
             ---  bn    3. changed TknStrS to TknStr in ManIndo6.

2.18         ---  bn    1. added cgPtyNmb1 for INTR6 in conEvnt.

2.19         ---  bn    1. changed TknStr to TknStrS in ManIndo6.

2.20         ---  bn    1. changed #ifdef HOLD to #if ISDN_HOLD.

3.1          ---  bn    1. Changed interfaces to include Pst structure
                           instead of BndCfg.
             ---  bn    2. changed layer manager interface.
             ---  bn    3. added support for NI2.
             ---  bn    4. added support for ETSI QSIG.

3.2          ---  krp   1. Added the following for support of new NTT spec
                           - Block Channel Id element definition.
                           - NTT elements to CnStEvnt and Info message 
                             definition.

3.3          ---  krp   1. change shift element

3.4          --   sb    1. Added dChanCes parameter to ConRsp.

*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------

3.4          ---      sb   1. Added dChanCes parameter to ConRsp.

3.5          ---      sb   1. Added field protProfile to structure 
                              qFacility.
             ---      sb   2. Added structure QSigInfoTran.  This structre 
                              is used to indicate the info. transfer type.
             ---      sb   3. Added fields to structure Facil to have all the 
                              IE of QSIG GFT Facility message.

3.6          ---      sam  1. Added the causeValue and evntType arguments
                              to AnLiIntStaReq, IxLiIntStaReq, InUiIntStaReq
                              functions - patch in007.34

3.7          ---      pk   1. Added prototypes for cmInt functions.

3.8          ---      sam  1. Added NtFacility for Facility IE for NTDMS100P.
             ---      sam  2. Added structure NtDisplay.
                              Modified disc mesg. and discEvnt.
                              Modified notify mesg. and cnStEvnt.
             ---      sam  3. Modified notify msg /cnStEvnt to have infoReq 
                              struct for NTDMS100P also.
             ---      sam  4. Added new IE for cause in Prog mesg.
             ---      sam  5. Modified release , rel complete mesg and rel 
                              event to have cause IE for NTDMS00P.
             ---      sam  6. Modified setup, conEvnt to have facility IE 
                              for NTDMS00P.
             ---      sam  7. Modified conEvnt and setup msg to have 
                              ntDispaly IE for NTDMS100P.
             ---      sam  8. Modified messages/event structures to include 
                              IEs for NTMCI.
             ---      sam  9. Added ces parameter in upper layer primitives.
             ---      sam 10. Modified positioning of INTR6 and NTT IEs in 
                              event structures.
             ---      sam 11. Changed structure names for NttBlkChanId,
                              NI1RedirNmb and Srv.
             ---      sam 12. Changed structure NetFac - netFacSpec is
                              TknStr now - earlier it was TknU8.
             ---      sam 13. Changed IN_MF_MAX_REPELMT to IN_MF_MAX_IE for 
                              all IEs except bearer capability.
             ---      sam 14. Added support for 4 progInds.
             ---      sam 15. Made netFac an array, similar to causeDgn.
             ---      sam 16. Modified facEvnt and facil structures.
             ---      sam 17. Added structures NtOrig, NtDest, NtOpt.
             ---      pk  18. Changed ordef or layer identities and 
                              userinfolyrprot for lyr 1, 2 and 3 in 
                              bearCap structure. 
             ---      sb  19. Text changes
             ---      sam 20. Modified bearCap and llComp structures
                              to support rateMultiplier.

3.9          ---      pk   1. Added structure tscFacility for NTSPRINT.
                           2. Modified structures relCmplt, facil, reg
                              to include TscFacility and Shift for
                              NTSPRINT.
                           3. Modified structures for facEvnt and relEvnt
                              for NTSPRINT.
                      pk   4. Changed the order of layer identities and
                              userinfolyrprot for lyr 1, 2 and 3 in
                              bearCap structure.
                      pk   5. Added additional facility IEs for QSIG in
                              alerting, connect, setup, progress, release
                              disconnect, release complete, facility,
                              conEvnt, discEvnt, cnStEvnt, facEvnt and
                              relEvnt.
                      pk   6. Changed TKNU8 to TKNU32 for notDatStr.
             ---      pk   7. Added prototypes for primitives for PSIF.
             ---      pk   8. Added redirNmb1 in setup and conEvnt 
                              structures.
3.9          ---      pk   9. Changed SuInstId and SpInstId to type 
                              UConnId in the upper interface primitives.
                          10. Provided backward compatibility for upper
                              Interface primitives.
                          11. Changed intId field to U16 in the ChanId 
                              structure.
                          12. Text/ Comment  Changes

3.10         ---      pk   1. Added Origination and Destination IEs for NTMCI 
                              in facil and facEvnt.
                           2. Added Facility IEs for NTMCI in alerting, conn,
                              progress, setup, disc, facil, conEvnt, discEvnt,
                              cnStEvnt, and facEvnt.
                           3. Added Connected Number IE for NT, NTDMS250, and 
                              ATT variants in conn, disc, rel, relCmplt, 
                              notify, discEvnt, cnStEvnt, and relEvnt.
                           4. Added Congestion level IE in staEvnt.
                           5. Changed type defines for IntFlcInd, IntFlcReq.
                           6  Changed input parameters for all upper interface
                              function used for Flow Control.
                              Used staEvnt instead of action.
                           7. Changed events and messages to allow any 
                              parameters for codesets 6 and 7.
                           8. Added facility IE to CALLPROC, SETUP, SETUP ACK
                              messages and ConEvnt structures.
                           9. Removed staEnqEvnt.
           in009.310  cy  10. Added ntMCIOctStr in CnStEvnt structure.
           in021.310  cy  11. Added facilityStr IE in setup and conEvnt 
                              structures.
                          12. Added nwNmb in setup and conEvnt 
                              structures to pass the network number to 
                              the call control.
                          13. Added function propotypes
                              cmIntUnpkElmtFacilityStr and 
                              cmIntPkElmtFacilityStr.
/main/32     ---      cy   1. Updated for new release.
           in016.311  bn   1. Text changes.
           in017.311  bn   1. Text changes.
*********************************************************************91*/
