/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/

/********************************************************************20**

     Name:     isdn network layer

     Type:     C include file

     Desc:     Defines required by the isdn network layer service user.

     File:     int.h

     Sid:      int.h@@/main/25 - Wed May 23 17:06:45 2001

     Prg:      bn

*********************************************************************21*/

#ifndef __INTH__
#define __INTH__


/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.             description
*     --------     ----------------------------------------------
*     1000009     Network Layer - Q.930/Q.931
*
*/

/*
*     This software may be combined with the following TRILLIUM
*     software:
*
*     part no.             description
*     --------     ----------------------------------------------
*     1000009     Network Layer - Q.930/Q.931
*     1000023     Network Layer - X.31
*
*/

#include "cm_q930.h"

/* SHIFT Element */
/* shift codeset values */
#define IN_LS_CDESET0     0x00  /* codeset 0 */
#define IN_LS_CDESET5     0x05  /* codeset 5 */
#define IN_LS_CDESET6     0x06  /* codeset 6 */
#define IN_LS_CDESET7     0x07  /* codeset 7 */

/* locking non-locking shift flags */
#define IN_LS_ON          0x00  /* locking */
#define IN_LS_OFF         0x01  /* non-locking */

/* CAUSE element */
/* location */
#define IN_LOC_USER       0x00  /* user */
#define IN_LOC_PRIVNETLU  0x01  /* private network serving local user */
#define IN_LOC_PUBNETLU   0x02  /* public network serving local user */
#define IN_LOC_TRANNET    0x03  /* transit network */
#define IN_LOC_PUBNETRU   0x04  /* public network serving the remote user */
#define IN_LOC_PRIVNETRU  0x05  /* private network serving the remote user */
#define IN_LOC_INTNET     0x07  /* international network */
#define IN_LOC_NETINTER   0x0a  /* network beyond internetworking point */
#define IN_LOC_NOINFOAV   0x0f  /* no info concerning origin location */

/* recommendation */
#define IN_REC_Q931       0x00  /* CCITT Recommendation Q.931 */
#define IN_REC_X21        0x03  /* CCITT Recommendation X.21 */
#define IN_REC_X25        0x04  /* CCITT Recommendation X.25 */

/* cause value */
#define IN_CCUNALLOC      1     /* unassigned number */
#define IN_CCNORTTOTSFNET 2     /* no route to transit network */
#define IN_CCNORTTODEST   3     /* no route to destination */
#define IN_CCCHANUNACPT   6     /* channel unacceptable */
#define IN_CCCALLAWD      7     /* call awarded and being delivered */
#define IN_CCPRE1DINERR   9     /* prefix 1 dialed in error */
#define IN_CCCALLCLR      16    /* normal call clearing */
#define IN_CCUSRBSY       17    /* user busy */
#define IN_CCNOUSRRSP     18    /* no user response */
#define IN_CCNOANSWR      19    /* no answer (user alerted ) */
#define IN_CCCALLRJT      21    /* call rejected */
#define IN_CCNMBRCHG      22    /* number changed */
#define IN_CCNMBRUNASS    24    /* number unassigned */
#define IN_CCNONSELCLR    26    /* non selected User clearing */
#define IN_CCDESTOUTORD   27    /* destination out of order */
#define IN_CCINVNMBFRM    28    /* invalid number format */
#define IN_CCFACREJ       29    /* facility rejected */
#define IN_CCRSPSTSENQ    30    /* response to STATUS ENQUIRY */
#define IN_CCNORMUNSPEC   31    /* normal unspecified */
#define IN_CCNOCIRCUIT    34    /* no circuit/channel available */
#define IN_CCCLQUEUED     35    /* call queued */
#define IN_CCNETAOL       38    /* network out of order */
#define IN_CCTMPFAIL      41    /* Temporary failure */
#define IN_CCSWTCHCONG    42    /* Switch equipment congestion */
#define IN_CCACCINFDISC   43    /* access info discarded */
#define IN_CCREQUNAVAIL   44    /* requested circuit/channel unavailable */
#define IN_CCRESCUNAVAIL  47    /* resources unavailable, unspecified */
#define IN_CCQOSUNAVAIL   49    /* Quality of Service unavailable */
#define IN_CCFACNOTSUB    50    /* requested facility not subscribed */
#define IN_CCOUTCLSBRRD   52    /* outgoing calls barred */
#define IN_CCINCCALBARD   54    /* incoming calls barred */
#define IN_CCNOTAUTHBCAP  57    /* bearer capability not authorized */
#define IN_CCBCAPUNAVAIL  58    /* bearer capability not available */
#define IN_CCCALRESTRICT  59    /* call restriction */
#define IN_CCTRMCLLRDRRJ  60    /* terminal call redirection rejected */
#define IN_CCUNATHSERV    62    /* unathorized service */
#define IN_CCSERVUNAVAIL  63    /* Service or option unavailable */
#define IN_CCBCAPNOTIMP   65    /* bearer capability not implemented */
#define IN_CCCHANNOTIMP   66    /* channel type not implemented */
#define IN_CCFACNOTIMP    69    /* requested facility not implemented */
#define IN_CCRESTDIG      70    /* only restricted digital bear cap is avail */
#define IN_CCSERVNOTIMP   79    /* service or option not implemented */
#define IN_CCINVCALLREF   81    /* invalid call reference */
#define IN_CCCHANNOTEXST  82    /* channel does not exist */
#define IN_CCINVCALLID    83    /* susp. call exists, call id is invalid */
#define IN_CCCALLIDINUSE  84    /* call identity is in use */
#define IN_CCNOCALLSUSP   85    /* no call suspended */
#define IN_CCCALLCLEAR    86    /* call id'd has been cleared */
#define IN_CCINCOMPDEST   88    /* incompatible destination */
#define IN_CCINVTRNSTNET  91    /* invalid transit network selection */
#define IN_CCINVFACPARM   92    /* invalid facility parameter */
#define IN_CCINVMSG       95    /* invalid message, unspecified */
#define IN_CCINFOELMSSG   96    /* mandatory info element is missing */
#define IN_CCNOMSGTYP     97    /* msg type is non-existent or not
                                   implemented */
#define IN_CCINVMSGTYP    98    /* msg type invalid in call state or not 
                                   implemented */
#define IN_CCNOINFOEL     99    /* info element non-existent or not
                                   implemented */
#define IN_CCINVINFOEL    100   /* invalid info element */
#define IN_CCMSGNOTCMP    101   /* msg type not compatible with call state */
#define IN_CCTIMERECOVR   102   /* recovery on timer expiry */
#define IN_CCMIEINCLGTH   103   /* mssg recvd with mand info elmt of incorrect 
                                length */
#define IN_CCPROTERR      111   /* protocol error, unspecified */
#define IN_CCPROTDISCERR  112   /* protocol discriminator error */
#define IN_CCBEARSRVNA    113   /* bearer service not available */
#define IN_CCETOINFTRIMP  114   /* end-to-end info transfer impossible */
#define IN_CCENTCONVMDE   126   /* entering conversation mode */
#define IN_CCINTRWRK      127   /* interworkingpecified */

/* note 12 coding */
#define IN_N12_UNKNOWN    0x80  /* unknown condition */
#define IN_N12_PERMANENT  0x81  /* permanent condition */
#define IN_N12_TRANSIENT  0x82  /* transient condition */

/* note 3 coding */
#define IN_N03_INFOCAP    0x31  /* information transfer capability */
#define IN_N03_INFOMODE   0x32  /* information transfer mode */
#define IN_N03_INFORATE0  0x33  /* information transfer rate */
#define IN_N03_STRUCT     0x34  /* structure */
#define IN_N03_CFG        0x35  /* configuration */
#define IN_N03_ESTAB      0x36  /* establishment */
#define IN_N03_SYM        0x37  /* symmetry */
#define IN_N03_INFORATE1  0x38  /* information transfer rate */
#define IN_N03_LYRID      0x39  /* layer identification */

/* CHANNEL ID element */
/* interface identifier present */
#define IN_IIP_IMPLICIT   0x00  /* interface implicitly identified */
#define IN_IIP_EXPLICIT   0x01  /* interface explicitly identified */

/* interface type */
#define IN_IT_BASIC       0x00  /* basic rate rnterface */
#define IN_IT_OTHER       0x01  /* other interface (e.g. primary rate) */

/* preferred/exclusive */
#define IN_PE_PREFER      0x00  /* indicated channel is preferred */
#define IN_PE_EXCLSVE     0x01  /* exclusivie, only indicated channel is
                                   acptble */
/* D channel selection indicator */
#define IN_DSI_NOTDCHAN   0x00  /* channel identified is not d channel */
#define IN_DSI_DCHAN      0x01  /* channel identified is d channel */

/* information channel selection */
#define IN_ICS_NOCHAN     0x00  /* no channel */
#define IN_ICS_B1CHAN     0x01  /* B1 channel */
#define IN_ICS_B2CHAN     0x02  /* B2 channel */
#define IN_ICS_ANYCHN     0x03  /* any channel */

/* number/map */
#define IN_NM_CHNNMB      0x00  /* channel is indicated by a number */
#define IN_NM_CHNMAP      0x01  /* channel is indicated by a slot map */

/* channel type/map element type */
#define IN_CMT_BCHAN      0x03  /* B channel units */
#define IN_CMT_H0CHAN     0x06  /* H0 channel units */
#define IN_CMT_H11CHAN    0x08  /* H11 channel units */
#define IN_CMT_H12CHAN    0x09  /* H12 channel units */
#define IN_CMT_ATMVCC     0x0b  /* ATM VCC units */

/* HIGH LAYER COMPATIBILITY element */

/* extended high layer characteristics */
#define IN_XHLCI_TEL      0x01  /* Telephony - Recommendation G.711 */
#define IN_XHLCI_FAXG4    0x04  /* Facsimile Group 4 - Recommendation T.62 */
#define IN_XHLCI_DAPFAXG4 0x21  /* Doc App Profile for Facsimile Group 4
                                   Recommendation T.503 */
#define IN_XHLCI_DAPMIXED 0x24  /* Doc App Profile for Facsimile Group 4
                                   Recommendation T.501 */
#define IN_XHLCI_DAPPROC  0x28  /* Doc App Profile for Facsimile Group 4
                                   Recommendation T.502 */
#define IN_XHLCI_TELETEX  0x31  /* Teletex - Recommendation T.62/T.70 */
#define IN_XHLCI_DAPVIDEO 0x32  /* Doc App Profile for Facsimile Group 4
                                   Recommendation T.503 */
#define IN_XHLCI_TELEX    0x35  /* Telex */
#define IN_XHLCI_MHS      0x38  /* Message Handling System
                                   Recommendation X.400 */
#define IN_XHLCI_OSIAPP   0x41  /* OSI Application - Recommendation X.200 */
#define IN_XHLCI_MAINT    0x5e  /* Maintenance */
#define IN_XHLCI_MNGMT    0x5f  /* Management */
#define IN_XHLCI_VIDTEL   0x60  /* Videotelephony (F.xyz and AV.242) */
#define IN_XHLCI_RESERVE  0xff  /* Reserved */

/* PROGRESS INDICATOR element */
/* progress description */
#define IN_PD_NOTETEISDN  0x01  /* call is not end to end isdn */
#define IN_PD_DSTNOTISDN  0x02  /* destination address is not isdn */
#define IN_PD_ORGNOTISDN  0x03  /* orgination address is not isdn */
#define IN_PD_CALLRET     0x04  /* call has returned to isdn */
#define IN_PD_IBAVAIL     0x08  /* inband information now available */
#define IN_PD_DELRESP     0x0a  /* delayed response at called interface */

/* repeat indication */
#define IN_RI_PRIOR       0x02  /* prioritized list for selecting
                                   possibility */

/* RESTART INDICATOR element */
/* restart class */
#define IN_CL_INDCHAN     0x00  /* indicated channels */
#define IN_CL_SNGINT      0x06  /* single interface */
#define IN_CL_ALLINT      0x07  /* all interfaces */
#define IN_RSTSND         0x08  /* Restart message Sent event */

/* SEGMENT Element */
/* first segment indicator */
#define IN_FSI_SUBSEG     0x00  /* subsequent segment to first segment */
#define IN_FSI_FRSTSEG    0x01  /* first segment of segmented message */

/* CALLING/CONNECTED PARTY NUMBER  element */
/* Transit Network and Network specific facilities Elements */

/* type of network identification */
#define IN_TNID_USER      0x00  /* user specified */
#define IN_TNID_NAT       0x02  /* national */
#define IN_TNID_INTER     0x03  /* international */

/* network identification plan */
#define IN_NIDPLN_UNK     0x00  /* unknown */
#define IN_NIDPLN_CIC     0x01  /* carrier identification code */
#define IN_NIDPLN_USRSPEC 0x02  /* user specified identification code */
#define IN_NIDPLN_DNIC    0x03  /* data network identification code, CCITT */

/* defines for primitives exchanged between Q.931 and the upper layer */
#define NMB_MSG            0x17   /* number of messages */
#ifdef Q932
#define NMB_ALLMSG         0x27   /* number of messages */
#else /* Q932 */
#define NMB_ALLMSG         0x20   /* number of messages */
#endif /* Q932 */

#define IN_NMB_PRIM           14     /* number of primitives */

#define IN_PM_CONREQ          (NMB_ALLMSG + 0)  /* Connect Request */
#define IN_PM_CONRSP          (NMB_ALLMSG + 1)  /* Connect Response */
#define IN_PM_CNSTREQ         (NMB_ALLMSG + 2)  /* Connection Status Request */
#define IN_PM_DISCREQ         (NMB_ALLMSG + 3)  /* Disconnect Request */
#define IN_PM_RELREQ          (NMB_ALLMSG + 4)  /* Release Request */
#define IN_PM_DATREQ          (NMB_ALLMSG + 5)  /* Data Request */
#define IN_PM_SSHLREQ         (NMB_ALLMSG + 6)  /* Suspend/Halt Request */
#define IN_PM_SSHLRSP         (NMB_ALLMSG + 7)  /* Suspend/Halt Response */
#define IN_PM_RMRTREQ         (NMB_ALLMSG + 8)  /* Resume/Retrieve Request */
#define IN_PM_RMRTRSP         (NMB_ALLMSG + 9)  /* Resume/Retrieve Response */
#define IN_PM_FLCREQ          (NMB_ALLMSG + 10) /* Flow Control Request */
#define IN_PM_STATREQ         (NMB_ALLMSG + 11) /* Status Request */
#define IN_PM_STATRSP         (NMB_ALLMSG + 12) /* Status Response */
#define IN_PM_SRV             (NMB_ALLMSG + 13) /* Service */
#define IN_PM_RST             (NMB_ALLMSG + 14) /* Restart */
#define IN_PM_FAC             (NMB_ALLMSG + 15) /* Facility */

/* events for upper interface primitives */

#define EVTINTBNDREQ      0x04  /* Bind request */
#define EVTINTUBNDREQ     0x08  /* Unbind request */

#define EVTINTCONREQ      0x0C  /* Connct request */      
#define EVTINTCONCFM      0x0D  /* Connct confirm */      
#define EVTINTCONRSP      0x0F  /* Connect response */      
#define EVTINTCONIND      0x0E  /* Connect indication */

#define EVTINTDISCREQ     0x10  /* Disconnect request */
#define EVTINTDISCIND     0x12  /* Disconnect indication */
      
#define EVTINTCNSTREQ     0x58  /* Connection progress status request */      
#define EVTINTCNSTIND     0x5A  /* Connection progress status indication */
      
#define EVTINTDATREQ      0x14  /* Data request */     
#define EVTINTDATIND      0x16  /* Data indication */  
   
#define EVTINTFLCREQ      0x28  /* Flow control request */
#define EVTINTFLCIND      0x2A  /* Flow control indication */

#define EVTINTRSTREQ      0x2C  /* Reset request */
#define EVTINTRSTCFM      0x2D  /* Reset confirmation */
#define EVTINTRSTIND      0x2E  /* Restart indication */

#define EVTINTRELREQ      0x5C  /* Connection release request */    
#define EVTINTRELRSP      0x5F  /* Connection release response */   
#define EVTINTRELIND      0x5E  /* Connection release indication */ 
#define EVTINTRELCFM      0x5D  /* Connection release confirmation */      

#define EVTINTSSHLREQ     0x60  /* Call suspend/halt request */      
#define EVTINTSSHLCFM     0x61  /* Call suspend/halt confirmation */      
#define EVTINTSSHLIND     0x62  /* Call suspend/halt indication */      
#define EVTINTSSHLRSP     0x63  /* Call suspend/halt response */      

#define EVTINTRMRTREQ     0x64  /* Call resume/retrieve request */      
#define EVTINTRMRTCFM     0x65  /* Call resume/retrieve confirm */      
#define EVTINTRMRTIND     0x66  /* Call resume/retrieve indication */    
#define EVTINTRMRTRSP     0x67  /* Call resume/retrieve response */      
  
#define EVTINTFACREQ      0x68  /* Call facility request */     
#define EVTINTFACIND      0x6A  /* Call facility indication */     
     
#define EVTINTSTAREQ      0x6c  /* Status request */     
#define EVTINTSTACFM      0x6d  /* Status Confirm */  

#define EVTINTSRVREQ      0x70  /* Service request */
#define EVTINTSRVCFM      0x71  /* Service confirmation */
#define EVTINTSRVIND      0x72  /* Service indication */
#define EVTINTSETUPCOMP   0x73  /* Setup Complete Request */

#define EVTINTBNDCFM      0x74  /* Bind Confirm */

#define EVTINTRSCSTAIND   0x75  /* Resource Status Indication */

/* reason for UbndReq */
#define IN_N_UBNDREQ      1    /* Requested */

/* service access point ids for BndReq */
#define Q_930          0    /* Q.930 sapi */
#define X_25           16   /* x.25 sapi */
#define MNGMT          63   /* management sapi */

/* value for dChan */
#define IN_DCH_INSIGNIF   0xff  /* channel insignificant */

/* event type for restart confirm */
#define IN_LNK_UP          0      /* link is up */
#define IN_LNK_DWN         1      /* link is down */
#define IN_INDCHAN         2      /* b channel */
#define IN_LNK_DWN_DM_RLS  3      /* for NFAS with service procedures */
#define IN_SWCHD_BU_DCHAN  4      /* for NFAS switchover to backup 
                                  dchannel occured */
/* action for FlcReq and FlcInd */
#define IN_N_STARTFLC     0     /* Start Flow Control */
#define IN_N_ENDFLC       1     /* End Flow Control */

/* action for SsHlReq  */
#define IN_N_SUSPEND      0     /* Suspend */
#define IN_N_HOLD         1     /* Hold */

/* action for RmRtReq  */
#define IN_N_RESUME       2     /* Resume */
#define IN_N_RETRIEVE     3     /* Retrieve */

/* defines for request type for InUiIntRstReq */
#define IN_SND_RST        0     /* send restart */
#define IN_REMOVE         1     /* remove from service */
#define IN_RESTORE        2     /* restore service */

#define IN_MF_MAX_REPELMT 2     /* maximum repeated elements */
#define IN_MF_MAX_IE      4     /* maximum repeated IEs other than BearCap */
#define IN_MF_MAX_FACIE   5     /* maximum repeated facility IEs */

#define IN_MAX_DISPLAY    3     /* number dislpay IE could appear in
                                NT setup and notify messages */
/* configuration */
#define IN_C_PTPT         0x00  /* point to point */

/* user rate */
#define IN_UR_EINI460     0x00  /* determined by E bits in I.460 */
#define IN_UR_600         0x01  /* 0.6 kbits, V.6 and X.1 */
#define IN_UR_1200        0x02  /* 1.2 kbits, V.6 */
#define IN_UR_2400        0x03 /* 2.4 kbits, V.6 and X.1 */
#define IN_UR_3600        0x04  /* 3.6 kbits, V.6 */
#define IN_UR_4800        0x05  /* 4.8 kbits, V.6 and X.1 */
#define IN_UR_7200        0x06  /* 7.2 kbits, V.6 */
#define IN_UR_8000        0x07  /* 8.0 kbits, I.460 */
#define IN_UR_9600        0x08  /* 9.6 kbits, V.6 and X.1 */
#define IN_UR_14400       0x09  /* 14.4 kbits, V.6 */
#define IN_UR_16000       0x0a  /* 16 kbits, I.460 */
#define IN_UR_19200       0x0b  /* 19.2 kbits, V.6 */
#define IN_UR_32000       0x0c  /* 32 kbits, I.460 */
#define IN_UR_48000       0x0e  /* 48 kbits, V.6 and X.1 */
#define IN_UR_56000       0x0f  /* 56 kbits, V.6 */
#define IN_UR_64000       0x10  /* 64 kbits, X.1 */
#define IN_UR_134         0x15  /* .1345 kbits, X.1 */
#define IN_UR_100         0x16  /* .100 kbits, X.1 */
#define IN_UR_75_1200     0x17  /* .075/1200 kbits, V.6 and X.1 */
#define IN_UR_1200_75     0x18  /* 1200/.075 kbits, V.6 and X.1 */
#define IN_UR_50          0x19  /* .050 kbits, V.6 and X.1 */
#define IN_UR_75          0x1a  /* .075 kbits, V.6 and X.1 */
#define IN_UR_110         0x1b  /* .110 kbits, V.6 and X.1 */
#define IN_UR_150         0x1c  /* .150 kbits, V.6 and X.1 */
#define IN_UR_200         0x1d  /* .200 kbits, V.6 and X.1 */
#define IN_UR_300         0x1e  /* .300 kbits, V.6 and X.1 */
#define IN_UR_12000       0x1f  /* 12 kbits, V.6 */

/* network independent clock on transmission */
#define IN_NICTX_NOTREQ   0x00  /* not required to send with nic */
#define IN_NICTX_REQ      0x01  /* required to send with nic */

/* network independent clock on reception */
#define IN_NICRX_NOTACC   0x00  /* cannot accept data with nic */
#define IN_NICRX_ACC      0x01  /* can accept data with nic */

/* flow control on transmission */
#define IN_FLCTX_NOTREQ   0x00  /* not required to send with flow control */
#define IN_FLCTX_REQ      0x01  /* required to send with flow control */

/* flow control on reception */
#define IN_FLCRX_NOTACC   0x00  /* cannot accept data with flow control */
#define IN_FLCRX_ACC      0x01  /* can accept data with flow control */

/* rate adaption header/not header */
#define IN_RAH_NOTINC     0x00  /* not included */
#define IN_RAH_INC        0x01  /* included */

/* QSIG Information Transfer types. 
   These are not part of the standard.  These constants are used
   for layer 4 <-> layer 3 communication.   
*/
#define IN_QSIGGFT_CALLREL  0x01   /* QSIG Call Related info transfer */
#define IN_QSIGGFT_CONLESS  0x02   /* QSIG Connectionless info transfer */
#define IN_QSIGGFT_CONINDP  0x03   /* QSIG Connection independent info
                                      transfer */
/*
 * QSIG Protocol Profiles.
 */
#define IN_QSIGGFT_PPROF_ROSE 0x11           /* QSIG ROSE */
#define IN_QSIGGFT_PPROF_ACSE 0x13           /* QSIG ACSE */
#define IN_QSIGGFT_PPROF_NFE  0x1f           /* QSIG Network Facility Extension */

/* authority and format identifier */
#define IN_AFI_BCD        0x0   /* BCD format for X.121 and E.164 */
#define IN_AFI_ASCII      0x1   /* ASCII format for ISO8348 */
#define IN_AFI_X121A      0x36  /* BCD format for X.121 */
#define IN_AFI_X121B      0x37  /* BCD format for X.121 */
#define IN_AFI_X121C      0x52  /* BCD format for X.121 */
#define IN_AFI_X121D      0x53  /* BCD format for X.121 */
#define IN_AFI_E164A      0x44  /* BCD format for E.164 */
#define IN_AFI_E164B      0x45  /* BCD format for E.164 */
#define IN_AFI_E164C      0x58  /* BCD format for E.164 */
#define IN_AFI_E164D      0x59  /* BCD format for E.164 */
#define IN_AFI_ISO1       0x48  /* ASCII format for ISO8348 */
#define IN_AFI_ISO2       0x49  /* ASCII format for ISO8348 */
#define IN_AFI_ISO3       0x50  /* ASCII format for ISO8348 */
#define IN_AFI_ISO4       0x51  /* ASCII format for ISO8348 */

/* NT Network specific cause value */
#define IN_CCPREF1NOTDIAL 4     /* prefix 1 not dialed */
#define IN_CCCALLPROCEED  8     /* call is proceeding */
#define IN_CCBEARCAPINCMP 51    /* bearer capabil incompat with requested */
#define IN_CCSERVOPRVIOL  53    /* service operation violated */
#define IN_CCDESTADDRMSSG 90    /* destination address missing, direct call
                                   not subscribed */
#ifdef INTR6
/* INTR6 Network specific cause value */
#define IN_CCINVCLLREF      1   /* invalid call reference */
#define IN_CCBRSRVNIMP      3   /* no application has been made for spec
                                    servise*/
#define IN_CCCALIDNONEX     7   /* inknown call identity */
#define IN_CCCALIDINUSE     8   /* call identity already assigned */
#define IN_CCNOCHANAVAL    10   /* no useful channel available */
#define IN_CCREQFACNTIML   16   /* specified facility code is unknown */
#define IN_CCREQFACNTSBD   17   /* requested facility not subscribed */
#define IN_CCOUTCALBARRD   32   /* outgoing calls barred */
#define IN_CCUSERBUSY      33   /* user busy */
#define IN_CCNEGCUGCOMP    34   /* negative CUG comparison */
#define IN_CCNOTEXSTGCUG   35   /* nonexistent CUG */
#define IN_CCCOMSPLNTRERM  37   /* comm as semi-perm link not permitted 
                                    (RFNR check negative) */
#define IN_CCDSTNOTOBT     53   /* incorrect destination address */
#define IN_CCNUMBRCHNGD    56   /* number changed */
#define IN_CCOUTORDER      57   /* remote TE not ready */
#define IN_CCNOUSRRESP     58   /* no user responding */
#define IN_CCUSRBUSY       59   /* user busy */
#define IN_CCINCCLSBRRD    61   /* incoming calls barred */
#define IN_CCCALLREJ       62   /* call actively rejected */
#define IN_CCNETWCONGST    89   /* network congestion */
#define IN_CCRMTUSRINIT    90   /* rejected by remote user */
#define IN_CCLOCLPROCERR  112   /* local procedure error */ 
#define IN_CCRMTEPROCERR  113   /* remote procedure error */
#define IN_CCRMTEUSRSUSP  114   /* remote user suspended */
#define IN_CCRMTEUSRRSMD  115   /* remote user resumed */
#define IN_CCUSRINFODSCL  127   /* user info message rejected locally */
#endif /* INTR6 */

#define IN_CCNI1VACCODE    4      /* National Specific - Vacant Code */
#define IN_CCNI1PRE0DINERR 8      /* Nat. Prefix 0 dialed in error */
#define IN_CCNI1PRE1DINERR 9      /* Nat. Prefix 1 dialed in error */
#define IN_CCNI1PRE1NOTD   10     /* Nat. Prefix 1 not dialed */
#define IN_CCNI1EXCDIGPROC 11     /* Nat. Excess digits call proceeding */
#define IN_CCNI1CALLPROC   8      /* Network Specific - Call proceeding */
#define IN_CCNI1SERVDEN    13     /* Net. Service Denied */
#define IN_CCNI1SPECINAN   28     /* Net. Special Intercept Announcement */
#define IN_CCNI1SPECINANUC 29     /* Net. Spec. Intercept Ann. Undefined
                                     code */
#define IN_CCNI1SPECINANNU 30     /* Net. Spec. Intercept Ann. Number
                                     Unassigned */
#define IN_CCNI1CALLINCOMP 51     /* Net. Call type incompatable with
                                     service */
#define IN_CCNI1SERVOPVIOL 53     /* Net. Service operation violated */
#define IN_CCNI1PROTERRTHR 101    /* Net. Protocol Error Threshold Exceeded */

#ifdef ETSI
/* etsi specific cause code values */
#define IN_CCNOCUG        88    /* non-existent closed user group */
#define IN_CCNOTMEMCUG    89    /* called user member of closed user grp */
#define IN_CCMEMCUG       90    /* called user member of closed user grp */
#endif /* ETSI */

/* congestion level */
#define IN_CL_RR          0x00  /* receiver ready */
#define IN_CL_RNR         0x0f  /* receiver not ready */

/* interpreter */
#define IN_IN_SELECT      0x00  /* select identified terminal */
#define IN_IN_EXCLUDE     0x01  /* select all but identified terminal */

/* status indicator */
#define IN_SI_IDLE        0x00  /* feature is in idle state */
#define IN_SI_ACTV        0x01  /* feature is in active state */
#define IN_SI_PROMPT      0x02  /* prompt for user imput */
#define IN_SI_PENDING     0x03  /* feature is in pending */

/* type of network identification */
#define IN_TNID_USER      0x00  /* user specified */
#define IN_TNID_NAT       0x02  /* national */
#define IN_TNID_INTER     0x03  /* international */

/* network identification plan */
#define IN_NIDPLN_UNK     0x00  /* unknown */
#define IN_NIDPLN_CIC     0x01  /* carrier identification code */
#define IN_NIDPLN_DNIC    0x03  /* data network identification code, CCITT */
                             /* Recommendation X.121 */
/* facility code */
#define IN_SID_PREF       0x01  /* SID preffered */
#define IN_SDN            0x01  /* */
#define IN_BN_PREF        0x02  /* BN preffered */
#define IN_SID_ONLY       0x03  /* SID only */
#define IN_BN_ONLY        0x04  /* BN only */
#define IN_ACCUNET        0x06  /* ACCUNET SDS */
#define IN_LONG_DIS       0x07  /* long distance */
#define IN_INT_800        0x08  /* international 800 */
#define IN_CA_TSC         0x09  /* CA TSC */
#define IN_ATT_MULTIQ     0x10  /* ATT MultiQuest */
  
/* binary facility coding values for NT */
#define IN_BF_PVT         0x01  /* Private */
#define IN_BF_INWATS      0x02  /* Inwats */
#define IN_BF_OUTWATS     0x03  /* Outwats */
#define IN_BF_FX          0x04  /* Foreign Exchange */
#define IN_BF_TIE         0x05  /* Tie Trunk */

/* facility coding values for NTNI */
#define IN_FC_INWATS      0x11  /* Inwats */
#define IN_FC_OUTWATS     0x12  /* Outwats */
#define IN_FC_FX          0x13  /* Foreign Exchange */
#define IN_FC_TIE         0x14  /* Tie Trunk */
#define IN_FC_HM          0x15  /* Hotel Motel */
#define IN_FC_SCOCS       0x16  /* SCOCS */

/* NTNI Protocol Profiles.  */
#define IN_NTNIGFT_PPROF_ROSE 0x11 /* ROSE */
#define IN_NTNIGFT_PPROF_NFE  0x1f /* Networking Extension */

/* Display type for Display IE for NTDMS100P */
#define IN_DT_CGPTYNAME      0x01  /* Calling Party Name NTDMS100P */
#define IN_DT_CNPTYNAME      0x02  /* Connected Party Name NTDMS100P */
#define IN_DT_ORIGCDPTYNAME  0x03  /* Original Called Party name NTDMS100P */

/* Display type for Display IE for NTMCI/NTDMS250 */
#define IN_DT_UNKNOWN        0x00  /* Unknown */
#define IN_DT_ORIGCDPTYNMB   0x01  /* Original Called Party Number */
#define IN_DT_CGPTYNAME2     0x02  /* Calling Party Name - NTMCI */
#define IN_DT_CDPTYNAME      0x03  /* Calling Party Name - NTMCI */
#define IN_DT_REDIRPTYNAME   0x04  /* Redirecting Party Name */
#define IN_DT_REDIRNPTYNAME  0x05  /* Redirection Party Name */
#define IN_DT_CNPTYNAME2     0x06  /* Connected Party Name NTMCI */
#define IN_DT_MSGRET         0x07  /* Message Retreival */
#define IN_DT_MISCDISPINFO   0x08  /* Miscellaneous Display Info. */
#define IN_DT_ELECDIARY      0x09  /* Electronic Diary */

/* Associated Information for Display IE for NTDMS100P & NTMCI */
#define IN_AI_UNDEFINED    0x00   /* Undefined */
#define IN_AI_REQUESTED    0x01   /* Requested */
#define IN_AI_NOTREQUESTED 0x02   /* Not Requested */
#define IN_AI_INCLUDED     0x03   /* Included */
#define IN_AI_NOTINCLUDED  0x04   /* Not Included */
#define IN_AI_INFOUNAVAIL  0x05   /* Information Unavailable */
#define IN_AI_DENIED       0x06   /* Denied */

/* feature or service */
#define FEATURE        0x00  /* feature */
#define SERVICE        0x01  /* service */

/* expansion bit */
#define IN_EXPBIT1        0x01   /* coding value of facility in fllwng 6
                                    bits */
/* parametrized or binary */
#define IN_PARAM          0x00  /* parametrized */
#define IN_BINARY         0x01  /* binary */

/* notification indicator */
#define IN_NI_USRSUSP     0x00  /* user suspended */
#define IN_NI_USRRESM     0x01  /* user resumed */
#define IN_NI_BEARCHG     0x02  /* bearer service change */
#define IN_NI_DISCNOTEXT  0x03  /* discriminator for notification extension */
#define IN_NI_STRTDIAL    0x0b  /* start dial */
#define IN_NI_TOLLDVRSN   0x0c  /* toll diversion */
#define IN_NI_CNDLPLSDET  0x0d  /* connect dial pulse detector */
#define IN_NI_DDLPLSDET   0x0e  /* disconnect dial pulse detector */
#define IN_NI_SLNTINTRVL  0x0f  /* silent interval */
#define IN_NI_TNEGCNCHK   0x13  /* timed negative coin check */
#define IN_NI_TPOSCNCHK   0x14  /* timed positive coin check */
#define IN_NI_TPOSCNCTL   0x15  /* timed positive coin control */
#define IN_NI_TNEGCNCTL   0x16  /* timed negative coin control */
#define IN_NI_COINGRND    0x17  /* coin ground */
#define IN_NI_NOCOINGRND  0x18  /* no coin ground */
#define IN_NI_CONTRLLR    0x20  /* conncted via conference controller */
#define IN_NI_CONFREE     0x21  /* conncted via conference conferee */
#define IN_NI_TWOPTYCAL   0x22  /* two party call */
#define IN_NI_CONFASREL   0x23  /* conference facility released */
#define IN_NI_CONECB      0x24  /* connected to emergency service bureau */
#define IN_NI_CONATTCON   0x25  /* connected to attendant console */
#define IN_NI_REPTYDISC   0x26  /* remote party disconnected */
#define IN_NI_BRIDGCALL   0x27  /* bridged call */
#define IN_NI_CLNOBRIDG   0x28  /* call no longer bridged */
#define IN_NI_RTHLDCALL   0x29  /* retrieve held call */
#define IN_NI_DISATTCON   0x2a  /* no longer connected to attendant console */
#define IN_NI_CALLDIVRT   0x2c  /* call diverted */
#define IN_NI_CALLWAIT    0x60  /* call waiting */
#define IN_NI_CALINEVT    0x71  /* call information/event */
#define IN_NI_USRBRIDGON  0x75  /* user bridged onto call */
#define IN_NI_ABCMONDISC  0x76  /* ABC monitoring discontinued */
#define IN_NI_CALHLD      0x77  /* call on hold */
#define IN_NI_MONUSRIDLE  0x78  /* monitored user idle */
#define IN_NI_REMHLD      0x79  /* remote hold */
#define IN_NI_REMHLDREL   0x7a  /* remote hold released */
#define IN_NI_CALLFWDED   0x7b  /* call is forwarded */
#define IN_NI_PRVENB      0x7c  /* privacy enabled */
#define IN_NI_PRVDSB      0x7d  /* privacy disabled */
#define IN_NI_CALRTHL     0x7e  /* call retrieved from hold */
#if (ISDN_303TMC || ISDN_303CSC)
#define IN_NI_TIPPTYTST   0x25  /* tip party test */
#define IN_NI_TIPGRND     0x26  /* tip party ground */
#define IN_NI_NOTIPGRND   0x27  /* no tip party ground */
#endif /* ISDN_303TMC || ISDN_303CSC */
 
#ifdef NTNI
#define IN_NI_ASN         0x40 /* ASN.1 for ISO */
#endif /* NTNI */

#ifdef QSIG
#define IN_PD_INTWPUBNET  0x10  /* interworking with public network */
#define IN_PD_ITWUSRLSIG  0x11  /* interworking with  network unable to
                                     supply a release signal */
#define IN_PD_ITWUSRLBAN  0x12  /* interworking with  network unable to
                                     supply a release signal before answer */
#define IN_PD_ITWUSRLAAN  0x13  /* interworking with  network unable to
                                     supply a release signal after answer */
#define IN_PD_INTWPRVNET  0x14  /* interworking with another private
                                     network */
#endif /* QSIG */

/* signal value */
#define IN_SIG_DIAL       0x00  /* dial tone on */
#define IN_SIG_RNGBCK     0x01  /* ring back tone on */
#define IN_SIG_INTER      0x02  /* intercept tone on */
#define IN_SIG_NETCONG    0x03  /* network congestion tone on */
#define IN_SIG_BUSY       0x04  /* busy tone on */
#define IN_SIG_CONFIRM    0x05  /* confirm tone on */
#define IN_SIG_ANSWER     0x06  /* answer tone on */
#define IN_SIG_CALLWAIT   0x07  /* call waiting tone on */
#define IN_SIG_OFFHOOK    0x08  /* off hook warning tone on */
#define IN_SIG_CSTMTON    0x09  /* Custom tone on */
#define IN_SIG_BSVERTON   0x0b  /* busy verify tone on */
#define IN_SIG_ERRTON     0x0c  /* error tone on */
#define IN_SIG_STDLTON    0x0d  /* stutter dial tone on */
#define IN_SIG_RCLDLTNON  0x11  /* recall dial tone on */
#define IN_SIG_EXPRTTON   0xfd  /* stutter dial tone on */
#define IN_SIG_TONESOFF   0x3f  /* tones off */
#define IN_SIG_ALERT0     0x40  /* alerting on - pattern 0 */
#define IN_SIG_ALERT1     0x41  /* alerting on - pattern 1 */
#define IN_SIG_ALERT2     0x42  /* alerting on - pattern 2 */
#define IN_SIG_ALERT3     0x43  /* alerting on - pattern 3 */
#define IN_SIG_ALERT4     0x44  /* alerting on - pattern 4 */
#define IN_SIG_ALERT5     0x45  /* alerting on - pattern 5 */
#define IN_SIG_ALERT6     0x46  /* alerting on - pattern 6 */
#define IN_SIG_ALERT7     0x47  /* alerting on - pattern 7 */
#define IN_SIG_ALERTT     0x48  /* alerting on - t ringing */
#define IN_SIG_ALERTR     0x49  /* alerting on - r ringing */
#define IN_SIG_ALERTTT    0x4a  /* alerting on - t ringing */
#define IN_SIG_ALERTOFF   0x4f  /* alerting off */
#ifdef BC303CSC
#define IN_SIG_WINKSTRT   0x53  /* wink start */
#define IN_SIG_IMMDIAL    0x54  /* immediate dial */
#define IN_SIG_DELDIAL    0x55  /* delay dial */
#endif /* BC303CSC */ 

#define IN_SIG_RECDIALTN  0x11  /* nt recall dial tone on */
#define IN_SIG_BARGINTON  0x12  /* barge in tone */
#define IN_SIG_INCADDTON  0xfa  /* incoming additional call tone */
#define IN_SIG_PRIADDTON  0xfb  /* priority additional call tone */

/* protocol discriminator */
#define PD_USER        0x00  /* user specific */
#define PD_OSIHL       0x01  /* osi high layer */
#define PD_X244        0x02  /* CCITT Recommendation X.244 */
#define PD_MNGMT       0x03  /* system management convergence */
#define PD_IA5         0x04  /* IA5 characters */
#define PD_V120        0x07  /* CCITT Recommendation V.120 rate adaption */
#define PD_Q931        0x08  /* CCITT Recommendation Q.931 */
#define PD_N0          0x40  /* N0 Recommendation 1 - TR6 */
#define PD_N1          0x41  /* N1 Recommendation 1 - TR6 */
#define PD_BCMNGT      0x43  /* Bellcore management */
#define PD_BC303       0x4f  /* BC Recommendation TR - TSY 303 */

/* protocol discriminator */
#define VPD_NT2        0x40  /* NT2 - NT2 facilities */
#define VPD_MINMSG     0x41  /* minimessage handling service */
#define VPD_X208       0x05  /* X.208/X.209 coded user info */
#define VPD_USERSPEC   0x00  /* User specific protocol */
#define VPD_OSIHLP     0x01  /* OSI High Layer Protocols */
#define VPD_X244       0x02  /* CCITT X.244 */
#define VPD_SMCONV     0x03  /* Reserved for system management convergence */
#define VPD_IA5        0x04  /* IA5 characters */
#define VPD_V120       0x07  /* CCITT V.120 */
#define VPD_Q931       0x08  /* Q.931 (I.451) user-net call cntl messages */
#define VPD_T1607      0x08  /* ANSI T1.607 user-net call cntl messages */

/* service discriminator */
#define IN_SD_SUPAPP      0x11  /* supplementary service applications */
#define IN_SD_TCAP        0x12  /* supplementary service - TCAP */

/* service indentifier */
#define IN_SI_RLT         0x3e  /* release link trunk */
#define IN_SI_SR          0x04  /* Service Rewrite */
#define IN_SI_NMS         0x70  /* network message service */
#define IN_SI_NACD        0x7e  /* network automatic call distribution */
#define IN_SI_NRAG        0x7f  /* network ring again */

#ifdef ISDN_NTSPRINT
#define IN_CNTRL_INVOKE   0x01  /* Control Type - Invoke */
#define IN_CNTRL_RETRSLT  0x02  /* Control Type - Return Result */
#define IN_CNTRL_RETERR   0x03  /* Control Type - Return Error */
#define IN_CNTRL_INVKLST  0x06  /* Control Type - Invoke Last*/
#endif /* ISDN_NTSPRINT */

/* capability description */
#define IN_CDSC_NATFMDE   0x0   /* terminal or NT2 in national funct mode */
#define IN_CDSC_STMLS     0x02  /* stimulus */

/* indication type */
#define IN_INDTP_TOTCHG   0x02  /* total charge */

/* facility class */
#define IN_FC_CONSPEC     0x02  /* context specific */

/* form */
#define IN_FF_CONSTRUCT   0x01  /* constructor */

/* component tag */
#define IN_CT_INVOKE      0x01  /* invoke */
#define IN_CT_RETRSLT     0x02  /* return result */
#define IN_CT_RETERR      0x03  /* return error */
#define IN_CT_REJECT      0x04  /* return reject */

/* length format */
#define IN_LF_COMPONE     0x00  /* length of component field is one octet */

/* information specific */
#define IN_IS_DIALNMBR    0x00  /* dialing number */
#define IN_IS_CGNMBR      0x01  /* calling number */
#define IN_IS_CONNMBR     0x02  /* connected number */
#define IN_IS_REDGNMBR    0x10  /* redirecting number */
#define IN_IS_REDNNMBR    0x11  /* redirection number */
#define IN_IS_REDGNMBRWI  0x12  /* redirecting number without indication */
#define IN_IS_REDNNMBRWI  0x13  /* redirection number without indication */
#define IN_IS_INFODEND    0x30  /* information denied */
#define IN_IS_INFONOAV    0x31  /* information not available */

/* switchhook value */
#define IN_SWH_ONHOOK     0x00  /* onhook */
#define IN_SWH_OFFHOOK    0x01  /* off hook */

/* throughput class */
#define IN_TC_75          0x03  /* .075 kbits */
#define IN_TC_150         0x04  /* .150 kbits */
#define IN_TC_300         0x05  /* .300 kbits */
#define IN_TC_600         0x06  /* .600 kbits */
#define IN_TC_1200        0x07  /* 1.2 kbits */
#define IN_TC_2400        0x08  /* 2.4 kbits */
#define IN_TC_4800        0x09  /* 4.8 kbits */
#define IN_TC_9600        0x0a  /* 9.6 kbits */
#define IN_TC_19200       0x0b  /* 19.2 kbits */
#define IN_TC_48000       0x0c  /* 48 kbits */

/* fast select */
#define IN_FS_NOTREQ0     0x00  /* fast select not requested */
#define IN_FS_NOTREQ1     0x01  /* fast select not requested */
#define IN_FS_REQNORES    0x02  /* fast select requested with no restriction
                                   of response */
#define IN_FS_REQRES      0x03  /* fast select requested with restriction
                                   of response */
/* expedited data */
#define IN_ED_NOREQ       0x00  /* no request/request denied */
#define IN_ED_REQ         0x01  /* request indicated/request accepted */

/* type of information */
#define IN_TI_UNDF        0x00  /* undefined */
#define IN_TI_ATHCDE      0x01  /* authorization code */
#define IN_TI_ADRDIG      0x02  /* address digits */
#define IN_TI_TERMID      0x03  /* terminal identification */

/* information request indicator */
#define IN_IR_RQCMPL      0x00  /* information request completed */
#define IN_IR_PRMPT       0x01  /* prompt for additional information */

/* delivery confirmation */
#define IN_DC_LNKLNK      0x00  /* link by link confirmation */
#define IN_DC_ENDEND      0x01  /* end to end confirmation */

/* modulo */
#define IN_MOD_8          0x00  /* modulo 8 sequencing */
#define IN_MOD_128        0x01  /* modulo 128 sequencing */

/* call forwarding no reply indicator */
#define IN_CF_FALSE       0x00  /* false */
#define IN_CF_TRUE        0x01  /* true */

/* layer 1 identity */
#define IN_L1_IDENT       0x01  /* layer 1 identity */

/* layer 2 identity */
#define IN_L2_IDENT       0x02  /* layer 2 identity */

/* layer 3 identity */
#define IN_L3_IDENT       0x03  /* layer 3 identity */

/* extension bit */
#define IN_EXT            0x80

#ifdef ATT
/* operation type */
#define IN_OT_ACTION     0x00  /* action */
#define IN_OT_EVENT      0x01  /* event */
#define IN_OT_GET        0x02  /* get */
#define IN_OT_SET        0x03  /* set */

/* operation class */
#define IN_OC_UNCONF     0x00  /* unconfirmed operation */
#define IN_OC_CONF       0x01  /* confirmed operation */
#define IN_OC_RESULT     0x02  /* return result */
#define IN_OC_RESCONT    0x03  /* return result continued */
#define IN_OC_ERROR      0x04  /* return error */
#define IN_OC_REJECT     0x05  /* reject */

/* management codes */
#define IN_CO_ERROR      0x00  /* unspecified error */
#define IN_CO_INITREQ    0x01  /* initialization request */
#define IN_CO_ADRINFO    0x01  /* address information */
#define IN_CO_PROTVIO    0x01  /* protocol violation */
#define IN_CO_ENDSTCH    0x02  /* endpoint service state change */
#define IN_CO_UNROPER    0x02  /* unrecognized operation */
#define IN_CO_ACTLOOP    0x03  /* activate loopback */
#define IN_CO_NONSYNC    0x03  /* non-synchronous operation not supported */
#define IN_CO_DEACTLOOP  0x04  /* deactivate loopback */
#define IN_CO_CALLSTAT   0x04  /* call status information */
#define IN_CO_RESET      0x08  /* reset */
#define IN_CO_EQUIP      0x08  /* equipment information */

/* management parameter identifier */
#define IN_MP_SRVPROFID  0x01  /* service profile id */
#define IN_MP_ENDID      0x02  /* endpoint id */
#define IN_MP_CALREFID   0x08  /* call reference id */
#define IN_MP_CALSTID    0x09  /* call state id */
#define IN_MP_CHANID     0x0a  /* channel id */
#define IN_MP_LLID       0x0b  /* logical link ID */
#define IN_MP_SRVSTATE   0x11  /* service state */
#define IN_MP_SRVMSGERR  0x12  /* service message error code */
#define IN_MP_LOOPLOC    0x13  /* loopback location */
#define IN_MP_SUPCAP     0x2a  /* supplementary capabilities */
#define IN_MP_CAUSEID    0x70  /* cause id */
#endif /* ATT */

/* call state */
#define IN_CS_NULL          0x00   /* U00, N00 - null                      - c, p, u */
#define IN_CS_CALLINIT      0x01   /* U01, N01 - call initiated            - c, p, u */
#define IN_CS_OVLAPSND      0x02   /* U02, N02 - overlap sending           - c, u    */
#define IN_CS_OUTPROC       0x03   /* U03, N03 - outgoing call proceeding  - c, p, u */
#define IN_CS_CALLDEL       0x04   /* U04, N04 - call delivered            - c, u    */
#define IN_CS_CALLPRES      0x06   /* U06, N06 - call present              - c, p, u */
#define IN_CS_CALLRECV      0x07   /* U07, N07 - call received             - c, p    */
#define IN_CS_CONNRQ        0x08   /* U08, N08 - connect request           - c, p, u */
#define IN_CS_INPROC        0x09   /* U09, N09 - incoming call proceeding  - c, p, u */
#define IN_CS_ACTVE         0x0A   /* U10, N10 - active call               - c, p, u */
#define IN_CS_DISRQ         0x0B   /* U11, N11 - disconnect request        - c, p    */
#define IN_CS_DISCIN        0x0C   /* U12, N12 - disconnect indictation    - c, p    */
#define IN_CS_SUSRQ         0x0F   /* U15, N15 - suspend request           - c       */
#define IN_CS_RSMRQ         0x11   /* U17, N17 - resume request            - c       */
#define IN_CS_RELRQ         0x13   /* U19, N19 - release request           - c, p, u */
#define IN_CS_CALLABRT      0x16   /* ---, N22 - call abort                - c, p, u */
#define IN_CS_OVLAPRCV      0x19   /* U25, N25 - overlap receiving         - c, u    */
#define IN_CS_CALLINDEP     0x1f   /* U31, N31 - call independent          - c, p, u */
/*in005.311 - Addition to add two intermediate states */
#define CS_INTRELREQ       0x20/*U32, N32 - intermediate release request - c, p, u */
#define CS_INTNULL         0x21 /* U33, N33 - intermediate null            - c, p, u */
#if (ISDN_BC303TMC || ISDN_BC303CSC)
#define IN_CS_PERMSIGN      0x64   /* U100, N100 - permanent signal        - c, p, u */
#define IN_CS_PERMSIGN_MSK  0x24   /* U100, N100 - permanent signal masked - c, p, u */
#endif /* ISDN_BC303TMC || ISDN_BC303CSC */

/* global interface state */
#define IN_GS_REST0           0x00   /* Rest 0   - restart null             - c, p, u */
#define IN_GS_REST1           0x3d   /* Rest 1   - restart request          - c, p, u */
#define IN_GS_REST2           0x3e   /* Rest 2   - restart                  - c, p, u */

/* new status */
#define IN_NS_INSRV           0x00   /* in service  */
#define IN_NS_MAINT           0x01   /* maintenance */
#define IN_NS_OUTSRV          0x02   /* out service */

/* preference */
#define IN_PF_INT             0x00   /* interface */
#define IN_PF_CHAN            0x01   /* channel */

/* type of access */
#define IN_TA_PUBPNC          0x00   /* public/principal - default op syst */
#define IN_TA_PUBALT          0x01   /* public/alternative - default op syst */
#define IN_TA_PRVTPNC         0x02   /* private/princ - used for attendt serv */

/* international type of access */
#define IN_ITA_UNK            0x00   /* unknown */
#define IN_ITA_DSD            0x01   /* direct sprint dial */
#define IN_ITA_IGA            0x02   /* intern. operator general assistance */
#define IN_ITA_IDA            0x03   /* international directory assistance */

/* line privelege information indicator */
#define IN_LPII_FIXED         0x00   /* fixed line privileges */
#define IN_LPII_CUST          0x01   /* customer defined line privileges */

/* attendant status */
#define IN_ATTST_LINE         0x01   /* attendant line */
#define IN_ATTST_NOIND        0x00   /* no indication */

/* encoding scheme */
#define IN_ES_BCDE            0x00   /* BCD even */
#define IN_ES_BCDO            0x01   /* BCD odd */
#define IN_ES_IA5             0x02   /* IA5 */
#define IN_ES_BIN             0x03   /* binary */

/* type of service */
#define IN_TS_UNSPEC          0x00   /* unspecified */

#ifdef INTR6
/* service */
#define IN_SRV_TLPHNY         0x01   /* telephony */ 
#define IN_SRV_ABSRV          0x02   /* a/b services */
#define IN_SRV_X21            0x03   /* X.21 */
#define IN_SRV_GR4FAX         0x04   /* group 4 telefax */
#define IN_SRV_INTERACT       0x05   /* interactive video */
#define IN_SRV_DATA           0x07   /* data transmission */
#define IN_SRV_X25            0x08   /* X.25 */
#define IN_SRV_TELETEX        0x09   /* teletex */
#define IN_SRV_MXDMODE        0x0a   /* mixed mode */
#define IN_SRV_TLECNTRL       0x0d   /* telecontrol */
#define IN_SRV_GRAPH          0x0e   /* graphic telephone services */
#define IN_SRV_INTVDTEX       0x0f   /* interactive videotex */
#define IN_SRV_VIDPHONE       0x10   /* videophone */

/* attributes */
#define IN_ATR_NOSAT          0x00    /* no satellite link */
#define IN_ATR_ONESAT         0x01    /* one satellite link */
#define IN_ATR_TWOSAT         0x02    /* two satellite link */
#define IN_ATR_THREESAT       0x03    /* three satellite link */

/* status */
#define IN_STAT_NOINFO        0x01    /* no information */
#define IN_STAT_PTYCLD        0x02    /* party is called */

/* flag */
#define IN_FL_RQST            0x01    /* request */
#define IN_FL_INDIC           0x00    /* indication */
#endif /* INTR6 */

#define IN_RSTACKSND          0x04    /* restart ack message sent to far end event */

#ifdef QSIG
/* party category */
#define IN_PTYCAT_UNWN        0x00     /* unknown */
#define IN_PTYCAT_EXTN        0x01     /* unknown */
#define IN_PTYCAT_OPER        0x02     /* unknown */
#define IN_PTYCAT_EMRGEXT     0x03     /* unknown */
#endif /* QSIG */

#ifdef NI2
/* CUG indication */
#define IN_CUG_SEL            0x01    /* closed user group selection */
#define IN_CUG_OUTACCSEL      0x02    /* cug with outgoing access  selection */
#endif /* NI2 */

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
/* Origination/Destination Encoding */
#define IN_OD_BCDO            0x01   /* BCD Odd */
#define IN_OD_BCDE            0x02   /* BCD Even */
#define IN_OD_BIN             0x03   /* Binary */
#define IN_OD_IA5             0x04   /* IA5 */

/* Type of Routing */
#define IN_RT_PVT             0x01   /* Private Number */
#define IN_RT_PUB             0x02   /* Public Number */
#define IN_RT_CCS7            0x03   /* CCS7 point code */
#endif /* (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)*/

#ifdef NT
/* Options Value */
#define IN_OPT_RETMSGERR      0x01   /* Return message on error */

/* Reason for Return */
#define IN_RR_NOTRANSNAT      0x01   /* No translation for add of such type */
#define IN_RR_NOTRANSADD      0x02   /* No translation for specific address */
#define IN_RR_APPCONG         0x03   /* Application congestion */
#define IN_RR_APPFAIL         0x04   /* Application failure */
#define IN_RR_UNEQUP          0x05   /* Unequipped application */
#define IN_RR_NETFAIL         0x06   /* Network failure */
#define IN_RR_NETCONG         0x07   /* Network congestion */
#endif /* NT */

#ifdef QW
/* Cause and Event value sent in resource status indication */
#define INST_EVENT_UP         0x01  /* Resource available */
#define INST_EVENT_DOWN       0x02  /* Resource unavailable */
#define INST_CAUSE_DCHAN      0x03  /* D-Channel availability status changes */
#define INST_CAUSE_BCHAN      0x04  /* B_Channel availability status changes */
#define INST_CAUSE_INTERFACE  0x05  /* Interface availability status changes */
#endif /* QW */

/* This part includes the old defines
   that are still used by some of the
   upper layers that uses the services
   of the Q.930/Q.930 layer. These
   upper layers should phase out the
   uses of these old defines in the next
   release */
#ifdef INT_OLD_DEFINES

/* SHIFT Element */
/* shift codeset values */
#define LS_CDESET0  IN_LS_CDESET0  /* codeset 0 */
#define LS_CDESET5  IN_LS_CDESET5  /* codeset 5 */
#define LS_CDESET6  IN_LS_CDESET6  /* codeset 6 */
#define LS_CDESET7  IN_LS_CDESET7  /* codeset 7 */

/* locking non-locking shift flags */
#define LS_ON       IN_LS_ON   /* locking */
#define LS_OFF      IN_LS_OFF  /* non-locking */

/* CAUSE element */
/* location */
#define LOC_USER       IN_LOC_USER       /* user */
#define LOC_PRIVNETLU  IN_LOC_PRIVNETLU  /* private network serving local user */
#define LOC_PUBNETLU   IN_LOC_PUBNETLU   /* public network serving local user */
#define LOC_TRANNET    IN_LOC_TRANNET    /* transit network */
#define LOC_PUBNETRU   IN_LOC_PUBNETRU   /* public network serving the remote user */
#define LOC_PRIVNETRU  IN_LOC_PRIVNETRU  /* private network serving the remote user */
#define LOC_INTNET     IN_LOC_INTNET     /* international network */
#define LOC_NETINTER   IN_LOC_NETINTER   /* network beyond internetworking point */
#define LOC_NOINFOAV   IN_LOC_NOINFOAV   /* no info concerning origin location */

/* recommendation */
#define REC_Q931       IN_REC_Q931  /* CCITT Recommendation Q.931 */
#define REC_X21        IN_REC_X21   /* CCITT Recommendation X.21 */
#define REC_X25        IN_REC_X25   /* CCITT Recommendation X.25 */

/* cause value */
#define CCUNALLOC          IN_CCUNALLOC      /* unassigned number */
#define CCNORTTOTSFNET     IN_CCNORTTOTSFNET /* no route to transit network */
#define CCNORTTODEST       IN_CCNORTTODEST   /* no route to destination */
#define CCCHANUNACPT       IN_CCCHANUNACPT   /* channel unacceptable */
#define CCCALLAWD          IN_CCCALLAWD      /* call awarded and being delivered */
#define CCPRE1DINERR       IN_CCPRE1DINERR   /* prefix 1 dialed in error */
#define CCCALLCLR          IN_CCCALLCLR      /* normal call clearing */
#define CCUSRBSY           IN_CCUSRBSY       /* user busy */
#define CCNOUSRRSP         IN_CCNOUSRRSP     /* no user response */
#define CCNOANSWR          IN_CCNOANSWR      /* no answer (user alerted ) */
#define CCCALLRJT          IN_CCCALLRJT      /* call rejected */
#define CCNMBRCHG          IN_CCNMBRCHG      /* number changed */
#define CCNMBRUNASS        IN_CCNMBRUNASS    /* number unassigned */
#define CCNONSELCLR        IN_CCNONSELCLR    /* non selected User clearing */
#define CCDESTOUTORD       IN_CCDESTOUTORD   /* destination out of order */
#define CCINVNMBFRM        IN_CCINVNMBFRM    /* invalid number format */
#define CCFACREJ           IN_CCFACREJ       /* facility rejected */
#define CCRSPSTSENQ        IN_CCRSPSTSENQ    /* response to STATUS ENQUIRY */
#define CCNORMUNSPEC       IN_CCNORMUNSPEC   /* normal unspecified */
#define CCNOCIRCUIT        IN_CCNOCIRCUIT    /* no circuit/channel available */
#define CCCLQUEUED         IN_CCCLQUEUED     /* call queued */
#define CCNETAOL           IN_CCNETAOL       /* network out of order */
#define CCTMPFAIL          IN_CCTMPFAIL      /* Temporary failure */
#define CCSWTCHCONG        IN_CCSWTCHCONG    /* Switch equipment congestion */
#define CCACCINFDISC       IN_CCACCINFDISC   /* access info discarded */
#define CCREQUNAVAIL       IN_CCREQUNAVAIL   /* requested circuit/channel unavailable */
#define CCRESCUNAVAIL      IN_CCRESCUNAVAIL  /* resources unavailable, unspecified */
#define CCQOSUNAVAIL       IN_CCQOSUNAVAIL   /* Quality of Service unavailable */
#define CCFACNOTSUB        IN_CCFACNOTSUB    /* requested facility not subscribed */
#define CCOUTCLSBRRD       IN_CCOUTCLSBRRD   /* outgoing calls barred */
#define CCINCCALBARD       IN_CCINCCALBARD   /* incoming calls barred */
#define CCNOTAUTHBCAP      IN_CCNOTAUTHBCAP  /* bearer capability not authorized */
#define CCBCAPUNAVAIL      IN_CCBCAPUNAVAIL  /* bearer capability not available */
#define CCCALRESTRICT      IN_CCCALRESTRICT  /* call restriction */
#define CCTRMCLLRDRRJ      IN_CCTRMCLLRDRRJ  /* terminal call redirection rejected */
#define CCUNATHSERV        IN_CCUNATHSERV    /* unathorized service */
#define CCSERVUNAVAIL      IN_CCSERVUNAVAIL  /* Service or option unavailable */
#define CCBCAPNOTIMP       IN_CCBCAPNOTIMP   /* bearer capability not implemented */
#define CCCHANNOTIMP       IN_CCCHANNOTIMP   /* channel type not implemented */
#define CCFACNOTIMP        IN_CCFACNOTIMP    /* requested facility not implemented */
#define CCRESTDIG          IN_CCRESTDIG      /* only restricted digital bear cap is avail. */
#define CCSERVNOTIMP       IN_CCSERVNOTIMP   /* service or option not implemented */
#define CCINVCALLREF       IN_CCINVCALLREF   /* invalid call reference */
#define CCCHANNOTEXST      IN_CCCHANNOTEXST  /* channel does not exist */
#define CCINVCALLID        IN_CCINVCALLID    /* susp. call exists, call id is invalid */
#define CCCALLIDINUSE      IN_CCCALLIDINUSE  /* call identity is in use */
#define CCNOCALLSUSP       IN_CCNOCALLSUSP   /* no call suspended */
#define CCCALLCLEAR        IN_CCCALLCLEAR    /* call id'd has been cleared */
#define CCINCOMPDEST       IN_CCINCOMPDEST   /* incompatible destination */
#define CCINVTRNSTNET      IN_CCINVTRNSTNET  /* invalid transit network selection */
#define CCINVFACPARM       IN_CCINVFACPARM   /* invalid facility parameter */
#define CCINVMSG           IN_CCINVMSG       /* invalid message, unspecified */
#define CCINFOELMSSG       IN_CCINFOELMSSG   /* mandatory info element is missing */
#define CCNOMSGTYP         IN_CCNOMSGTYP     /* msg type is non-existent or not implemented */
#define CCINVMSGTYP        IN_CCINVMSGTYP    /* msg type invalid in call state or not 
                                                implemented */
#define CCNOINFOEL         IN_CCNOINFOEL     /* info element non-existent or not implemented */
#define CCINVINFOEL        IN_CCINVINFOEL    /* invalid info element */
#define CCMSGNOTCMP        IN_CCMSGNOTCMP    /* msg type not compatible with call state */
#define CCTIMERECOVR       IN_CCTIMERECOVR  /* recovery on timer expiry */
#define CCMIEINCLGTH       IN_CCMIEINCLGTH   /* mssg recvd with mand info elmt of incorrect 
                                                length */
#define CCPROTERR          IN_CCPROTERR      /* protocol error, unspecified */
#define CCPROTDISCERR      IN_CCPROTDISCERR  /* protocol discriminator error */
#define CCBEARSRVNA        IN_CCBEARSRVNA    /* bearer service not available */
#define CCETOINFTRIMP      IN_CCETOINFTRIMP  /* end-to-end info transfer impossible */
#define CCENTCONVMDE       IN_CCENTCONVMDE   /* entering conversation mode */
#define CCINTRWRK          IN_CCINTRWRK      /* interworkingpecified */

/* note 12 coding */
#define N12_UNKNOWN    IN_N12_UNKNOWN    /* unknown condition */
#define N12_PERMANENT  IN_N12_PERMANENT  /* permanent condition */
#define N12_TRANSIENT  IN_N12_TRANSIENT  /* transient condition */

/* note 3 coding */
#define N03_INFOCAP    IN_N03_INFOCAP    /* information transfer capability */
#define N03_INFOMODE   IN_N03_INFOMODE   /* information transfer mode */
#define N03_INFORATE0  IN_N03_INFORATE0  /* information transfer rate */
#define N03_STRUCT     IN_N03_STRUCT     /* structure */
#define N03_CFG        IN_N03_CFG        /* configuration */
#define N03_ESTAB      IN_N03_ESTAB      /* establishment */
#define N03_SYM        IN_N03_SYM        /* symmetry */
#define N03_INFORATE1  IN_N03_INFORATE1  /* information transfer rate */
#define N03_LYRID      IN_N03_LYRID      /* layer identification */

/* CHANNEL ID element */
/* interface identifier present */
#define IIP_IMPLICIT   IN_IIP_IMPLICIT  /* interface implicitly identified */
#define IIP_EXPLICIT   IN_IIP_EXPLICIT  /* interface explicitly identified */

/* interface type */
#define IT_BASIC       IN_IT_BASIC      /* basic rate rnterface */
#define IT_OTHER       IN_IT_OTHER      /* other interface (e.g. primary rate) */

/* preferred/exclusive */
#define PE_PREFER      IN_PE_PREFER     /* indicated channel is preferred */
#define PE_EXCLSVE     IN_PE_EXCLSVE    /* exclusivie, only indicated channel is acptble*/

/* D channel selection indicator */
#define DSI_NOTDCHAN   IN_DSI_NOTDCHAN  /* channel identified is not d channel */
#define DSI_DCHAN      IN_DSI_DCHAN     /* channel identified is d channel */

/* information channel selection */
#define ICS_NOCHAN     IN_ICS_NOCHAN    /* no channel */
#define ICS_B1CHAN     IN_ICS_B1CHAN    /* B1 channel */
#define ICS_B2CHAN     IN_ICS_B2CHAN    /* B2 channel */
#define ICS_ANYCHN     IN_ICS_ANYCHN    /* any channel */

/* number/map */
#define NM_CHNNMB      IN_NM_CHNNMB     /* channel is indicated by a number */
#define NM_CHNMAP      IN_NM_CHNMAP     /* channel is indicated by a slot map */

/* channel type/map element type */
#define CMT_BCHAN      IN_CMT_BCHAN     /* B channel units */
#define CMT_H0CHAN     IN_CMT_H0CHAN    /* H0 channel units */
#define CMT_H11CHAN    IN_CMT_H11CHAN   /* H11 channel units */
#define CMT_H12CHAN    IN_CMT_H12CHAN   /* H12 channel units */
#define CMT_ATMVCC     IN_CMT_ATMVCC    /* ATM VCC units */

/* HIGH LAYER COMPATIBILITY element */

/* extended high layer characteristics */
#define XHLCI_TEL      IN_XHLCI_TEL       /* Telephony - Recommendation G.711 */
#define XHLCI_FAXG4    IN_XHLCI_FAXG4     /* Facsimile Group 4 - Recommendation T.62 */
#define XHLCI_DAPFAXG4 IN_XHLCI_DAPFAXG4  /* Doc App Profile for Facsimile Group 4 */
                                          /* Recommendation T.503 */
#define XHLCI_DAPMIXED IN_XHLCI_DAPMIXED  /* Doc App Profile for Facsimile Group 4 */
                                          /* Recommendation T.501 */
#define XHLCI_DAPPROC  IN_XHLCI_DAPPROC   /* Doc App Profile for Facsimile Group 4 */
                                          /* Recommendation T.502 */
#define XHLCI_TELETEX  IN_XHLCI_TELETEX   /* Teletex - Recommendation T.62/T.70 */
#define XHLCI_DAPVIDEO IN_XHLCI_DAPVIDEO  /* Doc App Profile for Facsimile Group 4 */
                                          /* Recommendation T.503 */
#define XHLCI_TELEX    IN_XHLCI_TELEX     /* Telex */
#define XHLCI_MHS      IN_XHLCI_MHS       /* Message Handling System */
                                          /* Recommendation X.400 */
#define XHLCI_OSIAPP   IN_XHLCI_OSIAPP    /* OSI Application - Recommendation X.200 */
#define XHLCI_MAINT    IN_XHLCI_MAINT     /* Maintenance */
#define XHLCI_MNGMT    IN_XHLCI_MNGMT     /* Management */
#define XHLCI_VIDTEL   IN_XHLCI_VIDTEL    /* Videotelephony (F.xyz and AV.242) */
#define XHLCI_RESERVE  IN_XHLCI_RESERVE   /* Reserved */

/* PROGRESS INDICATOR element */
/* progress description */
#define PD_NOTETEISDN  IN_PD_NOTETEISDN  /* call is not end to end isdn */
#define PD_DSTNOTISDN  IN_PD_DSTNOTISDN  /* destination address is not isdn */
#define PD_ORGNOTISDN  IN_PD_ORGNOTISDN  /* orgination address is not isdn */
#define PD_CALLRET     IN_PD_CALLRET     /* call has returned to isdn */
#define PD_IBAVAIL     IN_PD_IBAVAIL     /* inband information now available */
#define PD_DELRESP     IN_PD_DELRESP     /* delayed response at called interface */

/* repeat indication */
#define RI_PRIOR       IN_RI_PRIOR       /* prioritized list for selecting possibility */

/* RESTART INDICATOR element */
/* restart class */
#define CL_INDCHAN     IN_CL_INDCHAN   /* indicated channels */
#define CL_SNGINT      IN_CL_SNGINT    /* single interface */
#define CL_ALLINT      IN_CL_ALLINT    /* all interfaces */
#define RSTSND         IN_RSTSND       /* Restart message Sent event */

/* SEGMENT Element */
/* first segment indicator */
#define FSI_SUBSEG     IN_FSI_SUBSEG   /* subsequent segment to first segment */
#define FSI_FRSTSEG    IN_FSI_FRSTSEG  /* first segment of segmented message */

/* CALLING/CONNECTED PARTY NUMBER  element */

/* Transit Network and Network specific facilities Elements */

/* type of network identification */
#define TNID_USER      IN_TNID_USER    /* user specified */
#define TNID_NAT       IN_TNID_NAT     /* national */
#define TNID_INTER     IN_TNID_INTER   /* international */

/* network identification plan */
#define NIDPLN_UNK     IN_NIDPLN_UNK      /* unknown */
#define NIDPLN_CIC     IN_NIDPLN_CIC      /* carrier identification code */
#define NIDPLN_USRSPEC IN_NIDPLN_USRSPEC  /* user specified identification code */
#define NIDPLN_DNIC    IN_NIDPLN_DNIC     /* data network identification code, CCITT */

#define NMB_PRIM       IN_NMB_PRIM        /* number of primitives */

#define PM_CONREQ          (NMB_ALLMSG + 0)   /* Connect Request */
#define PM_CONRSP          (NMB_ALLMSG + 1)   /* Connect Response */
#define PM_CNSTREQ         (NMB_ALLMSG + 2)   /* Connection Status Request */
#define PM_DISCREQ         (NMB_ALLMSG + 3)   /* Disconnect Request */
#define PM_RELREQ          (NMB_ALLMSG + 4)   /* Release Request */
#define PM_DATREQ          (NMB_ALLMSG + 5)   /* Data Request */
#define PM_SSHLREQ         (NMB_ALLMSG + 6)   /* Suspend/Halt Request */
#define PM_SSHLRSP         (NMB_ALLMSG + 7)   /* Suspend/Halt Response */
#define PM_RMRTREQ         (NMB_ALLMSG + 8)   /* Resume/Retrieve Request */
#define PM_RMRTRSP         (NMB_ALLMSG + 9)   /* Resume/Retrieve Response */
#define PM_FLCREQ          (NMB_ALLMSG + 10)  /* Flow Control Request */
#define PM_STATREQ         (NMB_ALLMSG + 11)  /* Status Request */
#define PM_STATRSP         (NMB_ALLMSG + 12)  /* Status Response */
#define PM_SRV             (NMB_ALLMSG + 13)  /* Service */
#define PM_RST             (NMB_ALLMSG + 14)  /* Restart */
#define PM_FAC             (NMB_ALLMSG + 15)  /* Facility */

/* reason for UbndReq */
#define N_UBNDREQ      IN_N_UBNDREQ     /* Requested */

/* value for dChan */
#define DCH_INSIGNIF   IN_DCH_INSIGNIF  /* channel insignificant */

/* event type for restart confirm */
#define LNK_UP          IN_LNK_UP          /* link is up */
#define LNK_DWN         IN_LNK_DWN         /* link is down */
#define INDCHAN         IN_INDCHAN         /* b channel */
#define LNK_DWN_DM_RLS  IN_LNK_DWN_DM_RLS  /* for NFAS with service procedures */
#define SWCHD_BU_DCHAN  IN_SWCHD_BU_DCHAN  /* for NFAS switchover to backup 
                                              dchannel occured */

/* action for FlcReq and FlcInd */
#define N_STARTFLC     IN_N_STARTFLC    /* Start Flow Control */
#define N_ENDFLC       IN_N_ENDFLC      /* End Flow Control */

/* action for SsHlReq  */
#define N_SUSPEND      IN_N_SUSPEND     /* Suspend */
#define N_HOLD         IN_N_HOLD        /* Hold */

/* action for RmRtReq  */
#define N_RESUME       IN_N_RESUME      /* Resume */
#define N_RETRIEVE     IN_N_RETRIEVE    /* Retrieve */

/* defines for request type for InUiIntRstReq */
#define SND_RST        IN_SND_RST       /* send restart */
#define REMOVE         IN_REMOVE        /* remove from service */
#define RESTORE        IN_RESTORE       /* restore service */

#define MF_MAX_REPELMT IN_MF_MAX_REPELMT  /* maximum repeated elements */
#define MF_MAX_IE      IN_MF_MAX_IE       /* maximum repeated IEs other than BearCap */
#define MF_MAX_FACIE   IN_MF_MAX_FACIE    /* maximum repeated facility IEs */

#define MAX_DISPLAY    IN_MAX_DISPLAY     /* number dislpay IE could appear in
                                             NT setup and notify messages */
/* configuration */
#define C_PTPT         IN_C_PTPT  /* point to point */

/* user rate */
#define UR_EINI460     IN_UR_EINI460  /* determined by E bits in I.460 */
#define UR_600         IN_UR_600      /* 0.6 kbits, V.6 and X.1 */
#define UR_1200        IN_UR_1200     /* 1.2 kbits, V.6 */
#define UR_2400        IN_UR_2400     /* 2.4 kbits, V.6 and X.1 */
#define UR_3600        IN_UR_3600     /* 3.6 kbits, V.6 */
#define UR_4800        IN_UR_4800     /* 4.8 kbits, V.6 and X.1 */
#define UR_7200        IN_UR_7200     /* 7.2 kbits, V.6 */
#define UR_8000        IN_UR_8000     /* 8.0 kbits, I.460 */
#define UR_9600        IN_UR_9600     /* 9.6 kbits, V.6 and X.1 */
#define UR_14400       IN_UR_14400    /* 14.4 kbits, V.6 */
#define UR_16000       IN_UR_16000    /* 16 kbits, I.460 */
#define UR_19200       IN_UR_19200    /* 19.2 kbits, V.6 */
#define UR_32000       IN_UR_32000    /* 32 kbits, I.460 */
#define UR_48000       IN_UR_48000    /* 48 kbits, V.6 and X.1 */
#define UR_56000       IN_UR_56000    /* 56 kbits, V.6 */
#define UR_64000       IN_UR_64000    /* 64 kbits, X.1 */
#define UR_134         IN_UR_134      /* .1345 kbits, X.1 */
#define UR_100         IN_UR_100      /* .100 kbits, X.1 */
#define UR_75_1200     IN_UR_75_1200  /* .075/1200 kbits, V.6 and X.1 */
#define UR_1200_75     IN_UR_1200_75  /* 1200/.075 kbits, V.6 and X.1 */
#define UR_50          IN_UR_50       /* .050 kbits, V.6 and X.1 */
#define UR_75          IN_UR_75       /* .075 kbits, V.6 and X.1 */
#define UR_110         IN_UR_110      /* .110 kbits, V.6 and X.1 */
#define UR_150         IN_UR_150      /* .150 kbits, V.6 and X.1 */
#define UR_200         IN_UR_200      /* .200 kbits, V.6 and X.1 */
#define UR_300         IN_UR_300      /* .300 kbits, V.6 and X.1 */
#define UR_12000       IN_UR_12000    /* 12 kbits, V.6 */

/* network independent clock on transmission */
#define NICTX_NOTREQ   IN_NICTX_NOTREQ  /* not required to send with nic */
#define NICTX_REQ      IN_NICTX_REQ     /* required to send with nic */

/* network independent clock on reception */
#define NICRX_NOTACC   IN_NICRX_NOTACC  /* cannot accept data with nic */
#define NICRX_ACC      IN_NICRX_ACC     /* can accept data with nic */

/* flow control on transmission */
#define FLCTX_NOTREQ   IN_FLCTX_NOTREQ  /* not required to send with flow control */
#define FLCTX_REQ      IN_FLCTX_REQ     /* required to send with flow control */

/* flow control on reception */
#define FLCRX_NOTACC   IN_FLCRX_NOTACC  /* cannot accept data with flow control */
#define FLCRX_ACC      IN_FLCRX_ACC     /* can accept data with flow control */

/* rate adaption header/not header */
#define RAH_NOTINC     IN_RAH_NOTINC  /* not included */
#define RAH_INC        IN_RAH_INC     /* included */

/* QSIG Information Transfer types. 
   These are not part of the standard.  These constants are used
   for layer 4 <-> layer 3 communication.   
*/
#define QSIGGFT_CALLREL  IN_QSIGGFT_CALLREL   /* QSIG Call Related info transfer */
#define QSIGGFT_CONLESS  IN_QSIGGFT_CONLESS   /* QSIG Connectionless info transfer */
#define QSIGGFT_CONINDP  IN_QSIGGFT_CONINDP   /* QSIG Connection independent info transfer */
/*
 * QSIG Protocol Profiles.
 */
#define QSIGGFT_PPROF_ROSE IN_QSIGGFT_PPROF_ROSE   /* QSIG ROSE */
#define QSIGGFT_PPROF_ACSE IN_QSIGGFT_PPROF_ACSE   /* QSIG ACSE */
#define QSIGGFT_PPROF_NFE  IN_QSIGGFT_PPROF_NFE    /* QSIG Network Facility Extension */

/* authority and format identifier */
#define AFI_BCD        IN_AFI_BCD   /* BCD format for X.121 and E.164 */
#define AFI_ASCII      IN_AFI_ASCII /* ASCII format for ISO8348 */
#define AFI_X121A      IN_AFI_X121A /* BCD format for X.121 */
#define AFI_X121B      IN_AFI_X121B /* BCD format for X.121 */
#define AFI_X121C      IN_AFI_X121C /* BCD format for X.121 */
#define AFI_X121D      IN_AFI_X121D /* BCD format for X.121 */
#define AFI_E164A      IN_AFI_E164A /* BCD format for E.164 */
#define AFI_E164B      IN_AFI_E164B /* BCD format for E.164 */
#define AFI_E164C      IN_AFI_E164C /* BCD format for E.164 */
#define AFI_E164D      IN_AFI_E164D /* BCD format for E.164 */
#define AFI_ISO1       IN_AFI_ISO1  /* ASCII format for ISO8348 */
#define AFI_ISO2       IN_AFI_ISO2  /* ASCII format for ISO8348 */
#define AFI_ISO3       IN_AFI_ISO3  /* ASCII format for ISO8348 */
#define AFI_ISO4       IN_AFI_ISO4  /* ASCII format for ISO8348 */

/* NT Network specific cause value */
#define CCPREF1NOTDIAL     IN_CCPREF1NOTDIAL /* prefix 1 not dialed */
#define CCCALLPROCEED      IN_CCCALLPROCEED  /* call is proceeding */
#define CCBEARCAPINCMP     IN_CCBEARCAPINCMP /* bearer capabil incompat with requested */
#define CCSERVOPRVIOL      IN_CCSERVOPRVIOL  /* service operation violated */
#define CCDESTADDRMSSG     IN_CCDESTADDRMSSG /* destination address missing, direct call not 
                                                subscribed */
#ifdef INTR6
/* INTR6 Network specific cause value */
#define CCINVCLLREF       IN_CCINVCLLREF     /* invalid call reference */
#define CCBRSRVNIMP       IN_CCBRSVNIMP      /* no application has been made for spec servise*/
#define CCCALIDNONEX      IN_CCCALIDNONEX    /* inknown call identity */
#define CCCALIDINUSE      IN_CCCALIDINUSE    /* call identity already assigned */
#define CCNOCHANAVAL      IN_CCNOCHANAVAL    /* no useful channel available */
#define CCREQFACNTIML     IN_CCREQFACNTIML   /* specified facility code is unknown */
#define CCREQFACNTSBD     IN_CCREQFACNTSBD   /* requested facility not subscribed */
#define CCOUTCALBARRD     IN_CCOUTCALBARRD   /* outgoing calls barred */
#define CCUSERBUSY        IN_CCUSERBUSY      /* user busy */
#define CCNEGCUGCOMP      IN_CCNEGCUGCOMP    /* negative CUG comparison */
#define CCNOTEXSTGCUG     IN_CCNOTEXSTGCUG   /* nonexistent CUG */
#define CCCOMSPLNTRERM    IN_CCCOMSPLNTRERM  /* comm as semi-perm link not permitted 
                                                (RFNR check negative) */
#define CCDSTNOTOBT       IN_CCDSTNOTOBT     /* incorrect destination address */
#define CCNUMBRCHNGD      IN_CCNUMBRCHNGD    /* number changed */
#define CCOUTORDER        IN_CCOUTORDER      /* remote TE not ready */
#define CCNOUSRRESP       IN_CCNOUSRRESP     /* no user responding */
#define CCUSRBUSY         IN_CCUSRBUSY       /* user busy */
#define CCINCCLSBRRD      IN_CCINCCLSBRRD    /* incoming calls barred */
#define CCCALLREJ         IN_CCCALLREJ       /* call actively rejected */
#define CCNETWCONGST      IN_CCNETWCONGST    /* network congestion */
#define CCRMTUSRINIT      IN_CCRMTUSRINIT    /* rejected by remote user */
#define CCLOCLPROCERR     IN_CCLOCLPROCERR   /* local procedure error */ 
#define CCRMTEPROCERR     IN_CCRMTEPROCERR   /* remote procedure error */
#define CCRMTEUSRSUSP     IN_CCRMTEUSRSUSP   /* remote user suspended */
#define CCRMTEUSRRSMD     IN_CCRMTEUSRRSMD   /* remote user resumed */
#define CCUSRINFODSCL     IN_CCUSRINFODSCL   /* user info message rejected locally */
#endif /* INTR6 */

#define CCNI1VACCODE      IN_CCNI1VACCODE    /* National Specific - Vacant Code */
#define CCNI1PRE0DINERR   IN_CCNI1PRE0DINERR /* Nat. Prefix 0 dialed in error */
#define CCNI1PRE1DINERR   IN_CCNI1PRE1DINERR /* Nat. Prefix 1 dialed in error */
#define CCNI1PRE1NOTD     IN_CCNI1PRE1NOTD   /* Nat. Prefix 1 not dialed */
#define CCNI1EXCDIGPROC   IN_CCNI1EXCDIGPROC /* Nat. Excess digits call proceeding */
#define CCNI1CALLPROC     IN_CCNI1CALLPROC   /* Network Specific - Call proceeding */
#define CCNI1SERVDEN      IN_CCNI1SERVDEN    /* Net. Service Denied */
#define CCNI1SPECINAN     IN_CCNI1SPECINAN   /* Net. Special Intercept Announcement */
#define CCNI1SPECINANUC   IN_CCNI1SPECINANUC /* Net. Spec. Intercept Ann. Undefined code */
#define CCNI1SPECINANNU   IN_CCNI1SPECINANNU /* Net. Spec. Intercept Ann. Number Unassigned*/
#define CCNI1CALLINCOMP   IN_CCNI1CALLINCOMP /* Net. Call type incompatable with service */
#define CCNI1SERVOPVIOL   IN_CCNI1SERVOPVIOL /* Net. Service operation violated */
#define CCNI1PROTERRTHR   IN_CCNI1PROTERRTHR /* Net. Protocol Error Threshold Exceeded */


#ifdef ETSI
/* etsi specific cause code values */
#define CCNOCUG           IN_CCNOCUG     /* etsi - non-existent closed user group */
#define CCNOTMEMCUG       IN_CCNOTMEMCUG /* etsi - called user member of closed user grp */
#define CCMEMCUG          IN_CCMEMCUG    /* etsi - called user member of closed user grp */
#endif /* ETSI */

/* congestion level */
#define CL_RR          IN_CL_RR   /* receiver ready */
#define CL_RNR         IN_CL_RNR  /* receiver not ready */

/* interpreter */
#define IN_SELECT      IN_SELECT   /* select identified terminal */
#define IN_EXCLUDE     IN_EXCLUDE  /* select all but identified terminal */

/* status indicator */
#define SI_IDLE        IN_SI_IDLE    /* feature is in idle state */
#define SI_ACTV        IN_SI_ACTV    /* feature is in active state */
#define SI_PROMPT      IN_SI_PROMPT  /* prompt for user imput */
#define SI_PENDING     IN_SI_PENDING /* feature is in pending */

/* type of network identification */
#define TNID_USER      IN_TNID_USER   /* user specified */
#define TNID_NAT       IN_TNID_NAT    /* national */
#define TNID_INTER     IN_TNID_INTER  /* international */

/* network identification plan */
#define NIDPLN_UNK     IN_NIDPLN_UNK   /* unknown */
#define NIDPLN_CIC     IN_NIDPLN_CIC   /* carrier identification code */
#define NIDPLN_DNIC    IN_NIDPLN_DNIC  /* data network identification code, CCITT */
                                       /* Recommendation X.121 */
/* facility code */
#define SID_PREF       IN_SID_PREF    /* SID preffered */
#define SDN            IN_SDN         /* */
#define BN_PREF        IN_BN_PREF     /* BN preffered */
#define SID_ONLY       IN_SID_ONLY    /* SID only */
#define BN_ONLY        IN_BN_ONLY     /* BN only */
#define ACCUNET        IN_ACCUNET     /* ACCUNET SDS */
#define LONG_DIS       IN_LONG_DIS    /* long distance */
#define INT_800        IN_INT_800     /* international 800 */
#define CA_TSC         IN_CA_TSC      /* CA TSC */
#define ATT_MULTIQ     IN_ATT_MULTIQ  /* ATT MultiQuest */

/* binary facility coding values for NT */
#define BF_PVT         IN_BF_PVT      /* Private */
#define BF_INWATS      IN_BF_INWATS   /* Inwats */
#define BF_OUTWATS     IN_BF_OUTWATS  /* Outwats */
#define BF_FX          IN_BF_FX       /* Foreign Exchange */
#define BF_TIE         IN_BF_TIE      /* Tie Trunk */

/* facility coding values for NTNI */
#define FC_INWATS      IN_FC_INWATS   /* Inwats */
#define FC_OUTWATS     IN_FC_OUTWATS  /* Outwats */
#define FC_FX          IN_FC_FX       /* Foreign Exchange */
#define FC_TIE         IN_FC_TIE      /* Tie Trunk */
#define FC_HM          IN_FC_HM       /* Hotel Motel */
#define FC_SCOCS       IN_FC_SCOCS    /* SCOCS */

/* NTNI Protocol Profiles.  */
#define NTNIGFT_PPROF_ROSE IN_NTNIGFT_PPROF_ROSE  /* ROSE */
#define NTNIGFT_PPROF_NFE  IN_NTNIGFT_PPROF_NFE   /* Networking Extension */


/* Display type for Display IE for NTDMS100P */
#define DT_CGPTYNAME      IN_DT_CGPTYNAME      /* Calling Party Name NTDMS100P */
#define DT_CNPTYNAME      IN_DT_CNPTYNAME      /* Connected Party Name NTDMS100P */
#define DT_ORIGCDPTYNAME  IN_DT_ORIGCDPTYNAME  /* Original Called Party name NTDMS100P */

/* Display type for Display IE for NTMCI/NTDMS250 */
#define DT_UNKNOWN        IN_DT_UNKNOWN        /* Unknown */
#define DT_ORIGCDPTYNMB   IN_DT_ORIGCDPTYNMB   /* Original Called Party Number */
#define DT_CGPTYNAME2     IN_DT_CGPTYNAME2     /* Calling Party Name - NTMCI */
#define DT_CDPTYNAME      IN_DT_CDPTYNAME      /* Calling Party Name - NTMCI */
#define DT_REDIRPTYNAME   IN_DT_REDIRPTYNAME   /* Redirecting Party Name */
#define DT_REDIRNPTYNAME  IN_DT_REDIRNPTYNAME  /* Redirection Party Name */
#define DT_CNPTYNAME2     IN_DT_CNPTYNME2      /* Connected Party Name NTMCI */
#define DT_MSGRET         IN_DT_MSGRET         /* Message Retreival */
#define DT_MISCDISPINFO   IN_DT_MISCDISPINFO   /* Miscellaneous Display Info. */
#define DT_ELECDIARY      IN_DT_ELECDIARY      /* Electronic Diary */

/* Associated Information for Display IE for NTDMS100P & NTMCI */
#define AI_UNDEFINED    IN_AI_UNDEFINED     /* Undefined */
#define AI_REQUESTED    IN_AI_REQUESTED     /* Requested */
#define AI_NOTREQUESTED IN_AI_NOTREQUESTED  /* Not Requested */
#define AI_INCLUDED     IN_AI_INCLUDED      /* Included */
#define AI_NOTINCLUDED  IN_AI_NOTINCLUDED   /* Not Included */
#define AI_INFOUNAVAIL  IN_AI_INFOUNAVAIL   /* Information Unavailable */
#define AI_DENIED       IN_AI_DENIED        /* Denied */

/* expansion bit */
#define EXPBIT1        IN_EXPBIT1   /* coding value of facility in fllwng  6 bits */

/* parametrized or binary */
#define PARAM          IN_PARAM   /* parametrized */
#define BINARY         IN_BINARY  /* binary */

/* notification indicator */
#define NI_USRSUSP     IN_NI_USRSUSP     /* user suspended */
#define NI_USRRESM     IN_NI_USRRESM     /* user resumed */
#define NI_BEARCHG     IN_NI_BEARCHG     /* bearer service change */
#define NI_DISCNOTEXT  IN_NI_DISCNOTEXT  /* discriminator for notification extension */
#define NI_STRTDIAL    IN_NI_STRTDIAL    /* start dial */
#define NI_TOLLDVRSN   IN_NI_TOLLDVRSN   /* toll diversion */
#define NI_CNDLPLSDET  IN_NI_CNDLPLSDET  /* connect dial pulse detector */
#define NI_DDLPLSDET   IN_NI_DDLPLSDET   /* disconnect dial pulse detector */
#define NI_SLNTINTRVL  IN_NI_SLNTINTRVL  /* silent interval */
#define NI_TNEGCNCHK   IN_NI_TNEGCNCHK   /* timed negative coin check */
#define NI_TPOSCNCHK   IN_NI_TPOSCNCHK   /* timed positive coin check */
#define NI_TPOSCNCTL   IN_NI_TPOSCNCTL   /* timed positive coin control */
#define NI_TNEGCNCTL   IN_NI_TNEGCNCTL   /* timed negative coin control */
#define NI_COINGRND    IN_NI_COINGRND    /* coin ground */
#define NI_NOCOINGRND  IN_NI_NOCOINGRND  /* no coin ground */
#define NI_CONTRLLR    IN_NI_CONTRLLR    /* conncted via conference controller */
#define NI_CONFREE     IN_NI_CONFREE     /* conncted via conference conferee */
#define NI_TWOPTYCAL   IN_NI_TWOPTYCAL   /* two party call */
#define NI_CONFASREL   IN_NI_CONFASREL   /* conference facility released */
#define NI_CONECB      IN_NI_CONECB      /* connected to emergency service bureau */
#define NI_CONATTCON   IN_NI_CONATTCON   /* connected to attendant console */
#define NI_REPTYDISC   IN_NI_REPTYDISC   /* remote party disconnected */
#define NI_BRIDGCALL   IN_NI_BRIDGCALL   /* bridged call */
#define NI_CLNOBRIDG   IN_NI_CLNOBRIDG   /* call no longer bridged */
#define NI_RTHLDCALL   IN_NI_RTHLDCALL   /* retrieve held call */
#define NI_DISATTCON   IN_NI_DISATTCON   /* no longer connected to attendant console */
#define NI_CALLDIVRT   IN_NI_CALLDIVRT   /* call diverted */
#define NI_CALLWAIT    IN_NI_CALWAIT     /* call waiting */
#define NI_CALINEVT    IN_NI_CALINEVT    /* call information/event */
#define NI_USRBRIDGON  IN_NI_USRBRIDGON  /* user bridged onto call */
#define NI_ABCMONDISC  IN_NI_ABCMONDISC  /* ABC monitoring discontinued */
#define NI_CALHLD      IN_NI_CALHLD      /* call on hold */
#define NI_MONUSRIDLE  IN_NI_MONUSRIDLE  /* monitored user idle */
#define NI_REMHLD      IN_NI_REMHLD      /* remote hold */
#define NI_REMHLDREL   IN_NI_REMHLDREL   /* remote hold released */
#define NI_CALLFWDED   IN_NI_CALLFWDED   /* call is forwarded */
#define NI_PRVENB      IN_NI_PRVENB      /* privacy enabled */
#define NI_PRVDSB      IN_NI_PRVDSB      /* privacy disabled */
#define NI_CALRTHL     IN_NI_CALRTHL     /* call retrieved from hold */

#if (ISDN_303TMC || ISDN_303CSC)
#define NI_TIPPTYTST   IN_NI_TIPPTYTST  /* tip party test */
#define NI_TIPGRND     IN_NI_TIPGRND    /* tip party ground */
#define NI_NOTIPGRND   IN_NI_NOTIPGRND  /* no tip party ground */
#endif /* ISDN_303TMC || ISDN_303CSC */
 
#ifdef NTNI
#define NI_ASN         IN_NI_ASN /* ASN.1 for ISO */
#endif /* NTNI */

#ifdef QSIG
#define PD_INTWPUBNET  IN_PD_INTWPUBNET  /* interworking with public network */
#define PD_ITWUSRLSIG  IN_PD_ITWUSRLSIG  /* interworking with  network unable to supply
                                            a release signal */
#define PD_ITWUSRLBAN  IN_PD_ITWUSRLBAN  /* interworking with  network unable to supply
                                            a release signal before answer */
#define PD_ITWUSRLAAN  IN_PD_ITWUSRLAAN  /* interworking with  network unable to supply
                                            a release signal after answer */
#define PD_INTWPRVNET  IN_PD_INTWPRVNET  /* interworking with another private network */
#endif /* QSIG */

/* signal value */
#define SIG_DIAL       IN_SIG_DIAL       /* dial tone on */
#define SIG_RNGBCK     IN_SIG_RNGBCK     /* ring back tone on */
#define SIG_INTER      IN_SIG_INTER      /* intercept tone on */
#define SIG_NETCONG    IN_SIG_NETCONG    /* network congestion tone on */
#define SIG_BUSY       IN_SIG_BUSY       /* busy tone on */
#define SIG_CONFIRM    IN_SIG_CONFIRM    /* confirm tone on */
#define SIG_ANSWER     IN_SIG_ANSWER     /* answer tone on */
#define SIG_CALLWAIT   IN_SIG_CALLWAIT   /* call waiting tone on */
#define SIG_OFFHOOK    IN_SIG_OFFHOOK    /* off hook warning tone on */
#define SIG_CSTMTON    IN_SIG_CSTMTON    /* Custom tone on */
#define SIG_BSVERTON   IN_SIG_BSVETON    /* busy verify tone on */
#define SIG_ERRTON     IN_SIG_ERRTON     /* error tone on */
#define SIG_STDLTON    IN_SIG_STDLTON    /* stutter dial tone on */
#define SIG_RCLDLTNON  IN_SIG_RCLDLTNON  /* recall dial tone on */
#define SIG_EXPRTTON   IN_SIG_EXPRTTON   /* stutter dial tone on */
#define SIG_TONESOFF   IN_SIG_TONESOFF   /* tones off */
#define SIG_ALERT0     IN_SIG_ALERT0     /* alerting on - pattern 0 */
#define SIG_ALERT1     IN_SIG_ALERT1     /* alerting on - pattern 1 */
#define SIG_ALERT2     IN_SIG_ALERT2     /* alerting on - pattern 2 */
#define SIG_ALERT3     IN_SIG_ALERT3     /* alerting on - pattern 3 */
#define SIG_ALERT4     IN_SIG_ALERT4     /* alerting on - pattern 4 */
#define SIG_ALERT5     IN_SIG_ALERT5     /* alerting on - pattern 5 */
#define SIG_ALERT6     IN_SIG_ALERT6     /* alerting on - pattern 6 */
#define SIG_ALERT7     IN_SIG_ALERT7     /* alerting on - pattern 7 */
#define SIG_ALERTT     IN_SIG_ALERTT     /* alerting on - t ringing */
#define SIG_ALERTR     IN_SIG_ALERTR     /* alerting on - r ringing */
#define SIG_ALERTTT    IN_SIG_ALERTT     /* alerting on - t ringing */
#define SIG_ALERTOFF   IN_SIG_ALERTOFF   /* alerting off */
#ifdef BC303CSC
#define SIG_WINKSTRT   IN_SIG_WINKSTRT   /* wink start */
#define SIG_IMMDIAL    IN_SIG_IMMDIAL    /* immediate dial */
#define SIG_DELDIAL    IN_SIG_DELDIAL    /* delay dial */
#endif /* BC303CSC */

#define SIG_RECDIALTN  IN_SIG_RECDIALTN  /* nt recall dial tone on */
#define SIG_BARGINTON  IN_SIG_BARGINTON  /* barge in tone */
#define SIG_INCADDTON  IN_SIG_INCADDTON  /* incoming additional call tone */
#define SIG_PRIADDTON  IN_SIG_PRIADDTON  /* priority additional call tone */

/* service discriminator */
#define SD_SUPAPP      IN_SD_SUPAPP  /* supplementary service applications */
#define SD_TCAP        IN_SD_TCAP    /* supplementary service - TCAP */

/* service indentifier */
#define SI_RLT         IN_SI_RLT   /* release link trunk */
#define SI_SR          IN_SI_SR    /* Service Rewrite */
#define SI_NMS         IN_SI_NMS   /* network message service */
#define SI_NACD        IN_SI_NACD  /* network automatic call distribution */
#define SI_NRAG        IN_SI_NRAG  /* network ring again */

#ifdef ISDN_NTSPRINT
#define CNTRL_INVOKE   IN_CNTRL_INVOKE   /* Control Type - Invoke */
#define CNTRL_RETRSLT  IN_CNTRL_RETRSLT  /* Control Type - Return Result */
#define CNTRL_RETERR   IN_CNTRL_RETERR   /* Control Type - Return Error */
#define CNTRL_INVKLST  IN_CNTRL_INVKLST  /* Control Type - Invoke Last*/
#endif /* ISDN_NTSPRINT */

/* capability description */
#define CDSC_NATFMDE   IN_CDSC_NATFMDE /* terminal or NT2 in national funct mode */
#define CDSC_STMLS     IN_CDSC_STMLS   /* stimulus */

/* indication type */
#define INDTP_TOTCHG   IN_INDTP_TOTCHG  /* total charge */

/* facility class */
#define FC_CONSPEC     IN_FC_CONSPEC  /* context specific */

/* form */
#define FF_CONSTRUCT   IN_FF_CONSTRUCT  /* constructor */

/* component tag */
#define CT_INVOKE      IN_CT_INVOKE   /* invoke */
#define CT_RETRSLT     IN_CT_RETRSLT  /* return result */
#define CT_RETERR      IN_CT_RETERR   /* return error */
#define CT_REJECT      IN_CT_REJECT   /* return reject */

/* length format */
#define LF_COMPONE     IN_LF_COMPONE  /* length of component field is one octet */

/* information specific */
#define IS_DIALNMBR    IN_IS_DIALNMBR    /* dialing number */
#define IS_CGNMBR      IN_IS_CGNMBR      /* calling number */
#define IS_CONNMBR     IN_IS_CONNMBR     /* connected number */
#define IS_REDGNMBR    IN_IS_REDGNMBR    /* redirecting number */
#define IS_REDNNMBR    IN_IS_REDNNMBR    /* redirection number */
#define IS_REDGNMBRWI  IN_IS_REDGNMBRWI  /* redirecting number without indication */
#define IS_REDNNMBRWI  IN_IS_REDNNMBRWI  /* redirection number without indication */
#define IS_INFODEND    IN_IS_INFODEND    /* information denied */
#define IS_INFONOAV    IN_IS_INFONOAV    /* information not available */

/* switchhook value */
#define SWH_ONHOOK     IN_SWH_ONHOOK   /* onhook */
#define SWH_OFFHOOK    IN_SWH_OFFHOOK  /* off hook */

/* throughput class */
#define TC_75          IN_TC_75     /* .075 kbits */
#define TC_150         IN_TC_150    /* .150 kbits */
#define TC_300         IN_TC_300    /* .300 kbits */
#define TC_600         IN_TC_600    /* .600 kbits */
#define TC_1200        IN_TC_1200   /* 1.2 kbits */
#define TC_2400        IN_TC_2400   /* 2.4 kbits */
#define TC_4800        IN_TC_4800   /* 4.8 kbits */
#define TC_9600        IN_TC_9600   /* 9.6 kbits */
#define TC_19200       IN_TC_19200  /* 19.2 kbits */
#define TC_48000       IN_TC_48000  /* 48 kbits */

/* fast select */
#define FS_NOTREQ0     IN_FS_NOTREQ0   /* fast select not requested */
#define FS_NOTREQ1     IN_FS_NOTREQ1   /* fast select not requested */
#define FS_REQNORES    IN_FS_REQNORES  /* fast select requested with no restriction */
                                       /* of response */
#define FS_REQRES      IN_FS_REQRES    /* fast select requested with restriction */
                                       /* of response */

/* expedited data */
#define ED_NOREQ       IN_ED_NOREQ   /* no request/request denied */
#define ED_REQ         IN_ED_REQ     /* request indicated/request accepted */

/* type of information */
#define TI_UNDF        IN_TI_UNDF    /* undefined */
#define TI_ATHCDE      IN_TI_ATHCDE  /* authorization code */
#define TI_ADRDIG      IN_TI_ADRDIG  /* address digits */
#define TI_TERMID      IN_TI_TERMID  /* terminal identification */

/* information request indicator */
#define IR_RQCMPL      IN_IR_RQCMPL  /* information request completed */
#define IR_PRMPT       IN_IR_PRMPT   /* prompt for additional information */

/* delivery confirmation */
#define DC_LNKLNK      IN_DC_LNKLNK  /* link by link confirmation */
#define DC_ENDEND      IN_DC_ENDEND  /* end to end confirmation */

/* modulo */
#define MOD_8          IN_MOD_8    /* modulo 8 sequencing */
#define MOD_128        IN_MOD_128  /* modulo 128 sequencing */

/* call forwarding no reply indicator */
#define CF_FALSE       IN_CF_FALSE  /* false */
#define CF_TRUE        IN_CF_TRUE   /* true */


/* layer 1 identity */
#define L1_IDENT       IN_L1_IDENT  /* layer 1 identity */

/* layer 2 identity */
#define L2_IDENT       IN_L2_IDENT  /* layer 2 identity */

/* layer 3 identity */
#define L3_IDENT       IN_L3_IDENT  /* layer 3 identity */

/* extension bit */
#define EXT            IN_EXT

#ifdef ATT
/* operation type */
#define OT_ACTION     IN_OT_ACTION  /* action */
#define OT_EVENT      IN_OT_EVENT   /* event */
#define OT_GET        IN_OT_GET     /* get */
#define OT_SET        IN_OT_SET     /* set */

/* operation class */
#define OC_UNCONF     IN_OC_UNCONF   /* unconfirmed operation */
#define OC_CONF       IN_OC_CONF     /* confirmed operation */
#define OC_RESULT     IN_OC_RESULT   /* return result */
#define OC_RESCONT    IN_OC_RESCONT  /* return result continued */
#define OC_ERROR      IN_OC_ERROR    /* return error */
#define OC_REJECT     IN_OC_REJECT   /* reject */

/* management codes */
#define CO_ERROR      IN_CO_ERROR      /* unspecified error */
#define CO_INITREQ    IN_CO_INITREQ    /* initialization request */
#define CO_ADRINFO    IN_CO_ADRINFO    /* address information */
#define CO_PROTVIO    IN_CO_PROTVIO    /* protocol violation */
#define CO_ENDSTCH    IN_CO_ENDSTCH    /* endpoint service state change */
#define CO_UNROPER    IN_CO_UNROPER    /* unrecognized operation */
#define CO_ACTLOOP    IN_CO_ACTLOOP    /* activate loopback */
#define CO_NONSYNC    IN_CO_NONSYNC    /* non-synchronous operation not supported */
#define CO_DEACTLOOP  IN_CO_DEACTLOOP  /* deactivate loopback */
#define CO_CALLSTAT   IN_CO_CALLSTAT   /* call status information */
#define CO_RESET      IN_CO_RESET      /* reset */
#define CO_EQUIP      IN_CO_EQUIP      /* equipment information */

/* management parameter identifier */
#define MP_SRVPROFID  IN_MP_SRVPROFID  /* service profile id */
#define MP_ENDID      IN_MP_ENDID      /* endpoint id */
#define MP_CALREFID   IN_MP_CALREFID   /* call reference id */
#define MP_CALSTID    IN_MP_CALSTID    /* call state id */
#define MP_CHANID     IN_MP_CHANID     /* channel id */
#define MP_LLID       IN_MP_LLID       /* logical link ID */
#define MP_SRVSTATE   IN_MP_SRVSTATE   /* service state */
#define MP_SRVMSGERR  IN_MP_SRVMSGERR  /* service message error code */
#define MP_LOOPLOC    IN_MP_LOOPLOC    /* loopback location */
#define MP_SUPCAP     IN_MP_SUPCAP     /* supplementary capabilities */
#define MP_CAUSEID    IN_MP_CAUSEID    /* cause id */
#endif /* ATT */

/* call state */
#define CS_NULL            IN_CS_NULL      /* U00, N00 - null                     - c, p, u */
#define CS_CALLINIT        IN_CS_CALLINIT  /* U01, N01 - call initiated           - c, p, u */
#define CS_OVLAPSND        IN_CS_OVLAPSND  /* U02, N02 - overlap sending          - c, u */
#define CS_OUTPROC         IN_CS_OUTPROC   /* U03, N03 - outgoing call proceeding - c, p, u */
#define CS_CALLDEL         IN_CS_CALLDEL   /* U04, N04 - call delivered           - c, u */
#define CS_CALLPRES        IN_CS_CALLPRES  /* U06, N06 - call present             - c, p, u */
#define CS_CALLRECV        IN_CS_CALLRECV  /* U07, N07 - call received            - c, p */
#define CS_CONNRQ          IN_CS_CONNRQ    /* U08, N08 - connect request          - c, p, u */
#define CS_INPROC          IN_CS_INPROC    /* U09, N09 - incoming call proceeding - c, p, u */
#define CS_ACTVE           IN_CS_ACTVE     /* U10, N10 - active call              - c, p, u */
#define CS_DISRQ           IN_CS_DISRQ     /* U11, N11 - disconnect request       - c, p */
#define CS_DISCIN          IN_CS_DISCIN    /* U12, N12 - disconnect indictation   - c, p */
#define CS_SUSRQ           IN_CS_SUSRQ     /* U15, N15 - suspend request          - c */
#define CS_RSMRQ           IN_CS_RSMRQ     /* U17, N17 - resume request           - c */
#define CS_RELRQ           IN_CS_RELRQ     /* U19, N19 - release request          - c, p, u */
#define CS_CALLABRT        IN_CS_CALLABRT  /* ---, N22 - call abort               - c, p, u */
#define CS_OVLAPRCV        IN_CS_OVLAPRCV  /* U25, N25 - overlap receiving        - c, u */
#define CS_CALLINDEP       IN_CS_CALLINDEP /* U31, N31 - call independent         - c, p, u */

#if (ISDN_BC303TMC || ISDN_BC303CSC)
#define CS_PERMSIGN       IN_CS_PERMSIGN      /* U100, N100 - permanent signal        - c, p, u */
#define CS_PERMSIGN_MSK   IN_CS_PERMSIGN_MSK  /* U100, N100 - permanent signal masked - c, p, u */
#endif /* ISDN_BC303TMC || ISDN_BC303CSC */

/* global interface state */
#define GS_REST0           IN_GS_REST0   /* Rest 0   - restart null             - c, p, u */
#define GS_REST1           IN_GS_REST1   /* Rest 1   - restart request          - c, p, u */
#define GS_REST2           IN_GS_REST2   /* Rest 2   - restart                  - c, p, u */

/* new status */
#define NS_INSRV           IN_NS_INSRV    /* in service  */
#define NS_MAINT           IN_NS_MAINT    /* maintenance */
#define NS_OUTSRV          IN_NS_OUTSRV   /* out service */

/* preference */
#define PF_INT             IN_PF_INT    /* interface */
#define PF_CHAN            IN_PF_CHAN   /* channel */

/* type of access */
#define TA_PUBPNC          IN_TA_PUBPNC    /* public/principal - default op syst */
#define TA_PUBALT          IN_TA_PUBALT    /* public/alternative - default op syst */
#define TA_PRVTPNC         IN_TA_PRVTPNC   /* private/princ - used for attendt serv */

/* international type of access */
#define ITA_UNK            IN_ITA_UNK   /* unknown */
#define ITA_DSD            IN_ITA_DSD   /* direct sprint dial */
#define ITA_IGA            IN_ITA_IGA   /* intern. operator general assistance */
#define ITA_IDA            IN_ITA_IDA   /* international directory assistance */

/* line privelege information indicator */
#define LPII_FIXED         IN_LPII_FIXED  /* fixed line privileges */
#define LPII_CUST          IN_LPII_CUST   /* customer defined line privileges */

/* attendant status */
#define ATTST_LINE         IN_ATTST_LINE    /* attendant line */
#define ATTST_NOIND        IN_ATTST_NOIND   /* no indication */

/* encoding scheme */
#define ES_BCDE            IN_ES_BCDE   /* BCD even */
#define ES_BCDO            IN_ES_BCDO   /* BCD odd */
#define ES_IA5             IN_ES_IA5    /* IA5 */
#define ES_BIN             IN_ES_BIN    /* binary */

/* type of service */
#define TS_UNSPEC          IN_TS_UNSPEC  /* unspecified */

#ifdef INTR6
/* service */
#define SRV_TLPHNY         IN_SRV_TLPHNY    /* telephony */ 
#define SRV_ABSRV          IN_SRV_ABSRV     /* a/b services */
#define SRV_X21            IN_SRV_X21       /* X.21 */
#define SRV_GR4FAX         IN_SRV_GR4FAX    /* group 4 telefax */
#define SRV_INTERACT       IN_SRV_INTERACT  /* interactive video */
#define SRV_DATA           IN_SRV_DATA      /* data transmission */
#define SRV_X25            IN_SRV_X25       /* X.25 */
#define SRV_TELETEX        IN_SRV_TELETEX   /* teletex */
#define SRV_MXDMODE        IN_SRV_MXDMODE   /* mixed mode */
#define SRV_TLECNTRL       IN_SRV_TLECNTRL  /* telecontrol */
#define SRV_GRAPH          IN_SRV_GRAPH     /* graphic telephone services */
#define SRV_INTVDTEX       IN_SRV_INTVDTEX  /* interactive videotex */
#define SRV_VIDPHONE       IN_SRV_VIDPHONE  /* videophone */

/* attributes */
#define ATR_NOSAT          IN_ATR_NOSAT    /* no satellite link */
#define ATR_ONESAT         IN_ATR_ONESAT   /* one satellite link */
#define ATR_TWOSAT         IN_ATR_TWOSAT   /* two satellite link */
#define ATR_THREESAT       IN_ATR_THREESAT /* three satellite link */

/* status */
#define STAT_NOINFO        IN_STAT_NOINFO    /* no information */
#define STAT_PTYCLD        IN_STAT_PTYCLD    /* party is called */

/* flag */
#define FL_RQST            IN_FL_RQST     /* request */
#define FL_INDIC           IN_FL_INDIC    /* indication */
#endif /* INTR6 */

#define RSTACKSND          IN_RSTACKSND   /* restart ack message sent to far end event */

#ifdef QSIG
/* party category */
#define PTYCAT_UNWN        IN_PTYCAT_UNWN     /* unknown */
#define PTYCAT_EXTN        IN_PTYCAT_EXTN     /* unknown */
#define PTYCAT_OPER        IN_PTYCAT_OPER     /* unknown */
#define PTYCAT_EMRGEXT     IN_PTYCAT_EMRGEXT  /* unknown */
#endif /* QSIG */

#ifdef NI2
/* CUG indication */
#define CUG_SEL            IN_CUG_SEL         /* closed user group selection */
#define CUG_OUTACCSEL      IN_CUG_OUTACCSEL   /* cug with outgoing access  selection */
#endif /* NI2 */

#if (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)
/* Origination/Destination Encoding */
#define OD_BCDO            IN_OD_BCDO   /* BCD Odd */
#define OD_BCDE            IN_OD_BCDE   /* BCD Even */
#define OD_BIN             IN_OD_BIN    /* Binary */
#define OD_IA5             IN_OD_IA5    /* IA5 */

/* Type of Routing */
#define RT_PVT             IN_RT_PVT    /* Private Number */
#define RT_PUB             IN_RT_PUB    /* Public Number */
#define RT_CCS7            IN_RT_CCS7   /* CCS7 point code */
#endif /* (ISDN_NT || ISDN_NTDMS250 || ISDN_NTMCI)*/

#ifdef NT
/* Options Value */
#define OPT_RETMSGERR      IN_OPT_RETMSGERR   /* Return message on error */

/* Reason for Return */
#define RR_NOTRANSNAT      IN_RR_NOTRANSNAT   /* No translation for add of such type */
#define RR_NOTRANSADD      IN_RR_NOTRANSADD   /* No translation for specific address */
#define RR_APPCONG         IN_RR_APPCONG      /* Application congestion */
#define RR_APPFAIL         IN_RR_APPFAIL      /* Application failure */
#define RR_UNEQUP          IN_RR_UNEQUP       /* Unequipped application */
#define RR_NETFAIL         IN_RR_NETFAIL      /* Network failure */
#define RR_NETCONG         IN_RR_NETCONG      /* Network congestion */
#endif /* NT */

#endif /* INT_OLD_DEFINES */

#define  ERRINT  0
#define  EINTXXX (ERRIN + 999) /* Error code for pk , unpk */

#define   EINT001      (ERRINT +    1)    /*        int.c: 142 */
#define   EINT002      (ERRINT +    2)    /*        int.c: 143 */
#define   EINT003      (ERRINT +    3)    /*        int.c: 186 */
#define   EINT004      (ERRINT +    4)    /*        int.c: 187 */
#define   EINT005      (ERRINT +    5)    /*        int.c: 225 */
#define   EINT006      (ERRINT +    6)    /*        int.c: 226 */
#define   EINT007      (ERRINT +    7)    /*        int.c: 276 */
#define   EINT008      (ERRINT +    8)    /*        int.c: 277 */
#define   EINT009      (ERRINT +    9)    /*        int.c: 278 */
#define   EINT010      (ERRINT +   10)    /*        int.c: 279 */
#define   EINT011      (ERRINT +   11)    /*        int.c: 280 */
#define   EINT012      (ERRINT +   12)    /*        int.c: 334 */
#define   EINT013      (ERRINT +   13)    /*        int.c: 335 */
#define   EINT014      (ERRINT +   14)    /*        int.c: 336 */
#define   EINT015      (ERRINT +   15)    /*        int.c: 337 */
#define   EINT016      (ERRINT +   16)    /*        int.c: 338 */
#define   EINT017      (ERRINT +   17)    /*        int.c: 339 */
#define   EINT018      (ERRINT +   18)    /*        int.c: 392 */
#define   EINT019      (ERRINT +   19)    /*        int.c: 393 */
#define   EINT020      (ERRINT +   20)    /*        int.c: 394 */
#define   EINT021      (ERRINT +   21)    /*        int.c: 395 */
#define   EINT022      (ERRINT +   22)    /*        int.c: 396 */
#define   EINT023      (ERRINT +   23)    /*        int.c: 397 */
#define   EINT024      (ERRINT +   24)    /*        int.c: 398 */
#define   EINT025      (ERRINT +   25)    /*        int.c: 453 */
#define   EINT026      (ERRINT +   26)    /*        int.c: 454 */
#define   EINT027      (ERRINT +   27)    /*        int.c: 455 */
#define   EINT028      (ERRINT +   28)    /*        int.c: 456 */
#define   EINT029      (ERRINT +   29)    /*        int.c: 457 */
#define   EINT030      (ERRINT +   30)    /*        int.c: 458 */
#define   EINT031      (ERRINT +   31)    /*        int.c: 510 */
#define   EINT032      (ERRINT +   32)    /*        int.c: 511 */
#define   EINT033      (ERRINT +   33)    /*        int.c: 512 */
#define   EINT034      (ERRINT +   34)    /*        int.c: 513 */
#define   EINT035      (ERRINT +   35)    /*        int.c: 560 */
#define   EINT036      (ERRINT +   36)    /*        int.c: 561 */
#define   EINT037      (ERRINT +   37)    /*        int.c: 562 */
#define   EINT038      (ERRINT +   38)    /*        int.c: 563 */
#define   EINT039      (ERRINT +   39)    /*        int.c: 613 */
#define   EINT040      (ERRINT +   40)    /*        int.c: 614 */
#define   EINT041      (ERRINT +   41)    /*        int.c: 615 */
#define   EINT042      (ERRINT +   42)    /*        int.c: 616 */
#define   EINT043      (ERRINT +   43)    /*        int.c: 670 */
#define   EINT044      (ERRINT +   44)    /*        int.c: 671 */
#define   EINT045      (ERRINT +   45)    /*        int.c: 672 */
#define   EINT046      (ERRINT +   46)    /*        int.c: 673 */
#define   EINT047      (ERRINT +   47)    /*        int.c: 674 */
#define   EINT048      (ERRINT +   48)    /*        int.c: 727 */
#define   EINT049      (ERRINT +   49)    /*        int.c: 728 */
#define   EINT050      (ERRINT +   50)    /*        int.c: 729 */
#define   EINT051      (ERRINT +   51)    /*        int.c: 730 */
#define   EINT052      (ERRINT +   52)    /*        int.c: 731 */
#define   EINT053      (ERRINT +   53)    /*        int.c: 788 */
#define   EINT054      (ERRINT +   54)    /*        int.c: 789 */
#define   EINT055      (ERRINT +   55)    /*        int.c: 790 */
#define   EINT056      (ERRINT +   56)    /*        int.c: 791 */
#define   EINT057      (ERRINT +   57)    /*        int.c: 792 */
#define   EINT058      (ERRINT +   58)    /*        int.c: 793 */
#define   EINT059      (ERRINT +   59)    /*        int.c: 794 */
#define   EINT060      (ERRINT +   60)    /*        int.c: 847 */
#define   EINT061      (ERRINT +   61)    /*        int.c: 848 */
#define   EINT062      (ERRINT +   62)    /*        int.c: 849 */
#define   EINT063      (ERRINT +   63)    /*        int.c: 850 */
#define   EINT064      (ERRINT +   64)    /*        int.c: 851 */
#define   EINT065      (ERRINT +   65)    /*        int.c: 899 */
#define   EINT066      (ERRINT +   66)    /*        int.c: 900 */
#define   EINT067      (ERRINT +   67)    /*        int.c: 901 */
#define   EINT068      (ERRINT +   68)    /*        int.c: 902 */
#define   EINT069      (ERRINT +   69)    /*        int.c: 959 */
#define   EINT070      (ERRINT +   70)    /*        int.c: 960 */
#define   EINT071      (ERRINT +   71)    /*        int.c: 961 */
#define   EINT072      (ERRINT +   72)    /*        int.c: 962 */
#define   EINT073      (ERRINT +   73)    /*        int.c: 963 */
#define   EINT074      (ERRINT +   74)    /*        int.c: 964 */
#define   EINT075      (ERRINT +   75)    /*        int.c: 965 */
#define   EINT076      (ERRINT +   76)    /*        int.c:1017 */
#define   EINT077      (ERRINT +   77)    /*        int.c:1018 */
#define   EINT078      (ERRINT +   78)    /*        int.c:1019 */
#define   EINT079      (ERRINT +   79)    /*        int.c:1021 */
#define   EINT080      (ERRINT +   80)    /*        int.c:1022 */
#define   EINT081      (ERRINT +   81)    /*        int.c:1072 */
#define   EINT082      (ERRINT +   82)    /*        int.c:1073 */
#define   EINT083      (ERRINT +   83)    /*        int.c:1074 */
#define   EINT084      (ERRINT +   84)    /*        int.c:1075 */
#define   EINT085      (ERRINT +   85)    /*        int.c:1124 */
#define   EINT086      (ERRINT +   86)    /*        int.c:1125 */
#define   EINT087      (ERRINT +   87)    /*        int.c:1126 */
#define   EINT088      (ERRINT +   88)    /*        int.c:1127 */
#define   EINT089      (ERRINT +   89)    /*        int.c:1128 */
#define   EINT090      (ERRINT +   90)    /*        int.c:1176 */
#define   EINT091      (ERRINT +   91)    /*        int.c:1177 */
#define   EINT092      (ERRINT +   92)    /*        int.c:1178 */
#define   EINT093      (ERRINT +   93)    /*        int.c:1179 */
#define   EINT094      (ERRINT +   94)    /*        int.c:1224 */
#define   EINT095      (ERRINT +   95)    /*        int.c:1225 */
#define   EINT096      (ERRINT +   96)    /*        int.c:1226 */
#define   EINT097      (ERRINT +   97)    /*        int.c:1227 */
#define   EINT098      (ERRINT +   98)    /*        int.c:1228 */
#define   EINT099      (ERRINT +   99)    /*        int.c:1276 */
#define   EINT100      (ERRINT +  100)    /*        int.c:1277 */
#define   EINT101      (ERRINT +  101)    /*        int.c:1278 */
#define   EINT102      (ERRINT +  102)    /*        int.c:1279 */
#define   EINT103      (ERRINT +  103)    /*        int.c:1280 */
#define   EINT104      (ERRINT +  104)    /*        int.c:1281 */
#define   EINT105      (ERRINT +  105)    /*        int.c:1331 */
#define   EINT106      (ERRINT +  106)    /*        int.c:1332 */
#define   EINT107      (ERRINT +  107)    /*        int.c:1333 */
#define   EINT108      (ERRINT +  108)    /*        int.c:1334 */
#define   EINT109      (ERRINT +  109)    /*        int.c:1335 */
#define   EINT110      (ERRINT +  110)    /*        int.c:1384 */
#define   EINT111      (ERRINT +  111)    /*        int.c:1385 */
#define   EINT112      (ERRINT +  112)    /*        int.c:1386 */
#define   EINT113      (ERRINT +  113)    /*        int.c:1387 */
#define   EINT114      (ERRINT +  114)    /*        int.c:1430 */
#define   EINT115      (ERRINT +  115)    /*        int.c:1431 */
#define   EINT116      (ERRINT +  116)    /*        int.c:1432 */
#define   EINT117      (ERRINT +  117)    /*        int.c:1433 */
#define   EINT118      (ERRINT +  118)    /*        int.c:1478 */
#define   EINT119      (ERRINT +  119)    /*        int.c:1479 */
#define   EINT120      (ERRINT +  120)    /*        int.c:1480 */
#define   EINT121      (ERRINT +  121)    /*        int.c:1481 */
#define   EINT122      (ERRINT +  122)    /*        int.c:1529 */
#define   EINT123      (ERRINT +  123)    /*        int.c:1530 */
#define   EINT124      (ERRINT +  124)    /*        int.c:1531 */
#define   EINT125      (ERRINT +  125)    /*        int.c:1532 */
#define   EINT126      (ERRINT +  126)    /*        int.c:1533 */
#define   EINT127      (ERRINT +  127)    /*        int.c:1586 */
#define   EINT128      (ERRINT +  128)    /*        int.c:1587 */
#define   EINT129      (ERRINT +  129)    /*        int.c:1588 */
#define   EINT130      (ERRINT +  130)    /*        int.c:1589 */
#define   EINT131      (ERRINT +  131)    /*        int.c:1590 */
#define   EINT132      (ERRINT +  132)    /*        int.c:1645 */
#define   EINT133      (ERRINT +  133)    /*        int.c:1646 */
#define   EINT134      (ERRINT +  134)    /*        int.c:1647 */
#define   EINT135      (ERRINT +  135)    /*        int.c:1648 */
#define   EINT136      (ERRINT +  136)    /*        int.c:1649 */
#define   EINT137      (ERRINT +  137)    /*        int.c:1650 */
#define   EINT138      (ERRINT +  138)    /*        int.c:1703 */
#define   EINT139      (ERRINT +  139)    /*        int.c:1704 */
#define   EINT140      (ERRINT +  140)    /*        int.c:1705 */
#define   EINT141      (ERRINT +  141)    /*        int.c:1706 */
#define   EINT142      (ERRINT +  142)    /*        int.c:1707 */
#define   EINT143      (ERRINT +  143)    /*        int.c:1758 */
#define   EINT144      (ERRINT +  144)    /*        int.c:1759 */
#define   EINT145      (ERRINT +  145)    /*        int.c:1760 */
#define   EINT146      (ERRINT +  146)    /*        int.c:1761 */
#define   EINT147      (ERRINT +  147)    /*        int.c:1815 */
#define   EINT148      (ERRINT +  148)    /*        int.c:1816 */
#define   EINT149      (ERRINT +  149)    /*        int.c:1817 */
#define   EINT150      (ERRINT +  150)    /*        int.c:1818 */
#define   EINT151      (ERRINT +  151)    /*        int.c:1819 */
#define   EINT152      (ERRINT +  152)    /*        int.c:1820 */
#define   EINT153      (ERRINT +  153)    /*        int.c:1872 */
#define   EINT154      (ERRINT +  154)    /*        int.c:1873 */
#define   EINT155      (ERRINT +  155)    /*        int.c:1874 */
#define   EINT156      (ERRINT +  156)    /*        int.c:1875 */
#define   EINT157      (ERRINT +  157)    /*        int.c:1876 */
#define   EINT158      (ERRINT +  158)    /*        int.c:1921 */
#define   EINT159      (ERRINT +  159)    /*        int.c:1922 */
#define   EINT160      (ERRINT +  160)    /*        int.c:1923 */
#define   EINT161      (ERRINT +  161)    /*        int.c:1974 */
#define   EINT162      (ERRINT +  162)    /*        int.c:1975 */
#define   EINT163      (ERRINT +  163)    /*        int.c:1976 */
#define   EINT164      (ERRINT +  164)    /*        int.c:1977 */
#define   EINT165      (ERRINT +  165)    /*        int.c:2033 */
#define   EINT166      (ERRINT +  166)    /*        int.c:2034 */
#define   EINT167      (ERRINT +  167)    /*        int.c:2035 */
#define   EINT168      (ERRINT +  168)    /*        int.c:2036 */
#define   EINT169      (ERRINT +  169)    /*        int.c:2037 */
#define   EINT170      (ERRINT +  170)    /*        int.c:2038 */
#define   EINT171      (ERRINT +  171)    /*        int.c:2086 */
#define   EINT172      (ERRINT +  172)    /*        int.c:2087 */
#define   EINT173      (ERRINT +  173)    /*        int.c:2088 */
#define   EINT174      (ERRINT +  174)    /*        int.c:2089 */
#define   EINT175      (ERRINT +  175)    /*        int.c:2090 */
#define   EINT176      (ERRINT +  176)    /*        int.c:2091 */
#define   EINT177      (ERRINT +  177)    /*        int.c:2141 */
#define   EINT178      (ERRINT +  178)    /*        int.c:2142 */
#define   EINT179      (ERRINT +  179)    /*        int.c:2143 */
#define   EINT180      (ERRINT +  180)    /*        int.c:2144 */
#define   EINT181      (ERRINT +  181)    /*        int.c:2145 */
#define   EINT182      (ERRINT +  182)    /*        int.c:2146 */
#define   EINT183      (ERRINT +  183)    /*        int.c:2147 */
#define   EINT184      (ERRINT +  184)    /*        int.c:2194 */
#define   EINT185      (ERRINT +  185)    /*        int.c:2195 */
#define   EINT186      (ERRINT +  186)    /*        int.c:2196 */
#define   EINT187      (ERRINT +  187)    /*        int.c:2197 */
#define   EINT188      (ERRINT +  188)    /*        int.c:2244 */
#define   EINT189      (ERRINT +  189)    /*        int.c:2245 */
#define   EINT190      (ERRINT +  190)    /*        int.c:2246 */
#define   EINT191      (ERRINT +  191)    /*        int.c:2247 */
#define   EINT192      (ERRINT +  192)    /*        int.c:2295 */
#define   EINT193      (ERRINT +  193)    /*        int.c:2296 */
#define   EINT194      (ERRINT +  194)    /*        int.c:2297 */
#define   EINT195      (ERRINT +  195)    /*        int.c:2298 */
#define   EINT196      (ERRINT +  196)    /*        int.c:2349 */
#define   EINT197      (ERRINT +  197)    /*        int.c:2350 */
#define   EINT198      (ERRINT +  198)    /*        int.c:2351 */
#define   EINT199      (ERRINT +  199)    /*        int.c:2352 */
#define   EINT200      (ERRINT +  200)    /*        int.c:2353 */
#define   EINT201      (ERRINT +  201)    /*        int.c:2404 */
#define   EINT202      (ERRINT +  202)    /*        int.c:2405 */
#define   EINT203      (ERRINT +  203)    /*        int.c:2406 */
#define   EINT204      (ERRINT +  204)    /*        int.c:2407 */
#define   EINT205      (ERRINT +  205)    /*        int.c:2408 */
#define   EINT206      (ERRINT +  206)    /*        int.c:2458 */
#define   EINT207      (ERRINT +  207)    /*        int.c:2459 */
#define   EINT208      (ERRINT +  208)    /*        int.c:2460 */
#define   EINT209      (ERRINT +  209)    /*        int.c:2461 */
#define   EINT210      (ERRINT +  210)    /*        int.c:2462 */
#define   EINT211      (ERRINT +  211)    /*        int.c:2511 */
#define   EINT212      (ERRINT +  212)    /*        int.c:2512 */
#define   EINT213      (ERRINT +  213)    /*        int.c:2513 */
#define   EINT214      (ERRINT +  214)    /*        int.c:2514 */
#define   EINT215      (ERRINT +  215)    /*        int.c:2515 */
#define   EINT216      (ERRINT +  216)    /*        int.c:2564 */
#define   EINT217      (ERRINT +  217)    /*        int.c:2565 */
#define   EINT218      (ERRINT +  218)    /*        int.c:2566 */
#define   EINT219      (ERRINT +  219)    /*        int.c:2567 */
#define   EINT220      (ERRINT +  220)    /*        int.c:2623 */
#define   EINT221      (ERRINT +  221)    /*        int.c:2624 */
#define   EINT222      (ERRINT +  222)    /*        int.c:2625 */
#define   EINT223      (ERRINT +  223)    /*        int.c:2626 */
#define   EINT224      (ERRINT +  224)    /*        int.c:2627 */
#define   EINT225      (ERRINT +  225)    /*        int.c:2628 */
#define   EINT226      (ERRINT +  226)    /*        int.c:2629 */
#define   EINT227      (ERRINT +  227)    /*        int.c:2674 */
#define   EINT228      (ERRINT +  228)    /*        int.c:2675 */
#define   EINT229      (ERRINT +  229)    /*        int.c:2676 */
#define   EINT230      (ERRINT +  230)    /*        int.c:2677 */
#define   EINT231      (ERRINT +  231)    /*        int.c:2726 */
#define   EINT232      (ERRINT +  232)    /*        int.c:2727 */
#define   EINT233      (ERRINT +  233)    /*        int.c:2728 */
#define   EINT234      (ERRINT +  234)    /*        int.c:2729 */
#define   EINT235      (ERRINT +  235)    /*        int.c:2773 */
#define   EINT236      (ERRINT +  236)    /*        int.c:2774 */
#define   EINT237      (ERRINT +  237)    /*        int.c:2775 */
#define   EINT238      (ERRINT +  238)    /*        int.c:2776 */
#define   EINT239      (ERRINT +  239)    /*        int.c:2823 */
#define   EINT240      (ERRINT +  240)    /*        int.c:2824 */
#define   EINT241      (ERRINT +  241)    /*        int.c:2825 */
#define   EINT242      (ERRINT +  242)    /*        int.c:2826 */
#define   EINT243      (ERRINT +  243)    /*        int.c:2827 */
#define   EINT244      (ERRINT +  244)    /*        int.c:2875 */
#define   EINT245      (ERRINT +  245)    /*        int.c:2876 */
#define   EINT246      (ERRINT +  246)    /*        int.c:2877 */
#define   EINT247      (ERRINT +  247)    /*        int.c:2878 */
#define   EINT248      (ERRINT +  248)    /*        int.c:2879 */
#define   EINT249      (ERRINT +  249)    /*        int.c:2927 */
#define   EINT250      (ERRINT +  250)    /*        int.c:2928 */
#define   EINT251      (ERRINT +  251)    /*        int.c:2929 */
#define   EINT252      (ERRINT +  252)    /*        int.c:2930 */
#define   EINT253      (ERRINT +  253)    /*        int.c:2931 */
#define   EINT254      (ERRINT +  254)    /*        int.c:2980 */
#define   EINT255      (ERRINT +  255)    /*        int.c:2981 */
#define   EINT256      (ERRINT +  256)    /*        int.c:2982 */
#define   EINT257      (ERRINT +  257)    /*        int.c:2983 */
#define   EINT258      (ERRINT +  258)    /*        int.c:2984 */
#define   EINT259      (ERRINT +  259)    /*        int.c:3029 */
#define   EINT260      (ERRINT +  260)    /*        int.c:3030 */
#define   EINT261      (ERRINT +  261)    /*        int.c:3031 */
#define   EINT262      (ERRINT +  262)    /*        int.c:3032 */
#define   EINT263      (ERRINT +  263)    /*        int.c:3033 */
#define   EINT264      (ERRINT +  264)    /*        int.c:3085 */
#define   EINT265      (ERRINT +  265)    /*        int.c:3086 */
#define   EINT266      (ERRINT +  266)    /*        int.c:3087 */
#define   EINT267      (ERRINT +  267)    /*        int.c:3088 */
#define   EINT268      (ERRINT +  268)    /*        int.c:3089 */
#define   EINT269      (ERRINT +  269)    /*        int.c:3090 */
#define   EINT270      (ERRINT +  270)    /*        int.c:3134 */
#define   EINT271      (ERRINT +  271)    /*        int.c:3135 */
#define   EINT272      (ERRINT +  272)    /*        int.c:3136 */
#define   EINT273      (ERRINT +  273)    /*        int.c:3137 */
#define   EINT274      (ERRINT +  274)    /*        int.c:3181 */
#define   EINT275      (ERRINT +  275)    /*        int.c:3182 */
#define   EINT276      (ERRINT +  276)    /*        int.c:3183 */
#define   EINT277      (ERRINT +  277)    /*        int.c:3184 */
#define   EINT278      (ERRINT +  278)    /*        int.c:3229 */
#define   EINT279      (ERRINT +  279)    /*        int.c:3230 */
#define   EINT280      (ERRINT +  280)    /*        int.c:3231 */
#define   EINT281      (ERRINT +  281)    /*        int.c:3232 */
#define   EINT282      (ERRINT +  282)    /*        int.c:3282 */
#define   EINT283      (ERRINT +  283)    /*        int.c:3283 */
#define   EINT284      (ERRINT +  284)    /*        int.c:3284 */
#define   EINT285      (ERRINT +  285)    /*        int.c:3285 */
#define   EINT286      (ERRINT +  286)    /*        int.c:3286 */
#define   EINT287      (ERRINT +  287)    /*        int.c:3334 */
#define   EINT288      (ERRINT +  288)    /*        int.c:3335 */
#define   EINT289      (ERRINT +  289)    /*        int.c:3336 */
#define   EINT290      (ERRINT +  290)    /*        int.c:3337 */
#define   EINT291      (ERRINT +  291)    /*        int.c:3338 */
#define   EINT292      (ERRINT +  292)    /*        int.c:3385 */
#define   EINT293      (ERRINT +  293)    /*        int.c:3386 */
#define   EINT294      (ERRINT +  294)    /*        int.c:3387 */
#define   EINT295      (ERRINT +  295)    /*        int.c:3388 */
#define   EINT296      (ERRINT +  296)    /*        int.c:3389 */
#define   EINT297      (ERRINT +  297)    /*        int.c:3435 */
#define   EINT298      (ERRINT +  298)    /*        int.c:3436 */
#define   EINT299      (ERRINT +  299)    /*        int.c:3437 */
#define   EINT300      (ERRINT +  300)    /*        int.c:3438 */
#define   EINT301      (ERRINT +  301)    /*        int.c:3439 */
#define   EINT302      (ERRINT +  302)    /*        int.c:3485 */
#define   EINT303      (ERRINT +  303)    /*        int.c:3486 */
#define   EINT304      (ERRINT +  304)    /*        int.c:3487 */
#define   EINT305      (ERRINT +  305)    /*        int.c:3488 */
#define   EINT306      (ERRINT +  306)    /*        int.c:3542 */
#define   EINT307      (ERRINT +  307)    /*        int.c:3543 */
#define   EINT308      (ERRINT +  308)    /*        int.c:3544 */
#define   EINT309      (ERRINT +  309)    /*        int.c:3545 */
#define   EINT310      (ERRINT +  310)    /*        int.c:3546 */
#define   EINT311      (ERRINT +  311)    /*        int.c:3547 */
#define   EINT312      (ERRINT +  312)    /*        int.c:3593 */
#define   EINT313      (ERRINT +  313)    /*        int.c:3594 */
#define   EINT314      (ERRINT +  314)    /*        int.c:3595 */
#define   EINT315      (ERRINT +  315)    /*        int.c:3637 */
#define   EINT316      (ERRINT +  316)    /*        int.c:3638 */
#define   EINT317      (ERRINT +  317)    /*        int.c:3639 */
#define   EINT318      (ERRINT +  318)    /*        int.c:3686 */
#define   EINT319      (ERRINT +  319)    /*        int.c:3687 */
#define   EINT320      (ERRINT +  320)    /*        int.c:3688 */
#define   EINT321      (ERRINT +  321)    /*        int.c:3689 */
#define   EINT322      (ERRINT +  322)    /*        int.c:3734 */
#define   EINT323      (ERRINT +  323)    /*        int.c:3735 */
#define   EINT324      (ERRINT +  324)    /*        int.c:3736 */
#define   EINT325      (ERRINT +  325)    /*        int.c:3737 */
#define   EINT326      (ERRINT +  326)    /*        int.c:9802 */
#define   EINT327      (ERRINT +  327)    /*        int.c:9803 */
#define   EINT328      (ERRINT +  328)    /*        int.c:9846 */
#define   EINT329      (ERRINT +  329)    /*        int.c:9847 */
#define   EINT330      (ERRINT +  330)    /*        int.c:9888 */
#define   EINT331      (ERRINT +  331)    /*        int.c:9889 */
#define   EINT332      (ERRINT +  332)    /*        int.c:9937 */
#define   EINT333      (ERRINT +  333)    /*        int.c:9938 */
#define   EINT334      (ERRINT +  334)    /*        int.c:9939 */
#define   EINT335      (ERRINT +  335)    /*        int.c:9940 */
#define   EINT336      (ERRINT +  336)    /*        int.c:9941 */
#define   EINT337      (ERRINT +  337)    /*        int.c:9988 */
#define   EINT338      (ERRINT +  338)    /*        int.c:9989 */
#define   EINT339      (ERRINT +  339)    /*        int.c:9990 */
#define   EINT340      (ERRINT +  340)    /*        int.c:9991 */
#define   EINT341      (ERRINT +  341)    /*        int.c:9992 */
#define   EINT342      (ERRINT +  342)    /*        int.c:9993 */
#define   EINT343      (ERRINT +  343)    /*        int.c:10044 */
#define   EINT344      (ERRINT +  344)    /*        int.c:10045 */
#define   EINT345      (ERRINT +  345)    /*        int.c:10046 */
#define   EINT346      (ERRINT +  346)    /*        int.c:10047 */
#define   EINT347      (ERRINT +  347)    /*        int.c:10048 */
#define   EINT348      (ERRINT +  348)    /*        int.c:10049 */
#define   EINT349      (ERRINT +  349)    /*        int.c:10050 */
#define   EINT350      (ERRINT +  350)    /*        int.c:10099 */
#define   EINT351      (ERRINT +  351)    /*        int.c:10100 */
#define   EINT352      (ERRINT +  352)    /*        int.c:10101 */
#define   EINT353      (ERRINT +  353)    /*        int.c:10102 */
#define   EINT354      (ERRINT +  354)    /*        int.c:10103 */
#define   EINT355      (ERRINT +  355)    /*        int.c:10104 */
#define   EINT356      (ERRINT +  356)    /*        int.c:10152 */
#define   EINT357      (ERRINT +  357)    /*        int.c:10153 */
#define   EINT358      (ERRINT +  358)    /*        int.c:10154 */
#define   EINT359      (ERRINT +  359)    /*        int.c:10155 */
#define   EINT360      (ERRINT +  360)    /*        int.c:10201 */
#define   EINT361      (ERRINT +  361)    /*        int.c:10202 */
#define   EINT362      (ERRINT +  362)    /*        int.c:10203 */
#define   EINT363      (ERRINT +  363)    /*        int.c:10204 */
#define   EINT364      (ERRINT +  364)    /*        int.c:10248 */
#define   EINT365      (ERRINT +  365)    /*        int.c:10249 */
#define   EINT366      (ERRINT +  366)    /*        int.c:10250 */
#define   EINT367      (ERRINT +  367)    /*        int.c:10251 */
#define   EINT368      (ERRINT +  368)    /*        int.c:10252 */
#define   EINT369      (ERRINT +  369)    /*        int.c:10297 */
#define   EINT370      (ERRINT +  370)    /*        int.c:10298 */
#define   EINT371      (ERRINT +  371)    /*        int.c:10299 */
#define   EINT372      (ERRINT +  372)    /*        int.c:10300 */
#define   EINT373      (ERRINT +  373)    /*        int.c:10301 */
#define   EINT374      (ERRINT +  374)    /*        int.c:10348 */
#define   EINT375      (ERRINT +  375)    /*        int.c:10349 */
#define   EINT376      (ERRINT +  376)    /*        int.c:10350 */
#define   EINT377      (ERRINT +  377)    /*        int.c:10351 */
#define   EINT378      (ERRINT +  378)    /*        int.c:10352 */
#define   EINT379      (ERRINT +  379)    /*        int.c:10353 */
#define   EINT380      (ERRINT +  380)    /*        int.c:10354 */
#define   EINT381      (ERRINT +  381)    /*        int.c:10400 */
#define   EINT382      (ERRINT +  382)    /*        int.c:10401 */
#define   EINT383      (ERRINT +  383)    /*        int.c:10402 */
#define   EINT384      (ERRINT +  384)    /*        int.c:10403 */
#define   EINT385      (ERRINT +  385)    /*        int.c:10404 */
#define   EINT386      (ERRINT +  386)    /*        int.c:10450 */
#define   EINT387      (ERRINT +  387)    /*        int.c:10451 */
#define   EINT388      (ERRINT +  388)    /*        int.c:10452 */
#define   EINT389      (ERRINT +  389)    /*        int.c:10453 */
#define   EINT390      (ERRINT +  390)    /*        int.c:10454 */
#define   EINT391      (ERRINT +  391)    /*        int.c:10500 */
#define   EINT392      (ERRINT +  392)    /*        int.c:10501 */
#define   EINT393      (ERRINT +  393)    /*        int.c:10502 */
#define   EINT394      (ERRINT +  394)    /*        int.c:10503 */
#define   EINT395      (ERRINT +  395)    /*        int.c:10553 */
#define   EINT396      (ERRINT +  396)    /*        int.c:10554 */
#define   EINT397      (ERRINT +  397)    /*        int.c:10555 */
#define   EINT398      (ERRINT +  398)    /*        int.c:10558 */
#define   EINT399      (ERRINT +  399)    /*        int.c:10560 */
#define   EINT400      (ERRINT +  400)    /*        int.c:10618 */
#define   EINT401      (ERRINT +  401)    /*        int.c:10619 */
#define   EINT402      (ERRINT +  402)    /*        int.c:10620 */
#define   EINT403      (ERRINT +  403)    /*        int.c:10621 */
#define   EINT404      (ERRINT +  404)    /*        int.c:10622 */
#define   EINT405      (ERRINT +  405)    /*        int.c:10623 */
#define   EINT406      (ERRINT +  406)    /*        int.c:10624 */
#define   EINT407      (ERRINT +  407)    /*        int.c:10673 */
#define   EINT408      (ERRINT +  408)    /*        int.c:10674 */
#define   EINT409      (ERRINT +  409)    /*        int.c:10675 */
#define   EINT410      (ERRINT +  410)    /*        int.c:10676 */
#define   EINT411      (ERRINT +  411)    /*        int.c:10723 */
#define   EINT412      (ERRINT +  412)    /*        int.c:10724 */
#define   EINT413      (ERRINT +  413)    /*        int.c:10725 */
#define   EINT414      (ERRINT +  414)    /*        int.c:10726 */
#define   EINT415      (ERRINT +  415)    /*        int.c:10727 */
#define   EINT416      (ERRINT +  416)    /*        int.c:10773 */
#define   EINT417      (ERRINT +  417)    /*        int.c:10774 */
#define   EINT418      (ERRINT +  418)    /*        int.c:10775 */
#define   EINT419      (ERRINT +  419)    /*        int.c:10776 */
#define   EINT420      (ERRINT +  420)    /*        int.c:10823 */
#define   EINT421      (ERRINT +  421)    /*        int.c:10824 */
#define   EINT422      (ERRINT +  422)    /*        int.c:10825 */
#define   EINT423      (ERRINT +  423)    /*        int.c:10826 */
#define   EINT424      (ERRINT +  424)    /*        int.c:10827 */
#define   EINT425      (ERRINT +  425)    /*        int.c:10877 */
#define   EINT426      (ERRINT +  426)    /*        int.c:10878 */
#define   EINT427      (ERRINT +  427)    /*        int.c:10879 */
#define   EINT428      (ERRINT +  428)    /*        int.c:10880 */
#define   EINT429      (ERRINT +  429)    /*        int.c:10881 */
#define   EINT430      (ERRINT +  430)    /*        int.c:10882 */
#define   EINT431      (ERRINT +  431)    /*        int.c:10930 */
#define   EINT432      (ERRINT +  432)    /*        int.c:10931 */
#define   EINT433      (ERRINT +  433)    /*        int.c:10932 */
#define   EINT434      (ERRINT +  434)    /*        int.c:10933 */
#define   EINT435      (ERRINT +  435)    /*        int.c:10934 */
#define   EINT436      (ERRINT +  436)    /*        int.c:10982 */
#define   EINT437      (ERRINT +  437)    /*        int.c:10983 */
#define   EINT438      (ERRINT +  438)    /*        int.c:10984 */
#define   EINT439      (ERRINT +  439)    /*        int.c:10985 */
#define   EINT440      (ERRINT +  440)    /*        int.c:11031 */
#define   EINT441      (ERRINT +  441)    /*        int.c:11032 */
#define   EINT442      (ERRINT +  442)    /*        int.c:11033 */
#define   EINT443      (ERRINT +  443)    /*        int.c:11034 */
#define   EINT444      (ERRINT +  444)    /*        int.c:11078 */
#define   EINT445      (ERRINT +  445)    /*        int.c:11079 */
#define   EINT446      (ERRINT +  446)    /*        int.c:11080 */
#define   EINT447      (ERRINT +  447)    /*        int.c:11081 */
#define   EINT448      (ERRINT +  448)    /*        int.c:11082 */
#define   EINT449      (ERRINT +  449)    /*        int.c:11127 */
#define   EINT450      (ERRINT +  450)    /*        int.c:11128 */
#define   EINT451      (ERRINT +  451)    /*        int.c:11129 */
#define   EINT452      (ERRINT +  452)    /*        int.c:11130 */
#define   EINT453      (ERRINT +  453)    /*        int.c:11131 */
#define   EINT454      (ERRINT +  454)    /*        int.c:11177 */
#define   EINT455      (ERRINT +  455)    /*        int.c:11178 */
#define   EINT456      (ERRINT +  456)    /*        int.c:11179 */
#define   EINT457      (ERRINT +  457)    /*        int.c:11180 */
#define   EINT458      (ERRINT +  458)    /*        int.c:11181 */
#define   EINT459      (ERRINT +  459)    /*        int.c:11182 */
#define   EINT460      (ERRINT +  460)    /*        int.c:11228 */
#define   EINT461      (ERRINT +  461)    /*        int.c:11229 */
#define   EINT462      (ERRINT +  462)    /*        int.c:11230 */
#define   EINT463      (ERRINT +  463)    /*        int.c:11231 */
#define   EINT464      (ERRINT +  464)    /*        int.c:11232 */
#define   EINT465      (ERRINT +  465)    /*        int.c:11278 */
#define   EINT466      (ERRINT +  466)    /*        int.c:11279 */
#define   EINT467      (ERRINT +  467)    /*        int.c:11280 */
#define   EINT468      (ERRINT +  468)    /*        int.c:11281 */
#define   EINT469      (ERRINT +  469)    /*        int.c:11282 */
#define   EINT470      (ERRINT +  470)    /*        int.c:11328 */
#define   EINT471      (ERRINT +  471)    /*        int.c:11329 */
#define   EINT472      (ERRINT +  472)    /*        int.c:11330 */
#define   EINT473      (ERRINT +  473)    /*        int.c:11331 */
#define   EINT474      (ERRINT +  474)    /*        int.c:11375 */
#define   EINT475      (ERRINT +  475)    /*        int.c:11376 */
#define   EINT476      (ERRINT +  476)    /*        int.c:11377 */
#define   EINT477      (ERRINT +  477)    /*        int.c:11378 */
#define   EINT478      (ERRINT +  478)    /*        int.c:11427 */
#define   EINT479      (ERRINT +  479)    /*        int.c:11428 */
#define   EINT480      (ERRINT +  480)    /*        int.c:11429 */
#define   EINT481      (ERRINT +  481)    /*        int.c:11430 */
#define   EINT482      (ERRINT +  482)    /*        int.c:11431 */
#define   EINT483      (ERRINT +  483)    /*        int.c:11432 */
#define   EINT484      (ERRINT +  484)    /*        int.c:11480 */
#define   EINT485      (ERRINT +  485)    /*        int.c:11481 */
#define   EINT486      (ERRINT +  486)    /*        int.c:11482 */
#define   EINT487      (ERRINT +  487)    /*        int.c:11528 */
#define   EINT488      (ERRINT +  488)    /*        int.c:11529 */
#define   EINT489      (ERRINT +  489)    /*        int.c:11530 */
#define   EINT490      (ERRINT +  490)    /*        int.c:11531 */
#define   EINT491      (ERRINT +  491)    /*        int.c:11583 */
#define   EINT492      (ERRINT +  492)    /*        int.c:11584 */
#define   EINT493      (ERRINT +  493)    /*        int.c:11585 */
#define   EINT494      (ERRINT +  494)    /*        int.c:11586 */
#define   EINT495      (ERRINT +  495)    /*        int.c:11587 */
#define   EINT496      (ERRINT +  496)    /*        int.c:11588 */
#define   EINT497      (ERRINT +  497)    /*        int.c:11633 */
#define   EINT498      (ERRINT +  498)    /*        int.c:11634 */
#define   EINT499      (ERRINT +  499)    /*        int.c:11635 */
#define   EINT500      (ERRINT +  500)    /*        int.c:11636 */
#define   EINT501      (ERRINT +  501)    /*        int.c:11637 */
#define   EINT502      (ERRINT +  502)    /*        int.c:11638 */
#define   EINT503      (ERRINT +  503)    /*        int.c:11686 */
#define   EINT504      (ERRINT +  504)    /*        int.c:11687 */
#define   EINT505      (ERRINT +  505)    /*        int.c:11688 */
#define   EINT506      (ERRINT +  506)    /*        int.c:11689 */
#define   EINT507      (ERRINT +  507)    /*        int.c:11690 */
#define   EINT508      (ERRINT +  508)    /*        int.c:11691 */
#define   EINT509      (ERRINT +  509)    /*        int.c:11692 */
#define   EINT510      (ERRINT +  510)    /*        int.c:11737 */
#define   EINT511      (ERRINT +  511)    /*        int.c:11738 */
#define   EINT512      (ERRINT +  512)    /*        int.c:11739 */
#define   EINT513      (ERRINT +  513)    /*        int.c:11740 */
#define   EINT514      (ERRINT +  514)    /*        int.c:11786 */
#define   EINT515      (ERRINT +  515)    /*        int.c:11787 */
#define   EINT516      (ERRINT +  516)    /*        int.c:11788 */
#define   EINT517      (ERRINT +  517)    /*        int.c:11789 */
#define   EINT518      (ERRINT +  518)    /*        int.c:11835 */
#define   EINT519      (ERRINT +  519)    /*        int.c:11836 */
#define   EINT520      (ERRINT +  520)    /*        int.c:11837 */
#define   EINT521      (ERRINT +  521)    /*        int.c:11838 */
#define   EINT522      (ERRINT +  522)    /*        int.c:11883 */
#define   EINT523      (ERRINT +  523)    /*        int.c:11884 */
#define   EINT524      (ERRINT +  524)    /*        int.c:11885 */
#define   EINT525      (ERRINT +  525)    /*        int.c:11886 */
#define   EINT526      (ERRINT +  526)    /*        int.c:11931 */
#define   EINT527      (ERRINT +  527)    /*        int.c:11932 */
#define   EINT528      (ERRINT +  528)    /*        int.c:11933 */
#define   EINT529      (ERRINT +  529)    /*        int.c:11934 */
#define   EINT530      (ERRINT +  530)    /*        int.c:11935 */
#define   EINT531      (ERRINT +  531)    /*        int.c:11981 */
#define   EINT532      (ERRINT +  532)    /*        int.c:11982 */
#define   EINT533      (ERRINT +  533)    /*        int.c:11983 */
#define   EINT534      (ERRINT +  534)    /*        int.c:11984 */
#define   EINT535      (ERRINT +  535)    /*        int.c:11985 */
#define   EINT536      (ERRINT +  536)    /*        int.c:12031 */
#define   EINT537      (ERRINT +  537)    /*        int.c:12032 */
#define   EINT538      (ERRINT +  538)    /*        int.c:12033 */
#define   EINT539      (ERRINT +  539)    /*        int.c:12034 */
#define   EINT540      (ERRINT +  540)    /*        int.c:12035 */
#define   EINT541      (ERRINT +  541)    /*        int.c:12081 */
#define   EINT542      (ERRINT +  542)    /*        int.c:12082 */
#define   EINT543      (ERRINT +  543)    /*        int.c:12083 */
#define   EINT544      (ERRINT +  544)    /*        int.c:12084 */
#define   EINT545      (ERRINT +  545)    /*        int.c:12085 */
#define   EINT546      (ERRINT +  546)    /*        int.c:12135 */
#define   EINT547      (ERRINT +  547)    /*        int.c:12136 */
#define   EINT548      (ERRINT +  548)    /*        int.c:12137 */
#define   EINT549      (ERRINT +  549)    /*        int.c:12138 */
#define   EINT550      (ERRINT +  550)    /*        int.c:12139 */
#define   EINT551      (ERRINT +  551)    /*        int.c:12140 */
#define   EINT552      (ERRINT +  552)    /*        int.c:12141 */
#define   EINT553      (ERRINT +  553)    /*        int.c:12187 */
#define   EINT554      (ERRINT +  554)    /*        int.c:12188 */
#define   EINT555      (ERRINT +  555)    /*        int.c:12189 */
#define   EINT556      (ERRINT +  556)    /*        int.c:12190 */
#define   EINT557      (ERRINT +  557)    /*        int.c:12235 */
#define   EINT558      (ERRINT +  558)    /*        int.c:12236 */
#define   EINT559      (ERRINT +  559)    /*        int.c:12237 */
#define   EINT560      (ERRINT +  560)    /*        int.c:12238 */
#define   EINT561      (ERRINT +  561)    /*        int.c:12283 */
#define   EINT562      (ERRINT +  562)    /*        int.c:12284 */
#define   EINT563      (ERRINT +  563)    /*        int.c:12285 */
#define   EINT564      (ERRINT +  564)    /*        int.c:12286 */
#define   EINT565      (ERRINT +  565)    /*        int.c:12287 */
#define   EINT566      (ERRINT +  566)    /*        int.c:12330 */
#define   EINT567      (ERRINT +  567)    /*        int.c:12331 */
#define   EINT568      (ERRINT +  568)    /*        int.c:12332 */
#define   EINT569      (ERRINT +  569)    /*        int.c:12333 */
#define   EINT570      (ERRINT +  570)    /*        int.c:12334 */
#define   EINT571      (ERRINT +  571)    /*        int.c:12377 */
#define   EINT572      (ERRINT +  572)    /*        int.c:12378 */
#define   EINT573      (ERRINT +  573)    /*        int.c:12379 */
#define   EINT574      (ERRINT +  574)    /*        int.c:12380 */
#define   EINT575      (ERRINT +  575)    /*        int.c:12381 */
#define   EINT576      (ERRINT +  576)    /*        int.c:12429 */
#define   EINT577      (ERRINT +  577)    /*        int.c:12430 */
#define   EINT578      (ERRINT +  578)    /*        int.c:12431 */
#define   EINT579      (ERRINT +  579)    /*        int.c:12432 */
#define   EINT580      (ERRINT +  580)    /*        int.c:12433 */
#define   EINT581      (ERRINT +  581)    /*        int.c:12477 */
#define   EINT582      (ERRINT +  582)    /*        int.c:12478 */
#define   EINT583      (ERRINT +  583)    /*        int.c:12479 */
#define   EINT584      (ERRINT +  584)    /*        int.c:12480 */
#define   EINT585      (ERRINT +  585)    /*        int.c:12481 */
#define   EINT586      (ERRINT +  586)    /*        int.c:12528 */
#define   EINT587      (ERRINT +  587)    /*        int.c:12529 */
#define   EINT588      (ERRINT +  588)    /*        int.c:12530 */
#define   EINT589      (ERRINT +  589)    /*        int.c:12531 */
#define   EINT590      (ERRINT +  590)    /*        int.c:12532 */
#define   EINT591      (ERRINT +  591)    /*        int.c:12533 */
#define   EINT592      (ERRINT +  592)    /*        int.c:12578 */
#define   EINT593      (ERRINT +  593)    /*        int.c:12579 */
#define   EINT594      (ERRINT +  594)    /*        int.c:12580 */
#define   EINT595      (ERRINT +  595)    /*        int.c:12581 */
#define   EINT596      (ERRINT +  596)    /*        int.c:12627 */
#define   EINT597      (ERRINT +  597)    /*        int.c:12628 */
#define   EINT598      (ERRINT +  598)    /*        int.c:12629 */
#define   EINT599      (ERRINT +  599)    /*        int.c:12630 */
#define   EINT600      (ERRINT +  600)    /*        int.c:12676 */
#define   EINT601      (ERRINT +  601)    /*        int.c:12677 */
#define   EINT602      (ERRINT +  602)    /*        int.c:12678 */
#define   EINT603      (ERRINT +  603)    /*        int.c:12679 */
#define   EINT604      (ERRINT +  604)    /*        int.c:12724 */
#define   EINT605      (ERRINT +  605)    /*        int.c:12725 */
#define   EINT606      (ERRINT +  606)    /*        int.c:12726 */
#define   EINT607      (ERRINT +  607)    /*        int.c:12727 */
#define   EINT608      (ERRINT +  608)    /*        int.c:12772 */
#define   EINT609      (ERRINT +  609)    /*        int.c:12773 */
#define   EINT610      (ERRINT +  610)    /*        int.c:12774 */
#define   EINT611      (ERRINT +  611)    /*        int.c:12775 */
#define   EINT612      (ERRINT +  612)    /*        int.c:12776 */
#define   EINT613      (ERRINT +  613)    /*        int.c:12822 */
#define   EINT614      (ERRINT +  614)    /*        int.c:12823 */
#define   EINT615      (ERRINT +  615)    /*        int.c:12824 */
#define   EINT616      (ERRINT +  616)    /*        int.c:12825 */
#define   EINT617      (ERRINT +  617)    /*        int.c:12826 */
#define   EINT618      (ERRINT +  618)    /*        int.c:12872 */
#define   EINT619      (ERRINT +  619)    /*        int.c:12873 */
#define   EINT620      (ERRINT +  620)    /*        int.c:12874 */
#define   EINT621      (ERRINT +  621)    /*        int.c:12875 */
#define   EINT622      (ERRINT +  622)    /*        int.c:12876 */
#define   EINT623      (ERRINT +  623)    /*        int.c:12922 */
#define   EINT624      (ERRINT +  624)    /*        int.c:12923 */
#define   EINT625      (ERRINT +  625)    /*        int.c:12924 */
#define   EINT626      (ERRINT +  626)    /*        int.c:12925 */
#define   EINT627      (ERRINT +  627)    /*        int.c:12926 */
#define   EINT628      (ERRINT +  628)    /*        int.c:12975 */
#define   EINT629      (ERRINT +  629)    /*        int.c:12976 */
#define   EINT630      (ERRINT +  630)    /*        int.c:12977 */
#define   EINT631      (ERRINT +  631)    /*        int.c:12978 */
#define   EINT632      (ERRINT +  632)    /*        int.c:12979 */
#define   EINT633      (ERRINT +  633)    /*        int.c:12980 */
#define   EINT634      (ERRINT +  634)    /*        int.c:13025 */
#define   EINT635      (ERRINT +  635)    /*        int.c:13026 */
#define   EINT636      (ERRINT +  636)    /*        int.c:13027 */
#define   EINT637      (ERRINT +  637)    /*        int.c:13071 */
#define   EINT638      (ERRINT +  638)    /*        int.c:13072 */
#define   EINT639      (ERRINT +  639)    /*        int.c:13073 */
#define   EINT640      (ERRINT +  640)    /*        int.c:13117 */
#define   EINT641      (ERRINT +  641)    /*        int.c:13118 */
#define   EINT642      (ERRINT +  642)    /*        int.c:13119 */
#define   EINT643      (ERRINT +  643)    /*        int.c:13120 */

#endif /* __INTH__ */

  
/********************************************************************30**
  
         End of file:     int.h@@/main/25 - Wed May 23 17:06:45 2001
  
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************70**
  
  version    initials                   description
-----------  ---------  ------------------------------------------------
1.1.0.0         lc      1. initial release.

1.2.0.0         lc      1. add event types
                        2. add information transfer rate
                        3. add symmetry
                        4. add locking shift codeset values

1.3.0.0         lc      1. add intermediate rate
                        2. add maximum repeat elements

1.4.0.0         lc      1. add and remove some defines for organizational
                           reasons
                        2. text changes

1.5.0.0         lc      1. change value of PD_IBAVAIL from 0x05 to 0x08

1.6             lc      1. added new defines for NT DMS-100 Basic and
                           Primary
                lc      2. added new defines for VN3 switch
                lc      3. added new defines for ATT5E Basic interface
                jrl     4. trillium development system checkpoint (dvs)
                           at version: 1.5.0.0

1.7             lc      1. add NMB_MSG (removed from in.h)
                        2. add NB_PRIM (removed from in.h)
                        3. add IN_PM_xxx (removed from in.h)
                        4. add MF_xxx
                        5. add INDTP_TOTCHG

1.8             bn      1. removed MF_UNK, MF_CKT, MF_PKT and MF_UTU
                           flags.

1.9             bn      1. added DCH_INSIGNIF.
                        2. added defines for tr6 specific elements.
                        3. added defines for aus tel values.

*********************************************************************71*/

/********************************************************************80**

  version    pat  init                   description
----------- ----- ----  ------------------------------------------------
1.10         ---  jrl   1. text changes

1.11         ---  bn    1. moved defines for reason for redirection, 
                           screening and presentation indicators to lm_pt.h
             ---  bn    2. removed duplication of eventType for NCnStReq,
                           NCnStInd, NSsHlRsp, NRmRtRsp.

1.12         ---  bn    1. moved defines for configuration parameters
                           to lm_pt.h

1.13         ---  rg    1. added new cause codes for etsi.

1.14         ---  rg    1. added support for Facility message.

1.15         ---  rg    1. added NMB_ALLMSG definition to account for
                           Facility related messages in decoding msg headers.

1.16         ---  bn    1. add support for tr 303 tmc.

1.17         ---  bn    1. add defines for LNK_UP and LNK_DWN.

1.18         ---  bn    1. adjusted number of messages for Q932.

1.19         ---  bn    1. added define for PD_N0 protocol discriminator.

3.1          ---  bn    1. Changed interfaces 
             ---  bn    2. changed layer manager interface.
             ---  bn    3. added support for NI2.
             ---  bn    4. added support for ETSI QSIG.

3.2          ---  bn    1. changed NMB_MSG, NMB_ALLMSG.

3.3          ---  bn    1. added define for  LNK_DWN_DM_RLS.


*********************************************************************81*/
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
3.4          ---      sb   1. Miscellaneous changes.

3.5          ---      sb   1. Added constants for QSIG information transfer
                             types.
             ---      sb   2. Added constants for QSIG protocol profiles.
             ---      sb   3. Added constantd for facility event.
             ---      sb   4. Added Event Constant for Setup Complete Req.

3.6          ---      pk   1. Added constants currently included in cm_isdn.h 

3.7          ---      sam  1. Added defines for Display IE for DMS 100 and
                              MCI variants.
             ---      sam  2. Added define SD_TCAP for facility IE in NT 
             ---           3. Added constants for DMS 100, MCI, DMS 250 and
                              sprint supplementary services.
             ---      sam  4. Text Changes - comments etc.
             ---      sam  5. Added MF_MAX_IE for supporting 4 cause, 
                              progress indicator and n/w specific facilities.
                              Not changed for Q.SIG or INTR6.
             ---      sam  6. Added defines for type of routing and 
                              origination/destination, options, reason
                              for return.
             ---      sb   7. Text changes

3.8          ---      pk   1. Added defines for Control Type for
                              NTSPRINT.
                      pk   2. Added MF_MAX_FACIE constant.

             ---      pk   3. Added IN_CMT_ATMVCC. 

3.9          ---      pk   1. Changed EVTINTSTAENQREQ and EVTINTSTAENQCFM
                              to EVTINTSTAREQ and EVTINTSTACFM 
                              respectively.
                           2. Added SWCHD_BU_DCHAN.
           in005.310  cy   3. Added IN_CS_PERMSIGN_MSK.
           in013.310  cy   4. Corrected IN_MP_SRVSTATE.
/main/25     ---      cy   1. Updated for new release.
           in005.311  cr   1. Updated for RQST00000016390

*********************************************************************91*/

