#ifndef __ENVOPTH__
#define __ENVOPTH__

#if defined(WIN32) || defined(__WINDOWS__)
#include <windows.h>
typedef unsigned __int64 uint64_t;
typedef unsigned __int32 uint32_t;
typedef unsigned __int16 uint16_t;
typedef unsigned __int8 uint8_t;
typedef __int64 int64_t;
typedef __int32 int32_t;
typedef __int16 int16_t;
typedef __int8 int8_t;
#define usleep(x) Sleep(x)
#define sleep(x) usleep(x)
/* FIXME hack to compile under win32 */
#define FIXME_DECLARE(type) __declspec(dllexport) type __stdcall
#else
#include <stdio.h>
#include <stdint.h>
#include <stdarg.h>
#define FIXME_DECLARE(type) type
#endif

/* added the defines here to make the compile lines shorter */
#define ANSI

#ifdef WIN32
#define NS
#define NU
#define STDIO_INCLD
#define BIT_64 /* without this, SGetEpcTime won't be included */
#define NS_ENB_MGMT /* without this, ns_task.c won't compile */
#else /* WIN32 */
#define SUNOS
#define SS_LINUX 
#define SS_MT 
#endif /* WIN32 */

/* DAVIDY - Increase maximum length of called party to 32 digits */
#define CDPTYNMB_32DIGIT

/* DAVIDY - Disable the extended-bit in the Channel-Id IE */
#define SANGOMA_ISDN_CHAN_ID_INVERT_BIT

#define SS 
#define SLES9_PLUS
#define CMFILE_REORG_1

#define SM
#define LD
#define IN
#define L1
#define CC
#define AN
#define LAPD_3_4
#define BASEONE
#define SNG_INT_DEBUG

#define DEBUGNOEXIT 1

#if 0
#define CONAVL                  /* console availability option */
#else
#define NOCONAVL
#endif

/* defines */
/**************************************************************************
   general parameters
**************************************************************************/

#define LMINT3       /* interface 3 */

/* NOTE : LMINT3 flag MUST be turned-on if using PSF (FT/HA) for a protocol layer */

#define TDS_CORE2                   /*Trillium DFT/HA CORE architecture enabled */
/* #define TDS_ROLL_UPGRADE_SUPPORT    Rolling upgrade feature support enabled  */
                                    /*in Trillium DFT/HA CORE architecture   */
/* #define TDS_FTHA_CUST_PKUNPK  If using a heterogenous system in a DFT/HA env */


/* packing order, choose none or one */
/* #define FCSPKINT      forward compatibility, packing order */

#ifndef NS
# ifdef WINNT
#  define WINNT_IATM 1    /* for backward compatibility with Integrated ATM */
# endif/* NS */
#endif /* WINNT */

#define LCLM         /* loosely coupled, layer management */

#define INT2
#define DAT2 

#ifdef IN       /* Q.93x */
/**************************************************************************
   q.930/q.931 parameters
**************************************************************************/
/* product version, choose one */
#define ISDN_3_8_PLUS  /* Code version 3.10 & above */

/* enable ISDN_3_8_PLUS if INT2 is enabled */
#ifdef INT2 
# ifndef ISDN_3_8_PLUS
#  define ISDN_3_8_PLUS 
# endif 
#endif /* INT2 */

/*#define INT_OLD_DEFINES      use old defines in int.h */
/*#define LIN_OLD_DEFINES      use old defines in lin.h */

#define BDVER2
#define INVER2         /* isdn, version 2.x */
#define ANVER2         /* isdn, version 2.x */
#define L3VER2         /* isdn, version 2.x */
/* #define IN_OLD_BIND  Use Old Method for Binding */
#define IN_LMINT3 1      /* If this flag is enabled also enable SMIN_LMINT3 under ifdef SM */
/* interfaces */

/* upper interface, isdn network, choose none or more */
#define LCINUIINT      /*loosely coupled, isdn network layer */

/* lower interface, data link, choose none or more */
#define LCINLIDAT      /*loosely coupled, data link layer */

/* layer management interface */
#define LCINMILIN      /*loosely coupled, layer manager */

/* Q.931 upper interface */
#ifdef LCINUIINT
# ifndef LCINT
#  define LCINT  1
# endif /* LCINT */
#endif /* LCINUIINT */

/* Q.931 lower interface */
#ifdef LCINLIDAT
# ifndef LCDAT
#  define LCDAT  1
# endif /* LCDAT */
#endif /* LCINLIDAT */

/* Q.931 layer manager interface */
#ifdef LCINMILIN
# ifndef LCLIN
#  define LCLIN  1
# endif /* LCLIN */
#endif /* LCINMILIN */

#ifdef IN_LMINT3
# undef IN_LMINT3
# define IN_LMINT3 1
#endif /* IN_LMINT3 */

/* side, choose one or more */
/* must agree with options delivered */

#define USRSIDE       /*user side, option 1 or option 3 */
#define NETSIDE       /*network side, option 2 or option 3 */

/* Option for ITUT-88 standard - used in bearcapability encoding/decoding */
 
/* #define ITUT88      ITU-T 88 - for Bearer Capability */

/* switch variants, choose none or more */
/* must agree with options delivered */
/* if applicable, must agree with x.31, isup switch variants */

#define ATT 		/*att 4ess and 5ess, option 11 */
#define NT		/*northern telecomm dms-100, option 12 */
/*#define VN             vn 2 and vn 3, france, option 13 */
#define ETSI		/*etsi, europe, option 14 */ 
/*#define AUS            AUS, australian, option 15 */ 
/*#define NI1            national isdn 1, north america, option 16 */ 
#define NTT            	/*ins net, japan, option 17 */
/*#define INTR6          1 - TR6, german, option 18 */
#define ATT5E          	/*att 5ess, option 19 */
#define ATT4E          	/*att 4ess, option 20 */
/*#define VN2            vn 2, france, option 21 */
/*#define VN3            vn 3, france, option 22 */
/*#define NTDMS250       northern telecom dms-250, option 23 */
/*#define BC303          bellcore tr-303, tmc and csc, option 24 */
/*#define BC303TMC       bellcore tr-303, tmc , option 25 */
/*#define BC303CSC       bellcore tr-303, csc, option 26 */
#define Q932           	/*q.932 option, option 27 */
#define NI2            	/*national isdn 2, north america, option 28 */ 
#define QSIG           	/*etsi qsig, option 29 */
/*#define NTNI           nt ni, option 31 */
/*#define NTMCI          nt mci, option 32 */
/*#define NTSPRINT       nt dms-250 sprint */

/* variant, choose all */

#ifdef ATT              /* att */
# define ATT5E           /* att 5ess, option 19 */
# define ATT4E           /* att 4ess, option 20 */
#endif

#ifdef VN3              /* vn 3 */
# define VN              /* vn 2 and vn 3, france, option 13 */
#endif

#ifdef VN               /* vn */
# define VN2             /* vn 2, france, option 21 */
# define VN3             /* vn 3, france, option 22 */
#endif

#ifdef BC303            /* bellcore tr-303 */
# define BC303TMC        /* bellcore tr-303, tmc , option 25 */
# define BC303CSC        /* bellcore tr-303, csc, option 26 */
#endif

/* features, choose none or more */

/*#define ISDN_SEGMENT  1   message segmentation and reassembly option */
#define ISDN_BRI      1   /*basic rate interface option */
#define ISDN_PRI      1   /* primary rate interface option */
/*#define ISDN_ROUTE    1   routing procedures provided */
#define ISDN_OVERLAP  1  	/*overlap sending/receiving provided */
#define ISDN_UTU      1 	/* user to user procedures provided */
#define ISDN_FACILITY 1   /* facility procedures provided */
#define ISDN_SRV      1   /* service procedures provided */
#define ISDN_NFAS     1   /* nfas procedures provided */
/* #define ISDN_SUSPEND  1  */ /* suspend/resume procedures provided */
/* #define ISDN_HOLD     1  */ /* hold/retrieve procedures provided */
/*#define DECODCDSET    1   decode network and user specific codeset 6 and 7 */
                         /* elements into individual elements vs. string */
#define MF_IN         1  /* For MF purposes */

#ifdef NETSIDE 
# define ISDN_PTMPT    1  /* ISDN Point to Multipoint. */
#endif /* NETSIDE */

#ifdef Q932
# ifndef ISDN_HOLD
#  define ISDN_HOLD     1  /* hold procedures provided */
# endif
# ifndef ISDN_FACILITY
#  define ISDN_FACILITY 1  /* facility procedures provided */
# endif
#endif

#ifdef NI2
/*#define NI2_BCAS          NI2 B channel service procedure */
/*#define NI2_TREST         NI2 TREST timer */
/*#define IN_NW_NMB         pass network number (station id) to call control */
#endif 

/*#define ISDN_RLNK         send STATENQ msg after date link reestablishment */
#define ISDN_SNDRSTIND    /* send IntRstInd to layer 4 after recving RST msg */
/*#define IN_RSCIND         send resource indication to QW */
/*#define IN_INSRV_ALARM    send alarm to LM when a D chan becomes IN SRV */
/*#define IN_FTHA           Enables SHT interface for Q.930/Q.931 */

/* data link interface type, choose one */
/* if applicable, must agree with lapb, lapd, lapb and lapd, basic frame
   relay or extended frame relay data link interface type */

#define DATINT1      /* data link interface 1 */
/* #define DATINT2       data link interface 2 */

#endif /* IN */

#ifdef LD       /* lapd */
/**************************************************************************
   lapd parameters
**************************************************************************/

/* product version, choose one */

/* #define BDVER1          lapd, version 1.x */
#define BDVER2          /* lapd , version 2.x */
#define L3VER2          /* layer 3 */
/* interfaces */

/* upper interface, data link, choose none or more */
#define LCDAUIDAT     /*loosely coupled, data link layer */

/* lower interface, mac, choose none or more */
#define LCDALIMAC     /*loosely coupled, mac layer */

/* management interface, lbd , choose none or more */
#define LCDAMILBD     /*loosely coupled, layer management */

/* debug mngmt interface, choose one or none, default is debug output disabled */
#define BD_LMINT3 1        
    /*layer management interface 3. If this flag
    is enabled, enable SMBD_LMINT3 flag in the
    #ifdef SM section. If this flag is disabled,
    disable SMBD_LMINT3 flag in the #ifdef SM
    section. This flag should be turned OFF for
    pre LMINT3 interface */

#ifdef LMINT3
# ifdef BD_LMINT3
#  undef BD_LMINT3
#  define BD_LMINT3 1
# endif /* BD_LMINT3 */
#endif /* BD_LMINT3 */

/* layer management options */

/* LCLM or TCLM chosen above, if LCLM or TCLM not chosen */
/* then choose none or one within else */
# define LCLDLM          /* loosely coupled, layer management */

/* product specific options */

/* tei management, choose none or one */
/* must agree with options delivered */

#define LMLD         /*  tei management, option 11 */

/* data link interface type, choose one */
/* if applicable, must agree with x.75, x.25 end and intermediate
   system, x.25 intermediate system, x.25 end system or x.31 data link
   interface type */
  
#define DATINT1       /* data link interface 1 */
/* #define DATINT2       data link interface 2 */

/* mac interface type, choose one */
/* if applicable, must agree with scc or isac-s mac interface type */

/*#define MACINT1        mac interface 1 */
/* #define MACINT2       mac interface 2 */
/*#define MACINT4*/         /* mac interface 4 */
#define MACINTN         /* mac interface N */

#define DATVER2
#define MACVER2

#ifdef LCDAMILBD
# ifndef LCLBD
#  define LCLBD 1
# endif /* LCLBD */
#endif /* LCDAMILBD */

#ifdef LCDAUIDAT
# ifndef LCDAT
#  define LCDAT 1
# endif /* LCDAT */
#endif /* LCDAUIDAT */

#ifdef LCDALIMAC
# ifndef LCMAC
#  define LCMAC 1
# endif /* LCMAC */
#endif /* LCDALIMAC */
/*#define BD_FTHA           Enables SHT interface for LAPD */
#endif /* LD */

#ifdef SM       /* stack manager */
/**************************************************************************
   Stack Manager parameters
**************************************************************************/
#define LCSMNSMILNS     /* stack manager loosely coupled to NTSS */
#define LCSMDAMILBD     /* stack manager loosely coupled to data link layer - ER, BR, BD, LD, LB */
#define LCSMINMILIN     /* stack manager loosely coupled to Q.930/Q.931 */

#define SMIN_LMINT3 1
#define SMBD_LMINT3 1

#ifdef LCSMINMILIN
# ifndef LCLIN
#  define LCLIN  1    /* Define LC flag for LIN (Q.931 LM) interface */
# endif /* LCLIN */
#endif /* LCSMINMILIN */

#endif /* SM */

/* switch type backwards compatibility */

/* isdn */

#ifdef ATT            /* att 4ess and 5ess, option 11 */
#define ISDN_ATT   1  /* att 4ess and 5ess, option 11 */
#endif
#ifdef NT             /* northern telecomm dms-100, option 12 */
#define ISDN_NT    1  /* northern telecomm dms-100, option 12 */
#endif
#ifdef VN             /* vn 2 and vn 3, france, option 13 */
#define ISDN_VN    1  /* vn 2 and vn 3, france, option 13 */
#endif
#ifdef ETSI           /* etsi, europe, option 14 */ 
#define ISDN_ETSI  1  /* etsi, europe, option 14 */ 
#endif
#ifdef AUS            /* AUS, australian, option 15 */ 
#define ISDN_AUS   1  /* AUS, australian, option 15 */ 
#endif
#ifdef NI1            /* national isdn 1, north america, option 16 */ 
#define ISDN_NI1   1  /* national isdn 1, north america, option 16 */ 
#endif
#ifdef NTT            /* ins net, japan, option 17 */
#define ISDN_NTT   1  /* ins net, japan, option 17 */
#endif
#ifdef INTR6          /* 1 - TR6, german, option 18 */
#define ISDN_TR6   1  /* 1 - TR6, german, option 18 */
#endif
#ifdef ATT5E          /* att 5ess, option 19 */
#define ISDN_ATT5E 1  /* att 5ess, option 19 */
#endif
#ifdef ATT4E          /* att 4ess, option 20 */
#define ISDN_ATT4E 1  /* att 4ess, option 20 */
#endif
#ifdef VN2            /* vn 2, france, option 21 */
#define ISDN_VN2   1  /* vn 2, france, option 21 */
#endif
#ifdef VN3            /* vn 3, france, option 22 */
#define ISDN_VN3   1  /* vn 3, france, option 22 */
#endif
#ifdef NTDMS250       /* northern telecom dms-250, option 23 */
#define ISDN_NTDMS250 1 /* northern telecom dms-250, option 23 */
#endif
#ifdef NTSPRINT       /* northern telecom dms-250 sprint , option 33 */
#define ISDN_NTSPRINT 1 /* northern telecom dms-250 sprint, option 33 */
#ifndef NTDMS250      /* we need to define NTDMS250 for NTSPRINT */
#define NTDMS250
#define ISDN_NTDMS250 1 /* northern telecom dms-250, option 23 */
#endif 
#endif /* NTSPRINT */
#ifdef BC303          /* bellcore tr-303, tmc and csc, option 24 */
#define ISDN_303    1 /* bellcore tr-303, tmc and csc, option 24 */
#endif
#ifdef BC303TMC       /* bellcore tr-303, tmc , option 25 */
#define ISDN_303TMC 1 /* bellcore tr-303, tmc , option 25 */
#define ISDN_BC303TMC 1 /* Bellcore TR-303 TMC */
#endif
#ifdef BC303CSC       /* bellcore tr-303, csc, option 26 */
#define ISDN_303CSC 1 /* bellcore tr-303, csc, option 26 */
#define ISDN_BC303CSC 1 /* Bellcore TR-303 CSC.  */
#endif
#ifdef Q932           /* q.932, option 27 */
#define ISDN_Q932   1 /* q.932, option 27 */
#endif
#ifdef NI2           /* national isdn 2, north america, option 28 */
#define ISDN_NI2    1 /* national isdn 2, north america, option 28 */
#endif
#ifdef QSIG           /* etsi qsig, option 29 */
#define ISDN_QSIG   1 /* etsi qsig, option 29 */
#endif
#ifdef NTNI           /* nt ni, option 31 */
#define ISDN_NTNI   1 /* nt ni, option 31 */
#endif
#ifdef NTMCI          /* nt mci, option 32 */
#define ISDN_NTMCI  1 /* nt mci, option 32 */
#endif


#endif /* __ENVOPTH__ */

