/********************************************************************16**

        (c) COPYRIGHT 1989-2001 by Trillium Digital Systems, Inc.
                          All rights reserved.

     This software is confidential and proprietary to Trillium
     Digital Systems, Inc.  No part of this software may be reproduced,
     stored, transmitted, disclosed or used in any form or by any means
     other than as expressly provided by the written license agreement
     between Trillium and its licensee.

     Trillium warrants that for a period, as provided by the written
     license agreement between Trillium and its licensee, this
     software will perform substantially to Trillium specifications as
     published at the time of shipment and the media used for delivery
     of this software will be free from defects in materials and
     workmanship.

     TRILLIUM MAKES NO OTHER WARRANTIES, EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION WARRANTIES OF MERCHANTABILITY OR FITNESS FOR
     A PARTICULAR PURPOSE WITH REGARD TO THIS SOFTWARE OR ANY RELATED
     MATERIALS.

     IN NO EVENT SHALL TRILLIUM BE LIABLE FOR ANY INDIRECT, SPECIAL,
     OR CONSEQUENTIAL DAMAGES IN CONNECTION WITH OR ARISING OUT OF
     THE USE OF, OR INABILITY TO USE, THIS SOFTWARE, WHETHER BASED
     ON BREACH OF CONTRACT, TORT (INCLUDING NEGLIGENCE), PRODUCT
     LIABILITY, OR OTHERWISE, AND WHETHER OR NOT IT HAS BEEN ADVISED
     OF THE POSSIBILITY OF SUCH DAMAGE.

                       Restricted Rights Legend

     This software and all related materials licensed hereby are
     classified as "restricted computer software" as defined in clause
     52.227-19 of the Federal Acquisition Regulation ("FAR") and were
     developed entirely at private expense for nongovernmental purposes,
     are commercial in nature and have been regularly used for
     nongovernmental purposes, and, to the extent not published and
     copyrighted, are trade secrets and confidential and are provided
     with all rights reserved under the copyright laws of the United
     States.  The Government's rights to the software and related
     materials are limited and restricted as provided in clause
     52.227-19 of the FAR.

                    IMPORTANT LIMITATION(S) ON USE

     The use of this software is limited to the Use set
     forth in the written License Agreement between Trillium and
     its Licensee. Among other things, the Use of this software
     may be limited to a particular type of Designated Equipment.
     Before any installation, use or transfer of this software, please
     consult the written License Agreement or contact Trillium at
     the location set forth below in order to confirm that you are
     engaging in a permissible Use of the software.

                    Trillium Digital Systems, Inc.
                  12100 Wilshire Boulevard, suite 1800
                    Los Angeles, CA 90025-7118, USA

                        Tel: +1 (310) 442-9222
                        Fax: +1 (310) 442-1162

                   Email: tech_support@trillium.com
                     Web: http://www.trillium.com

*********************************************************************17*/


  
/********************************************************************20**
  
     Name:     Q930 common defines - portable
  
     Type:     C include file
  
     Desc:     Defines required by the layer management and call control
               of Q.930.
  
     File:     cm_q930.h
  
     Sid:      cm_q930.h@@/main/1 - Wed May 23 17:07:22 2001
     
     Prg:      scc
  
*********************************************************************21*/
  
#ifndef __CMQ930H__
#define __CMQ930H__

  
/*
*     The defines declared in this file correspond to defines
*     used by the following TRILLIUM software:
*
*     part no.                      description
*     --------    ----------------------------------------------
*     1000009     Network Layer - Q.930/Q.931
*
*/
 
  


/* presentation indicator */

#define IN_PI_ALLOW       0x00  /* presentation allowed */
#define IN_PI_RESTRICT    0x01  /* presentation restricted */
#define IN_PI_NOTAVAIL    0x02  /* number not available due to 
                                   internetworking */

/* screening indicator */

#define IN_SI_USRNOTSCRN  0x00  /* user provided - not screened */
#define IN_SI_USRVERSCRN  0x01  /* user provided - verified and passed */
#define IN_SI_USRVERFAIL  0x02  /* user provided - verified and failed */
#define IN_SI_NET         0x03  /* network provided */

/* coding standards */

#define IN_CSTD_CCITT     0x00  /* CCITT standards */
#define IN_CSTD_INT       0x01  /* Other International Standards */
#define IN_CSTD_NAT       0x02  /* National Standard */
#define IN_CSTD_NET       0x03  /* Network Standard */

/* type of number */

#define IN_TON_UNK        0x00  /* unknown */
#define IN_TON_INT        0x01  /* international number */
#define IN_TON_NAT        0x02  /* national number */
#define IN_TON_NETSPEC    0x03  /* network specific number */
#define IN_TON_SUB        0x04  /* subscriber number */
#define IN_TON_OLSND      0x05  /* overlap sending */
#define IN_TON_ABB        0x06  /* abbreviated number */
#define IN_TON_EXT        0x07  /* reserved for extension */

/* numbering plan */

#define IN_NP_UNK         0x00  /* unknown */
#define IN_NP_ISDN        0x01  /* ISDN/telephony numbering - E.164/E.163 */
#define IN_NP_TEL         0x02  /* telephony numbering - E.163 */
#define IN_NP_DATA        0x03  /* data numbering - X.121 */
#define IN_NP_TELEX       0x04  /* telex numbering - Recommendation F.69 */
#define IN_NP_NATIONAL    0x08  /* national standard numbering */
#define IN_NP_PRIVATE     0x09  /* private numbering */
#define IN_NP_EXT         0x0f  /* reserved for extension */

/* type of subaddress */

#define IN_TOSAD_NSAP     0x00  /* nsap - X.213/ISO 8348 */
#define IN_TOSAD_USER     0x02  /* user specified */

/* odd/even indicator */

#define IN_OE_EVEN        0x00  /* even number of address signals */
#define IN_OE_ODD         0x01  /* odd number of address signals */

/* interpretation */

#define IN_INT_NAT        0x00  /* national */
#define IN_INT_FIRST      0x04  /* first high layer characteristics */

/* presentation method of protocol profile */

#define IN_PM_VAL1        0x01  /* value 1 */

/* high layer characteristics */

#define IN_HLCI_TEL       0x01  /* Telephony - Recommendation G.711 */
#define IN_HLCI_FAXG4     0x04  /* Facsimile Group 4 - Recommendation T.62 */
#define IN_HLCI_DAPFAXG4  0x21  /* Doc App Profile for Facsimile Group 4 */
                                /* Recommendation T.503 */
#define IN_HLCI_DAPMIXED  0x24  /* Doc App Profile for Facsimile Group 4 */
                                /* Recommendation T.501 */
#define IN_HLCI_DAPPROC   0x28  /* Doc App Profile for Facsimile Group 4 */
                                /* Recommendation T.502 */
#define IN_HLCI_TELETEX   0x31  /* Teletex - Recommendation T.62/T.70 */
#define IN_HLCI_DAPVIDEO  0x32  /* Doc App Profile for Facsimile Group 4 */
                                /* Recommendation T.503 */
#define IN_HLCI_TELEX     0x35  /* Telex */
#define IN_HLCI_MHS       0x38  /* Message Handling System */
                                /* Recommendation X.400 */
#define IN_HLCI_AUDSCR    0x40  /* VN-3 National Audiosritp */
#define IN_HLCI_OSIAPP    0x41  /* OSI Application - Recommendation X.200 */
#define IN_HLCI_AUDVID    0x48  /* VN-3 National Audiovideotex */
#define IN_HLCI_MAINT     0x5e  /* Maintenance */
#define IN_HLCI_MNGMT     0x5f  /* Management */
#define IN_HLCI_VIDTEL    0x60  /* Videotelephony F.xyz and AV.242 */
#define IN_HLCI_RESERVE   0xff  /* Reserved */

/* This part includes the old defines
   that are still used by the Layer
   Managers of some of the customers
   that uses the management interface
   or the INT interface 
   of the Q.930/Q.930 layer. These
   layers should phase out the
   uses of these old defines in their
   future revisions */

#if (defined(LIN_OLD_DEFINES) || defined(INT_OLD_DEFINES))

/* presentation indicator */

#define PI_ALLOW           IN_PI_ALLOW     /* presentation allowed */
#define PI_RESTRICT        IN_PI_RESTRICT  /* presentation restricted */
#define PI_NOTAVAIL        IN_PI_NOTAVAIL  /* number not available due to
                                              internetworking */

/* screening indicator */

#define SI_USRNOTSCRN      IN_SI_USRNOTSCRN  /* user provided - not screened */
#define SI_USRVERSCRN      IN_SI_USRVERSCRN  /* user provided 
                                                - verified and passed */
#define SI_USRVERFAIL      IN_SI_USRVERFAIL  /* user provided 
                                                - verified and failed */
#define SI_NET             IN_SI_NET         /* network provided */

/* coding standards */

#define CSTD_CCITT     IN_CSTD_CCITT  /* CCITT standards */
#define CSTD_INT       IN_CSTD_INT    /* Other International Standards */
#define CSTD_NAT       IN_CSTD_NAT    /* National Standard */
#define CSTD_NET       IN_CSTD_NET    /* Network Standard */

/* type of number */

#define TON_UNK        IN_TON_UNK      /* unknown */
#define TON_INT        IN_TON_INT      /* international number */
#define TON_NAT        IN_TON_NAT      /* national number */
#define TON_NETSPEC    IN_TON_NETSPEC  /* network specific number */
#define TON_SUB        IN_TON_SUB      /* subscriber number */
#define TON_OLSND      IN_TON_OLSND    /* overlap sending */
#define TON_ABB        IN_TON_ABB      /* abbreviated number */
#define TON_EXT        IN_TON_EXT      /* reserved for extension */

/* numbering plan */

#define NP_UNK         IN_NP_UNK       /* unknown */
#define NP_ISDN        IN_NP_ISDN      /* ISDN/telephony numbering 
                                          - E.164/E.163 */
#define NP_TEL         IN_NP_TEL       /* telephony numbering - E.163 */
#define NP_DATA        IN_NP_DATA      /* data numbering - X.121 */
#define NP_TELEX       IN_NP_TELEX     /* telex numbering 
                                          - Recommendation F.69 */
#define NP_NATIONAL    IN_NP_NATIONAL  /* national standard numbering */
#define NP_PRIVATE     IN_NP_PRIVATE   /* private numbering */
#define NP_EXT         IN_NP_EXT       /* reserved for extension */

/* type of subaddress */

#define TOSAD_NSAP     IN_TOSAD_NSAP   /* nsap - X.213/ISO 8348 */
#define TOSAD_USER     IN_TOSAD_USER   /* user specified */

/* odd/even indicator */

#define OE_EVEN        IN_OE_EVEN      /* even number of address signals */
#define OE_ODD         IN_OE_ODD       /* odd number of address signals */

/* interpretation */

#define INT_NAT        IN_INT_NAT     /* national */
#define INT_FIRST      IN_INT_FIRST   /* first high layer characteristics */

/* presentation method of protocol profile */

#define PM_VAL1        IN_PM_VAL1     /* value 1 */

/* high layer characteristics */

#define HLCI_TEL       IN_HLCI_TEL       /* Telephony - Recommendation G.711 */
#define HLCI_FAXG4     IN_HLCI_FAXG4     /* Facsimile Group 4 
                                            - Recommendation T.62 */
#define HLCI_DAPFAXG4  IN_HLCI_DAPFAXG4  /* Doc App Profile for Facsimile
                                            Group 4 - Recommendation T.503 */
#define HLCI_DAPMIXED  IN_HLCI_DAPMIXED  /* Doc App Profile for Facsimile 
                                            Group 4 - Recommendation T.501 */
#define HLCI_DAPPROC   IN_HLCI_DAPPROC   /* Doc App Profile for Facsimile 
                                            Group 4 - Recommendation T.502 */
#define HLCI_TELETEX   IN_HLCI_TELETEX   /* Teletex 
                                            - Recommendation T.62/T.70 */
#define HLCI_DAPVIDEO  IN_HLCI_DAPVIDEO  /* Doc App Profile for Facsimile 
                                            Group 4 - Recommendation T.503 */
#define HLCI_TELEX     IN_HLCI_TELEX     /* Telex */
#define HLCI_MHS       IN_HLCI_MHS       /* Message Handling System */
                                         /* Recommendation X.400 */
#define HLCI_AUDSCR    IN_HLCI_AUDSCR    /* VN-3 National Audiosritp */
#define HLCI_OSIAPP    IN_HLCI_OSIAPP    /* OSI Application 
                                            - Recommendation X.200 */
#define HLCI_AUDVID    IN_HLCI_AUDVID    /* VN-3 National Audiovideotex */
#define HLCI_MAINT     IN_HLCI_MAINT     /* Maintenance */
#define HLCI_MNGMT     IN_HLCI_MNGMT     /* Management */
#define HLCI_VIDTEL    IN_HLCI_VIDTEL    /* Videotelephony F.xyz and AV.242 */
#define HLCI_RESERVE   IN_HLCI_RESERVE   /* Reserved */

#endif /* LIN_OLD_DEFINES || INT_OLD_DEFINES */

#endif /* __CMQ930H__ */

  
/********************************************************************30**
 
         End of file:     cm_q930.h@@/main/1 - Wed May 23 17:07:22 2001
    
*********************************************************************31*/


/********************************************************************40**
  
        Notes:
  
*********************************************************************41*/

/********************************************************************50**

*********************************************************************51*/

   
/********************************************************************60**
  
        Revision history:
  
*********************************************************************61*/
  
/********************************************************************90**
 
     ver       pat    init                  description
------------ -------- ---- ----------------------------------------------
/main/1      ---      scc  initial release

*********************************************************************91*/
