#!/bin/sh
# Copyright (c) 2008-2011 Broadcom Corporation

if [ $# -lt 1 ]; then
	echo "$0: No kernel source directory provided." 1>&2
	exit 255
fi

srcdir=$1
shift

while [ $# != 0 ]; do
	case $1 in
		TG3_NO_EEE)
			echo "#define TG3_DISABLE_EEE_SUPPORT"
			;;
		*)
			;;
	esac
	shift
done

if grep -q "netdump_mode" $srcdir/include/linux/kernel.h ; then
	echo "#define BCM_HAS_NETDUMP_MODE"
fi

if grep -q "bool" $srcdir/include/linux/types.h ; then 
	echo "#define BCM_HAS_BOOL"
fi

if grep -q "__le32" $srcdir/include/linux/types.h ; then 
	echo "#define BCM_HAS_LE32"
fi

if grep -q "resource_size_t" $srcdir/include/linux/types.h ; then
	echo "#define BCM_HAS_RESOURCE_SIZE_T"
fi

if grep -q "kzalloc" $srcdir/include/linux/slab.h ; then
	echo "#define BCM_HAS_KZALLOC"
fi

for symbol in jiffies_to_usecs usecs_to_jiffies msecs_to_jiffies; do
	if [ -f $srcdir/include/linux/jiffies.h ]; then
		if grep -q "$symbol" $srcdir/include/linux/jiffies.h ; then
			echo "#define BCM_HAS_`echo $symbol | tr '[a-z]' '[A-Z]'`"
			continue
		fi
	fi
	if [ -f $srcdir/include/linux/time.h ]; then
		if grep -q "$symbol" $srcdir/include/linux/time.h ; then
			echo "#define BCM_HAS_`echo $symbol | tr '[a-z]' '[A-Z]'`"
			continue
		fi
	fi
	if [ -f $srcdir/include/linux/delay.h ]; then
		if grep -q "$symbol" $srcdir/include/linux/delay.h ; then
			echo "#define BCM_HAS_`echo $symbol | tr '[a-z]' '[A-Z]'`"
			continue
		fi
	fi
done

if grep -q "msleep" $srcdir/include/linux/delay.h ; then
	echo "#define BCM_HAS_MSLEEP"
fi

if grep -q "msleep_interruptible" $srcdir/include/linux/delay.h ; then
	echo "#define BCM_HAS_MSLEEP_INTERRUPTIBLE"
fi

if grep -q "skb_copy_from_linear_data" $srcdir/include/linux/skbuff.h ; then
	echo "#define BCM_HAS_SKB_COPY_FROM_LINEAR_DATA"
fi

if grep -q "skb_is_gso_v6" $srcdir/include/linux/skbuff.h ; then
	echo "#define BCM_HAS_SKB_IS_GSO_V6"
fi

if grep -q "skb_checksum_none_assert" $srcdir/include/linux/skbuff.h ; then
	echo "#define BCM_HAS_SKB_CHECKSUM_NONE_ASSERT"
fi

if grep -q "pci_ioremap_bar" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_IOREMAP_BAR"
fi

if grep -q "pci_read_vpd" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_READ_VPD"
fi

if grep -q "PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_INTX_MSI_WORKAROUND"
fi

if grep -q "pci_target_state" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_TARGET_STATE"
fi

if grep -q "pci_choose_state" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_CHOOSE_STATE"
fi

if grep -q "pci_pme_capable" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_PME_CAPABLE"
fi

if grep -q "pci_enable_wake" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_ENABLE_WAKE"
fi

if grep -q "pci_wake_from_d3" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_WAKE_FROM_D3"
fi

if grep -q "pci_set_power_state" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCI_SET_POWER_STATE"
fi

if [ -e "$srcdir/include/linux/pm_wakeup.h" ]; then
	TGT_H="$srcdir/include/linux/pm_wakeup.h"
elif [ -e "$srcdir/include/linux/pm.h" ]; then
	TGT_H="$srcdir/include/linux/pm.h"
fi

if [ -n "$TGT_H" ]; then
	if grep -q "device_can_wakeup"        $TGT_H && \
	   grep -q "device_may_wakeup"        $TGT_H && \
	   grep -q "device_set_wakeup_enable" $TGT_H ; then
		echo "#define BCM_HAS_DEVICE_WAKEUP_API"
	fi
fi

if [ -f $srcdir/include/asm-generic/pci-dma-compat.h ]; then
	TGT_H=$srcdir/include/asm-generic/pci-dma-compat.h
	num_args=`awk '/pci_dma_mapping_error/,/[;{]/ {printf $0; next}' $TGT_H | awk -F ',' '{print NF}'`
	if [ $num_args -eq 2 ]; then
		echo "#define BCM_HAS_NEW_PCI_DMA_MAPPING_ERROR"
	elif grep -q "pci_dma_mapping_error" $TGT_H ; then
		echo "#define BCM_HAS_PCI_DMA_MAPPING_ERROR"
	fi
fi

if grep -q "pcie_set_readrq" $srcdir/include/linux/pci.h ; then
	echo "#define BCM_HAS_PCIE_SET_READRQ"
fi

if grep -q "print_mac" $srcdir/include/linux/if_ether.h ; then
	echo "#define BCM_HAS_PRINT_MAC"
fi

# ethtool_op_set_tx_ipv6_csum() first appears in linux-2.6.23
if grep -q "ethtool_op_set_tx_ipv6_csum" $srcdir/include/linux/ethtool.h ; then
	echo "#define BCM_HAS_ETHTOOL_OP_SET_TX_IPV6_CSUM"
fi

# ethtool_op_set_tx_hw_csum() first appears in linux-2.6.12
if grep -q "ethtool_op_set_tx_hw_csum" $srcdir/include/linux/ethtool.h ; then
	echo "#define BCM_HAS_ETHTOOL_OP_SET_TX_HW_CSUM"
fi

# set_tx_csum first appears in linux-2.4.23
if grep -q "(*set_tx_csum)" $srcdir/include/linux/ethtool.h ; then
	echo "#define BCM_HAS_SET_TX_CSUM"
fi

if grep -q "skb_transport_offset" $srcdir/include/linux/skbuff.h ; then
	echo "#define BCM_HAS_SKB_TRANSPORT_OFFSET"
fi

if grep -q "skb_get_queue_mapping" $srcdir/include/linux/skbuff.h ; then
	echo "#define BCM_HAS_SKB_GET_QUEUE_MAPPING"
fi

if grep -q "ip_hdr" $srcdir/include/linux/ip.h ; then
	echo "#define BCM_HAS_IP_HDR"
fi

if grep -q "ip_hdrlen" $srcdir/include/net/ip.h ; then
	echo "#define BCM_HAS_IP_HDRLEN"
fi

if grep -q "tcp_hdr" $srcdir/include/linux/tcp.h ; then
	echo "#define BCM_HAS_TCP_HDR"
fi

if grep -q "tcp_optlen" $srcdir/include/linux/tcp.h ; then
	echo "#define BCM_HAS_TCP_OPTLEN"
fi

TGT_H=$srcdir/include/linux/netdevice.h
if grep -q "struct netdev_queue" $TGT_H ; then
	echo "#define BCM_HAS_STRUCT_NETDEV_QUEUE"
else
	num_args=`awk '/ netif_rx_complete\(struct/,/\)/ {printf $0; next}' $TGT_H | awk -F ',' '{print NF}'`
	if [ -n "$num_args" -a $num_args -eq 2 ]; then
		# Define covers netif_rx_complete, netif_rx_schedule,
		# __netif_rx_schedule, and netif_rx_schedule_prep
		echo "#define BCM_HAS_NEW_NETIF_INTERFACE"
	fi
fi

if grep -q "netif_set_real_num_tx_queues" $TGT_H ; then
	echo "#define BCM_HAS_NETIF_SET_REAL_NUM_TX_QUEUES"
fi

if grep -q "netif_set_real_num_rx_queues" $TGT_H ; then
	echo "#define BCM_HAS_NETIF_SET_REAL_NUM_RX_QUEUES"
fi

if grep -q "netdev_tx_t" $TGT_H ; then
	echo "#define BCM_HAS_NETDEV_TX_T"
fi

if grep -q "netdev_hw_addr" $TGT_H ; then
	echo "#define BCM_HAS_NETDEV_HW_ADDR"
fi

if grep -q "netdev_name" $TGT_H ; then
	echo "#define BCM_HAS_NETDEV_NAME"
fi

if grep -q "(*ndo_get_stats64)" $TGT_H ; then
	echo "#define BCM_HAS_GET_STATS64"
fi

if grep -q "vlan_features" $TGT_H ; then
	echo "#define BCM_HAS_VLAN_FEATURES"
fi

if grep -q "vlan_rx_register" $TGT_H ; then
	echo "#define BCM_USE_OLD_VLAN_INTERFACE"
fi

if grep -q "alloc_etherdev_mq" $srcdir/include/linux/etherdevice.h ; then
	echo "#define BCM_HAS_ALLOC_ETHERDEV_MQ"
fi

if grep -q "napi_gro_receive" $TGT_H ; then
	echo "#define BCM_HAS_NAPI_GRO_RECEIVE"
fi

if grep -q "netif_tx_lock" $TGT_H ; then
	echo "#define BCM_HAS_NETIF_TX_LOCK"
fi

if grep -q "txq_trans_update" $TGT_H ; then
	echo "#define BCM_HAS_TXQ_TRANS_UPDATE"
fi

if grep -q "vlan_gro_receive" $srcdir/include/linux/if_vlan.h ; then
	echo "#define BCM_HAS_VLAN_GRO_RECEIVE"
fi

if grep -q "vlan_group_set_device" $srcdir/include/linux/if_vlan.h ; then
	echo "#define BCM_HAS_VLAN_GROUP_SET_DEVICE"
fi

if grep -q "__vlan_hwaccel_put_tag" $srcdir/include/linux/if_vlan.h ; then
	# Redhat's and SuSE's backport of __vlan_hwaccel_put_tag() doesn't work.
	# It requires a call to vlan_gro_receive(), rather than napi_gro_receive().
	if [ ! -f /etc/SuSE-release -a ! -f /etc/redhat-release ]; then
		echo "#define BCM_HAS_VLAN_HWACCEL_PUT_TAG"
	fi
fi

if [ -f $srcdir/include/linux/device.h ]; then
	if grep -q "dev_driver_string" $srcdir/include/linux/device.h ; then
		echo "#define BCM_HAS_DEV_DRIVER_STRING"
	fi

	if grep -q "dev_name" $srcdir/include/linux/device.h ; then
		echo "#define BCM_HAS_DEV_NAME"
	fi
fi

if [ -f $srcdir/include/linux/mii.h ]; then
	if grep -q "mii_resolve_flowctrl_fdx" $srcdir/include/linux/mii.h ; then
		echo "#define BCM_HAS_MII_RESOLVE_FLOWCTRL_FDX"
	fi
fi

if [ -f $srcdir/include/linux/phy.h ]; then
	if grep -q "mdiobus_alloc" $srcdir/include/linux/phy.h ; then
		echo "#define BCM_HAS_MDIOBUS_ALLOC"
	fi

	if grep -q "struct device *parent" $srcdir/include/linux/phy.h ; then
		echo "#define BCM_MDIOBUS_HAS_PARENT"
	fi
fi

if [ -f $srcdir/include/linux/dma-mapping.h ]; then
	if grep -q "dma_data_direction" $srcdir/include/linux/dma-mapping.h ; then
		echo "#define BCM_HAS_DMA_DATA_DIRECTION"
	fi

	if grep -q "dma_unmap_addr" $srcdir/include/linux/dma-mapping.h ; then
		echo "#define BCM_HAS_DMA_UNMAP_ADDR"
		echo "#define BCM_HAS_DMA_UNMAP_ADDR_SET"
	fi
fi
