/* ---------------------------------------------------------------------------
          Copyright (c) 2004-2008 Micrel, Inc.  All rights reserved.
   ---------------------------------------------------------------------------

    device.h - Linux network device driver header.

    Author      Date        Description
    THa         01/05/04    Created file.
    THa         09/27/04    Updated for PCI version.
    THa         05/10/05    Updated for two port devices.
    THa         06/27/05    Updated for version 0.1.5.
    THa         06/29/05    Updated for Linux 2.6.
    THa         07/07/05    Changed /proc entries.
    THa         10/12/05    Updated for new descriptor structure.
    THa         04/03/06    Use TWO_NETWORK_INTERFACE instead of TWO_PORTS.
    THa         05/18/06    Implement network NAPI.
    THa         05/31/06    Add ethtool support.
    THa         02/02/07    Implement hardware checksumming correctly.
    THa         05/11/07    Update for 2.6.19 and newer kernels.
    THa         12/05/07    Update for 64-bit Linux kernels.
    THa         01/18/08    Update for old 2.4.20 kernel.
   ---------------------------------------------------------------------------
*/


#ifndef __DEVICE_H
#define __DEVICE_H


#include <linux/netdevice.h>
#include <linux/version.h>
#include <linux/mii.h>


#if 1
#define RX_COPY
#endif

/* Scatter/gather requires hardware checksumming. */
#if TXCHECKSUM_DEFAULT
#define SCATTER_GATHER
#endif

#ifndef CONFIG_SH_7751_SOLUTION_ENGINE
#if 0
#define HIGH_MEM_SUPPORT
#endif
#endif

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2, 4, 20))
#ifndef TWO_NETWORK_INTERFACE
#if 0
#define CONFIG_KS884X_NAPI
#endif
#endif
#endif

/* -------------------------------------------------------------------------- */

typedef struct {
    struct timer_list* pTimer;
    void*              pData;
    unsigned int       cnCount;
    int                nCount;
    int                nTime;
} TTimerInfo, *PTTimerInfo;

/* -------------------------------------------------------------------------- */

typedef struct
{
    dma_addr_t dma_addr;
    UINT       ulAllocSize;
    UINT       ulPhysical;
    PUCHAR     pAllocVirtual;
    PUCHAR     pVirtual;
} SHARED_MEM, *PSHARED_MEM;


typedef struct _DMA_BUFFER
{
    struct sk_buff*     skb;
    dma_addr_t          dma;
    int                 len;
#if 0
    UINT                ulSize;
#endif
    struct _DMA_BUFFER* pNext;
} DMA_BUFFER, *PDMA_BUFFER;

#define DMA_BUFFER( pDesc )  (( PDMA_BUFFER )(( pDesc )->pReserved ))


typedef struct
{

    /* Array of buffers. */
    PDMA_BUFFER BufArray;

    /* Current buffer being manipulated .*/
    PDMA_BUFFER pCurrent;

    /* First buffer in the free stack. */
    PDMA_BUFFER pTop;

    /* Number of buffers allocated. */
    int         cnAlloc;

    /* Number of buffers available for use. */
    int         cnAvail;
} BUFFER_INFO, *PBUFFER_INFO;

/* -------------------------------------------------------------------------- */

typedef struct {
    wait_queue_head_t       wqhCounter;
    unsigned long           time;
    int                     fRead;
} COUNTER_INFO, *PCOUNTER_INFO;

/* -------------------------------------------------------------------------- */

struct dev_info {
    struct net_device*      dev;
    struct pci_dev*         pdev;

#ifdef CONFIG_PM
#if (LINUX_VERSION_CODE <= KERNEL_VERSION(2, 6, 9))
    u32                     pci_cfg_state[ 64 / sizeof( u32 )];
#endif
#endif

    spinlock_t              lockHardware;
    wait_queue_head_t       wqhHardware;
    struct proc_dir_entry*  proc_main;
    struct proc_dir_entry*  proc_port[ 2 ];
    struct semaphore        proc_sem;

    SHARED_MEM              m_DescPool;

    int                     m_nMTU;
    BUFFER_INFO             m_RxBufInfo;
    BUFFER_INFO             m_TxBufInfo;

    HARDWARE                hw;

    int                     id;

    TTimerInfo              MonitorTimerInfo;
    struct timer_list       timerMonitor;

    struct tasklet_struct   rx_tasklet;
    struct tasklet_struct   tx_tasklet;

    COUNTER_INFO            Counter[ TOTAL_PORT_NUM ];

    unsigned long           pme_wait;

#ifdef TWO_NETWORK_INTERFACE
    struct net_device*      pDev[ 2 ];
#endif
};


struct dev_priv {
    struct net_device_stats stats;

    struct dev_info         dev_info;
    struct dev_info*        pDevInfo;

    spinlock_t              lock;

    struct mii_if_info      mii_if;

#if defined( DEF_KS8842 )  &&  !defined( TWO_NETWORK_INTERFACE )
    struct mii_if_info      mii_if_2;
#endif
    u32                     advertising;

    /* debug message level */
    u32                     msg_enable;

    struct sk_buff*         skb_waiting;

    int                     media_state;
    int                     opened;

#ifdef TWO_NETWORK_INTERFACE
    int                     port;
#endif
};

/* -------------------------------------------------------------------------- */

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 0))
void

#else
irqreturn_t
#endif
ks8842p_dev_interrupt (
    int             irq,
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 19))
    void*           dev_id,
    struct pt_regs* regs );
#else
    void*           dev_id );
#endif

/* -------------------------------------------------------------------------- */

void ks8842p_transmit_alloc_done (
    struct net_device* dev );

void ks8842p_transmit_done (
    struct net_device* dev );

void transmit_reset (
    struct net_device* dev );

int ks8842p_dev_transmit (
    struct sk_buff*    skb,
    struct net_device* dev );

void ks8842p_dev_transmit_timeout (
    struct net_device *dev );

#ifdef CONFIG_KS884X_NAPI
int ks8842p_dev_poll (
    struct net_device* dev,
    int*               budget );

#define DEV_POLL              ks8842p_dev_poll
#endif

#define DEV_INTERRUPT_PTR     &ks8842p_dev_interrupt

#define TRANSMIT_ALLOC_DONE   ks8842p_transmit_alloc_done
#define TRANSMIT_DONE         ks8842p_transmit_done
#define TRANSMIT_EMPTY        ks8842p_transmit_empty
#define DEV_TRANSMIT          ks8842p_dev_transmit
#define DEV_TRANSMIT_TIMEOUT  ks8842p_dev_transmit_timeout

/* -------------------------------------------------------------------------- */

int AcquireHardware (
    struct dev_info* priv,
    int              in_intr,
    int              wait );

void ReleaseHardware (
    struct dev_info* priv,
    int              in_intr );

/* -------------------------------------------------------------------------- */

void InitBuffers (
    PBUFFER_INFO pBufInfo );

void InitReceiveBuffers (
    struct dev_info* pAdapter );

/* -------------------------------------------------------------------------- */

#endif
