#!/bin/sh

#
# Script to prepare to create a RPM source package.
#

[ -z $1 ] && echo "$0 version" && exit 1

NAME="ksz884x"
LAST="$PWD"

mkdir /tmp/$NAME-$1
cp -rp * /tmp/$NAME-$1/
find /tmp/$NAME-$1 -name ".svn" -type d | xargs rm -rf
cd /tmp
rm $NAME-$1/prepRPM.sh
tar cfz $NAME-$1.tar.gz $NAME-$1/*
rm -rf /tmp/$NAME-$1
cd $LAST
if [ -d $HOME/rpmbuild/SPECS ]; then
    RPMDIR="$HOME/rpmbuild"
elif [ -d /usr/src/redhat/SPECS ]; then
    RPMDIR="/usr/src/redhat"
fi
if [ ! -z $RPMDIR ]; then
    mv /tmp/$NAME-$1.tar.gz $RPMDIR/SOURCES/
    cp ksz884x_net.spec $RPMDIR/SPECS/
fi
