<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class wanrouter_hwprobe_controls
{
	function get_generic_profiles($db, $table,$param,$data,&$counter)
	{
		$a = 0;
	
		$select = "SELECT " . $param . " FROM " . $table . ";";
		
		//echo $select;
		
		$table = $data->check_for_table($db,$table);
		if ($table >1 )
		{
			try
			{
				//open the database
				$db = new PDO($db);
	
				$result = $db->query($select);
			
				foreach($result as $row)
				{
					$profile[$a] = $row;
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage() . "<br />";
				echo "Database location = $db<br />";
				echo "Table = $table<br />";
				echo "Select statement = $select <br />";
			}
		}
	
		return $profile;
	}	
	
	
//Redirects you to the page you have selected depending on the submit button that is pressed
function redirect($input, $data, $tokenization,$db=null,$relay_db=null )
{
	//Counter for tokens to place into an array
	$total_token = 0;
	
	//Split up submit button return into smaller pieces to parse properly
	foreach ($input as $key => $value)
	{
		//echo $key . "=" . $value . "<br />";
		//Tokenize $key to split the submit button
		$tok = strtok($key, "-");
	
		$count = 0;
		
		while ($tok !== false) {
			$token[$count] = $tok;
			
			//Stores the tokens in an array to be parsed
			$token_values[$total_token] = $token[$count];			
		    $tok = strtok("-");
			$count++;
			$total_token++;
		}	
	}

	for ($a = 0; $a <= $total_token; $a ++)
	{
		//echo "$a = $token_values[$a]<br />";
		//Checks if T1/E1/J1 cards were selected
		if ($token_values[$a] == "A101" || $token_values[$a] == "A102" || $token_values[$a] == "A104" || $token_values[$a] == "A108" || $token_values[$a] == "A116")
		{
			//echo $a;
			//Relative positions of values needed
			$pos = $a - 1; //Position of the hw/sig
			$card_num = $a + 3;
			$card_port = $a + 2;
			$config = $a - 2;
			$ss7_span = $a + 4; //position of the ss7 span number	
			$ss7_line = $a + 5; //position of media type		
			$proc_id = $a + 6;  //Position of proc_id
			//echo $token_values[$proc_id];
			//echo $token_values[$pos];
			
			//Stop the identify feature after ok is clicked in the alert box
			if ($token_values[$config] == "config" && $token_values[$pos] == "led")
			{
				$proc_id = $a + 4;
				//Redirect to the identify page
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];	
				$_SESSION['proc_id'] = $token_values[$proc_id];
				$_SESSION['last_page'] = "hwprobe";
				//echo $proc_id;
				//echo $ss7_line . "<br />";			
				
				unset ($_SESSION['created']);
				
				//Redirect identification page
				header( 'Location:identify/identify_ui.php#top' ) ;
				exit;
			}
			
			//Checks to see if the hardware configuration button was clicked
			if ($token_values[$config] == "config" && $token_values[$pos] == "hw")
			{	
				//echo "Card number = " . $token_values[$card_num] . "<br />";;
				$proc_id = $a + 5;  //Position of proc_id
				
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				$_SESSION['ss7_span'] = $token_values[$ss7_span];
				$_SESSION['proc_id'] = $token_values[$proc_id];
			
				unset ($_SESSION['created']);
				
				//Redirect to t1/e1 configuration page
				if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
					header( 'Location:configuration/configure_t1e1.php#top') ;
				else
                    header( 'Location:configuration/configure_t1e1.php#top') ;

				exit;
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "sig")
			{
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				$_SESSION['proc_id'] = $token_values[$proc_id];
					
				//Drop Down Box Position (Always above the signaling submit button. (Relative position 7, need to go back 7)
				$signal = $a - 7;
				$card_signal = $a - 6;
				$card_type = $a - 5;
				$card_signal_port = $a - 4;
				$card_signal_num = $a - 3;
				
				//Rebuild submit info
				$drop_down_signal = $token_values[$signal] . "-" . $token_values[$card_signal] . "-" . $token_values[$card_type] . "-" .  $token_values[$card_signal_port] ."-" .  $token_values[$card_signal_num];
				$submit_sig = "config-sig-" . $token_values[$a] . "-" . $token_values[$card_port] . "-" .  $token_values[$card_num];
									
				if ($input[$drop_down_signal] == "PRI")
				{
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];					
	
					unset ($_SESSION['created']);
					
					//Redirect to PRI Profile Creation Page
					//Redirect to t1/e1 configuration page
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						header( 'Location:profiles/view_profiles.php#top' ) ;
					else
						header( 'Location:profiles/view_profiles.php#top' ) ;
					exit;
					
				}
				elseif ($input[$drop_down_signal] == "SS7")
				{
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];
					$_SESSION['ss7_line'] = $token_values[$ss7_line];	
					$_SESSION['proc_id'] = $token_values[$proc_id];			
					
					unset ($_SESSION['created']);						
									
					//Redirect to SS7 Link configuration page
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						header( 'Location:SS7/SS7_link_config.php#top' ) ;
					else
						header( 'Location:SS7/SS7_link_config.php#top' ) ;
						
					exit;
					
				}	
				elseif($_SESSION['nbess7'] == "yes")
				{
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];
					$_SESSION['ss7_line'] = $token_values[$ss7_line];
					$_SESSION['proc_id'] = $token_values[$proc_id];									
					
					unset ($_SESSION['created']);						
									
					//Redirect to SS7 Link configuration page
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
					{
						//header( 'Location:SS7/SS7_link_config.php#top' ) ;
						header ('Location:SS7/decide_ss7_linktype.php#top');
					}
					else
					{
						//echo "I am here";
						//header( 'Location:configuration/configure_t1e1.php#top') ;
						//header('Window-target: _top');
						//header('Location:/admin/ss7_t1e1_configuration.php');
						//echo "<script type='text/javascript'>\n";
						//echo " self.parent.location.href = '/admin/ss7_t1e1_configuration.php';";
						/*echo "</script>";*/
						
						//header( 'Location:SS7/SS7_link_config.php#top' ) ;
						header ('Location:SS7/decide_ss7_linktype.php#top');
					}
					exit;
								
				}
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "linkset")
			{
					$proc_id = $a + 5;  //Position of proc_id
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];
					$_SESSION['proc_id'] = $token_values[$proc_id];					

					unset ($_SESSION['created']);						
						
					//Redirect to SS7 Linkset Page
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						header( 'Location:SS7/view_ss7_linkset.php#top' ) ;
					else
						header( 'Location:SS7/view_ss7_linkset.php#top' ) ;

					exit;
					
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "cluster")
			{
					$proc_id = $a + 5;  //Position of proc_id
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];
					$_SESSION['proc_id'] = $token_values[$proc_id];					

					unset ($_SESSION['created']);						
						
					//Redirect to SS7 Linkset Page
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						header( 'Location:SS7/sigtran/m2ua_clusters.php#top' ) ;
					else
						header( 'Location:SS7/sigtran/m2ua_clusters.php#top' ) ;

					exit;
					
			}			
			if ($token_values[$config] == "config" && $token_values[$pos] == "ss7ccspan")
			{
					$proc_id = $a + 5;  //Position of proc_id
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];
					$_SESSION['proc_id'] = $token_values[$proc_id];					

					unset ($_SESSION['created']);						
					
					//Redirect to SS7 CCSpans page
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						header( 'Location:SS7/create_ss7_ccspans.php#top' ) ;
					else
						header( 'Location:SS7/create_ss7_ccspans.php#top' ) ;

					exit;
					
			}	
			if ($token_values[$config] == "config" && $token_values[$pos] == "ss7mgchan")
			{
					$proc_id = $a + 5;  //Position of proc_id
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];
					$_SESSION['proc_id'] = $token_values[$proc_id];					

					unset ($_SESSION['created']);						

					//Redirect to SS7 CCSpans page
					if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
						header( 'Location:SS7/sigtran/mg_channels.php#top' ) ;
					else
						header( 'Location:SS7/sigtran/mg_channels.php#top' ) ;

					exit;
					
			}					
			if ($token_values[$config] == "config" && $token_values[$pos] == "accept")
			{
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				//Create Channel Maps
				//Put directly into the signalling database for that card
				
				//Rebuilt textbox name
				$textbox = "channel-map-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$group = "group-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$context = "context-" . $_SESSION['card_clicked'] . "-SH-". $_SESSION['port_num_clicked'] . "-" . $_SESSION['card_num'];
				
				//Enter into the signalling database using update
				//Cardname-card_num-signalling
				$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] ."_signalling";
				$r2_table = $_SESSION['card_clicked'] ."_" . $_SESSION['card_num'] . "_r2_signalling";
				
				//If dahdi is installed, use the following parameters
				if ($_SESSION['dahdi'] != "")
					$parameters = "channels = \"$input[$textbox]\", group_num = \"$input[$group]\", context = \"$input[$context]\"";					
				elseif ($_SESSION['freetdm'] != "")
					$parameters = "channels = \"$input[$textbox]\", group_num = \"$input[$group]\"";
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				
				//echo $_REQUEST['span_type_'.$_SESSION['port_num_clicked'].'_'.$_SESSION['card_num']];
				
				if ($_REQUEST['span_type_'.$_SESSION['port_num_clicked'].'_'.$_SESSION['card_num']] == "r2_" . $_SESSION['port_num_clicked'].'_'.$_SESSION['card_num'])
					$data->update_table("sqlite:sqlite/cardinfo.db", $r2_table, $parameters, $where_param);
				else
					$data->update_table("sqlite:sqlite/cardinfo.db", $table_name, $parameters, $where_param);
				
				//$session_return = "channel-" . $_SESSION['card_clicked'] . "-" .  $_SESSION['card_num'] . "-" . $_SESSION['port_num_clicked'];

				unset ($_SESSION['created']);

				header( 'Location:wanrouterhwprobe.php#top' );				
			}
			if ($token_values[$config] == "ss7linkset" && $token_values[$pos] == "accept")
			{
				$proc_id = $a + 5;  //Position of proc_id
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				$_SESSION['proc_id'] = $token_values[$proc_id];	
				
				//Rebuilds Drop Down Box
				$dropdown = "linkset-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				
				$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] ."_SS7_link";
				$parameters = "linkset = \"$input[$dropdown]\"";
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				
				$data->update_table("sqlite:sqlite/cardinfo.db", $table_name, $parameters, $where_param);
				
				unset ($_SESSION['created']);

				//Redirect page to itself

				header( 'Location:wanrouterhwprobe.php#top' );				
			}			
			if ($token_values[$config] == "config" && $token_values[$pos] == "clear")
			{
				$proc_id = $a + 4;
				//echo $token_values[$proc_id];
				//Clears the existing configuration for that specific port
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				$_SESSION['proc_id'] = $token_values[$proc_id];
							
				//Database related variables
				if ($token_values[$proc_id] == 1)
					$db_location = "sqlite:sqlite/cardinfo.db";	
				elseif ($token_values[$proc_id] > 1)
					$db_location = "sqlite:sqlite/cardinfo" . $token_values[$proc_id] . ".db";			

				$parameters = "port_id = " . $_SESSION['port_num_clicked'];
				
				//Get media type from database to reduce the number of configured channels
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
				$result = $data->select_statement($db_location,$table_name,"line_type",$parameters);
				
				$data->delete_generic($db_location, $table_name, $parameters);
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				$data->delete_generic($db_location, $table_name, $parameters);

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_r2_signalling";
				$data->delete_generic($db_location, $table_name, $parameters);				

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link";
				$data->delete_generic($db_location, $table_name, $parameters);					

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_ccspans";
				$data->delete_generic($db_location, $table_name, $parameters);
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_link";
				$data->delete_generic($db_location, $table_name, $parameters);

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_channels";
				$data->delete_generic($db_location, $table_name, $parameters);				
				
				$card_format = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_" . $_SESSION['port_num_clicked'];					
				$table_name = "finished_ports";
				$delete_param = "card = \"$card_format\"";
				$data->delete_generic($db_location, $table_name, $delete_param);
				
				$card_format = $_SESSION['card_clicked'] . "-" . $_SESSION['card_num'] . "-" . $_SESSION['port_num_clicked'];
				$table_name = "used_linkset";
				$delete_param = "card = \"$card_format\"";
				$data->delete_generic($db_location, $table_name, $delete_param);
			

				unset ($_SESSION['created']);

				$table_name = "configured_channels";						
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
				{
					$chan = $data->select_statement($db_location,$table_name,"channels","id = 1");
					if ($result['line_type'] == "E1")
						$new_chan = $chan['channels'] - 31;
					elseif ($result['line_type'] == "T1")
						$new_chan = $chan['channels'] - 24;
					
					//Update channels table
					$data->update_table ($db_location, $table_name, "channels = \"" . $new_chan . "\"", "id = 1");
				}		
								
				$anchor_id = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_" . $_SESSION['port_num_clicked'];

				//Redirect page to itself
				header( 'Location:wanrouterhwprobe.php#' . $anchor_id);
			}			

		}
		elseif ($token_values[$a] == "A200" || $token_values[$a] == "A400" || $token_values[$a] == "B600" || $token_values[$a] == "B800")
		{
			//echo $a;
			//Relative positions of values needed
			$pos = $a - 1; //Position of the hw/sig
			$card_num = $a + 3;
			$card_port = $a + 2;
			$config = $a - 2;			

			//Stop the identify feature after ok is clicked in the alert box
			if ($token_values[$config] == "config" && $token_values[$pos] == "led")
			{
				//kill the wanpipemon process
				$cmd = "kill -2 " . $_SESSION['pidof'];
				exec ($cmd);
				//echo $cmd . "<br />";
				
				//Stop port if it was never started
				if (!isset($_SESSION['wanrouter_started']))
				{
					$cmd = "/usr/bin/pkill -9 wanpipemon";
					shell_exec($cmd);					
					$cmd = "/usr/sbin/wanrouter stop " . $_SESSION['wanpipe_off'];
					exec($cmd);
				}
				
				//delete the file if it was temporary
				if ($_SESSION['delete_file'] == "yes")
				{
					$cmd = "rm -f /etc/wanpipe/" . $_SESSION['wanpipe_off'] . ".conf";
					exec($cmd);
				}
			}			
			//Checks to see if the hardware configuration button was clicked
			if ($token_values[$config] == "config" && $token_values[$pos] == "hw")
			{	
				//echo "Card number = " . $token_values[$card_num] . "<br />";;
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
			
				unset ($_SESSION['created']);
							
				//Redirect to analog configuration page
				header( 'Location:configuration/configure_analog.php' ) ;
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "sig")
			{
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
										
				//Redirect to analog profiles page
				header( 'Location:profiles/view_analog_profiles.php' ) ;
			}							
			if ($token_values[$config] == "config" && $token_values[$pos] == "accept")
			{
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				//Create Channel Maps
				//Put directly into the signalling database for that card
				
				//Rebuilt textbox name
				$textbox = "channel-map-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$group = "group-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$context = "context-" . $_SESSION['card_clicked'] . "-SH-". $_SESSION['port_num_clicked'] . "-" . $_SESSION['card_num'];
				
				//Enter into the signalling database using update
				//Cardname-card_num-signalling
				$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] ."_signalling";
				
				//If dahdi is installed, use the following parameters
				if ($_SESSION['dahdi'] != "")
					$parameters = "group_num = \"$input[$group]\", context = \"$input[$context]\"";					
				elseif ($_SESSION['freetdm'] != "")
					$parameters = "group_num = \"$input[$group]\"";
				
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				$data->update_table("sqlite:sqlite/cardinfo.db", $table_name, $parameters, $where_param);
				
				unset ($_SESSION['created']);

				//Redirect page to itself
				header( 'Location:wanrouterhwprobe.php' );				
			}
			
			if ($token_values[$config] == "config" && $token_values[$pos] == "clear")
			{
				//Clears the existing configuration for that specific port
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				$db_location = "sqlite:sqlite/cardinfo.db";
				$parameters = "port_id = " . $_SESSION['port_num_clicked'];
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
				$data->delete_generic($db_location, $table_name, $parameters);
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				$data->delete_generic($db_location, $table_name, $parameters);

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link";
				$data->delete_generic($db_location, $table_name, $parameters);	

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_ccspans";
				$data->delete_generic($db_location, $table_name, $parameters);	
				
				//clear m2ua and mg tables
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_link";
				$data->delete_generic($db_location, $table_name, $parameters);	

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_channels";
				$data->delete_generic($db_location, $table_name, $parameters);					
				
				$card_format = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_" . $_SESSION['port_num_clicked'];					
				$table_name = "finished_ports";
				$delete_param = "card = \"$card_format\"";
				$data->delete_generic($db_location, $table_name, $delete_param);								

				$table_name = "finished_ports";						
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
				
				$table_name = "configured_channels";						
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
				
				//Creates finished ports table
				$table_name = "finished_ports";
				$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30)";
				$data->create_table($db_location, $table_name, $parameters);	
								

				unset ($_SESSION['created']);

				//Redirect page to itself
				header( 'Location:wanrouterhwprobe.php' );				
			}				
			
		}
		if ($token_values[$a] == "B601")
		{
			//echo $a;
			//Relative positions of values needed
			$pos = $a - 1; //Position of the hw/sig
			$card_num = $a + 3;
			$card_port = $a + 2;
			$config = $a - 2;	
			$ss7_span = $a + 4; //position of the ss7 span number
			$ss7_line = $a + 5; //position of media type		
			
			//Stop the identify feature after ok is clicked in the alert box
			if ($token_values[$config] == "config" && $token_values[$pos] == "led")
			{
				//kill the wanpipemon process
				$cmd = "kill -2 " . $_SESSION['pidof'];
				exec ($cmd);
				//echo $cmd . "<br />";
				
				//Stop port if it was never started
				if (!isset($_SESSION['wanrouter_started']))
				{
					$cmd = "/usr/bin/pkill -9 wanpipemon";
					shell_exec($cmd);					
					$cmd = "/usr/sbin/wanrouter stop " . $_SESSION['wanpipe_off'];
					exec($cmd);
				}
				
				//delete the file if it was temporary
				if ($_SESSION['delete_file'] == "yes")
				{
					$cmd = "rm -f /etc/wanpipe/" . $_SESSION['wanpipe_off'] . ".conf";
					exec($cmd);
				}
			}	
					
			//Checks to see if the hardware configuration button was clicked
			if ($token_values[$config] == "config" && $token_values[$pos] == "hw")
			{	
				//echo "Card number = " . $token_values[$card_num] . "<br />";;
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
			
				unset ($_SESSION['created']);
							
				if ($token_values[$card_port] == 1)
				{
					//Redirect to t1/e1 configuration page
					header( 'Location:configuration/configure_t1e1.php' ) ;
				}
				elseif ($token_values[$card_port] == 2)
				{
					//Redirect to analog configuration page
					header( 'Location:configuration/configure_analog.php' ) ;
				}
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "sig")
			{
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				//Drop Down Box Position (Always above the signaling submit button. (Relative position 7, need to go back 7)
				$signal = $a - 7;
				$card_signal = $a - 6;
				$card_type = $a - 5;
				$card_signal_port = $a - 4;
				$card_signal_num = $a - 3;
				
				//Rebuild submit info
				$drop_down_signal = $token_values[$signal] . "-" . $token_values[$card_signal] . "-" . $token_values[$card_type] . "-" .  $token_values[$card_signal_port] ."-" .  $token_values[$card_signal_num];
				$submit_sig = "config-sig-" . $token_values[$a] . "-" . $token_values[$card_port] . "-" .  $token_values[$card_num];

				if ($token_values[$card_port] == 1)
				{
					if ($input[$drop_down_signal] == "PRI")
					{
						//Store important information into session variable
						$_SESSION['port_num_clicked'] = $token_values[$card_port];
						$_SESSION['card_clicked'] = $token_values[$a];
						$_SESSION['card_num'] = $token_values[$card_num];					
		
						unset ($_SESSION['created']);
						
						//Redirect to t1/e1 configuration page
						header( 'Location:profiles/view_profiles.php' ) ;
					}	
					elseif ($input[$drop_down_signal] == "SS7")
					{
						//Store important information into session variable
						$_SESSION['port_num_clicked'] = $token_values[$card_port];
						$_SESSION['card_clicked'] = $token_values[$a];
						$_SESSION['card_num'] = $token_values[$card_num];										
						$_SESSION['ss7_span'] = $token_values[$ss7_span];
						$_SESSION['ss7_line'] = $token_values[$ss7_line];
											
						unset ($_SESSION['created']);	
																	
						//Redirect to ss7 link configuration page
						header( 'Location:SS7/SS7_link_config.php' ) ;
					}
				}
				elseif ($token_values[$card_port] == 2)
				{
					unset ($_SESSION['created']);						
					//Redirect to analog configuration page
					header( 'Location:profiles/view_analog_profiles.php' ) ;
				}					
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "linkset")
			{
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];

					unset ($_SESSION['created']);						
										
					//Redirect to the ss7 linkset page
					header( 'Location:SS7/view_ss7_linkset.php' ) ;
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "ss7ccspan")
			{
					//Store important information into session variable
					$_SESSION['port_num_clicked'] = $token_values[$card_port];
					$_SESSION['card_clicked'] = $token_values[$a];
					$_SESSION['card_num'] = $token_values[$card_num];	
					$_SESSION['ss7_span'] = $token_values[$ss7_span];

					unset ($_SESSION['created']);						
										
					//Redirect to CC Spans section
					header( 'Location:SS7/create_ss7_ccspans.php' ) ;
			}					
			if ($token_values[$config] == "config" && $token_values[$pos] == "accept")
			{
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				//Create Channel Maps
				//Put directly into the signalling database for that card
				
				//Rebuilt textbox name
				$textbox = "channel-map-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$group = "group-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$context = "context-" . $_SESSION['card_clicked'] . "-SH-". $_SESSION['port_num_clicked'] . "-" . $_SESSION['card_num'];
				
				//Enter into the signalling database using update
				//Cardname-card_num-signalling
				$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] ."_signalling";
				
				//If dahdi is installed, use the following parameters
				if ($_SESSION['dahdi'] != "")
				{
					$parameters = "channels = \"$input[$textbox]\", group_num = \"$input[$group]\", context = \"$input[$context]\"";					
				}
				elseif ($_SESSION['freetdm'] != "")
				{
					$parameters = "channels = \"$input[$textbox]\", group_num = \"$input[$group]\"";
				}
				
				$where_param = "port_id = " . $_SESSION['port_num_clicked'];
				$data->update_table("sqlite:sqlite/cardinfo.db", $table_name, $parameters, $where_param);
				
				//$session_return = "channel-" . $_SESSION['card_clicked'] . "-" .  $_SESSION['card_num'] . "-" . $_SESSION['port_num_clicked'];

				unset ($_SESSION['created']);

				//Redirect page to itself
				header( 'Location:wanrouterhwprobe.php' );				
			}
			
			if ($token_values[$config] == "config" && $token_values[$pos] == "clear")
			{
				//Clears the existing configuration for that specific port
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				$db_location = "sqlite:sqlite/cardinfo.db";
				$parameters = "port_id = " . $_SESSION['port_num_clicked'];
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
				$data->delete_generic($db_location, $table_name, $parameters);
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				$data->delete_generic($db_location, $table_name, $parameters);

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link";
				$data->delete_generic($db_location, $table_name, $parameters);
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_ccspans";
				$data->delete_generic($db_location, $table_name, $parameters);	
				
				$card_format = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_" . $_SESSION['port_num_clicked'];					
				$table_name = "finished_ports";
				$delete_param = "card = \"$card_format\"";
				$data->delete_generic($db_location, $table_name, $delete_param);								
			
				/*$table_name = "perm_" . $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
				$data->delete_generic($db_location, $table_name, $parameters);
				
				$table_name = "perm_" . $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				$data->delete_generic($db_location, $table_name, $parameters);*/

				$table_name = "finished_ports";						
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
				{
					$data->drop_table($db_location, $table_name);
				}
				
				$table_name = "configured_channels";						
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
				{
					$data->drop_table($db_location, $table_name);
				}
				
				//Creates finished ports table
				$table_name = "finished_ports";
				$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30)";
				$data->create_table($db_location, $table_name, $parameters);	
								

				unset ($_SESSION['created']);

				//Redirect page to itself
				header( 'Location:wanrouterhwprobe.php' );				
			}			

		}		
		
		//Checks if BRI cards were selected
		elseif ($token_values[$a] == "A500" || $token_values[$a] == "B700")
		{
			//Relative positions of values needed
			$pos_hw = $a - 2; //Position of the hw/sig
			$card_num = $a + 3;
			$bri_type = $a - 1;
			$card_port = $a + 2;
			$config_hw = $a - 3;			
			$config = $a - 2;
			$pos = $a - 1; 

			//Stop the identify feature after ok is clicked in the alert box
			if ($token_values[$config] == "config" && $token_values[$pos] == "led")
			{
				//kill the wanpipemon process
				$cmd = "kill -2 " . $_SESSION['pidof'];
				exec ($cmd);
				//echo $cmd . "<br />";
				
				//Stop port if it was never started
				if (!isset($_SESSION['wanrouter_started']))
				{
					$cmd = "/usr/bin/pkill -9 wanpipemon";
					shell_exec($cmd);					
					$cmd = "/usr/sbin/wanrouter stop " . $_SESSION['wanpipe_off'];
					exec($cmd);
				}
				
				//delete the file if it was temporary
				if ($_SESSION['delete_file'] == "yes")
				{
					$cmd = "rm -f /etc/wanpipe/" . $_SESSION['wanpipe_off'] . ".conf";
					exec($cmd);
				}
			}

			//Checks to see if the hardware configuration button was clicked
			if ($token_values[$config_hw] == "config" && $token_values[$pos_hw] == "hw")
			{				
				//Store important information into session variable
				$_SESSION['bri_type'] = $token_values[$bri_type];
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
			
				unset ($_SESSION['created']);
			
				if ($token_values[$bri_type] == "NT" || $token_values[$bri_type] == "TE" )
				{
					//Redirect to BRI configuration page
					header( 'Location:configuration/configure_bri.php' ) ;
				}
				elseif ($token_values[$bri_type] == "FXO" || $token_values[$bri_type] == "FXS")
				{
					//Redirect to Analog configuration page
					header( 'Location:configuration/configure_analog.php' ) ;
				}
			}
			if ($token_values[$config] == "config" && $token_values[$pos] == "clear")
			{
				//Clears the existing configuration for that specific port
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				$db_location = "sqlite:sqlite/cardinfo.db";
				$parameters = "port_id = " . $_SESSION['port_num_clicked'];
				$param_signalling = "id = " . $_SESSION['port_num_clicked'];
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
				$data->delete_generic($db_location, $table_name, $parameters);
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				$data->delete_generic($db_location, $table_name, $param_signalling);

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link";
				$data->delete_generic($db_location, $table_name, $parameters);

				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_ccspans";
				$data->delete_generic($db_location, $table_name, $parameters);	
				
				$card_format = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_" . $_SESSION['port_num_clicked'];					
				$table_name = "finished_ports";
				$delete_param = "card = \"$card_format\"";
				$data->delete_generic($db_location, $table_name, $delete_param);							
				
				$table_name = "finished_ports";						
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
				{
					$data->drop_table($db_location, $table_name);
				}
				
				$table_name = "configured_channels";						
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
				{
					$data->drop_table($db_location, $table_name);
				}
				
				//Creates finished ports table
				$table_name = "finished_ports";
				$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30)";
				$data->create_table($db_location, $table_name, $parameters);	
								

				unset ($_SESSION['created']);
				
				//Redirect page to itself
				header( 'Location:wanrouterhwprobe.php' );
			}	
			if ($token_values[$config_hw] == "config" && $token_values[$pos_hw] == "sig")
			{						
				//Store important information into session variable			
				$_SESSION['bri_type'] = $token_values[$bri_type];
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				unset ($_SESSION['created']);	

				if ($token_values[$bri_type] == "NT" || $token_values[$bri_type] == "TE" )
				{
					//Redirect to BRI configuration page
					header( 'Location:profiles/view_bri_profiles.php' ) ;
				}
				elseif ($token_values[$bri_type] == "FXO" || $token_values[$bri_type] == "FXS")
				{
					//Redirect to Analog configuration page
					header( 'Location:profiles/view_analog_profiles.php' ) ;
				}
				
			}
			//echo $token_values[$pos_hw];
			if ($token_values[$config_hw] == "config" && $token_values[$pos_hw] == "accept")
			{
				//Store important information into session variable
				$_SESSION['port_num_clicked'] = $token_values[$card_port];
				$_SESSION['card_clicked'] = $token_values[$a];
				$_SESSION['card_num'] = $token_values[$card_num];
				
				//Create Channel Maps
				//Put directly into the signalling database for that card
				
				//Rebuilt textbox name
				$textbox = "channel-map-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$group = "group-" . $_SESSION['card_clicked'] . "-SH" . "-" .  $_SESSION['port_num_clicked'] . "-" .  $_SESSION['card_num'];
				$context = "context-" . $_SESSION['card_clicked'] . "-SH-". $_SESSION['port_num_clicked'] . "-" . $_SESSION['card_num'];
				
				//echo $token_values[$bri_type] . ", " . $group . ", " . $input[$group] . "<br />";
				
				//Enter into the signalling database using update
				//Cardname-card_num-signalling
				$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] ."_signalling";
				
				//If dahdi is installed, use the following parameters
				if ($token_values[$bri_type] == "NT" || $token_values[$bri_type] == "TE")
				{
					if ($_SESSION['dahdi'] != "")
					{
						$parameters = "channels = \"$input[$textbox]\", group_num = \"$input[$group]\", context = \"$input[$context]\"";					
					}
					elseif ($_SESSION['freetdm'] != "")
					{
						$parameters = "channels = \"$input[$textbox]\", group_num = \"$input[$group]\"";
					}
				
					$where_param = "id = " . $_SESSION['port_num_clicked'];
					$data->update_table("sqlite:sqlite/cardinfo.db", $table_name, $parameters, $where_param);
				}
				elseif ($token_values[$bri_type] == "FXS" || $token_values[$bri_type] == "FXO")
				{
					if ($_SESSION['dahdi'] != "")
					{
						$parameters = "group_num = \"$input[$group]\", context = \"$input[$context]\"";					
					}
					elseif ($_SESSION['freetdm'] != "")
					{
						$parameters = "group_num = \"$input[$group]\"";
					}
				
					$where_param = "id = " . $_SESSION['port_num_clicked'];
					$data->update_table("sqlite:sqlite/cardinfo.db", $table_name, $parameters, $where_param);
				}
				
				//$session_return = "channel-" . $_SESSION['card_clicked'] . "-" .  $_SESSION['card_num'] . "-" . $_SESSION['port_num_clicked'];

				unset ($_SESSION['created']);

				//Redirect page to itself
				header( 'Location:wanrouterhwprobe.php' );
			}
		}
	}
	if ($input['reset'] == "Reset Config")
	{
		if ($relay_db == "")
			$relay_db = 'sqlite:sqlite/relay_info.db';
		if ($db != "")
			$db_location = $db;
			
		$table_exists = $data->check_for_table($relay_db,'relay_hosts');
		
		if ($table_exists > 1)
		{
			$count_hosts = $data->select_statement($relay_db,'relay_hosts','count(id)',"");
			if ($count_hosts['count(id)'] == "")
				$count_hosts['count(id)'] = 1;
		}
		elseif ($table_exists < 2)
			$count_hosts['count(id)'] =1 ;
		
		for ($k = 1; $k <= $count_hosts['count(id)']; $k++)
		{
			if ($k == 1 && $db == "")
				$db_location = "sqlite:sqlite/cardinfo.db";	
			elseif ($k > 1)
				$db_location = "sqlite:sqlite/cardinfo" . $k . ".db";
	
			//Clears the existing configuration for that specific card
			
			$select = "SELECT id, dev_name FROM card_present;";
	
			$a = 0;
		
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);
						
				foreach($result as $row)
				{
					$array[$a] = $row;
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				echo "Unable to retreive boards present in the system<br />";
				echo "DB = $db_location<br />";
				echo "Select statement = $select<br />";
				print 'Exception : '.$e->getMessage();
			}
			
			$z = 0; 				
			//Drop the tables	
			for ($b = 1; $b <= $a; $b++)
			{
				$card = $tokenization->tokenize_wanpipe($array[$z]['dev_name']);
				
				$table_name = $card . "_" . $array[$z]['id'];
				$table = $data->check_for_table ($db_location, $table_name);

				if ($table > 1)
					$data->drop_table($db_location, $table_name);
				
				$table_name = $card . "_" . $array[$z]['id'] . "_signalling";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
					
				$table_name = $card . "_" . $array[$z]['id'] . "_r2_signalling";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);					
				
				$table_name = $card . "_" . $array[$z]['id'] . "_SS7_link";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
								
				$table_name = $card . "_" . $array[$z]['id'] . "_SS7_ccspans";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
				
				$table_name = $card . "_" . $array[$z]['id'] . "_m2ua_link";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
				
				$table_name = $card . "_" . $array[$z]['id'] . "_m2ua_channels";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
										
				$z++;
			}
	
			//drop tables
			$table_name = "ss7_linkset_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
	
			$table_name = "ss7_isup_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
	
			$table_name = "ss7_route_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "used_linkset";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "used_route";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "used_isup";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "sctp_interfaces";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);

			$table_name = "t1e1_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
				
			$table_name = "r2_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);				
			
			//Pull cluster info and drop cluster tables
			$clusters = $this->get_generic_profiles($db_location,'m2ua_clusters','profile_name',$data,&$counter);
			if (isset($clusters)) {
				foreach ($clusters as $cluster) {
					$table = $cluster['profile_name'].'_peers';
					if ($data->check_for_table($db_location,$table) > 1 )
						$data->drop_table($db_location,$table);						
				}
			}							
				
			$table_name = "m2ua_clusters";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);			
			
			$table_name = "finished_ports";						
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "configured_channels";						
			$new_table = "perm_configured_channels";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
			{
				//Copy results to a perm table to store the last number of configured channels
				$data->select_into($db_location,$table_name, "*", $new_table);
				$data->drop_table($db_location, $table_name);
			}
			
			//Creates finished ports table
			$table_name = "finished_ports";
			$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30), mg_profile varchar(100)";
			$data->create_table($db_location, $table_name, $parameters);	
							
			//Creates the SS7 Linkset Profile Table
			$table_name = "ss7_linkset_profile";
			$parameters = "id int primary key, profile_name varchar(60), apc int, minactive int";
			$data->create_table($db_location, $table_name, $parameters);	
	
			//Creates the SS7 ISUP Profile Table
			$table_name = "ss7_isup_profile";
			$parameters = "id int primary key, profile_name varchar(60), spc int, ssf varchar(30), route varchar(60), t6 int , t9 int";
			$data->create_table($db_location, $table_name, $parameters);	
	
			//Creates the SS7 Route Profile Table
			$table_name = "ss7_route_profile";
			$parameters = "id int primary key, profile_name varchar(60), dpc int, linksets varchar(100), stp varchar(10)";
			$data->create_table($db_location, $table_name, $parameters);	
			
			//Create the linkset used table
			$table_name="used_linkset";
			$parameters = "id int primary key, card varchar(30), name varchar(60)";
			$data->create_table($db_location, $table_name, $parameters);
	
			//Create the route used table
			$table_name="used_route";
			$parameters = "id int primary key, isup varchar(30), name varchar(60)";
			$data->create_table($db_location, $table_name, $parameters);					
	
			//Create the isup used table
			$table_name="used_isup";
			$parameters = "id int primary key, card varchar(30), name varchar(60)";
			$data->create_table($db_location, $table_name, $parameters);		

			if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded'])) {	
				$table_name = "t1e1_profile";
				$parameters = "id int primary key, profile_name varchar(60), line_type varchar(10), protocol varchar(10), switchtype varchar(30), signalling varchar(30), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), overlap varchar(30), transfer varchar(30)";
				$data->create_table($db_location, $table_name, $parameters);
	
				$table_name = "bri_profile";
				$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, overlap varchar(10), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), bearer_ITC varchar(30), bearer_UIL varchar(30), msn varchar(100), min_digits int";
				$data->create_table($db_location, $table_name, $parameters);
	
				$table_name = "analog_profile";
				$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), codec varchar(10), operation_mode varchar(10), hangup_polarity varchar(20), answer_polarity varchar(20),callerid varchar(20), tones varchar(20), call_waiting varchar(20), three_way varchar(20), call_swap varchar(20), digit_timeout int, max_digits int, polarity_delay int";
				$data->create_table($db_location, $table_name, $parameters);
	
				$table_name = 'r2_profile';
				$parameters = "id INTEGER PRIMARY KEY, profile_name varchar(30), varient varchar(30), ani_length int, dnis_length int, category varchar(30), collect_calls varchar(30), immediate_accept varchar(30), double_answer varchar(30), skip_category varchar(30), forced_release varchar(30), charge_calls varchar(30), ani_first varchar(30), backward_timeout varchar(30), pulse_timeout int, call_files varchar(30)";
				$data->create_table($db_location, $table_name, $parameters);
	
				//Insert Default Profiles
				$table_name = "t1e1_profile";
				$parameters = "id, profile_name, line_type, protocol, switchtype, signalling, facility, bearer_ITC, overlap, transfer";
				
				$values = "1, \"T1 PRI CPE\", \"T1\", \"CCS\", \"NI2\", \"PRI CPE\", \"no\", \"\", \"disable\", \"yes\"";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
				
				$values = "2, \"E1 PRI CPE\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI CPE\", \"no\", \"\", \"disable\", \"yes\"";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
				
				$values = "3, \"T1 PRI NET\", \"T1\", \"CCS\", \"NI2\", \"PRI NET\", \"no\", \"\", \"disable\", \"yes\"";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
	
				$values = "4, \"E1 PRI NET\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI NET\", \"no\", \"\", \"disable\", \"yes\"";
				$data->insert_statement($db_location, $table_name, $parameters, $values);		
		
				//Insert Default R2 Profiles
				$table_name = "r2_profile";
				$parameters = "id, profile_name, varient, ani_length, dnis_length, category, collect_calls";
				
				$values = '1, "R2 Mexico Profile", "mx", 10, 4, "National Subscriber","no"';
				$data->insert_statement($db_location, $table_name, $parameters, $values);
				
				$values = '2, "R2 Brazil Profile", "br", 10, 4, "National Subscriber","no"';
				$data->insert_statement($db_location, $table_name, $parameters, $values);			
					
				$values = '3, "R2 ITU Profile", "itu", 10, 4, "National Subscriber","no"';
				$data->insert_statement($db_location, $table_name, $parameters, $values);				
					
				//Insert Default BRI Profiles
				$table_name = "bri_profile";
				$parameters = "id, profile_name, conn_type, sig_type,  interface, switchtype, tei, overlap, bearer_ITC, min_digits";
				
				$values = "1, \"BRI PTMP CPE\", \"TE\", \"CPE\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
				
				$values = "2, \"BRI PTMP NET\", \"NT\", \"NET\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
	
				$values = "3, \"BRI PTP CPE\", \"TE\", \"CPE\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
							
				$values = "4, \"BRI PTP NET\", \"NT\", \"NET\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				$data->insert_statement($db_location, $table_name, $parameters, $values);			
				
				//Insert Default Analog Profiles
				$table_name = "analog_profile";
				$parameters = "id, profile_name, codec, operation_mode, hangup_polarity, answer_polarity, callerid, tones, call_waiting, three_way, call_swap, polarity_delay";
				
				$values = "1, \"ANALOG MULAW\", \"MULAW\", \"FCC\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", \"600\"";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
				
				$values = "2, \"ANALOG ALAW\", \"ALAW\", \"TBR21\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", \"600\"";
				$data->insert_statement($db_location, $table_name, $parameters, $values);
				
				$table_name='snmp_db';
				$parameters = "id integer, snmp_version varchar(30), username varchar(30), password varchar(30)";
				$data->create_table($db_location, $table_name, $parameters);
				
				//Creates M2UA Cluster tables
				$table_name = "m2ua_clusters";
				$parameters = "id integer primary key, profile_name varchar(100), traffic_mode varchar(50), load_share varchar(50)";
				$data->create_table($db_location, $table_name,$parameters);
				
				//Creates SCTP Interfaces table
				$table_name = "sctp_interfaces";
				$parameters = "id integer primary key, profile_name varchar(100), dest_ip_1 varchar(100), dest_ip_2 varchar(100), dest_ip_3 varchar(100), dest_ip_4 varchar(100),dest_ip_5 varchar(100), port int";
				$data->create_table($db_location, $table_name, $parameters);				
			}

			unset ($_SESSION['created']);
			unset ($_SESSION['create']);
		}
		
		//unset counter session variables
		unset($_SESSION['profile_num_ccspan']);
		unset($_SESSION['cic']);
		unset($_SESSION['profile_num_route']);
		unset($_SESSION['profile_num_linkset']);
		unset($_SESSION['profile_num_isup']);
		unset($_SESSION['profile_pri_num']);
		unset($_SESSION['profile_bri_num']);
		unset($_SESSION['profile_analog_num']);
		
		//Redirect page to itself
		//header( 'Location:wanrouterhwprobe.php' );
	}	
	
	if ($input['restore'] == "Restore Config")
	{
		//Restores information to the scratchpad database from the permanent databases
		//Straight Copy from permanent databases to scratchpad databases
		//Use database copy command
		//Clears the existing configuration for that specific card

		$table_exists = $data->check_for_table('sqlite:sqlite/relay_info.db','relay_hosts');
		
		if ($table_exists > 1)
		{
			$count_hosts = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','count(id)',"");
			if ($count_hosts['count(id)'] == "")
				$count_hosts['count(id)'] = 1;
		}
		elseif ($table_exists < 2)
			$count_hosts['count(id)'] =1 ;
		
		for ($k = 1; $k <= $count_hosts['count(id)']; $k++)
		{
			if ($k == 1)
				$db_location = "sqlite:sqlite/cardinfo.db";	
			elseif ($k > 1)
				$db_location = "sqlite:sqlite/cardinfo" . $k . ".db";
				
			$select = "SELECT id, dev_name FROM card_present;";
	
			//While Loop Counter
			$a = 1;
	
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);
						
				foreach($result as $row)
				{
					$array[$a] = $row;
					$a++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				echo "Unable to retreive boards present in the system<br />";
				echo "DB = $db_location<br />";
				echo "Select statement = $select<br />";
				print 'Exception : '.$e->getMessage();
			}
							
			//Drop the tables	
			for ($b = 1; $b < $a; $b++)
			{
				$card = $tokenization->tokenize_wanpipe($array[$b]['dev_name']);

				//Hardware Physical Layer				
				$table_name = $card . "_" . $array[$b]['id'];
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
				
				$new_table = $table_name;
				$table_name = "perm_" . $table_name;
				$data->select_into ($db_location, $table_name, "*", $new_table);	
				
				//PRI/BRI/Analog Signalling
				$table_name = $card . "_" . $array[$b]['id'] . "_signalling";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
					
				$new_table = $table_name;
				$table_name = "perm_" . $table_name;
				$data->select_into ($db_location, $table_name, "*", $new_table);						
				
				if ($card == "A101" || $card == "A102" || $card == "A104" || $card == "A108" || $card == "A116" || $card == "B601")
				{
					//R2
					$table_name = $card . "_" . $array[$b]['id'] . "_r2_signalling";
					$table = $data->check_for_table ($db_location, $table_name);
					if ($table > 1)
						$data->drop_table($db_location, $table_name);					
					
					$new_table = $table_name;
					$table_name = "perm_" . $table_name;
					$data->select_into ($db_location, $table_name, "*", $new_table);			
					
					//SS7 Sig Link
					$table_name = $card . "_" . $array[$b]['id'] . "_SS7_link";
					$table = $data->check_for_table ($db_location, $table_name);
					if ($table > 1)
						$data->drop_table($db_location, $table_name);
		
					$new_table = $table_name;
					$table_name = "perm_" . $table_name;
					$data->select_into ($db_location, $table_name, "*", $new_table);			
					
					//SS7 CCSpans
					$table_name = $card . "_" . $array[$b]['id'] . "_SS7_ccspans";
					$table = $data->check_for_table ($db_location, $table_name);
					if ($table > 1)
						$data->drop_table($db_location, $table_name);
					
					$new_table = $table_name;
					$table_name = "perm_" . $table_name;
					$data->select_into ($db_location, $table_name, "*", $new_table);			
					
					//SS7 M2UA Link
					$table_name = $card . "_" . $array[$b]['id'] . "_m2ua_link";
					$table = $data->check_for_table ($db_location, $table_name);
					if ($table > 1)
						$data->drop_table($db_location, $table_name);
		
					$new_table = $table_name;
					$table_name = "perm_" . $table_name;
					$data->select_into ($db_location, $table_name, "*", $new_table);			
					
					//SS7 MG/M2UA Voice Channels
					$table_name = $card . "_" . $array[$b]['id'] . "_m2ua_channels";
					$table = $data->check_for_table ($db_location, $table_name);
					if ($table > 1)
						$data->drop_table($db_location, $table_name);
		
					$new_table = $table_name;
					$table_name = "perm_" . $table_name;
					$data->select_into ($db_location, $table_name, "*", $new_table);
				}
			}
			
			//copy back the linkset/route/isup tables from permanent tables
			//drop tables
			$table_name = "m2ua_clusters";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
				
			$table_name = "ss7_linkset_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
	
			$table_name = "ss7_isup_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
	
			$table_name = "ss7_route_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "sctp_interfaces";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			//Pull cluster info and drop cluster tables
			$clusters = $this->get_generic_profiles($db_location,'m2ua_clusters','profile_name',$data,&$counter);
			if (isset($clusters)) {
				foreach ($clusters as $cluster) {
					$table = $cluster['profile_name'].'_peers';
					if ($data->check_for_table($db_location,$table) > 1 )
						$data->drop_table($db_location,$table);						
				}
			}	
				
			//PRI Profile Restore
			$table_name = "t1e1_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
							
			$new_table = "t1e1_profile";
			$table_name = "perm_t1e1_profile";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);	
			
			//MG Profile restore
			$table_name = "mg_profiles";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$new_table = "mg_profiles";
			$table_name = "perm_mg_profiles";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);
			
			//R2 Profile restore
			$table_name = "r2_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$new_table = "r2_profile";
			$table_name = "perm_r2_profile";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);			
				
			$new_table = "configured_channels";						
			$table_name = "perm_configured_channels";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
			{
				//Copy results to a perm table to store the last number of configured channels
				$data->select_into($db_location,$table_name, "*", $new_table);
				$data->drop_table($db_location, $table_name);
			}		
			
			//SS7 Linkset Restore	
			$table_name = "ss7_linkset_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
									

			$table_name = "perm_ss7_linkset_profile";
			$new_table = "ss7_linkset_profile";
			$parameters = "id, profile_name, apc, minactive";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);		
			
			//SS7 Route Restore
			$table_name = "ss7_route_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);						
			
			$table_name = "perm_ss7_route_profile";
			$new_table = "ss7_route_profile";
			$parameters = "id, profile_name, dpc, linksets, stp";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);
			
			//SS7 ISUP Restore
			$table_name = "ss7_isup_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
							
			$table_name = "perm_ss7_isup_profile";
			$new_table = "ss7_isup_profile";
			$parameters = "id, profile_name, spc, ssf, route, t6, t9";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);	
			
			//SCTP Interface restore
			$table_name = "sctp_interfaces";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
							
			$new_table = "sctp_interfaces";
			$table_name = "perm_sctp_interfaces";
			$parameters = "*";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);
			
			//Cluster Restore
			//Pull cluster info and create cluster tables
			$clusters = $this->get_generic_profiles($db_location,'perm_m2ua_clusters','profile_name',$data,&$counter);
			if (isset($clusters)) {
				foreach ($clusters as $cluster) {
					$table_name = 'perm_'.$cluster['profile_name'].'_peers';
					$new_table=$cluster['profile_name'].'_peers';
					$parameters = "*";
					if ($data->check_for_table($db_location,$new_table) > 1 )
						$data->drop_table($db_location, $cluster['profile_name'].'_peers');
					
					if ($data->check_for_table($db_location,$table_name) > 1 )
						$data->select_into ($db_location, $table_name, $parameters, $new_table);					
				}
			}	
			
			$table_name = "m2ua_clusters";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);			
			
			$table_name = "perm_m2ua_clusters";
			$new_table = "m2ua_clusters";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);	
				
			//Finished ports
			$table_name = "finished_ports";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
							
			$new_table = "finished_ports";
			$table_name = "perm_finished_ports";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);				
				

			//MG Profile restore
			$table_name = "mg_profiles";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$new_table = "mg_profiles";
			$table_name = "perm_mg_profiles";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);


		}
		unset ($_SESSION['created']);
	}
	
	if ($input['generate'] == "Generate Config")
	{
		//Call the Wanpipe Configuration PHP class to generate wanpipeX.conf
		//Wanpipe configurations different whether using dahdi or freetdm
		
		//Retrieve the card, total cards, # of ports per card, total spans
		//Opens a database connection
		$m2ua_link = false;
		$m2ua = 0;
		$mg_chan = 0;
		
		//Sets up for relay/standalone setup
		$table_exists = $data->check_for_table('sqlite:sqlite/relay_info.db','relay_hosts');
		
		if ($table_exists > 1)
		{
			$count_hosts = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','count(id)',"");
			if ($count_hosts['count(id)'] == "")
				$count_hosts['count(id)'] = 1;
		}
		elseif ($table_exists < 2)
			$count_hosts['count(id)'] =1 ;
		
		$a = 1;
		$e = 1;
		for ($k = 1; $k <= $count_hosts['count(id)']; $k++)
		{
			//$card_num = array();
			if ($k == 1)
				$db_location = "sqlite:sqlite/cardinfo.db";
			elseif ($k > 1)
				$db_location = "sqlite:sqlite/cardinfo" . $k . ".db";
			
			$select = "SELECT id, dev_name FROM card_present;";
	
			//While Loop Counter
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);
				
				foreach($result as $row)
				{
					$allcards[$e] = $row;
	
					$alldevice[$e]['dev_name'] = $tokenization->tokenize_wanpipe($allcards[$e]['dev_name']);
					//echo "Device name = " . $device[$a]['dev_name'] . "<br />";
					//echo "Card number = " . $cards[$a]['id'] . "<br />"; 				
					
					$table_name = $alldevice[$e]['dev_name'] . "_" . $allcards[$e]['id'];
					//echo "Table = " . $table_name . "<br />";
					$hw_table = $data->check_for_table ($db_location, $table_name);				
					$table_name = $alldevice[$e]['dev_name'] . "_" . $allcards[$e]['id'] . "_signalling";
					//echo "Table = " . $table_name . "<br />";
					$sig_table = $data->check_for_table ($db_location, $table_name);
					
					$table_name = $alldevice[$e]['dev_name'] . "_" . $allcards[$e]['id'] . "_r2_signalling";
					//echo "Table = " . $table_name . "<br />";
					$r2_table = $data->check_for_table ($db_location, $table_name);
					
					$table_name = $alldevice[$e]['dev_name'] . "_" . $allcards[$e]['id'] . "_SS7_link";
					//echo "Table = " . $table_name . "<br />";
					$ss7_link = $data->check_for_table ($db_location, $table_name);
					
					$table_name = $alldevice[$e]['dev_name'] . "_" . $allcards[$e]['id'] . "_SS7_ccspans";
					//echo "Table = " . $table_name . "<br />";
					$ss7_ccspans = $data->check_for_table ($db_location, $table_name);		
					
					$table_name = $alldevice[$e]['dev_name'] . "_" . $allcards[$e]['id'] . "_m2ua_link";
					//echo "Table = " . $table_name . "<br />";
					$m2ua_link = $data->check_for_table ($db_location, $table_name);					
					
					$table_name = $alldevice[$e]['dev_name'] . "_" . $allcards[$e]['id'] . "_m2ua_channels";
					//echo "Table = " . $table_name . "<br />";
					$m2ua_channels = $data->check_for_table ($db_location, $table_name);													
									
					$e++;
					
					$cards[$a] = $row;
	
					$device[$a]['dev_name'] = $tokenization->tokenize_wanpipe($cards[$a]['dev_name']);
					//echo "Device name = " . $device[$a]['dev_name'] . "<br />";
					//echo "Card number = " . $cards[$a]['id'] . "<br />"; 				
					
					$table_name = $device[$a]['dev_name'] . "_" . $cards[$a]['id'];

					//echo "Table = " . $table_name . "<br />";
					$hw_table = $data->check_for_table ($db_location, $table_name);				
					$table_name = $device[$a]['dev_name'] . "_" . $cards[$a]['id'] . "_signalling";
					//echo "Table = " . $table_name . "<br />";
					$sig_table = $data->check_for_table ($db_location, $table_name);
					
					$table_name = $alldevice[$a]['dev_name'] . "_" . $allcards[$a]['id'] . "_r2_signalling";
					//echo "Table = " . $table_name . "<br />";
					$r2_table = $data->check_for_table ($db_location, $table_name);
					//echo $r2_table;
					$table_name = $device[$a]['dev_name'] . "_" . $cards[$a]['id'] . "_SS7_link";
					//echo "Table = " . $table_name . "<br />";
					$ss7_link = $data->check_for_table ($db_location, $table_name);
					
					$table_name = $device[$a]['dev_name'] . "_" . $cards[$a]['id'] . "_SS7_ccspans";
					//echo "Table = " . $table_name . "<br />";
					$ss7_ccspans = $data->check_for_table ($db_location, $table_name);								
					
					$table_name = $device[$a]['dev_name'] . "_" . $cards[$a]['id'] . "_m2ua_link";
					//echo "Table = " . $table_name . "<br />";
					$m2ua_link = $data->check_for_table ($db_location, $table_name);					
					
					$table_name = $device[$a]['dev_name'] . "_" . $cards[$a]['id'] . "_m2ua_channels";
					//echo "Table = " . $table_name . "<br />";
					$m2ua_channels = $data->check_for_table ($db_location, $table_name);					
					
					//echo "Hardware = $hw_table & sig = $m2ua_channels <br />";
					if ($hw_table > 1 && $sig_table > 1 || $hw_table >1 && $ss7_ccspans >1 && $ss7_link >1 || $hw_table > 1 && $m2ua_link > 1 || $hw_table > 1 && $m2ua_channels > 1 || $hw_table > 1 && $r2_table > 1)
					{
						$device[$a]['proc_id'] = $k;
						$cards[$a]['proc_id'] = $k;
						//echo "Device = " .  $device[$a]['dev_name']  . "<br />";
						//echo "Card number = " . $cards[$a]['id'] . "<br />"; 
						$card_num[$a]['id'] = $cards[$a]['id'];				
						$a++;						
					}
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				print 'Exception : '.$e->getMessage();
			}
			
			//print_r ($cards);
			//echo "$e and $a<br />";
			//Drop the generate table then re-create the generate table
			$table_name = "generated_ports";
			
			$table = $data->check_for_table ($db_location, $table_name);
			
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			//Creates generated ports table
			$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30), wanpipe varchar(20), mtp2_name varchar(10), mtp3_name varchar(10), mg_name varchar(30), cluster_name varchar(30), m2ua_link_name varchar(30), pri_profile varchar(30), r2_profile varchar(30)";
			$data->create_table($db_location, $table_name, $parameters);			
	
			//Drop all permanent tables
			for ($b = 1; $b < $e; $b++)
			{
				$card = $tokenization->tokenize_wanpipe($allcards[$b]['dev_name']);
				//echo "Card number = " . $card_num[$b]['id'] . "<br />";
				$table_name = "perm_" . $card . "_" . $allcards[$b]['id'];
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);
				
				$table_name = "perm_" . $card . "_" . $allcards[$b]['id'] . "_signalling";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);	
				
				$table_name = "perm_" . $card . "_" . $allcards[$b]['id'] . "_r2_signalling";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);					
				
				$table_name = "perm_" . $card . "_" . $allcards[$b]['id'] . "_SS7_link";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);	
				
				$table_name = "perm_" . $card . "_" . $allcards[$b]['id'] . "_SS7_ccspans";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);	
				
				$table_name = "perm_" . $card . "_" . $allcards[$b]['id'] . "_m2ua_link";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);	
				
				$table_name = "perm_" . $card . "_" . $allcards[$b]['id'] . "_m2ua_channels";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);	
					
				$table_name = "perm_finished_ports";
				$table = $data->check_for_table ($db_location, $table_name);
				if ($table > 1)
					$data->drop_table($db_location, $table_name);						
			}
			unset($card);
			//Recreate all the required perm tables
			for ($b = 1; $b < $a; $b++)
			{
				$card = $tokenization->tokenize_wanpipe($cards[$b]['dev_name']);
				if ($card == "A101" || $card == "A102" || $card == "A104" || $card == "A108" || $card == "A116")
				{
					//echo "I am here <br />";
	
					//Hardware Table Creation
					$name = $card . "_" . $cards[$b]['id'];
					//echo $name . "<br />";
					$table = $data->check_for_table ($db_location, $name);
					//echo "table = $table<br />";
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'];
						$param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), coding varchar(10), framing varchar(10), clock varchar(30), ref_clock int, echo varchar(30), dtmf varchar(30), dtmf_removal varchar(30), fax varchar(30), lbo varchar(30), txtristate varchar(30), sigmode varchar(10), impedence varchar(30), rx_level varchar(30), rxgain decimal(10,2), txgain decimal(10,2), pre_buffer_size int";
						$data->create_table($db_location, $table_name, $param);
					}

					//Signalling Table Creation
					$name = $card . "_" . $cards[$b]['id'] . "_signalling";
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_signalling";
						if ($_SESSION['freetdm'] != "")
							$param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, ton_name varchar(30), ton_value varchar(30),  npi_name varchar(30), npi_value varchar(30), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), overlap varchar(30)";
						elseif ($_SESSION['dahdi'] != "")
							$param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, context varchar(60)";
						$data->create_table($db_location, $table_name, $param);
					}
					
					if ($_SESSION['freetdm'] != "")
					{
						//R2 Signalling Table Creation
						$name = $card . "_" . $cards[$b]['id'] . "_r2_signalling";
						$table = $data->check_for_table ($db_location, $name);
						if ($table > 1)
						{
							$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_r2_signalling";
							$param = "port_id int primary key, dev_name varchar(60), r2_profile varchar(60), line_type, channels varchar(60), group_num int";
							$data->create_table($db_location, $table_name, $param);
						}						
						
						$name = $card . "_" . $cards[$b]['id'] . "_SS7_link";
						$table = $data->check_for_table ($db_location, $name);
						if ($table > 1) {
							$param = "port_id int primary key, link_name varchar(60), span int, sig_channel int, error_type varchar(30), lssu int, priority int, switchtype varchar(30), SSF varchar(30), SLC int, link_type varchar(30), line_type varchar(10), linkset varchar(60), voice varchar(10)";
							//$data->create_table($db_location, $table_name, $param);	
						}
						
						$name = $card . "_" . $cards[$b]['id'] . "_SS7_ccspans";
						$table = $data->check_for_table ($db_location, $name);
						if ($table > 1) {
							$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_SS7_ccspans";
							$param = "port_id int primary key, profile_name varchar(60), isup varchar(30), cic varchar(30), channels varchar(30), min_digits int, clg_nadi int, cld_nadi int, rdnis_nadi int, obci_bita int, typeCntrl varchar(30), group_num int, lpa int, transparent_iam varchar(30), itx varchar(30), transparent_iam_timeout int, cpg_on_progress varchar(30), cpg_on_progress_media varchar(30), t10 int, t35 int";	
							//$data->create_table($db_location, $table_name, $param);					
						}
					}
				}
				elseif ($card == "B601")
				{
					$name = $card . "_" . $cards[$b]['id'];
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'];
	
						$param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), coding varchar(10), framing varchar(10), clock varchar(30), ref_clock int, echo varchar(30), dtmf varchar(30), fax varchar(30), lbo varchar(30), txtristate varchar(30), sigmode varchar(10), impedence varchar(30), rx_level varchar(30), rxgain decimal(10,2), txgain decimal(10,2)";
					
						$data->create_table($db_location, $table_name, $param);
					}
				
					$name = $card . "_" . $cards[$b]['id'] . "_signalling";
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_signalling";
						if ($_SESSION['freetdm'] != "")
						$param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, ton_name varchar(30), ton_value varchar(30),  npi_name varchar(30), npi_value varchar(30), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), codec varchar(10), operation_mode varchar(10)";
						elseif ($_SESSION['dahdi'] != "")
							$param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, context varchar(60), codec varchar(10), operation_mode varchar(10)";
		
						$data->create_table($db_location, $table_name, $param);	
					}
					
					if ($_SESSION['freetdm'] != "")
					{
						$name = $card . "_" . $cards[$b]['id'] . "_SS7_link";
						$table = $data->check_for_table ($db_location, $name);
						if ($table > 1)
						{
							$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_SS7_link";
							$param = "port_id int primary key, link_name varchar(60), span int, sig_channel int, error_type varchar(30), lssu int, priority int, switchtype varchar(30), SSF varchar(30), SLC int, link_type varchar(30), line_type varchar(10), linkset varchar(60), voice varchar(10)";
		
							$data->create_table($db_location, $table_name, $param);
						}
						
						$name = $card . "_" . $cards[$b]['id'] . "_SS7_ccspans";
						$table = $data->check_for_table ($db_location, $name);
						if ($table > 1)
						{
							$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_SS7_ccspans";
							$param = "port_id int primary key, profile_name varchar(60), isup varchar(30), cic varchar(30), channels varchar(30), min_digits int, clg_nadi int, cld_nadi int, rdnis_nadi int, obci_bita int, typeCntrl varchar(30), lpa int, transparent_iam varchar(30), itx varchar(30), transparent_iam_timeout int, cpg_on_progress varchar(30), cpg_on_progress_media varchar(30), t10 int, t35 int";

							$data->create_table($db_location, $table_name, $param);					
						}
					}							
				}
				elseif ($card == "A500")
				{
					$name = $card . "_" . $cards[$b]['id'];
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'];
						$param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
						$data->create_table($db_location, $table_name, $param);
					}
					
					$name = $card . "_" . $cards[$b]['id'] . "_signalling";
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_signalling";
						if ($_SESSION['freetdm'] != "")
							$param = "id int primary key, dev_name varchar(60), profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, overlap varchar(10), ton_name varchar(30), ton_value varchar(30), npi_name varchar(30), npi_value varchar(30), bearer_ITC varchar(30), bearer_UIL varchar(30), msn int, channels varchar(60), group_num int, min_digits int";
						elseif ($_SESSION['dahdi'] != "")
							$param = "id int primary key, dev_name varchar(60),  profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, channels varchar(60), group_num int, context varchar(60)";
			
						$data->create_table($db_location, $table_name, $param);
					}
				}
				elseif ($card == "A200" || $card == "A400" || $card == "B600")
				{
					$name = $card . "_" . $cards[$b]['id'];
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'];
						$param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), network_sync varchar(10) , rxgain decimal(10,2), txgain decimal(10,2)";
						$data->create_table($db_location, $table_name, $param);
					}
					
					$name = $card . "_" . $cards[$b]['id'] . "_signalling";
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_signalling";
						if ($_SESSION['freetdm'] != "")
							$param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), codec varchar(10), operation_mode varchar(10), group_num int";
						elseif ($_SESSION['dahdi'] != "")
							$param = "port_id int primary key,  dev_name varchar(60), profile_name varchar(60), codec varchar(10), operation_mode varchar(10), group_num int, context varchar(30)";
			
						$data->create_table($db_location, $table_name, $param);
					}
				}
				elseif ($card == "B700")
				{
					$name = $card . "_" . $cards[$b]['id'] . "_signalling";
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'];
						$param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
						$data->create_table($db_location, $table_name, $param);
					}
				
					$name = $card . "_" . $cards[$b]['id'] . "_signalling";
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
					{
						$table_name = "perm_" . $card . "_" . $cards[$b]['id'] . "_signalling";
						if ($_SESSION['freetdm'] != "")
							$param = "id int primary key, dev_name varchar(60), profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, overlap varchar(10), ton_name varchar(30), ton_value varchar(30), npi_name varchar(30), npi_value varchar(30), bearer_ITC varchar(30), bearer_UIL varchar(30), msn int, channels varchar(60), group_num int, codec varchar(10), operation_mode varchar(10), min_digits int";
						elseif ($_SESSION['dahdi'] != "")
							$param = "id int primary key, dev_name varchar(60),  profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, channels varchar(60), group_num int, context varchar(60), codec varchar(10), operation_mode varchar(10)";
			
						$data->create_table($db_location, $table_name, $param);
					}
				}			
			}		
			$license_spans = 0;
			//generated_ports span number counter
			$ll = 0;
			
			//Start a loop from counter $a and copy all the tables that are complete into the permanent tables
			//Discard partially completed configurations.
			//A line must exist for both the hardware table and the signalling table
			//i.e port numbers much match in both tables
			for ($c = 1; $c < $a; $c++)
			{	
				$device[$c]['dev_name'] = $tokenization->tokenize_wanpipe($cards[$c]['dev_name']);
				//$card_num = $c;
				$card_number = $cards[$c]['id'];
				
				$table_name = $device[$c]['dev_name'] . "_" . $card_number;
				
				$total = $data->check_for_table ($db_location, $table_name);
				
				if ($total > 1)
				{
					try
					{
						$select = "SELECT port_id FROM ". $table_name . " ORDER BY port_id;";
						//echo "Device = " . $device[$c]['dev_name'] . "<br />";
						//echo "SQL Select = $select<br />";
						//While Loop Counter
						$port_count = 0;
		
						//open the database
						$db = new PDO($db_location);
	
						$result = $db->query($select);
							
						foreach($result as $row)
						{			
							$array[$port_count] = $row;
							$port_count++;
						}
						// close the database connection
						$db = NULL;
					}
					catch(PDOException $e)
					{
						print 'Exception : '.$e->getMessage();
					}				
				}
				$device[$c]['port_num']	= $port_count;
								
				unset($hw_information);
				unset($sig_information);
				unset($r2_information);
				unset($ss7_ccspans_information);
				unset($ss7_link_information);
				unset($m2ua_link_information);
				unset($m2ua_channels_information);
				$r2_span=0;
				
				if ($device[$c]['proc_id'] == $k)
				{
				for ($x = 0; $x < $port_count; $x++)
				{	
					$table_name = $device[$c]['dev_name'] . "_" . $card_number;
					$param = "*";
					//echo $device[$c]['dev_name'] . " before config port id = " . $array[$x]['port_id'] . "<br />";
					//echo 'Card Num = ' . $card_num . ' ' . $device[$c]['dev_name'] . " before config port id = " . $array[$x]['port_id'] . "<br />";

					if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116" || $device[$c]['dev_name'] == "A200" || $device[$c]['dev_name'] == "A400" || $device[$c]['dev_name'] == "B600" || $device[$c]['dev_name'] == "B601")
						$where_param = "port_id = " . $array[$x]['port_id'];
					elseif ($device[$c]['dev_name'] == "A500" || $device[$c]['dev_name'] == "B700")
						$where_param = "port_id = " . $array[$x]['port_id'];				
							
					//$name = $card . "_" . $card_num;
					$name = $device[$c]['dev_name'] . "_" . $card_number;
					//$name = $device[$c]['hw_table_name'];
					$table = $data->check_for_table ($db_location, $name);
					if ($table > 1)
						$hw_information = $data->select_statement ($db_location, $name, $param, $where_param);
					
					//print_r ($hw_information);
					//echo "<br />";
					
					$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_signalling";
					$param = "*";
	
					if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116" || $device[$c]['dev_name'] == "A200" || $device[$c]['dev_name'] == "A400" || $device[$c]['dev_name'] == "B600" || $device[$c]['dev_name'] == "B601")
						$where_param = "port_id = " . $array[$x]['port_id'];
					elseif ($device[$c]['dev_name'] == "A500" || $device[$c]['dev_name'] == "B700" )
						$where_param = "id = " . $array[$x]['port_id'];
					
					$table = $data->check_for_table ($db_location, $table_name);
					if ($table > 1)
						$sig_information = $data->select_statement ($db_location, $table_name, $param, $where_param);
					
					
					if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116" ||$device[$c]['dev_name'] == "B601")
					{
						$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_r2_signalling";
						$param = "*";
						$where_param = "port_id = " . $array[$x]['port_id'];
						
						if ($data->check_for_table ($db_location, $table_name) > 1)
							$r2_information = $data->select_statement ($db_location, $table_name, $param, $where_param);
						//print_r ($r2_information);
						$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_SS7_link";
						$param = "*";
						$where_param = "port_id = " . $array[$x]['port_id'];
						
						$table = $data->check_for_table ($db_location, $table_name);
						if ($table > 1)
						{
							$ss7_exist = "yes";
							$ss7_link_information = $data->select_statement ($db_location, $table_name, $param, $where_param);
							//echo $ss7_link_information['link_name'] . "<br />";
						}
						
						$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_SS7_ccspans";
						$param = "*";					
						$where_param = "port_id = " . $array[$x]['port_id'];
					
						$table = $data->check_for_table ($db_location, $table_name);
						if ($table > 1)
							$ss7_ccspans_information = $data->select_statement ($db_location, $table_name, $param, $where_param);
							
						$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_channels";
						$param = "*";					
						$where_param = "port_id = " . $array[$x]['port_id'];
					
						$table = $data->check_for_table ($db_location, $table_name);
						if ($table > 1) {
							$ss7_exist = "yes";
							$m2ua_channels_information = $data->select_statement ($db_location, $table_name, $param, $where_param);							
						}
						
						$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_link";
						$param = "*";					
						$where_param = "port_id = " . $array[$x]['port_id'];
					
						$table = $data->check_for_table ($db_location, $table_name);
						if ($table > 1) {
							$ss7_exist = "yes";
							$m2ua_link_information = $data->select_statement ($db_location, $table_name, $param, $where_param);							
						}						
							
					}
					//If a device name exists for both tables, then the card is configured
					//Proceeds 
					//echo "Last proc_id = $last_procID  Hardware = " . $hw_information['dev_name'] . " SS7 Link = " . $ss7_link_information['link_name'] . " CCSpans = " . $ss7_ccspans_information['profile_name'] . "<br />";
					if (($hw_information['dev_name'] != "" && $sig_information['dev_name'] != "") || ($hw_information['dev_name'] != "" && $r2_information['dev_name'] != "") || ($hw_information['dev_name'] != "" && $ss7_link_information['link_name'] != "" && $ss7_ccspans_information['profile_name'] != "" ) || ($hw_information['dev_name'] != "" && $m2ua_link_information['link_name'] != "") || ($hw_information['dev_name'] != "" && $m2ua_channels_information['profile_name'] != ""))
					{
						//echo "Card information secured <br />";
						$ll++;
						//Insert physical hardware information into genrated ports table
						$generate_table = "generated_ports";
						$card_info = $device[$c]['dev_name'] . "_" . $card_number . "_" . $array[$x]['port_id'];
						$insert_generate = "id, card, completed";
						$insert_gererate_values = $ll . ", \"" . $card_info . "\", \"yes\"";
						$data->insert_statement($db_location, $generate_table, $insert_generate, $insert_gererate_values);					
						
						//echo $device[$c]['dev_name'] . " before config port id = " . $array[$x]['port_id'] . "<br />";
						//Check in perm_card_card-num
						$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number;
						$perm_parameters = "dev_name";
						
						if ($device[$c]['dev_name'] == "A116" || $device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A200" || $device[$c]['dev_name'] == "A400" || $device[$c]['dev_name'] == "B600" || $device[$c]['dev_name'] == "B601")
							$perm_where_param = "port_id = " . $array[$x]['port_id'];
						elseif ($device[$c]['dev_name'] == "A500" || $device[$c]['dev_name'] == "B700")
							$perm_where_param = "port_id = " . $array[$x]['port_id'];
						
						$perm_hw_information = $data->select_statement ($db_location, $perm_table_name, $perm_parameters, $perm_where_param);		
	
						if ($perm_hw_information['dev_name'] == "")
						{
							if ($device[$c]['dev_name'] == "B601")
								$b601_port[$x] = $array[$x]['port_id'];

							//Insert
							if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] ==  "A116" || $device[$c]['dev_name'] == "B601")
							{
								$insert_param = "port_id, dev_name, line_type, coding, framing, clock, ref_clock, echo, dtmf, dtmf_removal,  fax, lbo, txtristate, sigmode, impedence, rx_level, rxgain, txgain, pre_buffer_size";
								$insert_values = "\"" . $hw_information['port_id'] . "\", \"" . $hw_information['dev_name'] . "\", \"" .$hw_information['line_type'] . "\", \"" .$hw_information['coding'] . "\", \"" . $hw_information['framing'] . "\", \"" . $hw_information['clock'] . "\",\"" . $hw_information['ref_clock'] . "\", \"" .$hw_information['echo']. "\", \"" . $hw_information['dtmf'] . "\", \"" . $hw_information['dtmf_removal'] . "\", \"" . $hw_information['fax'] . "\", \"" . $hw_information['lbo'] . "\", \"" . $hw_information['txtristate'] . "\", \"" . $hw_information['sigmode'] . "\", \"" . $hw_information['impedence'] . "\", \"" . $hw_information['rx_level'] . "\", \"" . $hw_information['rxgain'] . "\", \"" . $hw_information['txgain'] . "\", \"" . $hw_information['pre_buffer_size'] . "\"";

								$data->insert_statement($db_location, $perm_table_name, $insert_param, $insert_values);								
							}
							elseif ($device[$c]['dev_name'] == "A500" || $device[$c]['dev_name'] == "B700")
							{
								$insert_param = "port_id, conn_type, dev_name, hw_ec, hw_dtmf, hw_fax, txgain, rxgain";
								$insert_values = $hw_information['port_id'] . ", \"" . $hw_information['conn_type'] . "\",  \"" . $hw_information['dev_name'] . "\", \"" . $hw_information['hw_ec'] . "\", \"" . $hw_information['hw_dtmf'] . "\", \"" . $hw_information['hw_fax'] . "\", \"" . $hw_information['txgain'] . "\", \"" . $hw_information['rxgain'] . "\"";							
								$data->insert_statement($db_location, $perm_table_name, $insert_param, $insert_values);
							}
							elseif ($device[$c]['dev_name'] == "A200" || $device[$c]['dev_name'] == "A400" || $device[$c]['dev_name'] == "B600")
							{
								$insert_param = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, network_sync, txgain, rxgain";	
								$insert_values = $hw_information['port_id'] . ", \"" . $hw_information['dev_name'] . "\",\"" . $hw_information['hw_ec'] . "\", \"" . $hw_information['hw_dtmf']. "\", \"" . $hw_information['hw_fax'] . "\", \"" . $hw_information['network_sync'] . "\", \"" . $hw_information['txgain'] . "\", \"" . $hw_information['rxgain'] . "\"";
								$data->insert_statement($db_location, $perm_table_name, $insert_param, $insert_values);
							}
							
						}
						
						//Check in perm_card_card-num_signalling
						$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_signalling";
						$perm_parameters = "dev_name";
	
						if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116")
							$perm_where_param = "port_id = " . $array[$x]['port_id'];
						elseif ($device[$c]['dev_name'] == "A500" || $device[$c]['dev_name'] == "B700")
							$perm_where_param = "id = " . $array[$x]['port_id'];
						
						$table = $data->check_for_table ($db_location, $perm_table_name);
						//echo "$table <br />";
						if ($table > 1)
						{
							$perm_sig_information = $data->select_statement ($db_location, $perm_table_name, $perm_parameters, $perm_where_param);
	
							if ($perm_sig_information['dev_name'] == "")
							{
								//Insert
								if ($_SESSION['dahdi'] != "")
								{
									if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116")
									{
										$insert_param = "port_id, dev_name, line_type, signalling, channels, group_num, context";
										$insert_values = "\"" . $sig_information['port_id'] . "\", \"" . $sig_information['dev_name'] . "\", \"". $sig_information['line_type'] . "\", \"". $sig_information['signalling'] . "\", \"". $sig_information['channels'] . "\", \"". $sig_information['group_num'] . "\", \"". $sig_information['context'] . "\"" ;						
									}
									elseif ($device[$c]['dev_name'] == "A500")
									{
										$insert_param = "id, dev_name , profile_name, conn_type, sig_type, interface, switchtype, tei";
										$insert_values = "" . $sig_information['id'] . ", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"" . $sig_information['conn_type'] . "\", \"" . $sig_information['sig_type'] . "\", \"" . $sig_information['interface'] . "\", \"" . $sig_information['switchtype'] . "\", \"" . $sig_information['tei'] . "\"";
									}
									elseif ($device[$c]['dev_name'] == "B700")
									{
										$insert_param = "id, dev_name , profile_name, conn_type, sig_type, interface, switchtype, tei, codec, operation_mode";
										$insert_values = "" . $sig_information['id'] . ", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"" . $sig_information['conn_type'] . "\", \"" . $sig_information['sig_type'] . "\", \"" . $sig_information['interface'] . "\", \"" . $sig_information['switchtype'] . "\", \"" . $sig_information['tei'] . "\", \"" . $sig_information['codec'] . "\", \"" . $sig_information['operation_mode'] . "\"";
									}
									elseif ($device[$c]['dev_name'] == "B601")
									{
										$insert_param = "port_id, dev_name, profile_name, line_type, signalling, channels, group_num, context, codec, operation_mode";
										$insert_values = "\"" . $sig_information['port_id'] . "\", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"". $sig_information['line_type'] . "\", \"". $sig_information['signalling'] . "\", \"". $sig_information['channels'] . "\", \"". $sig_information['group_num'] . "\", \"". $sig_information['context'] . "\", \"" . $sig_information['codec'] . "\", \"" . $sig_information['operation_mode'] . "\"";		
									}							
								}
								elseif ($_SESSION['freetdm'] != "")
								{
									if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116")
									{		
										//echo "Port = "  . $array[$x]['port_id'] . "<br />";				
										$insert_param = "port_id, dev_name, line_type, signalling, channels, group_num, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap";
										$insert_values = "\"" . $sig_information['port_id'] . "\", \"" . $sig_information['dev_name'] . "\", \"". $sig_information['line_type'] . "\", \"". $sig_information['signalling'] . "\", \"". $sig_information['channels'] . "\", \"". $sig_information['group_num'] . "\", \"" . $sig_information['ton_name'] . "\",\"" . $sig_information['ton_value'] . "\",\"" . $sig_information['npi_name'] . "\",\"" . $sig_information['npi_value'] . "\",\"" . $sig_information['facility'] . "\",\"" . $sig_information['facility_timeout'] . "\", \"" . $sig_information['bearer_ITC'] . "\", \"" . $sig_information['bearer_UIL'] . "\", \"" . $sig_information['overlap'] . "\"";	
										
										$generate_update = "type = \"PRI\", pri_profile=\"" . $sig_information['signalling'] . "\"";
										
										if (($sig_information['line_type'] == "E1") || ($hw_information['line_type'] == "E1" && $sig_information['line_type'] != ""))
											$license_spans = 31 + $license_spans;
										elseif (($sig_information['line_type'] == "T1") || ($hw_information['line_type'] == "T1" && $sig_information['line_type'] != ""))
											$license_spans = 24 + $license_spans;											
										
									}
									elseif ($device[$c]['dev_name'] == "A500")
									{
										$insert_param = "id, dev_name, profile_name, conn_type, sig_type, interface, switchtype, tei, overlap, ton_name, ton_value, npi_name, npi_value, bearer_ITC, bearer_UIL, msn, min_digits";
										$insert_values = "" . $sig_information['id'] . ", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"" . $sig_information['conn_type'] . "\", \"" . $sig_information['sig_type'] . "\", \"" . $sig_information['interface'] . "\", \"" . $sig_information['switchtype'] . "\", \"" . $sig_information['tei'] . "\", \"" . $sig_information['overlap'] . "\", \"" . $sig_information['ton_name'] . "\", \"" . $sig_information['ton_value'] . "\", \"" . $sig_information['npi_name'] . "\", \"" . $sig_information['npi_value'] . "\", \"" . $sig_information['bearer_ITC'] . "\", \"" . $sig_information['bearer_UIL'] . "\", \"" . $sig_information['msn'] . "\", \"" . $sig_information['min_digits'] . "\"";
										$generate_update = "type = \"BRI\"";
									}
									elseif ($device[$c]['dev_name'] == "B700")
									{
										$insert_param = "id, dev_name, profile_name, conn_type, sig_type, interface, switchtype, tei, overlap, ton_name, ton_value, npi_name, npi_value, bearer_ITC, bearer_UIL, msn, codec, operation_mode, min_digits";
										$insert_values = "" . $sig_information['id'] . ", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"" . $sig_information['conn_type'] . "\", \"" . $sig_information['sig_type'] . "\", \"" . $sig_information['interface'] . "\", \"" . $sig_information['switchtype'] . "\", \"" . $sig_information['tei'] . "\", \"" . $sig_information['overlap'] . "\", \"" . $sig_information['ton_name'] . "\", \"" . $sig_information['ton_value'] . "\", \"" . $sig_information['npi_name'] . "\", \"" . $sig_information['npi_value'] . "\", \"" . $sig_information['bearer_ITC'] . "\", \"" . $sig_information['bearer_UIL'] . "\", \"" . $sig_information['msn'] . "\",\"" . $sig_information['codec'] . "\",\"" . $sig_information['operation_mode'] . "\", \"" . $sig_information['min_digits'] . "\"";			
										$generate_update = "type = \"Hybrid BRI/Analog\"";				
									}
									elseif ($device[$c]['dev_name'] == "B601")
									{
										$insert_param = "port_id, dev_name, profile_name, line_type, signalling, channels, group_num, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, codec, operation_mode, overlap";
										$insert_values = "\"" . $sig_information['port_id'] . "\", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"". $sig_information['line_type'] . "\", \"". $sig_information['signalling'] . "\", \"". $sig_information['channels'] . "\", \"". $sig_information['group_num'] . "\", \"" . $sig_information['ton_name'] . "\",\"" . $sig_information['ton_value'] . "\",\"" . $sig_information['npi_name'] . "\",\"" . $sig_information['npi_value'] . "\",\"" . $sig_information['facility'] . "\",\"" . $sig_information['facility_timeout'] . "\", \"" . $sig_information['bearer_ITC'] . "\", \"" . $sig_information['bearer_UIL'] . "\",\"" . $sig_information['codec'] . "\",\"" . $sig_information['operation_mode'] . "\", \"" . $sig_information['overlap'] . "\"";									
										$generate_update = "type = \"Hybrid PRI/Analog\"";
									}							
								}
								
								if ($device[$c]['dev_name'] == "A200" || $device[$c]['dev_name'] == "A400" || $device[$c]['dev_name'] == "B600")
								{
									if ($_SESSION['freetdm'] != "")
									{
										$insert_param = "port_id, dev_name , profile_name, codec, operation_mode, group_num";
										$insert_values = "" . $sig_information['port_id'] . ", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"" . $sig_information['codec'] . "\", \"" . $sig_information['operation_mode'] . "\", \"" . $sig_information['group_num'] . "\"";
									}
									elseif ($_SESSION['dahdi'] != "")
									{
										$insert_param = "port_id, dev_name , profile_name, codec, operation_mode, group_num, context";
										$insert_values = "" . $sig_information['port_id'] . ", \"" . $sig_information['dev_name'] . "\", \"" . $sig_information['profile_name'] . "\", \"" . $sig_information['codec'] . "\", \"" . $sig_information['operation_mode'] . "\", \"" . $sig_information['group_num'] . "\", \"" . $sig_information['context'] . "\"";
									}
									$generate_update = "type = \"Analog\"";
								}							
									
								if (!empty($sig_information))					
									$data->insert_statement($db_location, $perm_table_name, $insert_param, $insert_values);
							}
							
							//Update Generate Table
							$generate_table = "generated_ports";														
							$generate_where = "id = $ll";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);														
						}
						
						//R2 Tables
						if (($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116" )&& (!empty($r2_information))) {
							//Check in perm_card_card-num_signalling
							$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_r2_signalling";						

							if ($data->check_for_table ($db_location, $perm_table_name) > 1)
							{
								$perm_parameters = "dev_name";
								$perm_where_param = "port_id = " . $array[$x]['port_id'];
								$perm_sig_information = $data->select_statement ($db_location, $perm_table_name, $perm_parameters, $perm_where_param);
		
								if ($perm_sig_information['dev_name'] == "")
								{
									$insert_param = 'port_id,dev_name,r2_profile,line_type, channels,group_num';
									$insert_values = $r2_information['port_id'] . ',"'.$r2_information['dev_name'] . '","'.$r2_information['r2_profile'].'","'.$r2_information['line_type'].'","'.$r2_information['channels'].'","'.$r2_information['group_num'].'"';
									if (!empty($r2_information))					
										$data->insert_statement($db_location, $perm_table_name, $insert_param, $insert_values);
												
									//Update Generate Table
									$generate_update = "type = \"MFC/R2\"";
									$generate_table = "generated_ports";														
									$generate_where = "id = $ll";
									$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);	

									if (($r2_information['line_type'] == "E1") || ($hw_information['line_type'] == "E1" && $r2_information['line_type'] != ""))
										$license_spans = 31 + $license_spans;
									elseif (($r2_information['line_type'] == "T1") || ($hw_information['line_type'] == "T1" && $r2_information['line_type'] != ""))
										$license_spans = 24 + $license_spans;									
									
									$r2_span++;										
								}
							}
						}
						
						//SS7 Tables
						if ($device[$c]['dev_name'] == "A101" || $device[$c]['dev_name'] == "A102" || $device[$c]['dev_name'] == "A104" || $device[$c]['dev_name'] == "A108" || $device[$c]['dev_name'] == "A116" || $device[$c]['dev_name'] == "B601")
						{
							if (($ss7_link_information['line_type'] == "E1") || ($hw_information['line_type'] == "E1" && $m2ua_channels_information['profile_name'] != "") || ($hw_information['line_type'] == "E1" && $m2ua_link_information['line_type'] != "") )
								$license_spans = 31 + $license_spans;
							elseif (($ss7_link_information['line_type'] == "T1") || ($hw_information['line_type'] == "T1" && $m2ua_channels_information['profile_name'] != "")|| ($hw_information['line_type'] == "E1" && $m2ua_link_information['line_type'] != ""))
								$license_spans = 24 + $license_spans;

							//Check in perm_card_card-num
							$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_link";
							$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_link";

							//echo "$table <br />";
							if (($data->check_for_table ($db_location, $table_name) > 1) && ($m2ua_link_information['line_type'] != ""))
							{
								$data->select_into($db_location,$table_name,"*",$perm_table_name);
								$generate_update = "type = \"M2UA Signalling Gateway\"";
								$generate_table = "generated_ports";								
								$generate_where = "id = $ll";
								$m2ua++;
								
								$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);		
	
								if ($m2ua_link_information['voice_chans'] == "yes") {
									$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_channels";
									$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_channels";
									$data->select_into($db_location,$table_name,"*",$perm_table_name);
								}
							}
							
							
							//Check in perm_card_card-num
							$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_channels";
							$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_channels";

							//echo "$table <br />";
							if (($data->check_for_table ($db_location, $table_name) > 1) && ($m2ua_channels_information['profile_name'] != "") && (!isset($m2ua_link_information['voice_chans'])) )
							{
								$mg_chan++;
								
								$data->select_into($db_location,$table_name,"*",$perm_table_name);
								$generate_update = "type = \"Media Gateway\"";
								$generate_table = "generated_ports";								
								$generate_where = "id = $ll";
								$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);			

								$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_channels";
								$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_m2ua_channels";
								$data->select_into($db_location,$table_name,"*",$perm_table_name);														
							}							
							

							//Check in perm_card_card-num
							$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_SS7_link";
							$table_name = $device[$c]['dev_name'] . "_" . $card_number . "_SS7_link";
	
							//echo "$table <br />";
							if (($data->check_for_table ($db_location, $table_name) > 1 ) &&($hw_information['dev_name'] != "" && $ss7_link_information['link_name'] != "" && $ss7_ccspans_information['profile_name'] != "" ))
							{
								$data->select_into ($db_location, $device[$c]['dev_name'] . "_" . $card_number . "_SS7_link", "*", $perm_table_name);

								
								//Update the generated ports table
								if ($ss7_link_information['voice'] == "")
									//Signalling Link
									$generate_update = "type = \"SS7 Signalling Link\"";
								else
									//Voice Link
									$generate_update = "type = \"SS7 Voice Link\"";
								
								$generate_table = "generated_ports";								
								$generate_where = "id = $ll";
								$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);								
								
								//Check in CCSpans Table
								$perm_table_name = "perm_" . $device[$c]['dev_name'] . "_" . $card_number . "_SS7_ccspans";
								$perm_parameters = "profile_name";
							
								$perm_where_param = "port_id = " . $array[$x]['port_id'];
							
								$perm_ss7_ccspans_information = $data->select_statement ($db_location, $perm_table_name, $perm_parameters, $perm_where_param);		
		
								if ($perm_ss7_ccspans_information['profile_name'] == "")
									$data->select_into ($db_location, $device[$c]['dev_name'] . "_" . $card_number . "_SS7_ccspans", "*", $perm_table_name);
							}	
						}
					}
				}
				}
			}
		
			//Create permananent linkset/route/isup tables and copy information into them
			$table_name = "perm_ss7_linkset_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
	
			$table_name = "perm_ss7_isup_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
	
			$table_name = "perm_ss7_route_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "perm_sctp_interfaces";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "perm_t1e1_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
			$table_name = "perm_r2_profile";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
				$data->drop_table($db_location, $table_name);
			
	
			$table_name = "perm_m2ua_clusters";
			$table = $data->check_for_table ($db_location, $table_name);
			if ($table > 1)
			{
				//pull cluster data and drop peer tables
				$profiles = $this->get_generic_profiles($db_location,'perm_m2ua_clusters','profile_name',$data,&$counter);

				if (isset($profiles)) {
					foreach ($profiles as $cluster) {
						$data->drop_table($db_location,'perm_'.$cluster['profile_name'].'_peers');
					}
				}
				$data->drop_table($db_location, $table_name);
				
			}
							
			$table_name = "sctp_interfaces";
			$new_table = "perm_sctp_interfaces";
			$parameters = "*";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);
			
			$new_table = "perm_t1e1_profile";
			$table_name = "t1e1_profile";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);	
			
			$new_table = "perm_r2_profile";
			$table_name = "r2_profile";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);	
			
			$new_table = "perm_finished_ports";
			$table_name = "finished_ports";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);									
			
			$new_table = "perm_m2ua_clusters";
			$table_name = "m2ua_clusters";
			$parameters = "*";	
			$data->select_into ($db_location, $table_name, $parameters, $new_table);				
			//comeback
			//Pull cluster info and place in perm_table
			$clusters = $this->get_generic_profiles($db_location,'m2ua_clusters','profile_name',$data,&$counter);
			if (isset($clusters)) {
				foreach ($clusters as $cluster) {
					$new_table = "perm_".$cluster['profile_name'].'_peers';
					$table_name = $cluster['profile_name'].'_peers';
					$parameters = "*";	
					$data->select_into ($db_location, $table_name, $parameters, $new_table);						
				}
			}
			
			$table_name = "ss7_linkset_profile";
			$new_table = "perm_ss7_linkset_profile";
			$parameters = "id, profile_name, apc, minactive";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);		
			
			$table_name = "ss7_route_profile";
			$new_table = "perm_ss7_route_profile";
			$parameters = "id, profile_name, dpc, linksets, stp";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);
			
			$table_name = "ss7_isup_profile";
			$new_table = "perm_ss7_isup_profile";
			$parameters = "id, profile_name, spc, ssf, route, t6, t9";
			$data->select_into ($db_location, $table_name, $parameters, $new_table);
			
			//Place number of spans into a database table for easy check throughout the UI
			//echo $license_spans ."<br />";
			$table = "configured_channels";
			//$db_location = "sqlite:sqlite/cardinfo.db";
			
			$data->drop_table($db_location,$table);
			
			//Create table
			$parameters = "id int primary key, channels varchar(20)";
			$data->create_table($db_location, $table, $parameters);
			
			$insert_param = "id, channels";
			$insert_values = "\"1\", \"" . $license_spans . "\"";
			$data->insert_statement($db_location, $table, $insert_param, $insert_values);
			
			if ($k == 1)
				//$db_location = "sqlite:sqlite/cardinfo.db";	
				$last_procId = 1;
			elseif ($k > 1)
				//$db_location = "sqlite:sqlite/cardinfo" . $k . ".db";
				$last_procId = $k - 1;	
			
		}
		//echo "generate <br />";
		//Starts the generation process
		//$a = Number of cards in the system
		//tokenize the dev_name
		//unset ($array);
		
		//echo "<hr />";	
		
		//=====================================================
		//CREATE FILES
		//=====================================================
		
		//$a is the number of cards in the system
		//$device[$b]['dev_name'] = Device Name (Tokenized)
		//$device[$b]['port_num'] is a calculation of the number of ports for each card that needs to be generated
		
		/*foreach ($device as $key => $value)
		{
			echo $key . "   " . $value['dev_name'] . "<br />";
		}
		
		echo "Number of elements = " . count($device) . "<br />";*/
		
		if ($m2ua > 0)
			$m2ua_link = true;
		elseif ($m2ua == 0)
			$m2ua_link = false;
			
		if ($r2_span > 0)
			$r2_link = true;
		elseif ($r2_span == 0)
			$r2_link = false;
			
		$x = 0;
		$relay_id2 = 1;
		
		//Determine the API
		if ($_SESSION['dahdi'] != "")
		{
			$API = "TDM_VOICE";
			$BRI_API = "TDM_VOICE_API";
			$BRI_SPAN = 1;
			$DAHDI_SPAN = 1;
		}
		elseif ($_SESSION['freetdm'] != "")
			$API = "TDM_VOICE_API";
		
		$a500 = $_SESSION['a500_ports'];
		$b700 = $_SESSION['b700_ports'];
		//echo "wanpipe <br />";
		
		//PERFORM SHELL_EXEC TO CREATE TEMPORARY FILES
		$relay_type = $data->select_statement('sqlite:sqlite/relay_info.db','ss7_relay','machine_type','id=1');
		//echo $relay_type['machine_type'] . "<br />";
		if ($relay_type['machine_type'] == "standalone")
		{
			//If standalone
			shell_exec("mkdir /etc/wanpipe/wanpipe_old_configs");
			shell_exec("mv /etc/wanpipe/wanpipe*.conf /etc/wanpipe/wanpipe_old_configs/");
			shell_exec("mv /etc/wanpipe/wanrouter.rc /etc/wanpipe/wanpipe_old_configs/");
		}
		else
		{
			//If relay, create wanpipe directories for each machine
			for ($ll = 1; $ll <= $count_hosts['count(id)']; $ll++)
			{
				$dir = "/tmp/relay" . $ll;
				if (!file_exists($dir) && !is_dir($dir))
				{
					if (!mkdir($dir,'0644',TRUE))
						echo "Error, unable to create RELAY" . $ll . " directory";
				}
				
				$dir1 = '/tmp/relay' . $ll . '/wanpipe';
				if (!file_exists($dir1) && !is_dir($dir1))
				{
					if (!mkdir($dir1,'0644',TRUE))
						echo "Error, unable to create WANPIPE directory";
				}
				
				$dir1 = '/tmp/relay' . $ll . '/freetdm';
				if (!file_exists($dir1) && !is_dir($dir1))
				{
					if (!mkdir($dir1,'0644',TRUE))
						echo "Error, unable to create FREETDM directory";
				}
				
				$dir1 = '/tmp/relay' . $ll . '/freetdm/freetdm_old_configs';
				if (!file_exists($dir1) && !is_dir($dir1))
				{
					if (!mkdir($dir1,'0644',TRUE))
						echo "Error, unable to create FREETDM_OLD_CONFIG directory";					
				}
				
				$dir1 = '/tmp/relay' . $ll . '/wanpipe/wanpipe_old_configs';
				if (!file_exists($dir1) && !is_dir($dir1))
				{
					if (!mkdir($dir1,'0644',TRUE))
						echo "Error, unable to create WANPIPE_OLD_CONFIG directory";
				}
				
				
				//Backup Wanpipe
				$wanpipe_file = "/tmp/relay" . $ll . "/wanpipe/wanpipe*.conf";
				$wanrouter_rc = "/tmp/relay" . $ll . "/wanpipe/wanrouter.rc";
				$wanpipe_old_dir = "/tmp/relay" . $ll . "/wanpipe/wanpipe_old_configs/";
				
				$cmd = "mv  " . $wanpipe_file . " " . $wanpipe_old_dir;
				//echo $cmd . "<br />";
				shell_exec($cmd);
				
				$cmd = "mv " . $wanrouter_rc . " " . $wanpipe_old_dir;
				//echo $cmd . "<br />";
				shell_exec($cmd);	
				
				
				//Backup freetdm
				$freetdm_conf_file = "/tmp/relay" . $ll . "/freetdm/freetdm.conf";
				$freetdm_xml_rc = "/tmp/relay" . $ll . "/freetdm/freetdm.conf.xml";
				$freetdm_old_dir = "/tmp/relay" . $ll . "/freetdm/freetdm_old_configs/";
				
				$cmd = "mv  " . $freetdm_conf_file . " " . $freetdm_old_dir;
				//echo $cmd . "<br />";
				shell_exec($cmd);
				
				$cmd = "mv " . $freetdm_xml_rc . " " . $freetdm_old_dir;
				//echo $cmd . "<br />";
				shell_exec($cmd);				
			}
		}
		
		unset($device);
		unset($array);
		//Create Wanpipe files
		for ($kk =1; $kk <= $count_hosts['count(id)'] ; $kk++)
		{
			//Set the database to read from
			if ($kk == 1)
				$db_location = "sqlite:sqlite/cardinfo.db";
			else
				$db_location = "sqlite:sqlite/cardinfo" . $kk . ".db";
			
			//echo $db_location . "<br />";
				
			$l = 0;
			
			for ($b = 1; $b < $a; $b++)
			{
				if ($cards[$b]['proc_id'] == $kk)
				{
					//echo "b = $b<br />";
					//echo "Device = " . $cards[$b]['dev_name'] . "<br />";
					//echo "port = " . $array[$b]['port_id'] . "<br />";
					
					
					$device[$b]['dev_name'] = $tokenization->tokenize_wanpipe($cards[$b]['dev_name']);
					$card_number = $cards[$b]['id'];
					//$db_location = "sqlite:sqlite/cardinfo.db";
					 
					$table_name = "perm_" . $device[$b]['dev_name'] . "_" . $card_number;
					 
					//echo "Device = " . $device[$b]['dev_name'] . ", Table name =  $table_name <br />";
					
					//Check if database exists
					$total = $data->check_for_table ($db_location, $table_name);
					//echo $total . "<br />";
					if ($total > 1)
					{
						try
						{
							$select = "SELECT port_id FROM ". $table_name . " ORDER BY port_id;";
							//echo "SQL Select statement: $select<br />";
		
		
							//While Loop Counter
							$port_count = 0;
			
							//open the database
							$db = new PDO($db_location);
							
							$result = $db->query($select);
								
							foreach($result as $row)
							{	
								//echo "Device = " . $device[$b]['dev_name']. "<br />";	
								$array[$b][$port_count] = $row['port_id'];
								$device[$b]['proc_id'] = $kk;		 
								//$array[$port_count]['port_id'] = $row['port_id'];
								//echo $device[$b]['dev_name'] . " port = " . $array[$b][$port_count]['port_id'] . "<br />"; 
								$port_count++;
							}
							// close the database connection
							$db = NULL;
						}
						catch(PDOException $e)
						{
							print 'Exception : '.$e->getMessage();
							echo "Database location = $db_location, table = $table_name<br />";
							echo "SQL Select statement = $select <br />";
						}					 
						
						$device[$b]['port_num']	= $port_count;	
						//echo $device[$b]['port_num'] . "<br />";		
					}
				}
			}
			//echo "<hr />";
			//Get the port type from the b700 hardware table
			$conn = 0;
			for ($b = 1; $b < $a; $b++)
			{
				if ($device[$b]['dev_name'] == "B700")
				{	
					$table = "perm_" . $device[$b]['dev_name'] . "_" . $cards[$b]['id'];
					$select = "SELECT port_id, conn_type FROM " . $table . " ORDER BY port_id;";
					//echo $select . "<br />";
	
					try
					{
						//open the database
						$db = new PDO($db_location);
			
						$result = $db->query($select);
					
						foreach($result as $row)
						{
							$connection[$conn] = $row['conn_type'];
							//echo "Port if = " . $row['port_id'] . "<br />";
							if ($connection[$conn] == "FXO")
								$fxo_exist = "yes";
							elseif ($connection[$conn] == "FXS")
								$fxs_exist = "yes";
							
							$conn++;
							
						}
						// close the database connection
						$db = NULL;
					}
					catch(PDOException $e)
					{
						//echo "hello <br />";
						print 'Exception : '.$e->getMessage();
					}
				}
			}					
				
			$p = 1;	
			for ($b = 1; $b < $a; $b++)
			{		
				if ($device[$b]['dev_name'] == "B700")						
				{
					for ($l = 1; $l <= count($b700); $l++)
					{
						//echo "Port = " . $a500[$l] . "<br />";echo "Port = " . $a500[$l] . "<br />";
						//Check to see which ports were configured
						//$db_location = "sqlite:sqlite/cardinfo.db";
						$table = "perm_" . $device[$b]['dev_name'] . "_" . $cards[$b]['id'] . "_signalling";
						$where = "id = " . $b700[$l];
						$result = $data->select_statement($db_location, $table, "id", $where);
						
						if ($result['id'] != "")
						{
							$b700_port[$p] = $_SESSION['b700_ports'][$l];
							//echo "Port = " . $a500_port[$p] . "<br />";
							$p++;
						}
					}
					$device[$b]['port_num']	= $p;
				}
			}			
			
			$p = 0;	
			for ($b = 1; $b < $a; $b++)
			{		
				if ($device[$b]['dev_name'] == "A500")						
				{
					for ($l = 1; $l <= count($a500); $l++)
					{
						//echo "Port = " . $a500[$l] . "<br />";echo "Port = " . $a500[$l] . "<br />";
						//Check to see which ports were configured
						//$db_location = "sqlite:sqlite/cardinfo.db";
						$table = "perm_" . $device[$b]['dev_name'] . "_" . $cards[$b]['id'] . "_signalling";
						$where = "id = " . $a500[$l];
						$result = $data->select_statement($db_location, $table, "id", $where);
						
						if ($result['id'] != "")
						{
							$p++;
							$a500_port[$p] = $_SESSION['a500_ports'][$l];
							//echo "$p, Port = " . $a500_port[$p] . "<br />";
						}
					}
					$device[$b]['port_num']	= $p;
				}
			}					
			
			//Creates files
			//unset($wanpipe);		//Unset the wanpipe array so that each relay element has a unique number
			for ($qq = 0; $qq <= count($wanpipe); $qq++)
				$wanpipe[$qq] == "";
			
			
			$x = 0;	
			for ($b = 1; $b < $a; $b++)
			{	
				$num = 0;
				//echo "Card Ports = " . $device[$b]['port_num'] . "<br />";
				//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
				if ($device[$b]['proc_id'] == $kk)
				{
					for ($c = 0; $c < $device[$b]['port_num']; $c++)
					{
						//echo "port = " . $a500_port[$c] . "<br />";
		
						$x++;
						//echo "$c , " . $x . "<br />";
						//echo $device[$b]['port_num'] . "<br />";
						//echo "Relay $kk = iteration $x <b>" . $device[$b]['dev_name'] . " before config port id = " . $array[$b][$c]['port_id'] . "</b><br />";	
						if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116")
						{
							//Initialize class
							$wanpipe_config = new T1_E1_wanpipe_dahdi;
							$wanpipe_config->db_location = $db_location;
							//$port = $c + 1;
							//Gather information
							//echo $c . "<br />";
							//echo "$x <br />";
							$wanpipe_config->populate_vars($device[$b]['dev_name'], $cards[$b]['id'], $x, $array[$b][$c]['port_id'] , $data, $DAHDI_SPAN);
							//Generate config
							$wanpipe_config->A10x_template($API,$relay_type['machine_type'],$kk );
							
							$wanpipe[$x] = "wanpipe" . $wanpipe_config->span;
							
							$DAHDI_SPAN++;
						
							//Update the generated ports table
							$generate_update = "wanpipe = \"wanpipe" . $wanpipe_config->span . "\"";					
							$generate_table = "generated_ports";								
							$generate_where = "id = $x";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);							
						}
						elseif ($device[$b]['dev_name'] == "B601" &&  $b601_port[$c] == 1)
						{
							//Initialize class
							$wanpipe_config = new T1_E1_wanpipe_dahdi;
							$wanpipe_config->db_location = $db_location;
							
							//Gather information
							$wanpipe_config->populate_vars($device[$b]['dev_name'], $cards[$b]['id'], $x,  $b601_port[$c], $data, $DAHDI_SPAN);
							//Generate config
							$wanpipe_config->A10x_template($API,$relay_type['machine_type'],$kk );
							
							$wanpipe[$x] = "wanpipe" . $x;
							
							$DAHDI_SPAN++;
							
							//Update the generated ports table
							$generate_update = "wanpipe = \"wanpipe" . $x . "\"";					
							$generate_table = "generated_ports";								
							$generate_where = "id = $x";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);					
						}
						elseif ($device[$b]['dev_name'] == "B601" &&  $b601_port[$c] == 2)
						{
							//Initialize class
							$wanpipe_config = new analog_wanpipe_dahdi;
							$wanpipe_config->db_location = $db_location;
								
							//Gather information
							$wanpipe_config->populate_vars($device[$b]['dev_name'], $cards[$b]['id'], $x,  $b601_port[$c], $data, $DAHDI_SPAN);
							//Generate config
							$wanpipe_config->analog_template($API,$relay_type['machine_type'],$kk );
							
							$wanpipe[$x] = "wanpipe" . $x;
							
							$DAHDI_SPAN++;
							
							//Update the generated ports table
							$generate_update = "wanpipe = \"wanpipe" . $x . "\"";					
							$generate_table = "generated_ports";								
							$generate_where = "id = $x";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);
						}
						elseif ($device[$b]['dev_name'] == "A200" || $device[$b]['dev_name'] == "A400" || $device[$b]['dev_name'] == "B600" )
						{
							//Initialize class
							$wanpipe_config = new analog_wanpipe_dahdi;
							$wanpipe_config->db_location = $db_location;
							$port = $c + 1;		
							//Gather information
							$wanpipe_config->populate_vars($device[$b]['dev_name'], $cards[$b]['id'], $x, $port, $data, $DAHDI_SPAN);
							//Generate config
							$wanpipe_config->analog_template($API,$relay_type['machine_type'],$kk );
							
							$wanpipe[$x] = "wanpipe" . $x;
							
							$DAHDI_SPAN++;
							
							//Update the generated ports table
							$generate_update = "wanpipe = \"wanpipe" . $x . "\"";					
							$generate_table = "generated_ports";								
							$generate_where = "id = $x";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);
						}
						if ($device[$b]['dev_name'] == "B700")				
						{
							if ($connection[$c] == "FXO" || $connection[$c] == "FXS")
							{
								//Initialize class
								$wanpipe_config = new analog_wanpipe_dahdi;
								$wanpipe_config->db_location = $db_location;
								
								$num = $c + 1;	
								//Gather information
								$wanpipe_config->populate_vars($device[$b]['dev_name'], $cards[$b]['id'], $x, $b700_port[$num], $data, $DAHDI_SPAN);
								//Generate config
								$wanpipe_config->analog_template($API,$relay_type['machine_type'],$kk );
							
								$wanpipe[$x] = "wanpipe" . $x;
								
								$DAHDI_SPAN++;						
							}	
							
							//Update the generated ports table
							$generate_update = "wanpipe = \"wanpipe" . $x . "\"";					
							$generate_table = "generated_ports";								
							$generate_where = "id = $x";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);			
						}
						elseif ($device[$b]['dev_name'] == "A500")
						{	
							//Initialize class
							$wanpipe_config = new BRI_wanpipe;
							$wanpipe_config->db_location = $db_location;
							
							//$port = $array[$b][$c]['port_id'];	
							$num = $c+1;
							//echo "$c, port = " . $a500_port[$c] . "<br />";
							//echo "<b>card = " . $device[$b]['dev_name'] . " on port " . $array[$b][$c]['port_id'] . "</b><br />";
							//Gather information
							$wanpipe_config->populate_vars($device[$b]['dev_name'], $cards[$b]['id'], $x, $a500_port[$num], $data, $BRI_SPAN);
							//Generate config
							if ($_SESSION['dahdi'] != "")
								$wanpipe_config->A500_template($BRI_API,$relay_type['machine_type'],$kk );
							elseif ($_SESSION['freetdm'] != "")
								$wanpipe_config->A500_template($API,$relay_type['machine_type'],$kk );
							
							$wanpipe[$x] = "wanpipe" . $x;					
							
							$BRI_SPAN++;
							
							//Update the generated ports table
							$generate_update = "wanpipe = \"wanpipe" . $x . "\"";					
							$generate_table = "generated_ports";								
							$generate_where = "id = $x";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);					
						}
						if ($device[$b]['dev_name'] == "B700")
						{
							$num = $c+1;
							//echo "<b>card = " . $device[$b]['dev_name'] . " on port " . $b700_port[$num] . "</b><br />";
							//echo "$c = " . $connection[$c] . "<br />";							
							if ($connection[$c] == "NT" || $connection[$c] == "TE")
							{ 	
								//Initialize class
								$wanpipe_config = new BRI_wanpipe;
								$wanpipe_config->db_location = $db_location;
								
								$num = $c + 1;
								//Gather information
								$wanpipe_config->populate_vars($device[$b]['dev_name'], $cards[$b]['id'], $x, $b700_port[$num], $data, $BRI_SPAN);
								//Generate config
								if ($_SESSION['dahdi'] != "")
									$wanpipe_config->A500_template($BRI_API,$relay_type['machine_type'],$kk );
								elseif ($_SESSION['freetdm'] != "")
									$wanpipe_config->A500_template($API,$relay_type['machine_type'],$kk );
								
								$wanpipe[$x] = "wanpipe" . $x;					
								
								$BRI_SPAN++;					
							}
							
							//Update the generated ports table
							$generate_update = "wanpipe = \"wanpipe" . $x . "\"";					
							$generate_table = "generated_ports";								
							$generate_where = "id = $x";
							$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);
						}			
					}
				}
			}			
			
			//Loops to figure out all the wanpipeX.conf to include in the wanrouter.rc file
			$wanpipes = "";		//Set the wanpipes variable to null
			for ($l = 1; $l <= $x; $l++)
				$wanpipes = $wanpipes . $wanpipe[$l] . " ";
			//echo $wanpipes . "<br />";
			$wanpipe_common_functions = new wanpipe_common;
			
			//Generates the wanrouter.rc file to use
			$wanpipe_common_functions->wanrouter_rc($wanpipes,$relay_type['machine_type'],$kk );		
			
			
			//====================================================
			//ANALOG FXO/FXS MODULE LOCATIONS FOR DAHDI/FREETDM
			//====================================================
			
			//If you are using an analog card, it will detect the positions of the FXO and FXS modules
			$x = 0;
			for ($b = 1; $b < $a; $b++)
			{	
				//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
				if ($device[$b]['proc_id'] == $kk)
				{
					for ($c = 0; $c < $device[$b]['port_num']; $c++)
					{
						//echo "card = " . $device[$b]['dev_name'] . " " . $array[$c]['port_id'] . "<br />";
						$x++;
						if ($device[$b]['dev_name'] == "A200" || $device[$b]['dev_name'] == "A400" || $device[$b]['dev_name'] == "B600" || $device[$b]['dev_name'] == "B601" && $b601_port[$c] == 2)
						{
							$count = 0;
							$wanrouter_hwprobe = exec ('wanrouter hwprobe dump', $output);
							$counter = count($output);
							//echo "counter = $counter<br />";
							for ($l = 0; $l < $counter; $l ++)
							{
								if (preg_match('/(\d+)(.*):.*SLOT=(\d+).*BUS=(\d+).*CPU=(\w+).*PORT=(\w+).*/', $output[$l]) || preg_match('/(\d+).(\w+\w+).*SLOT=(\d+).*BUS=(\d+).*(\w+).*PORT=(\w+).*HWEC=(\d+)/', $output[$l]))
								{
									$tok = strtok($output[$l], "|");
							
									while ($tok !== false)
									{
										$card_token[$card_count] = $tok;
										$tok = strtok("|");
										$card_count++;
									}
								}
							}
							
							$tok = "";
							
							for ($u = 0; $u <= $card_count; $u ++)
							{	
								$tok = strtok($card_token[$u], "=");
						
								while ($tok !== false)
								{
									$tokenize[$values] = $tok;
									$tok = strtok("=");
									$values++;
								}
							}
							
							//Find the analog cards
							for ($analog = 0; $analog <= $values; $analog++)
							{
								$count_module = 0;
								
								if ($tokenize[$analog] == "AFT-A200-SH")
								{
									$analog_token = $analog + 66;
									for ($module = $analog; $module <= $analog_token; $module++)
									{
										if ($tokenize[$module] == "FE")
										{
											$count_module++;
											$module_type = $module + 1;
											$a200_module_position[$count_module] = $tokenize[$module_type];
											if ($tokenize[$module_type] == "FXS")
												$fxs_exist = "yes";
											elseif ($tokenize[$module_type] == "FXO")
												$fxo_exist = "yes";
											//echo "$count_module = $a200_module_position[count_module]<br />";									
										}
									}
								}
								elseif ($tokenize[$analog] == "AFT-A400-SH")
								{
									$analog_token = $analog + 66;
									for ($module = $analog; $module <= $analog_token; $module++)
									{
										if ($tokenize[$module] == "FE")
										{
											$count_module++;
											$module_type = $module + 1;
											//echo "$module = $tokenize[$module_type]<br />";
											$a400_module_position[$count_module] = $tokenize[$module_type];
											if ($tokenize[$module_type] == "FXS")
												$fxs_exist = "yes";
											elseif ($tokenize[$module_type] == "FXO")
												$fxo_exist = "yes";
										}
									}			
								}
								elseif ($tokenize[$analog] == "AFT-B600-SH")
								{
									$analog_token = $analog + 26;
									for ($module = $analog; $module <= $analog_token; $module++)
									{
										if ($tokenize[$module] == "FE")
										{
											$count_module++;
											$module_type = $module + 1;
											//echo "$module = $tokenize[$module_type]<br />";
											$b600_module_position[$count_module] = $tokenize[$module_type];
											
											if ($tokenize[$module_type] == "FXS")
											{
												$fxs_exist = "yes";
											}
											elseif ($tokenize[$module_type] == "FXO")
											{
												$fxo_exist = "yes";
											}									
										}
									}							
								}
								elseif ($tokenize[$analog] == "AFT-B601-SH")
								{
									$analog_token = $analog + 26;
									for ($module = $analog; $module <= $analog_token; $module++)
									{
										if ($tokenize[$module] == "FE")
										{
											$count_module++;
											$module_type = $module + 1;
											//echo "$module = $tokenize[$module_type]<br />";
											
											
											if ($tokenize[$module_type] == "FXS")
											{
												$b601_module_position[$count_module] = $tokenize[$module_type];										
												$fxs_exist = "yes";
											}
											elseif ($tokenize[$module_type] == "FXO")
											{
												$b601_module_position[$count_module] = $tokenize[$module_type];										
												$fxo_exist = "yes";
											}									
										}
									}							
								}																		
							}
							//echo  "------------------<br />";								
						}
					}
				}
			}
					
			//echo "Number of modules in A200 = " . count($a200_module_position) . "<br />";
			//echo "Number of modules in A400 = " . count($a400_module_position) . "<br />";
			//echo "Number of modules in B600 = " . count($b600_module_position) . "<br />";
			//echo "Number of modules in B601 = " . count($b601_module_position) . "<br />";		
			
			/*for ($z = 1; $z <= count($a200_module_position); $z++)
			{
				echo "$z = $a200_module_position[$z]<br />";
			}
					echo  "------------------<br />";			
			for ($z = 1; $z <= count($a400_module_position); $z++)
			{
				echo "$z = $a400_module_position[$z]<br />";
			}
			for ($z = 1; $z <= count($b600_module_position); $z++)
			{
				echo "$z = $b600_module_position[$z]<br />";
			}
					echo  "------------------<br />";
					
			for ($z = 1; $z <= count($b601_module_position); $z++)
			{
				echo "$z = $b601_module_position[$z]<br />";
			}	*/
				
			
			//====================================================
			//DAHDI CONFIGURATION
			//====================================================		
			
			//If dahdi/zaptel module is detected, generate 
			//"/etc/asterisk/chan_dahdi.conf"/"/etc/asterisk/zapata.conf" & "/etc/dahdi/system.conf"/"/etc/zaptel.conf"			
			if ($_SESSION['dahdi'] != "")
			{
				//Initializes seperate spans for each type of devices
				$DAHDI_SPAN = 1;
				$BRI_SPAN = 1;
				
				shell_exec ("cp smg_ctrl/woomera.conf.template smg_ctrl/woomera.conf");
				shell_exec ("cp smg_ctrl/smg_bri.conf.template smg_ctrl/smg_bri.conf");			
				
				//Initializes the dahdi class
				$smg_ctrl = new BRI_SMG;
				$dahdi_cfg = new Dahdi_configuration;
	
				$dahdi_cfg->system_conf("");
				$dahdi_cfg->chan_dahdi_conf("");
	
				$x = 0;
				for ($b = 1; $b < $a; $b++)
				{
					//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
					if ($device[$b]['proc_id'] == $kk)
					{			
						for ($c = 0; $c < $device[$b]['port_num']; $c ++)
						{				
							$x++;
							
							if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116" )
							{
								$port = $c + 1;
								//populate class
								$dahdi_cfg->populate($device[$b]['dev_name'], $cards[$b]['id'], $DAHDI_SPAN,$array[$b][$c]['port_id'], $data,"", $x);
								
								//create system.conf
								$dahdi_cfg->system_conf("True");
								//chan_dahdi.conf
								$dahdi_cfg->chan_dahdi_conf("True");							
								$DAHDI_SPAN++;
							}	
							elseif ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
							{
								//populate class
								$dahdi_cfg->populate($device[$b]['dev_name'], $cards[$b]['id'], $DAHDI_SPAN,$b601_port[$c], $data,"", $x);
								
								//create system.conf
								$dahdi_cfg->system_conf("True");
								//chan_dahdi.conf
								$dahdi_cfg->chan_dahdi_conf("True");							
								$DAHDI_SPAN++;						
							}
							elseif ($device[$b]['dev_name'] == "A200")
							{
								$port = $c + 1;
								//populate class
								$dahdi_cfg->populate($device[$b]['dev_name'], $cards[$b]['id'], $DAHDI_SPAN,$port, $data, $a200_module_position, $x);
				
								//create system.conf
								$dahdi_cfg->system_conf("True");
								//chan_dahdi.conf
								$dahdi_cfg->chan_dahdi_conf("True");							
								$DAHDI_SPAN++;
							}
							elseif ($device[$b]['dev_name'] == "A400")
							{
								$port = $c + 1;
								//populate class
								$dahdi_cfg->populate($device[$b]['dev_name'], $cards[$b]['id'], $DAHDI_SPAN,$port, $data, $a400_module_position, $x);
				
								//create system.conf
								$dahdi_cfg->system_conf("True");
								//chan_dahdi.conf
								$dahdi_cfg->chan_dahdi_conf("True");							
								$DAHDI_SPAN++;
							}	
							elseif ($device[$b]['dev_name'] == "B600")
							{
								$port = $c + 1;
								//populate class
								$dahdi_cfg->populate($device[$b]['dev_name'], $cards[$b]['id'], $DAHDI_SPAN,$port, $data, $b600_module_position, $x);
				
								//create system.conf
								$dahdi_cfg->system_conf("True");
								//chan_dahdi.conf
								$dahdi_cfg->chan_dahdi_conf("True");							
								$DAHDI_SPAN++;
							}
							elseif ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 2)
							{
								//populate class
								$dahdi_cfg->populate($device[$b]['dev_name'], $cards[$b]['id'], $DAHDI_SPAN,$b601_port[$c], $data, $b601_module_position, $x);
				
								//create system.conf
								$dahdi_cfg->system_conf("True");
								//chan_dahdi.conf
								$dahdi_cfg->chan_dahdi_conf("True");							
								$DAHDI_SPAN++;
							}																
							elseif ($device[$b]['dev_name'] == "A500")
							{
								$num = $c + 1;
								//populate class
								$smg_ctrl->populate($device[$b]['dev_name'], $cards[$b]['id'], $BRI_SPAN,$a500_port[$num], $data,"");
				
								//create system.conf
								$smg_ctrl->smg_bri();
								//chan_dahdi.conf
								$smg_ctrl->woomera();							
								$BRI_SPAN++;						
							}
							elseif ($device[$b]['dev_name'] == "B700")
							{
								$num = $c + 1;
								if ($connection[$c] == "NT" || $connection[$c] == "TE")
								{
									//populate class
									$smg_ctrl->populate($device[$b]['dev_name'], $cards[$b]['id'], $BRI_SPAN,$b700_port[$num], $data,"");
				
									//create system.conf
									$smg_ctrl->smg_bri();
									//chan_dahdi.conf
									$smg_ctrl->woomera();							
									$BRI_SPAN++;	
								}
								elseif ($connection[$c] == "FXS" || $connection[$c] == "FXO")
								{
									$dahdi_cfg->b700_module = $connection[$c];
									
									//populate class
									$dahdi_cfg->populate($device[$b]['dev_name'], $cards[$b]['id'], $DAHDI_SPAN,$b700_port[$num], $data, "", $x);
				
									//create system.conf
									$dahdi_cfg->system_conf("True");
									//chan_dahdi.conf
									$dahdi_cfg->chan_dahdi_conf("True");							
									$DAHDI_SPAN++;
								}
							}					
						}
					}
				}					
				
				shell_exec ("mv chan_dahdi.conf /etc/asterisk");
				shell_exec ("mv system.conf /etc/dahdi");	
				shell_exec ("mv smg_ctrl/woomera.conf /etc/asterisk");
				shell_exec ("mv smg_ctrl/smg_bri.conf /etc/wanpipe");			
			}
		
			//====================================================
			//FREETDM/SS7/NSG/NVG CONFIGURATION
			//====================================================		
			
			//If FreeTDM module is found, generate
			//"PATHTOSMG/conf/freetdm.conf" and "PATHTOSMG/conf/autoload_configs/freetdm.conf.xml"
			elseif ($_SESSION['freetdm'] != "")
			{
				//initializes the freetdm class
				unset($freetdm_cfg);
				$freetdm_cfg = new freetdm_configuration;
				$freetdm_cfg->freetdm_conf("", "");
				$freetdm_cfg->db_location = $db_location;
				$freetdm_cfg->freetdm_xml("");
				unset ($_SESSION['last_t1_e1_profile']);
				unset ($_SESSION['last_r2_profile']);				
				unset ($_SESSION['last_bri_profile']);
	
				$x = 0;
				for ($b = 1; $b < $a; $b++)
				{	
					//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
					if ($device[$b]['proc_id'] == $kk)
					{		
						for ($c = 0; $c < $device[$b]['port_num']; $c ++)
						{				
							$x++;
							
							if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116")
							{
								$port = $c + 1;
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
								//create freetdm.conf
								$freetdm_cfg->freetdm_conf("hello", "");
								//echo "i am here";
								if ($freetdm_cfg->ss7_span == "no")
								{					
									//freetdm.conf.xml profile portion
									if ($freetdm_cfg->r2_span)
										$freetdm_cfg->freetdm_xml("r2_profile");							
									else
										$freetdm_cfg->freetdm_xml("Profile");							
								}
							}
							elseif ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
							{
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
								
								//create freetdm.conf
								$freetdm_cfg->freetdm_conf("hello", "");
		
								if ($freetdm_cfg->ss7_span == "no")
								{
									//echo "I am here<br />";							
									//freetdm.conf.xml profile portion
									$freetdm_cfg->freetdm_xml("Profile");							
								}
							}						
							if ($device[$b]['dev_name'] == "A500")
							{
								$num = $c + 1;
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$a500_port[$num], $data);
								
								//create freetdm.conf
								$freetdm_cfg->freetdm_conf("hello", "");
									
								//freetdm.conf.xml profile portion
								$freetdm_cfg->freetdm_xml("Profile");							
							}
							if ($device[$b]['dev_name'] == "B700")
							{
								$num = $c + 1;
								//echo "module = " . $connection[$c] . "<br />";
								if ($connection[$c] == "NT" || $connection[$c] == "TE")
								{
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b700_port[$num], $data);
									
									//echo "value = " . $freetdm_cfg->facility . "<br />";
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "");
										
									//freetdm.conf.xml profile portion
									$freetdm_cfg->freetdm_xml("Profile");							
								}
							}					
						}
					}
				}	
				
				$freetdm_cfg->db_location = $db_location;
				//Starts the FXS/FXO headers in freetdm.conf
				//echo $fxo_exist . "<br />";
				if ($fxo_exist == "yes")
				{
					//Start the FXO Header if FXO exists
					$freetdm_cfg->freetdm_conf("empty_fxo", "");				
	
					//FXO Channels
					$x = 0;
					for ($b = 1; $b < $a; $b++)
					{
						//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
						if ($device[$b]['proc_id'] == $kk)
						{			
							for ($c = 0; $c < $device[$b]['port_num']; $c ++)
							{				
								$x++;
								
								//Perform FXO Span data
								if ($device[$b]['dev_name'] == "A200")				
								{
									unset ($freetdm_cfg->module_list);
									$port = $c + 1;
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$port, $data, $a200_module_position);
									
									$freetdm_cfg->module_list = $a200_module_position;
		
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXO");
																	
								}
								if ($device[$b]['dev_name'] == "A400")				
								{
									unset ($freetdm_cfg->module_list);
									$port = $c + 1;
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$port, $data, $a400_module_position);
									
									$freetdm_cfg->module_list = $a400_module_position;
									
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXO");
										
								}
								if ($device[$b]['dev_name'] == "B600")				
								{
									unset ($freetdm_cfg->module_list);
									$port = $c + 1;
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$port, $data, $b600_module_position);
									
									$freetdm_cfg->module_list = $b600_module_position;
					
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXO");	
								}
								if ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 2)				
								{
									unset ($freetdm_cfg->module_list);
									//echo "i am here <br />";
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data, $b601_module_position);
						
									$freetdm_cfg->module_list = $b601_module_position;
					
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXO");	
								}						
								if ($device[$b]['dev_name'] == "B700")				
								{
									$port = $c + 1;
									//echo "module = " . $connection[$c] . "<br />";
									if ($connection[$c] == "FXO")
									{
										$num = $c + 1;
										unset ($freetdm_cfg->module_list);
										//populate class
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b700_port[$num], $data, "");
										
										
										$freetdm_cfg->module_list[1] = "FXO";
										$freetdm_cfg->module_list[2] = "FXO";
										
										//create freetdm.conf
										$freetdm_cfg->freetdm_conf("hello", "FXO");	
									}
								}						
							}
						}
					}	
				}
				
				//Starts the FXS/FXO headers in freetdm.conf
				if ($fxs_exist == "yes")
				{
					//Start the FXS header if FXS exists
					$freetdm_cfg->freetdm_conf("empty_fxs", "");
				
					//FXS Channels
					$x = 0;
					for ($b = 1; $b < $a; $b++)
					{	
						//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
						if ($device[$b]['proc_id'] == $kk)
						{		
							for ($c = 0; $c < $device[$b]['port_num']; $c ++)
							{			
								$x++;
								//Perform FXS Span data
								if ($device[$b]['dev_name'] == "A200")				
								{
									unset ($freetdm_cfg->module_list);
									$port = $c + 1;
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$port, $data, $a200_module_position);
									
									
									$freetdm_cfg->module_list = $a200_module_position;
					
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXS");
										
								}
								if ($device[$b]['dev_name'] == "A400")				
								{
									unset ($freetdm_cfg->module_list);
									$port = $c + 1;
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$port, $data, $a400_module_position);
									
									
									$freetdm_cfg->module_list = $a400_module_position;
					
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXS");
										
								}
								if ($device[$b]['dev_name'] == "B600")				
								{
									unset ($freetdm_cfg->module_list);
									$port = $c + 1;
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$port, $data, $b600_module_position);
									
									
									$freetdm_cfg->module_list = $b600_module_position;
					
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXS");
										
								}
								if ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 2)				
								{
									unset ($freetdm_cfg->module_list);
									//echo "i am here <br />";
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data, $b601_module_position);
									
									
									$freetdm_cfg->module_list = $b601_module_position;
					
									//create freetdm.conf
									$freetdm_cfg->freetdm_conf("hello", "FXS");	
								}
								if ($device[$b]['dev_name'] == "B700")				
								{
									unset ($freetdm_cfg->module_list);
									$num = $c + 1;
									if ($connection[$c] == "FXS")
									{
										//populate class
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b700_port[$num], $data, $a200_module_position);
										
										
										$freetdm_cfg->module_list[1] = "FXS";
										$freetdm_cfg->module_list[2] = "FXS";
					
										//create freetdm.conf
										$freetdm_cfg->freetdm_conf("hello", "FXS");	
									}
								}						
							}
						}
					}	
				}
				
				//Freetdm.conf.xml close tags
				$freetdm_cfg->freetdm_xml("end config_profiles");
				
				//Run through the PRI Spans
				$freetdm_cfg->freetdm_xml("start PRI spans");
	
				$x = 0;
				for ($b = 1; $b < $a; $b++)
				{	
					//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
					if ($device[$b]['proc_id'] == $kk)
					{		
						for ($c = 0; $c < $device[$b]['port_num']; $c ++)
						{				
							$x++;
							
							if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116")
							{
								$port = $c + 1;
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
								
								//echo $freetdm_cfg->ss7_span  . "<br />";
								
								if ($freetdm_cfg->ss7_span == "no")
								{
									//echo "I am here<br />";							
									//freetdm.conf.xml profile portion
									if (!$freetdm_cfg->r2_span)
										$freetdm_cfg->freetdm_xml("PRI spans");							
								}
							}
							if ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
							{
								$port = $c + 1;
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
								
								
								//echo $freetdm_cfg->ss7_span  . "<br />";
								
								if ($freetdm_cfg->ss7_span == "no")
								{
									//echo "I am here<br />";							
									//freetdm.conf.xml profile portion
									$freetdm_cfg->freetdm_xml("PRI spans");							
								}						
							}
						}
					}
				}
				
				//Freetdm.conf.xml close tags
				$freetdm_cfg->freetdm_xml("close PRI spans");
				
				//Run through the R2 Spans
				$freetdm_cfg->freetdm_xml("start R2 spans");
	
				$x = 0;
				for ($b = 1; $b < $a; $b++)
				{	
					//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
					if ($device[$b]['proc_id'] == $kk)
					{		
						for ($c = 0; $c < $device[$b]['port_num']; $c ++)
						{				
							$x++;
							
							if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116")
							{
								$port = $c + 1;
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
								
								if ($freetdm_cfg->ss7_span == "no" && $freetdm_cfg->r2_span)
								{
									//echo "I am here<br />";							
									//freetdm.conf.xml profile portion
									$freetdm_cfg->freetdm_xml("R2 spans");							

									//Update the generated ports table
									$generate_update = "r2_profile = \"". $freetdm_cfg->profile_name. "\"";					
									$generate_table = "generated_ports";								
									$generate_where = "id = " . $x;
									$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);												
								}
							}
							if ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
							{
								$port = $c + 1;
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
								
								if ($freetdm_cfg->ss7_span == "no" && $freetdm_cfg->r2_span)
								{
									//echo "I am here<br />";							
									//freetdm.conf.xml profile portion
									$freetdm_cfg->freetdm_xml("R2 spans");	
		
									//Update the generated ports table
									$generate_update = "r2_profile = \"". $freetdm_cfg->profile_name. "\"";					
									$generate_table = "generated_ports";								
									$generate_where = "id = " . $x;
									$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);				
								}						
							}
						}
					}
				}
				
				//Freetdm.conf.xml close tags
				$freetdm_cfg->freetdm_xml("close R2 spans");				
				
				
				
				//Run through the BRI Spans
				$freetdm_cfg->freetdm_xml("start BRI spans");			
				
				$x = 0;
				for ($b = 1; $b < $a; $b++)
				{	
					//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
					if ($device[$b]['proc_id'] == $kk)
					{		
						for ($c = 0; $c < $device[$b]['port_num']; $c ++)
						{				
							$x++;
							if ($device[$b]['dev_name'] == "A500")
							{
								$num = $c + 1;
								//populate class
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$a500_port[$num], $data);
								
								
								//freetdm.conf.xml profile portion
								$freetdm_cfg->freetdm_xml("BRI spans");							
							}
							if ($device[$b]['dev_name'] == "B700")
							{
								$num = $c + 1;
								if ($connection[$c] == "NT" || $connection[$c] == "TE")
								{						
									//populate class
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b700_port[$num], $data);
									
									
									//freetdm.conf.xml profile portion
									$freetdm_cfg->freetdm_xml("BRI spans");							
								}
							}
						}
					}
				}
	
				//Freetdm.conf.xml close tags
				$freetdm_cfg->freetdm_xml("close BRI spans");			
				
				//Analog Spans	
				$x = 0;
				$freetdm_cfg->freetdm_xml("start analog spans");
				for ($b = 1; $b < $a; $b++)
				{	
					//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
					if ($device[$b]['proc_id'] == $kk)
					{		
						for ($c = 0; $c < $device[$b]['port_num']; $c ++)
						{				
							$x++;
							
							if ($device[$b]['dev_name'] == "A200" || $device[$b]['dev_name'] == "A400" || $device[$b]['dev_name'] == "B600")
							{
								$port = $c + 1;
								//echo "span = $x <br />";
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$port, $data);
								
								
								if ($fxo_exist == "yes")
									$freetdm_cfg->freetdm_xml("fxo analog spans");
								if ($fxs_exist == "yes")
									$freetdm_cfg->freetdm_xml("fxs analog spans");
							
							}
							if ($device[$b]['dev_name'] == "B601" && $b601_port[$c] == 2)
							{
								$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
								
								if ($fxo_exist == "yes")
									$freetdm_cfg->freetdm_xml("fxo analog spans");
								if ($fxs_exist == "yes")
									$freetdm_cfg->freetdm_xml("fxs analog spans");
							
							}					
							if ($device[$b]['dev_name'] == "B700")
							{
								$num = $c + 1;
								if ($connection[$c] == "FXS" || $connection[$c] == "FXO" )
								{						
									$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b700_port[$num], $data);
									
									if ($connection[$c] == "FXO")
										$freetdm_cfg->freetdm_xml("fxo analog spans");
									if ($connection[$c] == "FXS")
										$freetdm_cfg->freetdm_xml("fxs analog spans");
								}
							}
						}
					}
				}			
				$freetdm_cfg->freetdm_xml("end analog spans");
	
				//SS7 Configuration for FreeTDM.conf.xml
				
				if ($ss7_exist == "yes")
				{
					$freetdm_cfg->db_location = $db_location;
					//Run through the SS7 Spans Section
					$freetdm_cfg->freetdm_xml("start SS7 config", $relay_type['machine_type'], $kk);
					
					$freetdm_cfg->freetdm_xml("start_mtp1_links");
					unset ($freetdm_cfg->ss7_m2ua_link);
					unset ($freetdm_cfg->ss7_m2ua_chans);					
					$x = 0;
					for ($b = 1; $b < $a; $b++)
					{
						//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
						if ($device[$b]['proc_id'] == $kk)
						{			
							for ($c = 0; $c < $device[$b]['port_num']; $c ++)
							{				
								$x++;
								//$relay_id2++;
								
								if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116" || $device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
								{
									$port = $c + 1;
									//populate class
									if ($device[$b]['dev_name'] == "B601")
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);	
									else
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
			
									if (($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_voice == "") || ($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_m2ua_link['link_name'] != ""))
									{
										if ($freetdm_cfg->ss7_m2ua_link['link_name'] == "" && $freetdm_cfg->ss7_m2ua_chans['profile_name'] != "") {
										}
										else {
											$mtp1_Id++;
											//freetdm.conf.xml profile portion
											$freetdm_cfg->freetdm_xml("mtp1_links", $relay_type['machine_type'], $kk,$mtp1_Id, $mtp1_Id);	
										}
									}
								}
							}
						}
					}
					$freetdm_cfg->freetdm_xml("stop_mtp1_links");
					
					$freetdm_cfg->freetdm_xml("start_mtp2_links");
					unset ($freetdm_cfg->ss7_m2ua_link);
					unset ($freetdm_cfg->ss7_m2ua_chans);
					$freetdm_cfg->db_location = $db_location;
					$x = 0;
					//$relay_id2 = 0;
					for ($b = 1; $b < $a; $b++)
					{	
						//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
						if ($device[$b]['proc_id'] == $kk)
						{		
							for ($c = 0; $c < $device[$b]['port_num']; $c++)
							{				
								$x++;
								$port = $c + 1;
								if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116" || $device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
								{
									$port = $c + 1;
									//populate class
									if ($device[$b]['dev_name'] == "B601")
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
									else
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
										
									if (($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_voice == "") || ($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_m2ua_link['link_name'] != ""))
									{
										if ($freetdm_cfg->ss7_m2ua_link['link_name'] == "" && $freetdm_cfg->ss7_m2ua_chans['profile_name'] != "") {
										}
										else {
											$mtp2_Id++;
											//freetdm.conf.xml profile portion
											$freetdm_cfg->freetdm_xml("mtp2_links", $relay_type['machine_type'], $kk, $mtp2_Id, $mtp2_Id);
																		
											//Update the generated ports table
											if ($freetdm_cfg->ss7_m2ua_link['link_name'] != "")
												$span_id = $freetdm_cfg->ss7_m2ua_link['span'];
											else
												$span_id = $freetdm_cfg->span_num;

											$generate_update = "mtp2_name = \"mtp2-". $span_id. "\"";					
											$generate_table = "generated_ports";								
											$generate_where = "id = $x";
											$data->update_table ($db_location, $generate_table, $generate_update, $generate_where);	
										}
									}								
								}					
							}
						}
					}
					
					$freetdm_cfg->freetdm_xml("stop_mtp2_links");

					$freetdm_cfg->db_location = $db_location;
					$freetdm_cfg->freetdm_xml("start_mtp3_links");
					unset ($freetdm_cfg->ss7_m2ua_link);
					unset ($freetdm_cfg->ss7_m2ua_chans);

					//Only on Proc ID 1 or if machine a standalone machine
					if ($relay_type['machine_type'] == "standalone" || $kk == 1)
					{
						//Go into a loop to place all the mtp3 information on proc_id 1 for relay
						for ($bb =1; $bb <= $count_hosts['count(id)'] ; $bb++)
						{
							//Set the database to read from
							if ($bb == 1)
								$db_location2 = "sqlite:sqlite/cardinfo.db";
							else
								$db_location2 = "sqlite:sqlite/cardinfo" . $bb . ".db";

							//read from card_present table
							$boards = $data->array_select_statement($db_location2, 'card_present','id,dev_name');
							foreach ($boards as $board) {
								$tmpBoard = explode('-',$board['dev_name']);
								$board_name = $tmpBoard[1];
								$boardID = $tmpBoard[3];

								$hwTable = $board_name . "_" . $boardID;
								$ss7LinkTable = $board_name . "_" . $boardID . "_SS7_link";
								$ss7CCspansTable = $board_name . "_" . $boardID . "_SS7_ccspans";

								if ($data->check_for_table($db_location2,$hwTable) > 1) {
									//pull configured ports
									unset($configuredPorts);
									$configuredPorts = $data->array_select_statement ($db_location2,$hwTable,'*','', 'port_id');
									foreach ($configuredPorts as $configuredPort) {
										if ($data->check_for_table($db_location2,$ss7LinkTable) > 1) {
											$ss7LinkInfo = $data->select_statement($db_location2,$ss7LinkTable,'link_name,voice,span','port_id = ' . $configuredPort['port_id']);
											if (!empty($ss7LinkInfo)) {
												if ($ss7LinkInfo['voice'] == "" && $ss7LinkInfo['link_name'] != "") {
													//confirm ccspan for that port exists
													if ($data->check_for_table ($db_location2,$ss7CCspansTable) > 1) {
														$ss7CCSpanInfo = $data->select_statement ($db_location2,$ss7CCspansTable,'profile_name','port_id = ' . $configuredPort['port_id']);
														if (!empty($ss7CCSpanInfo)) {
															//Port exists and is Signalling link for MTP3
															//Enter in freetdm.conf.xml
															$freetdm_cfg->db_location = $db_location2;
															$freetdm_cfg->freetdm_generate($board_name, $tmpBoard[3], $ss7LinkInfo['span'] ,$configuredPort['port_id'] , $data);
					
															if ($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_voice == "" && $freetdm_cfg->ss7_m2ua_link['link_name'] == "" && $freetdm_cfg->ss7_m2ua_chans['profile_name'] == "")
															{
																//freetdm.conf.xml profile portion
																$freetdm_cfg->freetdm_xml("mtp3_links", $relay_type['machine_type'], $bb,$bb, $ss7LinkInfo['span']);							
																//Update the generated ports table
																$generate_update = "mtp3_name = \"mtp3-". $freetdm_cfg->span_num. "\"";
																$generate_table = "generated_ports";								
																$generate_where = "id = " . $ss7LinkInfo['span'];
																$data->update_table ($db_location2, $generate_table, $generate_update, $generate_where);
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					
					$freetdm_cfg->freetdm_xml("stop_mtp3_links");
					$freetdm_cfg->db_location = $db_location;
					
					//mtp_linksets, mtp_routes and mtp_isup				
					//$freetdm_cfg->db_location = "sqlite:sqlite/cardinfo.db";
					if ($ss7_exist == "yes")
					{	
						$freetdm_cfg->freetdm_xml("start_linkset");
						if ($relay_type['machine_type'] == "standalone" || $kk == 1)
							$freetdm_cfg->freetdm_xml("mtp_linksets");
						$freetdm_cfg->freetdm_xml("stop_linkset");
					
						$freetdm_cfg->freetdm_xml("start_route");
						if ($relay_type['machine_type'] == "standalone" || $kk == 1)
							$freetdm_cfg->freetdm_xml("mtp_route");
						$freetdm_cfg->freetdm_xml("stop_route");
					
						$freetdm_cfg->freetdm_xml("start_isup");
						if ($relay_type['machine_type'] == "standalone" || $kk == 1)
							$freetdm_cfg->freetdm_xml("isup");
						$freetdm_cfg->freetdm_xml("stop_isup");
					}
					
					if ($ss7_exist == "yes")
					{
						//SCTP
						//echo "m2ua = $m2ua and mg = $mg_chan<br />";
						//echo "m2ua_link = $m2ua_link <br />";
						$freetdm_cfg->freetdm_xml("start_sctp");
						if ($m2ua_link) {
							if ($relay_type['machine_type'] == "standalone")
								$freetdm_cfg->freetdm_xml("sctp_interfaces");
						}
						$freetdm_cfg->freetdm_xml("stop_sctp");

					}
						
					//NIF
					$freetdm_cfg->db_location = $db_location;
					$freetdm_cfg->freetdm_xml("start_nif");
					$shaunt_count = 1;	//MTP2 ID counter
					if ($m2ua_link) {
						//Only on Proc ID 1 or if machine a standalone machine
						if ($relay_type['machine_type'] == "standalone")
						{
							//$relay_id = 0;
							
							//Go into a loop to place all the mtp3 information on proc_id 1 for relay
							for ($bb =1; $bb <= $count_hosts['count(id)'] ; $bb++)
							{
								$x = 0;
								for ($b = 1; $b < $a; $b++)
								{		
									for ($c = 0; $c < $device[$b]['port_num']; $c ++)
									{				
										$x++;
										//$relay_id++;
										if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116" || $device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
										{								
											$port = $c + 1;
											//populate class
											if ($device[$b]['dev_name'] == "B601")
												$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
											else
												$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
											
											if ($freetdm_cfg->ss7_span == "yes")
											{
												if ( $freetdm_cfg->ss7_m2ua_link['link_name'] != "" ) {
													//echo "i am here<br />";
													$nif_id++;
													
													if ($array[$b][$c]['port_id'] == 1)
														$shaunt_count = 1;
													else													
														$shaunt_count++;
													//freetdm.conf.xml profile portion
													//echo "Counter = " . $shaunt_count."<br />";
													$freetdm_cfg->freetdm_xml("nif_int", $relay_type['machine_type'], $bb,$shaunt_count,$nif_id);	
												}
												elseif (($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_voice == "") || ($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_m2ua_link['link_name'] != "")) {
													//$shaunt_count++;
												}
											}	
										}
									}
								}
							}					
						}
					}
					$freetdm_cfg->freetdm_xml("stop_nif");
					$freetdm_cfg->db_location = $db_location;
										
					//M2UA
					$freetdm_cfg->freetdm_xml("start_m2ua");
					if ($m2ua_link) {
						//Only on Proc ID 1 or if machine a standalone machine
						if ($relay_type['machine_type'] == "standalone")
						{
							//$relay_id = 0;
							
							//Go into a loop to place all the mtp3 information on proc_id 1 for relay
							for ($bb =1; $bb <= $count_hosts['count(id)'] ; $bb++)
							{
								$x = 0;
								for ($b = 1; $b < $a; $b++)
								{	
									for ($c = 0; $c < $device[$b]['port_num']; $c ++)
									{				
										$x++;
										//$relay_id++;
										if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116" || $device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
										{								
											$port = $c + 1;
											//populate class
											if ($device[$b]['dev_name'] == "B601")
												$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
											else
												$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
											
											if ($freetdm_cfg->ss7_span == "yes")
											{
												if ( $freetdm_cfg->ss7_m2ua_link['link_name'] != "" ) {
													//echo "i am here<br />";
													$freetdm_cfg->data=$data;
													$m2uaid++;
													$shaunt_count++;
													//freetdm.conf.xml profile portion
													$freetdm_cfg->freetdm_xml("m2ua_config", $relay_type['machine_type'], $bb,$shaunt_count,$m2uaid);
													
													$generate_update = "m2ua_link_name = \"" . $freetdm_cfg->ss7_m2ua_link['link_name'] . "\", cluster_name = \"" . $freetdm_cfg->ss7_m2ua_link['cluster'] . "\"";					
													$generate_table = "generated_ports";								
													$generate_where = "id = $x";
													$data->update_table ($db_location2, $generate_table, $generate_update, $generate_where);	
												}
											}	
										}
									}
								}
							}					
						}
					}
					$freetdm_cfg->freetdm_xml("stop_m2ua");
					$freetdm_cfg->db_location = $db_location;					
					
					//M2UA Peers
					if ($ss7_exist == "yes")
					{
						$freetdm_cfg->freetdm_xml("start_m2ua_peers");
						if ($m2ua_link) {
							if ($relay_type['machine_type'] == "standalone")
								$freetdm_cfg->freetdm_xml("m2ua_peer");
						}
						$freetdm_cfg->freetdm_xml("stop_m2ua_peers");						
					}
					
					//M2UA Clusters
					if ($ss7_exist == "yes")
					{
						$freetdm_cfg->freetdm_xml("start_m2ua_clusters");
						if ($m2ua_link) {
							if ($relay_type['machine_type'] == "standalone")
							{
								$freetdm_cfg->freetdm_xml("m2ua_clusters");
								$mtp3id++;
							}
						}
						$freetdm_cfg->freetdm_xml("stop_m2ua_clusters");						
					} 
					
					//$freetdm_cfg->db_location = $db_location;
					
					$freetdm_cfg->freetdm_xml("start_ccspans");
					if ($relay_type['machine_type'] != "standalone")
					{
						//CCspans for Relay Machines
						for ($bb =1; $bb <= $count_hosts['count(id)'] ; $bb++)
						{
							//Set the database to read from
							if ($bb == 1)
								$db_location2 = "sqlite:sqlite/cardinfo.db";
							else
								$db_location2 = "sqlite:sqlite/cardinfo" . $bb . ".db";
								
							//read from card_present table
							$boards = $data->array_select_statement($db_location2, 'card_present','id,dev_name');
							unset($configuredPorts);
							foreach ($boards as $board) {
								$tmpBoard = explode('-',$board['dev_name']);
								$board_name = $tmpBoard[1];
								$boardID = $tmpBoard[3];

								$hwTable = $board_name . "_" . $boardID;
								$ss7LinkTable = $board_name . "_" . $boardID . "_SS7_link";
								$ss7CCspansTable = $board_name . "_" . $boardID . "_SS7_ccspans";
								
								if ($data->check_for_table($db_location2,$hwTable) > 1) {
									//pull configured ports
									$configuredPorts = $data->array_select_statement ($db_location2,$hwTable,'*','', 'port_id');

									foreach ($configuredPorts as $configuredPort) {
										if ($data->check_for_table($db_location2,$ss7LinkTable) > 1) {
											$ss7LinkInfo = $data->select_statement($db_location2,$ss7LinkTable,'link_name,voice,span','port_id = ' . $configuredPort['port_id']);
											if (!empty($ss7LinkInfo)) {
												//confirm ccspan for that port exists
												if ($data->check_for_table ($db_location2,$ss7CCspansTable) > 1) {
													$ss7CCSpanInfo = $data->select_statement ($db_location2,$ss7CCspansTable,'profile_name','port_id = ' . $configuredPort['port_id']);
													if (!empty($ss7CCSpanInfo)) {
														//Port exists and is either a signalling link or voice link
														//Enter in freetdm.conf.xml
														$freetdm_cfg->db_location = $db_location2;
														$freetdm_cfg->freetdm_generate($board_name, $tmpBoard[3], $ss7LinkInfo['span'] ,$configuredPort['port_id'] , $data);
				
														if ($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_m2ua_link['link_name'] == "" && $freetdm_cfg->ss7_m2ua_chans['profile_name'] == "")
															$freetdm_cfg->freetdm_xml("ccspans", $relay_type['machine_type'], $bb,$bb, $ss7LinkInfo['span']);							
													}
												}
											}
										}
									}
								}
							}
						}
					}
					else
					{
						//Standalone System
						$x = 0;
						for ($b = 1; $b < $a; $b++)
						{									
							for ($c = 0; $c < $device[$b]['port_num']; $c ++)
							{				
								$x++;
								
								if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116" || $device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)
								{
									$port = $c + 1;
									//populate class
									
									//override database location so that you can pull all mtp3 information
									$freetdm_cfg->db_location = $db_location2;
									
									if ($device[$b]['dev_name'] == "B601")
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
									else
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);
									
									if ($freetdm_cfg->ss7_span == "yes" && $freetdm_cfg->ss7_m2ua_link['link_name'] == "" && $freetdm_cfg->ss7_m2ua_chans['profile_name'] == "")
									{
										$ccspanId++;
										//echo "proc id = $bb, ccspan id = $ccspanId <br />";
										//freetdm.conf.xml profile portion
										$freetdm_cfg->freetdm_xml("ccspans",$relay_type['machine_type'], '1',$ccspanId);
									}
								}
							}
						}
					}						
					
					$freetdm_cfg->freetdm_xml("stop_ccspans");	
					
					$freetdm_cfg->freetdm_xml("stop SS7 config");
					
					$freetdm_cfg->db_location = $db_location;
					//Run through the SS7 Spans Section
					$freetdm_cfg->freetdm_xml("start SS7 spans");
					unset ($freetdm_cfg->ss7_m2ua_link);
					unset ($freetdm_cfg->ss7_m2ua_chans);
					$x = 0;
					for ($b = 1; $b < $a; $b++)
					{	
						//echo "Proc ID = " . $device[$b]['proc_id'] . "<br />";
						if ($device[$b]['proc_id'] == $kk)
						{						
							for ($c = 0; $c < $device[$b]['port_num']; $c ++)
							{				
								$x++;
								
								if ($device[$b]['dev_name'] == "A101" || $device[$b]['dev_name'] == "A102" || $device[$b]['dev_name'] == "A104" || $device[$b]['dev_name'] == "A108" || $device[$b]['dev_name'] == "A116" || $device[$b]['dev_name'] == "B601" && $b601_port[$c] == 1)					{
									$port = $c + 1;
									//populate class
									if ($device[$b]['dev_name'] == "B601")
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$b601_port[$c], $data);
									else
										$freetdm_cfg->freetdm_generate($device[$b]['dev_name'], $cards[$b]['id'], $x,$array[$b][$c]['port_id'] , $data);

									if ($freetdm_cfg->ss7_span == "yes")
									{
										//freetdm.conf.xml profile portion
										if ($freetdm_cfg->ss7_m2ua_link['link_name'] != "") {
											if ($freetdm_cfg->ss7_m2ua_link['span'] == $freetdm_cfg->ss7_m2ua_chans['ss7_span']){
												//m2ua with voice
												$ss7Spans++;
												$freetdm_cfg->freetdm_xml("SS7 spans",$relay_type['machine_type'], $kk,$ss7Spans);	
											}
											elseif ($freetdm->ss7_m2ua_link['span'] == $ss7_spans) {
												//m2ua without voice
												$ss7Spans++;
												$freetdm_cfg->freetdm_xml("SS7 spans",$relay_type['machine_type'], $kk,$ss7Spans);	
											}
										}
										elseif ($freetdm_cfg->ss7_m2ua_chans['profile_name'] == "" && $freetdm_cfg->ss7_m2ua_link['link_name'] == "" )
										{
											//ISUP
											$ss7Spans++;
											$freetdm_cfg->freetdm_xml("SS7 spans",$relay_type['machine_type'], $kk,$ss7Spans);	
										}
										
									}
								}
							}
						}
					}
				
					//Freetdm.conf.xml close tags
					$freetdm_cfg->freetdm_xml("close SS7 spans");
				
				}
				
				unset($_SESSION['last_freetdm_profile']);	
				
				$freetdm_cfg->freetdm_xml("end");	
	
				if ($relay_type['machine_type'] == "standalone")
				{
				
					shell_exec("mv freetdm.conf ../../../conf");
					shell_exec("mv freetdm.conf.xml ../../../conf/autoload_configs");
				}
				else
				{
					$file_name = "freetdm.conf";
					$file_location = "/tmp/relay" . $kk . "/freetdm/";
					shell_exec("mv " . $file_name . " " . $file_location);
				
					$file_name = "freetdm.conf.xml";
					$file_location = "/tmp/relay" . $kk . "/freetdm/";
					shell_exec("mv " . $file_name . " " . $file_location);
				}
				//echo "<hr />";
			}
			
			$_SESSION['created'] = "YES";
			$_SESSION['wanpipes'] = $wanpipes;
			
		}

		//===========================================================
		//TAR UP RELAY FOLDERS AND TRANSFER THEM TO PROPER LOCATIONS
		//===========================================================
		
		if ($relay_type['machine_type'] != "standalone")
		{
			// Generate QOS control script
			// Enabled
			$cmd = "echo QOS_ENABLE=1 > " . $_SESSION['smg_root_path'] . "/conf/qos.conf";
			shell_exec($cmd);
			// On all ethernet interfaces
			$cmd = "ifconfig | grep eth | cut -d \" \" -f 1 | xargs -n6 | xargs -I{} echo QOS_DEVICE=\\\"{}\\\" >> " . $_SESSION['smg_root_path'] . "/conf/qos.conf";
			shell_exec($cmd);
			// P1 for every relay ports
			$relay_ports = $data->array_select_statement('sqlite:sqlite/relay_info.db','relay_hosts','DISTINCT relay_port',""); 
			$relay_qos_ports = "QOS_HIGH_PRIO_PORTS=\\\"";
			foreach ($relay_ports as $relay_port)
			{
			  $relay_qos_ports = $relay_qos_ports . $relay_port['relay_port'] . " ";
			}
			
			$relay_qos_ports = $relay_qos_ports . "\\\"";
			$cmd = "echo " . $relay_qos_ports ." >> " . $_SESSION['smg_root_path'] . "/conf/qos.conf";
			shell_exec($cmd);


			for ($qq = 1; $qq <= $count_hosts['count(id)']; $qq++)
			{
				//Get IP Address of host
				$dir = $_SESSION['smg_root_path'] . "/nginx/html/php/";
				chdir($dir);
				$relay_info = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','ip_addr,ssh_port',"id = $qq");
				
				if ($qq > 1)
				{
					//echo $qq . "<br />";
					chdir("/tmp");
					//echo getcwd() . "<br />";
					
					//Copy the database file to the tmp directory
					$cmd = "rm -fr /tmp/relay" . $qq . "/cardinfo.db";
					shell_exec($cmd);
					$cmd = "rm -fr /tmp/relay" . $qq . "/qos.conf";
					shell_exec($cmd);
					
          			// Copy card config db
					$cmd = "cp -fr " . $_SESSION['smg_root_path'] . "/nginx/html/php/sqlite/cardinfo" . $qq . ".db /tmp/relay" . $qq . "/cardinfo.db";
					shell_exec($cmd);
         	 		// Copy QOS config 
					$cmd = "cp -fr " . $_SESSION['smg_root_path'] . "/conf/qos.conf /tmp/relay" . $qq . "/qos.conf";
					shell_exec($cmd);
					
					$cmd = "tar czf relay" . $qq . ".tgz relay" . $qq;
					shell_exec($cmd);
					
					require_once('SSH_Class_new.php');
					$ssh = new executor_class;
					
					if ($ssh->connect($relay_info['ip_addr'],$relay_info['ssh_port']))
					{
						//echo "I am here <br />";
						$local = "/tmp/relay" . $qq . ".tgz";
						$remote = "/tmp/relay" . $qq . ".tgz";
						$ssh->copy_file($local,$remote);
						
						//echo $ssh->last_result . "<br />";
						
						if ($ssh->last_result == "PASSED")
						{
							//Remove old wanpipe files
							$cmd = "rm -fr /etc/wanpipe/wanpipe*.conf";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "rm -fr /etc/wanpipe/wanrouter.rc";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
		
							$cmd = "rm -fr /etc/wanpipe/wanpipe_old_configs/";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							//Remove old freetdm files
							$cmd = "rm -fr " . $_SESSION['smg_root_path'] . "/conf/freetdm.conf";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "rm -fr " . $_SESSION['smg_root_path'] . "/conf/autoload_configs/freetdm.conf.xml";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "rm -fr " . $_SESSION['smg_root_path'] . "/nginx/html/php/sqlite/cardinfo.db";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "rm -fr /tmp/relay" . $qq;
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							//tarball copied. extract and place in proper directories
							$cmd = "tar xmzf /tmp/relay" . $qq . ".tgz -C /tmp";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "cp -fr /tmp/relay" . $qq . "/wanpipe/* /etc/wanpipe/";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "cp -fr /tmp/relay" . $qq . "/freetdm/freetdm.conf " . $_SESSION['smg_root_path'] . "/conf/";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "cp -fr /tmp/relay" . $qq . "/freetdm/freetdm.conf.xml " . $_SESSION['smg_root_path'] . "/conf/autoload_configs/";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$cmd = "cp -fr /tmp/relay" . $qq . "/cardinfo.db " . $_SESSION['smg_root_path'] . "/nginx/html/php/sqlite/";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);

							$cmd = "cp -fr /tmp/relay" . $qq . "/qos.conf " . $_SESSION['smg_root_path'] . "/conf/";
							//echo $cmd . "<br />";
							$ssh->execute($cmd,$output);
							
							$ssh->disconnect($output);
						}
					}
					
					unset($ssh);
					
				}
				elseif ($qq == 1)
				{
					//echo $qq . "<br />";	
					//Remove old wanpipe files
					$cmd = "rm -fr /etc/wanpipe/wanpipe*.conf";
					//echo $cmd . "<br />";
					shell_exec($cmd);
					
					$cmd = "rm -fr /etc/wanpipe/wanrouter.rc";
					//echo $cmd . "<br />";
					shell_exec($cmd);

					$cmd = "rm -fr /etc/wanpipe/wanpipe_old_configs/";
					//echo $cmd . "<br />";
					shell_exec($cmd);
					
					//Remove old freetdm files
					$cmd = "rm -fr " . $_SESSION['smg_root_path'] . "/conf/freetdm.conf";
					//echo $cmd . "<br />";
					shell_exec($cmd);
					
					$cmd = "rm -fr " . $_SESSION['smg_root_path'] . "/conf/autoload_configs/freetdm.conf.xml";
					//echo $cmd . "<br />";
					shell_exec($cmd);
					
					$cmd = "cp -fr /tmp/relay" . $qq . "/wanpipe/* /etc/wanpipe/";
					//echo $cmd . "<br />";
					shell_exec($cmd);
										
					$cmd = "cp -fr /tmp/relay" . $qq . "/freetdm/freetdm.conf " . $_SESSION['smg_root_path'] . "/conf/";
					//echo $cmd . "<br />";
					shell_exec($cmd);
					
					$cmd = "cp -fr /tmp/relay" . $qq . "/freetdm/freetdm.conf.xml " . $_SESSION['smg_root_path'] . "/conf/autoload_configs/";
					//echo $cmd . "<br />";
					shell_exec($cmd);
				}
			}
		}
    else
    {
      $cmd = "rm -rf " . $_SESSION['smg_root_path'] . "/conf/qos.conf";
      shell_exec($cmd);
    }
		
		
		//===========================================================
		//REDIRECT BACK AFTER FILE CREATION
		//===========================================================
		//header( 'Location:wanrouterhwprobe.php#generate' );

		return true;
	}
}	

/**
*	Pulls data out of the database and returns it in an array
*	@param table
*			database table name
*	@param param
*			sql select parameter
*	@param $data
*			database object
*	@return array
*/
public function pull_data($table,$param,$data,$id=null,$db=null) {
	$c = 0;
	$profile_array = array();
	
	if ($db == "") 
		$db = 'sqlite:sqlite/cardinfo.db';
	
	if ($id == "")
		$id = "port_id";
	
	
	//Table exists
	if ($data->check_for_table ($db, $table) > 1)
	{
		$select = "SELECT " . $param . " FROM " . $table . " ORDER BY " . $id . " ;";
		try
		{
			//open the database
			$db = new PDO($db);

			$result = $db->query($select);
	
			if (!empty($result)) {	
				foreach($result as $row)
				{
					$profile_array[$c] = $row;
					$c++;
				}
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			print 'Exception : '.$e->getMessage();
		}
	}	
	
	return $profile_array;
	
}
}


?>
