<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Activate PHP Sessions
session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	include "database_classes.php";
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include 'sqlite/database_creation.php';
		include 'display_class.php';
	
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
		
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("TDM Status", "../../style.css","");		
	}

	//echo $_SERVER['PHP_SELF'];

	$data = new database_class;
	
?>
<hr />

<?php		
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
?>
<h3>TDM Status</h3>
<?php
	}
?>

<p>Please select one of the following buttons to show your statistics related to your TDM Devices</p>

<form method="post">
<?php
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{	
?>
	<input type="submit" name="wanrouter_status" value="TDM Status" style="background-color: #CCC"/>
<?php
	}
?>
	<input type="submit" name="ftdm_list" value="List Spans" style="background-color: #CCC"/>
    <input type="submit" name="interface" value="List All Interfaces on System" style="background-color: #CCC"/>
    <br />
    <?php /*Enter Span Number for Span Information: <input type="text" name="span" style="width:30px" />
    <input type="submit" name="ftdm_dump" value="Submit" /> */ ?>
</form>

<hr />

<?php

	//echo shell_exec("pwd");
	if ($_REQUEST['interface'] == "List All Interfaces on System")
	{
		exec("ifconfig", $output);
		echo "<h4>Interface Status</h4>";

	}
	if ($_REQUEST['wanrouter_status'] == "TDM Status")
	{
		exec("cat /proc/net/wanrouter/status", $output);
		echo "<h4>TDM Driver Status</h4>";
		
	}
	//ftdm dump span #
	elseif ($_REQUEST['ftdm_dump'] == "Submit")
	{
		$command = $_SESSION['smg_location'] . "/bin/" . $_SESSION['cli'] . " \"ftdm dump " . $_REQUEST['span'] . "\"";
		exec($command, $output);
		echo "<h4>FreeTDM Dump Span # " . $_REQUEST['span'] . "</h4>\n";
	}
	elseif ($_REQUEST['ftdm_list'] == "List Spans")
	{
		$cmd = $_SESSION['smg_location'] . "/bin/" . $_SESSION['cli'] . " -x \"ftdm list\"";
		exec($cmd, $output);
		echo "<h4>Spans Loaded within " . $_SESSION['shortname'] . "</h4>";
	}
	
	$counter = count($output);
	//echo "<pre>\n";
	for ($a = 0; $a <= $counter; $a++)
	{
		echo "$output[$a]<br />";
	}
	//echo "</pre>\n";

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:index.php' ) ;
}	
?>