<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();

class create_database extends database_class
{	
	public $db_location = "";	//Contains the database location
	private $table_col = ""	;	//Contains the table columns for a particular table required
	public $relay_name="";		//Contains the relay name
	//public $db="";

	//Checks the schema for that schema and tells me if the tables are the same. If they are not the same it replaces the existing table with the new one.
	function check_schema($db_location, $table_name)
	{
		//Checks if the database exists
		try
		{
			//open the database			
			$db = new PDO ($db_location);
			
			$resq = $db->query ("PRAGMA table_info(" . $table_name . ")");
			$cols = $resq->fetchAll (PDO::FETCH_BOTH);
			$num = count ($cols);
			//echo "Number of columns = " . $num . "\n\n<br />";
			for ($i=0; $i<$num; $i++)
			{
				$numfld = count ($cols[$i]);
				/*for ($j=0; $j<$numfld; $j++)
				{
					echo $cols[$i][$j] . " ";
				}
				echo "<br />";*/
			}
			return $num;
			
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
			
		}
	
	}

	function database_creation()
	{
		//Runs the check for the file
		//$this->db_location = "sqlite:sqlite/cardinfo.db";
		$pathtemp = $_SESSION['path'] . "/sqlite";
		$path = preg_replace ("/\s*/m", "", $pathtemp);


		//if ($this->relay_name == "")
		//{
			//$this->db_location = "sqlite:sqlite/cardinfo.db";
			$cmd = "ls $path | grep -c cardinfo.db";
			
		//}
		//else
		/*{
			//echo "i am here<br />";
			
			$relay_node = parent::select_statement('sqlite:sqlite/relay_info.db','relay_hosts','id ',"relay_name = \"" . $this->relay_name . "\"");
	
			if ($relay_node['id'] == 1)
			{
				$cmd = "ls $path | grep -c cardinfo.db";
				$this->db_location = 'sqlite:sqlite/cardinfo.db';
			}
			elseif ($relay_node['id'] > 1)
			{	
				$cmd = "ls $path | grep -c cardinfo" . $relay_node['id'] . ".db";
				$this->db_location = "sqlite:sqlite/cardinfo" . $relay_node['id'] . ".db";
			}
			echo $type . ", " . $relay_node['ip_addr'] . "<br />";
			
		}*/
		exec($cmd,$output);
		
		//echo $output[0];
		//If statement that controls the output
		if ($output[0] == 0)
		{	
			//give write permissions to db and folder
			$cmd1 = "sudo /bin/chmod 777 /usr/local/nsg/nginx/html/php/sqlite";
			$cmd2 = "sudo /bin/chmod 766 /usr/local/nsg/nginx/html/php/sqlite/cardinfo.db";
			
			shell_exec ($cmd1);
			shell_exec ($cmd2);		
		
			//Create required tables
			$table_name = "t1e1_profile";
			$parameters = "id int primary key, profile_name varchar(60), line_type varchar(10), protocol varchar(10), switchtype varchar(30), signalling varchar(30), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), overlap varchar(30), transfer varchar(30)";
			parent::create_table($this->db_location, $table_name, $parameters);

			$table_name = "bri_profile";
			$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, overlap varchar(10), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), bearer_ITC varchar(30), bearer_UIL varchar(30), msn varchar(100), min_digits int";
			parent::create_table($this->db_location, $table_name, $parameters);

			$table_name = "analog_profile";
			$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), codec varchar(10), operation_mode varchar(10), hangup_polarity varchar(20), answer_polarity varchar(20),callerid varchar(20), tones varchar(20), call_waiting varchar(20), three_way varchar(20), call_swap varchar(20), digit_timeout int, max_digits int, polarity_delay int";
			parent::create_table($this->db_location, $table_name, $parameters);

			$table_name = 'r2_profile';
			$parameters = "id INTEGER PRIMARY KEY, profile_name varchar(30), varient varchar(30), ani_length int, dnis_length int, category varchar(30), collect_calls varchar(30), immediate_accept varchar(30), double_answer varchar(30), skip_category varchar(30), forced_release varchar(30), charge_calls varchar(30), ani_first varchar(30), backward_timeout varchar(30), pulse_timeout int, call_files varchar(30)";
			parent::create_table($this->db_location, $table_name, $parameters);

			//Creates the card_present table
			$table_name = "card_present";
			$parameters = "id int primary key, dev_name varchar(60), pci_slot int, pci_bus int, num_ports int, firmware int, echo varchar(20), analog_location int, num_te int, num_nt int";
			parent::create_table($this->db_location, $table_name, $parameters);		
	
			//Creates the SS7 Linkset Profile Table
			$table_name = "ss7_linkset_profile";
			$parameters = "id int primary key, profile_name varchar(60), apc int, minactive int";
			parent::create_table($this->db_location, $table_name, $parameters);	
			
			//Create the linkset used table
			$table_name="used_linkset";
			$parameters = "id int primary key, card varchar(30), name varchar(60)";
			parent::create_table($this->db_location, $table_name, $parameters);	

			//Creates the SS7 ISUP Profile Table
			$table_name = "ss7_isup_profile";
			$parameters = "id int primary key, profile_name varchar(60), spc int, ssf varchar(30), route varchar(60), t6 int , t9 int";
			parent::create_table($this->db_location, $table_name, $parameters);	
				
			//Create the isup used table
			$table_name="used_isup";
			$parameters = "id int primary key, card varchar(30), name varchar(60)";
			parent::create_table($this->db_location, $table_name, $parameters);	
			
			//Creates the SS7 Route Profile Table
			$table_name = "ss7_route_profile";
			$parameters = "id int primary key, profile_name varchar(60), dpc int, linksets varchar(100), stp varchar(10)";
			parent::create_table($this->db_location, $table_name, $parameters);	

			//Create the route used table
			$table_name="used_route";
			$parameters = "id int primary key, isup varchar(30), name varchar(60)";
			parent::create_table($this->db_location, $table_name, $parameters);	
				
			//Creates the Hosts Table
			$table_name = "hosts";
			$parameters = "id int, hostname varchar(100), ssh_port int, username varchar(100), smg_version varchar(50), relay_port int";
			parent::create_table($this->db_location, $table_name, $parameters);		
			
			//Creates the transcoding table
			$table_name = "transcode";
			$parameters = "id int primary key, interface varchar(30), ip_address varchar(30), net_mask varchar(30), mac_addr varchar(30), num_modules int, nibble varchar(30)";
			parent::create_table($this->db_location, $table_name, $parameters);	
			
			//Creates finished ports table
			$table_name = "finished_ports";
			$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30), mg_profile varchar(100)";
			//parent::create_table($this->db_location, $table_name, $parameters);	
			
			//Creates the transcoding codec	table. This is the table which the users chosen codecs get placed
			$table_name = "transcode_user_codecs";
			$parameters = "id int primary key, codec_syntax varchar(30)";
			parent::create_table($this->db_location, $table_name, $parameters);

			//Insert full codec list into transcode user codecs
			$table_check = parent::select_statement($this->db_location,$table_name,'count(*)','id=1');
			
			if ($table_check['count(*)'] == 0) {
				//Insert full codec list into transcode user codecs
				$insert_param = "id, codec_syntax";
				$insert_values = "1, \"AMR\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "2, \"G722\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "3, \"G7221\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "4, \"G723\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "5, \"G726-32\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "6, \"G729\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "7, \"GSM\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "8, \"ILBC\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
			}	
			
			$table_check = parent::select_statement($this->db_location,$table_name,'count(*)','id=1');
			
			if ($table_check['count(*)'] == 0) {
				//Insert full codec list into transcode user codecs
				$insert_param = "id, codec_syntax";
				$insert_values = "1, \"AMR\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "2, \"G722\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "3, \"G7221\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "4, \"G723\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "5, \"G726-32\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "6, \"G729\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "7, \"GSM\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "8, \"ILBC\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
			}
			
			//Creates the transcoding setup database
			$table_name = "transcode_setup";
			$parameters = "id int primary key, setup varchar(20)";
			parent::create_table($this->db_location, $table_name, $parameters);				
	
		    //Creates the transcoding codec	table. This is the table which the users chosen codecs get placed
			$table_name = "transcode_bind";
			$parameters = "id int primary key, bind_addr varchar(30), bind_port varchar(30)";
			parent::create_table($this->db_location, $table_name, $parameters);	
			
			//Creates M2UA Cluster tables
			$table_name = "m2ua_clusters";
			$parameters = "id integer primary key, profile_name varchar(100), traffic_mode varchar(50), load_share varchar(50)";
			parent::create_table($this->db_location, $table_name,$parameters);
			
			//Creates SCTP Interfaces table
			$table_name = "sctp_interfaces";
			$parameters = "id integer primary key, profile_name varchar(100), dest_ip_1 varchar(100), dest_ip_2 varchar(100), dest_ip_3 varchar(100), dest_ip_4 varchar(100),dest_ip_5 varchar(100), port int";
			parent::create_table($this->db_location, $table_name, $parameters);
	
			//Insert Default Profiles
			$table_name = "t1e1_profile";
			$table_check = parent::select_statement($this->db_location,$table_name,'count(*)','id=1');
			
			if ($table_check['count(*)'] == 0) {
				$parameters = "id, profile_name, line_type, protocol, switchtype, signalling, facility, bearer_ITC, overlap, transfer";
	
				$values = "1, \"T1 PRI CPE\", \"T1\", \"CCS\", \"NI2\", \"PRI CPE\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = "2, \"E1 PRI CPE\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI CPE\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = "3, \"T1 PRI NET\", \"T1\", \"CCS\", \"NI2\", \"PRI NET\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = "4, \"E1 PRI NET\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI NET\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
			}
	
			//Insert Default R2 Profiles
			$table_name = "r2_profile";
			$table_check = parent::select_statement($this->db_location,$table_name,'count(*)','id=1');
			
			if ($table_check['count(*)'] == 0) {
				$parameters = "id, profile_name, varient, ani_length, dnis_length, category, collect_calls";
	
				$values = '1, "R2 Mexico Profile", "mx", 10, 4, "National Subscriber","no"';
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = '2, "R2 Brazil Profile", "br", 10, 4, "National Subscriber","no"';
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = '3, "R2 ITU Profile", "itu", 10, 4, "National Subscriber","no"';
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
			}
			
			//Insert Default BRI Profiles
			$table_name = "bri_profile";
			$table_check = parent::select_statement($this->db_location,$table_name,'count(*)','id=1');
			
			if ($table_check['count(*)'] == 0) {			
				$parameters = "id, profile_name, conn_type, sig_type,  interface, switchtype, tei, overlap, bearer_ITC, min_digits";

				$values = "1, \"BRI PTMP CPE\", \"TE\", \"CPE\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);

				$values = "2, \"BRI PTMP NET\", \"NT\", \"NET\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);

				$values = "3, \"BRI PTP CPE\", \"TE\", \"CPE\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);

				$values = "4, \"BRI PTP NET\", \"NT\", \"NET\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
			}
			
			//Insert Default Analog Profiles
			$table_name = "analog_profile";
			$table_check = parent::select_statement($this->db_location,$table_name,'count(*)','id=1');
			
			if ($table_check['count(*)'] == 0) {
				$parameters = "id, profile_name, codec, operation_mode, hangup_polarity, answer_polarity, callerid, tones, call_waiting, three_way, call_swap, polarity_delay";
	
				$values = "1, \"ANALOG MULAW\", \"MULAW\", \"FCC\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", \"600\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = "2, \"ANALOG ALAW\", \"ALAW\", \"TBR21\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", \"600\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
			}
			
			$table_name='snmp_db';
		 	$parameters = "id integer, snmp_version varchar(30), username varchar(30), password varchar(30)";
			parent::create_table($this->db_location, $table_name, $parameters);	
			
		}
		else
		{		
				//give write permissions to db and folder
				$cmd1 = "sudo /bin/chmod 777 /usr/local/nsg/nginx/html/php/sqlite";
				$cmd2 = "sudo /bin/chmod 766 /usr/local/nsg/nginx/html/php/sqlite/cardinfo.db";
				
				shell_exec ($cmd1);
				shell_exec ($cmd2);
					
			//Check if the tables have the right amount of parameters
			
			//echo "t1<br />";
			$table_name = "t1e1_profile";
			$table_col = $this->check_schema($this->db_location, $table_name);
			if ($table_col != 16)
			{
				parent::drop_table($this->db_location, $table_name);
				//Create required tables
				$parameters = "id int primary key, profile_name varchar(60), line_type varchar(10), protocol varchar(10), switchtype varchar(30), signalling varchar(30), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), overlap varchar(30), transfer varchar(30)";
				parent::create_table($this->db_location, $table_name, $parameters);
				
				//Insert Default Profiles
				$parameters = "id, profile_name, line_type, protocol, switchtype, signalling, facility, bearer_ITC, overlap, transfer";
				
				$values = "1, \"T1 PRI CPE\", \"T1\", \"CCS\", \"NI2\", \"PRI CPE\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
				
				$values = "2, \"E1 PRI CPE\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI CPE\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
				
				$values = "3, \"T1 PRI NET\", \"T1\", \"CCS\", \"NI2\", \"PRI NET\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = "4, \"E1 PRI NET\", \"E1\", \"CCS\", \"EuroISDN\", \"PRI NET\", \"no\", \"\", \"disable\", \"yes\"";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);										
			}
			//echo "bri<br />";

			//echo "r2<br />";
			$table_name = "r2_profile";
			$table_col = $this->check_schema($this->db_location, $table_name);
			if ($table_col != 16)
			{
				parent::drop_table($this->db_location, $table_name);
				//Create required tables
				$parameters = "id INTEGER PRIMARY KEY, profile_name varchar(30), varient varchar(30), ani_length int, dnis_length int, category varchar(30), collect_calls varchar(30), immediate_accept varchar(30), double_answer varchar(30), skip_category varchar(30), forced_release varchar(30), charge_calls varchar(30), ani_first varchar(30), backward_timeout varchar(30), pulse_timeout int, call_files varchar(30)";
				parent::create_table($this->db_location, $table_name, $parameters);
				
				//Insert Default Profiles
				$parameters = "id, profile_name, varient, ani_length, dnis_length, category, collect_calls";
				
				$values = '1, "R2 Mexico Profile", "mx", 10, 4, "National Subscriber","no"';
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
				
				$values = '2, "R2 Brazil Profile", "br", 10, 4, "National Subscriber","no"';
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
				
				$values = '3, "R2 ITU Profile", "itu", 10, 4, "National Subscriber","no"';
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);											
			}

			$table_name = "bri_profile";
			$table_col = $this->check_schema($this->db_location, $table_name);
			if ($table_col != 16)
			{
				$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), sig_type varchar(10), interface varchar(10), switchtype varchar(30), tei int, overlap varchar(10), ton_name varchar(100), ton_value varchar(100), npi_name varchar(100), npi_value varchar(100), bearer_ITC varchar(30), bearer_UIL varchar(30), msn varchar(100), min_digits int";				
				parent::drop_table($this->db_location, $table_name);
				//Create required tables
				parent::create_table($this->db_location, $table_name, $parameters);
				
				//Insert Default Profiles
				$parameters = "id, profile_name, conn_type, sig_type,  interface, switchtype, tei, overlap, bearer_ITC, min_digits";
				
				$values = "1, \"BRI PTMP CPE\", \"TE\", \"CPE\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
				
				$values = "2, \"BRI PTMP NET\", \"NT\", \"NET\", \"ptmp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
	
				$values = "3, \"BRI PTP CPE\", \"TE\", \"CPE\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
							
				$values = "4, \"BRI PTP NET\", \"NT\", \"NET\", \"ptp\", \"EuroISDN\", \"\", \"disable\", \"\", 7";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);										
			}
			//echo "analog<br />";

			$table_name = "analog_profile";
			$table_col = $this->check_schema($this->db_location, $table_name);
			if ($table_col != 15)
			{
				//echo "here";
				$parameters = "id int primary key, profile_name varchar(60), conn_type varchar(10), codec varchar(10), operation_mode varchar(10), hangup_polarity varchar(20), answer_polarity varchar(20), callerid varchar(20), tones varchar(20), call_waiting varchar(20), three_way varchar(20), call_swap varchar(20), digit_timeout int, max_digits int, polarity_delay int";			
				parent::drop_table($this->db_location, $table_name);
				//Create required tables
				parent::create_table($this->db_location, $table_name, $parameters);
				
				//Insert Default Profiles
				$parameters = "id, profile_name, codec, operation_mode, hangup_polarity, answer_polarity, callerid, tones, call_waiting, three_way, call_swap, polarity_delay";
			
				$values = "1, \"ANALOG MULAW\", \"MULAW\", \"FCC\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", 600";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);
			
				$values = "2, \"ANALOG ALAW\", \"ALAW\", \"TBR21\", \"disable\", \"disable\", \"enable\", \"us\", \"disable\", \"disable\", \"disable\", 600";
				parent::insert_statement($this->db_location, $table_name, $parameters, $values);						
			}			


			//Creates the card_present table
			$table_name = "card_present";
			$parameters = "id int primary key, dev_name varchar(60), pci_slot int, pci_bus int, num_ports int, firmware int, echo varchar(20), analog_location int, num_te int, num_nt int";	
			$insert_parameters = "id , dev_name, pci_slot , pci_bus , num_ports , firmware , echo , analog_location , num_te , num_nt ";	
			parent::check_schema($this->db_location, $table_name, $parameters, "10", $insert_parameters);
	
			//Creates the SS7 Linkset Profile Table
			$table_name = "ss7_linkset_profile";
			$parameters = "id int primary key, profile_name varchar(60), apc int, minactive int";
			$insert_parameters = "id , profile_name , apc , minactive ";
			parent::check_schema($this->db_location, $table_name, $parameters, "4", $insert_parameters);					

			//Create the linkset used table
			$table_name="used_linkset";
			$parameters = "id int primary key, card varchar(30), name varchar(60)";
			$insert_parameters = "id, card, name";
			parent::check_schema($this->db_location, $table_name, $parameters, "3", $insert_parameters);	

			//Create the route used table
			$table_name="used_route";
			$parameters = "id int primary key, isup varchar(30), name varchar(60)";
			$insert_parameters = "id, isup, name";
			parent::check_schema($this->db_location, $table_name, $parameters, "3", $insert_parameters);	
			
			//Create the isup used table
			$table_name="used_isup";
			$parameters = "id int primary key,card varchar(30), name varchar(60)";
			$insert_parameters = "id, card, name";
			parent::check_schema($this->db_location, $table_name, $parameters, "3", $insert_parameters);	
						
			//Creates the SS7 ISUP Profile Table
			$table_name = "ss7_isup_profile";
			$parameters = "id int primary key, profile_name varchar(60), spc int, ssf varchar(30), route varchar(60), t6 int, t9 int";
			$insert_parameters = "id , profile_name , spc , ssf , route";
			parent::check_schema($this->db_location, $table_name, $parameters, "7", $insert_parameters);		
	
			//Creates the SS7 Route Profile Table
			$table_name = "ss7_route_profile";
			$parameters = "id int primary key, profile_name varchar(60), dpc int, linksets varchar(100), stp varchar(10)";
			$insert_parameters = "id , profile_name , dpc , linksets , stp";	
			parent::check_schema($this->db_location, $table_name, $parameters, "5", $insert_parameters);
			
			//Creates finished ports table
			$table_name = "finished_ports";
			$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(30), mg_profile varchar(30), span int";
			$insert_parmeters = "id, card, completed, type";
			//parent::create_table($this->db_location, $table_name, $parameters);	
			parent::check_schema($this->db_location, $table_name, $parameters, "6", $insert_parameters);
			
			//Creates the SS7 Route Profile Table
			$table_name = "hosts";
			$parameters = "id int, hostname varchar(100), ssh_port int, username varchar(100), smg_version varchar(50), relay_port int";
			$insert_parameters = "id, hostname , ssh_port , username , smg_version , relay_port ";	
			//parent::check_schema($this->db_location, $table_name, $parameters, "6", $insert_parameters);
			
			//Creates the transcoding table
			$table_name = "transcode";
			$parameters = "id int primary key, interface varchar(30), ip_address varchar(30), net_mask varchar(30), mac_addr varchar(30), num_modules int, nibble varchar(30)";
			$insert_parameters = "id, interface, ip_address, net_mask, num_modules, nibble";
			parent::check_schema($this->db_location, $table_name, $parameters, "7", $insert_parameters);
			
			//Creates the transcoding codec	table. This is the table which the users chosen codecs get placed
			$table_name = "transcode_user_codecs";
			$parameters = "id int primary key, codec_syntax varchar(30)";
			$insert_parameters = "id, codec_syntax";
			parent::check_schema($this->db_location, $table_name, $parameters, "2", $insert_parameters);
			
			//Checks to make sure the table is not populated. If it is not populated, it will adjust the table to make sure all codecs are highlighted
			$table_check = parent::select_statement($this->db_location,$table_name,'count(*)','id=1');
			
			if ($table_check['count(*)'] == 0) {
				//Insert full codec list into transcode user codecs
				$insert_param = "id, codec_syntax";
				$insert_values = "1, \"AMR\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "2, \"G722\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "3, \"G7221\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "4, \"G723\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "5, \"G726-32\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "6, \"G729\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "7, \"GSM\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
				$insert_values = "8, \"ILBC\"";
				parent::insert_statement($this->db_location, $table_name, $insert_param, $insert_values);	
			}	
			
			//Creates the transcoding setup database
			$table_name = "transcode_setup";
			$parameters = "id int primary key, setup varchar(20)";
			$insert_parameters = "id, setup";
			parent::check_schema($this->db_location, $table_name, $parameters, "2", $insert_parameters);			
			
			//Creates the table which holds the bind address and the bind port for the sngtc installation
			$table_name = "transcode_bind";
			$parameters = "id int primary key, bind_addr varchar(30), bind_port varchar(30)";
			$insert_parameters = "id, bind_addr, bind_port";
			parent::check_schema($this->db_location, $table_name, $parameters, "3", $insert_parameters);	
			
			
			//Creates M2UA Cluster tables
			$table_name = "m2ua_clusters";
			$parameters = "id integer primary key, profile_name varchar(100), traffic_mode varchar(50), load_share varchar(50)";
			$insert_parameters = "id, traffic_mode, load_share";
			parent::check_schema($this->db_location, $table_name, $parameters, "4", $insert_parameters);	
			
			//Creates SCTP Interfaces table
			$table_name = "sctp_interfaces";
			$parameters = "id integer primary key, profile_name varchar(100),dest_ip_1 varchar(100), dest_ip_2 varchar(100), dest_ip_3 varchar(100), dest_ip_4 varchar(100),dest_ip_5 varchar(100), port int";
			$insert_parameters = "id, dest_ip_1,dest_ip_2,dest_ip_3,dest_ip_4,dest_ip_5, port";
			parent::check_schema($this->db_location, $table_name, $parameters, "8", $insert_parameters);	
			
			$table_name='snmp_db';
		 	$parameters = "id integer, snmp_version varchar(30), username varchar(30), password varchar(30)";
			$insert_parameters = 'id, snmp_version, username, password';
			parent::check_schema($this->db_location, $table_name, $parameters, "4", $insert_parameters);
						
			
		}
	}
}

?>
