<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

@ini_set('zlib.output_compression',0);
#@ini_set('implicit_flush',1);
@ini_set('output_buffering','on');
@ob_end_clean();
set_time_limit(0);

session_start();

include 'check_referer.php';

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{

	include 'sng_config_manager_functions.php';
	include 'database_classes.php';
	include 'wanrouter_controls.php';
	include 'classes.php';
	include 'mg/mg_config_generate.php';
	include 'wanpipe_config/wanpipe.php';
	include 'smg_ctrl/smg_ctrl.php';
	include 'freetdm_config/freetdm.php';
	include 'installation/transcoding_class.php';
	
	$tdm_config = new wanrouter_hwprobe_controls;
	$data = new database_class;
	$tokenization = new wanrouter_hwprobe;
	
	$install=false;
	$reset=false;
	$restore=false;
	$restart=false;	

	if ($_REQUEST['reset']){
		//Resets Configuration
		$tdm_config->redirect($_REQUEST,$data,$tokenization);
		
		//Reset MP Tables
		reset_mp_tables($data);
		
		//Reset MG Configuration
		reset_mg_tables($data);
		
		$reset=true;
	}
	if ($_REQUEST['restore']){
		//Restores configuration (TDM)
		$tdm_config->redirect($_REQUEST,$data,$tokenization);
		
		//Restore MP Tables
		restore_mp_tables($data);
		
		//Restores Configuration (MG)
		restore_mg_tables($data);
		
		$restore=true;
	}

	if ($_REQUEST['install-restart']) {
		$_REQUEST['generate'] = "Generate Config";
		$restart='restart';
	}

	if ($_REQUEST['install-start']) {
		$_REQUEST['generate'] = "Generate Config";
		$restart = 'start';
	}

	if ($_REQUEST['generate']){
		$data->drop_all_tables('sqlite:sqlite/cardinfo.db');
		$install=true;
	}



	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		include 'display_class.php';
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include 'sqlite/database_creation.php';
		include 'display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";	
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Configuration Manager", "/style.css","");		
	}	

	if ($install) 
		cfg_display_files($tdm_config,$tokenization,$data,$restart);
	else {
		if ($reset)	
			cfg_manager($reset);
		elseif ($restore)	
			cfg_manager('',$restore);
		else
			cfg_manager();
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer(true);	
	}
}
else
{
	header( 'Location:index.php' ) ;
}


?>
