<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();
include '../display_class.php';
$display_common = new Display_common;
if ( $display_common->IsRenderingNonDynamicDiv( ) ) {
	if (empty ($_POST)) 
		include '../check_referer.php';
}

//Checks to make sure the user is logged into the WebUI
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Page includes
	include 'nsg_relay_cfg_class.php';
	include '../database_classes.php';
	include 'relay_questionnaire_class.php';
	
	//Class Constructors
	$relay_cfg = new relay_hosts;
	$data = new database_class;
	$ssh_gen = new questionnaire;

	//Defines
	define(	"UPLOAD_LOCATION",	"/root/.ssh/"); //Contains the location of the public/private key
	define( "DB_LOCATION",		"sqlite:../sqlite/relay_info.db"); //Contains the database tables for relay
	define( "RELAY_TABLE"		,"relay_hosts"); //Contains the relay_hosts table
	
	unset($_SESSION['host_id']);

	//Pre-page processing
	//Pull information regarding the relay type
	$table = $data->check_for_table(DB_LOCATION,"ss7_relay");
	if ($table < 2)
	{
		//Redirect user to relay questionnaire
		header('location:relay_questionnaire.php');
	}
	if ($table > 1)
	{
		//Check if standalone
		$check = $data->select_statement(DB_LOCATION,"ss7_relay","machine_type","id = 1");
		// Do not redirect to questionnaire, just display stand alone and allow to 
		// change configuration
		if ($check['machine_type'] == "standalone")
		{
			//header('location:relay_questionnaire.php');
		}
	}

	if ($_REQUEST['enable_ssh'] == "yes")
	{
		//system('/etc/init.d/sshd start');
		shell_exec ('/etc/init.d/sshd start');
	}

	if ($_REQUEST['add_new_host'])
	{
		$_SESSION['ping'] = "";
		$_SESSION['ssh_status'] = "";
		
		//redirect to relay host addition page
		header( 'Location:add_relay_host.php' );
	}
	
	//Upload the key to /root/.ssh directory
	if ($_REQUEST['upload_key'])
	{
		$_SESSION['ping'] = "";
		$_SESSION['ssh_status'] = "";
		$relay_cfg->upload_pub_key($data);
	}
	
	//Generate new ssh key pairs
	if ($_REQUEST['generate_key'] || $_REQUEST['generate_key2'])
	{
		//echo "i am here";
		$_SESSION['ping'] = "";
		$_SESSION['ssh_status'] = "";
		$ssh_gen->generate_ssh_key($data);
		//header('Location:relay_cfg.php');
	}
	
	//Post checking for edit and delete buttons
	foreach ($_REQUEST as $key => $value)
	{
		for ($x = 0; $x <= 9; $x++)
		{
			//Delete a host
			if ($key == "delete$x" && $value == "Remove")
			{
				$_SESSION['ping'] = "";
				$_SESSION['ssh_status'] = "";
				$where_param = "id = $x";
				$data->delete_generic(DB_LOCATION,RELAY_TABLE,$where_param);
			}
			
			//Edit a host
			if ($key == "edit$x" && $value == "Edit")
			{
				$_SESSION['ping'] = "";
				$_SESSION['ssh_status'] = "";
				$_SESSION['host_id'] = $x;
				header('location:add_relay_host.php');
			}
		}
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';	
		
		$_SESSION['embedded'] = "true";
		
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("NSG Relay Configuration ", "../../style.css","");		
	}
	
	//MAIN PAGE
	
	if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])
	  && $display_common->IsRenderingNonDynamicDiv( ) )  
	{
		$display_common->DynamicDivEnable();
    unset($_SESSION['ping']);
    unset($_SESSION['ssh_status']);
	}	
	
	
	
	$relay_cfg->relay_page($data, $display_common);
	
	
	$_SESSION['ping'] = "yes";
	$_SESSION['ssh_status'] = "yes";
	
	if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
	{
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			unset($_SESSION['embedded']);
			//FusionPBX Integration
			require_once "../fusionpbx/includes/footer.php";
		}
		elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{
			//ClearOS Integration
			$display_common->html_footer();	
		}
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>
