<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();
$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";


//Checks to make sure the user is logged into the WebUI
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//File Includes
	include 'add_relay_class.php';
	include '../database_classes.php';	
	
	//Class Constructors
	$add_relay = new add_relay_host;
	$add_relay->data = new database_class;
	
	//Defines
	define( "DB_LOCATION",		"sqlite:../sqlite/relay_info.db"); //Contains the database tables for relay
	define( "COLOR_ERROR" , 	"#E42217"); // Kind of Firebrick
	define(	"RELAY_TABLE", 		"relay_hosts"); //Table which contains the relay hosts
	
	//Get database information
	if ($_SESSION['host_id'] )
	{
		$add_relay->database_check();
	}
	
	//echo $add_relay->database['id'] . "<br />";
	
	//-----FORM POST-----//
	
	if ($_REQUEST['cancel'])
	{
		//Return to the relay configuration page
		header('location:relay_cfg.php');
	}
	
	if ($_REQUEST['add_host'] == "Apply Configuration" || $_REQUEST['add_host'] == "Add Host")
	{
		//echo "I am here";
		//Validate form
		if ($add_relay->database['id'] == 1)
		{
			$_REQUEST['ssh_port'] = 22;
		}
		
		$error_count = $add_relay->validate();
		
		//echo "$error_count<br />";
		if ($error_count == 0)
		{
			//Proceed to add to the database
			$add_relay->insert_info();
			$_SESSION['host_id'] = "";
			
			$_SESSION['first_time'] == "";
			//Redirect to relay configuration
			header('location:relay_cfg.php');
		}
		else
		{
			//Error in form
		}
	}
	
	
	//-----HTML PAGE-----//
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
		
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Add Relay Host ", "../../style.css","");		
	}
	
	//MAIN PAGE
	$add_relay->main_html();
	
	
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>