<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class r2_profiles {
	
	public $db = 'sqlite:../sqlite/cardinfo.db';		//DB Location
	
	/**
	* Displays the main profile table
	* @param object $data
	*/
	public function display($data=NULL) {
		$r2_profiles = $this->get_r2_profiles($data);
		$available_ports = $this->find_available_ports($data);
		?>
        <br />
		<form name="r2_profiles" method="post">
    		
            <table class="mytable" width='100%'>
                <th colspan="9" class="widget-content-header ui-state-active ui-corner-top" align="left">R2 Signalling Profiles</th>
                <tr>
            	    <td class="mytableheader ">Profile Name</td>
            	    <td class="mytableheader ">Varient</td>                    
        	        <td class="mytableheader ">ANI Length</td>
    	            <td class="mytableheader ">DNIS Length</td>
                    <td class="mytableheader">Category</td>
	                <td class="mytableheader" colspan="4"></td>
                </tr>
		<?php
		foreach ($r2_profiles as $profile) {
			echo "<tr>";
			if ($_SESSION['last_profile'] == $profile['profile_name'])
				echo "<td><b>" . $profile['profile_name'] . "</b></td>";
			else
				echo "<td>" . $profile['profile_name'] . "</td>";
			
			if ($profile['varient'] == "br")
				echo "<td>Brazil</td>";
			elseif ($profile['varient'] == "mx")
				echo "<td>Mexico</td>";
			elseif ($profile['varient'] == "ar")
				echo "<td>Argentina</td>";
			elseif ($profile['varient'] == "cn")
				echo "<td>China</td>";			
			elseif ($profile['varient'] == "cz")
				echo "<td>Czech Republic</td>";
			elseif ($profile['varient'] == "co")
				echo "<td>Columbia</td>";
			elseif ($profile['varient'] == "ec")
				echo "<td>Ecuador</td>";
			elseif ($profile['varient'] == "itu")
				echo "<td>ITU</td>";
			elseif ($profile['varient'] == "ph")
				echo "<td>Phillipines</td>";
			elseif ($profile['varient'] == "ve")
				echo "<td>Venezuela</td>";																
																			
			echo "<td>" . $profile['ani_length'] . "</td>";
			echo "<td>" . $profile['dnis_length'] . "</td>";
			echo "<td>" . $profile['category'] . "</td>";
			
			echo "<td align='right'>";
			
			if ($this->check_port_profile_used($profile['profile_name'], $data))
				echo "<input type='submit' name='use-" . $profile['id'] . "' value='Use' " . $_SESSION['button_class'] . " />";
			else
				echo "<input type='submit' name='use-" . $profile['id'] . "' value='Use' " . $_SESSION['disabled_button_class'] . " />";
				
			if ($available_ports) 	
				echo "<input type='submit' name='use-all-" . $profile['id'] . "' value='Use for all Ports' " . $_SESSION['button_class'] . " />";
			else
				echo "<input type='submit' name='use-all-" . $profile['id'] . "' value='Use for all Ports' " . $_SESSION['disabled_button_class'] . " />";
				
			echo "<input type='submit' name='edit-" . $profile['id'] . "' value='Edit' " . $_SESSION['button_class'] . " />";
			
			$skip = false;
			
			if ($profile['profile_name'] == "R2 Mexico Profile" || $profile['profile_name'] == "R2 Brazil Profile")
				$skip = true;

			if (!$skip) {
				//check if r2 profile in use
				if ($this->check_profile_used($profile['profile_name'], $data))
					echo "<input type='submit' name='delete-" . $profile['id'] . "' value='Delete' " . $_SESSION['button_class'] . " />";										
				else
					echo "<input type='submit' name='delete-" . $profile['id'] . "' value='Delete' " . $_SESSION['disabled_button_class'] . " />";
			}
			else
				echo "<input type='submit' name='delete-" . $profile['id'] . "' value='Delete' " . $_SESSION['disabled_button_class'] . " />";
			echo "</td>";	
			echo "</tr>";
		}
		?>
            </table>
            
	    	<br />
	        <table width="100%">
	        <tr>
	        <td width="10%"><input type="submit" name="create" value="Create New Profile" <?=$_SESSION['button_class']; ?>/></td>
	    	<td align="right"><input type="submit" name="back" value="Go Back to Hardware Information" <?=$_SESSION['button_class']; ?>/></td>
	        </tr>
	        </table>            
		</form>                      
        <?php
		unset($_SESSION['last_profile']);		
	}
	
	/**
	* Pulls all the profile information out of the database
	* @param object $data 
	*/
	public function get_r2_profiles ($data) {
		$profiles = $data->array_select_statement ($this->db, 'r2_profile', '*', '');
		return $profiles;
	}

	/**
	* Checks if a R2 profile is in use by any board in the system
	* @param string $profile_name
	* @return boolean
	*/
	public function check_profile_used($profile_name, $data=NULL) {
		//pull all the cards in the system
		$boards = $this->pull_data('card_present','id, dev_name',$data);
		
		foreach ($boards as $board) {
			$board_name = explode ('-',$board['dev_name']);
			$dev_name = $board_name[1];
			$dev_id = $board['id'];
			
			$table = $dev_name.'_'.$dev_id.'_r2_signalling';
			$card = $this->pull_data($table,'r2_profile',$data);
			foreach ($card as $sig) {
				if ($sig['r2_profile'] == $profile_name)
					return false;
			}
		}
		return true;
	}	
	
	/**
	* Checks if a R2 profile is in use by any board in the system
	* @param string $profile_name
	* @return boolean
	*/
	public function check_port_profile_used($profile_name, $data=NULL) {
		//pull all the cards in the system
		$table = $_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling';
		$card = $data->select_statement($this->db,$table,'r2_profile','port_id='.$_SESSION['port_num_clicked']);
		
		if ($card['r2_profile'] == $profile_name)
			return false;
		
		return true;
	}		
	
	/**
	*	Pulls data out of the database and returns it in an array
	*	@param table
	*			database table name
	*	@param param
	*			sql select parameter
	*	@param $data
	*			database object
	*	@return array
	*/
	public function pull_data($table,$param,$data=NULL) {
		$c = 0;
		$profile_array = array();
		
		if ($this->db == "") 
			$this->db = 'sqlite:../sqlite/cardinfo.db';
		
		
		//Table exists
		if ($data->check_for_table ($this->db, $table) > 1)
		{
			$select = "SELECT " . $param . " FROM " . $table . ";";
	
			try
			{
				//open the database
				$db = new PDO($this->db);
	
				$result = $db->query($select);
			
				foreach($result as $row) {
					$profile_array[$c] = $row;
					$c++;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				//echo "hello <br />";
				print 'Exception : '.$e->getMessage();
				echo "<br />";
				echo "Table = $table<br />";
				echo "Parameter = $param<br />";
				echo "db location = " . $this->db . "<br />";
			}
		}	
		return $profile_array;
	}
	
	/**
	* Creates the r2 signalling table
	* @param object $data
	*/
	public function create_r2_table($data=NULL) {
		$create_param = "port_id int primary key, dev_name varchar(60), r2_profile varchar(60), line_type, channels varchar(60), group_num int";
		$data->create_table($this->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling' , $create_param);
	}
	
	/**
	* Returns the r2 profile name from the database
	* @param object $data
	* @param string $r2_profile_id
	*/	
	public function find_r2_profile_name ($data=NULL,$r2_profile_id) {
		$r2_profile_name = $data->select_statement($this->db,'r2_profile','profile_name','id='.$r2_profile_id);
		return $r2_profile_name['profile_name'];
	}

	/**
	* Inserts the information into the r2 profile signalling database for a board
	* @param object $data
	* @param string $r2_profile_id
	* @param string $port_id
	*/		
	public function insert_r2_table($data=NULL,$r2_profile_id, $port_id=NULL) {
		if (isset($port_id)) 
			$port = $port_id;
		else
			$port = $_SESSION['port_num_clicked'];
		
		//find r2 profile name
		$r2_profile = $this->find_r2_profile_name($data,$r2_profile_id);
		
		$param = 'port_id,dev_name,r2_profile,line_type';
		$values = $port.',"'.$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'","'.$r2_profile.'","E1"';
		$data->insert_statement($this->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling',$param,$values);
		
	}
	
	/**
	* Updates the information of the r2 profile signalling database for a board
	* @param object $data
	* @param string $r2_profile_id
	* @param string $port_id
	*/			
	public function update_r2_table ($data=NULL,$r2_profile_id,$port_id=NULL) {
		if (isset($port_id)) 
			$port = $port_id;
		else
			$port = $_SESSION['port_num_clicked'];

		//find r2 profile name
		$r2_profile = $this->find_r2_profile_name($data,$r2_profile_id);
		
		$where = "port_id=".$port;
		$param = 'r2_profile="'.$r2_profile.'"';
		$data->update_table($this->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_r2_signalling',$param,$where);
		
	}
	
	/**
	* Finds amount of available ports for the Use for all ports button. Will allow changing R2 profiles
	* @param object $data
	*/
	public function find_available_ports ($data=NULL) {
		//Find total number of ports on card
		$table = 'card_present';
		$param = 'num_ports';
		$where = 'id='.$_SESSION['card_num'];
		
		$num_ports = $data->select_statement($this->db,$table,$param,$where);
		$current = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'],'*','port_id='.$_SESSION['port_num_clicked']);
		$physical = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
		
		$counter = 0;

		for ($a=1;$a<=$num_ports['num_ports'];$a++) {	
			$port = $a;	
			//Check if port has any other config. if it does, skip over the configuration.
			$m2ua = $data->select_statement($this->db,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_m2ua_link','link_name','port_id='.$port);
			$mg = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_channels",'profile_name','port_id='.$port);
			$ss7_link = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link","link_name",'port_id='.$port);
			$pri = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling",'signalling','port_id='.$port);
			//$r2 = $data->select_statement($this->db,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_r2_signalling",'r2_profile','port_id='.$port);
			
			if ($ss7_link['link_name'] != "")
				$counter++;
			elseif($mg['profile_name'] != "")
				$counter++;
			elseif ($m2ua['link_name'] != "")
				$counter++;
			elseif ($pri['signalling'] != "")
				$counter++;
			//elseif ($r2['r2_profile'] != "")
			//	$counter++;
				
		}

		$total_available_ports = ($a-1) - $counter;

		if ($total_available_ports > 1)
			return true;
		else
			return false;		
	}
}

?>