<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class r2_profile {
	
	public $db;					//database location
	private $_pick=array();		//Contains the information that will be entered into the form on post or on load
	public $edit=array();		//Contains the DB information for a specific profile
	public $error=array();		//Contains the validation error messages
	
	public function display($data) {
		$this->_get_values($data);
		
		?>
    	<br />
        <form name='create_r2' method="post">
        	<table class="mytable" width='100%'>
                <th colspan="9" class="widget-content-header ui-state-active ui-corner-top" align="left">R2 Signalling Profiles</th>
                <tr>
                	<td class="mytablesubheader" width='30%'>Profile Name</td>
                    <?php
					if ($this->edit['profile_name'] == "") {
					?>
                    <td width='40%'><input type="text" name="profile_name" value="<?=$this->_pick['profile_name'];?>" align="right" style="text-align:left" /></td>
					<?php
                    }
					else {
					?>
                    <td width='40%'><input type="text" name="profile_name" value="<?=$this->_pick['profile_name'];?>" align="right" style="text-align:left" disabled="disabled" /></td>
					<?php						
					}
					?>
                    <td width='30%'><font color="#FF0000"><?=$this->error['profile_name']?></font></td>
                </tr>                
            </table>
        	<br />
           	<table class="mytable" width='100%'>
                <th colspan="9" class="widget-content-header ui-state-active ui-corner-top" align="left">Standard Options</th>
                <tr>
                	<td class="mytablesubheader" width='30%'>Varient</td>
                    <td>
                    	<select name='varient'>
                        	<option value='ar' <?php if ($this->_pick['varient_ar'] == "yes") { echo "selected='selected'"; } ?> />Argentina</option>
							<option value='br' <?php if ($this->_pick['varient_br'] == "yes") { echo "selected='selected'"; } ?> />Brazil</option>                            
                            <option value='cn' <?php if ($this->_pick['varient_cn'] == "yes") { echo "selected='selected'"; } ?> />China</option>
                            <option value='cz' <?php if ($this->_pick['varient_cz'] == "yes") { echo "selected='selected'"; } ?> />Czech Republic</option>
                            <option value='co' <?php if ($this->_pick['varient_co'] == "yes") { echo "selected='selected'"; } ?> />Colombia</option>
                            <option value='ec' <?php if ($this->_pick['varient_ec'] == "yes") { echo "selected='selected'"; } ?> />Ecuador</option>
                            <option value='itu' <?php if ($this->_pick['varient_itu'] == "yes") { echo "selected='selected'"; } ?> />ITU</option>
                            <option value='mx' <?php if ($this->_pick['varient_mx'] == "yes") { echo "selected='selected'"; } ?> />Mexico</option>
                            <option value='ph' <?php if ($this->_pick['varient_ph'] == "yes") { echo "selected='selected'"; } ?> />Phillipines</option>
                            <option value='ve' <?php if ($this->_pick['varient_ve'] == "yes") { echo "selected='selected'"; } ?> />Venezuela</option>
                        </select>
                    </td>
                    <td><font color="#FF0000"><?=$this->error['varient']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>ANI Length</td>
                    <td><input type='text' name='ani_length' value='<?=$this->_pick['ani_length']?>' /></td>
                    <td><font color="#FF0000"><?=$this->error['ani_length']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>DNIS Length</td>
                    <td><input type='text' name='dnis_length' value='<?=$this->_pick['dnis_length']?>' /></td>
                    <td><font color="#FF0000"><?=$this->error['dnis_length']?></font></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>Category</td>
                    <td>
                    	<select name='category'>
                        	<option value='National Subscriber' <?php if ($this->_pick['category_National_Subscriber'] == "yes") { echo "selected='selected'"; } ?> />National Subscriber</option>
                            <option value='National Priority Subscriber' <?php if ($this->_pick['category_National_Priority_Subscriber'] == "yes") { echo "selected='selected'"; } ?> />National Priority Subscriber</option>
                            <option value='International Subscriber' <?php if ($this->_pick['category_International_Subscriber'] == "yes") { echo "selected='selected'"; } ?> />International Subscriber</option>
                            <option value='International Priority Subscriber' <?php if ($this->_pick['category_International_Priority_Subscriber'] == "yes") { echo "selected='selected'"; } ?> />International Priority Subscriber</option>
                            <option value='Collect Call' <?php if ($this->_pick['category_Collect_Call'] == "yes") { echo "selected='selected'"; } ?> />Collect Call</option>
                            <option value='Test Equipment' <?php if ($this->_pick['category_Test_Equipment'] == "yes") { echo "selected='selected'"; } ?> />Test Equipment</option>
                            <option value='Pay Phone' <?php if ($this->_pick['category_Pay_Phone'] == "yes") { echo "selected='selected'"; } ?> />Pay Phone</option>
                            <!-- <option value='Unknown' <?php if ($this->_pick['category_Unknown'] == "yes") { echo "selected='selected'"; } ?> />Unknown</option>-->
                        </select>
                    </td>
                    <td><font color="#FF0000"><?=$this->error['category']?></font></td>
                </tr>                                                               
            </table>
            <br />
            <div class="fakelink"
                id="show_e"
                onclick="this.style.display='none';
                document.getElementById('hide_e').style.display='block';
                document.getElementById('options').style.display='inline';
                ResizeFrame();
                ">&raquo; Show Advanced Options</div>
            <div class="fakelink"
                id="hide_e"
                onclick="this.style.display='none';
                document.getElementById('show_e').style.display='block';
                document.getElementById('options').style.display='none';
                ResizeFrame();
                ">&raquo; Hide Advanced Options</div>
            <div id="options"> 
	            <br />
            	<table class="mytable" width='100%'>
                	<th colspan="9" class="widget-content-header ui-state-active ui-corner-top" align="left">Advanced Options</th>                     
                    <tr>
                        <td class="mytablesubheader" width='30%'>Collect Calls</td>
                        <td>
                            <select name='collect_calls'>
                            	<option value='yes' <?php if ($this->_pick['collect_calls_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['collect_calls_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['collect_calls']?></font></td>
                    </tr>  
                    <tr>
                        <td class="mytablesubheader" width='30%'>Immediately Accept Calls</td>
                        <td>
                            <select name='immediate_accept'>
                            	<option value='yes' <?php if ($this->_pick['immediate_accept_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['immediate_accept_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['immediate_accept']?></font></td>
                    </tr>
                    <tr>
                        <td class="mytablesubheader" width='30%'>Double Answer</td>
                        <td>
                            <select name='double_answer'>
                            	<option value='yes' <?php if ($this->_pick['double_answer_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['double_answer_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['double_answer']?></font></td>
                    </tr> 
                    <tr>
                        <td class="mytablesubheader" width='30%'>Skip Category</td>
                        <td>
                            <select name='skip_category'>
                            	<option value='yes' <?php if ($this->_pick['skip_category_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['skip_category_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['skip_category']?></font></td>
                    </tr>  
                    <tr>
                        <td class="mytablesubheader" width='30%'>Forced Release</td>
                        <td>
                            <select name='forced_release'>
                            	<option value='yes' <?php if ($this->_pick['forced_release_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['forced_release_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['forced_release']?></font></td>
                    </tr>    
                    <tr>
                        <td class="mytablesubheader" width='30%'>Charge Calls</td>
                        <td>
                            <select name='charge_calls'>
                            	<option value='yes' <?php if ($this->_pick['charge_calls_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['charge_calls_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['charge_calls']?></font></td>
                    </tr> 
                    <tr>
                        <td class="mytablesubheader" width='30%'>Get ANI First</td>
                        <td>
                            <select name='ani_first'>
                            	<option value='yes' <?php if ($this->_pick['ani_first_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['ani_first_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['ani_first']?></font></td>
                    </tr>
                    <tr>
                        <td class="mytablesubheader" width='30%'>MF Backward Timeout</td>
                        <!--<td>
                            <select name='backward_timeout'>
                            	<option value='yes' <?php if ($this->_pick['backward_timeout_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['backward_timeout_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td> -->
                        <td><input type='text' name='backward_timeout' value='<?=$this->_pick['backward_timeout']?>' /></td>                        
                        <td><font color="#FF0000"><?=$this->error['backward_timeout']?></font></td>
                    </tr>  
                    <tr>
                        <td class="mytablesubheader" width='30%'>Metering Pulse Timeout</td>
                        <td><input type='text' name='pulse_timeout' value='<?=$this->_pick['pulse_timeout']?>' /></td>
                        <td><font color="#FF0000"><?=$this->error['pulse_timeout']?></font></td>
                    </tr>
                    <tr>
                        <td class="mytablesubheader" width='30%'>Enable/Disable R2 Debugging</td>
                        <td>
                            <select name='call_files'>
                            	<option value='yes' <?php if ($this->_pick['call_files_yes'] == "yes") { echo "selected='selected'"; } ?> />Enable</option>
                                <option value='no' <?php if ($this->_pick['call_files_no'] == "yes") { echo "selected='selected'"; } ?> />Disable</option>
                            </select>
                        </td>
                        <td><font color="#FF0000"><?=$this->error['backward_timeout']?></font></td>
                    </tr>                                                                                                                                                                                   
           		</table>
            </div>
            <br />
        	<table width="100%">
	        	<tr>
		    	    <td width="10%"><input type="submit" name="save" value="Save Profile" <?=$_SESSION['button_class']; ?>/></td>
		    		<td align="right"><input type="submit" name="back" value="Cancel" <?=$_SESSION['button_class']; ?>/></td>
	    	    </tr>
		    </table>            
		</form>   
        <?php
	}
	
	/**
	* Returns all database or request elements to place into the form
	*/
	private function _get_values($data=NULL) {
		
		if ($_SESSION['r2_id'] != "")
			$this->edit = $data->select_statement($this->db,'r2_profile','*','id='.$_SESSION['r2_id']);
		else {
			//find last id value and increment it by 1
			$profiles = $data->array_select_statement ($this->db, 'r2_profile', 'count(*)', '');
			$count = $profiles[0]['count(*)'];
			settype($count,'integer');
			$id = $count+1;
		}
			
		//Profile name textbox
		if ($_REQUEST['profile_name'] != "")
			$this->_pick['profile_name'] = $_REQUEST['profile_name'];
		elseif ($this->edit['profile_name'] != "")
			$this->_pick['profile_name'] = $this->edit['profile_name'];
		else
			$this->_pick['profile_name'] = "New_R2_Profile" . $id;	
			
		//ANI Length textbox
		if ($_REQUEST['ani_length'] != "")
			$this->_pick['ani_length'] = $_REQUEST['ani_length'];
		elseif ($this->edit['ani_length'] != "")
			$this->_pick['ani_length'] = $this->edit['ani_length'];
		else
			$this->_pick['ani_length'] = 10;	
			
		//DNIS Length textbox
		if ($_REQUEST['dnis_length'] != "")
			$this->_pick['dnis_length'] = $_REQUEST['dnis_length'];
		elseif ($this->edit['dnis_length'] != "")
			$this->_pick['dnis_length'] = $this->edit['dnis_length'];
		else
			$this->_pick['dnis_length'] = 4;							
			
		//Category Dropdown
		if ($_REQUEST['category'] == "National Subscriber")
			$this->_pick['category_National_Subscriber'] = "yes";
		elseif ($this->edit['category'] == "National Subscriber")	
			$this->_pick['category_National_Subscriber'] = "yes";
		elseif ($_REQUEST['category'] == "National Priority Subscriber")
			$this->_pick['category_National_Priority_Subscriber'] = "yes";
		elseif ($this->edit['category'] == "National Priority Subscriber")	
			$this->_pick['category_National_Priority_Subscriber'] = "yes";
		elseif ($_REQUEST['category'] == "International Subscriber")
			$this->_pick['category_International_Subscriber'] = "yes";
		elseif ($this->edit['category'] == "International Subscriber")	
			$this->_pick['category_International_Subscriber'] = "yes";
		elseif ($_REQUEST['category'] == "International Priority Subscriber")
			$this->_pick['category_International_Priority_Subscriber'] = "yes";
		elseif ($this->edit['category'] == "International Priority Subscriber")	
			$this->_pick['category_International_Priority_Subscriber'] = "yes";			
		elseif ($_REQUEST['category'] == "Collect Call")
			$this->_pick['category_Collect_Call'] = "yes";
		elseif ($this->edit['category'] == "Collect Call")	
			$this->_pick['category_Collect_Call'] = "yes";			
		elseif ($_REQUEST['category'] == "Test Equipment")
			$this->_pick['category_Test_Equipment'] = "yes";
		elseif ($this->edit['category'] == "Test Equipment")	
			$this->_pick['category_Test_Equipment'] = "yes";	
		elseif ($_REQUEST['category'] == "Pay Phone")
			$this->_pick['category_Pay_Phone'] = "yes";
		elseif ($this->edit['category'] == "Pay Phone")	
			$this->_pick['category_Pay_Phone'] = "yes";
		elseif ($_REQUEST['category'] == "Unknown")
			$this->_pick['category_Unknown'] = "yes";
		elseif ($this->edit['category'] == "Unknown")	
			$this->_pick['category_Unknown'] = "yes";	
		
		//Varient Dropdown
		if ($_REQUEST['varient'] == "ar")
			$this->_pick['varient_ar'] = "yes";
		elseif ($this->edit['varient'] == "ar")
			$this->_pick['varient_ar'] = "yes";
		elseif ($_REQUEST['varient'] == "br")
			$this->_pick['varient_br'] = "yes";
		elseif ($this->edit['varient'] == "br")
			$this->_pick['varient_br'] = "yes";
		elseif ($_REQUEST['varient'] == "cn")
			$this->_pick['varient_cn'] = "yes";
		elseif ($this->edit['varient'] == "cn")
			$this->_pick['varient_cn'] = "yes";
		elseif ($_REQUEST['varient'] == "cz")
			$this->_pick['varient_cz'] = "yes";
		elseif ($this->edit['varient'] == "cz")
			$this->_pick['varient_cz'] = "yes";		
		elseif ($_REQUEST['varient'] == "co")
			$this->_pick['varient_co'] = "yes";
		elseif ($this->edit['varient'] == "co")
			$this->_pick['varient_co'] = "yes";
		elseif ($_REQUEST['varient'] == "ec")
			$this->_pick['varient_ec'] = "yes";
		elseif ($this->edit['varient'] == "ec")
			$this->_pick['varient_ec'] = "yes";
		elseif ($_REQUEST['varient'] == "itu")
			$this->_pick['varient_itu'] = "yes";
		elseif ($this->edit['varient'] == "itu")
			$this->_pick['varient_itu'] = "yes";																		
		elseif ($_REQUEST['varient'] == "mx")
			$this->_pick['varient_mx'] = "yes";
		elseif ($this->edit['varient'] == "mx")
			$this->_pick['varient_mx'] = "yes";	
		elseif ($_REQUEST['varient'] == "ph")
			$this->_pick['varient_ph'] = "yes";
		elseif ($this->edit['varient'] == "ph")
			$this->_pick['varient_ph'] = "yes";	
		elseif ($_REQUEST['varient'] == "ve")
			$this->_pick['varient_ve'] = "yes";
		elseif ($this->edit['varient'] == "ve")
			$this->_pick['varient_ve'] = "yes";													
		
		//Collect Calls
		if ($_REQUEST['collect_calls'] == "yes")
			$this->_pick['collect_calls_yes'] = "yes";
		elseif ($this->edit['collect_calls'] == "yes")
			$this->_pick['collect_calls_yes'] = "yes";
		elseif ($_REQUEST['collect_calls'] == "no")
			$this->_pick['collect_calls_no'] = "yes";
		elseif ($this->edit['collect_calls'] == "no")
			$this->_pick['collect_calls_no'] = "yes";
		else
			$this->_pick['collect_calls_no'] = "yes";
		
		//immediate answer
		if ($_REQUEST['immediate_accept'] == "yes")
			$this->_pick['immediate_accept_yes'] = "yes";
		elseif ($this->edit['immediate_accept'] == "yes")
			$this->_pick['immediate_accept_yes'] = "yes";
		elseif ($_REQUEST['immediate_accept'] == "no")
			$this->_pick['immediate_accept_no'] = "yes";
		elseif ($this->edit['immediate_accept'] == "no")
			$this->_pick['immediate_accept_no'] = "yes";
		else
			$this->_pick['immediate_accept_no'] = "yes";		
		
		//double answer
		if ($_REQUEST['double_answer'] == "yes")
			$this->_pick['double_answer_yes'] = "yes";
		elseif ($this->edit['double_answer'] == "yes")
			$this->_pick['double_answer_yes'] = "yes";
		elseif ($_REQUEST['double_answer'] == "no")
			$this->_pick['double_answer_no'] = "yes";
		elseif ($this->edit['double_answer'] == "no")
			$this->_pick['double_answer_no'] = "yes";
		else
			$this->_pick['double_answer_no'] = "yes";	
			
		//Skip Category			
		if ($_REQUEST['skip_category'] == "yes")
			$this->_pick['skip_category_yes'] = "yes";
		elseif ($this->edit['skip_category'] == "yes")
			$this->_pick['skip_category_yes'] = "yes";
		elseif ($_REQUEST['skip_category'] == "no")
			$this->_pick['skip_category_no'] = "yes";
		elseif ($this->edit['skip_category'] == "no")
			$this->_pick['skip_category_no'] = "yes";
		else
			$this->_pick['skip_category_no'] = "yes";	
		
		//Forced Release
		if ($_REQUEST['forced_release'] == "yes")
			$this->_pick['forced_release_yes'] = "yes";
		elseif ($this->edit['forced_release'] == "yes")
			$this->_pick['forced_release_yes'] = "yes";
		elseif ($_REQUEST['forced_release'] == "no")
			$this->_pick['forced_release_no'] = "yes";
		elseif ($this->edit['forced_release'] == "no")
			$this->_pick['forced_release_no'] = "yes";
		else
			$this->_pick['forced_release_no'] = "yes";			
		
		//Charge Calls
		if ($_REQUEST['charge_calls'] == "yes")
			$this->_pick['charge_calls_yes'] = "yes";
		elseif ($this->edit['charge_calls'] == "yes")
			$this->_pick['charge_calls_yes'] = "yes";
		elseif ($_REQUEST['charge_calls'] == "no")
			$this->_pick['charge_calls_no'] = "yes";
		elseif ($this->edit['charge_calls'] == "no")
			$this->_pick['charge_calls_no'] = "yes";
		else
			$this->_pick['charge_calls_no'] = "yes";			
		
		//ani first
		if ($_REQUEST['ani_first'] == "yes")
			$this->_pick['ani_first_yes'] = "yes";
		elseif ($this->edit['ani_first'] == "yes")
			$this->_pick['ani_first_yes'] = "yes";
		elseif ($_REQUEST['ani_first'] == "no")
			$this->_pick['ani_first_no'] = "yes";
		elseif ($this->edit['ani_first'] == "no")
			$this->_pick['ani_first_no'] = "yes";
		else
			$this->_pick['ani_first_no'] = "yes";	
			
		//MF Backward timeout
		/*if ($_REQUEST['backward_timeout'] == "yes")
			$this->_pick['backward_timeout_yes'] = "yes";
		elseif ($this->edit['backward_timeout'] == "yes")
			$this->_pick['backward_timeout_yes'] = "yes";
		elseif ($_REQUEST['backward_timeout'] == "no")
			$this->_pick['backward_timeout_no'] = "yes";
		elseif ($this->edit['backward_timeout'] == "no")
			$this->_pick['backward_timeout_no'] = "yes";
		else
			$this->_pick['backward_timeout_no'] = "yes";		
		*/
		if ($_REQUEST['backward_timeout'] != "")
			$this->_pick['backward_timeout'] = $_REQUEST['backward_timeout'];
		elseif ($this->edit['backward_timeout'] != "")
			$this->_pick['backward_timeout'] = $this->edit['backward_timeout'];
		else
			$this->_pick['backward_timeout'] = 0;			
			
		//Pulse Timeout
		if ($_REQUEST['pulse_timeout'] != "")
			$this->_pick['pulse_timeout'] = $_REQUEST['pulse_timeout'];
		elseif ($this->edit['pulse_timeout'] != "")
			$this->_pick['pulse_timeout'] = $this->edit['pulse_timeout'];
		else
			$this->_pick['pulse_timeout'] = 0;			
			
		//Call Files
		if ($_REQUEST['call_files'] == "yes")
			$this->_pick['call_files_yes'] = "yes";
		elseif ($this->edit['call_files'] == "yes")
			$this->_pick['call_files_yes'] = "yes";
		elseif ($_REQUEST['call_files'] == "no")
			$this->_pick['call_files_no'] = "yes";
		elseif ($this->edit['call_files'] == "no")
			$this->_pick['call_files_no'] = "yes";
		else
			$this->_pick['call_files_no'] = "yes";					
	}
	
	/**
	* Validates the form after a post request
	* @param object $data
	* @return boolean
	*/
	public function validation($data=NULL) {
		//Validate profile name not in use anywhere
		$r2_profiles = $data->array_select_statement($this->db,'r2_profile','profile_name','');
		foreach ($r2_profiles as $profile) {
			if (trim($profile['profile_name']) == trim($_REQUEST['profile_name'])) {
				$this->error['profile_name'] = "<b>Profile Name</b> in use by a different profile";
				$error_counter++;
				break;
			}
		}
		
		//ani_length min 0 max 99
		if ($_REQUEST['ani_length'] == "") {
			$this->error['ani_length'] = "<b>ANI Length</b> MUST be entered";
			$error_counter++;
		}
		elseif ($_REQUEST['ani_length'] != "" && !is_numeric($_REQUEST['ani_length'])) {
			$this->error['ani_length'] = "<b>ANI Length</b> MUST be a numeric value";
			$error_counter++;			
		}
		elseif ($_REQUEST['ani_length'] <= 0 || $_REQUEST['ani_length'] > 99) {
			$this->error['ani_length'] = "<b>ANI Length</b> MUST be between 0 and 99";
			$error_counter++;			
		}
		
		//dnis length min 0 max 99
		if ($_REQUEST['dnis_length'] == "") {
			$this->error['dnis_length'] = "<b>DNIS Length</b> MUST be entered";
			$error_counter++;
		}
		elseif ($_REQUEST['dnis_length'] != "" && !is_numeric($_REQUEST['dnis_length'])) {
			$this->error['dnis_length'] = "<b>DNIS Length</b> MUST be a numeric value";
			$error_counter++;			
		}
		elseif ($_REQUEST['dnis_length'] <= 0 || $_REQUEST['dnis_length'] > 99) {
			$this->error['dnis_length'] = "<b>DNIS Length</b> MUST be between 0 and 99";
			$error_counter++;			
		}
				
		//pulse_timeout min 1 max 10000 allow default 0
		if ($_REQUEST['pulse_timeout'] == 0) {
		}
		elseif ($_REQUEST['pulse_timeout'] == "") {
			$this->error['pulse_timeout'] = "<b>Metering Pulse Timeout</b> MUST be entered";
			$error_counter++;
		}
		elseif ($_REQUEST['pulse_timeout'] != "" && !is_numeric($_REQUEST['pulse_timeout'])) {
			$this->error['pulse_timeout'] = "<b>Metering Pulse Timeout</b> MUST be a numeric value";
			$error_counter++;			
		}
		elseif ($_REQUEST['pulse_timeout'] <= 1 || $_REQUEST['pulse_timeout'] > 10000) {
			$this->error['pulse_timeout'] = "<b>Metering Pulse Timeout</b> MUST be between 1 and 10000 OR 0";
			$error_counter++;			
		}		

		//backward timeout min 1 max 10000 allow default 0
		if ($_REQUEST['backward_timeout'] == 0) {
		}
		elseif ($_REQUEST['backward_timeout'] == "") {
			$this->error['backward_timeout'] = "<b>MF Backward Timeout</b> MUST be entered";
			$error_counter++;
		}
		elseif ($_REQUEST['backward_timeout'] != "" && !is_numeric($_REQUEST['backward_timeout'])) {
			$this->error['backward_timeout'] = "<b>MF Backward Timeout</b> MUST be a numeric value";
			$error_counter++;			
		}
		elseif ($_REQUEST['backward_timeout'] <= 1 || $_REQUEST['backward_timeout'] > 10000) {
			$this->error['backward_timeout'] = "<b>MF Backward Timeout</b> MUST be between 1 and 10000 OR 0";
			$error_counter++;			
		}	
			
		if ($error_counter == 0)
			return true;
		else
			return false;
	}
	
}

?>