<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

	//Starts PHP Sessions
	session_start();
	
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Classes
	include '../display_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructors
	$display_common = new Display_common;	
	$data = new database_class;
	$display_pri = new view_pri_profiles;
	
	
	//Database Information
	$db_location = "sqlite:../sqlite/cardinfo.db";
				
	$num_entries = $_SESSION['num_entries'];
	
	if ($_REQUEST['create'] == "Create New Profile")
	{
		//Redirects to viewing all profiles page
		header( 'Location:../profiles/create_profile.php' ) ;		
	}
	if ($_REQUEST['back'] == "Go Back to Hardware Information")
	{
		unset ($_SESSION['last_profile']);
		//Redirects to hardware probe
		header( 'Location:../wanrouterhwprobe.php' ) ;
	}

	//Goes through the $_REQUEST hash to see which button was pressed
	foreach ($_REQUEST as $key => $value)
	{	
		for ($x = 0; $x <= $num_entries+100; $x++)
		{
			//Checks to see which Delete button was pressed
			if ($key == "delete$x" && $value == "Delete Profile")
			{
				$table_name = "t1e1_profile";
				$param = "id = $x";
				$data->delete_generic($db_location, $table_name, $param);
			}
			if ($key == "config$x" && $value == "Edit Profile")
			{
				//Takes the last value in the key to know the database ID number clicked
				$rest = substr($key, -1);
				
				//Sets the ID number into a session variable to go to the redirection and edit the file
				$_SESSION['id_num'] = $rest;
			
				//Redirects to create profiles
				header( 'Location:../profiles/create_profile.php' ) ;
			}
			
			//Clicked when user wants to use the T1/E1 Profile
			if ($key == "use$x" && $value == "Use")
			{
				//$x = the t1e1_profile line number
				$table_name =  $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				
				//Creates the permanent Database
				$perm_table_name = "perm_" . $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				
				if ($_SESSION['card_clicked'] == "B601")
				{
					//Checks which module is installed and creates the database as per that module
					if ($_SESSION['dahdi'] == "True")
					{
						$create_param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, context varchar(60), codec varchar(10), operation_mode varchar(10)";				
					}
					elseif ($_SESSION['freetdm'] == "True")
					{
						$create_param = "port_id int primary key, dev_name varchar(60), profile_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, ton_name varchar(30), ton_value varchar(30),  npi_name varchar(30), npi_value varchar(30), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), codec varchar(10), operation_mode varchar(10), overlap varchar(30)";
					}
				}
				else
				{
					//Checks which module is installed and creates the database as per that module
					if ($_SESSION['dahdi'] == "True")
					{
						$create_param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, context varchar(60)";				
					}
					elseif ($_SESSION['freetdm'] == "True")
					{
						$create_param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, ton_name varchar(30), ton_value varchar(30),  npi_name varchar(30), npi_value varchar(30), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), overlap varchar(30)";
					}
				}
				
				$port = $_SESSION['port_num_clicked'];
				
				//Hold information and insert it into the Main database
				//Check if the T1/E1 Signalling database exists
				//If it exists, insert the values in the T1/E1 Signalling Database
				$totaltables = $data->check_for_table ($db_location, $table_name);
				//echo $total_tables . "<br />";
				if ($totaltables > 1)
				{
						
					if ($_SESSION['card_clicked'] == "B601")
					{
						//Checks which module is installed and creates the database as per that module
						if ($_SESSION['dahdi'] == "True")
						{
							$insert_parameter = "port_id, dev_name, line_type, signalling , channels, group_num , context, codec , operation_mode ";
							$data->check_schema($db_location, $table_name, $create_param, "9", $insert_parameter);							
						}
						elseif ($_SESSION['freetdm'] == "True")
						{
							$insert_parameter = "port_id , dev_name , profile_name , line_type , signalling , channels , group_num , ton_name , ton_value ,  npi_name , npi_value , facility , facility_timeout , bearer_ITC , bearer_UIL , codec , operation_mode, overlap";
							$data->check_schema($db_location, $table_name, $create_param, "18", $insert_parameter);							
						}
					}
					else
					{
						//Checks which module is installed and creates the database as per that module
						if ($_SESSION['dahdi'] == "True")
						{
							$create_param = "port_id, dev_name, line_type, signalling , channels, group_num , context";				
							$data->check_schema($db_location, $table_name, $create_param, "7", $insert_param);							
						}
						elseif ($_SESSION['freetdm'] == "True")
						{
							$create_param = "port_id , dev_name , profile_name , line_type , signalling , channels , group_num , ton_name , ton_value ,  npi_name , npi_value , facility , facility_timeout , bearer_ITC , bearer_UIL, overlap";
							$data->check_schema($db_location, $table_name, $create_param, "15", $insert_param);							
						}
					}					

					//Insert
					//Check if database line exists
					$where_param = "port_id = " . $port;
					$param = "dev_name";
					$row = $data->select_statement ($db_location, $table_name, $param, $where_param);
								
					$dev = $row['dev_name'];
								
					//Check if there is a value on the return	
					if ($dev != "")
					{
						//If it exists, update the line
						//Insert the proper signalling profile into database by selecting it out of the t1e1_profile database
						$where = "id = " . $x;
						$values = $data->select_statement($db_location, "t1e1_profile", "profile_name, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap", $where);
						
						$values['ton_name'] = $values[1];
						$values['ton_value'] = $values[2];
						$values['npi_name'] = $values[3];	
						$values['npi_value'] = $values[4];
						$values['facility'] = $values[5];
						$values['facility_timeout'] = $values[6];
						$values['bearer_ITC'] = $values[7];
						$values['bearer_UIL'] = $values[8];
						$values['overlap'] = $values[9];
						
						//Update the line using the SQL Update
						if ($_SESSION['dahdi'] == "True")
						{
							$parameters = "signalling = \"" . $values['profile_name'] . "\", line_type = \"" . $_SESSION['line_type'] . "\"";
						}
						elseif ($_SESSION['freetdm'] == "True")
						{
							$parameters = "signalling = \"" . $values['profile_name'] . "\", line_type = \"" . $_SESSION['line_type'] . "\", ton_name = \"" . $values['ton_name'] . "\", ton_value = \"" . $values['ton_value'] . "\", npi_name = \"" . $values['npi_name'] . "\", npi_value = \"" . $values['npi_value'] . "\", facility = \"" . $values['facility'] . "\", facility_timeout = \"" . $values['facility_timeout'] . "\", bearer_ITC = \"" . $values['bearer_ITC'] . "\", bearer_UIL = \"" . $values['bearer_UIL'] . "\", overlap = \"" . $values['overlap'] . "\"";
						}
						$where_param = "port_id = " . $_SESSION['port_num_clicked'];
						$data->update_table($db_location, $table_name, $parameters, $where_param);
					}
					elseif ($dev == "")
					{
						//Insert the proper signalling profile into database by selecting it out of the t1e1_profile database
						$where = "id = " . $x;
						$values = $data->select_statement($db_location, "t1e1_profile", "profile_name, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap", $where);	
						
						$dev_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
						
						$values['ton_name'] = $values[1];
						$values['ton_value'] = $values[2];
						$values['npi_name'] = $values[3];	
						$values['npi_value'] = $values[4];
						$values['facility'] = $values[5];
						$values['facility_timeout'] = $values[6];
						$values['bearer_ITC'] = $values[7];
						$values['bearer_UIL'] = $values[8];	
						$values['overlap'] = $values[9];				
						
						if ($_SESSION['dahdi'] == "True")
						{
							$parameters = "port_id, dev_name, line_type, signalling";							
							$insert_values = $_SESSION['port_num_clicked'] . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\"";
						}
						elseif ($_SESSION['freetdm'] == "True")
						{
							$parameters = "port_id, dev_name, line_type, signalling, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap";							
							$insert_values = $_SESSION['port_num_clicked'] . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\", \"" . $values['ton_name'] . "\", \"" . $values['ton_value'] . "\", \"" . $values['npi_name'] . "\", \"" . $values['npi_value'] . "\", \"" . $values['facility'] . "\", \"" . $values['facility_timeout'] . "\", \"" . $values['bearer_ITC'] . "\", \"" . $values['bearer_UIL'] . "\", \"" . $values['overlap'] . "\"";							
						}
						$data->insert_statement($db_location, $table_name, $parameters, $insert_values);
					}
				}
				else
				{

					//Create
					$data->create_table($db_location, $table_name, $create_param);
					
					$result = $data->check_for_table ($db_location, $perm_table_name);

					if ($result < 2)
					{
						$data->create_table($db_location, $perm_table_name, $create_param);					
					}
					
					//Insert the proper signalling profile into database by selecting it out of the t1e1_profile database
					$where = "id = " . $x;
					$values = $data->select_statement($db_location, "t1e1_profile", "profile_name, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap", $where);	
					
					$values['ton_name'] = $values[1];
					$values['ton_value'] = $values[2];
					$values['npi_name'] = $values[3];	
					$values['npi_value'] = $values[4];
					$values['facility'] = $values[5];
					$values['facility_timeout'] = $values[6];
					$values['bearer_ITC'] = $values[7];
					$values['bearer_UIL'] = $values[8];
					$values['overlap'] = $values[9];
					
					$dev_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
					
					if ($_SESSION['dahdi'] == "True")
					{
						$parameters = "port_id, dev_name, line_type, signalling";
						$insert_values = $_SESSION['port_num_clicked'] . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\"";
					}
					elseif ($_SESSION['freetdm'] == "True")
					{
						$parameters = "port_id, dev_name, line_type, signalling, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap";
						$insert_values = $_SESSION['port_num_clicked'] . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\", \"" . $values['ton_name'] . "\", \"" . $values['ton_value'] . "\", \"" . $values['npi_name'] . "\", \"" . $values['npi_value'] . "\", \"" . $values['facility'] . "\", \"" . $values['facility_timeout'] . "\", \"" . $values['bearer_ITC'] . "\", \"" . $values['bearer_UIL'] . "\", \"" . $values['overlap'] . "\"";
					}
					
					$data->insert_statement($db_location, $table_name, $parameters, $insert_values);
				}
	
				unset ($_SESSION['last_profile']);
				
				//Check if a SS7 Signalling table exists
				//If it exists, drop the table so that it will not conflict with PRI configuration
				$ss7_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
				$table_exists = $data->check_for_table ($db_location, $ss7_table);
		
				if ($table_exists > 1)
				{
					//remove the line out of the table
					//$data->drop_table($ss7_link->db_location, $pri_table);
					$parameters = "port_id = " . $_SESSION['port_num_clicked'];
					
					$data->delete_generic($db_location,$ss7_table, $parameters);
				}
				
				//Redirects to hardware probe
				header( 'Location:../wanrouterhwprobe.php' ) ;	
			}	
			
			//Configure all ports that have hardware configuration
			if ($key == "use-all-$x" && $value == "Use for all Ports")
			{
				//Database Information
				$db_location = "sqlite:../sqlite/cardinfo.db";
				
				//Creates the permanent Database
				$perm_table_name = "perm_" . $table_name;
				
				//Configure all the unconfigured ports on that board (physical layer)
				//Find total number of ports on card
				$table = 'card_present';
				$param = 'num_ports';
				$where = 'id='.$_SESSION['card_num'];
				
				$num_ports = $data->select_statement($db_location,$table,$param,$where);
				$current = $data->select_statement($db_location,$_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'],'*','port_id='.$_SESSION['port_num_clicked']);
				for ($a=1;$a<=$num_ports['num_ports'];$a++) {
					$physical = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
					$where_param = "port_id = " . $a;
					$result = $data->select_statement ($db_location, $physical, "port_id", $where_param);
					
					//Configure Port with the exact same values as the port being used
					if ($result['port_id'] == "")
					{
						$where = "port_id = " . $_SESSION['port_num_clicked'];
						$current = $data->select_statement($db_location,$physical,"*",$where);
						
						$insert_parameters = "port_id, dev_name, line_type, coding, framing, clock, ref_clock, echo, dtmf, fax, lbo, txtristate, sigmode, impedence, rx_level, rxgain, txgain, dtmf_removal, pre_buffer_size";	
						$insert_value = $a . ", \"" . $current['dev_name'] . "\", \"" . $current['line_type'] . "\", \"" .$current['coding'] . "\", \"" . $current['framing'] . "\", \"" . $current['clock'] . "\",\"" . $current['ref_clock'] . "\", \"" .$current['echo']. "\", \"" . $current['dtmf'] . "\", \"" . $current['fax'] . "\", \"" . $current['lbo'] . "\", \"" . $current['txtristate'] . "\", \"" . $current['sigmode'] . "\", \"" . $current['impedence'] . "\", \"" . $current['rx_level'] . "\", \"" . $current['rxgain'] . "\", \"" . $current['txgain'] . "\", \"" . $current['dtmf_removal'] . "\", \"" . $current['pre_buffer_size'] . "\"";
						
						$data->insert_statement($db_location, $physical, $insert_parameters, $insert_value);	
					}
				}
				
				//Check the hardware table of that card for all the configured ports
				//select id from card_cardnum;
				
				$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
	
				$select = "SELECT port_id, line_type FROM " . $table_name . ";";
				$a = 0;
	
				try
				{
					//open the database
					$db = new PDO($db_location);

					$result = $db->query($select);
					
				    foreach($result as $row)
				    {
						$array[$a] = $row['port_id'];
						$line[$a] = $row['line_type'];
						$a++;
					}
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					print 'Exception : '.$e->getMessage();
				}	
								
				//Checks which module is installed and creates the database as per that module
				if ($_SESSION['dahdi'] == "True")
					$create_param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, context varchar(60)";				
				elseif ($_SESSION['freetdm'] == "True")
					$create_param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), signalling varchar(60), channels varchar(60), group_num int, ton_name varchar(30), ton_value varchar(30),  npi_name varchar(30), npi_value varchar(30), facility varchar(10), facility_timeout int, bearer_ITC varchar(30), bearer_UIL varchar(30), overlap varchar(30)";

				$table_name =  $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_signalling";
				for ($b = 0; $b < $a; $b++)
				{
					$dev = "";
					$port = $array[$b];
					$t1_e1 = $line[$b];

					//Check if port has any other config. if it does, skip over the configuration.
					$skip = false;
					
					$m2ua = $data->select_statement($db_location,$_SESSION['card_clicked'].'_'.$_SESSION['card_num'].'_m2ua_link','link_name','port_id='.$port);
					$mg = $data->select_statement($db_location,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_m2ua_channels",'profile_name','port_id='.$port);
					$ss7_link = $data->select_statement($db_location,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_SS7_link","link_name",'port_id='.$port);
					$r2 = $data->select_statement($db_location,$_SESSION['card_clicked'] . "_" . $_SESSION['card_num'] . "_r2_signalling",'r2_profile','port_id='.$port);
					
					if ($ss7_link['link_name'] != "")
						$skip = true;
					elseif($mg['profile_name'] != "")
						$skip = true;
					elseif ($m2ua['link_name'] != "")
						$skip = true;
					elseif ($r2['r2_profile'] != "")
						$skip = true;
					
					//echo "Port = " . $port . " Skip = " . $skip . "<br />";
					
					//Port empty, configure port							
					if (!$skip) {
						if ($t1_e1 == $_SESSION['line_type'])
						{
							//Hold information and insert it into the Main database
							//Check if the T1/E1 Signalling database exists
							//If it exists, insert the values in the T1/E1 Signalling Database
							$totaltables = $data->check_for_table ($db_location, $table_name);
							
							if ($totaltables > 1)
							{
								if ($_SESSION['card_clicked'] == "B601")
								{
									//Checks which module is installed and creates the database as per that module
									if ($_SESSION['dahdi'] == "True")
									{
										$insert_parameter = "port_id, dev_name, line_type, signalling , channels, group_num , context, codec , operation_mode ";
										$data->check_schema($db_location, $table_name, $create_param, "9", $insert_parameter);							
									}
									elseif ($_SESSION['freetdm'] == "True")
									{
										$insert_parameter = "port_id , dev_name , profile_name , line_type , signalling , channels , group_num , ton_name , ton_value ,  npi_name , npi_value , facility , facility_timeout , bearer_ITC , bearer_UIL , codec , operation_mode, overlap";
										$data->check_schema($db_location, $table_name, $create_param, "18", $insert_parameter);							
									}
								}
								else
								{
									//Checks which module is installed and creates the database as per that module
									if ($_SESSION['dahdi'] == "True")
									{
										$insert_parameter = "port_id, dev_name, line_type, signalling , channels, group_num , context";				
										$data->check_schema($db_location, $table_name, $create_param, "7", $insert_parameter);							
									}
									elseif ($_SESSION['freetdm'] == "True")
									{
										$insert_parameter = "port_id , dev_name , profile_name , line_type , signalling , channels , group_num , ton_name , ton_value ,  npi_name , npi_value , facility , facility_timeout , bearer_ITC , bearer_UIL, overlap";
										$data->check_schema($db_location, $table_name, $create_param, "15", $insert_parameter);							
									}
								}					
								
								//Insert
								//Check if database line exists
								
								$where_param = "port_id = " . $port;
								$param = "dev_name";
								$row = $data->select_statement ($db_location, $table_name, $param, $where_param);
								
								$dev = $row['dev_name'];
								//echo "Deveice = $dev <br />";
								//Check if there is a value on the return	
								if ($dev != "")
								{
									//If it exists, update the line
									//Insert the proper signalling profile into database by selecting it out of the t1e1_profile database
									$where = "id = " . $x;
								
									//Update the line using the SQL Update
									if ($_SESSION['dahdi'] == "True")
									{
										$values = $data->select_statement($db_location, "t1e1_profile", "profile_name", $where);								
										$parameters = "signalling = \"" . $values['profile_name'] . "\", line_type = \"" . $_SESSION['line_type'] . "\"";
									}
									elseif ($_SESSION['freetdm'] == "True")
									{
										$values = $data->select_statement($db_location, "t1e1_profile","profile_name, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap", $where);
										
										$values['ton_name'] = $values[1];
										$values['ton_value'] = $values[2];
										$values['npi_name'] = $values[3];	
										$values['npi_value'] = $values[4];
										$values['facility'] = $values[5];
										$values['facility_timeout'] = $values[6];
										$values['bearer_ITC'] = $values[7];
										$values['bearer_UIL'] = $values[8];
										$values['overlap'] = $values[9];
							
										$parameters = "signalling = \"" . $values['profile_name'] . "\", line_type = \"" . $_SESSION['line_type'] . "\", ton_name = \"" . $values['ton_name'] . "\", ton_value = \"" . $values['ton_value'] . "\", npi_name = \"" . $values['npi_name'] . "\", npi_value = \"" . $values['npi_value'] . "\", facility = \"" . $values['facility'] . "\", facility_timeout = \"" . $values['facility_timeout'] . "\", bearer_ITC = \"" . $values['bearer_ITC'] . "\", bearer_UIL = \"" . $values['bearer_UIL'] . "\", overlap = \"" . $values['overlap'] . "\"";
									}
									$where_param = "port_id = " . $port;
									$data->update_table($db_location, $table_name, $parameters, $where_param);
								}
								elseif ($dev == "")
								{
									//Insert the proper signalling profile into database by selecting it out of the t1e1_profile database
									$where = "id = " . $x;
									$values = $data->select_statement($db_location, "t1e1_profile", "profile_name, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap", $where);
									
									$values['ton_name'] = $values[1];
									$values['ton_value'] = $values[2];
									$values['npi_name'] = $values[3];	
									$values['npi_value'] = $values[4];
									$values['facility'] = $values[5];
									$values['facility_timeout'] = $values[6];
									$values['bearer_ITC'] = $values[7];
									$values['bearer_UIL'] = $values[8];
									$values['overlap'] = $values[9];
									
									$dev_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
										
									if ($_SESSION['dahdi'] == "True")
									{
										$insert_values = $port . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\"";
										$parameters = "port_id, dev_name, line_type, signalling";
									}
									elseif ($_SESSION['freetdm'] == "True")
									{
										$parameters = "port_id, dev_name, line_type, signalling, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap";
										$insert_values = $port . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\",\"" . $values['ton_name'] . "\", \"" . $values['ton_value'] . "\",\"" . $values['npi_name'] . "\", \"" . $values['npi_value'] . "\", \"" . $values['facility'] . "\", \"" . $values['facility_timeout'] . "\", \"" . $values['bearer_ITC'] . "\", \"" . $values['bearer_UIL'] . "\", \"" . $values['overlap'] . "\"";
									}
									$data->insert_statement($db_location, $table_name, $parameters, $insert_values);
								}
							}
							elseif ($totaltables < 2)
							{
								//echo "i am here";
								//Create
								$data->create_table($db_location, $table_name, $create_param);
							
								$result = $data->check_for_table ($db_location, $perm_table_name);
							
								if ($result < 1)
									$data->create_table($db_location, $perm_table_name, $create_param);					
						
								//Insert the proper signalling profile into database by selecting it out of the t1e1_profile database
								$where = "id = " . $x;
								$dev_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
									
								if ($_SESSION['dahdi'] == "True")
								{
									$values = $data->select_statement($db_location, "t1e1_profile", "profile_name", $where);					
										
									$parameters = "port_id, dev_name, line_type, signalling";
									$insert_values = $port . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\"";
								}
								elseif ($_SESSION['freetdm'] == "True")
								{
									$values = $data->select_statement($db_location, "t1e1_profile", "profile_name, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap", $where);			
									
									$values['ton_name'] = $values[1];
									$values['ton_value'] = $values[2];
									$values['npi_name'] = $values[3];	
									$values['npi_value'] = $values[4];
									$values['facility'] = $values[5];
									$values['facility_timeout'] = $values[6];
									$values['bearer_ITC'] = $values[7];
									$values['bearer_UIL'] = $values[8];
									$values['overlap'] = $values[9];
								
									$parameters = "port_id, dev_name, line_type, signalling, ton_name, ton_value, npi_name, npi_value, facility, facility_timeout, bearer_ITC, bearer_UIL, overlap";
									$insert_values = $port . ", \"" .  $dev_name . "\", \"" . $_SESSION['line_type'] . "\", \"" . $values['profile_name'] . "\",\"" . $values['ton_name'] . "\",\"" . $values['ton_value'] . "\", \"" . $values['npi_name'] . "\", \"" . $values['npi_value'] . "\", \"" . $values['facility'] . "\", \"" . $values['facility_timeout'] . "\", \"" . $values['bearer_ITC'] . "\", \"" . $values['bearer_UIL'] . "\", \"" . $values['overlap'] . "\"";
								}
								
								$data->insert_statement($db_location, $table_name, $parameters, $insert_values);
							}	
						}
					}
				}
				
				//Check if a SS7 Signalling table exists
				//If it exists, drop the table so that it will not conflict with PRI configuration
				/*$ss7_table = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'] . "_SS7_link";
				$table_exists = $data->check_for_table ($db_location, $ss7_table);
		
				if ($table_exists > 1)
					$data->drop_table($db_location, $ss7_table);
				*/
				
				unset ($_SESSION['last_profile']);
				//Redirects to hardware probe
				header( 'Location:../wanrouterhwprobe.php' ) ;				
			}						
		}
	}

	$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
	$where_param = " port_id = " . $_SESSION['port_num_clicked'];
	$row = $data->select_statement ("sqlite:../sqlite/cardinfo.db", $table_name, "line_type", $where_param);
	
	//Stores the line type in a session variable
	$_SESSION['line_type'] = $row['line_type'];	
		
	$profile_array = $data->get_profiles("*");
	$a = $_SESSION['counter'];
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("View T1/E1 Profiles", "../../../style.css");		
	}	
	
	//Displays PRI Profiles Page<br />
	$display_pri->data = $data;
	$display_pri->db = $db_location;
	$display_pri->display_profiles($profile_array, $a);
		
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}

}
else
{
	header( 'Location:../index.php' ) ;
}
?>