<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

	//Starts PHP Session
	session_start();

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Includes
	include 'create_bri_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$bri_config = new create_bri_profile;
	
	$db_location = "sqlite:../sqlite/cardinfo.db";

	//If statement that controls the HTML Title & gets the information out of the database if you are performing editing.
	if ($_SESSION['id_num'] == "") 
	{ 
		$title = $_SESSION['line_type'] . " Profile Creation"; 
	} 
	else 
	{ 
		$title = "Edit Profile"; 
		//echo "id = " . $_SESSION['id_num'] . "<br />";
		$id = $_SESSION['id_num'];
		
		//Pull the information out of the database and save it in the class variable "edit"
		$bri_config->edit = $data->select_statement($db_location, "bri_profile", "*", "id = $id");
	}	

	
	if ($_REQUEST['create'] == "Create Profile" || $_REQUEST['create'] == "Save Profile")
	{
		//Runs the validation script
		$bri_config->validation();
		
		if ($_SESSION['interface'] == "TE")
		{
			if ($_REQUEST['msn1'] != "" || $_REQUEST['msn2'] != "" || $_REQUEST['msn3'] != "" || $_REQUEST['msn4'] != "" || $_REQUEST['msn5'] != "" || $_REQUEST['msn6'] != "" || $_REQUEST['msn7'] != "" || $_REQUEST['msn8'] != "")
			{
				$msn = $bri_config->combine_msn();
				//echo $msn . "<br />";
			}
		}
		
		if ($_REQUEST['ton_value1'] != "")
		{
			$_REQUEST['ton_name1'] = "outbound-called-ton";
		}
		if ($_REQUEST['ton_value2'] != "")
		{
			$_REQUEST['ton_name2'] = "outbound-calling-ton";
		}
		if ($_REQUEST['ton_value3'] != "")
		{
			$_REQUEST['ton_name3'] = "outbound-rdnis-ton";
		}
		
		if ($_REQUEST['npi_value1'] != "")
		{
			$_REQUEST['npi_name1'] = "outbound-called-npi";
		}
		if ($_REQUEST['npi_value2'] != "")
		{
			$_REQUEST['npi_name2'] = "outbound-calling-npi";
		}
		if ($_REQUEST['npi_value3'] != "")
		{
			$_REQUEST['npi_name3'] = "outbound-rdnis-npi";
		}
		
		
		if ($_REQUEST['ton_name1'] != "" || $_REQUEST['ton_name2'] != "" || $_REQUEST['ton_name3'] != "")
		{
			$ton_name = $bri_config->combine_ton_name();
		}
		else
		{
			$ton_name = "";
		}
		if ($_REQUEST['ton_value1'] != "" || $_REQUEST['ton_value2'] != "" || $_REQUEST['ton_value3'] != "")
		{
			$ton_value = $bri_config->combine_ton_value();
		}
		else
		{
			$ton_value = "";
		}
		if ($_REQUEST['npi_name1'] != "" || $_REQUEST['npi_name2'] != "" || $_REQUEST['npi_name3'] != "")
		{
			$npi_name = $bri_config->combine_npi_name();
		}
		else
		{
			$npi_name = "";
		}
		if ($_REQUEST['npi_value1'] != "" || $_REQUEST['npi_value2'] != "" || $_REQUEST['npi_value3'] != "")
		{
			$npi_value = $bri_config->combine_npi_value();
		}
		else
		{
			$npi_value = "";
		}
		
		if ($_SESSION['interface'] == "NT") 
		{ 
			$sig_type = "NET"; 
		} 
		elseif ($_SESSION['interface'] == "TE") 
		{ 
			$sig_type = "CPE"; 
		}
		
		//If there are no errors, place in the database
		if ($bri_config->error_counter == 0)
		{
			$_SESSION['last_profile'] = $_REQUEST['profile_name'];
			$_SESSION['profile_bri_num'] = $_REQUEST['id_number'];
			
			//Check if it is a the profile is in the database
			if ($_SESSION['id_num'] != "")
			{
				$exist = $data->select_statement($db_location, "bri_profile", "profile_name", "id = $id");
			}
			$id = $data->select_statement($db_location, "bri_profile", "id", "");
			
			$id[0]++;
			
			if ($exist['profile_name'] == "")
			{
				//Line doesn't exist, insert it
				$insert_param = "id, profile_name, conn_type, sig_type, interface, switchtype, tei, bearer_ITC, bearer_UIL, ton_name, ton_value, npi_name, npi_value, msn, overlap, min_digits";
				$insert_values = "$id[0], \"" . $_REQUEST['profile_name'] . "\", \"" . $_SESSION['interface'] . "\", \"" . $sig_type . "\", \"" . $_REQUEST['interface'] . "\", \"" . $_REQUEST['switchtype'] . "\", \"" . $_REQUEST['tei'] . "\", \"" . $_REQUEST['bearer_ITC'] . "\", \"" . $_REQUEST['bearer_UIL'] . "\", \"" . $ton_name . "\", \"" . $ton_value . "\", \"" . $npi_name . "\", \"" . $npi_value . "\", \"" . $msn . "\" , \"" . $_REQUEST['overlap'] . "\", \"" . $_REQUEST['min_digits'] . "\"";
				
				$data->insert_statement($db_location, "bri_profile", $insert_param, $insert_values);
			}
			elseif ($exist['profile_name'] != "")
			{
				//Line exists, update it
				$update_param = "profile_name = \"" . $_REQUEST['profile_name'] . "\", conn_type = \"" . $_SESSION['interface'] . "\", sig_type = \"" . $sig_type . "\", interface = \"" . $_REQUEST['interface'] . "\", switchtype = \"" . $_REQUEST['switchtype'] . "\", tei = \"" . $_REQUEST['tei'] . "\", bearer_ITC = \"" . $_REQUEST['bearer_ITC'] . "\", bearer_UIL = \"" . $_REQUEST['bearer_UIL'] . "\", ton_name = \"" . $ton_name . "\", ton_value = \"" . $ton_value . "\", npi_name = \"" . $npi_name . "\", npi_value = \"" . $npi_value . "\", msn = \"" . $msn . "\", overlap = \"" . $_REQUEST['overlap'] . "\", min_digits = \"". $_REQUEST['min_digits'] . "\"";

				$where_param = "id = " . $_SESSION['id_num'];
				
				$data->update_table($db_location, "bri_profile", $update_param, $where_param);
			}
			
			//$_SESSION['profile_num']--;
			
			header( 'Location: view_bri_profiles.php' ) ;
		}
	}
	if ($_REQUEST['cancel'] == "Cancel Profile Creation" || $_REQUEST['cancel'] == "Cancel Profile Editing")
	{
		$_SESSION['id_num'] = "";
		
		//$_SESSION['profile_num'] = $_SESSION['profile_num'] - 2;
		
		//Redirects to viewing all profiles page
		header( 'Location:view_bri_profiles.php' ) ;			
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		//include 'database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
		
		if ($_SESSION['id_num'] == "") 
		{ 
			$title = "BRI Profile Creation - " . $_SESSION['interface'] . "";		
		} 
		else 
		{ 
			$title = "BRI Profile Editing - " . $_SESSION['interface'] . ""; 
		} 
				
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title($title, "../../../style.css");		
	}
	
	//BRI Profile main page
	$bri_config->display();	
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>