<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class create_bri_profile
{
	
	private $error= "";				//Contains validation errors
	public $error_counter="";		//Contains the number of errors in the form
	public $edit="";				//Contains database returned values for editing
	private $interface="";			//Contains the Interface
	public $profile_name = array();	//Contains the profile names within the database
	public $profile_counter = "";	//Contains the number of profiles in the database
	private $pick="";				//Contains the data for what was returned to the form
	
	//Display function
	function display()
	{
		$this->tokenize_values();

		if ($_SESSION['id_num'] == "") 
		{ 
			echo "<h3>BRI Profile Creation - " . $_SESSION['interface'] . "</h3>";		
		} 
		else 
		{ 
			echo "<h3>BRI Profile Editing - " . $_SESSION['interface'] . "</h3>"; 
		} 
		
		if ($_SESSION['interface'] == "NT")
		{
			$this->line_mode = "NT";
		}
		elseif ($_SESSION['interface'] == "TE")
		{
			$this->line_mode = "TE";
		}
		
		if ($_SESSION['profile_bri_num'] == "")
		{
			$a = 1;
			//$_SESSION['profile_num'] = $a;
		}
		elseif ($_SESSION['profile_bri_num'] != "")
		{
			$a = $_SESSION['profile_bri_num'];
			$a++;
			//$_SESSION['profile_num'] = $a;
		}
		
		$this->check_submit();
		
		?>
	<p>
    	Please enter the Signalling Level configuration in order to generate a valid BRI Profile.<br />
        Advanced options are available for your BRI Profile. They are populated with their default values, but you may change them if required.
    </p>	
	<form name="create_profile" method="post">
		<hr style='width:700px;' align='left'/>    		
        <input type="hidden" name="id_number" value="<?php echo $a; ?>" />
       <h4>Standard Options</h4>    
		<table>
			<tr>
				<td>Profile Name</td>
				<td align="right"><input type="text" name="profile_name" style="text-align:right" value="<?php if ($this->edit['profile_name'] != "") { echo $this->edit['profile_name']; } elseif($_REQUEST['profile_name'] == "") { echo "New BRI Profile$a"; } else { echo $_REQUEST['profile_name']; } ?>" /></td>
				<td><?php echo $this->error['profile_name']; ?></td>
			</tr>
			<tr>
				<td>Line Mode</td>        
				<td align="right"><font color="#666666"><strong><?php echo $this->line_mode; ?></strong></font></td>
			</tr>            
			<tr>
				<td>Signalling Type</td>                                        
				<td align="right"><font color="#666666"><?php if ($this->line_mode == "NT") { echo "NET"; } elseif ($this->line_mode == "TE") { echo "CPE"; } ?><strong></strong></font></td>
			</tr>            
			<tr>
				<td>Interface</td>
				<td align="right">
                	<select name="interface" style="text-align:right">
                    	<option value="" style="text-align:right">Please Select a Interface</option>
                    	<option value="ptmp" <?php if ($this->pick['interface_ptmp'] == "yes") { ?> selected=selected <?php }  ?> style="text-align:right">Point to MultiPoint</option>
                        <option value="ptp" <?php if ($this->pick['interface_ptp'] == "yes") { ?> selected=selected <?php } ?> style="text-align:right">Point to Point</option>
                    </select>
				</td>
				<td><?php echo $this->error['interface']; ?></td>                                        
			</tr>            
			<tr>
				<td>Switchtype</td>
				<td align="right">
					<select name="switchtype" style="text-align:right">
                    	<option value="" style="text-align:right">Please Select a Switchtype</option>
						<option value="EuroISDN" <?php if ($this->pick['switchtype_euroisdn'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">EuroISDN</option>
                        <?php /*<option value="etsi" <?php if ($this->pick['switchtype_etsi'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">ETSI</option>*/ ?>
                        <?php if ($_SESSION['freetdm'])
						{?>
            			<option value="insnet" <?php if ($this->pick['switchtype_insnet'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">INS-NET</option>
                        <?php
						}?>
                    </select>
				</td>
                <td><?php echo $this->error['switchtype'];?></td>
			</tr>
       </table>
            <?php 
			//Displays the following information only if SMG/FreeTDM is installed
			if ($_SESSION['freetdm'] == "True")
			{
			?>       
       <br />
	   <hr style='width:700px;' align='left'/> 
            <div class="fakelink"
                    id="show_e"
                    onclick="this.style.display='none';
                    document.getElementById('hide_e').style.display='block';
                    document.getElementById('options').style.display='inline';
                    ">&raquo; Show Advanced Options</div>
            <div class="fakelink"
                    id="hide_e"
                    onclick="this.style.display='none';
                    document.getElementById('show_e').style.display='block';
                    document.getElementById('options').style.display='none';
                    ">&raquo; Hide Advanced Options</div>
            <div id="options">          		
		<br />
       <font color="red">NOTE: These options are set to their default parameters and shouldn't be changed unless required.</font>
       <table> 
       		<tr>
            	<td>Minimum Digits</td>
                <td align="right"><input type="text" name="min_digits" style="width:50px; text-align:right" <?php if ($this->edit['min_digits'] != "") { echo "value=\"" . $this->edit['min_digits'] . "\""; } elseif( $_REQUEST['min_digits'] == "" ) { echo "value=\"\""; } elseif ($_REQUEST['min_digits'] != "") { echo "value=\"" . $_REQUEST['min_digits'] . "\""; } ?> />
                <td><?php echo $this->error['min_digits']; ?></td>
            </tr>    
            <tr>
            	<td>TEI</td>
                <td align="right"><input type="text" name="tei" style="width:50px; text-align:right" <?php if ($this->edit['tei'] != "") { echo "value=\"" . $this->edit['tei'] . "\""; } elseif( $_REQUEST['tei'] == "" ) { echo "value=\"\""; } elseif ($_REQUEST['tei'] != "") { echo "value=\"" . $_REQUEST['tei'] . "\""; } ?> />
                <td><?php echo $this->error['tei']; ?></td>
            </tr> 
            <tr>
            	<td>Overlap Dialing</td>
                <td align="right">
                	<select name="overlap" style="text-align:right">
                    	<option value="enable" <?php if ($this->pick['overlap_enable'] =="yes") { echo "selected=selected"; } ?> style="text-align:right">Enabled</option>
                        <option value="disable" <?php if ($this->pick['overlap_disable'] =="yes") { echo "selected=selected"; } ?> style="text-align:right">Disabled</option>
                    </select>
                </td>
            </tr>
        </table>
        <br />
        Bearer Capability<br />
        <font color="red"><i>Note:Used only when the Bearer Capability is <b>not available</b></i></font>
        <table>    
            <tr>
            	<td>Information Transfer Capability</td>
                <td align="right">
                	<select name="bearer_ITC" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                    	<option value="speech" <?php if ($this->pick['bearer_ITC_speech'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">Speech</option>
                        <option value="unrestricted-digital" <?php if ($this->pick['bearer_ITC_ud'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Unrestricted Digital</option>
                        <option value="3.1khz" <?php if ($this->pick['bearer_ITC_31khz'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">3.1 KHz</option>
                    </select>
                </td>
            </tr>                
            <tr>
            	<td>User Information layer 1 Protocol</td>
                <td align="right">
                	<select name="bearer_UIL" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                    	<option value="v110" <?php if ($this->pick['bearer_UIL_v110'] == "yes" ) { ?> selected=selected <?php }?> style="text-align:right">V.110</option>
                        <option value="ulaw" <?php if ($this->pick['bearer_UIL_ulaw'] == "yes" ) { ?> selected=selected <?php }?> style="text-align:right">uLaw</option>
                        <option value="alaw" <?php if ($this->pick['bearer_UIL_alaw'] == "yes" ) { ?> selected=selected <?php }?> style="text-align:right">aLaw</option>
                    </select>
                </td>
            </tr>
         </table>
         <br />
         Type of Number (TON)
         <table>      
			<tr>    
				<td>Outbound Called TON</td>        
                <td align="right">
                	<select name="ton_value1" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                        <option value="international" <?php if ($this->pick['ton_value1_international'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">International</option>
                        <option value="national" <?php if ($this->pick['ton_value1_national'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">National</option>
                        <option value="local" <?php if ($this->pick['ton_value1_local'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">Local</option>
                    </select>
                </td>
				<td><?php if ($this->error['ton_name1'] == "") { echo $this->error['ton_value1']; } elseif ($this->error['ton_value1'] == "") { echo $this->error['ton_name1']; } ?></td>
			</tr>
			<tr>    
				<td>Outbound Calling TON</td>        
                <td align="right">
                	<select name="ton_value2" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                        <option value="international" <?php if ($this->pick['ton_value2_international'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">International</option>
                        <option value="national" <?php if ($this->pick['ton_value2_national'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">National</option>
                        <option value="local" <?php if ($this->pick['ton_value2_local'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">Local</option>
                    </select>
                </td>
				<td><?php if ($this->error['ton_name2'] == "") { echo $this->error['ton_value2']; } elseif ($this->error['ton_value2'] == "") { echo $this->error['ton_name2']; } ?></td>
			</tr>
			<tr>    
				<td>Outbound Redirecting TON</td>        
                <td align="right">
                	<select name="ton_value3" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                        <option value="international" <?php if ($this->pick['ton_value3_international'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">International</option>
                        <option value="national" <?php if ($this->pick['ton_value3_national'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">National</option>
                        <option value="local" <?php if ($this->pick['ton_value3_local'] == "yes") { ?> selected="selected" <?php }?> style="text-align:right">Local</option>
                    </select>
                </td>
				<td><?php if ($this->error['ton_name3'] == "") { echo $this->error['ton_value3']; } elseif ($this->error['ton_value3'] == "") { echo $this->error['ton_name3']; } ?></td>
			</tr>                        
        </table> 
        <br />
        Numbering Plan Identification (NPI)
        <table>   
			<tr>
				<td>Outbound Called NPI</td>
                <td align="right">
                	<select name="npi_value1" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                        <option value="isdn" <?php if ($this->pick['npi_value1_isdn'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">ISDN</option>
                        <option value="e164" <?php if ($this->pick['npi_value1_e164'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">E.164</option>
                        <option value="data" <?php if ($this->pick['npi_value1_data'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Data</option>
                        <option value="telex" <?php if ($this->pick['npi_value1_telex'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Telex</option>
                        <option value="national" <?php if ($this->pick['npi_value1_national'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">National</option>
                        <option value="private" <?php if ($this->pick['npi_value1_private'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Private</option>
                        <option value="reserved" <?php if ($this->pick['npi_value1_reserved'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Reserved</option>
                    </select>
                </td>   
				<td><?php if ($this->error['npi_name1'] == "") { echo $this->error['npi_value1']; } elseif ($this->error['npi_value1'] == "") { echo $this->error['npi_name1']; } ?></td>
            </tr> 
			<tr>
				<td>Outbound Calling NPI</td>
                <td align="right">
                	<select name="npi_value2" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                        <option value="isdn" <?php if ($this->pick['npi_value2_isdn'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">ISDN</option>
                        <option value="e164" <?php if ($this->pick['npi_value2_e164'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">E.164</option>
                        <option value="data" <?php if ($this->pick['npi_value2_data'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Data</option>
                        <option value="telex" <?php if ($this->pick['npi_value2_telex'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Telex</option>
                        <option value="national" <?php if ($this->pick['npi_value2_national'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">National</option>
                        <option value="private" <?php if ($this->pick['npi_value2_private'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Private</option>
                        <option value="reserved" <?php if ($this->pick['npi_value2_reserved'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Reserved</option>
                    </select>
                </td>   
				<td><?php if ($this->error['npi_name2'] == "") { echo $this->error['npi_value2']; } elseif ($this->error['npi_value2'] == "") { echo $this->error['npi_name2']; } ?></td>
            </tr> 
			<tr>
				<td>Outbound Redirecting NPI</td>
                <td align="right">
                	<select name="npi_value3" style="text-align:right">
                    	<option value="" style="text-align:right">Default</option>
                        <option value="isdn" <?php if ($this->pick['npi_value3_isdn'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">ISDN</option>
                        <option value="e164" <?php if ($this->pick['npi_value3_e164'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">E.164</option>
                        <option value="data" <?php if ($this->pick['npi_value3_data'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Data</option>
                        <option value="telex" <?php if ($this->pick['npi_value3_telex'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Telex</option>
                        <option value="national" <?php if ($this->pick['npi_value3_national'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">National</option>
                        <option value="private" <?php if ($this->pick['npi_value3_private'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Private</option>
                        <option value="reserved" <?php if ($this->pick['npi_value3_reserved'] == "yes") { ?> selected="selected" <?php } ?> style="text-align:right">Reserved</option>
                    </select>
                </td>   
				<td><?php if ($this->error['npi_name3'] == "") { echo $this->error['npi_value3']; } elseif ($this->error['npi_value3'] == "") { echo $this->error['npi_name3']; } ?></td>
            </tr>                         
		</table>
        <?php
		if ($this->line_mode == "TE")
		{
		?>
		<br />
        Multiple Subscriber Number (MSN)
		<table>            
            <tr>
            	<td>MSN 1:</td>
                <td><input type="text" name="msn1" style="width:100px; text-align:right" <?php if ($this->edit['msn1'] != "") { echo "value=\"" . $this->edit['msn1'] . "\""; } elseif ($_REQUEST['msn1'] != "") { echo "value=\"" . $_REQUEST['msn1'] . "\""; } ?> />
                <td><?php echo $this->error['msn1']; ?></td>
            </tr>
            <tr>
            	<td>MSN 2:</td>
                <td><input type="text" name="msn2" style="width:100px; text-align:right" <?php if ($this->edit['msn2'] != "") { echo "value=\"" . $this->edit['msn2'] . "\""; } elseif ($_REQUEST['msn2'] != "") { echo "value=\"" . $_REQUEST['msn2'] . "\""; } ?> />
                <td><?php echo $this->error['msn2']; ?></td>
            </tr>
            <tr>
            	<td>MSN 3:</td>
                <td><input type="text" name="msn3" style="width:100px; text-align:right" <?php if ($this->edit['msn3'] != "") { echo "value=\"" . $this->edit['msn3'] . "\""; } elseif ($_REQUEST['msn3'] != "") { echo "value=\"" . $_REQUEST['msn3'] . "\""; } ?> />
                <td><?php echo $this->error['msn3']; ?></td>
            </tr>                        
            <tr>
            	<td>MSN 4:</td>
                <td><input type="text" name="msn4" style="width:100px; text-align:right" <?php if ($this->edit['msn4'] != "") { echo "value=\"" . $this->edit['msn4'] . "\""; } elseif ($_REQUEST['msn4'] != "") { echo "value=\"" . $_REQUEST['msn4'] . "\""; } ?> />
                <td><?php echo $this->error['msn4']; ?></td>
            </tr>
            <tr>
            	<td>MSN 5:</td>
                <td><input type="text" name="msn5" style="width:100px; text-align:right" <?php if ($this->edit['msn5'] != "") { echo "value=\"" . $this->edit['msn5'] . "\""; } elseif ($_REQUEST['msn5'] != "") { echo "value=\"" . $_REQUEST['msn5'] . "\""; } ?> />
                <td><?php echo $this->error['msn5']; ?></td>
            </tr>
            <tr>
            	<td>MSN 6:</td>
                <td><input type="text" name="msn6" style="width:100px; text-align:right" <?php if ($this->edit['msn6'] != "") { echo "value=\"" . $this->edit['msn6'] . "\""; } elseif ($_REQUEST['msn6'] != "") { echo "value=\"" . $_REQUEST['msn6'] . "\""; } ?> />
                <td><?php echo $this->error['msn6']; ?></td>
            </tr>
            <tr>
            	<td>MSN 7:</td>
                <td><input type="text" name="msn7" style="width:100px; text-align:right" <?php if ($this->edit['msn7'] != "") { echo "value=\"" . $this->edit['msn7'] . "\""; } elseif ($_REQUEST['msn7'] != "") { echo "value=\"" . $_REQUEST['msn7'] . "\""; } ?> />
                <td><?php echo $this->error['msn7']; ?></td>
            </tr>                                                
            <tr>
            	<td>MSN 8:</td>
                <td><input type="text" name="msn8" style="width:100px; text-align:right" <?php if ($this->edit['msn8'] != "") { echo "value=\"" . $this->edit['msn8'] . "\""; } elseif ($_REQUEST['msn8'] != "") { echo "value=\"" . $_REQUEST['msn8'] . "\""; } ?> />
                <td><?php echo $this->error['msn8']; ?></td>
            </tr>            
		</table>
        <?php
		}
		}
		?>
		<br />
        </div>
        <hr style='width:700px;' align='left'/>
        <table width="700px">
        <tr>
        <td width="1%"><input type="submit" name="create" value="<?php if ($_SESSION['id_num'] == "") { echo "Create Profile"; } else { echo "Save Profile"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
		<td align="right"><input type="submit" name="cancel" value="<?php if ($_SESSION['id_num'] == "") { echo "Cancel Profile Creation"; } else { echo "Cancel Profile Editing"; } ?>" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
	</form>  
	<?php
	}	
	
	//Validates the Form
	function validation()
	{
		
		//Grab the profile name and make sure there isn't a profile already in the database
		//Only to occur if you are making a new profile
		if ($_SESSION['id_num'] == 0)
		{
			//Calls the profile class
			$this->get_profiles();
			
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}
			
			$this->get_t1_e1_profiles();
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}
			
			$this->get_analog_profiles();
			for ($z = 0; $z <= $this->profile_counter; $z++)
			{
				if (strtoupper($this->profile_name[$z]['profile_name']) == strtoupper($_REQUEST['profile_name']))
				{
					$this->error['profile_name'] = "<font color=\"red\">Profile already <strong>EXISTS</strong>. Please use a different profile name</font>";
					$this->error_counter++;
				}
			}
			
		}
		
		//Makes sure the user enters a profile name
		if ($_REQUEST['profile_name'] == "")
		{
			$this->error['profile_name'] = "<font color=\"red\">Please Enter a Profile Name</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['interface'] == "")
		{
			$this->error['interface'] = "<font color=\"red\">Please select an <strong>INTERFACE</strong></font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['interface'] == "ptp" && $_REQUEST['switchtype'] == "etsi")
		{
			$this->error['interface'] = "<font color=\"red\">ETSI <b>CANNOT</b> be used with <strong>POINT TO POINT</strong> connections</font>";
			$this->error_counter++;
		}
				
		/*if ($_REQUEST['signalling'] == "")
		{
			$this->error['signalling'] = "<font color=\"red\">Please select a <strong>SIGNALLING</strong> option</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['line_mode'] == "NT" && $_REQUEST['signalling'] == "CPE")
		{
			$this->error['signalling'] = "<font color=\"red\">Cannot use <strong>CPE</strong> Signalling on a <strong>NT</strong> Line</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['line_mode'] == "TE" && $_REQUEST['signalling'] == "NET")
		{
			$this->error['signalling'] = "<font color=\"red\">Cannot use <strong>NET</strong> Signalling on a <strong>TE</strong> Line</font>";
			$this->error_counter++;
		}*/			

		if ($_REQUEST['tei'] != "" && !is_numeric($_REQUEST['tei']))
		{
			$this->error['tei'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for TEI</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['tei'] != "" && $_REQUEST['tei'] < "0" || $_REQUEST['tei'] > "127")
		{
			$this->error['tei'] = "<font color=\"red\">TEI must be <strong>BETWEEN</strong> 0 and 127</font>";
			$this->error_counter++;
		}
	
		if ($_REQUEST['min_digits'] != "" && !is_numeric($_REQUEST['min_digits']))
		{
			$this->error['min_digits'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for the MINIMUM DIGITS</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['min_digits'] != "" && $_REQUEST['min_digits'] < "0" || $_REQUEST['min_digits'] > "12")
		{
			$this->error['min_digits'] = "<font color=\"red\">Minimum digits must be <strong>BETWEEN</strong> 1 and 12</font>";
			$this->error_counter++;
		}		
		
		if ($_REQUEST['msn1'] != "" && !is_numeric($_REQUEST['msn1']))
		{
			$this->error['msn1'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn1'] != "" && strlen($_REQUEST['msn1']) > 32)
		{
			$this->error['msn1'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['msn2'] != "" && !is_numeric($_REQUEST['msn2']))
		{
			$this->error['msn2'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn2'] != "" && strlen($_REQUEST['msn2']) > 32)
		{
			$this->error['msn2'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['msn3'] != "" && !is_numeric($_REQUEST['msn3']))
		{
			$this->error['msn3'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn3'] != "" && strlen($_REQUEST['msn3']) > 32)
		{
			$this->error['msn3'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['msn4'] != "" && !is_numeric($_REQUEST['msn4']))
		{
			$this->error['msn4'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn4'] != "" && strlen($_REQUEST['msn4']) > 32)
		{
			$this->error['msn4'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['msn5'] != "" && !is_numeric($_REQUEST['msn5']))
		{
			$this->error['msn5'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn5'] != "" && strlen($_REQUEST['msn5']) > 32)
		{
			$this->error['msn5'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['msn6'] != "" && !is_numeric($_REQUEST['msn6']))
		{
			$this->error['msn6'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn6'] != "" && strlen($_REQUEST['msn6']) > 32)
		{
			$this->error['msn6'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['msn7'] != "" && !is_numeric($_REQUEST['msn7']))
		{
			$this->error['msn7'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn7'] != "" && strlen($_REQUEST['msn7']) > 32)
		{
			$this->error['msn7'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
		
		if ($_REQUEST['msn8'] != "" && !is_numeric($_REQUEST['msn8']))
		{
			$this->error['msn8'] = "<font color=\"red\">Please enter a <strong>NUMERIC</strong> value for MSN</font>";
			$this->error_counter++;
		}
		elseif ($_REQUEST['msn8'] != "" && strlen($_REQUEST['msn8']) > 32)
		{
			$this->error['msn8'] = "<font color=\"red\">MSN <b>CANNOT</b> be longer then <b>32</b> digits</font>";
			$this->error_counter++;
		}
	
	}
	
	//Retrieves all the BRI Profile Names
	function get_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "bri_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}	
	
	//Retrieves all the BRI Profile Names
	function get_t1_e1_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "t1e1_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}		
	
	//Retrieves all the Analog Profile Names
	function get_analog_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "analog_profile";
		$a = 0;

		$select = "SELECT profile_name FROM " . $table_name . ";";

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_name[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->profile_counter = $a;
	}		
	
	//Tokenizes the TON, NPI and MSN values
	function tokenize_values()
	{
		$tok = strtok($this->edit['ton_name'], ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok(",");
			$count++;
		}	
		//echo $token[0] . "...<br />";
		$this->edit['ton_name1'] = $token[0];
		$this->edit['ton_name2'] = $token[1];
		$this->edit['ton_name3'] = $token[2];
		
		$token = "";
		$tok = strtok($this->edit['ton_value'], ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok(",");
			$count++;
		}	
		
		//echo "..." . $token[0] . "...<br />";
		
		$this->edit['ton_value1'] = $token[0];
		$this->edit['ton_value2'] = $token[1];
		$this->edit['ton_value3'] = $token[2];
		
		$token = "";
		$tok = strtok($this->edit['npi_name'], ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok(",");
			$count++;
		}	
		
		$this->edit['npi_name1'] = $token[0];
		$this->edit['npi_name2'] = $token[1];
		$this->edit['npi_name3'] = $token[2];
		
		$token = "";
		$tok = strtok($this->edit['npi_value'], ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok(",");
			$count++;
		}	
		
		$this->edit['npi_value1'] = $token[0];
		$this->edit['npi_value2'] = $token[1];
		$this->edit['npi_value3'] = $token[2];
		
		$tok = strtok($this->edit['msn'], ",");

		$token = "";
		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok(",");
			$count++;
		}	
		
		$this->edit['msn1'] = $token[0];
		$this->edit['msn2'] = $token[1];
		$this->edit['msn3'] = $token[2];
		$this->edit['msn4'] = $token[3];
		$this->edit['msn5'] = $token[4];
		$this->edit['msn6'] = $token[5];
		$this->edit['msn7'] = $token[6];
		$this->edit['msn8'] = $token[7];		
	}
	
	//Combines msn values into a token value
	function combine_msn()
	{
		$value = $_REQUEST['msn1'] . "," . $_REQUEST['msn2'] . "," . $_REQUEST['msn3'] . "," . $_REQUEST['msn4'] . "," . $_REQUEST['msn5'] . "," . $_REQUEST['msn6'] . "," . $_REQUEST['msn7'] . "," . $_REQUEST['msn8'];
		
		return $value;
	}
	
	//Combine the TON names into a token value
	function combine_ton_name()
	{
		$value = $_REQUEST['ton_name1'] . " , " . $_REQUEST['ton_name2'] . " , " . $_REQUEST['ton_name3'];
		
		return $value;
	}
	
	//Combine the TON Values into a token value
	function combine_ton_value()
	{
		$value = $_REQUEST['ton_value1'] . " , " . $_REQUEST['ton_value2'] . " , " . $_REQUEST['ton_value3'];
		
		return $value;
	}
	
	//Combine the NPI names into a token value
	function combine_npi_name()
	{
		$value = $_REQUEST['npi_name1'] . " , " . $_REQUEST['npi_name2'] . " , " . $_REQUEST['npi_name3'];
		
		return $value;
	}

	//Combine the NPI Values into a token value
	function combine_npi_value()
	{
		$value = $_REQUEST['npi_value1'] . " , " . $_REQUEST['npi_value2'] . " , " . $_REQUEST['npi_value3'];
		
		return $value;
	}
	
	function check_submit()
	{
		if ($_REQUEST['overlap'] == "" && $this->edit['overlap'] == "")
		{
			$this->pick['overlap_disable'] = "yes";
		}
		if ($_REQUEST['overlap'] == "disable")
		{
			$this->pick['overlap_disable'] = "yes";
		}
		elseif ($_REQUEST['overlap'] == "enable")
		{
			$this->pick['overlap_enable'] = "yes";
		}
		elseif ($this->edit['overlap'] == "disable")
		{
			$this->pick['overlap_disable'] = "yes";
		}
		elseif ($this->edit['overlap'] == "enable")
		{
			$this->pick['overlap_enable'] = "yes";
		}
		
		if ($_REQUEST['interface'] == "ptmp")
		{
			$this->pick['interface_ptmp'] = "yes";
		}
		elseif ($_REQUEST['interface'] == "ptp")
		{
			$this->pick['interface_ptp'] = "yes";
		}
		elseif ($this->edit['interface'] == "ptmp")
		{
			$this->pick['interface_ptmp'] = "yes";
		}
		elseif ($this->edit['interface'] == "ptp")
		{
			$this->pick['interface_ptp'] = "yes";
		}
		
		if ($_REQUEST['switchtype'] == "EuroISDN")
		{
			$this->pick['switchtype_euroisdn'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "etsi")
		{
			$this->pick['switchtype_etsi'] = "yes";
		}
		elseif ($_REQUEST['switchtype'] == "insnet")
		{
			$this->pick['switchtype_insnet'] = "yes";
		}
		elseif ($this->edit['switchtype'] == "EuroISDN")
		{
			$this->pick['switchtype_euroisdn'] = "yes";
		}
		elseif ($this->edit['switchtype'] == "etsi")
		{
			$this->pick['switchtype_etsi'] = "yes";
		}
		elseif ($this->edit['switchtype'] == "insnet")
		{
			$this->pick['switchtype_insnet'] = "yes";
		}
		
		if ($_REQUEST['bearer_ITC'] == "3.1khz")
		{
			$this->pick['bearer_ITC_31khz'] = "yes";
		}
		elseif ($_REQUEST['bearer_ITC'] == "unrestricted-digital")
		{
			$this->pick['bearer_ITC_ud'] = "yes";
		}
		elseif ($_REQUEST['bearer_ITC'] == "speech")
		{
			$this->pick['bearer_ITC_speech'] = "yes";
		}
		elseif ($this->edit['bearer_ITC'] == "3.1khz")
		{
			$this->pick['bearer_ITC_31khz'] = "yes";
		}
		elseif ($this->edit['bearer_ITC'] == "unrestricted-digital")
		{
			$this->pick['bearer_ITC_ud'] = "yes";
		}
		elseif ($this->edit['bearer_ITC'] == "speech")
		{
			$this->pick['bearer_ITC_speech'] = "yes";
		}
		
		if ($_REQUEST['bearer_UIL'] == "v110")
		{
			$this->pick['bearer_UIL_v110'] = "yes";
		}
		elseif ($_REQUEST['bearer_UIL'] == "ulaw")
		{
			$this->pick['bearer_UIL_ulaw'] = "yes";
		}
		elseif ($_REQUEST['bearer_UIL'] == "alaw")
		{
			$this->pick['bearer_UIL_alaw'] = "yes";
		}
		elseif ($this->edit['bearer_UIL'] == "v110")
		{
			$this->pick['bearer_UIL_v110'] = "yes";
		}
		elseif ($this->edit['bearer_UIL'] == "alaw")
		{
			$this->pick['bearer_UIL_alaw'] = "yes";
		}
		elseif ($this->edit['bearer_UIL'] == "ulaw")
		{
			$this->pick['bearer_UIL_ulaw'] = "yes";
		}
		
		//echo $this->edit['ton_name1'] . "..." . $this->edit['ton_value1'];
		if ($this->edit['ton_name1'] == "outbound-called-ton ")
		{
			if ($this->edit['ton_value1'] == "international ")
			{
				$this->pick['ton_value1_international'] = "yes";
			}
			elseif ($this->edit['ton_value1'] == "national ")
			{
				$this->pick['ton_value1_national'] = "yes";
			}
			elseif ($this->edit['ton_value1'] == "local ")
			{
				$this->pick['ton_value1_local'] = "yes";
			}			
		}
		
		if($this->edit['ton_name2'] == " outbound-calling-ton ")
		{
			if ($this->edit['ton_value2'] == " international ")
			{
				$this->pick['ton_value2_international'] = "yes";
			}
			elseif ($this->edit['ton_value2'] == " national ")
			{
				$this->pick['ton_value2_national'] = "yes";
			}
			elseif ($this->edit['ton_value2'] == " local ")
			{
				$this->pick['ton_value2_local'] = "yes";
			}
		}
		
		if($this->edit['ton_name3'] == " outbound-rdnis-ton")
		{
			if ($this->edit['ton_value3'] == " international")
			{
				$this->pick['ton_value3_international'] = "yes";
			}
			elseif ($this->edit['ton_value3'] == " national")
			{
				$this->pick['ton_value3_national'] = "yes";
			}
			elseif ($this->edit['ton_value3'] == " local")
			{ 
				$this->pick['ton_value3_local'] = "yes";
			}
		}
		
		if ($_REQUEST['ton_value1'] == "international")
		{
			$this->pick['ton_value1_international'] = "yes";
		}
		elseif ($_REQUEST['ton_value1'] == "national")
		{
			$this->pick['ton_value1_national'] = "yes";
		}
		elseif ($_REQUEST['ton_value1'] == "local")
		{
			$this->pick['ton_value1_local'] = "yes";
		}

		if ($_REQUEST['ton_value2'] == "international")
		{
			$this->pick['ton_value2_international'] = "yes";
		}
		elseif ($_REQUEST['ton_value2'] == "national")
		{
			$this->pick['ton_value2_national'] = "yes";
		}
		elseif ($_REQUEST['ton_value2'] == "local")
		{
			$this->pick['ton_value2_local'] = "yes";
		}

		if ($_REQUEST['ton_value3'] == "international")
		{
			$this->pick['ton_value3_international'] = "yes";
		}
		elseif ($_REQUEST['ton_value3'] == "national")
		{
			$this->pick['ton_value3_national'] = "yes";
		}
		elseif ($_REQUEST['ton_value3'] == "local")
		{
			$this->pick['ton_value3_local'] = "yes";
		}
				
		if ($this->edit['npi_name1'] == "outbound-called-npi ")
		{
			if ($this->edit['npi_value1'] == "isdn ")
			{
				$this->pick['npi_value1_isdn'] = "yes";
			}
			elseif ($this->edit['npi_value1'] == "e164 ")
			{
				$this->pick['npi_value1_e164'] = "yes";
			}
			elseif ($this->edit['npi_value1'] == "data ")
			{
				$this->pick['npi_value1_data'] = "yes";
			}
			elseif ($this->edit['npi_value1'] == "telex ")
			{
				$this->pick['npi_value1_telex'] = "yes";
			}
			elseif ($this->edit['npi_value1'] == "national ")
			{
				$this->pick['npi_value1_national'] = "yes";
			}
			elseif ($this->edit['npi_value1'] == "reserved ")
			{
				$this->pick['npi_value1_reserved'] = "yes";
			}
			elseif ($this->edit['npi_value1'] == "private ")
			{
				$this->pick['npi_value1_private'] = "yes";
			}
		}

		if($this->edit['npi_name2'] == " outbound-calling-npi ")
		{
			if ($this->edit['npi_value2'] == " isdn ")
			{
				$this->pick['npi_value2_isdn'] = "yes";
			}
			elseif ($this->edit['npi_value2'] == " e164 ")
			{
				$this->pick['npi_value2_e164'] = "yes";
			}
			elseif ($this->edit['npi_value2'] == " data ")
			{
				$this->pick['npi_value2_data'] = "yes";
			}
			elseif ($this->edit['npi_value2'] == " telex ")
			{
				$this->pick['npi_value2_telex'] = "yes";
			}
			elseif ($this->edit['npi_value2'] == " national ")
			{
				$this->pick['npi_value2_national'] = "yes";
			}
			elseif ($this->edit['npi_value2'] == " reserved ")
			{
				$this->pick['npi_value2_reserved'] = "yes";
			}
			elseif ($this->edit['npi_value2'] == " private ")
			{
				$this->pick['npi_value2_private'] = "yes";
			}
		}

		if($this->edit['npi_name3'] == " outbound-rdnis-npi")
		{
			if ($this->edit['npi_value3'] == " isdn")
			{
				$this->pick['npi_value3_isdn'] = "yes";
			}
			elseif ($this->edit['npi_value3'] == " e164")
			{
				$this->pick['npi_value3_e164'] = "yes";
			}
			elseif ($this->edit['npi_value3'] == " data")
			{
				$this->pick['npi_value3_data'] = "yes";
			}
			elseif ($this->edit['npi_value3'] == " telex")
			{
				$this->pick['npi_value3_telex'] = "yes";
			}
			elseif ($this->edit['npi_value3'] == " national")
			{
				$this->pick['npi_value3_national'] = "yes";
			}
			elseif ($this->edit['npi_value3'] == " reserved")
			{
				$this->pick['npi_value3_reserved'] = "yes";
			}
			elseif ($this->edit['npi_value3'] == " private")
			{
				$this->pick['npi_value3_private'] = "yes";
			}
		}
		
		if ($_REQUEST['npi_value1'] == "isdn")
		{
			$this->pick['npi_value1_isdn'] = "yes";
		}
		elseif ($_REQUEST['npi_value1'] == "e164")
		{
			$this->pick['npi_value1_e164'] = "yes";
		}
		elseif ($_REQUEST['npi_value1'] == "data")
		{
			$this->pick['npi_value1_data'] = "yes";
		}
		elseif ($_REQUEST['npi_value1'] == "telex")
		{
			$this->pick['npi_value1_telex'] = "yes";
		}
		elseif ($_REQUEST['npi_value1'] == "national")
		{
			$this->pick['npi_value1_national'] = "yes";
		}
		elseif ($_REQUEST['npi_value1'] == "reserved")
		{
			$this->pick['npi_value1_reserved'] = "yes";
		}
		elseif ($_REQUEST['npi_value1'] == "private")
		{
			$this->pick['npi_value1_private'] = "yes";
		}
		
		if ($_REQUEST['npi_value2'] == "isdn")
		{
			$this->pick['npi_value2_isdn'] = "yes";
		}
		elseif ($_REQUEST['npi_value2'] == "e164")
		{
			$this->pick['npi_value2_e164'] = "yes";
		}
		elseif ($_REQUEST['npi_value2'] == "data")
		{
			$this->pick['npi_value2_data'] = "yes";
		}
		elseif ($_REQUEST['npi_value2'] == "telex")
		{
			$this->pick['npi_value2_telex'] = "yes";
		}
		elseif ($_REQUEST['npi_value2'] == "national")
		{
			$this->pick['npi_value2_national'] = "yes";
		}
		elseif ($_REQUEST['npi_value2'] == "reserved")
		{
			$this->pick['npi_value2_reserved'] = "yes";
		}
		elseif ($_REQUEST['npi_value2'] == "private")
		{
			$this->pick['npi_value2_private'] = "yes";
		}
		
		if ($_REQUEST['npi_value3'] == "isdn")
		{
			$this->pick['npi_value3_isdn'] = "yes";
		}
		elseif ($_REQUEST['npi_value3'] == "e164")
		{
			$this->pick['npi_value3_e164'] = "yes";
		}
		elseif ($_REQUEST['npi_value3'] == "data")
		{
			$this->pick['npi_value3_data'] = "yes";
		}
		elseif ($_REQUEST['npi_value3'] == "telex")
		{
			$this->pick['npi_value3_telex'] = "yes";
		}
		elseif ($_REQUEST['npi_value3'] == "national")
		{
			$this->pick['npi_value3_national'] = "yes";
		}
		elseif ($_REQUEST['npi_value3'] == "reserved")
		{
			$this->pick['npi_value3_reserved'] = "yes";
		}
		elseif ($_REQUEST['npi_value3'] == "private")
		{
			$this->pick['npi_value3_private'] = "yes";
		}
	}
}