<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

	//Starts PHP Session
	session_start();
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Includes
	include 'create_analog_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$analog_config = new create_analog_profile;
	
	$db_location = "sqlite:../sqlite/cardinfo.db";

	//If statement that controls the HTML Title & gets the information out of the database if you are performing editing.
	if ($_SESSION['id_num'] == "") 
	{ 
		$title = $_SESSION['line_type'] . " Profile Creation"; 
	} 
	else 
	{ 
		$title = "Edit Profile"; 
		//echo "id = " . $_SESSION['id_num'] . "<br />";
		$id = $_SESSION['id_num'];
		
		//Pull the information out of the database and save it in the class variable "edit"
		$analog_config->edit = $data->select_statement($db_location, "analog_profile", "*", "id = $id");
	}	

	
	if ($_REQUEST['create'] == "Create Profile" || $_REQUEST['create'] == "Save Profile")
	{
		//Runs the validation script
		$analog_config->validation();
				
		//If there are no errors, place in the database
		if ($analog_config->error_counter == 0)
		{
			$_SESSION['profile_analog_num'] = $_REQUEST['id_number'];	
			$_SESSION['last_profile'] = $_REQUEST['profile_name'];
			
			//Check if it is a the profile is in the database
			if ($_SESSION['id_num'] != "")
			{
				$exist = $data->select_statement($db_location, "analog_profile", "profile_name", "id = $id");
			}
			$id = $data->select_statement($db_location, "analog_profile", "id", "");
			
			$id[0]++;
			
			if ($exist['profile_name'] == "")
			{
				//Line doesn't exist, insert it
				$insert_param = "id, profile_name, codec, operation_mode, hangup_polarity, answer_polarity, callerid, tones, call_waiting, three_way, call_swap, digit_timeout, max_digits, polarity_delay";
				$insert_values = "$id[0], \"" . $_REQUEST['profile_name'] . "\", \"" . $_REQUEST['codec'] . "\", \"" . $_REQUEST['operation_mode'] . "\", \"" . $_REQUEST['hangup_polarity'] . "\", \"" . $_REQUEST['answer_polarity'] . "\", \"" . $_REQUEST['callerid'] . "\", \"" . $_REQUEST['tones'] . "\", \"" . $_REQUEST['call_waiting'] . "\", \"" . $_REQUEST['three-way'] . "\", \"" . $_REQUEST['call-swap'] . "\", \"" . $_REQUEST['digit_timeout'] . "\", \"" . $_REQUEST['max_digits'] . "\", \"" . $_REQUEST['polarity_delay'] . "\"";
				
				$data->insert_statement($db_location, "analog_profile", $insert_param, $insert_values);
			}
			elseif ($exist['profile_name'] != "")
			{
				//Line exists, update it
				$update_param = "profile_name = \"" . $_REQUEST['profile_name'] . "\", codec = \"" . $_REQUEST['codec'] . "\", operation_mode = \"" . $_REQUEST['operation_mode'] . "\", hangup_polarity= \"" . $_REQUEST['hangup_polarity'] . "\", answer_polarity= \"" . $_REQUEST['answer_polarity'] . "\", callerid = \"" . $_REQUEST['callerid'] . "\", tones = \"" . $_REQUEST['tones'] . "\", call_waiting = \"" . $_REQUEST['call_waiting'] . "\", three_way = \"" . $_REQUEST['three-way'] . "\", call_swap = \"" . $_REQUEST['call-swap'] . "\", digit_timeout = \"" . $_REQUEST['digit_timeout'] . "\", max_digits = \"" . $_REQUEST['max_digits'] . "\", polarity_delay = \"" . $_REQUEST['polarity_delay'] . "\"";

				$where_param = "id = " . $_SESSION['id_num'];
				
				$data->update_table($db_location, "analog_profile", $update_param, $where_param);
			}
			
			//$_SESSION['profile_num']--;
			
			header( 'Location: view_analog_profiles.php' ) ;
		}
	}
	if ($_REQUEST['cancel'] == "Cancel Profile Creation" || $_REQUEST['cancel'] == "Cancel Profile Editing")
	{
		$_SESSION['id_num'] = "";
		
		//$_SESSION['profile_num'] = $_SESSION['profile_num'] - 2;
		
		//Redirects to viewing all profiles page
		header( 'Location:view_analog_profiles.php' ) ;			
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		//include 'database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
		
		if ($_SESSION['id_num'] == "") 
		{ 
			$title = "Analog Profile Creation";		
		} 
		else 
		{ 
			$title = "Analog Profile - Edit"; 
		} 
				
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title($title, "../../../style.css");		
	}
	
	//Displays the analog profile configuration page
	$analog_config->display();	

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}	
?>