<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class bri_view_profile_class
{
	
	//Variable declarations
	private $counter = int;					//Contains the total number of profiles
	private $profile_array = array();		//Contains the BRI Profiles in an array	
	public $total_ports = int;				//Contains the total number of ports for the card in question
	public $conn_type = "";					//Contains the connection type for the port
	
	//Function that retrieves the BRI profiles from the database and stores it in a multi-dimensional array
	function get_profiles()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$where_param = "conn_type = \"" . $_SESSION['bri_type'] . "\"";
		$table_name = "bri_profile";
		$a = 0;

		$select = "SELECT * FROM " . $table_name . " WHERE " . $where_param . ";";
		
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$this->profile_array[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$this->counter = $a;
	}
	
	function get_ports()
	{
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $_SESSION['card_clicked'] . "_" . $_SESSION['card_num'];
	
		$select = "SELECT port_id FROM " . $table_name . ";";
		unset($this->total_ports);
		$count = 0;
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
					
			foreach($result as $row)
			{
				if ($_SESSION['card_clicked'] == "B700" && $row['port_id'] == 5)
				{
				}
				else
				{
					$this->total_ports[$count] = $row;
					//echo "port num = " . $this->total_ports[$count]['port_id'] . "<br />";
					$count++;
				}
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}		
	}
	
	function display_profiles()
	{
		if ($this->profile_array[0]['conn_type'] == "NT")
		{
			$conn = "NT";
		}
		elseif ($this->profile_array[0]['conn_type'] == "TE")
		{
			$conn = "TE";
		}
		$_SESSION['interface'] = $conn;
?>	
    	<h3>BRI Signalling Profiles - <?php echo $conn; ?> </h3>
		<p>
        	Below is a list of all <?php echo $conn; ?> Profiles configured on this system.<br />
            There are two default profiles configured for the user. These profiles can be edited to add more functionality to the profile.<br />
            You can manage you profiles using the edit and delete buttons on the right of the specific profile.<br />
            In order to create a new profile, click on "Create New Profile".<br />
            In order to use a specific profile on a port, click on "Use" or "Use for All Ports".
        </p>
        <br />
		<form name="view" method="post">    
    	<table class="mytable">
        	<th colspan="15" class="widget-content-header ui-state-active ui-corner-top" align="left">BRI Signalling Profiles - <?php echo $conn; ?></th>
            <tr>
    		<td class="mytableheader ui-state-active">Profile Name</td>
    	    <td class="mytableheader ui-state-active">Conection Type</td>
            <td class="mytableheader ui-state-active">Interface</td>
    	    <td class="mytableheader ui-state-active">Switchtype</td>
<?php
		//Displays the following information only if SMG/FreeTDM is installed
		if ($_SESSION['freetdm'] == "True")
		{
?>			
            <td class="mytableheader ui-state-active">TEI</td>
			<td class="mytableheader ui-state-active">Overlap</td>
            <td class="mytableheader ui-state-active">Minimum Digits</td>
            <td class="mytableheader ui-state-active">Bearer Capability (ITC)</td>
            <td class="mytableheader ui-state-active">Bearer Capability (UIL)</td>
            <td class="mytableheader ui-state-active">TON</td>
            <td class="mytableheader ui-state-active">NPI</td>
<?php
			if ($this->profile_array[0]['conn_type'] == "TE")
			{
?>				            
            <td class="mytableheader ui-state-active">MSN</td>
<?php
			}
		}
		echo "</tr>\n";
		//echo "counter = " . $this->counter . "<br />";
		for ($b = 0; $b < $this->counter; $b++)
		{
			echo "\t\t\t<tr>\n";
			if ($_SESSION['last_profile'] == $this->profile_array[$b]['profile_name'])
			{
				echo "\t\t\t\t<td align=\"center\"><b>" . $this->profile_array[$b]['profile_name'] . "</b></td>\n";
			}
			else
			{
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['profile_name'] . "</td>\n";
			}
			echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['sig_type'] . "</td>\n";
			if ($this->profile_array[$b]['interface'] == "ptp")
			{
				echo "\t\t\t\t<td align=\"center\">Point to Point</td>\n";
			}
			elseif ($this->profile_array[$b]['interface'] == "ptmp")
			{
				echo "\t\t\t\t<td align=\"center\">Point to MultiPoint</td>\n";
			}
			echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['switchtype'] . "</td>\n";
			
			//Displays the following information only if SMG/FreeTDM is installed
			if ($_SESSION['freetdm'] == "True")
			{
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['tei'] . "</td>\n";				
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['overlap'] . "</td>\n";
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['min_digits'] . "</td>\n";
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['bearer_ITC'] . "</td>\n";
				echo "\t\t\t\t<td align=\"center\">" . $this->profile_array[$b]['bearer_UIL'] . "</td>\n";
				//echo "\t\t\t\t<td>\n";
				//echo "\t\t\t\t\t<table>\n";
				//echo "\t\t\t\t\t\t<tr>\n";
				if ($this->profile_array[$b]['ton_name'] == "" || $this->profile_array[$b]['ton_name'] == " ,  , ")
				{
					echo "\t\t\t\t<td align=\"center\"></td>\n";	
				}	
				elseif ($this->profile_array[$b]['ton_name'] != "")
				{
					$tons = $this->tokenize_values($this->profile_array[$b]['ton_name']);
					if ($tons == 1)
					{
						echo "\t\t\t\t\t\t\t<td align=\"center\">$tons entry exists</td>\n";
					}
					elseif ($tons > 1)
					{
						echo "\t\t\t\t\t\t\t<td align=\"center\">$tons entries exist</td>\n";
					}
					//echo "\t\t\t\t\t\t\t<td align=\"right\">" . $this->profile_array[$b]['ton_value'] . "</td>\n";
				}							
				
				//echo "\t\t\t\t\t\t</tr>\n";
				//echo "\t\t\t\t\t</table>\n";
				//echo "\t\t\t\t</td>\n";
				//echo "\t\t\t\t<td>\n";
				//echo "\t\t\t\t\t<table>\n";
				//echo "\t\t\t\t\t\t<tr>\n";
				if ($this->profile_array[$b]['npi_name'] == "" || $this->profile_array[$b]['npi_name'] == " ,  , ")
				{
					echo "\t\t\t\t<td align=\"center\"></td>\n";	
				}				
				elseif ($this->profile_array[$b]['npi_name'] != "")
				{
					$npis = $this->tokenize_values($this->profile_array[$b]['npi_name']);
					if ($npis == 1)
					{
						echo "\t\t\t\t\t\t\t<td align=\"center\">$npis entry exists</td>\n";	
					}
					elseif ($npis > 1)
					{
						echo "\t\t\t\t\t\t\t<td align=\"center\">$npis entries exist</td>\n";
					}
				}				
				//echo "\t\t\t\t\t\t\t<td align=\"left\">" . $this->profile_array[$b]['npi_name'] . "</td>\n";	
				//echo "\t\t\t\t\t\t\t<td align=\"right\">" . $this->profile_array[$b]['npi_value'] . "</td>\n";
				//echo "\t\t\t\t\t\t</tr>\n";
				//echo "\t\t\t\t\t</table>\n";
				echo "\t\t\t\t</td>\n";	
				if ($this->profile_array[0]['conn_type'] == "TE")
				{				
					if ($this->profile_array[$b]['msn'] != "")
					{
						$msns = $this->tokenize_values($this->profile_array[$b]['msn']);
						if ($msns == 1)
						{
							echo "\t\t\t\t<td align=\"center\">$msns Number Entered</td>\n";
						}
						elseif ($msns > 1)
						{
							echo "\t\t\t\t<td align=\"center\">$msns Numbers Entered</td>\n";	
						}
					}
					else
					{
						echo "\t\t\t\t<td align=\"center\">0 Numbers Entered</td>\n";	
					}
				}
			}
			echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use" . $this->profile_array[$b]['id'] . "\" value=\"Use\" " . $_SESSION['button_class'] . "/></td>\n";		
			echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"use-all-" . $this->profile_array[$b]['id'] . "\" value=\"Use for all Ports\" " . $_SESSION['button_class'] . "/></td>\n";		
			echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"config" . $this->profile_array[$b]['id'] . "\" value=\"Edit Profile\" " . $_SESSION['button_class'] . "/></td>\n";
	
			$skip = 0;
			//Disables deleting the default profile
			if ($this->profile_array[$b]['profile_name'] == "BRI PTMP CPE" || $this->profile_array[$b]['profile_name'] == "BRI PTMP NET")
			{
				$skip = 1;
			}
			elseif ($this->profile_array[$b]['profile_name'] == "BRI PTP CPE" || $this->profile_array[$b]['profile_name'] == "BRI PTP NET")
			{
				$skip = 1;
			}
			
			if ($skip == 0)
			{
				echo "\t\t\t\t<td align=\"center\"><input type=\"submit\" name=\"delete" . $this->profile_array[$b]['id'] . "\" value=\"Delete Profile\" " . $_SESSION['button_class'] . "/></td>\n";
			}

			echo "\t\t\t<tr>\n";
			$num_entries++;
		}
		echo "\t\t</table>\n";		
	
	//Puts the number of entries in the database into a session variable
	$_SESSION['num_entries'] = $num_entries;
?>	        
    	<br />
        <table width="900px">
        <tr>
        <td width="1%"><input type="submit" name="create" value="Create New Profile" <?php echo $_SESSION['button_class']; ?>/></td>
    	<td align="right"><input type="submit" name="back" value="Go Back to Hardware Information" <?php echo $_SESSION['button_class']; ?>/></td>
        </tr>
        </table>
</form>        

<?php
	}
	
	//Tokenizes the TON,NPI and MSN values for entry into the form
	function tokenize_values($string)
	{
		$tok = strtok($string, ",");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok= strtok(",");
			$count++;
		}	
		
		for ($a = 0; $a < $count; $a++)
		{
			if ($token[$a] == " " || $token[$a] == "  ")
			{
			}
			else
			{
				$counter++;
			}
		}
		
		return $counter;		
	}	

}

?>