<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
	Jonathan Maurice <jmaurice@sangoma.com>
*/

//Starts PHP Sessions
session_start();
$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

include '../check_referer.php';

//Make sure the user is logged into the WebUI
Authenticate();

require_once('../classes.php');
require_once('../database_classes.php');
require_once('../bg_process_class.php');
require_once('../display_class.php');
require_once('test-setup-class.php');

define("ICON_LOADING", "./icon-loading.gif");

$testScriptPath = getcwd(). "/prod-test.sh";
$testProcessName = "self-test";

$prodTestDynDivName = "SelfTestDiv";
$prodTestDispCommon = new Display_common();

$bgProcessTest = new BgProcess($testScriptPath, null, $testProcessName);

///////////////////////////////////////////////////////////////////////////////
//
// HEADER
//
///////////////////////////////////////////////////////////////////////////////
//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
  unset($_SESSION['embedded']);
  
  //FusionPBX Integration
  require_once "../fusionpbx/includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
  //Includes required for ClearOS Integration
  require_once '../sqlite/database_creation.php';
  
  $display_common = new Display_common;
  
  $_SESSION['embedded'] = "true";
  
  //ClearOS Integration
  $prodTestDispCommon->session_vars("sqlite:../sqlite/cardinfo.db");
  $prodTestDispCommon->html_header();
  $prodTestDispCommon->html_title("Production Test", "../../style.css","");		
}
///////////////////////////////////////////////////////////////////////////////
//
// Main
//
///////////////////////////////////////////////////////////////////////////////

//Check if the test script was aborted
if(isset($_POST['Abort-Self-Test']) && $prodTestDispCommon->IsRenderingNonDynamicDiv()) {

  //Test must be aborted.
  $testSetup = new TestSetup();

  DisplayHeader();
  DisplayCardsTable($testSetup);
  
  //Abort test (wait 10 sec for script to exit)
  if ($bgProcessTest->abort(10) ){
    //require_once 'prod-test.php';
    //restoreConfig();
	
	$cmd = $_SESSION['smg_root_path'] . "/nginx/html/php/production-test/restore.sh";
	exec($cmd);
		
	$notif = new NotificationBox( 'Error', NotificationBox::Error  );
	$notif->add("Self Test Abort", "Test was aborted");
	echo $notif->getHtml();		
	unset($notif);	
  }
  else {
  	$notif = new NotificationBox( 'Error', NotificationBox::Error  );
	$notif->add("Self Test Abort","Failed to stop self test!");
	echo $notif->getHtml();		
	unset($notif);
    //$prodTestDispCommon->WarningBox("Failed to stop self test!");
    DisplayTestOutput($bgProcessTest);
  }
}
//Check if request is a refresh.
elseif ($prodTestDispCommon->IsRenderingNonDynamicDiv() && !isset($_POST['Start-Self-Test']) ) {
  //This is a normal request.
  DisplayHeader();
  
  $testSetup = new TestSetup();

  //Make sure there is any cards
  if (!$testSetup->hasCards()) {
  	$notif = new NotificationBox( 'Error', NotificationBox::Error  );
	$notif->add("Hardware","Please Insert a TDM card or Media Processing Card into your system in order to run the self-test");
	echo $notif->getHtml();		
	unset($notif);	  
    //$prodTestDispCommon->WarningBox("Please Insert a TDM card or Media Processing Card into your system in order to run the self-test");
  }
  else {

    DisplayCardsTable($testSetup);

    //Check if this is already running...
    if($bgProcessTest->isRunning()){
      DisplayTestOutput($bgProcessTest);
    }
    else {
      //Test is not running
      DisplayTestForm($testSetup);
    }
  }

  DisplayFooter();
}
elseif($prodTestDispCommon->IsDynamicDivRefreshRequest($prodTestDynDivName) && !isset($_POST['Start-Self-Test'])) {
  //This is a refresh.
  DisplayTestOutput($bgProcessTest);

}
elseif(isset($_POST['Start-Self-Test'])) {
  //This is a start self test request
  $testSetup = new TestSetup();

  //Make sure that any test type was checked in the form
  if ( isset($_POST['Run-Tdm-Test']) || isset($_POST['Run-Media-Test']) ){
    //Start self test
    DisplayHeader();
    DisplayCardsTable($testSetup);
    $prodTestDispCommon->DynamicDivEnable();
    //Start dynamic div with refresh of 2 second.
    $prodTestDispCommon->DynamicDivBegin($prodTestDynDivName, "", 2000);
    StartSelfTest($testSetup, $bgProcessTest, $_POST);
    DisplayTestOutput($bgProcessTest);
    $prodTestDispCommon->DynamicDivEnd($prodTestDynDivName);
  }
  else {
    //No test was selected in the form
  	$notif = new NotificationBox( 'Error', NotificationBox::Error  );
	$notif->add("Self-Test","Please select the type of the test you want to run!");
	echo $notif->getHtml();		
	unset($notif);	
    //$prodTestDispCommon->WarningBox("Please select the type of the test you want to run!");
    DisplayHeader();
    DisplayCardsTable($testSetup);
    DisplayTestForm($testSetup);
  }

  DisplayFooter();
}
///////////////////////////////////////////////////////////////////////////////
//
// FOOTER
//
///////////////////////////////////////////////////////////////////////////////
if ( $prodTestDispCommon->IsRenderingNonDynamicDiv( ) )
{  
  if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  {
    unset($_SESSION['embedded']);
    //FusionPBX Integration
    require_once "../fusionpbx/includes/footer.php";
  }
  elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {
    //ClearOS Integration
    $prodTestDispCommon= new Display_common;
    $prodTestDispCommon->html_footer();	
  }
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

function Authenticate ()
{
  if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1"){
    return true;
  }
  else {
    header( 'Location:index.php' ) ;
    exit();
  }
}

function StartSelfTest(&$in_testSetup, &$in_bgProcess, $in_post)
{
  //Need to use $in_bgProcess->setArgs() to add arguments base on the POST.
  //POST will be similar to this:
  //Array ( [Run-Tdm-Test] => Tdm [Tdm-Line-Type] => T1 [Run-Media-Test] => 
  //Media [Start-Self-Test] => Start Self Test ) 

  $runTdm = isset($in_post['Run-Tdm-Test']);
  $runMedia = isset($in_post['Run-Media-Test']);

  $args = "";
  $tdmLineType = "";
  if ($runTdm && $runMedia){
	  $tdmLineType = $in_post['Tdm-Line-Type'];
	  if ($_POST['physical_test'] == "yes") {
		  $args = "--all $tdmLineType physical";
	  }
	  else {
		  $args = "--all $tdmLineType";
	  }
  }
  elseif ($runTdm){
    $tdmLineType = $in_post['Tdm-Line-Type'];
	  if ($_POST['physical_test'] == "yes") {
		  $args = "--TDM $tdmLineType physical";
	  }
	  else {
    $args = "--TDM $tdmLineType";
	  }
  }
  elseif ($runMedia){
    $args = "--media all";
  }

  //Set arguments
  $in_bgProcess->setArgs($args);

  //Start self test
  $in_bgProcess->run();
}

function DisplayTestOutput(&$in_bgProcess)
{
  $running = $in_bgProcess->isRunning();
  $logContent = $in_bgProcess->getLog();
  $output = "";

  foreach ($logContent as $line) {
    $output = $output . "$line<br/>\n";
  }

  if($running){
    $output = $output . "<img src='" .ICON_LOADING. "' align='left'/>&nbsp;"
              . "Test is running... please wait<br/>\n";
  }
  else {
    $output = $output . "Done<br/>\n";
  }

//var_dump ($logContent);

  echo "<br/>\n";
  echo "<table class='mytable' border='1' width='100%'>\n";
  echo "	<tr>\n";
  //Show abort button
  echo "     <th class='widget-content-header ui-state-active ui-corner-top' align='left'>";
  echo "     <table width='100%'>\n";
  echo "       <tr>\n";
  echo "	     <td align='left'>\n";
  echo "	 	     <b>Test Output</b>\n";
  echo "       </td>\n";
  echo "	     <td align='right' width='33%'>\n";
  if ($running){
    echo "       <form name='Abort-self-test' method='post'>\n"; 
    echo "         <input align='center' type='submit' name='Abort-Self-Test' value='Abort Self Test' " . $_SESSION['button_class'] . "/>\n";
    echo "       </form>\n";
  }
  else {
    echo "       <form name='Download-test-results' method='get' action='download-prod-test-result.php'>\n"; 
    echo "         <input align='center' type='submit' name='Download-Result' value='Download Results' " . $_SESSION['button_class'] . "/>\n";
    echo "       </form>\n";
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  	{
		echo "       <form name='refresh-page' method='get' action='/fusionpbx/sangoma/production-test/production-test.php'>\n"; 
	}
	elseif  (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  	{
		echo "       <form name='refresh-page' method='get' action='/admin/ss7_diagnostics.php' target=\"_parent\">\n"; 
	}
    echo "         <input align='center' type='submit' name=refresh' value='Refresh Page' " . $_SESSION['button_class'] . "/>\n";
    echo "       </form>\n";
  }
  echo "       </td>\n";
  echo "     </table>\n";
  echo "     </th>\n";
  echo "	</tr>\n";
  echo "<tr><td>\n";
  //Show output log
  echo $output;
  echo "</td></tr>\n";
  echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom'>\n";
  echo "</th>\n";
  echo "</table>\n";
  echo "<br/>\n";

}

function DisplayCardsTable(&$in_testSetup)
{
	require_once('../classes.php');
	require_once('../production-test/prod-test-class.php');
	$prod = new prod_test;
	$tokenization = new wanrouter_hwprobe;

	$prod->smg_path();
	$prod->parse_results = $tokenization->get_information('');
	$prod->get_cards();	
	
  //Process digitals cards
  if ($in_testSetup->hasDigitalCards()){
    $digCards = $in_testSetup->getDigitalCards();

    echo "<table class='mytable' border='1' width='450px'>\n";
    echo "<th colspan='5' class='widget-content-header ui-state-active ui-corner-top' align='left'>TDM Cards\n";
    echo "</th>\n";
    echo "<tr align='center'>\n
           	<td class='mytableheader ui-state-active'>Board Name</td>\n
            <td class='mytableheader ui-state-active'>Board Type</td>\n
            <td class='mytableheader ui-state-active'>Number of Boards</td>\n
            <td class='mytableheader ui-state-active'>Number of Spans</td>\n
			
          </tr>\n";


	for ($y = 1; $y <= $prod->num_a101; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A101</td>\n";
      	echo "<td>1 Port T1/E1 Board</td>\n";
		echo "<td>" . $prod->num_a101 . "</td>\n";
		echo "<td>".  ($prod->num_a101 * 1) . "</td>";
      	echo "</tr>\n";
		break;

	}
	for ($y = 1; $y <= $prod->num_a102; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A102</td>\n";
      	echo "<td>2 Port T1/E1 Board</td>\n";
		echo "<td>" . $prod->num_a102 . "</td>\n";
		echo "<td>".  ($prod->num_a102 * 2) . "</td>";
		break;
	}
	for ($y = 1; $y <= $prod->num_a104; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A104</td>\n";
      	echo "<td>4 Port T1/E1 Board</td>\n";
		echo "<td>" . $prod->num_a104 . "</td>\n";
		echo "<td>".  ($prod->num_a104 * 4) . "</td>";
		echo "</tr>\n";
		break;
	}
	for ($y = 1; $y <= $prod->num_a108; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A108</td>\n";
      	echo "<td>8 Port T1/E1 Board</td>\n";
		echo "<td>" . $prod->num_a108 . "</td>\n";
		echo "<td>".  ($prod->num_a108 * 8) . "</td>";
		echo "</tr>\n";
		break;
	}
	for ($y = 1; $y <= $prod->num_a116; $y++)
	{
		echo "<tr align='center'>\n";
      	echo "<td>A116</td>\n";
      	echo "<td>16 Port T1/E1 Board</td>\n";
		echo "<td>" . $prod->num_a116/2 . "</td>\n";
		echo "<td>".  ($prod->num_a116 * 8) . "</td>";
		echo "</tr>\n";
		break;
	}
	

    /*$digCardSpecs = new DigitalCardSpecs();
    foreach ($digCards as $cardName => $numCard) {
      $cardType = $digCardSpecs->getCardTypeStr($cardName);
      $numSpan = $digCardSpecs->getNumSpan($cardName);
      echo "<tr align='center'>\n";
      echo "<td>$cardName</td>\n";
      echo "<td>$cardType</td>\n";
      echo "<td>$numCard</td>\n";
      echo "<td>$numSpan</td>\n";
	  //echo "<td>$firmware</td>\n";
      echo "</tr>\n";
    }
	*/
    echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='5'>\n";
    echo "</th>\n";
    echo "</table>\n";
    echo "<br/>\n";
  }

  //Process media cards
  if ($in_testSetup->hasMediaCards()){
    $mediaCards = $in_testSetup->getMediaCards();

    echo "<table class='mytable' border='1' width='450px'>\n";
    echo "<th colspan='3' class='widget-content-header ui-state-active ui-corner-top' align='left'>Media Cards\n";
    echo "</th>\n";
    echo "<tr align='center'>\n
           	<td class='mytableheader ui-state-active'>Interface</td>\n
           	<td class='mytableheader ui-state-active'>Mac Address</td>\n
			
          </tr>\n";

    foreach ($mediaCards as $ethName => $macAddr) {
      echo "<tr align='center'>\n";
      echo "<td>$ethName</td>\n";
      echo "<td>$macAddr</td>\n";
	  
	  //Get vocallo firmware version
	  /*$firmware = new firmware_check;
	  $firmware_value = $firmware->vocallo_firmware($ethName,$data);
	  
	  if ($_SESSION['vocallo_firmware'] != $firmware_value)
	  {
		  $firmware_string = "<font color='red'>" . $firmware_value . "<img src='../fusionpbx/AlertSign.png' width='12' height='12' title='Firmware outdated' style='vertical-align:text-bottom;float:none'/></font>";
	  }
	  else
	  {
		  $firmware_string = $firmware_value;
	  }
	  
	  echo "<td>$firmware_string</td>\n";*/
      echo "</tr>\n";
    }

    echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='3'>\n";
    echo "</th>\n";
    echo "</table>\n";
    echo "<br/>\n";
  }

}

function DisplayTestForm(&$in_testSetup)
{
  $display_common = new Display_common;

  if( $display_common->IsGatewayRunning() ) {
    //$display_common->WarningBox("The Gateway is currently started. Please stop the gateway in order to proceed with the self test.");
	$notif = new NotificationBox( 'Error', NotificationBox::Error );
	$notif->add("Gateway", "The Gateway is currently started. Please stop the gateway in order to proceed with the self test.");
	echo $notif->getHtml();		
	unset($notif);
    return false;
  }

  echo "<br/>\n";
  echo "<table class='mytable' border='1' width='400px'>\n";
  echo "<th colspan='3' class='widget-content-header ui-state-active ui-corner-top' align='left'>Self Test Settings\n";
  echo "</th>\n";
  echo "<tr align='center'>\n
          <td class='mytableheader ui-state-active'>Type</td>\n
          <td class='mytableheader ui-state-active'>Run</td>\n
          <td class='mytableheader ui-state-active'>Options</td>\n
        </tr>\n";
  echo "<form name='Run-self-test' method='post'>\n"; 
  //If there is digital cards show related input
  if ($in_testSetup->hasDigitalCards()){
    echo "  <tr align='center'>\n";
    echo "    <td>TDM</td>\n";
    echo "    <td><input align='center' type='checkbox' checked='checked' name='Run-Tdm-Test' value='Tdm'/></td>\n";
    echo "    <td>\n
	            <table>
				<tr>
				<td>
				Line Type: 
                <select name='Tdm-Line-Type'>\n
                  <option value='T1'>T1</option>\n
                  <option value='E1'selected='selected'>E1</option>\n
				  </select>
				 </td>
				 <td> 
				<!-- <input type='checkbox' name='physical_test' checked='checked' value='yes' />Physical Test	 -->
				Loopback Mode: 
				<select name='physical_test'>
					<option value='yes'>Physical</option>
					<option value='digital'>Digital</option>
				</select>
				</tr>
				</table>
              </td>\n";			  
    echo "  </tr>\n";
  }
  //If there is media cards show related input
  if ($in_testSetup->hasMediaCards()){
    echo "  <tr align='center'>\n";
    echo "    <td>Media</td>\n";
    echo "    <td><input align='center' type='checkbox' checked='checked' name='Run-Media-Test' value='Media'/></td>\n";
    echo "    <td></td>\n";
    echo "  </tr>\n";
  }
  //Close the table
  echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='3'>\n";
  echo "</th>\n";
  echo "</table>\n";
  echo "<br/>\n";
  //Submit button
  echo "<input align='center' type='submit' name='Start-Self-Test' value='Start Self Test' " . $_SESSION['button_class'] . "/>\n";
  echo "</form>\n";

}

function DisplayHeader()
{
  // !+!wadam use old method otherwise binary version does not work
  return;
  //Check to see which UI we are running in
  if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  {
    unset($_SESSION['embedded']);
    
    //FusionPBX Integration
    require_once "../fusionpbx/includes/header.php";
  }
  elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {
    //Includes required for ClearOS Integration
    require_once '../sqlite/database_creation.php';
    
    $display_common = new Display_common;
    
    $_SESSION['embedded'] = "true";
    
    //ClearOS Integration
    $display_common->session_vars("sqlite:../sqlite/cardinfo.db");
    $display_common->html_header();
    $display_common->html_title("Production Test", "../../style.css","");		
  }
}

function DisplayFooter()
{
  // !+!wadam use old method otherwise binary version does not work
  return;
  if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
  {
    unset($_SESSION['embedded']);
    //FusionPBX Integration
    require_once "../fusionpbx/includes/footer.php";
  }
  elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {
    //ClearOS Integration
    $display_common = new Display_common;
    $display_common->html_footer();	
  }
}

?>
