<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Production Test Class
class prod_test
{

	public $a101count = "";				//Initializes the A101 Counter
	public $a102count = "";				//Initializes the A102 Counter
	public $a104count = "";				//Initializes the A104 Counter
	public $a108count = "";				//Initializes the A108 counter
	public $a116count = "";				//Initializes the A116 counter
	public $line_counter = "";			//Initializes the Line Counter which looks at the results of the wanrouter hwprobe dump
	public $line_type = "";				//Initializes the linetype variable
	public $parse_results = array();	//Initializes the parse_results array
	public $card_error = "";			//Error variable that holds whethere there are cards in the system
	public $main_smg_path = "";			//Contains the root path to smg
	private $conf_smg_path = "";		//Contains the path to the conf directory of smg
	private $array_name=array();		//Contains the ethernet device names
	public $array_mac=array();			//Contains the mac address of the ethernet devices
	public $mp_device_name=array();		//Contiains the media processing device name
	private $is_sangoma="";				//Tells whether the ethernet device is a sangoma device
	public $mp_card = array();			//Contains the complete list of mp cards on the system
	private $mp_mac = array();			//Contains the mac address of all media processing cards on the system
	public $num_a101 = "";
	public $num_a102 = "";
	public $num_a104 = "";
	public $num_a108 = "";
	public $num_a116 = "";
	public $total_span = "";			//Contains the total number of A10x spans in the system
	public $num_spans = "";				//Contains the total number of A10x spans in the system
	public $legacy_names = array();		//Contains the legacy names for the transcoder cards
	public $array_ip_addr = array();
	public $ifcfg_error = array();		//Contains ifcfg file creation errors
	public $tc_sessions = array();		//Contains the amount of transcoding sessions the card can do
	public $translate = array();				//Translates span number to port and card and card number
	
	//Gets the values and places them into their own classes for the creation of  
	function get_cards()
	{	
		//Requires the classes.php file in order to populate the card class variables
		//require('../classes.php');
	
		//Counter that goes through each item of the parse_results variable and searches A-Series Cards
		$this->line_counter = count($this->parse_results);
		
		//echo "Counter = " . count($this->parse_results) . "\n";
		
		if ($this->line_counter > 0)
		{	
			for ($b = 0; $b <= $this->line_counter; $b++)
			{	
				//Fills A101 Class with information from wanrouter hwprobe dump
				if ($this->parse_results[$b] == "AFT-A101-SH")
				{
					if ($this->a101count % 1 == 0)
					{
						$e++;
						$this->a101[$e] = new cardinfo();
					}
				
					$this->a101[$e]->class_create_shift($this->parse_results,$b);
					$this->a101count++;
				}
				
				//Fills A102 Class with information from wanrouter hwprobe dump
				if ($this->parse_results[$b] == "AFT-A102-SH")
				{
					if ($this->a102count % 2 == 0)
					{
						$d++;
						$this->a102[$d] = new cardinfo();
					}
					
					$this->a102[$d]->class_create_shift($this->parse_results,$b);
					$this->a102count++;
				}
				
				//Fills A104 Class with information from wanrouter hwprobe dump
				if ($this->parse_results[$b] == "AFT-A104-SH")
				{
					if ($this->a104count % 4 == 0)
					{
						$x++;
						$this->a104[$x] = new cardinfo();			
					}
					
					$this->a104[$x]->class_create_shift($this->parse_results,$b);
					$this->a104count++;
				} 
				
				//Fills A108 Class with information from wanrouter hwprobe dump
				if ($this->parse_results[$b] == "AFT-A108-SH")
				{
					if ($this->a108count % 8 == 0)
					{
						$y++;
						$this->a108[$y] = new cardinfo();							
					}
			
					$this->a108[$y]->class_create_shift($this->parse_results,$b);
					//echo "slot = " . $this->a108[$y]->pci_slot . "\n";
					$this->a108count++;		
				}
				//Fills A116 Class with information from wanrouter hwprobe dump
				if ($this->parse_results[$b] == "AFT-A116-SH")
				{
					if ($this->a116count % 8 == 0)
					{
						$z++;
						$this->a116[$z] = new cardinfo();							
					}
			
					$this->a116[$z]->class_create_shift($this->parse_results,$b);
					//echo "slot = " . $this->a108[$y]->pci_slot . "\n";
					$this->a116count++;		
				}				
			}
			$this->num_a101 = $e;
			$this->num_a102 = $d;
			$this->num_a104 = $x;
			$this->num_a108 = $y;
			$this->num_a116 = $z;						
		}
		elseif ($this->line_counter == 0)
		{
			//No Cards inside the system
			//Return Error
			
			$this->card_error = "YES";
		}
	}
	
	//Finds any media processing cards within the system
	function find_mp_cards()
	{
		//Calls the function which returns information based on the media processing cards
		$this->get_mp_info();
		
		//Starts the counter for the complete array of sangoma devices
		$count = 0;
		
		//Goes through all the ethernet devices to find the sangoma hardware
		for ($a = 0; $a < count($this->array_name); $a++)
		{
			$this->compare_mac($this->array_mac[$a]);
			//echo $this->array_name[$a] . "<br />\n";
			if ($this->is_sangoma == "YES")
			{
				$this->mp_cards[$count] = $this->array_name[$a];
				$this->mp_mac[$count] = $this->array_mac[$a];
				$count++;
			}
		}
	}
	
	//Calculates the number of spans in the system
	function calc_num_spans()
	{
		$this->num_spans = ($this->num_a101 * 1 ) + ($this->num_a102 * 2) + ($this->num_a104 * 4) + ($this->num_a108 * 8) + ($this->num_a116 * 8);
	}
	
	function smg_path()
	{
		//Figures out the path of smg
		$output = shell_exec ("pwd");
		$path = $output;

		//Tokenize the path and strip eveything up to nginx
		//Counter for tokens to place into an array
		$total_token = 0;
		
		$tok = strtok($output, "/");
		$count = 0;
		
		while ($tok !== false) {
			$token[$count] = $tok;
			
			//Stores the tokens in an array to be parsed
			$token_values[$total_token] = $token[$count];			
			$tok = strtok("/");
			$count++;
			$total_token++;
		}	
		
		$a = $total_token;
		
		do
		{
			$a--;
		} 
		while($token_values[$a] != "nginx");
		
		for ($z = 0; $z < $a; $z++)
		{
			$smg_temp_path .= "/" . $token_values[$z];
		}
		$_SESSION['smg_location'] = $smg_temp_path;
		
		$this->main_smg_path = $smg_temp_path;
		$this->conf_smg_path = $smg_temp_path . "/conf";	
	}
	
	//Wanrouter control
	function wanrouter($status)
	{
		if ($status == "start")
		{
			//echo $this->num_spans . "\n";
			/*for ($aa = 1; $aa <= $this->num_spans; $aa++)
			{
				$cmd = "/usr/sbin/wanrouter start wanpipe" . $aa . " &>  " . $this->main_smg_path . "/nginx/html/php/production-test/temp";
				//echo $cmd . "\n";
				exec($cmd, $output);

			}*/
			$cmd = "/usr/sbin/wanrouter start &>  " . $this->main_smg_path . "/nginx/html/php/production-test/temp";
			exec ($cmd, $output);
			
			$cmd = "grep -E 'ERROR|ioctl' -c temp";
			//echo $cmd . "\n";
			exec ($cmd, $output);
			exec ("rm -f temp");
			
			if ($output[0] > 0)
			{
				$cmd = "/usr/bin/pkill -9 wanpipemon";
				shell_exec($cmd);				
				exec ("/usr/sbin/wanrouter stop all");
				$error = "wanrouter error";
			}
			else
			{
				$error = "";
			}	
			
		}
		elseif ($status == "stop")
		{
			sleep(5);
			$cmd = "/usr/bin/pkill -9 wanpipemon";
			shell_exec($cmd);
			exec("/usr/sbin/wanrouter stop all",$output);
			sleep(5);
		}
		
		return $error;
	}
	
	//Sangoma Media Gateway control
	function smg($status)
	{
		$cmd = "/etc/init.d/nsg " . $status . " > /dev/null 2>&1";
		sleep(1);
		exec($cmd);
	}
	
	//Media Processing Control
	function sngmp_server($status)
	{
		$cmd = "/usr/sbin/sngtc_server_ctrl " . $status;
		exec($cmd);
		exec("echo \$?",$output);
		
		//echo "Response was " . $output[0] . "<br />";
		
		if ($output[0] != 0)
		{
			$error = "yes";
		}			
		return $error;
	}
	
	function backup()
	{	
		//Backup /etc/wanpipe directory
		exec ("ls /etc/wanpipe | grep -c 'wanpipe_old_configs'", $output);
		//echo "dir = " . $output[0] . "\n";
		
		if ($output[0] == 0)
		{
			shell_exec("mkdir /etc/wanpipe/wanpipe_old_configs");
		}
		
		$cmd = "ls /etc/wanpipe/ | egrep -c 'wanpipe[1-9].?\.conf'";
		exec ($cmd, $check);
		if ($check[0] > 1)
		{
			shell_exec("mv /etc/wanpipe/wanpipe*.conf /etc/wanpipe/wanpipe_old_configs/");
			shell_exec("mv /etc/wanpipe/wanrouter.rc /etc/wanpipe/wanpipe_old_configs/");
		}

		$cmd = "ls " . $this->conf_smg_path . " | grep -c 'freetdm_backup'";
		exec ($cmd,$smg_output);
		
		if ($smg_output[0] == 0) 
		{
			$smg_mkdir = "mkdir " . $this->conf_smg_path . "/freetdm_backup";
			shell_exec ("$smg_mkdir");
		}
		//echo "dir = " . $smg_output[0] . "\n";
		
		//Backup Freetdm configuration
		$location = $this->conf_smg_path . "/freetdm.conf";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{		
			$smg_backup = "mv " . $this->conf_smg_path . "/freetdm.conf " . $this->conf_smg_path . "/freetdm_backup/";
			shell_exec ($smg_backup);
		}
		
		$location = $this->conf_smg_path . "/autoload_configs/freetdm.conf.xml";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{		
			$smg_backup = "mv " . $this->conf_smg_path . "/autoload_configs/freetdm.conf.xml " . $this->conf_smg_path . "/freetdm_backup/";
			shell_exec ($smg_backup);
		}
		
		//Backup media processing config
		$location = $this->conf_smg_path . "/autoload_configs/sangoma_codec.conf.xml";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{
			$smg_backup = "mv " . $this->conf_smg_path . "/autoload_configs/sangoma_codec.conf.xml " . $this->conf_smg_path . "/freetdm_backup/";
			shell_exec ($smg_backup);
		}
		
		$location = "/etc/sngtc/sngtc_server.conf.xml";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{
			$smg_backup = "mv /etc/sngtc/sngtc_server.conf.xml " . $this->conf_smg_path . "/freetdm_backup/";
			shell_exec ($smg_backup);
		}
		
		
		//Check if interfaces need to be backed up
		for ($a=0; $a< count($this->mp_cards); $a++)
		{
			$interface_cmd = "ls /etc/sysconfig/network-scripts | grep -c ifcfg-" . $this->mp_cards[$a];
			exec ($interface_cmd, $output);
			
			if ($output[0] > 0)
			{
				//backup the file
				$location = "/etc/sysconfig/network-scripts/ifcfg-" . $this->mp_cards[$a];
				$value = $this->check_for_file($location);

				if ($value == "yes")
				{
					$interface_backup = "mv /etc/sysconfig/network-scripts/ifcfg-" . $this->mp_cards[$a] . " " . $this->conf_smg_path . "/freetdm_backup/";
					//echo $interface_backup . "\n";
					shell_exec($interface_backup);
				}
			}
		}
	}
	
	//Checks if a file exists so that it can be backed up
	function check_for_file($location)
	{
		if (file_exists($location))
			$value = "yes";
		
		return $value;
	}
	
	//Restore original configuration files
	function restore()
	{
		$cmd = "ls /etc/wanpipe/wanpipe_old_configs | egrep -c 'wanpipe[1-9].?\.conf'";
		exec ($cmd, $check);
		if ($check[0] > 1)
		{
			//Remove old files
			shell_exec("rm -f /etc/wanpipe/wanpipe*.conf");
			shell_exec("rm -f /etc/wanpipe/wanrouter.rc");
			
			//Restore files
			shell_exec("mv /etc/wanpipe/wanpipe_old_configs/wanpipe*.conf /etc/wanpipe/");
			shell_exec("mv /etc/wanpipe/wanpipe_old_configs/wanrouter.rc /etc/wanpipe/");
		}
		elseif ($check[0] < 2)
		{
			//Remove the newly created wanpipe files but keep wanrouter.rc so that no errors show up
			shell_exec("rm -f /etc/wanpipe/wanpipe*.conf");
		}

		$location = $this->conf_smg_path . "/freetdm_backup/freetdm.conf";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{
			$smg_backup = "mv " . $this->conf_smg_path . "/freetdm_backup/freetdm.conf " . $this->conf_smg_path . "/";
			shell_exec ($smg_backup);	
		}

		$location = $this->conf_smg_path . "/freetdm_backup/freetdm.conf.xml";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{		
			$smg_backup = "mv " . $this->conf_smg_path . "/freetdm_backup/freetdm.conf.xml " . $this->conf_smg_path . "/autoload_configs/";
			shell_exec ($smg_backup);	
		}
		
		$location = $this->conf_smg_path . "/freetdm_backup/sangoma_codec.conf.xml";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{		
			$smg_backup = "mv " . $this->conf_smg_path . "/freetdm_backup/sangoma_codec.conf.xml " . $this->conf_smg_path . "/autoload_configs/";
			shell_exec ($smg_backup);	
		}
		
		$location = $this->conf_smg_path . "/freetdm_backup/sngtc_server.conf.xml";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{
			$smg_backup = "cp " . $this->conf_smg_path . "/freetdm_backup/sngtc_server.conf.xml /etc/sngtc/";
			shell_exec ($smg_backup);	
		}
		
		$location = $this->conf_smg_path . "/freetdm_backup/ifcfg-*";
		$value = $this->check_for_file($location);

		if ($value == "yes")
		{		
			$interface_restore = "mv " . $this->conf_smg_path . "/freetdm_backup/ifcfg-* /etc/sysconfig/network-scripts/";
			shell_exec($interface_restore);
		}
	}
	
	//Places all the cards
	function create_wanpipe_devices()
	{
		//require('wanpipe_prod.php');
		
		$wanpipe = new wanpipe_prod;
		
		$wanpipe->line_type = $this->line_type;
		
		$wanpipe->freetdm("start");
		
		$span = 1;
		$port = 1;
		
		$num_a116 = count($this->a116);
		//echo "Number of A116 = " . $num_a116 . "\n";
		$counting = 0;
		if ($num_a116 != 0)
		{
			//echo $num_a108;
			do
			{
				$counting++;
				//echo $this->a108count . "\n";
				for ($a = 1; $a <= 8; $a++)
				{
					//echo "counter = $a, span = $span, Card stuff = " . $this->a116[$counting]->pci_slot . " " . $this->a116[$counting]->echo . "\n";
					//print_r ($this->a116[$counting]);
					//echo "<br />";
					//Create Wanpipe Device
					$wanpipe->A10x_template($span, $port, $this->a116[$counting]->pci_slot, $this->a116[$counting]->pci_bus, $this->a116[$counting]->echo, $this->a116[$counting]->device_name);			
					$wanpipe->freetdm("card");
										
					$this->translate[$span]['name'] = "A116";
					$this->translate[$span]['port'] = $port;
					$this->translate[$span]['card_num'] = $counting;
					$this->translate[$span]['pci_slot'] = $this->a116[$counting]->pci_slot;
					$this->translate[$span]['pci_bus'] = $this->a116[$counting]->pci_bus;					
					$this->translate[$span]['echo'] = $this->a116[$counting]->echo;							
										
					if ($port == 8)
						$port = 1;
					elseif ($port != 8)
						$port++;
					
					$span++;
				}
				//echo $counting . "\n";
			}while($counting != $num_a116);
		}			
		
		
		$num_a108 = count($this->a108);
		//echo "Number of A108 = " . $num_a108 . "\n";
		$counting = 0;
		if ($num_a108 != 0)
		{
			//echo $num_a108;
			do
			{
				$counting++;
				//echo $this->a108count . "\n";
				for ($a = 1; $a <= 8; $a++)
				{
					//echo "counter = $a, span = $span, Card stuff = " . $this->a108[$counting]->pci_slot . " " . $this->a108[$counting]->echo . "\n";
					//Create Wanpipe Device
					$wanpipe->A10x_template($span, $port, $this->a108[$counting]->pci_slot, $this->a108[$counting]->pci_bus, $this->a108[$counting]->echo, $this->a108[$counting]->device_name);			
					$wanpipe->freetdm("card");
										
					$this->translate[$span]['name'] = "A108";
					$this->translate[$span]['port'] = $port;
					$this->translate[$span]['card_num'] = $counting;
					$this->translate[$span]['pci_slot'] = $this->a108[$counting]->pci_slot;
					$this->translate[$span]['pci_bus'] = $this->a108[$counting]->pci_bus;					
					$this->translate[$span]['echo'] = $this->a108[$counting]->echo;							
										
					if ($port == 8)
						$port = 1;
					elseif ($port != 8)
						$port++;
				
					$span++;
				}
				//echo $counting . "\n";
			}while($counting != $num_a108);
		}	
			
		$port = 1;
		$num_a104 = count($this->a104);
		$counting = 0;
		
		if ($num_a104 != 0 )
		{
			do
			{	
				$counting++;	
				for ($a = 1; $a <= 4; $a++)
				{			
					//Create Wanpipe Device
					$wanpipe->A10x_template($span, $port, $this->a104[$counting]->pci_slot, $this->a104[$counting]->pci_bus, $this->a104[$counting]->echo, $this->a104[$counting]->device_name);			
					$wanpipe->freetdm("card");
										
					$this->translate[$span]['name'] = "A104";
					$this->translate[$span]['port'] = $port;
					$this->translate[$span]['card_num'] = $counting;
					$this->translate[$span]['pci_slot'] = $this->a104[$counting]->pci_slot;
					$this->translate[$span]['pci_bus'] = $this->a104[$counting]->pci_bus;					
					$this->translate[$span]['echo'] = $this->a104[$counting]->echo;							
					
					$span++;
					if ($port == 4)
						$port = 1;
					elseif ($port != 4)
						$port++;
				}
				
			}while($counting != $num_a104);		
		}		
		
		$port = 1;	
		$num_a102 = count($this->a102);
		$counting = 0;			
		if ($num_a102 != 0)
		{
			do
			{	
				$counting++;
				for ($a = 1; $a <= 2; $a++)
				{
					//Create Wanpipe Device
					$wanpipe->A10x_template($span, $port, $this->a102[$counting]->pci_slot, $this->a102[$counting]->pci_bus, $this->a102[$counting]->echo, $this->a102[$counting]->device_name);			
					$wanpipe->freetdm("card");
					
					$this->translate[$span]['name'] = "A102";
					$this->translate[$span]['port'] = $port;
					$this->translate[$span]['card_num'] = $counting;
					$this->translate[$span]['pci_slot'] = $this->a102[$counting]->pci_slot;
					$this->translate[$span]['pci_bus'] = $this->a102[$counting]->pci_bus;					
					$this->translate[$span]['echo'] = $this->a102[$counting]->echo;							
					
					$span++;
					if ($port == 3)
						$port = 1;
					elseif ($port != 4)
						$port++;
				}
			}while($counting != $num_a102);	
		}		
		
		
		$num_a101 = count($this->a101);
		$counting = 0;
		if ($num_a101 != 0)
		{
			do
			{	
				$counting++;
				for ($a = 1; $a <= 1; $a++)
				{
					//echo "i am here\n";
					$port = 1;
					//Create Wanpipe Device
					$wanpipe->A10x_template($span, $port, $this->a101[$a]->pci_slot, $this->a101[$a]->pci_bus, $this->a101[$a]->echo, $this->a101[$a]->device_name);
					$wanpipe->freetdm("card");

					$this->translate[$span]['name'] = "A101";
					$this->translate[$span]['port'] = $port;
					$this->translate[$span]['card_num'] = $counting;
					$this->translate[$span]['pci_slot'] =  $this->a101[$a]->pci_slot;
					$this->translate[$span]['pci_bus'] = $this->a101[$a]->pci_bus;					
					$this->translate[$span]['echo'] = $this->a101[$a]->echo;
					
					$span++;
				}
			}while($counting != $num_a101);	
		}				
		
		
		//Calculation of the total A10x spans
		$this->total_span = $span - 1;
		
		//build wanrouter.rc string
		//Loops to figure out all the wanpipeX.conf to include in the wanrouter.rc file
		for ($l = 1; $l < $span; $l++)
			$wanpipes = $wanpipes . "wanpipe$l ";

		//echo $wanpipes . "\n";
		//Generates the wanrouter.rc file to use
		$this->wanrouter_rc($wanpipes);		
		
		//Move freetdm.conf to smg path
		$ftdm_move = "mv freetdm.conf " . $this->conf_smg_path . "/";
		shell_exec ($ftdm_move);		
	}
	
	//Create New wanrouter.rc file
	function wanrouter_rc($wanpipe)
	{
		$file_name = "../wanrouter.rc";
		shell_exec ("cp ../wanrouter.rc.template ../wanrouter.rc");		
		$filehandle = fopen($file_name, 'a') or die("can't open file");

		$file = "WAN_DEVICES=\"" . $wanpipe . "\"";

		fwrite($filehandle, $file);
		fclose($filehandle);
		
		shell_exec ("cp ../wanrouter.rc /etc/wanpipe/wanrouter.rc");	
	}	


	function get_mp_info()
    {
		exec("/sbin/ifconfig -a | grep eth | cut -d: -f1 | awk '{ print $1}'", $name_1);
		exec("/sbin/ifconfig -a | grep __tmp | cut -d: -f1 | awk '{ print $1}'", $name_2);
		
		for ($a = 0; $a < count($name_1); $a ++)
		{
			$command = "/sbin/ifconfig " . $name_1[$a] . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			$command_2 = "/sbin/ifconfig " . $name_1[$a] . " | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'";
			exec($command, $name_1_ip_addr);
			exec($command_2, $name_1_mac);

			if ($name_1_ip_addr[$a] == "")
			{
				$name_1_ip_addr[$a] = "";
			}
			if ($name_1_mask[$a] == "")
			{
				$name_1_mask[$a] = "";
			}
			if ( $name_1_mac[$a] == "")
			{
				 $name_1_mac[$a] = "";
			}
			//echo "$a = " . $name_1[$a] . " IP " . $name_1_ip_addr[$a] . " MAC " . $name_1_mac[$a] . " MASK " . $name_1_mask[$a] . "<br />";
			
		}
		for ($a = 0; $a < count($name_2); $a ++)
		{
			$command = "/sbin/ifconfig " . $name_2[$a] . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			$command_2 = "/sbin/ifconfig " . $name_2[$a] . " | grep -o -E '([[:xdigit:]]{1,2}:){5}[[:xdigit:]]{1,2}'";
			exec($command, $name_2_ip_addr);
			exec($command_2, $name_2_mac);
			if ($name_2_ip_addr[$a] == "")
			{
				$name_2_ip_addr[$a] = "";
			}
			if ($name_2_mask[$a] == "")
			{
				$name_2_mask[$a] = "";
			}
			if ( $name_2_mac[$a] == "")
			{
				 $name_2_mac[$a] = "";
			}
		}
		
		$this->counter = count($name_1) + count($name_2);
		//echo "Counter = " . $this->counter . "\n";
		for ($b = 0; $b < count($name_1); $b++)
		{
			$this->legacy_names[$b] = $name_1[$b];
			$this->array_name[$b] = $name_1[$b];
			$this->array_mac[$b] = $name_1_mac[$b];
			$this->array_ip_addr[$b] = $name_1_ip_addr[$b];
		}
		for ($c = 0; $c < count($name_2); $c++)
		{
			$this->legacy_names[$b] = $name_2[$c];
			//echo "Name = " . $this->legacy_names[$c] . "\n";
			//$this->array_name[$b] = "eth" . $c;
			$this->array_name[$b] = $name_2[$c];
			$this->array_mac[$b] = $name_2_mac[$c];
			$this->array_ip_addr[$b] = $name_2_ip_addr[$c];
			$b++;
		}
	}

	//Compare the first 3 elements of the mac address to find whether it is a sangoma mac address
	function compare_mac($mac_addr)
	{
		//tokenize the mac address
		$tok = strtok($mac_addr, ":");
	
		$count = 0;
		
		while ($tok !== false) {
			$token[$count] = $tok;
			
			//Stores the tokens in an array to be parsed
			$token_values[$total_token] = $token[$count];			
		    $tok = strtok(":");
			$count++;
			$total_token++;
		}
		
		if ($token[0] == "02")
		{
			if ($token[1] == "19")
			{
				if ($token[2] == "23")
				{
					$this->is_sangoma = "YES";
				}
				else
				{
					$this->is_sangoma = "NO";
				}
			}
			else
			{
				$this->is_sangoma = "NO";
			}
		}
		else
		{
			$this->is_sangoma = "NO";
		}	
	}	

	//runs the media processing bert test
	function run_sngmp_bert($a)
	{
		if (is_numeric($a))
		{
			//Find out how many transcoding channels there are on the card
			$cmd = "/usr/sbin/sngtc_tool -dev " . $this->mp_cards[$a] . " -list_modules | grep Capacity | cut -d'=' -f4";
			exec ($cmd, $sessions);
			
			$this->tc_sessions[$a] = $sessions[0];
			
			$command = "/sbin/ifconfig " . $this->mp_cards[$a] . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			exec ($command, $output);
			
			$bert_command = $this->main_smg_path . "/usr/bin/sngtc_client -bert -timeout 30 -bindip " . $output[0] . " -sessions " . $sessions[0];
			system ($bert_command, $bert_output);
			
			//system ("rm -fr temp");
		}
		else
		{
			//Find out how many transcoding channels there are on the card
			$cmd = "/usr/sbin/sngtc_tool -dev " . $a . " -list_modules | grep Capacity | cut -d'=' -f4";
			exec ($cmd, $sessions);
			
			$this->tc_sessions[$a] = $sessions[0];
			
			$command = "/sbin/ifconfig " . $a . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			exec ($command, $output);
			
			$bert_command = $this->main_smg_path . "/usr/bin/sngtc_client -bert -timeout 30 -bindip " . $output[0] . " -sessions " . $sessions[0];
			system ($bert_command, $bert_output);			
		}
		//print_r ($bert_output);
		
		return $bert_output;
	}

	//Generates the ifcfg files required
	function ifcfg()
	{
		for ($b = 0; $b < count($this->mp_cards); $b++)
		{
			//Use this only if using a RedHat Install (CentOS, Fedora, RHEL)
			$file_name = "ifcfg-" . $this->mp_cards[$b];
			$filehandle = fopen($file_name, 'w') or die("can't open file");		
	
	
			$ifcfg = "#Sangoma D-Series Card Networking Configuration\nDEVICE=" . $this->mp_cards[$b] . "\nBOOTPROTO=static\nIPADDR=10.$b.100.1\nNETMASK=255.255.255.0\nHWADDR=" . $this->mp_mac[$b] . "\nONBOOT=yes\nUSERCTL=no\n";
	
			//close the file
			fwrite($filehandle, $ifcfg);
			fclose($filehandle);
	
			//Moves the created file to the required place.
			//Specific to RedHat Distributions
			$cmd = "mv " . $file_name . " /etc/sysconfig/network-scripts/" . $file_name;				
			exec($cmd);
			exec("echo \$?", $output);
			
			if ($output[0] > 0)
			{
				$this->ifcfg_error[$b] == "error";
			}
			
		}
	}

	//Bring Media Processing Interface up for testing
	function interface_up($a)
	{
		if (is_numeric($a))
		{
			$command = "/sbin/ifconfig " . $this->mp_cards[$a] . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			exec ($command, $output);
			
			if ($output[0] == "")
			{
				$command = "/sbin/ifconfig " . $this->mp_cards[$a] . " 10.$a.100.1 netmask 255.255.255.0";
				//echo $command . "\n";
				exec($command);
			}
			
			$command = "/sbin/ifconfig " . $this->mp_cards[$a] . " up";
			//echo $command . "\n";
			exec($command);
			sleep(5);	
		}
		else
		{
			$command = "/sbin/ifconfig " . $a . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
			exec ($command, $output);
			
			if ($output[0] == "")
			{
				$command = "/sbin/ifconfig " . $a . " 10.100.100.1 netmask 255.255.255.0";
				//echo $command . "\n";
				exec($command);
			}
			
			$command = "/sbin/ifconfig " . $a . " up";
			//echo $command . "\n";
			exec($command);
			sleep(5);				
		}
	}



	//Generate sngtc_server.conf
	function sngtc_server_file()
	{
		//open a file
		$file_name = "sngtc_server.conf.xml";		
		$filehandle = fopen($file_name, 'w') or die("can't open file");		

		$xml =	"<configuration name=\"sngtc_server.conf\" description=\"Sangoma Transcoding Manager Configuration\">\n";
		//$xml .= "\t<settings>\n";
		//$xml.="\t\t<param name=\"bindaddr\" value=\"0.0.0.0\" />\n\t\t<param name=\"bindport\" value=\"9000\" />\n";
		//$xml.= "\t</settings>\n";
		$xml.= "\t<vocallos>\n";
		
		//Enter each vocallo entry
		//For loop for all the entries
		for ($a = 0; $a <= count($this->mp_cards); $a++)
		{
			//echo "interface = " . $info['interface'] . "<br />";
			if ($this->mp_cards[$a] != "")
			{
				$xml .="\n\t\t<vocallo name=\"" . $this->mp_cards[$a] . "\">\n\t\t\t<param name=\"base_udp\" value=\"5000\"/>\n\t\t\t<param name=\"base_ip_octet\" value=\"150\"/>\n\t\t</vocallo>\n";
			}
		}
	
		$xml.= "\n\t</vocallos>\n</configuration>\n";

		//close the file
		fwrite($filehandle, $xml);
		fclose($filehandle);
		
		//Moves the created file to the required place.
		$cmd = "mv " . $file_name . " /etc/sngtc/" . $file_name;	
		//echo $cmd;			
		exec($cmd);
		exec("echo \$?", $output);
		
		if ($output[0] > 0)
		{
			$this->sngtc_error == "error";
		}		
	}

	//Places TDM ports in digital loopback mode
	function digital_loopback($a)
	{
		$command = "wanpipemon -i w" . $a . "g1 -c Tadlb";
		//echo $command . "\n";
		exec ($command);
		//sleep(2);
	}

	//Places TDM ports in mpd mode
	function mpd($a)
	{
		$command = "wan_ec_client wanpipe" . $a . " mpd all";
		//echo $command . "\n";
		exec($command);
	}
	
	//Disables the echo canceler on all TDM Ports
	function bypass_disable($a)
	{
		$command = "wan_ec_client wanpipe" . $a . " bd";
		exec ($command);
	}

	//Runs the HDLC Test for TDM Cards
	function hdlc_test()
	{
		//Create span string
		for ($a = 1; $a <= $this->total_span; $a++)
		{
			if ($a == 1)
				$string = "$a ";
			elseif ($a == 32) {
				//NSG only supports hdlc_test for up to 32 spans
				$string .="$a";
				break;
			}				
			elseif ($a != $this->total_span)
				$string .= "$a ";
			elseif ($a == $this->total_span)
				$string .="$a";
		}

		$tdm_hdlc_test_path = $this->main_smg_path . "/bin/tdm_hdlc_test.sh";
		$test_command =  $tdm_hdlc_test_path . " \"" . $string . "\" \"all\"";
		//echo $test_command . "\n";
		$output = array();
	
		//change current directories (script need to be called from it's directory).
		$cwd = getcwd();
		chdir(dirname($tdm_hdlc_test_path));
		
		//Launch hdlc test script
		exec ($test_command, $output);
		chdir($cwd);

		return $output;
	}
	
	//Searches wanrouter status for the Connected state
	function wanrouter_connected()
	{
		//echo $this->num_spans . "\n";
		$starttime = time();
		$endtime = $starttime + 45;
		
		do
		{
			$cmd = "/usr/sbin/wanrouter status | grep -c \"Connected\"";
			$output = shell_exec ($cmd);
			//echo $output . "\n";
			
			$currenttime = time();
			
			if ($currenttime >= $endtime)
				$exit = "true";
			else
				$exit = "false";

			if ($output != $this->num_spans && $exit != "true")
				$continue = "true";
			else
				$continue = "false";
		}
		while ($continue == "true");
		
		//echo "exit status = $exit, Number of spans = " . $this->num_spans . ", Output = $output.\n";
		
		//Exit the script if there is a connection issue.
		if ($exit == "true" && $output != $this->num_spans)
		{
			echo "An <font color='red'>ERROR</font> has occured while trying to run the TDM Self Test.\n";
			echo "Restoring Configuration Files\n";
			echo "Self Test <font color='red'>FAILED</font>\n";
			$this->wanrouter("stop");
			$this->restore();
			exit(2);
		}
		
		//echo "TDM Ports now in Connected State\n";
	}

	//Appends the failed output to the file
	function append_file($array)
	{
		$file = $this->main_smg_path . "/nginx/html/php/production-test/output.txt";
		$fp = fopen($file, "a");
		
		for ($ii = 0; $ii < count($array); $ii++)  
			fputs($fp, $array[$ii] . "\n");
		
		fclose ($fp);		
	}

	//Function that prepares files to send and archives them all together.
	function files_to_send()
	{		
		//Kernel Information
		$output = array("\nKernel Information", "");
		$this->append_file($output);
	
		exec ("uname -r\n", $kernel);
		$this->append_file($kernel);
		
		exec ("uname -a\n",$all);
		$this->append_file($all);
		
		//Last 1000 lines of /var/log/messages
		$output = array("\n\n/var/log/messages file", "");
		$this->append_file($output);
		
		exec ("tail -n 1000 /var/log/messages",$messages);
		$this->append_file($messages);
		
		//Last 1000 lines of /usr/local/nsg/logs/sangomagw.log
		$log = $this->main_smg_path . "/log/sangomagw.log";
		if (file_exists($this->main_smg_path . "/log/sangomagw.log"))
		{
			$output = array("\n\nGateway Log File", "");
			$this->append_file($output);
			
			$cmd = "tail -n 1000 " . $this->main_smg_path . "/log/sangomagw.log";
			//echo $cmd;
			exec ($cmd,$gateway);
			$this->append_file($gateway);
		}
		//wanrouter hwprobe verbose
		$output = array("\n\nTDM Driver Information", "");
		$this->append_file($output);
		
		exec ("/usr/sbin/wanrouter hwprobe verbose",$hwprobe);
		$this->append_file($hwprobe);
	
		//wanrouter version
		exec ("/usr/sbin/wanrouter version",$version);
		$this->append_file($version);

		if (file_exists("/var/log/sngtc_server.log"))
		{
			//Last 1000 lines of /var/log/sngtc_server.log
			$output = array("\nMedia Processing Log Files", "");
			$this->append_file($output);
			
			exec ("tail -n 1000 /var/log/sngtc_server.log",$sngtc_server);
			$this->append_file($sngtc_server);
		}
		
		//change current directories (script need to be called from it's directory).
		$path = $this->main_smg_path . "/nginx/html/php/production-test";
		$cwd = getcwd();
		//echo $cwd;
		chdir($path);
	
		//tar the folder
		//$tar = "tar czf " . $this->main_smg_path . "/nginx/html/php/production-test/SangomaOutput.tgz " . $this->main_smg_path . "/nginx/html/php/production-test/output.txt";
		$cmd = "mkdir -p logs";
		shell_exec($cmd);
		$cmd = "cp output.txt logs/logfiles.txt";
		shell_exec ($cmd);
		
		//nsg configuration logs
		$cmd = "mkdir -p logs/gw_conf";
		shell_exec ($cmd);
		$cmd = "cp -fr " . $this->main_smg_path . "/conf logs/gw_conf";
		shell_exec($cmd);
		$cmd = "rm logs/gw_conf/conf/license.txt.sig";
		shell_exec($cmd);
		
		//Wanpipe configs
		$cmd = "mkdir -p logs/wanpipe";
		shell_exec($cmd);
		$cmd = "cp -fr /etc/wanpipe/wanpipe*.conf logs/wanpipe/";
		shell_exec($cmd);
		
		//sngtc logs
		$cmd = "mkdir -p logs/sngtc";
		shell_exec($cmd);
		$cmd = "cp -fr /etc/sngtc logs/";
		shell_exec($cmd);
		
		//Network Scripts
		$cmd = "mkdir -p logs/network-scripts";
		shell_exec($cmd);
		$cmd = "cp -fr /etc/sysconfig/network-scripts/* logs/network-scripts";
		shell_exec($cmd);
		
		//SSI Logs
		$cmd = "mkdir -p logs/ssi_logs";
		shell_exec($cmd);
		$cmd = "cp -fr /tmp/sngtc-*-ssi.bin logs/ssi_logs/";
    	shell_exec($cmd);
		
		//Get common logs
		$cmd= "mkdir -p logs/logs";
		shell_exec($cmd);
		$cmd = "cp /var/log/messages logs/logs";
		shell_exec($cmd);
		$cmd = "cp /var/log/wanrouter logs/logs";
		shell_exec($cmd);
		$cmd = "cp /var/log/sngtc_server.log logs/logs";
		shell_exec($cmd);
		$cmd = "cp " . $this->main_smg_path . "/log/sangomagw.log logs/logs";
		shell_exec ($cmd);
		
		//Create backtrace file
		exec('/usr/local/sng/bin/sng-dbg-backtrace');
		$cmd = "mkdir -p logs/backtrace";
		shell_exec($cmd);
		$cmd = "cp " .$this->main_smg_path . "/bin/backtrace.txt logs/backtrace/";
		shell_exec($cmd);
    
		//get license file
		shell_exec('mkdir -p logs/license');
		shell_exec('cp -fr /usr/local/nsg/conf/license.txt logs/license/');
	
		//get route and vlan start scripts
		shell_exec('mkdir -p logs/networking-scripts');
		shell_exec ('cp -fr /usr/local/sng/bin/sng-vlan-start logs/networking-scripts');
		shell_exec('cp -fr /usr/local/sng/bin/sng-route-start logs/networking-scripts');

		//Tar up logs directory
		#$tar = "tar czf sangoma-nsg-debug-" . date('Y-m-d') . ".tgz logs";
		$tar = "tar czf SangomaOutput.tgz logs";
		//echo $tar . "\n";
		shell_exec($tar);

		//Remove the file
		$cmd = "rm -f " . $this->main_smg_path . "/nginx/html/php/production-test/output.txt";	
		shell_exec($cmd);
		$cmd = "rm -fr logs";
		shell_exec($cmd);
		$cmd = "rm -fr logfiles.txt";
		shell_exec($cmd);
		chdir($cwd);
	}

	function find_vocallo_firmware($a)
	{
		//Find transcoding cards in system
		$this->compare_mac($this->array_mac[$a]);
		//echo $this->legacy_names[$a] . "\n";
		//echo $this->is_sangoma . "\n";
		//echo $this->array_ip_addr[$a] . "\n";
		$count++;
		
		//Firmware version Check
		$cmd = "/usr/sbin/sngtc_tool -firmware_version | grep 'Vocallo' | cut -d\":\" -f2 | cut -d\" \" -f3";
		exec ($cmd,$voc_firm); 
			
		if ($this->is_sangoma == "YES" && $this->array_ip_addr[$a] != "")
		{
			//Use the IP Address of that device and find out the firmware using sngtc_tool
			$cmd = "/usr/sbin/sngtc_tool -dev " . $this->legacy_names[$a] . " -list_modules | grep Ver | cut -d\"=\" -f3 | cut -d\" \" -f1";
			//echo $cmd;
			exec ($cmd,$output);
			//echo $output[0] . "\n";
			
			//Firmware version Check
			$cmd = "/usr/sbin/sngtc_tool -firmware_version | grep 'Vocallo' | cut -d\":\" -f2 | cut -d\" \" -f3";
			exec ($cmd,$voc_firm); 
			
			if ($output[0] != $voc_firm[0])
			{
				echo "Media Device " . $this->legacy_names[$a] . " Firmware Version = <b><font color='red'>" . $output[0] . " OUT OF DATE</font></b>\n";
				$firmware = "yes";
			}
			else
				echo "Media Device " . $this->legacy_names[$a] . " Firmware Version = " . $output[0] . "\n";
		}
		elseif ($this->is_sangoma == "YES" && $this->array_ip_addr[$a] == "")
		{
			$command = "/sbin/ifconfig " . $this->legacy_names[$a] . " 10.$count.100.1 netmask 255.255.255.0 >> /dev/null";
			//echo $command . "\n";
			exec($command);
			
			$command = "/sbin/ifconfig " . $this->legacy_names[$a] . " up";
			exec($command);
			
			//Use the IP Address of that device and find out the firmware using sngtc_tool
			$cmd = "/usr/sbin/sngtc_tool -dev " . $this->legacy_names[$a] . " -list_modules | grep Ver | cut -d\"=\" -f3 | cut -d\" \" -f1";
			//echo $cmd;
			exec ($cmd,$output);
			//echo $output[0] . "\n";
			if ($output[0] != $voc_firm[0])
			{
				echo "Media Device " . $this->legacy_names[$a] . " Firmware Version = <b><font color='red'>" . $output[0] . " OUT OF DATE</font></b>\n";
				$firmware = "yes";
			}
			else
				echo "Media Device " . $this->legacy_names[$a] . " Firmware Version = " . $output[0] . "\n";
			
			$command = "/sbin/ifconfig " . $a . " down >> /dev/null 2>&1";
			exec($command);
		}
		
		return $firmware;
	}
	
	//Tokenizes the HDLC test output
	function token_name($string)
	{
		$tok = strtok($string, "=");

		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
			$tok = strtok("=");
			$count++;
		}
	
		return $token[1];
	}

}


?>
