<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class view_megaco_profiles_class
{
	
	//Variable declarations
	private $counter = int;					//Contains the total number of profiles
	private $profile_array = array();		//Contains the Analog Profiles in an array	
	public $total_ports = int;				//Contains the total number of ports for the card in question
	public $conn_type = "";					//Contains the connection type for the port
	
	//Database variables
	public $table_name = 'mg_profiles';								//Contains table name of megaco profile
	public $db_location = 'sqlite:../sqlite/cardinfo.db';			//Contains database location
	
	//Function that retrieves the BRI profiles from the database and stores it in a multi-dimensional array
	function get_profiles()
	{
		$where_param = "";
		$a = 0;

		$select = "SELECT id, name, ip_addr, port, protocol FROM " . $this->table_name . ";";
		try
		{
			//open the database
			$db = new PDO($this->db_location);

			$result = $db->query($select);

			if (count($result) >= 1) {
				foreach($result as $row)
				{
					$this->profile_array[$a] = $row;
					$a++;
				}
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
			echo "Database location = " . $this->db_location . ", table = " . $this->table_name . "<br />";
			echo "SQL Select statement = $select<br />";
		}

		$this->counter = $a;
	}
	
	function display_profiles($data)
	{
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
			require_once '../display_class.php';
	
		//Check if mg_config in sync
		require_once '../sng_config_manager_functions.php';
		$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
		if (mg_check($notif,'','sqlite:../sqlite/cardinfo.db'))
			$notif->add('Media Gateway','Please proceed to the <a href="../sng_config_manager.php" >Apply Configuration</a> Page');
			
		$notif->display();
		unset($notif);
?>	
		<br />
		<form name="view" method="post">
    	
    	<table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Media Gateway Profiles</th>
            <tr>
    		<td class="mytableheader ">Name</td>
            <td class="mytableheader ">Protocol Type</td>
            <td class="mytableheader ">IP Address</td>
    	    <td class="mytableheader ">Port</td>
			<td class="mytableheader "></td>
            </tr>
            
		<?php
		
		for ($b = 0; $b < $this->counter; $b++)
		{
			echo "<tr>\n";
			if ($_SESSION['last_profile'] == $this->profile_array[$b]['name'])
			{
				echo "<td><b>" . $this->profile_array[$b]['name'] . "</b></td>\n";
			}
			else
			{
				echo "<td>" . $this->profile_array[$b]['name'] . "</td>\n";
			}
			echo "<td>" . strtoupper($this->profile_array[$b]['protocol']) . "</td>\n";
			echo "<td>" . $this->profile_array[$b]['ip_addr'] . "</td>\n";
			echo "<td>" . $this->profile_array[$b]['port'] . "</td>\n";
	
			echo "<td align=\"right\">\n";		
			echo "<input type=\"submit\" name=\"config" . $this->profile_array[$b]['id'] . "\" value=\"Edit Profile\" " . $_SESSION['button_class'] . "/>\n";
			echo "<input type=\"submit\" name=\"delete" . $this->profile_array[$b]['id'] . "\" value=\"Delete Profile\" " . $_SESSION['button_class'] . "/>\n";
			echo "</td>\n";

			echo "<tr>\n";
			$num_entries++;
			
		}
		?>
		     <tr>
            	<td align='center' colspan="5" class="widget-content-header ui-state-active ui-corner-bottom"><input type='submit' name='create' value='Add New Profile' <?php echo $_SESSION['button_class'];?> /></td>
            </tr>
		</table>
	</form>        

		<?php
		//Puts the number of entries in the database into a session variable
		$_SESSION['num_entries'] = $num_entries;
	}
	
	/**
	* Checks the db for the mg_profile table. If it doesn't find it, it will create the table
	* @param: $data
	*			database object
	* @param: $table
	*			mg profile table name
	*/
	public function db_table_check($data,$table){
		$check = $data->check_for_table($this->db_location,$table);
		//Create table if not found
		if ($check < 2)
		{
			$parameters = "id integer primary key, name varchar(100), ip_addr varchar(100), port varchar(100), protocol varchar(100), domain varchar(100), mid varchar(100), rtp_port_min int, rtp_port_max int, term_prefix varchar(100), term_id_len varchar(100), megaco_version varchar(100), default_codec varchar(100), rtp_ip varchar(100), t38 varchar(100)";
			$data->create_table($this->db_location, $table, $parameters);
		}
		else {
			//Check if all columns are in the table
			$insert_parameters = 'id,name,ip_addr,port,protocol,domain,mid,rtp_port_min,rtp_port_max,term_prefix,term_id_len,megaco_version,default_codec,rtp_ip';
			$parameters = "id integer primary key, name varchar(100), ip_addr varchar(100), port varchar(100), protocol varchar(100), domain varchar(100), mid varchar(100), rtp_port_min int, rtp_port_max int, term_prefix varchar(100), term_id_len varchar(100), megaco_version varchar(100), default_codec varchar(100), rtp_ip varchar(100), t38 varchar(100)";
			$data->check_schema($this->db_location, $table, $parameters, "15", $insert_parameters);	
		}
	}
	
	/**
	* Checks if a row exists in the database
	* @param: $data
	*			database object
	* @param: $table
	*			mg profile table name
	* @return boolean	
	*/
	public function check_for_row($data,$table) {
		$row_exists = $data->array_select_statement($this->db_location, $table, "count(*)",'');

		if ($row_exists[0]['count(*)']> 0)
			return true;
		else
			return false;
	}
	
	
	/**
	* Displays the deletion confirmation box
	* @param: $data
	*			database object
	*/
	public function display_delete($data) {
		$profile_name = $data->select_statement($this->db_location,$this->table_name,"name","id = " . $_SESSION['delete_id']);
		$notif = new NotificationBox( 'Error', NotificationBox::Error );
		$notif->add("", "Removing the Profile <b>" . $profile_name['name'] . "</b> will remove all associate peers." );
		$notif->add("", "Click <b>REMOVE</b> to continue." );
		echo $notif->getHtml();		
		unset($notif);	
		?>
        <br />
		<form name="remove_profile" method="post">  		   
	    <input type="hidden" name="id_number" value="<?php echo $a; ?>" />
    	<table class="mytable" width='100%'>
        	<th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Media Gateway Profile Configuration</th> 
    		<tr>
				<td class="mytablesubheader" width='50%'>Profile marked for Removal</td>
				<td align="left" width='50%'><b><?=$profile_name['name']?></b></td>
			</tr>
            <tr>
            	<td class="mytablesubheader" width='50%'></td>
                <td>
                <input type="submit" name="delete" value='Remove'  <?php echo $_SESSION['button_class']; ?>/>
                <input type="submit" name="cancel" value="Cancel" <?php echo $_SESSION['button_class']; ?>/>
                </td>
            </tr>
        </table>
	</form>
	<?php
	}
}

?>
