<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Session
session_start();

//echo $_SESSION['cic'];
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{	
	//PHP Includes
	include 'create_megaco_profile_class.php';
	include '../database_classes.php';
	
	//PHP Class Constructor
	$data = new database_class;
	$megaco_profile = new create_megaco_profile;
		
	//Check the database. If the database exists, use that information to display
	$db_location = "sqlite:../sqlite/cardinfo.db";
	$table_name = "mg_profiles";
	$table_exists = $data->check_for_table ($db_location, $table_name);

	$proceed = false;
	$update_data = false;
	$delete_confirm = false;
	$peer_update_data = false;
	$add_peer = false;
	$error_profile = false;

	if ($_REQUEST['create_mg'] == "Create Media Gateway Profile"){
		//Validate profile name
		$megaco_profile->validation();
				
		//if succeed, proceed to profile properties
		if ($megaco_profile->error_counter == 0) {
			//insert profile name into database
			$param = 'name';
			$value = '"' . $_REQUEST['name'] . '"';
			$data->insert_statement($db_location,$table_name,$param,$value);
			
			//Get ID from database and store it
			$id = $data->select_statement($db_location,$table_name,'id','name="' . $_REQUEST['name'] . '"');
			$_SESSION['id_num'] = $id['id'];
			$update_data = true;
		}
		else {
			$error_profile = true;
		}
	}
	if ($_REQUEST['create_peer'] == "Create Peer")
	{
		//Validate profile name
		$megaco_profile->validation();	
		
		//if succeed, proceed to profile properties
		if ($megaco_profile->error_counter == 0) {
			//check if peer table exists
			$table = $_SESSION['profile_name'] . '_peers';
			$check = $data->check_for_table($db_location,$table);
			
			if ($check < 2) {
					$parameters = "id integer primary key, name varchar(100), ip_addr varchar(100), port varchar(100), protocol varchar(100), mid varchar(100), encoding_scheme varchar(30), domain varchar(30)";
					$data->create_table($db_location, $_REQUEST['profile_name'] . '_peers', $parameters);
			}
			else {
				//check if table needs to be updated
				$parameters = "id integer primary key, name varchar(100), ip_addr varchar(100), port varchar(100), protocol varchar(100), mid varchar(100), encoding_scheme varchar(30), domain varchar(30)";
				$insert_parameters = "id,name,ip_addr,port,protocol,mid,encoding_scheme";
				$data->check_schema($db_location, $_REQUEST['mg_profile'].'_peers', $parameters, "8", $insert_parameters);	
			}
			
			//insert profile name into database
			$param = 'name';
			$value = '"' . $_SESSION['profile_name'] . '_' . $_REQUEST['peer_name'] . '"';
			$data->insert_statement($db_location,$table,$param,$value);
			
			//Get ID from database and store it
			$id = $data->select_statement($db_location,$table,'id','name="' . $_SESSION['profile_name'] .'_' . $_REQUEST['peer_name'] . '"');
			$_SESSION['peer_id_num'] = $id['id'];
			$peer_update_data = true;
		}
		else
			$add_peer = true;
	}
	if ($_REQUEST['update_gw'] == "Update Media Gateway Profile")
	{
		//Validate Information
		$megaco_profile->validation();

		//Insert into database
		if ($megaco_profile->error_counter == 0) {
			$where_param = "name=\"" . $_REQUEST['profile_name'] . "\"";
			$param = "ip_addr = \"" . $_REQUEST['ip_addr'] . "\", port = \"" . $_REQUEST['port'] . "\", \"domain\" = \"" . $_REQUEST['domain'] . "\", mid = '" . $_POST['mid'] . "', term_prefix = \"" . $_REQUEST['term_prefix'] . "\", protocol = \"" . $_REQUEST['protocol'] . "\", megaco_version = \"" . $_REQUEST['megaco_version'] . "\", default_codec=\"" . $_REQUEST['default_codec'] . "\", rtp_ip =\"" . $_REQUEST['rtp_ip'] . "\", t38 = \"" . $_REQUEST['t38'] . "\"";
			$data->update_table($db_location,$table_name,$param,$where_param);
			
			//Create Peer Table
			$parameters = "id integer primary key, name varchar(100), ip_addr varchar(100), port varchar(100), protocol varchar(100), mid varchar(100), encoding_scheme varchar(30)";
			$data->create_table($db_location, $_REQUEST['profile_name'] . '_peers', $parameters);
			
			$proceed = true;
		}
		else
			$update_data = true;
	}
	if ($_REQUEST['update_peer'] == "Update")
	{
		//Validate Information
		$megaco_profile->validation();

		if ($megaco_profile->error_counter == 0) {
			$table = $_SESSION['profile_name'] . "_peers";
			$where_param = "name=\"" . $_REQUEST['profile_name'] . "\"";
			$param = "ip_addr = \"" . $_REQUEST['ip_addr'] . "\", port = \"" . $_REQUEST['port'] . "\", mid = '" . $_REQUEST['mid'] . "', protocol = \"" . $_REQUEST['transport_protocol'] . "\", encoding_scheme=\"" . $_REQUEST['encoding_scheme'] . "\", \"domain\"=\"".$_REQUEST['domain'] . "\"";
			$data->update_table($db_location,$table,$param,$where_param);
			
			$proceed = true;
		}
		else
			$peer_update_data = true;
	}
	
	if ($_REQUEST['delete_peer'] == "Remove") {
		$param = "id = " . $_SESSION['delete_id'];
		$table = $_SESSION['profile_name'] . "_peers";
			
		$data->delete_generic($db_location, $table, $param);
		$_SESSION['delete_id'] = "";
		$proceed = true;
	}
	
	if ($_REQUEST['cancel'] == "Cancel Configuration")
	{
		$_SESSION['id_num'] = "";

		//Redirects to viewing all profiles page
		header( 'Location:mg_config.php' ) ;		
		
	}
	if ($_REQUEST['cancel_peer'] == "Cancel")
		$proceed = true;
	if ($_REQUEST['cancel_peer_update'] == "Cancel")
		$proceed = true;
	if ($_REQUEST['cancel_peer_removal'] == "Cancel")
		$proceed = true;
	if ($_REQUEST['cancel_update'] == "Cancel Update")
		$proceed = true;

		
	//Goes through the request variables and checks what was clicked on
	if ($_REQUEST) {
		foreach ($_REQUEST as $key => $value)
		{	
			$exists = $data->check_for_table ($db_location, $megaco_table);
			
			for ($x = 0; $x <= $num_entries+100; $x++)
			{
				//Checks to see which Delete button was pressed
				if ($key == "delete_peer$x" && $value == "Delete Peer")
				{
					//Display confirmation box for deletion of object from db
					$_SESSION['delete_id'] = $x;
					$delete_confirm = true;
				}
				if ($key == "config_peer$x" && $value == "Edit Peer")
				{
					//Takes the last value in the key to know the database ID number clicked
					$rest = substr($key, -1);
					
					//Sets the ID number into a session variable to go to the redirection and edit the profile
					$_SESSION['peer_id_num'] = $rest;
					$peer_update_data = true;
				}
			}
		}
	}

	if (!$_SESSION['edit_mg'] && !$proceed && !$update_data && !$add_peer && !$delete_confirm && !$_SESSION['no_profile'] && !$peer_update_data && !isset($_REQUEST['edit_profile']) && $_REQUEST['new_peer'] != "Add Peer" && !$error_profile)
		header( 'Location:mg_config.php' );
		
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		include '../display_class.php';
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Media Gateway Configuration", "../../../style.css","");		
	}	
	
	//display dependant on whether creating of updating
	if ($_SESSION['edit_mg'] || $proceed || $_REQUEST['cancel'] == "Cancel Update") {
		unset($_REQUEST);
		$megaco_profile->aggregated_view($data);	
		$_SESSION['edit_mg'] = "";	
	}
	elseif ($_REQUEST['edit_profile'] || $update_data)
		$megaco_profile->display($data);
	elseif ($_REQUEST['new_peer'] == "Add Peer" || $add_peer)
		$megaco_profile->create_peer($data);
	elseif ($peer_update_data)
		$megaco_profile->edit_peer($data);
	elseif ($delete_confirm)
		$megaco_profile->display_delete($data);
	elseif ($_SESSION['no_profile'] || $error_profile) {
		$megaco_profile->create_profile_name($data);
		$_SESSION['no_profile'] = false;
	}

	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		if ($megaco_profile->edit['rtp_ip'] == "")
			$display_common->html_footer(true);
		else
			$display_common->html_footer();	
	}
}
else
{
	header( 'Location:../index.php' ) ;
}
?>
