<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();
//Checks to make sure the user is logged into the WebUI
if (empty($_POST))
	include '../check_referer.php';

$_SESSION['ping'] = "";
$_SESSION['ssh_status'] = "";

include 'transcoding_class.php';
include '../database_classes.php';
include '../display_class.php';
include "../production-test/prod-test-class.php";

$transcode = new transcoding_class;
$transcode->data = new database_class;
$transcode->db_location = "sqlite:../sqlite/cardinfo.db";
$display_common = new Display_common;

if  (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
	//Includes required for ClearOS Integration
	include '../sqlite/database_creation.php';
	
	$_SESSION['embedded'] = "true";
	
	//ClearOS Integration
	$display_common->session_vars("sqlite:../sqlite/cardinfo.db");	
}	

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	$transcode->get_info();
	$transcode->get_codecs();

	//Decide which setup type to display
	$bind_table = "transcode_bind";
	$codec_table = "transcode_user_codecs";
	$table_name = "transcode_setup";
	
	//Check for the codec table, if it exists, run the select statement
	$table_exist = $transcode->data->check_for_table($transcode->db_location,$codec_table);
	if ($table_exist > 1)
		$codec = $transcode->data->select_statement($transcode->db_location, $codec_table, "codec_syntax", "id = 1");

	$table_exist = $transcode->data->check_for_table($transcode->db_location,$bind_table);
	if ($table_exist > 1)
		$bind = $transcode->data->select_statement($transcode->db_location, $bind_table, "bind_addr", "id = 1");				
	
	$table_exist = $transcode->data->check_for_table($transcode->db_location,$table_name);
	if ($table_exist > 1)
		$type = $transcode->data->select_statement($transcode->db_location, $table_name, "setup", "id = 1");

	if ($_REQUEST['single'] == "Local Setup")
		$_SESSION['transcoder_session'] = "single";
	elseif ($_REQUEST['distributed'] == "LAN Setup")
		$_SESSION['transcoder_session'] = "distributed";
	elseif (!isset($_SESSION['transcoder_session']))
	{
		if ($type['setup'] == "distributed")
			$_SESSION['transcoder_session'] = "distributed";
		elseif ($type['setup'] == "single")
			$_SESSION['transcoder_session'] = "single";
		else
			$_SESSION['transcoder_session'] = "single";
	}
	
	//echo $_SESSION['transcoder_session'];	
	
	//Compare the values. Use the database values, if database values don't exist, use ifconfig values
	for ($a = 0; $a < $transcode->counter; $a ++)
	{
		$table_name = "transcode";
		$where_param = "id = $a";
		$exist[$a] = $transcode->data->select_statement($transcode->db_location, $table_name, "*", $where_param);
		
		$transcode->find_values($exist, $a);
	}

	if ($_REQUEST['install'] == "Generate Configuration")
	{
		if ($_REQUEST['bind_addr'] != "" || $_REQUEST['bind_port'] != "")
		{
			if (!preg_match('/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/',$_REQUEST['bind_addr']))
			{
				$bind_error = "IP Address entered is not a valid IPv4 Address";
				$no_configure = "yes";
			}

			if (!is_numeric($_REQUEST['bind_port']))
			{
				$port_error = "Port Number must be a numeric value";
				$no_configure = "yes";
			}
		}
		
		$transcode->update_codec_table();	
	}
	
	//If the save button was pressed to save codecs
	if ($_REQUEST['save_codec_list'] == "Save")
	{
		$transcode->update_codec_table();			
	}

    //Goes through the request variables and checks what was clicked on
	foreach ($_REQUEST as $key => $value)
	{	
	
		//echo "key = $key and value= $value<br />";
		for ($a = 0; $a < $transcode->counter; $a ++)
		{			
			//if ($key == "accept$a" && $value == "USE")
			if ($key == "scan$a" && $value == "SCAN")
			{	
				//Validate the IP Address
				if (!preg_match('/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/',$transcode->array_ip_addr[$a]))
				{
					$error_ip[$a] = "yes";
					$ip_error = "<font color=\"red\">Please correct the IP Address for " . $transcode->array_name[$a] . "</font>";
				}
				else
				{
					$error_ip[$a] = "";
				}
				//Validate the Subnet Mask
				if (!preg_match('/^(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)(?:[.](?:25[0-5]|2[0-4]\d|1\d\d|[1-9]\d|\d)){3}$/', $transcode->array_mask[$a]))
				{
					$error_mask[$a] = "yes";
					$mask_error = "<font color=\"red\">Please correct the Subnet Mask for " . $transcode->array_name[$a] . "</font>";
				}
				else
				{
					$error_mask[$a] = "";
				}
				
				//If both pass, proceed to configuration
				if ($error_ip[$a] == "" && $error_mask[$a] == "")
				{
					//Only do this if it is a sangoma device	
					//Enter the IP Address and Subnet Mask into the linux system and bring that interface up
					$transcode->compare_mac($transcode->array_mac[$a]);
					
					if ($transcode->is_sangoma == "YES")
					{
						//echo "IP = " . $transcode->array_ip_addr[$a] . "<br />";
						if ($transcode->array_ip_addr[$a] == "")
						{
							$transcode->array_ip_addr[$a] = "0.0.0.0";
						}
						//$command = "/sbin/ifconfig " . $transcode->array_name[$a] . " down";
						//echo $command . "<br />";
						//exec($command);
						$command = "/sbin/ifconfig " . $transcode->legacy_names[$a] . " " . $transcode->array_ip_addr[$a] . " netmask " . $transcode->array_mask[$a];
						//echo $command . "<br />";
						exec($command);
						$command = "/sbin/ifconfig " . $transcode->legacy_names[$a] . " up";
						//echo $command . "<br />";
						exec($command);
						sleep(10);
					}
					
					//Scan for modules
					$command = "/usr/sbin/sngtc_tool -dev '" . $transcode->legacy_names[$a] . "' -list_modules | grep 'MAC' -c";
					//echo $command . "<br />";
					exec ($command, $sngtc);
	
					if (count($sngtc) > 0)
					{
						//echo "i am here<br />";
						$transcode->num_modules[$a] = $sngtc[0];
						
						if ($transcode->num_modules[$a] != 0)
						{
							//Place in database
							$transcode->initial_database($a, $sngtc[0]);
						}
						$_SESSION['proceed'] = "yes";
						
						header( 'Location:transcoding.php' ) ;	
					}
					else
					{
						//There is an error
						$error_modules[$a] = "<font color=\"red\">ERROR</font>";
						$table_name = "transcode";
						$where = "interface = \"" . $transcode->array_name[$a] . "\"";
						$transcode->data->delete_generic($transcode->db_location, $table_name, $where);
					}
				}
			}
			if ($key == "accept$a" && $value="USE")
			{
				//IP Nibble entered
				//Place nibble in database
				$transcode->update_nibble($a);
				
			}
			if ($key == "delete$a" && $value == "Remove")
			{
				$transcode->compare_mac($transcode->array_mac[$a]);
				
				if ($transcode->is_sangoma == "YES")
				{
					$command = "/sbin/ifconfig " . $transcode->legacy_names[$a] . " down";
					shell_exec($command);
				}
				
				//Removes the ifcfg file for that ethernet address
				$cmd = "rm /etc/sysconfig/network-scripts/ifcfg-" . $transcode->legacy_names[$a];
				exec ($cmd);
				$cmd = "rm /etc/sysconfig/network-scripts/ifcfg-" . $transcode->array_name[$a];
				exec ($cmd);
				
				
				$table_name = "transcode";
				$where = "interface = \"" . $transcode->array_name[$a] . "\"";

				$transcode->data->delete_generic($transcode->db_location, $table_name, $where);
				header( 'Location:transcoding.php' ) ;	
			}
		}
	}
	
	
	
	//MAIN PAGE
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif  (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{	
		$_SESSION['embedded'] = "true";
		
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		
		$display_common->html_title("Media Processing Configuration", "../../../style.css","");		
	}	
	
	//Gets all the codecs from the database
	$info = $transcode->get_codecs_database();
	$codec_used = count($info);
	
	//Check if media processing in sync
	require_once '../sng_config_manager_functions.php';
	$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
	if (transcode_check($notif,$transcode->data,$transcode->db_location))
		$notif->add('Media Processing','Please proceed to the <a href="../sng_config_manager.php" >Apply Configuration</a> Page');
		
	$notif->display();
	unset($notif);
	
  if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
  {
    //Go through the array and make sure there is at least 1 sangoma interface
    for ($a = 0; $a < $transcode->counter; $a ++)
    {
      $transcode->compare_mac($transcode->array_mac[$a]);
      $temp_array[$a] = $transcode->is_sangoma;
    }
    
    $DisplayCodec = 0;
    for ($b = 0; $b < count($temp_array); $b++)
    {
      //echo "array = " . $temp_array[$b] . "<br />";
      if ($temp_array[$b] == "YES")
      {
        $DisplayCodec = 1;
        break;
      }
    }
  }
  else
  {
    // Display selection in any case
    $DisplayCodec = 1;
  }

	//echo "Transcoding Session = " . $_SESSION['transcoder_session'] . "<br />";	
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
	?>
    <h2>MEDIA PROCESSING</h2>

	<hr style='width:700px;' align='left'/>
    
    <h4>Media Processing Configuration</h4>
    <form method="post">
    	<p>
        	Please specify whether the Media Processing will be done on this local server or done by a server on the Local Area Network (LAN)
        </p>
        <input type="submit" name="single" value="Local Setup" <?php echo $_SESSION['tc_button_class']; ?> />

        <input type="submit" name="distributed" value="LAN Setup" <?php echo $_SESSION['tc_button_class']; ?> />
        <br />
        <hr style='width:700px;' align='left'/>
    <?php
  }
  if ( 1 == $DisplayCodec ) 
  {
	?>        
        <br />
        Please select the codecs that will be used with <?php echo $_SESSION['name'] ; ?>:<br /><br />
	<?php
  }	
		//Distributed Setup
		if ($_REQUEST['distributed'] == "LAN Setup" || $_SESSION['transcoder_session'] == "distributed")
		{
			$_SESSION['transcoder_session'] = "distributed";
	?>

	<?php 
	if ( 1 == $DisplayCodec ) 
	{
	?>
        <table class="mytable">
        	<th class="widget-content-header ui-state-active ui-corner-top" colspan="12" align="left">Codec List</th>
        	
	<?php
		echo "<tr>\n";
		
		for ($l = 1; $l <= count($transcode->codec_array); $l++)
		{
			//echo $transcode->codec_array[$l] . "<br />";
			if ($transcode->codec_array[$l] == "PCMA" || $transcode->codec_array[$l] == "PCMU" || $transcode->codec_array[$l] == "L16")
			{
			}
			else
			{
				$modulus = $l % 6;
				$hash = "codec$l";
				echo "<td>\n<input type=\"checkbox\" name=\"codec$l\" value=\"" . $transcode->codec_array[$l] . "\"";
				for ($u = 0; $u < $codec_used; $u++)
				{
					if ($_REQUEST[$hash] == $transcode->codec_array[$l] || $info[$u] == $transcode->codec_array[$l] )
					{						
						 echo " checked=\"checked\" ";
					}			
				}
				echo "/>\n</td>\n";
				echo "<td align=\"left\">" . $transcode->codec_names[$l] . "</td>\n";
	
				if ($modulus == 0)
				{
					echo "</tr>\n<tr>\n";
				}
				
				$counter++;
			}
		}
	
	?> 
 		<tr>
           	<td align='center' colspan="12" class="widget-content-header ui-state-active ui-corner-bottom"><input type="submit" name="save_codec_list" value="Save" <?php echo $_SESSION['button_class']; ?> /></td>
        </tr> 
    	</table>
    <?php
	}
	?>
        <br />      
    
        If media processing server is not on the local machine, please specify the IP Address and the Port Number of the Media Processing Server:
        
        <table>
        	<tr>
            	<td>Address:</td>
                <td><input type="text" name="bind_addr" value="<?php echo $transcode->bind_addr; ?>" style="text-align:right"/></td>
                <td><font color="red"><?php echo $bind_error ?></font></td>
           </tr>
           <tr>
           		<td>Port:</td>
                <td><input type="text" name="bind_port" value="<?php echo $transcode->bind_port; ?>" style="text-align:right"/></td>
                <td><font color="red"><?php echo $port_error ?></font></td>
           </tr>
       	</table>
    	<br />
    	<input type="submit" name="install" value="Generate Configuration" <?php echo $_SESSION['tc_button_class']; ?>/>         
        <br />	
     <?php
        }	
		
		
		//Local Setup		
		elseif ($_REQUEST['single'] == "Local Setup" || $_SESSION['transcoder_session'] == "single")
		{
			$_SESSION['transcoder_session'] = "single";
	?>    
    <form method="post">
    
<?php if ( 1 == $DisplayCodec ) {?>
        <table class="mytable">
        	<th class="widget-content-header ui-state-active ui-corner-top" colspan="12" align="left">Codec List</th>
        	
	<?php
		echo "<tr>\n";
		
		for ($l = 1; $l <= count($transcode->codec_array); $l++)
		{
			//echo $transcode->codec_array[$l] . "<br />";
			if ($transcode->codec_array[$l] == "PCMA" || $transcode->codec_array[$l] == "PCMU" || $transcode->codec_array[$l] == "L16")
			{
			}
			else
			{
				$modulus = $l % 6;
				$hash = "codec$l";
				echo "<td>\n<input type=\"checkbox\" name=\"codec$l\" value=\"" . $transcode->codec_array[$l] . "\"";
				for ($u = 0; $u < $codec_used; $u++)
				{
					if ($_REQUEST[$hash] == $transcode->codec_array[$l] || $info[$u] == $transcode->codec_array[$l] )
					{						
						 echo " checked=\"checked\" ";
					}			
				}
				echo "/>\n</td>\n";
				echo "<td align=\"left\">" . $transcode->codec_names[$l] . "</td>\n";
	
				if ($modulus == 0)
				{
					echo "</tr>\n<tr>\n";
				}
				
				$counter++;
			}
		}
	
?>
        </tr>
		<tr>
           	<td align='center' colspan="12" class="widget-content-header ui-state-active ui-corner-bottom"><input type="submit" name="save_codec_list" value="Save" <?php echo $_SESSION['button_class']; ?> /></td>
        </tr>        
    	</table>
      
<?php
}
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			echo "<p>\n";
        	echo "To configure media processing, please select the appropriate interface.<br />\n
            	  Please note that if your interfaces are not listed, you will have to build the media processing drivers.\n";
			echo "</p>\n";
		}

		//Go through the array and make sure there is at least 1 sangoma interface
		for ($a = 0; $a < $transcode->counter; $a ++)
		{
			$transcode->compare_mac($transcode->array_mac[$a]);
			$temp_array[$a] = $transcode->is_sangoma;
		}
		
		for ($b = 0; $b < count($temp_array); $b++)
		{
			//echo "array = " . $temp_array[$b] . "<br />";
			if ($temp_array[$b] == "YES")
			{
				$found = 1;
			}
			//echo $found . "<br />";
		}
				
				if ( (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])) && $found == "")
				{
					//No Modules Found
					$display_common->WarningBox( "No Media Processing Interfaces Found" );
       			}
				elseif (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']) && $found == "")
				{
		?>
        <br />
       	To configure media processing, please select the appropriate interface.<br />
        <br />           
    	<table class="mytable">
        	<th align="left" class="widget-content-header ui-state-active ui-corner-top" colspan="10">Interface Configuration</th>
            <tr align="center">
   	 		<td class="mytableheader ui-state-active">Interface</td>
        	<td class="mytableheader ui-state-active">IP Address</td>
        	<td class="mytableheader ui-state-active">Subnet Mask</td>
        	<td class="mytableheader ui-state-active">Sangoma Device?</td>
        	<td class="mytableheader ui-state-active">Scan</td>
        	<td class="mytableheader ui-state-active">Modules Detected</td>
        	<td class="mytableheader ui-state-active">4th Octet of IP</td>
            <td class="mytableheader ui-state-active">Use</td>
            <td class="mytableheader ui-state-active">Remove</td>
            </tr>
        <?php					
				}
				elseif ($found == 1)
				{
					if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
					{				
		?>   
		<br />
		<div class="fakelink"
			id="show_e"
			onclick="this.style.display='none';
			document.getElementById('hide_e').style.display='block';
			document.getElementById('options').style.display='inline';
            ResizeFrame();
			">&raquo; Show Advanced Options</div>
		<div class="fakelink"
			id="hide_e"
			onclick="this.style.display='none';
			document.getElementById('show_e').style.display='block';
			document.getElementById('options').style.display='none';
            ResizeFrame();
			">&raquo; Hide Advanced Options</div>
		<div id="options">
        <?php
					}
		?>
        <br />
       	To configure media processing, please select the appropriate interface.<br />
        <br />           
    	<table class="mytable">
        	<th align="left" class="widget-content-header ui-state-active ui-corner-top" colspan="10">Interface Configuration</th>
            <tr align="center">
   	 		<td class="mytableheader ui-state-active">Interface</td>
        	<td class="mytableheader ui-state-active">IP Address</td>
        	<td class="mytableheader ui-state-active">Subnet Mask</td>
        	<td class="mytableheader ui-state-active">Sangoma Device?</td>
        	<td class="mytableheader ui-state-active">Scan</td>
        	<td class="mytableheader ui-state-active">Modules Detected</td>
            <?php /*
        	<td class="mytableheader ui-state-active">4th Octet of IP</td>
            <td class="mytableheader ui-state-active">Use</td>
			*/ ?>
            <td class="mytableheader ui-state-active">Remove</td>
            </tr>
        <?php 
				}
			
			for ($a = 0; $a < $transcode->counter; $a ++)
			{
				$transcode->compare_mac($transcode->array_mac[$a]);
				if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
				{
					//Only display sangoma interfaces
					if ($transcode->is_sangoma == "YES")
					{
						echo "<tr align=\"center\">\n";
						if (isset($error_modules[$a]))
						{
							echo "<td><font color=\"red\">" . $transcode->array_name[$a] . "</font><br />" . $error_modules[$a] . "</td>\n";
						}
						else
						{
							echo "<td>" . $transcode->array_name[$a] . "<br /></td>\n";
						}	
										
						if ($error_ip[$a] == "yes")
						{
							echo "<td><input type=\"text\" name=\"ip_addr_" . $a . "\" value=\"" . $transcode->array_ip_addr[$a] . "\" style=\"text-align:right;color:red\" /></td>\n";
						}
						else
						{
							echo "<td><input type=\"text\" name=\"ip_addr_" . $a . "\" value=\"" . $transcode->array_ip_addr[$a] . "\" style=\"text-align:right\" /></td>\n";						
						}
							
						if ($error_mask[$a] == "yes")
						{					
							echo "<td><input type=\"text\" name=\"netmask" . $a . "\" value=\"" . $transcode->array_mask[$a] . "\" style=\"text-align:right; color:red\" /></td>\n";
						}
						else
						{
							echo "<td><input type=\"text\" name=\"netmask" . $a . "\" value=\"" . $transcode->array_mask[$a] . "\" style=\"text-align:right\" /></td>\n";
						}	
						echo "<td>" . $transcode->is_sangoma . "</td>\n";	
		?>
			        <td><input type="submit" name="scan<?php echo $a; ?>" value="SCAN" <?php echo $_SESSION['tc_button_class']; ?> style="text-align:right;" /></td>
		<?php
						if ($exist[$a]['id'] != "")
						{
		?>                    
            		<td><?php echo $transcode->num_modules[$a]; ?></td>
        <?php
							if ($transcode->num_modules[$a] != 0)
							{
		?>      
            		<?php //<td><input type="text" name="nibble<?php echo $a; " value="<?php echo $transcode->array_nibble[$a]; " style="text-align:right; width: 50px"/></td>
                    
            		//<td><input type="submit" name="accept echo $a; " value="USE"  echo $_SESSION['tc_button_class'];  style="text-align:right;" /></td>
                    ?>
					<td><input type="submit" name="delete<?php echo $a; ?>" value="Remove" <?php echo $_SESSION['tc_button_class']; ?> style="text-align:right;" /></td>
        <?php        			
							}
						}
						else
						{
		?>                    
            		<td</td>
            		<td</td>
            		<td</td>
                    <td</td>
                    <td</td>
        <?php        			
						}
			   			echo "</tr>\n";											
					}					
				}
				elseif (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
				{
					
					//display all interfaces
			    	echo "<tr align=\"center\">\n";
					if (isset($error_modules[$a]))
					{
						echo "<td><font color=\"red\">" . $transcode->array_name[$a] . "</font><br />" . $error_modules[$a] . "</td>\n";
					}
					else
					{
						echo "<td>" . $transcode->array_name[$a] . "<br /></td>\n";
					}
					if ($transcode->is_sangoma == "YES")
					{
						if ($error_ip[$a] == "yes")
						{
							echo "<td><input type=\"text\" name=\"ip_addr_" . $a . "\" value=\"" . $transcode->array_ip_addr[$a] . "\" style=\"text-align:right;color:red\" /></td>\n";
						}
						else
						{
							echo "<td><input type=\"text\" name=\"ip_addr_" . $a . "\" value=\"" . $transcode->array_ip_addr[$a] . "\" style=\"text-align:right\" /></td>\n";						
						}
						
						if ($error_mask[$a] == "yes")
						{					
							echo "<td><input type=\"text\" name=\"netmask" . $a . "\" value=\"" . $transcode->array_mask[$a] . "\" style=\"text-align:right; color:red\" /></td>\n";
						}
						else
						{
							echo "<td><input type=\"text\" name=\"netmask" . $a . "\" value=\"" . $transcode->array_mask[$a] . "\" style=\"text-align:right\" /></td>\n";
						}					
					}
					elseif ($transcode->is_sangoma == "NO")
					{
						echo "<td><input type=\"text\" name=\"ip_addr_" . $a . "\" value=\"" . $transcode->array_ip_addr[$a] . "\" style=\"text-align:right;background-color: grey\" /></td>\n";
						echo "<td><input type=\"text\" name=\"netmask" . $a . "\" value=\"" . $transcode->array_mask[$a] . "\" style=\"text-align:right;background-color: grey\" /></td>\n";
					}
				
					echo "<td>" . $transcode->is_sangoma . "</td>\n";	
		?>
			        <td><input type="submit" name="scan<?php echo $a; ?>" value="SCAN" <?php echo $_SESSION['tc_button_class']; ?> /></td>
		<?php
					if ($exist[$a]['id'] != "")
					{
		?>                    
            		<td><?php echo $transcode->num_modules[$a]; ?></td>
        <?php
						if ($transcode->num_modules[$a] != 0)
						{
		?>      
            		<td><input type="text" name="nibble<?php echo $a; ?>" value="<?php echo $transcode->array_nibble[$a]; ?>" style="text-align:right; width: 50px"/></td>
            		<td><input type="submit" name="accept<?php echo $a; ?>" value="USE" <?php echo $_SESSION['tc_button_class']; ?> /></td>
                    <td><input type="submit" name="delete<?php echo $a; ?>" value="Remove" <?php echo $_SESSION['tc_button_class']; ?> /></td>
        <?php        			
						}
					}
					else
					{
		?>                    
            		<td></td>
            		<td></td>
            		<td></td>
                    <td></td>
                    <td></td>
        <?php        			
					}
			   		echo "</tr>\n";
				}
			}
			?>
		</table> 
        <?php
        if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		{				
		?> 
		</div>
        <?php
		}
		?>
        <br />
        	<?php			
		
			if (isset($ip_error) || isset($mask_error))
			{
				echo "<h4>ERRORS</h4>";
			}
			if (isset($ip_error))
			{
				echo "<b>$ip_error</b><br />";
			}
			if (isset($mask_error))
			{
				echo "<b>$mask_error</b>";
			}
			if (isset($ip_error) || isset($mask_error))
			{
				echo "<br />";
			}
							
		?>
    	<br />
		<?php
		//Does not show build tools if in embedded mode
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
		?>
        <hr style='width:700px;' align='left'/>
        <h4>Media Processing Driver Build Tool</h4>

		<p>
        	This portion of the installer builds the required drivers needed to operate the D-Series hardware within the system.<br />
            This is optional, as most systems already have the required media processing modules installed.<br /><br />
			<font color="red">NOTE: If you choose to build the media processing drivers and you have Broadcom NetExtreme or Micrel Ethernet Drivers loaded on your system,<br />
            you WILL lose network connectivity, which also can result in the loss of connection to the Gateway Web Server</font>            
        </p>
    	<input type="submit" name="build" value="Build Ethernet Drivers" <?php echo $_SESSION['tc_button_class']; ?> /> 
		<?php
		}
	}
	//REQUST PROCESSING
	
	
	//Performs the Ethernet Driver Build
	if ($_REQUEST['build'] == "Build Media Processing Drivers")
	{
	?>
    <hr style='width:700px;' align='left'/>
    <h3>Installation Status</h3>
    <table>
    	<th>Process</th>
        <th>Status</th>
        <tr>
            <td>Removing old Drivers</td>
            <?php
			exec ("lsmod | grep tg3 | cut -d' ' -f1", $output);
			if ($output[0] == "tg3")
			{
				$tg3 = "install";
			}
			exec ("lsmod | grep ks8842_pci | cut -d ' ' -f1", $output);
			if ($output[0] == "ks8842_pci")
			{
				$micrel = "install";
			}
			
			//echo "$tg3, $micrel";
			
			if ($tg3 == "install")
			{
				exec ("modprobe -r tg3");
				exec ("echo $?", $tg3_exit);
				if ($tg3_exit[0] != 0)
				{
					$tg3_error = "yes";
				}
			}
			if ($micrel == "install")
			{
				exec ("modprobe -r ks8842_pci");
				exec ("echo $?", $micrell_exit);
				if ($micrell_exit[0] != 0)
				{
					$micrell_error = "yes";
				}
			}
			
			if ($tg3_error == "yes" || $micrell_error == "yes")
			{
				?>
            <td width="100px" align="right"><font color="RED">ERROR</font></td>
            	<?php
				//Create Error Message
				//Failed to remove modules
			}
			else
			{
				?>
            <td width="100px" align="right"><font color="green">DONE</font></td>
         	   <?php
			   $continue = "yes";
			}
			?>
        </tr>   
        <?php
			if ($continue == "yes")
			{
		?>
        <tr> 
            <td>Installing Media Processing Drivers</td>        
            <?php
			
				//Clean out the directories
				$path = "cd " . $_SESSION['smg_root_path'] . "/src/tg3-3.112d && make clean";
				exec ($path);
				$path = "cd " . $_SESSION['smg_root_path'] . "/src/ks884x-linux-20090828 && make clean";
				exec ($path);
				$path = "cd " . $_SESSION['smg_root_path'] . "/src/ksz884x-1.0.13 && make clean";
				exec ($path);
				$path = "cd " . $_SESSION['smg_root_path'] . "/src && ". $_SESSION['smg_root_path'] . "/src/install.sh silent &> transcoder_install.txt";
				exec ($path, $install_output);
				
				/*echo "<pre>";
				for ($a = 0; $a < count($install_output); $a++)
				{
					echo "$install_output[$a]<br />";
				}
				echo "</pre>";*/
				
				exec ("echo \$?", $check_status);
				//echo $check_status[0];
				if ($check_status[0] == 0)
				{
					$cmd = "grep -E 'Error' -c " . $_SESSION['smg_root_path'] . "/src/transcoder_install.txt";
					exec ($cmd, $check);
					if ($check[0] == 0)
					{	
			?>
            <td width="100px" align="right"><font color="green">DONE</font></td>
            <?php
						$initialize_driver = "yes";
					}
					if ($check[0] > 0)
					{
						//Install script had errors in it	
			?>
            <td width="100px" align="right"><font color="red">ERROR</font></td>
            <?php
					}
					
					if ($initialize_driver = "yes")
					{					
			?>
        <tr>
            <td>Initializing Drivers</td>
            <?php
						exec ("lsmod | grep tg3 | cut -d' ' -f1", $output);
						if ($output[0] == "tg3")
						{
							$tg3 = "good";
						}
						else
						{
							$tg3 = "error";
						}
						
						exec ("lsmod | grep ks8842_pci | cut -d ' ' -f1", $micrel_output);
						//echo $micrel_output[0];
						if ($micrel_output[0] == "ks8842_pci")
						{
							$micrel = "good";
						}
						else
						{
							$micrel = "error";
						}
					
						if ($tg3 == "good" && $micrel == "good")
						{
			?>
            <td width="100px" align="right"><font color="green">DONE</font></td>
            <?php
							$complete = "yes";
						}
						else
						{
							//Could not bring the interfaces up
			?>
            <td width="100px" align="right"><font color="red">ERROR</font></td>
            <?php
							$interface = "error";
						}
			?>
            
        </tr>
        	<?php
					}				
				}
				else
				{
					//Install Script Failed to execute	
			?>
            <td width="100px" align="right"><font color="red">ERROR</font></td>
            <?php
					$install_script = "error";
				}
			?>
        </tr>
    </table>    

        <?php
				if ($complete == "yes")
				{
					$path = "rm -fr " . $_SESSION['smg_root_path'] . "/src/transcoder_install.txt";
					//exec ($path);
					echo "<p>
					Media Processing Drivers have now been built and loaded onto the system. You can now continue with your Media Processing configuration<br />
					</p>";
				}
				elseif ($interface == "error")
				{
					$body = "Dear Support;%0D%0AI am having trouble bringing up my media processing drivers using the Sangoma Media Gateway Media Processing Web Installation.%0D%0AAttached is the output from the media processing installation%0D%0ARegards";
					$file_location = $_SESSION['smg_root_path'] . "/nginx/html/php/installation/transcoder/transcoder_install.txt";
					
					echo "<p>
					There was an issue with your media processing driver installation. We were unable to bring the media processing interfaces up.<br />
					Please try re-installing the Media Processing drivers. If this issue occurs more then once, please download the file \"<a href=\"transcoder/transcoder_install.txt\" target=\"_blank\">Transcoder Install</a>\" and attach it with an email to \"<a href='mailto:techdesk@sangoma.com?subject=Cannont Compile Media Processing Drivers&body=$body&attachment=\"$file_location\"'>techdesk@sangoma.com</a>\"\".
					</p>";
				}
				elseif ($install_script == "error")
				{
					$body = "Dear Support;%0D%0AI am having trouble compiling my transcoding drivers using the Sangoma Media Gateway Transcoding Web Installation.%0D%0AAttached is the output from the transcoder installation%0D%0ARegards";
					$file_location = $_SESSION['smg_root_path'] . "/nginx/html/php/installation/transcoder/transcoder_install.txt";
					
					echo "<p>
					There was an issue with your transcoding driver installation. We were unable to install the transcoding drivers.<br />
					Please try re-installing the Transcoding drivers and make sure that the " . $_SESSION['smg_root_path'] . "/src exists. If this issue occurs more then once, please download the file \"<a href=\"transcoder/transcoder_install.txt\" target=\"_blank\">Transcoder Install</a>\" and attach with an email to \"<a href='mailto:techdesk@sangoma.com?subject=Cannont Compile Transcoding Drivers&body=$body&attachment=\"$file_location\"'>techdesk@sangoma.com</a>\"\".
					</p>";					
				}
			}
	}

	
	
	
	
	//INSTALL SNGTC
	if ($_REQUEST['install'] == "Generate Configuration" && $no_configure != "yes")
	{
		
		//Enter all the codecs requested into the database. Error out if no codecs were entered.
		
		foreach ($_REQUEST as $key => $value)
		{	
			//echo $key . "<br />";
			if (preg_match('/^codec[0-9]*/',$key))
			{
				$pass = "yes";
				//echo $pass . "<br />";
			}
		}
		
		//$pass = "no";
		if ($pass == "yes")
		{
			//Only show this for a distributed setup
			if($_SESSION['transcoder_session'] == "distributed")
			{
				//Check if the bind address and port are entered. If so, enter those values into the database
				if ($_REQUEST['bind_addr'] != "" && $_REQUEST['bind_port'] != "")
				{
					$table_name = "transcode_bind";
					
					$where = "1";
					$return = $transcode->data->select_statement($transcode->db_location, $table_name, "bind_addr", $where);
					
					//echo "id = " . $return['bind_addr'] . "<br />";
					
					if ($return['bind_addr'] != "")
					{
						//update the table
						$update_param = "bind_addr = \"" . $_REQUEST['bind_addr'] . "\", bind_port = \"" . $_REQUEST['bind_port'] . "\"";
						$transcode->data->update_table($transcode->db_location, $table_name, $update_param, $where);
					}
					elseif ($return['bind_addr'] == "")
					{
						//insert new data
						$insert_param = "id, bind_addr, bind_port";
						$insert_values = "1, \"" . $_REQUEST['bind_addr'] . "\", \"" . $_REQUEST['bind_port'] . "\"";
						$transcode->data->insert_statement($transcode->db_location, $table_name, $insert_param, $insert_values);
					}
				}
			 }
			 
			 //Checks for auto generation in embedded mode
			 //If database empty and there is a sangoma card, then auto populate table with default values and continue with generation
			 if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']) && $found == 1)
			 {
				 $transcode->auto_populate();
			 }
			 
			echo "<hr style='width:700px;' align='left'/>\n";
			echo "<h3>Media Processing Configuration Status</h3>\n";
		
			echo "<table class=\"mytable\">\n";
			echo "<th class=\"widget-content-header ui-state-active ui-corner-top\" colspan=\"2\" align=\"left\">Configuration Status</th>\n";
			echo "<tr>\n";
			echo "<td class=\"mytableheader ui-state-active\">Process</td>\n";
			echo "<td class=\"mytableheader  ui-state-active\">Status</td>\n";
			echo "</tr>\n";
			echo "<tr>\n";
	
			//Distributed setup
			if($_SESSION['transcoder_session'] == "distributed")
			{
				echo "<tr>\n";
				echo "<td>Generating Media Processing Configuration Files</td>\n";
				exec ("ls /etc/sngtc | grep 'sngtc_server.xml' -c",$sngtc_check);
				
				if ($sngtc_check[0] > 0)
				{
					exec ("mv /etc/sngtc/sngtc_server.xml /etc/sngtc/sngtc_server.xml.old");
				}		
				//Find the number of entries in the database table
				$transcode->num_entries();
			
				//Create /usr/local/smg/conf/autoload_configs/sangoma_codec.conf
				$transcode->sangoma_codec();
				
				//Not needed in a distributed setup
				if ($_SESSION['transcoder_session'] != "distributed")
				{
					//Create /etc/sngtc/sngtc_server.conf 
					$transcode->sngtc_server();
				}
				
				//$transcode->sangoma_codec_error = "error";
				//$transcode->sngtc_error = "error";
				
				if ($transcode->sangoma_codec_error == "error" && $transcode->sngtc_error == "error")
				{
					$check = 1;
				}
				elseif ($transcode->sangoma_codec_error == "error" || $transcode->sngtc_error == "error")
				{
					$check = 1;
				}
				else
				{
					$check = 0;
				}
			
				//Check if the file got created successfully
				if ($check == 0)
				{
					$transcode_complete = "yes";
					echo '<td width="100px" align="right"><font color="green">DONE</font></td>';
					echo "</tr>\n";
				}
				elseif ($check == 0 || $output[0] != 0)
				{
					$sngtc_script = "error";
					//Failed creating the sngtc.xml file
					echo '<td width="100px" align="right"><font color="red">ERROR</font></td>';
				}	
			}
			//Local Setup
			elseif ($_SESSION['transcoder_session'] != "distributed")
			{
				echo "<td>Generating Media Processing Driver Scripts</td>";
				
				//Create /etc/sysconfig/network_scripts file for internal transcoder cards selected
				$transcode->ifcfg();
				$zz = 0;
				do
				{
					if ($transcode->ifcfg_error[$zz] == "error")
					{
						$check = 1;
						break;
					}
					else
					{
						$check = 0;
					}
					$zz++;
				}while ($check = 0);
				
				//check completion
				if ($check == 0)
				{
					echo '<td width="100px" align="right"><font color="green">DONE</font></td>';
					echo "</tr>\n";
					echo "<tr>\n";
					echo "<td>Bringing Media Processing Interfaces Up</td>\n";
					
					//Bring up interfaces just created using ifup command
					$transcode->ifcfg();
					$zl = 0;
					do
					{
						if ($transcode->ifup_error[$zl] == "error")
						{
							$check = 1;
							break;
						}
						else
						{
							$check = 0;
						}
						$zl++;
					}while ($check = 0);				
					
					//Check Completion
					if ($check == 0)
					{
						echo '<td width="100px" align="right"><font color="green">DONE</font></td>';
						echo "</tr>\n";
						echo "<tr>\n";
						echo "<td>Generating Media Processor Configuration Files</td>\n";
						
						//Find the number of entries in the database table
						$transcode->num_entries();
	
						//Create /usr/local/smg/conf/autoload_configs/sangoma_codec.conf
						$transcode->sangoma_codec();
					
						//Create /etc/sngtc/sngtc_server.conf 
						$transcode->sngtc_server();
											
						if ($transcode->sangoma_codec_error == "error" && $transcode->sngtc_error == "error")
						{
							$check = 1;
						}
						elseif ($transcode->sangoma_codec_error == "error" || $transcode->sngtc_error == "error")
						{
							$check = 1;
						}
						else
						{
							$check = 0;
						}
	
						//Check if the file got created successfully
						if ($check == 0)
						{
							echo '<td width="100px" align="right"><font color="green">DONE</font></td>';
							$transcode_complete = "yes";
						}
						else
						{
							$sngtc_script = "error";
							//Failed creating the sngtc.xml file
							echo '<td width="100px" align="right"><font color="red">ERROR</font></td>';					
						}
					}
					else
					{
						$interface_up = "error";
						//Failed bringing up the interfaces
						echo '<td width="100px" align="right"><font color="red">ERROR</font></td>';					
					}	
				}
				else
				{
					$network_script = "error";
					//Failed creating the network script files
					echo '<td width="100px" align="right"><font color="red">ERROR</font></td>';					
				}
		 	}
		    echo "</tr>\n";
			echo "</table>\n";
		}
		
		//Successfully completed configuration
		if ($transcode_complete == "yes")
		{
			//Place the type of setup within the transcoding setup database
			$table_name = "transcode_setup";
				
			$where = "id = 1";
			$return = $transcode->data->select_statement($transcode->db_location, $table_name, "setup", $where);
				
			//echo "setup = " . $_SESSION['transcoder_session'] . "<br />";	
				
			if ($return['setup'] != "")
			{
				//update the table
				$update_param = "setup = \"" . $_SESSION['transcoder_session'] . "\"";
				$transcode->data->update_table($transcode->db_location, $table_name, $update_param, $where);
			}
			elseif ($return['setup'] == "")
			{
				//insert new data
				$insert_param = "id, setup";
				$insert_values = "1, \"" . $_SESSION['transcoder_session'] . "\"";
				$transcode->data->insert_statement($transcode->db_location, $table_name, $insert_param, $insert_values);
			}			
			$table = $transcode->data->check_for_table ($transcode->db_location, "perm_transcode_setup");
			if ($table > 0)
			{
				$transcode->data->drop_table($transcode->db_location, "perm_transcode_setup");
			}
			$transcode->data->select_into ($transcode->db_location, "transcode_setup", "*", "perm_transcode_setup");
    		
			//Create the generated transcoding interface table
			//Drop the generate table then re-create the generate table
			$table = $transcode->data->check_for_table ($transcode->db_location, "perm_transcode");
			if ($table > 0)
			{
				$transcode->data->drop_table($transcode->db_location, "perm_transcode");
			}
			$transcode->data->select_into ($transcode->db_location, "transcode", "*", "perm_transcode");

			$table = $transcode->data->check_for_table ($transcode->db_location, "perm_transcode_setup");
			if ($table > 0)
			{
				$transcode->data->drop_table($transcode->db_location, "perm_transcode_setup");
			}
			$transcode->data->select_into ($transcode->db_location, "transcode_setup", "*", "perm_transcode_setup");
			
			$table = $transcode->data->check_for_table ($transcode->db_location, "perm_transcode_user_codecs");
			if ($table > 0)
			{
				$transcode->data->drop_table($transcode->db_location, "perm_transcode_user_codecs");
			}
			$transcode->data->select_into ($transcode->db_location, "transcode_user_codecs", "*", "perm_transcode_user_codecs");
	
			$table = $transcode->data->check_for_table ($transcode->db_location, "perm_transcode_bind");
			if ($table > 0)
			{
				$transcode->data->drop_table($transcode->db_location, "perm_transcode_bind");
			}
			$transcode->data->select_into ($transcode->db_location, "transcode_bind", "*", "perm_transcode_bind");
						
			if ($_SESSION['transcoder_session'] == "distributed")
			{
	?>
    <p>
    	Media Processing configuration completed successfully.<br />
        Please proceed to the <a href="../controls_embedded.php">Control Panel</a> in order to start the Gateway.
    </p>				
    <?php
			}
			else
			{
	?> 
    <p>
    	Media Processing installation completed successfully and the Media Processing processes have been started.<br />
        Please proceed to the <a href="../controls_embedded.php">Control Panel</a> in order to start the Gateway.
    </p>
    <?php
			}
		}
		elseif ($interface_up == "error")
		{
			$body = "Dear Support;%0D%0AI am having trouble configuring my media processing cards using the Sangoma Media Gateway Media Processing Web Installation.%0D%0AThe media processing interfaces would not come up.%0D%0ARegards";
					
			echo "<p>
					There was an issue configuring your media processing interfaces. We were unable to bring the media processing interfaces up.<br />
					Please try re-configuring the Media Processing cards. If this issue occurs more then once, please send an email to \"<a href='mailto:techdesk@sangoma.com?subject=Cannont Configure Media Processing&body=$body&attachment=\"$file_location\"'>techdesk@sangoma.com</a>\"\".
				  </p>";			
		}
		elseif ($server_stop == "error")
		{
			$body = "Dear Support;%0D%0AI am having trouble configuring my media processing cards using the Sangoma Media Gateway Media Processing Web Installation.%0D%0AThe media processing service would not stop.%0D%0ARegards";
					
			echo "<p>
					There was an issue configuring your media processing interfaces. We were unable to stop the media processing service.<br />
					Please try re-configuring the Media Processing cards. If this issue occurs more then once, please send an email to \"<a href='mailto:techdesk@sangoma.com?subject=Cannont Configure Media Processing&body=$body&attachment=\"$file_location\"'>techdesk@sangoma.com</a>\"\".
				  </p>";				
		}
		elseif ($network_script == "error")
		{
			$body = "Dear Support;%0D%0AI am having trouble configuring my media processing cards using the Sangoma Media Gateway Media Processing Web Installation.%0D%0AThe media processing scripts are not being generated.%0D%0ARegards";
					
			echo "<p>
					There was an issue configuring your media processing interfaces. We were unable to configure the scripts required for media processing.<br />
					Please try re-configuring the Media Processing cards. If this issue occurs more then once, please send an email to \"<a href='mailto:techdesk@sangoma.com?subject=Cannont Configure Media Processing&body=$body&attachment=\"$file_location\"'>techdesk@sangoma.com</a>\"\".
				  </p>";			
		}
		elseif ($server_start == "error")
		{
			$body = "Dear Support;%0D%0AI am having trouble configuring my media processing cards using the Sangoma Media Gateway Media Processing Web Installation.%0D%0AThe media processing service would not start.%0D%0ARegards";
					
			echo "<p>
					There was an issue configuring your media processing interfaces. We were unable to start the media processing service.<br />
					Please try re-configuring the Media Processing cards. If this issue occurs more then once, please send an email to \"<a href='mailto:techdesk@sangoma.com?subject=Cannont Configure Media Processing&body=$body&attachment=\"$file_location\"'>techdesk@sangoma.com</a>\"\".
				  </p>";			
		}
		elseif ($sngtc_script == "error")
		{
			$body = "Dear Support;%0D%0AI am having trouble configuring my media processing cards using the Sangoma Media Gateway Media Processing Web Installation.%0D%0AThe media processing scripts are not being generated.%0D%0ARegards";
					
			echo "<p>
					There was an issue configuring your media processing interfaces. We were unable to configure the scripts required for media processing.<br />
					Please try re-configuring the Media Processing cards. If this issue occurs more then once, please send an email to \"<a href='mailto:techdesk@sangoma.com?subject=Cannont Configure Media Processing&body=$body&attachment=\"$file_location\"'>techdesk@sangoma.com</a>\"\".
				  </p>";				
		}
		elseif ($pass == "" || $pass == "no")
		{
			echo "<hr style='width:700px;' align='left'/>\n";
			echo "<h4>Media Processing Configuration Errors</h4>\n";
			echo "<p><font color=\"red\">Please select at least <b>1</b> codec in order to complete the Media Processing Configuration</font></p>\n";
		}
		
	}
	
	
	//CHECK OUT OF SYNC FOR MEDIA
	
	//Check if sngtc is running
/*	exec ("pidof sngtc_server",$output);
	
	//Checks if transcoding is enabled or disabled
	$mediaObj = new prod_test();
	$mediaObj->find_mp_cards();
	$mediaCardCount = count($mediaObj->mp_cards);
	$mediaObj = NULL;
	
	
	//Check to make sure there is an entry in the database in order to generate configuration
	$table = "transcode";
	$param = "interface";

	$check = $transcode->data->select_statement($transcode->db_location,$table, $param, "");
	
	// Check for transcoding configuration
	if ($mediaCardCount && !isMediaConfigInSync("sqlite:../sqlite/cardinfo.db") )
	{
	  echo "<br/>\n";
	  if ( $output[0] != "")
	  {
		$display_common->WarningBox( 
		  "<table><tr><td>\n".
		  "Media configuration out of synch:<br/>" .
		  "</td>\n".
		  "<td>\n".
		  "<ul>\n" .
		  "<li>Media Processing Started. Please stop by navigating to the <a href='../controls_embedded.php'>Control Panel</a></li>\n" .
		  "<li>Generate Media configuration.</li>\n" .
		  "</ul>\n".
		  "</td></tr></table>\n", "style='width:700px'"  );
	  }
	  else
	  {
		$display_common->WarningBox( 
		  "<table><tr><td>\n".
		  "Media configuration out of synch:<br/>" .
		  "</td>\n".
		  "<td>\n".
			"<input type='submit' name='install' value='Generate Configuration' " . $_SESSION['tc_button_class'] . " >".
		  "</td></tr></table>\n", "style='width:700px'"  );
	  }
	}
*/	
	//$transcode->find_vocallo_firmware($display_common);
	
	?>
    </form>
    
    
    <?php
					
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}	
}
else
{
	header( 'Location:../index.php' ) ;
}
