<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Sessions
session_start();
require_once '../database_classes.php';
include 'identify-start-class.php';
include '../SSH_Class.php';

//Class constructors
$data = new database_class;
$wanpipe = new wanpipe_class;
$ssh = new ssh_class;

//print_r ($ssh);

/*$full_card = $_GET['fullcard'];
$port = $_GET['port'];
$number = $_GET['card_num'];
$temp_card = $_GET['card'];*/

$card = str_replace (" ", "", $temp_card);

//echo "$full_card, $card, $number, $port <br />";
$full_card = "AFT-"  .$_SESSION['card_clicked'] . "-SH";
$port =  $_SESSION['port_num_clicked'];
$number = $_SESSION['card_num'];
$card = $_SESSION['card_clicked'];
$proc_id = $_SESSION['proc_id'];

if (isset($_SESSION['pci_slot']) && isset($_SESSION['pci_bus']))
{
	$nodatabase = true;
	$cardinfo['pci_slot'] = $_SESSION['pci_slot'];
	$cardinfo['pci_bus'] = $_SESSION['pci_bus'];
	 
	 unset($_SESSION['pci_bus']);
	 unset($_SESSION['pci_slot']);
}


//echo $port;
//adjust cardinfo.db based on proc_id
if ($proc_id == 1)
{
	$db_location = "sqlite:../sqlite/cardinfo.db";
}
elseif ($proc_id > 1)
{
	$db_location = "sqlite:../sqlite/cardinfo" . $proc_id . ".db";
}

//echo $db_location;

//Pull relay information from database
if (!$nodatabase)
{
	$relay_type = $data->select_statement('sqlite:../sqlite/relay_info.db','ss7_relay','machine_type,relay_type','');
	if ($relay_type['machine_type'] == "standalone" || $relay_type['relay_type'] == "SLAVE")
	{
		$type = "local";
	}
	else
	{
		$relay_info = $data->select_statement('sqlite:../sqlite/relay_info.db','relay_hosts','relay_name,ip_addr,ssh_port',"id = $proc_id");			
	
		$pattern = "'\bMaster1\b'";
	
		if (preg_match($pattern,$relay_info['relay_name']))
		{
			$type = "local";
		}
		elseif (!preg_match($pattern,$relay_info['relay_name']))
		{
			$type = "remote";
		}
	}
}
else
{
	$type = "local";
}
//echo "Type = $type<br />";
//Check if this particular wanpipe is configured already.
//If it is, do not create a new wanpipe config file
//If it is not, create a new wanpipe config file for it (wanpipe99999.conf)
$table_name = "generated_ports";
$cardformat = $card . "_" . $number . "_" . $port;
$where = "card = \"" . $cardformat . "\"";

$check_table = $data->check_for_table($db_location,$table_name);

if ($check_table > 1)
{
	$exist = $data->select_statement($db_location, $table_name, "id, card, wanpipe",$where);
}
//echo $check_table . ", " . $exist['card'] . "<br />";
if ($exist['card'] != "")
{
	$startport = $exist['wanpipe'];
	$start_span = "w" . $exist['id'] . "g1";
	unset($_SESSION['delete_file']);
}
elseif ($exist['card'] == "")
{	
	//Find unused span and use it for this port
	$cmd = "/usr/sbin/wanrouter hwprobe | grep -c AFT";
	//echo $proc_id;
	//echo $cmd . "<br />";
	if ($proc_id == 1)
	{
		//Standalone machine
		exec ($cmd, $output);
	}
	elseif ($proc_id > 1)
	{
		//echo "i am here";			
		$output = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
		//echo $output[0] . "done<br />";
	}
	//echo "Wanrouter hardware probe = " . $output[0] . "<br />";
	//exec ($cmd, $output);
	$file_name2 = trim($output[0]," \n\t");
	
	//pull all relevant information from card present table
	if (!$nodatabase)
	{
		$table_name = "card_present";
		$cardformat = $full_card . "-" . $number;
		$where = "dev_name = \"$cardformat\"";
		$param = "pci_bus, pci_slot";
		$cardinfo = $data->select_statement($db_location, $table_name, $param, $where);
	}
	
	//Create the file based on the type of card
	$wanpipe->A10x_template($file_name2,$port,$cardinfo['pci_slot'], $cardinfo['pci_bus'],$full_card);
		
	//Move file
	//if proc_id > 1, scp file, if it is 1, make local move
	
	//shell_exec ("mv " . $file_name . " /etc/wanpipe");
	$file_name = "wanpipe" . $file_name2 . ".conf";
	
	//echo $file_name . "<br />";
	$original_loc = $_SESSION['smg_root_path'] . "/nginx/html/php/identify/" . $file_name;
	$destination_loc = "/etc/wanpipe/" . $file_name;
	$cmd = "mv";
	//echo $cmd;
	$ssh->send_file($type,$relay_info['ip_addr'],$relay_info['ssh_port'],$original_loc,$destination_loc,$cmd);

	$startport = "wanpipe" . $file_name2;
	$start_span = "w" . $file_name2 . "g1";
	
	$_SESSION['delete_file'] = "yes";
}

//$_SESSION['exist'] == $exist['card'];

//Check if wanrouter started
//If wanrouter is started then you need to start just that port
$cmd = "/usr/sbin/wanrouter status | grep -c wanpipe";
//exec ("/usr/sbin/wanrouter status | grep -c wanpipe", $wanrouter_status);

$wanrouter_status = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);

//echo "Wanrouter status = " . $wanrouter_status[0] . "<br />";

if ($wanrouter_status[0] == 0)
{
	//wanrouter stopped
	//Start the port
	$cmd = "/usr/sbin/wanrouter start " . $startport;
	
	$null_val = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
	$_SESSION['wanrouter_started'] = $startport;
}
elseif ($wanrouter_status[0] > 0)
{
	//wanrouter started
	//Check to see if the port needing identification is started
	$cmd = "/usr/sbin/wanrouter status";
	//exec ($cmd, $port_up);
	$port_up = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
	
	//Port not started
	$pattern = "'\b" . $startport . "\b'";

	for ($a = 0; $a <=count($port_up); $a++)
	{
		//echo "Port Status = " . $port_up[$a] . "<br />";
		if (preg_match($pattern,$port_up[$a]))
		{
			$found = "yes";
			
			//This port was started already
			unset($_SESSION['wanrouter_started']);
		}
	}
	//echo $found;
	if ($found != "yes")
	{
		//Start the port
		$cmd = "/usr/sbin/wanrouter start " . $startport;
		//echo $cmd . "<br />";
		$null_value = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
		//exec ($cmd);
		$_SESSION['wanrouter_started'] = $startport;
	}
	elseif ($found != "yes")
	{
		$_SESSION['wanrouter_started'] = "all";
	}
}
//echo $_SESSION['wanrouter_started'] . "<br />";
//launch wanpipemon script and have it timeout in 5 minutes
$cmd = "wanpipemon -i " . $start_span . " -c dled_blink -timeout 300 > /dev/null 2>/dev/null &";
//echo $cmd;
//exec ($cmd);
$null_value = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);

$_SESSION['wanpipe_off'] = $startport;

//exec($cmd,$output2);
$cmd = "pidof wanpipemon";

if (!$nodatabase)
{
	$output2 = $ssh->execute($type,$cmd, $relay_info['ip_addr'], $relay_info['ssh_port']);
	//echo "PID = " . $output2[0] . "<br />";

	$out = $output2[0];
}
else
{
	//echo passthru($cmd,$result);
	ob_start();
	passthru($cmd,$result);
	$out = ob_get_contents();
	ob_clean();
	
	//echo "PID = " . $out . "<br />";

	//$_SESSION['pidof'] = $out;

}

$_SESSION['wanpipe_off'] = $startport;

//echo $_SERVER['PHP_SELF']  . "<br />";
?>
