<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class wanpipe_class
{	

	public $span ="";			//Contains the span number
	public $card ="";			//Contains the card
	public $port_id ="";		//Contains the cards port number
	private $clock = "";		//Contains the clock variable
	private $API = "";			//Contains the API being used
	private $dchan = "";		//Contains the D-Channel Variable
	private $echo = "";			//Contains the echo cancelation variable
	private $fax = "";			//Contains the HW Fax variable
	private $dtmf = "";			//Contains the HW DTMF variable
    
    //Template for the A10x series of Cards
	function A10x_template($span, $port, $slot, $bus, $device_name)
	{
		$this->span = $span;
		$this->card = $device_name;
		$this->port_id = $port;
		$this->API = "TDM_VOICE_API";
		$this->clock = "NORMAL";  
		$this->dchan = "24";
		$coding = "B8ZS";
		$framing = "ESF";
		$rx_level = "360DB";
		$LBO = "0DB";
		$sig_mode = "CCS";
		$this->echo = "NO";
		$this->dtmf = "NO";
		$this->fax = "NO";

		$file_location = "/etc/wanpipe";
		$file_name = "wanpipe" . $this->span . ".conf";

		$A10xfilehandle = fopen($file_name, 'w') or die("can't open file");

		$wanpipe_file = "
#================================================
# WANPIPE" . $this->span. " Configuration File
#================================================
# Card = " . $this->card . " Port = " . $this->port_id . "
# Date: " . date('l jS \of F Y h:i:s A') . "
#
# Note: This file was generated automatically
#       by SMG WebUI.
#
#       If you want to edit this file, it is
#       recommended that you use SMG WebUI App
#       
#================================================
# Sangoma Technologies Inc.
#================================================

[devices]
wanpipe" .$this->span . " = WAN_AFT_TE1, Comment

[interfaces]
w" .  $this->span . "g1 = wanpipe" . $this->span . ", , " . $this->API . ", Comment

[wanpipe" . $this->span . "]
CARD_TYPE       		= AFT
S514CPU         		= A
CommPort        		= PRI
AUTO_PCISLOT    		= NO
PCISLOT         		= " . $slot . "
PCIBUS          		= " . $bus . "
FE_MEDIA        		= T1
FE_LCODE        		= " . strtoupper($coding) . "
FE_FRAME        		= " . strtoupper($framing) . "
FE_LINE         		= " . $this->port_id . "		
TE_CLOCK        		= " . strtoupper($this->clock) . "
TE_REF_CLOCK    		= 0	
TE_SIG_MODE				= " . strtoupper($sig_mode) . "
TE_HIGHIMPEDANCE		= NO
TE_RX_SLEVEL    		= " . strtoupper($rx_level) . "
LBO             		= " . strtoupper($LBO) . "
FE_TXTRISTATE   		= NO
MTU						= 1500
UDPPORT         		= 9000
TTL             		= 255
IGNORE_FRONT_END        = NO		
TDMV_SPAN               = " . $this->span . "
TDMV_DCHAN              = " . $this->dchan . "
TE_AIS_MAINTENANCE 		= NO       					# NO: defualt  YES: Start port in AIS Blue Alarm and keep line down
					                                # wanpipemon -i w1g1 -c Ttx_ais_off to disable AIS maintenance mode
                                                    # wanpipemon -i w1g1 -c Ttx_ais_on to enable AIS maintenance mode
TDMV_HW_DTMF            = " . strtoupper($this->dtmf) . "	            		# YES: receive dtmf events from hardware
TDMV_HW_FAX_DETECT      = " . strtoupper($this->fax) . "		        		# YES: receive fax 1100hz events from hardware
HWEC_OPERATION_MODE     = OCT_NORMAL    			# OCT_NORMAL: echo cancelation enabled with nlp (default)
                                                    # OCT_SPEECH: improves software tone detection by disabling NLP (echo possible)
                                                    # OCT_NO_ECHO:disables echo cancelation but allows VQE/tone functions.
HWEC_DTMF_REMOVAL       = NO    					# NO: default  YES: remove dtmf out of incoming media (must have hwdtmf enabled)
HWEC_NOISE_REDUCTION    = NO    					# NO: default  YES: reduces noise on the line - could break fax
HWEC_ACUSTIC_ECHO       = NO    					# NO: default  YES: enables acustic echo cancelation
HWEC_NLP_DISABLE        = NO    					# NO: default  YES: guarantees software tone detection (possible echo)
HWEC_TX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_RX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_TX_GAIN            = 0         			    # 0: disable   -24-24: db values to be applied to tx signal
HWEC_RX_GAIN            = 0             			# 0: disable   -24-24: db values to be applied to tx signal

[w" . $this->span . "g1]
ACTIVE_CH       		= ALL
TDMV_HWEC       		= " . $this->echo . "
MTU             		= 80
";

		fwrite($A10xfilehandle, $wanpipe_file);
		fclose($A10xfilehandle);
		
		//shell_exec ("mv " . $file_name . " /etc/wanpipe");
	}
	
	function A500_template($span, $port, $slot, $bus, $device_name)
	{

		$this->span = $span;
		$this->card = $device_name;
		$this->port_id = $port;
		$this->API = "TDM_VOICE_API";
		$this->echo = "NO";
		$this->dtmf = "NO";
		$this->fax = "NO";

		$file_location = "/etc/wanpipe";
		$file_name = "wanpipe" . $this->span . ".conf";
	
		$A500filehandle = fopen($file_name, 'w') or die("can't open file");

		$wanpipe_file = "
#================================================
# WANPIPE" . $this->span. " Configuration File
#================================================
# Card = " . $this->card . " Port = " . $this->port_id . "
# Date: " . date('l jS \of F Y h:i:s A') . "
#
# Note: This file was generated automatically
#       by " . $_SESSION['shortname']  . " WebUI.
#
#       If you want to edit this file, it is
#       recommended that you use SMG WebUI App
#       
#================================================
# Sangoma Technologies Inc.
#================================================

[devices]		
wanpipe" . $this->span. " = WAN_AFT_ISDN_BRI, Comment

[interfaces]
w" . $this->span. "g1 = wanpipe" . $this->span. ", , " . $this->API . ", Comment

[wanpipe" . $this->span. "]
CARD_TYPE       		= AFT
S514CPU         		= A
CommPort        		= PRI
AUTO_PCISLOT    		= NO
PCISLOT         		= " . $this->pci_slot . "
PCIBUS          		= " . $this->pci_bus . "
FE_MEDIA        		= BRI
FE_LINE         		= " . $this->port_id . "
TDMV_LAW        		= ALAW
RM_BRI_CLOCK_MASTER 	= NO
MTU             		= 1500
UDPPORT         		= 9000
TTL             		= 255
IGNORE_FRONT_END		= NO
TDMV_SPAN               = " . $this->span . "
TE_AIS_MAINTENANCE 		= NO                # NO: defualt  YES: Start port in AIS Blue Alarm and keep line down
                                            # wanpipemon -i w1g1 -c Ttx_ais_off to disable AIS maintenance mode
                                            # wanpipemon -i w1g1 -c Ttx_ais_on to enable AIS maintenance mode
TDMV_HW_DTMF        	= " . strtoupper($this->dtmf) . "				# YES: receive dtmf events from hardware
TDMV_HW_FAX_DETECT      = " . strtoupper($this->fax) . "				# YES: receive fax 1100hz events from hardware
HWEC_OPERATION_MODE     = OCT_NORMAL    	# OCT_NORMAL: echo cancelation enabled with nlp (default)
                                        	# OCT_SPEECH: improves software tone detection by disabling NLP (echo possible)
                                            # OCT_NO_ECHO:disables echo cancelation but allows VQE/tone functions.
HWEC_DTMF_REMOVAL       = NO    			# NO: default  YES: remove dtmf out of incoming media (must have hwdtmf enabled)
HWEC_NOISE_REDUCTION    = NO    			# NO: default  YES: reduces noise on the line - could break fax
HWEC_ACUSTIC_ECHO       = NO    			# NO: default  YES: enables acustic echo cancelation
HWEC_NLP_DISABLE        = NO    			# NO: default  YES: guarantees software tone detection (possible echo)
HWEC_TX_AUTO_GAIN       = 0     			# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_RX_AUTO_GAIN       = 0     			# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_TX_GAIN            = 0     			# 0: disable   -24-24: db values to be applied to tx signal
HWEC_RX_GAIN            = 0     			# 0: disable   -24-24: db values to be applied to tx signal

[w" . $this->span. "g1]
ACTIVE_CH      			= ALL
TDMV_HWEC       		= " . strtoupper($this->echo) . "
MTU             		= 80
";

		fwrite($A500filehandle, $wanpipe_file);
		fclose($A500filehandle);
			
		shell_exec ("mv " . $file_name . " /etc/wanpipe");
	}
	
	
	function analog_template($span, $port, $slot, $bus, $device_name)
	{
		
		$this->span = $span;
		$this->card = $device_name;
		$this->port_id = $port;
		$this->API = "TDM_VOICE_API";
		$this->echo = "NO";
		$this->dtmf = "NO";
		$this->fax = "NO";		
		$file_location = "/etc/wanpipe";
		$file_name = "wanpipe" . $this->span . ".conf";

		$analogfilehandle = fopen($file_name, 'w') or die("can't open file");

		$wanpipe_file = "
#================================================
# WANPIPE" . $this->span. " Configuration File
#================================================
# Card = " . $this->card . " Port = " . $this->port_id . "
# Date: " . date('l jS \of F Y h:i:s A') . "
#
# Note: This file was generated automatically
#       by " . $_SESSION['shortname']  . " WebUI.
#
#       If you want to edit this file, it is
#       recommended that you use SMG WebUI App
#       
#================================================
# Sangoma Technologies Inc.
#================================================

[devices]
wanpipe" .$this->span . " = WAN_AFT_ANALOG, Comment

[interfaces]
w" .  $this->span . "g1 = wanpipe" . $this->span . ", , " . $this->API . ", Comment

[wanpipe" . $this->span . "]
CARD_TYPE   			= AFT
S514CPU     			= A
CommPort   				= PRI
AUTO_PCISLOT    		= NO
PCISLOT     			= " . $this->pci_slot . "
PCIBUS      			= " . $this->pci_bus . "
FE_MEDIA    			= FXO/FXS
TDMV_LAW    			= MULAW
TDMV_OPERMODE   		= FCC
RM_BATTTHRESH   		= 3
RM_BATTDEBOUNCE 		= 16
FE_NETWORK_SYNC 		= NO
MTU 					= 1500
UDPPORT         		= 9000
TTL             		= 255
IGNORE_FRONT_END        = NO	
TDMV_SPAN               = " . $this->span . "
TE_AIS_MAINTENANCE 		= NO         				# NO: defualt  YES: Start port in AIS Blue Alarm and keep line down
					    	                        # wanpipemon -i w1g1 -c Ttx_ais_off to disable AIS maintenance mode
                        	                        # wanpipemon -i w1g1 -c Ttx_ais_on to enable AIS maintenance mode
TDMV_HW_DTMF            = " . strtoupper($this->dtmf) . "	           			# YES: receive dtmf events from hardware
TDMV_HW_FAX_DETECT      = " . strtoupper($this->fax) . "		        		# YES: receive fax 1100hz events from hardware
HWEC_OPERATION_MODE     = OCT_NORMAL    			# OCT_NORMAL: echo cancelation enabled with nlp (default)
                                                    # OCT_SPEECH: improves software tone detection by disabling NLP (echo possible)
                                                    # OCT_NO_ECHO:disables echo cancelation but allows VQE/tone functions.
HWEC_DTMF_REMOVAL       = NO    					# NO: default  YES: remove dtmf out of incoming media (must have hwdtmf enabled)
HWEC_NOISE_REDUCTION    = NO    					# NO: default  YES: reduces noise on the line - could break fax
HWEC_ACUSTIC_ECHO       = NO    					# NO: default  YES: enables acustic echo cancelation
HWEC_NLP_DISABLE        = NO    					# NO: default  YES: guarantees software tone detection (possible echo)
HWEC_TX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_RX_AUTO_GAIN       = 0     					# 0: disable   -40-0: default tx audio level to be maintained (-20 default)
HWEC_TX_GAIN            = 0         			    # 0: disable   -24-24: db values to be applied to tx signal
HWEC_RX_GAIN            = 0             			# 0: disable   -24-24: db values to be applied to tx signal

[w" . $this->span . "g1]
ACTIVE_CH       		= ALL
TDMV_HWEC      			= " . strtoupper($this->echo) . "
MTU             		= 8
";

		fwrite($analogfilehandle, $wanpipe_file);
		fclose($analogfilehandle);
		
		shell_exec ("mv " . $file_name . " /etc/wanpipe");
	}		
}
?>