<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Session
session_start();

function get_eth_interfaces() {
	exec("/sbin/ifconfig -a | grep eth | cut -d: -f1 | awk '{ print $1}'", $interfaces);
	
	foreach ($interfaces as $interface) {
		$command = "/sbin/ifconfig " . $interface . " | grep 'inet addr:' | cut -d: -f2 | awk '{ print $1}'";
		exec ($command, $int_ip);
		if ($int_ip[0] != "") 
			$interface_list[$int_ip[0]] = trim($interface) . '-' . trim($int_ip[0]);
		unset ($int_ip);
	}
	return $interface_list;
}

function check_tdm_configured ($data,$db='sqlite:sqlite/cardinfo.db') {
	$check = $data->array_select_statement($db,'finished_ports','count(*)','');

	if ($check[0]['count(*)'] == 0 )
		return false;
	else
		return true;
}

function check_ip_exist($data,$db_location,&$sctp_status, &$sig_ip_status, &$rtp_ip_status) {
	$sctp_status = true;
	$sig_ip_status = true;
	$rtp_ip_status = true;
	$rtp_ip = array();
	$signalling_ip = array();
	$dest_ip_1 = array();
	$dest_ip_2 = array();
	$dest_ip_3 = array();
	$dest_ip_4 = array();
	$dest_ip_5 = array();
	$sig_ip_count = 0;
	$rtp_ip_count = 0;
	$dest_ip_1_count = 0;
	$dest_ip_2_count = 0;
	$dest_ip_3_count = 0;
	$dest_ip_4_count = 0;
	$dest_ip_5_count = 0;
	
	$interface_list = get_eth_interfaces();

	//Check sctp interfaces for valid IP's
	$sctp_interfaces = $data->array_select_statement ($db_location, 'sctp_interfaces', 'dest_ip_1,dest_ip_2,dest_ip_3,dest_ip_4,dest_ip_5','');

	if (!empty($sctp_interfaces) ) {
		foreach ($sctp_interfaces as $sctp) {
			if (isset($sctp['dest_ip_1'])) {
				$dest_ip_1[$dest_ip_1_count] = false;
				foreach ($interface_list as $k=>$v) {
					if ($k == $sctp['dest_ip_1']) {
						$dest_ip_1[$dest_ip_1_count] = true;
						break;
					}
				}
				$dest_ip_1_count++;
			}
			
			if ($sctp['dest_ip_2'] != "") {
				$dest_ip_2[$dest_ip_2_count] = false;
				foreach ($interface_list as $k=>$v) {
					if ($k == $sctp['dest_ip_2']) {
						$dest_ip_2[$dest_ip_2_count] = true;
						break;
					}
				}
				$dest_ip_2_count++;
			}
			
			if ($sctp['dest_ip_3'] != "") {
				$dest_ip_3[$dest_ip_3_count] = false;
				foreach ($interface_list as $k=>$v) {
					if ($k == $sctp['dest_ip_3']) {
						$dest_ip_3[$dest_ip_3_count] = true;
						break;
					}
				}
				$dest_ip_3_count++;
			}
			
			if ($sctp['dest_ip_4'] != "") {
				$dest_ip_4[$dest_ip_4_count] = false;
				foreach ($interface_list as $k=>$v) {
					if ($k == $sctp['dest_ip_4']) {
						$dest_ip_4[$dest_ip_4_count] = true;
						break;
					}
				}
				$dest_ip_4_count++;
			}
			
			if ($sctp['dest_ip_5']!= "") {	
				$dest_ip_5[$dest_ip_5_count] = false;
				foreach ($interface_list as $k=>$v) {
					if ($k == $sctp['dest_ip_5']) {
						$dest_ip_5[$dest_ip_5_count] = true;
						break;
					}
				}
				$dest_ip_5_count++;
			}		
		}
	}

	//Check mg_profile signalling_ip and rtp_ip for valid ip addresses
	$mg_profiles = $data->array_select_statement ($db_location, 'mg_profiles', 'rtp_ip,ip_addr','');

	if (!empty($mg_profiles)) {
		foreach ($mg_profiles as $profile) {
			if (isset($profile['rtp_ip'])) {
				$rtp_ip[$rtp_ip_count] = false;
				foreach ($interface_list as $k=>$v) {
					if ($k == $profile['rtp_ip']) {
						$rtp_ip[$rtp_ip_count] = true;
						break;
					}
				}
				$rtp_ip_count++;
			}
	
			if ($profile['ip_addr'] != "") {
				$ip_addr[$sig_ip_count] = false;
				foreach ($interface_list as $k=>$v) {
					if ($k == $profile['ip_addr']) {
						$ip_addr[$sig_ip_count] = true;
						break;
					}
				}
				$sig_ip_count++;
			}
		}
	}

	$skip=false;
	if (!empty($dest_ip_1)) {
		foreach ($dest_ip_1 as $dest_ip_1_check) {
			if (!$dest_ip_1_check) {
				$sctp_status = false;
				$skip=true;
				break;
			}
		}
	}
	
	if (!$skip && !empty($dest_ip_2)) {
		foreach ($dest_ip_2 as $dest_ip_2_check) {
			if (!$dest_ip_2_check) {
				$sctp_status = false;
				$skip=true;
				break;
			}
		}
	}
	
	if (!$skip && !empty($dest_ip_3)) {
		foreach ($dest_ip_3 as $dest_ip_3_check) {
			if (!$dest_ip_3_check) {
				$sctp_status = false;
				$skip=true;
				break;
			}
		}
	}

	if (!$skip && !empty($dest_ip_4)) {
		foreach ($dest_ip_4 as $dest_ip_4_check) {
			if (!$dest_ip_4_check) {
				$sctp_status = false;
				$skip=true;
				break;
			}
		}
	}	

	if (!$skip && !empty($dest_ip_5)) {
		foreach ($dest_ip_5 as $dest_ip_5_check) {
			if (!$dest_ip_5_check) {
				$sctp_status = false;
				$skip=true;
				break;
			}
		}
	}	
	
	if (!empty($ipaddr) ) {
		foreach ($ip_addr as $sig_ip_check) {
			if (!$sig_ip_check) {
				$sig_ip_status = false;
				break;
			}
		}
	}
	
	if (!empty($rtp_ip)) {
		foreach ($rtp_ip as $rtp_ip_check) {
			if (!$rtp_ip_check) {
				$rtp_ip_status = false;
				break;
			}
		}
	}
}

?>