<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is NSG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

/**
* Generates wanpipe configuration for a single port and updates wanrouter rc
*/
function generate_wanpipe_config($card,$span,$data,$db = 'sqlite:sqlite/cardinfo.db') {
	
	require_once ('wanpipe_config/wanpipe.php');
	$board = $card;
	$wanpipe = new T1_E1_wanpipe_dahdi;
	//Create wanpipe file
	$wanpipe->db_location = $db;
	$wanpipe->populate_vars($board[0],$board[1],$span,$board[2],$data,'');
	$wanpipe->A10x_template('TDM_VOICE_API');
	
	//copy into perm table
	$data->delete_generic($db, 'perm_'.$board[0].'_'.$board[1], 'port_id='.$board[2]);

  $param = "port_id int primary key, dev_name varchar(60), line_type varchar(10), coding varchar(10), framing varchar(10), clock varchar(30), ref_clock int, echo varchar(30), dtmf varchar(30), dtmf_removal varchar(30), fax varchar(30), lbo varchar(30), txtristate varchar(30), sigmode varchar(10), impedence varchar(30), rx_level varchar(30), rxgain decimal(10,2), txgain decimal(10,2), pre_buffer_size int";
	if ($data->check_for_table($db,'perm_'.$board[0].'_'.$board[1]) < 2) {
		//create perm table
		$table_name = 'perm_'.$board[0].'_'.$board[1];
		$data->create_table($db,$table_name,$param);
	}

	
	$scratch_table = $data->select_statement($db,$board[0].'_'.$board[1],'*','port_id='.$board[2]);
	if ($data->check_for_table($db,'perm_'.$board[0].'_'.$board[1]) < 2) {
		//create perm table
		$table_name = 'perm_'.$board[0].'_'.$board[1];
		$data->create_table($db, $table_name, $param);
	}
	
	$insert_params = 'port_id, dev_name, line_type,coding,framing,clock,ref_clock,echo,dtmf,dtmf_removal,fax,lbo,txtristate,sigmode,impedence,rx_level,rxgain,txgain,pre_buffer_size';
	$insert_values = '"'.$scratch_table['port_id'] . '","'.$scratch_table['dev_name'].'","'.$scratch_table['line_type'].'","'.$scratch_table['coding'].'","'.$scratch_table['framing'].'","'.$scratch_table['clock'].'","'.$scratch_table['ref_clock'].'","'.$scratch_table['echo'].'","'.$scratch_table['dtmf'].'","'.$scratch_table['dtmf_removal'].'","'.$scratch_table['fax'].'","'.$scratch_table['lbo'].'", "' . $scratch_table['txtristate'].  '","'.$scratch_table['sigmode'].'","'.$scratch_table['impedence'].'","'.$scratch_table['rx_level'].'","'.$scratch_table['rxgain'].'","'.$scratch_table['txgain'].'","'.$scratch_table['pre_buffer_size'].'"';
	$data->insert_statement($db,'perm_'.$board[0].'_'.$board[1],$insert_params,$insert_values);
	
	
	//update generated_ports table
	$insert_params = 'id,card,completed,wanpipe';
	$insert_values = '"'.$span.'","'.$board[0].'_'.$board[1].'_'.$board[2].'","yes","wanpipe'.$span.'"';
	$data->insert_statement($db,'generated_ports',$insert_params,$insert_values);

	$wanpipe_array = pull_array_data('generated_ports','wanpipe',$data);
	$a = 0;

	foreach ($wanpipe_array as $wanpipe) {
		foreach ($wanpipe as $k=>$v) {
			if (!is_numeric($k)) {
				$wan[$a] = $v;
				$a++;
			}
		}
	}
	$wanpipe_string = implode(' ',$wan);

	//update wanrouter.rc
	$file = '/etc/wanpipe/wanrouter.rc';
	$file_open = file_get_contents($file);
	$file_open = preg_replace ('/.*WAN_DEVICES=.*/', 'WAN_DEVICES="'.$wanpipe_string.'"',$file_open);
	file_put_contents($file,$file_open);
}

function remove_wanpipe_file($card,$span,$data,$db = 'sqlite:sqlite/cardinfo.db') {
	//remove file
	shell_exec('rm -fr /etc/wanpipe/wanpipe'.$span.'.conf');
	
	//remove from generated_ports table
	//$data->delete_generic($db,'generated_ports','card="'.$card[0].'_'.$card[1].'_'.$card[2].'"');
	$data->delete_generic($db,'perm_'.$card[0].'_'.$card[1],'port_id='.$card[2]);
}

function update_wanrouter_rc($data,$db="sqlite:sqlite/cardinfo.db") {
	$wanpipe_array = pull_array_data('generated_ports','wanpipe',$data);
	$a = 0;

	$wan = array();
	foreach ($wanpipe_array as $wanpipe) {
		$wan[$a] = $wanpipe['wanpipe'];
		$a++;
	}
	$wanpipe_string = implode(' ',$wan);
	
	//remove out of wanrouter.rc
	$file = '/etc/wanpipe/wanrouter.rc';
	$file_open = file_get_contents($file);
	$file_open = preg_replace ('/.*WAN_DEVICES=.*/', 'WAN_DEVICES="'.$wanpipe_string.'"',$file_open);
	file_put_contents($file,$file_open);
}

/**
* Generates freetdm.conf
*/
function generate_freetdm_config($card,$span,$data,$gen_type = 'new',$db='sqlite:sqlite/cardinfo.db') {
	require_once('freetdm_config/freetdm.php');
	$freetdm = new freetdm_configuration;
	$board = $card;
	$freetdm->db_location=$db;
	$freetdm-> freetdm_generate($board[0], $board[1], $span, $board[2], $data);
	
	//check if new port or existing port
	$check = $data->select_statement($db,'generated_ports','id','id='.$span);
	$file = $_SESSION['smg_root_path'] . '/conf/freetdm.conf';
	$file_open = file_get_contents($file);
	
	//if ($check['id'] == "")  {
	if ($gen_type == 'new') {
		//add new freetdm.conf entry
		$file_open.= $freetdm->generate_single_freetdm_conf_entry();
	}
	else {
		//Put old file into array
		$array = explode("\n",$file_open);
		$counter = 0;
		foreach ($array as $conf) {
			if (preg_match("/.*span wanpipe wp" . $span . ".*/",$conf))
				break;
			$counter++;
		}

		if ($gen_type == 'update') {
		//if ($freetdm->ss7_sig_channel != "") {
			//update freetdm.conf entry
			$updated_data = $freetdm->generate_single_freetdm_conf_entry();
	
			//Put new data into array
			$new_data = explode("\n",$updated_data);
			$count = 0;
			foreach ($new_data as $data) {
				if ($data == "")
					unset($new_data[$count]);
				$count++;
			}
			$new_data = array_merge($new_data);
			
			//Adjust array so that new values get appended to existing array
			$b = $counter -1;
			for ($a = 0 ; $a <= count($new_data); $a++) {
				if (isset($array[$b]))
					unset ($array[$b]);
							
				$array[$b] = $new_data[$a];
				$b++;
			}
			//Reindex array so everything stays in the proper order
			$count = 0;
			for ($a = 0; $a < count($array); $a++) {
				$final_array[$count] = $array[$a];
				$count++;
			}
			
		}
		elseif ($gen_type == 'remove') {
			//remove entry
			//Update Data
			$b = $counter -1;
			$line = $b + 6;
			for ($a = $b ; $a <= $line; $a++) {
				if ($array[$a] != "") {
					if (isset($array[$a]))
						unset ($array[$a]);
					$b++;
				}
				else
					break;
			}
			
			$final_array =array_values($array);
		}
		$file_open = implode("\n",$final_array);	
	}
	
	file_put_contents($file,$file_open);
	unset($freetdm);	
}

/**
* Generates freetdm.conf.xml for a m2ua link
*/
function generate_m2ua_config($card,$span,$data,$gen_type = 'new',$db='sqlite:sqlite/cardinfo.db') {
	require_once('freetdm_config/freetdm.php');
	$freetdm = new freetdm_configuration;
	$freetdm->db_location = $db;
	$board = $card;
	$freetdm-> freetdm_generate($board[0], $board[1], $span, $board[2], $data);

	$scratch_m2ua = $data->select_statement($db,$board[0].'_'.$board[1].'_m2ua_link','*','port_id='.$board[2]);

	//check if new port or existing port
	$check = $data->select_statement($db,'generated_ports','id','id='.$span);

	$file = $_SESSION['smg_root_path'].'/conf/autoload_configs/freetdm.conf.xml';
	$xml = simplexml_load_file ($file);
		
	if ($gen_type == 'new')  {
		//create new entry
		//modify freetdm.conf.xml
	
		//get last id value
		$id = $span;

		//MTP1
		$m2ua = $xml->signaling_configs->sngss7_configs->sng_isup->mtp1_links->addChild('mtp1_link');
		$m2ua->addAttribute('name','mtp1-'.$id);	
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','id');
		$p1->addAttribute('value',$id);
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','span');
		$p1->addAttribute('value',$span);
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','chan');
		$p1->addAttribute('value',$freetdm->ss7_sig_channel);	
	
		//MTP2
		$m2ua = $xml->signaling_configs->sngss7_configs->sng_isup->mtp2_links->addChild('mtp2_link');
		$m2ua->addAttribute('name','mtp2-'.$id);
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','id');
		$p1->addAttribute('value',$id);
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','mtp1Id');
		$p1->addAttribute('value',$id);
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','errorType');
		$p1->addAttribute('value',$freetdm->ss7_m2ua_link['error_type']);
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','lssuLength');
		$p1->addAttribute('value',$freetdm->ss7_m2ua_link['lssu']);
		$p1 = $m2ua->addChild('param');
		$p1->addAttribute('name','linkType');
		$p1->addAttribute('value',$freetdm->ss7_m2ua_link['link_type']);	
	
		//NIF
		$m2ua = $xml->signaling_configs->sngss7_configs->sng_isup->sng_nif_interfaces->addChild('sng_nif_interface');
		$m2ua->addAttribute('name','M2UA_NIF_'.$span);
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name','id');
		$p1->addAttribute('value',$id);
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name',"m2ua-interface-id");
		$p1->addAttribute('value',$id);
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name',"mtp2-interface-id");
		$p1->addAttribute('value',$id);
		
		//M2UA_Interfaces
		$cluster_id = $data->select_statement($db,'m2ua_clusters','id','profile_name="' . $freetdm->ss7_m2ua_link['cluster'] . '"');
		$cluster_int = $cluster_id['id'];
				
		$m2ua = $xml->signaling_configs->sngss7_configs->sng_isup->sng_m2ua_interfaces->addChild('sng_m2ua_interface');
		$m2ua->addAttribute('name','SGM2UA'.$id);
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name','id');
		$p1->addAttribute('value',$id);
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name',"m2ua-cluster-interface-id");
		$p1->addAttribute('value',$cluster_id['id']);		
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name',"interface-identifier");
		$p1->addAttribute('value',$freetdm->ss7_m2ua_link['interface_id']);	

		//CCSpans
		$m2ua = $xml->sangoma_ss7_spans->addChild('span');
		$m2ua->addAttribute('name','wp'.$span);
		$m2ua->addAttribute('cfgprofile','ss7config');
		$m2ua->addAttribute('operating_mode','M2UA_SG');
		$p1=$m2ua->addChild('param');
		$p1->addAttribute("name","ccSpanId");
		$p1->addAttribute('value',$span);
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name',"dialplan");
		$p1->addAttribute('value','XML');	
		$p1=$m2ua->addChild('param');
		$p1->addAttribute('name',"context");
		$p1->addAttribute('value','$${pstn_context}');	

		//update generated_ports table with data
		$m2ua_link_information = $data->select_statement($db,$board[0].'_'.$board[1].'_m2ua_link','*','port_id=' . $board[2]);
		$generate_update = "type = \"M2UA Signalling Gateway\", cluster_name = \"" . $m2ua_link_information['cluster'] . "\", mtp2_name = \"mtp2-" . $span . "\", m2ua_link_name=\"SGM2UA".$span."\"";
		$generate_table = "generated_ports";								
		$generate_where = "id = $span";
		$data->update_table($db,$generate_table,$generate_update,$generate_where);
				
		//check if perm table exists
		if ($data->check_for_table($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_link') < 2) {
			$create_param = "port_id int,link_name varchar(100), span int, sig_channel int, error_type varchar(100), lssu int, link_type varchar(30), line_type varchar(20), cluster varchar(30), voice_chans varchar(40), interface_id int";
			$data->create_table($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_link',$create_param);
		}

		//copy scratch into perm (insert)
		$insert_params = "port_id,link_name,span,sig_channel,error_type,lssu,link_type,line_type,cluster,voice_chans,interface_id";
		$insert_values = '"'.$board[2].'","'.$scratch_m2ua['link_name'] . '","'.$scratch_m2ua['span'].'","'.$scratch_m2ua['sig_channel'].'","'.$scratch_m2ua['error_type'].'","'.$scratch_m2ua['lssu'].'","'.$scratch_m2ua['link_type'].'","'.$scratch_m2ua['line_type'].'","'.$scratch_m2ua['cluster'].'","'.$scratch_m2ua['voice_chans'].'","'.$scratch_m2ua['interface_id'].'"';
		$data->insert_statement($db,"perm_".$board[0]."_".$board[1]."_m2ua_link",$insert_params,$insert_values);
		
	}
	else {
		//Update freetdm.conf.xml
		//Get ID
		$mtp2id = $data->select_statement($db,'generated_ports','mtp2_name','card="' . $board[0].'_'.$board[1].'_'.$board[2] . '"');
		$temp_id = explode('-',$mtp2id['mtp2_name']);
		$id = $temp_id[1];

		//Check if entry to be removed
		//if (!empty($freetdm->ss7_m2ua_link)) {
		if ($gen_type == 'update') {
			//Update MTP1
			$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/mtp1_links/mtp1_link[@name="mtp1-'.$id.'"]');
			if($obj){
				$obj[0]->param[2]->attributes()->value=$freetdm->ss7_sig_channel;
			}

			//Update MTP2
			$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/mtp2_links/mtp2_link[@name="mtp2-'.$id.'"]');
			if($obj){
				$obj[0]->param[2]->attributes()->value=$freetdm->ss7_m2ua_link['error_type'];
				$obj[0]->param[3]->attributes()->value=$freetdm->ss7_m2ua_link['lssu'];
				$obj[0]->param[4]->attributes()->value=$freetdm->ss7_m2ua_link['link_type'];			
			}

			//Update M2UA_Interfaces
			$cluster_id = $data->select_statement($db,'m2ua_clusters','id','profile_name="' . $freetdm->ss7_m2ua_link['cluster'] . '"');
			$cluster_int = $cluster_id['id'];

			$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/sng_m2ua_interfaces/sng_m2ua_interface[@name="'. $freetdm->ss7_m2ua_link['link_name'] .'"]');
			if($obj){
				$obj[0]->param[1]->attributes()->value=$cluster_int;
				$obj[0]->param[2]->attributes()->value=$freetdm->ss7_m2ua_link['interface_id'];		
			}
			
			//update generated_ports table with data
			$m2ua_link_information = $data->select_statement($db,$board[0].'_'.$board[1].'_m2ua_link','link_name,link_type,voice_chans','port_id=' . $board[2]);
			$generate_update = "type = \"M2UA Signalling Gateway\", cluster_name = \"" . $m2ua_link_information['cluster'] . "\", mtp2_name = \"mtp2-" . $span . "\", m2ua_link_name=\"SGM2UA".$span."\"";
			$generate_table = "generated_ports";								
			$generate_where = "id = $span";
			$data->update_table($db,$generate_table,$generate_update,$generate_where);
		}
		elseif ($gen_type == 'remove') {
			//Remove Entry
			//Remove MTP1

			$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/mtp1_links/mtp1_link[@name="mtp1-'.$id.'"]');
			if($obj){
				$dom=dom_import_simplexml($obj[0]);
				$dom->parentNode->removeChild($dom);
			}

			//Remove MTP2
			$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/mtp2_links/mtp2_link[@name="mtp2-'.$id.'"]');
			if($obj){
				$dom=dom_import_simplexml($obj[0]);
				$dom->parentNode->removeChild($dom);
			}

			//Remove NIF
			$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/sng_nif_interfaces/sng_nif_interface[@name="M2UA_NIF_'.$id.'"]');
			if($obj){
				$dom=dom_import_simplexml($obj[0]);
				$dom->parentNode->removeChild($dom);
			}

			//Remove M2UA Interface
			$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/sng_m2ua_interfaces/sng_m2ua_interface[@name="SGM2UA'.$id.'"]');
			if($obj){
				$dom=dom_import_simplexml($obj[0]);
				$dom->parentNode->removeChild($dom);		
			}

			//Remove CCSpans
			$obj = $xml->xpath('/configuration/sangoma_ss7_spans/span[@name="wp'.$id.'"]');
			if($obj){
				$dom=dom_import_simplexml($obj[0]);
				$dom->parentNode->removeChild($dom);		
			}

			$dom = new DOMDocument('1.0');
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			$dom->loadXML($xml->asXML());
			$dom->save($file);	
			$data->delete_generic($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_link', 'port_id='.$board[2]);				
			return true;
		}
				
		//copy scratch into perm (update)
		$parameters = 'link_name="'.$scratch_m2ua['link_name'] . '",span="'.$span.'",sig_channel="'.$scratch_m2ua['sig_channel'].'",error_type="'.$scratch_m2ua['error_type'].'",lssu="'.$scratch_m2ua['lssu'].'",link_type="'.$scratch_m2ua['link_type'].'",line_type="'.$scratch_m2ua['line_type'].'",cluster="'.$scratch_m2ua['cluster'].'",voice_chans="'.$scratch_m2ua['voice_chans'].'",interface_id="'.$scratch_m2ua['interface_id'].'"';
		$where_param = "port_id=".$board[2];
		$data->update_table ($db, 'perm_'.$board[0].'_'.$board[1].'_m2ua_link', $parameters, $where_param);		
	}
	//$xml->asXML($file);
	$dom = new DOMDocument('1.0');
	$dom->preserveWhiteSpace = false;
	$dom->formatOutput = true;
	$dom->loadXML($xml->asXML());
	$dom->save($file);	
	
	unset($freetdm);	
}

/**
* Generates a mod_media_gateway.conf.xml for physical spans
*/
function generate_mg_board_config($card,$span,$mg_profile,$data,$gen_type = 'new',$db='sqlite:sqlite/cardinfo.db') {
	require_once('freetdm_config/freetdm.php');
	$freetdm = new freetdm_configuration;

	$board = $card;
	$freetdm->db_location = $db;
	$freetdm-> freetdm_generate($board[0], $board[1], $span, $board[2], $data);

	$scratch_mg = $data->select_statement($db,$board[0].'_'.$board[1].'_m2ua_channels','*','port_id='.$board[2]);
	$scratch_m2ua = $data->select_statement($db,$board[0].'_'.$board[1].'_m2ua_link','*','port_id='.$board[2]);
	
	//check if new port or existing port
	$check = $data->select_statement($db,'generated_ports','id','id='.$span);
	$file = $_SESSION['smg_root_path'].'/conf/autoload_configs/mod_media_gateway.conf.xml';
	$xml = simplexml_load_file ($file);

	// Loop around all map entries and check if span is used as a channel prefix
	$obj = $xml->xpath('/configuration/mg_profiles/mg_profile/physical_terminations/map[@channel-prefix="wp'.$span.'"]');
	foreach($obj as $node){
		$dom=dom_import_simplexml($node);
		$dom->parentNode->removeChild($dom);
	}
				
	//if ($check['id'] == "")  {
	if ($gen_type == 'new') {
		//create new

		//get last id value
		$mgID =  pull_array_data('generated_ports','mg_profile',$data);
		$id = 0;
		if (!empty($mgID) ) {
			foreach ($mgID['mg_profile'] as $mg) {
				if ($mg['mg_profile'] !="" )
					$id++;
			}
		}

		//Determine if 1 line required or 2 line required
		if ($scratch_m2ua['sig_channel'] == "") {
			//1 entry
			$wp_span = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
			$p1 = $wp_span[0]->physical_terminations->addChild('map');
			$p1->addAttribute('termination-id-prefix',$scratch_mg['prefix']);
			$p1->addAttribute('termination-id-base',$scratch_mg['base']);
			$p1->addAttribute('tech','freetdm');
			$p1->addAttribute('channel-prefix','wp'.$span);
			$p1->addAttribute('channel-map',$scratch_mg['channel_map']);
		}
		else {
			//2 entries
			//figure out channel map and termination-id-base
			//Returns array of channel info and base
			$chan_info = mg_channels_finder($scratch_mg['channel_map'],$scratch_mg['base']);
			
			if ($chan_info['channels'][0] != "") {
			$wp_span = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
			$p1 = $wp_span[0]->physical_terminations->addChild('map');
			$p1->addAttribute('termination-id-prefix',$scratch_mg['prefix']);
			$p1->addAttribute('termination-id-base',$chan_info['base'][0]);
			$p1->addAttribute('tech','freetdm');
			$p1->addAttribute('channel-prefix','wp'.$span);
			$p1->addAttribute('channel-map',$chan_info['channels'][0]);
			}
			
			if ($chan_info['channels'][1] != "") {
				$wp_span = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
				$p1 = $wp_span[0]->physical_terminations->addChild('map');
				$p1->addAttribute('termination-id-prefix',$scratch_mg['prefix']);
				$p1->addAttribute('termination-id-base',$chan_info['base'][1]);
				$p1->addAttribute('tech','freetdm');
				$p1->addAttribute('channel-prefix','wp'.$span);
				$p1->addAttribute('channel-map',$chan_info['channels'][1]);
			}
		}		
	}
	else {
		//if ($scratch_mg['port_id'] != "") {
		if ($gen_type == 'update') {	
			//update
			$perm_m2ua = $data->select_statement($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_link','sig_channel','port_id='.$board[2]);	
			//find old mg profile
			$old_mg = get_data_values($data,'perm_'.$board[0].'_'.$board[1].'_m2ua_channels','port_id='.$board[2]);
			if ($old_mg['mg_profile'] != $mg_profile)
				$profile = $old_mg['mg_profile'];
			else
				$profile = $mg_profile;

			if ($scratch_m2ua['sig_channel'] == "") {
				//1 entry
				$wp_span = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
				$p1 = $wp_span[0]->physical_terminations->addChild('map');
				$p1->addAttribute('termination-id-prefix',$scratch_mg['prefix']);
				$p1->addAttribute('termination-id-base',$scratch_mg['base']);
				$p1->addAttribute('tech','freetdm');
				$p1->addAttribute('channel-prefix','wp'.$span);
				$p1->addAttribute('channel-map',$scratch_mg['channel_map']);
			}
			else {
				//2 entries
				//figure out channel map and termination-id-base
				//Returns array of channel info and base
				$chan_info = mg_channels_finder($scratch_mg['channel_map'],$scratch_mg['base']);
				if ($chan_info['channels'][0] != "") {
					$wp_span = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
					$p1 = $wp_span[0]->physical_terminations->addChild('map');
					$p1->addAttribute('termination-id-prefix',$scratch_mg['prefix']);
					$p1->addAttribute('termination-id-base',$chan_info['base'][0]);
					$p1->addAttribute('tech','freetdm');
					$p1->addAttribute('channel-prefix','wp'.$span);
					$p1->addAttribute('channel-map',$chan_info['channels'][0]);
				}
				
				if ($chan_info['channels'][1] != "") {
					$wp_span = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
					$p1 = $wp_span[0]->physical_terminations->addChild('map');
					$p1->addAttribute('termination-id-prefix',$scratch_mg['prefix']);
					$p1->addAttribute('termination-id-base',$chan_info['base'][1]);
					$p1->addAttribute('tech','freetdm');
					$p1->addAttribute('channel-prefix','wp'.$span);
					$p1->addAttribute('channel-map',$chan_info['channels'][1]);
				}
			}			
		}
		elseif ($gen_type == 'remove') {	
			//Remove Entries
			// Remove done at beginning, just serialize
			$dom = new DOMDocument('1.0');
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			$dom->loadXML($xml->asXML());
			$dom->save($file);

			//delete entry from perm table
			$data->delete_generic($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_channels','port_id='.$board[2]);
			return true;
		}
	}

	$dom = new DOMDocument('1.0');
	$dom->preserveWhiteSpace = false;
	$dom->formatOutput = true;
	$dom->loadXML($xml->asXML());
	$dom->save($file);

	//check if perm_table exists
	if ($data->check_for_table ($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_channels') < 2) {
		//create perm table
		$create_param = "port_id int, profile_name varchar(100), mg_profile varchar(100), prefix varchar(100), base varchar(100), channel_map varchar(100), ss7_span int";
		$data->create_table($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_channels',$create_param);
	}
	
	
	//delete entry from perm table
	$data->delete_generic($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_channels','port_id='.$board[2]);
	
	//insert into perm table
	$insert_parameters = "port_id,profile_name,mg_profile,prefix,base,channel_map,ss7_span";
	$insert_values = '"'.$board[2].'","'.$scratch_mg['profile_name'].'","'.$scratch_mg['mg_profile'].'","'.$scratch_mg['prefix'].'","'.$scratch_mg['base'].'","'.$scratch_mg['channel_map'].'","'.$scratch_mg['ss7_span'].'"';
	$data->insert_statement($db,'perm_'.$board[0].'_'.$board[1].'_m2ua_channels',$insert_parameters,$insert_values);
	
	//Adds to generated_ports table
	$m2ua_channels_information = $data->select_statement($db,$board[0].'_'.$board[1].'_m2ua_channels','mg_profile,profile_name','port_id='.$board[2]);	
	if ( $scratch_m2ua['sig_channel'] != "")
		$generate_update = "type = \"M2UA Signalling Gateway\", mg_name = \"" . $m2ua_channels_information['mg_profile'] . "\"";
	else
		$generate_update = "type = \"Media Gateway\", mg_name = \"" . $m2ua_channels_information['mg_profile'] . "\"";
		
	$generate_table = "generated_ports";								
	$generate_where = "id = $span";
	$data->update_table ($db, $generate_table, $generate_update, $generate_where);		
}

function generate_mg_profile_config($mg_profile,$data,$gen_type = 'new',$db='sqlite:sqlite/cardinfo.db') {
	$file = $_SESSION['smg_root_path'].'/conf/autoload_configs/mod_media_gateway.conf.xml';
	$xml = simplexml_load_file ($file);
	//$xml->load_file($file);
	//pull mg_profile information
	$mg_profile_info = $data->select_statement($db,'mg_profiles','*','name="'.$mg_profile.'"');
	$updated_data = false;

	if ($gen_type == 'new') {
		//create new profile
		$new_mg = $xml->mg_profiles->addChild('mg_profile');
		$new_mg->addAttribute('name',$mg_profile);
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','protocol');
		$p1->addAttribute('value',$mg_profile_info['protocol']);
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','version');
		$p1->addAttribute('value',$mg_profile_info['megaco_version']);		
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','local-ip');
		$p1->addAttribute('value',$mg_profile_info['ip_addr']);	
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','port');
		$p1->addAttribute('value',$mg_profile_info['port']);	
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','domain-name');
		$p1->addAttribute('value',$mg_profile_info['domain']);	
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','message-identifier');
		$p1->addAttribute('value',$mg_profile_info['mid']);	
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','rtp-termination-id-prefix');
		$p1->addAttribute('value',$mg_profile_info['term_prefix']);	
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','codec-prefs');
		$p1->addAttribute('value','$${global_codec_prefs}');	
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','rtp-ip');
		$p1->addAttribute('value',$mg_profile_info['rtp_ip']);	
		$p1=$new_mg->addChild('param');
		$p1->addAttribute('name','t38-fax-notify');
		$p1->addAttribute('value',$mg_profile_info['t38']);	
		$p1 = $new_mg->addChild('physical_terminations',"");
		$p1 = $new_mg->addChild('peers');
	}
	else {
		if ($gen_type == 'update') {
			//Update mg profile
			$obj = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
			$obj[0]->param[0]->attributes()->value=$mg_profile_info['protocol'];
			$obj[0]->param[1]->attributes()->value=$mg_profile_info['megaco_version'];	
			$obj[0]->param[2]->attributes()->value=$mg_profile_info['ip_addr'];
			$obj[0]->param[3]->attributes()->value=$mg_profile_info['port'];	
			$obj[0]->param[4]->attributes()->value=$mg_profile_info['domain'];	
			$obj[0]->param[5]->attributes()->value=$mg_profile_info['mid'];
			$obj[0]->param[6]->attributes()->value=$mg_profile_info['term_prefix'];
			$obj[0]->param[8]->attributes()->value=$mg_profile_info['rtp_ip'];
			$obj[0]->param[9]->attributes()->value=$mg_profile_info['t38'];

                        $where_param = "name=\"" . $mg_profile_info['name'] . "\"";
                        $param = "ip_addr = '" . $mg_profile_info['ip_addr'] . "', port = '" . $mg_profile_info['port'] . "', \"domain\" = '" . $mg_profile_info['domain'] . "', mid = '" . $mg_profile_info['mid'] . "', term_prefix = '" . $mg_profile_info['term_prefix'] . "', protocol = '" . $mg_profile_info['protocol'] . "', megaco_version = '" . $mg_profile_info['megaco_version'] . "', default_codec='" . $mg_profile_info['default_codec'] . "', rtp_ip ='" . $mg_profile_info['rtp_ip'] . "', t38 = '" . $mg_profile_info['t38'] . "'";
                        $data->update_table($db,'perm_mg_profiles',$param,$where_param);
			$updated_data = true;

		}
		elseif ($gen_type == 'remove') {
			//Remove Entries
			$obj = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
			if ($obj[0]->attributes()->{'name'} == $mg_profile) {
				//unset ($obj);
		        $dom=dom_import_simplexml($obj[0]);
		        $dom->parentNode->removeChild($dom);
			}

			$dom = new DOMDocument('1.0');
			$dom->preserveWhiteSpace = false;
			$dom->formatOutput = true;
			$dom->loadXML($xml->asXML());
			$dom->save($file);
			
			//drop perm tables
			$data->delete_generic($db,'perm_mg_profiles','name="'.$mg_profile.'"');
			$data->drop_table($db,'perm_',$mg_profile.'_peers');
			
			return true;
		}
	}

	$dom = new DOMDocument('1.0');
	$dom->preserveWhiteSpace = false;
	$dom->formatOutput = true;
	$dom->loadXML($xml->asXML());
	$dom->save($file);

	unset($xml);

	if (!$updated_data) {
		//delete perm table entry
		$data->delete_generic($db,'perm_mg_profiles','name="'.$mg_profile_info['name'].'"');
		//insert into perm table
		$insert_params = 'id,name,ip_addr,port,protocol,domain,mid,rtp_port_min,rtp_port_max,term_prefix,term_id_len,megaco_version,default_codec,rtp_ip,t38';
		$insert_values = $mg_profile_info['id'] . ',"'.$mg_profile_info['name'].'","'.$mg_profile_info['ip_addr'].'","'.$mg_profile_info['port'].'","'.$mg_profile_info['protocol'].'","'.$mg_profile_info['domain'].'","'.$mg_profile_info['mid'].'","'.$mg_profile_info['rtp_port_min'].'","'.$mg_profile_info['rtp_port_max'].'","'.$mg_profile_info['term_prefix'].'","'.$mg_profile_info['term_id_len'].'","'.$mg_profile_info['megaco_version'].'","'.$mg_profile_info['default_codec'].'","'.$mg_profile_info['rtp_ip'].'","'.$mg_profile_info['t38'].'"';
		$data->insert_statement($db,'perm_mg_profiles',$insert_params,$insert_values);
	}
}


function generate_peers ($mg_profile,$peer_name,$data,$gen_type = 'new',$db='sqlite:sqlite/cardinfo.db') {
	//Update/insert/remove peer data
	$file = $_SESSION['smg_root_path'].'/conf/autoload_configs/mod_media_gateway.conf.xml';
	$xml = simplexml_load_file ($file);
	$peers = $data->select_statement($db,$mg_profile.'_peers','*','name="'.$peer_name.'"');

	if ($gen_type == "new") {
		//create
		//Add to the mg_profile peer tag
		$new_peer =  $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');
		$p1 = $new_peer[0]->peers->addChild('param');
		$p1->addAttribute('name','peer');
		$p1->addAttribute('value',$peer_name);
		
		$new_peer = $xml->mg_peers->addChild('mg_peer');
		$new_peer->addAttribute('name',$peers['name']);
		$p1=$new_peer->addChild('param');
		$p1->addAttribute('name','ip');
		$p1->addAttribute('value',$peers['ip_addr']);
		$p1=$new_peer->addChild('param');
		$p1->addAttribute('name','port');
		$p1->addAttribute('value',$peers['port']);		
		$p1=$new_peer->addChild('param');
		$p1->addAttribute('name','encoding-scheme');
		$p1->addAttribute('value',$peers['encoding_scheme']);	
		$p1=$new_peer->addChild('param');
		$p1->addAttribute('name','transport-type');
		$p1->addAttribute('value',$peers['protocol']);	
		$p1=$new_peer->addChild('param');
		$p1->addAttribute('name','message-identifier');
		$p1->addAttribute('value',$peers['mid']);	
		if ($peers['domain'] != "") {
			$p1=$new_peer->addChild('param');
			$p1->addAttribute('name','domain-name');
			$p1->addAttribute('value',$peers['domain']);
		}
	}
	elseif ($gen_type == 'remove') {
		//remove
		$obj = $xml->xpath('/configuration/mg_peers/mg_peer[@name="'.$peer_name.'"]');

		if ($obj[0]->attributes()->name == $peer_name) {
			//unset ($obj);
	        $dom=dom_import_simplexml($obj[0]);
	        $dom->parentNode->removeChild($dom);			
		}
		
		//remove from mg peers section
		$obj = $xml->xpath('/configuration/mg_profiles/mg_profile[@name="'.$mg_profile.'"]');

		$p1 = $obj[0]->xpath('peers/param[@value="'.$peer_name.'"]');
		
		if ($p1[0]->attributes()->value == $mg_profile) {
			$dom=dom_import_simplexml($p1[0]);
			$dom->parentNode->removeChild($dom);
		}

		//remove peer
		$data->delete_generic($db,'perm_'.$mg_profile.'_peers','name="'.$peer_name.'"');
	}
	elseif ($gen_type == 'update') {
		//update
		$obj = $xml->xpath('/configuration/mg_peers/mg_peer[@name="'.$peer_name.'"]');
		$obj[0]->param[0]->attributes()->value = $peers['ip_addr'];
		$obj[0]->param[1]->attributes()->value = $peers['port'];
		$obj[0]->param[2]->attributes()->value = $peers['encoding_scheme'];
		$obj[0]->param[3]->attributes()->value = $peers['protocol'];
		$obj[0]->param[4]->attributes()->value = $peers['mid'];
		
		if ($peers['domain'] != "") {
			if(isset($obj[0]->param[5])){
	            if ($obj[0]->param[5]->attributes()->name = 'domain-name') {
	                $obj[0]->param[5]->attributes()->value = $peers['domain'];
		        }
			}
			else {
				//add the value
				$p1=$obj[0]->addChild('param');
				$p1->addAttribute('name','domain-name');
				$p1->addAttribute('value',$peers['domain']);
			}
		}
	}
	
	//$xml->asXML($file);
	$dom = new DOMDocument('1.0');
	$dom->preserveWhiteSpace = false;
	$dom->formatOutput = true;
	$dom->loadXML($xml->asXML());
	$dom->save($file);
}


function pull_array_data($table,$param,$data,$db='sqlite:sqlite/cardinfo.db') {
	$c = 0;
	$profile_array = array();

	//Table exists
	if ($data->check_for_table ($db, $table) > 1)
	{
		$select = "SELECT " . $param . " FROM " . $table . ";";
		try
		{
			//open the database
			$db = new PDO($db);

			$result = $db->query($select);
			if (!empty($result) ) {
				foreach($result as $row)
				{
					$profile_array[$c] = $row;
					$c++;
				}
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			//echo "hello <br />";
			print 'Exception : '.$e->getMessage();
		}
	}	
	return $profile_array;
}

/**
*	Determines the base and channel map for the xml file
*/
function mg_channels_finder($channel_map,$mg_base="") {
	$chans = explode(',',$channel_map);
	if (count($chans) == 2) {
		$a = 1;
		foreach ($chans as $chan) {
			$s_pos = strpos($chan,'s');
			$g_pos = strpos($chan,'g');
			if ($s_pos !== false || $g_pos !== false) {
				if ($s_pos !== false)
					$sig_type = 's';
				elseif ($g_pos !== false)
					$sig_type = 'g';
			}
			else{
				$channel_map = $chan;
				$channels = explode ('-',$chan);
				
				if ($sig_type == 's')
					$base = $mg_base + 1;
				elseif ($sig_type == 'g')
					$base = $mg_base;
				else
					$base = $mg_base;

				unset($sig_type);
				$return_array = array (
					'channels' => array(0=>$channel_map),
					'base' => array(0=>$base)
				);
			}
			$a++;
		}
	}
	elseif (count($chans) > 2) {
		$a = 1;
		$b = 0;
		foreach ($chans as $chan) {
			$s_pos = strpos($chan,'s');
			$g_pos = strpos($chan,'g');
			if ($s_pos !== false || $g_pos !== false) {
				if ($s_pos !== false)
					$sig_type = 's';
				elseif ($g_pos !== false)
					$sig_type = 'g';
				
				$location = $a + 1;
			}
			else {
				if ($a == 1) {
					//First portion of the channel map. No signalling link found here.
					$channel_map = $chan;
					$base = $mg_base;
				}
				elseif ($a == count($chans)) {
					//signalling link present just before the end
					$channels = explode ('-',$chan);
					if ($sig_type == 's')
						$base = ($mg_base + $channels[0]) - 1;
					elseif ($sig_type == 'g')
						$base = ($mg_base + $channels[0]) - 2;
					
					$channel_map = $chan;
				}
				else {
					//placed just in case of multiple signalling links
					$channels = explode ('-',$chan);
					if ($sig_type == 's')
						$base = ($mg['base'] + $channels[0]) - 1;
					elseif ($sig_type == 'g')
						$base = ($mg['base'] + $channels[0]) - 2;
					
					$channel_map = $chan;
				}
			}
			
			//$channel_map = $chans[0].','.$chans[2];
			$a++;
			if ($a != $location) {
				$return_array['channels'][$b] = $channel_map;
				$return_array['base'][$b] = $base;
				$b++;
			}
		}
		unset($sig_type);
	}
	else {
		//No signalling channels
		$channel_map = $mg['channel_map'];
		$base = $mg_base;
		$return_array = array (
			'channels' => array(0=>$channel_map),
			'base' => array(0=>$base)
		);	
	}
	return $return_array;
}

function add_new_cluster($cluster_name,$cluster_id,$data,$gen_type = 'new',$db='sqlite:sqlite/cardinfo.db') {
	$file = $_SESSION['smg_root_path'].'/conf/autoload_configs/freetdm.conf.xml';
	$xml = simplexml_load_file ($file);
	
	$scratch_cluster = $data->select_statement($db,'m2ua_clusters','*','id='.$cluster_id);
	// find all peers to get highest value
	$peer_id = 0;
	$obj = $xml->xpath('/configuration/signaling_configs/sngss7_configs/sng_isup/sng_m2ua_peer_interfaces/sng_m2ua_peer_interface/param[@name="id"]');
	if (!empty ($obj)) {
		foreach($obj as $node){
			if($peer_id < (int)$node->attributes()->{'value'})
				$peer_id = (int)$node->attributes()->{'value'};
		}
	}
	$peer_id++;	

	if ($gen_type == 'new') {
		$new_cluster =  $xml->signaling_configs->sngss7_configs->sng_isup->sng_m2ua_cluster_interfaces->addChild('sng_m2ua_cluster_interface');
		$new_cluster->addAttribute('name',$cluster_name);
		$p1=$new_cluster->addChild('param');
		$p1->addAttribute('name','id');
		$p1->addAttribute('value',$cluster_id);
		$p1=$new_cluster->addChild('param');
		$p1->addAttribute('name','traffic-mode');
		$p1->addAttribute('value',$scratch_cluster['traffic_mode']);
		$p1=$new_cluster->addChild('param');
		$p1->addAttribute('name','load-share-algorithm');
		$p1->addAttribute('value',$scratch_cluster['load_share']);	
		$p1=$new_cluster->addChild('sng_m2ua_peers');
		
		//pull all peers from cluster peer table
		$cl_peers = pull_array_data($cluster_name.'_peers','*',$data);
		
		$saved_peer_id = $peer_id;
		foreach ($cl_peers as $peer) {
			//append peers section
			$p2=$p1->addChild('param');
			$p2->addAttribute('name','m2ua-peer-interface-id');
			$p2->addAttribute('value',$peer_id);
			$peer_id++;
		}
		
		//Create document
		$dom = new DOMDocument('1.0');
		$dom->preserveWhiteSpace = false;
		$dom->formatOutput = true;
		$dom->loadXML($xml->asXML());
		$dom->save($file);
		
		//Update peers section with peer information
		$peer_id = $saved_peer_id;
		foreach ($cl_peers as $peer) {
			//Find associated sctp interface id
			$sctp_id = get_data_values($data,'sctp_interfaces','profile_name="'.$peer['sctp_int_name'].'"');
			$new_peer =  $xml->signaling_configs->sngss7_configs->sng_isup->sng_m2ua_peer_interfaces->addChild('sng_m2ua_peer_interface');
			$new_peer->addAttribute('name',$peer['profile_name']);
			$p1=$new_peer->addChild('param');
			$p1->addAttribute('name','id');
			//$p1->addAttribute('value',$peer['id']);
			$p1->addAttribute('value',$peer_id);
			$peer_id++;
			$p1=$new_peer->addChild('param');
			$p1->addAttribute('name','include-asp-identifier');
			if ($peer['include-asp-identifier'] == "disable")
				$p1->addAttribute('value','FALSE');			
			else
				$p1->addAttribute('value','TRUE');	
			$p1=$new_peer->addChild('param');
			$p1->addAttribute('name','sctp-interface-id');
			$p1->addAttribute('value',$sctp_id['id']);
			$p1=$new_peer->addChild('sng_destination_addresses');
			
			//include dest_ip_addr_X in file if not empty
			if ($peer['dest_ip_addr_1'] != "") {
				$p2 = $p1->addChild('param');
				$p2->addAttribute('name','address');
				$p2->addAttribute('value',$peer['dest_ip_addr_1']);
			}
			if ($peer['dest_ip_addr_2'] != "") {
				$p2 = $p1->addChild('param');
				$p2->addAttribute('name','address');
				$p2->addAttribute('value',$peer['dest_ip_addr_2']);
			}
			if ($peer['dest_ip_addr_3'] != "") {
				$p2 = $p1->addChild('param');
				$p2->addAttribute('name','address');
				$p2->addAttribute('value',$peer['dest_ip_addr_3']);
			}
			if ($peer['dest_ip_addr_4'] != "") {
				$p2 = $p1->addChild('param');
				$p2->addAttribute('name','address');
				$p2->addAttribute('value',$peer['dest_ip_addr_4']);
			}
			if ($peer['dest_ip_addr_5'] != "") {
				$p2 = $p1->addChild('param');
				$p2->addAttribute('name','address');
				$p2->addAttribute('value',$peer['dest_ip_addr_5']);
			}
			
			$p1=$new_peer->addChild('param');
			$p1->addAttribute('name','destination-port');
			$p1->addAttribute('value',$peer['dest_port']);
			$p1=$new_peer->addChild('param');
			$p1->addAttribute('name','number-of-outgoing-streams');
			$p1->addAttribute('value',$peer['num_out_streams']);	
			$p1=$new_peer->addChild('param');
			$p1->addAttribute('name','init-sctp-association');
			if ($peer['sctp_association'] == "disable")
				$p1->addAttribute('value','FALSE');	
			else
				$p1->addAttribute('value','TRUE');												
		}

		//Create document
		$dom = new DOMDocument('1.0');
		$dom->preserveWhiteSpace = false;
		$dom->formatOutput = true;
		$dom->loadXML($xml->asXML());
		$dom->save($file);
		
		//update tables
		$table = 'perm_m2ua_clusters';
		$insert_param = 'id, profile_name,traffic_mode,load_share';
		$insert_values='"'.$scratch_cluster['id'].'","'.$scratch_cluster['profile_name'].'","'.$scratch_cluster['traffic_mode'].'","'.$scratch_cluster['load_share'].'"';
		$data->insert_statement($db,$table,$insert_param,$insert_values);
		
		//create cluster peer perm table
		$table_name = $cluster_name."_peers";						
		$new_table = "perm_".$cluster_name."_peers";
		$data->drop_table($db,$new_table);
		$data->select_into($db,$table_name, "*", $new_table);		
	}
	
	return true;
}

function add_new_sctp($sctp_name,$sctp_id,$data,$gen_type = 'new',$db='sqlite:sqlite/cardinfo.db') {
	$file = $_SESSION['smg_root_path'].'/conf/autoload_configs/freetdm.conf.xml';
	$xml = simplexml_load_file ($file);
	
	$scratch_sctp = $data->select_statement($db,'sctp_interfaces','*','id='.$sctp_id);
	
	
	if ($gen_type == "new") {
		
		$new_sctp = $xml->signaling_configs->sngss7_configs->sng_isup->sng_sctp_interfaces->addChild('sng_sctp_interface');
		$new_sctp->addAttribute('name',$sctp_name);
		$p1=$new_sctp->addChild('param');
		$p1->addAttribute('name','id');
		$p1->addAttribute('value',$sctp_id);
		
		$p1=$new_sctp->addChild('sng_source_addresses');
		
		if ($scratch_sctp['dest_ip_1'] != "") {
			$p2=$p1->addChild('param');
			$p2->addAttribute('name','address');
			$p2->addAttribute('value',$scratch_sctp['dest_ip_1']);
		}
		if ($scratch_sctp['dest_ip_2'] != "") {
			$p2=$p1->addChild('param');
			$p2->addAttribute('name','address');
			$p2->addAttribute('value',$scratch_sctp['dest_ip_2']);
		}		
		if ($scratch_sctp['dest_ip_3'] != "") {
			$p2=$p1->addChild('param');
			$p2->addAttribute('name','address');
			$p2->addAttribute('value',$scratch_sctp['dest_ip_3']);
		}	
		if ($scratch_sctp['dest_ip_4'] != "") {
			$p2=$p1->addChild('param');
			$p2->addAttribute('name','address');
			$p2->addAttribute('value',$scratch_sctp['dest_ip_4']);
		}				
		if ($scratch_sctp['dest_ip_5'] != "") {
			$p2=$p1->addChild('param');
			$p2->addAttribute('name','address');
			$p2->addAttribute('value',$scratch_sctp['dest_ip_5']);
		}	
		$p1=$new_sctp->addChild('param');
		$p1->addAttribute('name','source-port');
		$p1->addAttribute('value',$scratch_sctp['port']);	
		
		//Create document
		$dom = new DOMDocument('1.0');
		$dom->preserveWhiteSpace = false;
		$dom->formatOutput = true;
		$dom->loadXML($xml->asXML());
		$dom->save($file);
		
		//Update perm table
		$table = 'perm_sctp_interfaces';
		$insert_param = 'id, profile_name,dest_ip_1,dest_ip_2,dest_ip_3,dest_ip_4,dest_ip_5,port';
		$insert_values=$scratch_sctp['id'].',"'.$scratch_sctp['profile_name'].'","'.$scratch_sctp['dest_ip_1'].'","'.$scratch_sctp['dest_ip_2'].'","'.$scratch_sctp['dest_ip_3'].'","'.$scratch_sctp['dest_ip_4'].'","'.$scratch_sctp['dest_ip_5'].'",'.$scratch_sctp['port'];
		$data->insert_statement($db,$table,$insert_param,$insert_values);
	}
	
	return true;
}

function get_data_values($data,$table,$where_clause,$db=NULL) {
	if (!isset($db))
		$db='sqlite:sqlite/cardinfo.db';
		
	$db_info = $data->select_statement($db,$table,'*',$where_clause);
	return $db_info;
}

?>
