<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class ui_prod_test
{
	//Class variables
	public $tokenization = "";						//Contains the class functions and variables required for finding out which TDM cards are detected
	public $parse_results = "";						//Contains all the data returned by the "wanrouter hwprobe dump" command
	public $wanrouter_error = "";					//Contains the error message found when wanrouter is started/stopped
	public $sngmp_stop_error = "";					//Contains the error message found when sngmp is started/stopped
	public $sngmp_error_msg = "";					//Contains the sngmp error message
	public $wanrouter_error_msg = "";				//Contains the wanrouter error message
	private $hdlc_test_results = array();			//Contains the hdlc test results
	private $mp_bert_output = array();				//Contains the bert test results
	private $hdlc_test_results_no_echo = array();	//Contains the hdlc test results
	
	//Main HTML Page
	function main()
	{
		include_once '../display_class.php';
		$display_common = new Display_common;
		
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
		{
			echo "<h3>TDM/MEDIA SELF-TEST</h3>\n";
			echo "<p>Please select from the options below in order to run a production test on your hardware.<br />\n
					You may run this test only on A10X hardware or any Media Processing hardware</p>\n";
			//echo "<hr style='width:700px;' align='left'/>\n";
		}
		
		//If any cards are detected in the system
		if ($this->prod->card_error == "YES" || $this->prod->num_a101 == 0 && $this->prod->num_a102 == 0 && $this->prod->num_a104 == 0 && $this->prod->num_a108 == 0 && count($this->prod->mp_cards) == 0)
		{
			//No Cards Found
			echo "<font color=\"red\"><b>No Cards Found</b></font>\n";
			echo "Please Insert a TDM card or Media Processing Card into your system in order to run the self-test\n";
		}
		elseif ($this->prod->num_a101 != 0 || $this->prod->num_a102 != 0 || $this->prod->num_a104 != 0 || $this->prod->num_a108 != 0 || count($this->prod->mp_cards) != 0)
		{	
		?>
        <table>
        <tr>
        <td>	
        <?php
			//If any TDM Hardware was detected
			if ($this->prod->a101count > 0 || $this->prod->a102count > 0 || $this->prod->a104count > 0 || $this->prod->a108count > 0)
			{
		?>
        <table width="370px" <?php echo $_SESSION['table_class']; ?>>
			<th colspan="4" class="widget-content-header ui-state-active ui-corner-top" align='left'>TDM Cards</th>
		 	<tr align="center">
            	<td class='mytableheader ui-state-active'>Card Name</td>
                <td class='mytableheader ui-state-active'>Card Type</td>
                <td class='mytableheader ui-state-active'>Number of Cards</td>
                <td class='mytableheader ui-state-active'>Number of Spans</td>
            </tr>
        <?php
				if ($this->prod->num_a101 > 0)
				{
					echo "<tr align=\"center\">\n";
					echo "<td>A101</td>\n";
					echo "<td>1 Port T1/E1</td>\n";
					echo "<td>" . $this->prod->num_a101 . "</td>\n";
					echo "<td>" . $this->prod->num_a101 * 1 . "</td>\n";
					echo "</tr>\n";
				}
				if ($this->prod->num_a102 > 0)
				{
					echo "<tr align=\"center\">\n";
					echo "<td>A102</td>\n";
					echo "<td>2 Port T1/E1</td>\n";
					echo "<td>" . $this->prod->num_a102 . "</td>\n";
					echo "<td>" . $this->prod->num_a102 * 2 . "</td>\n";
					echo "</tr>\n";
				}
				if ($this->prod->num_a104 > 0)
				{
					echo "<tr align=\"center\">\n";
					echo "<td>A104</td>\n";
					echo "<td>4 Port T1/E1</td>\n";
					echo "<td>" . $this->prod->num_a104 . "</td>\n";
					echo "<td>" . $this->prod->num_a104 * 4 . "</td>\n";
					echo "</tr>\n";
				}
				if ($this->prod->num_a108 > 0)
				{
					echo "<tr align=\"center\">\n";
					echo "<td>A108</td>\n";
					echo "<td>8 Port T1/E1</td>\n";
					echo "<td>" . $this->prod->num_a108 . "</td>\n";
					echo "<td>" . $this->prod->num_a108 * 8 . "</td>\n";
					echo "</tr>\n";
				}
		?>
        </table>
		</td>
       
        <?php
			}
		
			//If any media processing cards were detected
			if (count($this->prod->mp_cards) > 0)
			{
			?>
         <td>    
        <table width="100px" <?php echo $_SESSION['table_class']; ?>>
        <?php					
					$center = "align=\"center\"";
					echo "<th colspan=\"4\" class=\"widget-content-header ui-state-active ui-corner-top\" align='left'>Media Cards</th>";
					echo "<tr $center>\n";
            		echo "<td class='mytableheader ui-state-active'><b>Interface</b></td>\n";
            		echo "</tr>\n";

				for ($a = 0; $a < count($this->prod->mp_cards); $a++)
				{
					$counter = $a + 1;
					echo "<tr $center><td>" . $this->prod->mp_cards[$a] . "</td></tr>\n";
				}		
				echo "</table>\n";
				echo "</td>\n";
			}
		?>
        </table>

        <br />
        <p>
        <?php
				if ($this->prod->a101count > 0 || $this->prod->a102count > 0 || $this->prod->a104count > 0 || $this->prod->a108count > 0)
				{
		?>
		Total number of TDM Spans = <?php echo $this->prod->num_spans; ?><br />

        <?php
				}
				if (count($this->prod->mp_cards) > 0)
				{
		?>
		Total Number of Media Processing Cards = <?php echo $counter; ?>
        <?php
				}
			
		?>
        </p><br /><br />	
        <hr style='width:700px;' align='left'/>

        <form method="post">
        <?php
			if ($this->prod->a101count > 0 || $this->prod->a102count > 0 || $this->prod->a104count > 0 || $this->prod->a108count > 0)
			{
		?>
   	        <h4>Additional Options</h4>
            <table>
            	<tr>
                	<td>Please select whether you would like to run the TDM Self Test in T1 or E1 mode:</td>
                    <td>
			            <select name="line_type">
        			    	<option value="T1" <?php if ($_REQUEST['line_type'] == "T1") { echo "selected = \"selected\""; } ?> >T1</option>
                			<option value="E1" <?php if ($_REQUEST['line_type'] == "E1") { echo "selected = \"selected\""; } ?> >E1</option>
            			</select>
                    </td>
               </tr>
          	</table>
        <?php
			}
	
	  	//echo "<br />\n";
        echo "<p>\n";
	
		$cmd = "pidof " . $_SESSION['gateway_script'];
		
		exec ("/usr/sbin/wanrouter status | grep -c 'wanpipe'",$wan);
		exec ($cmd,$smg);
		//echo $wan[0] . ", " . $smg[0];
		
		if (isset($_REQUEST['embedded']) && isset($_SESSION['embedded']))
		{
			if ($display_common->IsRenderingNonDynamicDiv( )  
			  || $display_common->IsDynamicDivRefreshRequest('NotificationDiv') )
			{
			  // ************************************************************************************
			  // Notification Dynamic Div
			  // ************************************************************************************
			  $display_common->DynamicDivBegin( "NotificationDiv","width:700px");
			  echo "<br/>\n";
			
			  // Check if TDM configuration is in synch
			  if ($wan[0] != 0 && $smg[0] != "")
			  {
				  $display_common->WarningBox( 
					"<table><tr><td>\n".
					"" .
					"</td>\n".
					"<td>\n".
					"<ul>\n" .
					"<li>Stop the  <a href='../controls_embedded.php'>Gateway</a> to proceed with the Self-Test</li>\n" .
					"" .
					"</ul>\n".
					"</td></tr></table>\n" );
			  }    
				// Close dynamic div
			  $display_common->DynamicDivEnd( "NotificationDiv" );
			}
		}
         if ( $wan[0] != 0 || $smg[0] != "" )
		 {
			 if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
			 {
    	    	echo "<font color='red'>The Gateway is currently started. Please stop the gateway by navigating to the <a href='../controls_embedded.php'>Control Panel</a> in order to proceed<br />with the Self-Test</font><br />\n";
			 }
	    ?>
        	<input type="submit" name="run" value="Run Test" <?php echo $_SESSION['disabled_button_class']; ?> disabled="disabled"/>      
            </p>
        </form>
        <?php			 
		 }
		 else
		 {
  		?>
        	<input type="submit" name="run" value="Run Test" <?php echo $_SESSION['button_class']; ?>/>      
            </p>
        </form>
        <?php
		 }
		//After the submit button is pressed, display the information from the test
		
		if ($_REQUEST['run'] == "Run Test")
		{
			echo "<hr style='width:700px;' align='left'/><br />\n";
			
			//Display the error messages
			if ($this->wanrouter_error_msg != "" || $this->sngmp_error_msg != "")
			{
				echo $this->wanrouter_error_msg;
				echo $this->sngmp_error_msg;
			}
			
			//Display TDM HDLC Test Results
			if ($this->prod->num_a101 != 0 || $this->prod->num_a102 != 0 || $this->prod->num_a104 != 0 || $this->prod->num_a108 != 0)
			{
				for ($ll = 0; $ll < count($this->hdlc_test_results); $ll++)
				{
					if ($this->hdlc_test_results[$ll] == "|result=passed|")
					{
						$if = "passed";
					}
					else
					{
						$if = "failed";
					}
				}	
				
				for ($ll = 0; $ll < count($this->hdlc_test_results_no_echo); $ll++)
				{
					if ($this->hdlc_test_results_no_echo[$ll] == "|result=passed|")
					{
						$if2 = "passed";
					}
					else
					{
						$if2 = "failed";
					}
				}					
				//echo "$if, $if2 <br />";
				echo "<b><u>A10x HDLC Test Results</u></b><br /><br />\n";
				echo "Line Mode: " . $_REQUEST['line_type'] . "<br />\n";
	
				echo "Echo Cancellation: ENABLED<br />\n";
	
				if ($if == "passed")
				{			
					echo "<font color=\"green\">All Spans Passed HDLC Test</font><br />\n";
				}
				else
				{
					//var_dump ($this->hdlc_test_results);
					//Displays only the failed spans
					for ($ll = 0; $ll < count($this->hdlc_test_results); $ll++)
					{
						//echo $this->hdlc_test_results[$ll] . "<br />";
						if (preg_match('/failed/',$this->hdlc_test_results[$ll]) && $this->hdlc_test_results[$ll] != "|result=failed|")
						{
							echo "<font color=\"red\">" . $this->hdlc_test_results[$ll] . "</font><br />\n";
						}
					}
				}
				echo "<br />\n";
				echo "Echo Cancellation: BYPASSED<br />\n";
				if ($if2 == "passed")
				{			
					echo "<font color=\"green\">All Spans Passed HDLC Test</font><br />\n";
				}
				else
				{
					//Displays only the failed spans
					for ($ll = 0; $ll < count($this->hdlc_test_results_no_echo); $ll++)
					{
						//echo $this->hdlc_test_results_no_echo[$ll] . "<br />";
						if (preg_match('/failed/',$this->hdlc_test_results_no_echo[$ll]) && $this->hdlc_test_results_no_echo[$ll] != "|result=failed|")
						{
							echo "<font color=\"red\">" . $this->hdlc_test_results_no_echo[$ll] . "</font><br />\n";
						}
					}
				}											
			}
						
			//Display Media Processing Test Results
			if (count($this->prod->mp_cards) > 0)
			{
				echo "<br />\n";
				echo "<b><u>Media Processing Test Results</u></b><br /><br />\n";
				
				for ($a = 0; $a < count($this->prod->mp_cards); $a++)
				{
					echo "Tested: " . $this->prod->mp_cards[$a] . "<br />\n";
					//echo "Number of sessions = " . $this->prod->tc_sessions[$a] . "<br />\n";
					
					//Display output of bert command
					if ($this->mp_bert_output[$a] == 0)
					{
						echo "<font color=\"green\">" . $this->prod->mp_cards[$a] . " passed the Production Test</font><br />\n";
					}
					else
					{
						echo "<font color=\"red\">" . $this->prod->mp_cards[$a] . " failed the Production Test</font><br />\n";
					}
					echo "<br />\n";
				}	
			}
		
		}
		}
	}
	
	
	//Detects all cards in system
	function detect()
	{
		//Find out which cards are detected
		$this->prod->parse_results = $this->tokenization->get_information();
		$this->prod->get_cards();
		$this->prod->find_mp_cards();
		$this->prod->calc_num_spans();
	}
	
	//Stops services
	function service_stop()
	{
		//Stops smg
		$this->prod->smg("stop");

		if (isset($this->prod->a101count) || isset($this->prod->a102count) || isset($this->prod->a104count) || isset($this->prod->a108count))
		{
			//Stops wanrouter
			$this->wanrouter_error = $this->prod->wanrouter("stop");
		}	
		
		if (isset($this->prod->mp_cards))
		{
			$this->sngmp_stop_error = $this->prod->sngmp_server("stop");	
		}
	}
	
	//Starts services
	function service_start()
	{
		if (isset($this->prod->a101count) || isset($this->prod->a102count) || isset($this->prod->a104count) || isset($this->prod->a108count))
		{
			$this->wanrouter_error = $this->prod->wanrouter("start");
		}
		if (isset($this->prod->mp_cards))
		{
			$this->sngmp_stop_error = $this->prod->sngmp_server("start");	
		}
	}
	
	//Create configs
	function create_configurations()
	{
		$this->prod->line_type = $_REQUEST['line_type'];
		
		if (isset($this->prod->a101count) || isset($this->prod->a102count) || isset($this->prod->a104count) || isset($this->prod->a108count))
		{
			$this->prod->create_wanpipe_devices();
		}
		
		if (isset($this->prod->mp_card))
		{
			$this->prod->sngtc_server_file();
		}
	}
	
	//Check for error messages when starting/stopping services
	function check_error()
	{
		if ($this->wanrouter_error == "yes")
		{
			//Error
			$this->wanrouter_error_msg =  "<font color=\"red\"><b>There was an error with the TDM Driver.</b></font><br />\n
						  				   <font color=\"red\"><b>Please contact Sangoma Technical Support at techdesk@sangoma.com for more help with the issue</b></font><br />\n";	
		}
		if ($this->sngmp_stop_error == "yes")
		{
			//Error
			$this->sngmp_error_msg =  "<font color=\"red\"><b>Error w media processing service.</b></font><br />\n
				  				       <font color=\"red\"><b>Please contact Sangoma Technical Support at techdesk@sangoma.com for more help with the issue</b></font><br />\n";
		}
	}
	
	//TDM HDLC Test
	function hdlc_test()
	{
		for ($l = 0; $l <= $this->prod->total_span; $l++)
		{
			$this->prod->digital_loopback($l);
		}
		
		//Waits for the wanpipes to become connected
		$this->prod->wanrouter_connected();		
				
		//Put all in mpd mode
		for ($l = 0; $l <= $this->prod->total_span; $l++)
		{
			$this->prod->mpd($l);
		}
		//echo "running hdlc test<br />";
		
		//Runs HDLC Test	
		$this->hdlc_test_results = $this->prod->hdlc_test();
		
		//Bypasses the echo canceler if user asked to bypass the echo canceler
		for ($l = 0; $l <= $this->prod->total_span; $l++)
		{
			$this->prod->bypass_disable($l);
		}			
			
		//Runs HDLC Test	
		$this->hdlc_test_results_no_echo = $this->prod->hdlc_test();
				
	}
	
	//Media Processing Bert Test
	function mp_bert()
	{
		for ($a = 0; $a < count($this->prod->mp_cards); $a++)
		{
			//Bring interfaces up
			$this->prod->interface_up($a);
			
			//Run the test
			$this->mp_bert_output[$a] = $this->prod->run_sngmp_bert($a);
		}			
	}
	
}

?>
