<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Database Class
class database_class
{
	public function drop_all_tables($dbs="sqlite:sqlite/cardinfo.db") {
		try {
			//open the database			
			$db = new PDO ($dbs);
			$q = "select tbl_name from sqlite_master where type='table' AND tbl_name LIKE 'perm_%'";
			//echo $q . "<br />";
			$resq = $db->query ($q);
			$cols = $resq->fetchAll (PDO::FETCH_BOTH);
			$num = count ($cols);

			try
			{
				foreach ($cols as $table_names) {
					//Drop old table
					$name = $table_names['tbl_name'];
					$this->drop_table($dbs, $name);
				}
			}
			catch(PDOException $e) {
				print 'Exception : '.$e->getMessage() . '<br />';
				echo "Database location = $db, table = $table_name<br />";
			}
			
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage(). '<br />';
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $q<br />";
		}
	}
	
	//Checks the schema for that schema and tells me if the tables are the same. If they are not the same it replaces the existing table with the new one.
	//num_columns = number of columns the new table should have
	function check_schema($db_location, $table_name, $parameters, $num_columns, $insert_parameters)
	{
		//Checks if the database exists
		try
		{
			//open the database			
			$db = new PDO ($db_location);
			$q = "PRAGMA table_info(" . $table_name . ");";
			//echo $q . "<br />";
			$resq = $db->query ($q);
			$cols = $resq->fetchAll (PDO::FETCH_BOTH);
			$num = count ($cols);

			if ($num_columns !=  $num)
			{
				//echo "columns not equal, drop table and recreate it<br />";
				
				//Rename old table
				$alter = "ALTER TABLE " . $table_name . " RENAME TO " . $table_name . "_old;";
				$old_table_name = $table_name . "_old";
				//echo $alter . "<br />";
				$db->exec($alter);
				
				//Create new table
				$this->create_table($db_location,$table_name,$parameters);
				
				//Upgrade the table with the new columns
				$insert = "INSERT INTO " . $table_name . " ( " . $insert_parameters . " ) SELECT * FROM " . $old_table_name . ";";
				//echo $insert . "<br />";
		
		
				try
				{
					//open the database
					$db = new PDO($db_location);
			
					$db->exec($insert);
			
					// close the database connection
					$db = NULL;
				}
				catch(PDOException $e)
				{
					print 'Exception : '.$e->getMessage() . '<br />';
					echo "Database location = $db_location, table = $table_name<br />";
					echo "SQL Select statement = $insert<br />";
				}
				
				//Drop old table
				$this->drop_table($db_location, $old_table_name);
			}
			
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage(). '<br />';
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $q<br />";
		}
	
	}
	
	//Check if a table exists in a database
	public function check_for_table ($db_location, $table_name)
	{
		//Checks if the database exists
		try
		{
			//open the database
			$db = new PDO($db_location);
	
			$q = "SELECT name FROM sqlite_master WHERE type='table' and name='" . $table_name . "';";
			//echo $q . "<br />";
			$result = $db->query($q);
	
			$tables = $result->fetch();	
			$totaltables = count($tables);
		
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage(). '<br />';
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $q<br />";
		}
	//echo $totaltables . "<br />";
		return $totaltables;
	}
	
	//Create Generic 
	function create_table($db_location, $table_name, $parameters)
	{
		$create = "CREATE TABLE " . $table_name . " (" . $parameters . ");";
		//echo "$create<br />";

		try
		{
			//open the database
			$db = new PDO($db_location);
	
			$db->exec($create);
	
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage(). '<br />';
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $create<br />";
		}		
	}
		
	//Drop Generic 
	function drop_table($db_location, $table_name)
	{
		$drop = "drop table " . $table_name . ";";
		//echo $drop . "<br />";
		try
		{
			//open the database
			$db = new PDO($db_location);
	
			$db->exec($drop);
	
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage(). '<br />';
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $drop<br />";
		}	
	}		
	
	//Update Generic
	function update_table ($db_location, $table_name, $parameters, $where_param)
	{
		$update = "UPDATE " . $table_name . " SET ". $parameters . " WHERE " . $where_param . ";";
		//echo $update . "<br />";
		
		try
		{
			//open the database
			$db = new PDO($db_location);
	
			$db->exec($update);
	
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage(). '<br />';
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $update<br />";
		}	
	}
	
	//Generic SQL Delete statement
	function delete_generic($db_location, $table_name, $parameters)
	{
		$delete = "DELETE FROM " . $table_name . " WHERE " . $parameters . ";";
		//echo $delete . "<br />";

		try
		{
			//open the database
			$db = new PDO($db_location);
	
			$db->exec($delete);
	
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $delete<br />";
			print 'Exception : '.$e->getMessage(). '<br />';
		}	
	}
	
	//Select Into Generic
	function select_into ($db_location, $table_name, $parameters, $new_table)
	{
		$selectinto = "CREATE TABLE " . $new_table . " AS SELECT " . $parameters ." FROM " . $table_name . ";";
		//echo $selectinto . "<br />";
		
		try
		{
			//open the database
			$db = new PDO($db_location);
	
			$db->exec($selectinto);
	
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $selectinto<br />";
			print 'Exception : '.$e->getMessage() . '<br />';
		}			
	}
	
	//Select Generic
	function select_statement ($db_location, $table_name, $paramters, $where_param)
	{
		$table = $this->check_for_table($db_location,$table_name);
		
		if ($table > 1)
		{
			if ($where_param == "")
				$select = "SELECT " . $paramters . " FROM " . $table_name . ";";
			else
				$select = "SELECT " . $paramters . " FROM " . $table_name . " WHERE " . $where_param . ";";
			//echo $select . "<br />";
	
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);

				if (!empty($result)) {
					foreach($result as $row)
					{
						$values = $row;
					}
				}

				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				//echo "hello <br />";
				echo "Database location = $db_location, table = $table_name<br />";
				echo "SQL Select statement = " . $select . "<br />";
				print 'Exception : '.$e->getMessage() . '<br />';
			}
		}
		return $values;
	}
	
	//Select Generic
	function select_statement_order_by ($db_location, $table_name, $paramters, $where_param=NULL,$order_by=NULL,$limit=NULL)
	{
		$table = $this->check_for_table($db_location,$table_name);
		
		if ($table > 1)
		{
			$select = "SELECT " . $paramters . " FROM " . $table_name;
			if (isset ($where_param) && $where_param != "")
				$select .= " WHERE " . $where_param;
			if (isset ($order_by) && $order_by != "")
				$select .= " ORDER BY " . $order_by;
			if (isset ($limit) && $limit != "")
				$select .= " LIMIT " . $limit;
				
			$select .=";";
			//echo $select . "<br />";
	
			try
			{
				//open the database
				$db = new PDO($db_location);
	
				$result = $db->query($select);
				if (!empty($result)) {	
					foreach($result as $row)
						$values = $row;
				}
				// close the database connection
				$db = NULL;
			}
			catch(PDOException $e)
			{
				//echo "hello <br />";
				echo "Database location = $db_location, table = $table_name<br />";
				echo "SQL Select statement = $select<br />";
				print 'Exception : '.$e->getMessage() . '<br />';
			}
		}
		return $values;
	}
	
	//Select Generic in array	
	function array_select_statement ($db_location, $table_name, $paramters, $where_param="", $order_by = "")
	{
		if ($where_param == "")
			if ($order_by == "")
				$select = "SELECT " . $paramters . " FROM " . $table_name . ";";
			else
				$select = "SELECT " . $paramters . " FROM " . $table_name . " ORDER BY " . $order_by . ";";
		else
			$select = "SELECT " . $paramters . " FROM " . $table_name . " WHERE " . $where_param . ";";
			
		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
			if (!empty ($result) ) {
			    foreach($result as $row)
					$values[] = $row;
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage() . '<br />';
			echo "Function name = Select Statement (Array)<br />";
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $select<br />";
		}
		
		return $values;
	}
	
	//Insert Statement Generic
	function insert_statement($db_location, $table_name, $parameters, $values)
	{	
		$insert = "INSERT INTO " . $table_name . " ( " . $parameters . " ) VALUES (" . $values . ");";
		//echo $insert . "<br />";

		try
		{
			//open the database
			$db = new PDO($db_location);
	
			$db->exec($insert);
	
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage() . '<br />';
			echo "Database location = $db_location, table = $table_name<br />";
			echo "SQL Select statement = $insert<br />";
		}			

	}
	
	//Checks if card_present table is exists
	function create_hardware_table($relay_name)
	{
		//Decide which table to place it in if a relay machine
		$db = database_selection($relay_name);
		$db_location = "sqlite:sqlite/" . $db;
		//echo $db_location;
		//$db_location = 'sqlite:sqlite/cardinfo.db';
		$table_name = "card_present";
		//$perm_table_name = "perm_card_present";
		
		//Create table parameters
		$parameters = "id int primary key, dev_name varchar(60), pci_slot int, pci_bus int, num_ports int, firmware int, echo varchar(20), analog_location int, num_te int, num_nt int";
	
		//Returns whether the table exists or not
		$totaltables = $this->check_for_table( $db_location, $table_name);
		//echo "Tables = $totaltables<br />";
		if ($totaltables > 1)
		{
			//Drops the old table and create a new one with new information
			$this->drop_table($db_location, $table_name);
			//$this->drop_table($db_location, $perm_table_name);			
			
			//Creates new table
			$this->create_table($db_location, $table_name, $parameters);
			//$this->create_table($db_location, $perm_table_name, $parameters);			
		}
		elseif ($totaltables < 2)
		{
			//Creates new table
			$this->create_table($db_location, $table_name, $parameters);		
			//1.0$this->create_table($db_location, $perm_table_name, $parameters);			
		}
		
		//Create the rest of the required tables
		//echo $relay_name;

		
	}	
	
	//Function that gets ss7 m2ua information from the database for that particular card
	function get_ss7_m2ua_link($card, $port, $span, $relay_name)
	{	
		$tok = strtok($card, "-");
	
		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		//echo $token[0];
	
		if ($token[0] == "A101" || $token[0] == "A102" || $token[0] == "A104" || $token[0] == "A108" || $token[0] == "A116" || $token[0] == "B601")
		{	
			$table_name = $token[0] . "_" . $span . "_m2ua_link";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
			//$db_location = "sqlite:sqlite/cardinfo.db";
			
			$totaltables = $this->check_for_table($db_location, $table_name);

	    	if ($totaltables < 2)
			{
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			}
			else
			{
				$paramters = "link_name, line_type, voice_chans";
				$where_param = "port_id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['link_name'];
				$returned_value[1] = $row['line_type'];
				$returned_value[2] = $row['voice_chans'];
			}
		}
		//echo "name = ".  $returned_value[0];
		
		return $returned_value;
	}
	
	//Function that gets ss7 m2ua information from the database for that particular card
	function get_ss7_mg_channels($card, $port, $span, $relay_name)
	{	
		$tok = strtok($card, "-");
	
		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		//echo $token[0];
	
		if ($token[0] == "A101" || $token[0] == "A102" || $token[0] == "A104" || $token[0] == "A108" || $token[0] == "A116" || $token[0] == "B601")
		{	
			$table_name = $token[0] . "_" . $span . "_m2ua_channels";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
			//$db_location = "sqlite:sqlite/cardinfo.db";
			
			$totaltables = $this->check_for_table($db_location, $table_name);

	    	if ($totaltables < 2)
			{
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			}
			else
			{
				$paramters = "profile_name,mg_profile";
				$where_param = "port_id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['profile_name'];
				$returned_value[1] = $row['mg_profile'];
			}
		}
		//echo "name = ".  $returned_value[0];
		
		return $returned_value;
	}	
	

	//Function that gets ss7 information from the database for that particular card
	function get_ss7_link($card, $port, $span, $relay_name)
	{	
		$tok = strtok($card, "-");
	
		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		//echo $token[0];
	
		if ($token[0] == "A101" || $token[0] == "A102" || $token[0] == "A104" || $token[0] == "A108" || $token[0] == "A116" || $token[0] == "B601")
		{	
			$table_name = $token[0] . "_" . $span . "_SS7_link";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
			//$db_location = "sqlite:sqlite/cardinfo.db";
			
			$totaltables = $this->check_for_table($db_location, $table_name);

	    	if ($totaltables < 2)
			{
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			}
			else
			{
				$paramters = "link_name, line_type";
				$where_param = "port_id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['link_name'];
				$returned_value[1] = $row['line_type'];
			}
		}
		//echo "name = ".  $returned_value[0];
		
		return $returned_value;
	}

	//Returns R2 information to the tdm config display
	function get_r2_info($card,$port,$span,$relay_name) {
		$tok = strtok($card, "-");
	
		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		//echo $token[0];
	
		if ($token[0] == "A101" || $token[0] == "A102" || $token[0] == "A104" || $token[0] == "A108" || $token[0] == "A116")
		{	
			$table_name = $token[0] . "_" . $span . "_r2_signalling";
			//$db_location = "sqlite:sqlite/cardinfo.db";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
	
			$totaltables = $this->check_for_table($db_location, $table_name);
			
	    	if ($totaltables < 2)
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			else
			{
				$paramters = "line_type, r2_profile, channels, group_num";
				$where_param = "port_id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['line_type'];
				$returned_value[1] = $row['r2_profile'];
				$returned_value[2] = $row['channels'];
				$returned_value[3] = $row['group_num'];
			}
		}	
		//Returns the values from the database
		return $returned_value;	
	}

	//Function that gets signalling information from the database for that particular card
	function get_signalling_info($card, $port, $span,$relay_name)
	{	
		$tok = strtok($card, "-");
	
		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}
	
		//echo $token[0];
	
		if ($token[0] == "A101" || $token[0] == "A102" || $token[0] == "A104" || $token[0] == "A108" || $token[0] == "A116")
		{	
			$table_name = $token[0] . "_" . $span . "_signalling";
			//$db_location = "sqlite:sqlite/cardinfo.db";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
	
			$totaltables = $this->check_for_table($db_location, $table_name);
			
	    	if ($totaltables < 2)
			{
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			}
			else
			{
				if ($_SESSION['dahdi'] == "True")
				{
					$paramters = "line_type, signalling, channels, group_num, context";
				}
				else
				{
					$paramters = "line_type, signalling, channels, group_num";
				}
				$where_param = "port_id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['line_type'];
				$returned_value[1] = $row['signalling'];
				$returned_value[2] = $row['channels'];
				$returned_value[3] = $row['group_num'];

				if ($_SESSION['dahdi'] == "True")
				{
					$returned_value[4] = $row['context'];
				}
			}
		}
		elseif ($token[0] == "A500" || $token[0] == "B700")
		{	

			$table_name = $token[0] . "_" . $span . "_signalling";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
			//$db_location = "sqlite:sqlite/cardinfo.db";
			
			$totaltables = $this->check_for_table($db_location, $table_name);
			
	    	if ($totaltables < 2)
			{
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			}
			else
			{
				if ($_SESSION['dahdi'] == "True")
				{
					if ($token[0] == "B700")
					{
						$paramters = "profile_name, conn_type, interface, channels, group_num, context, codec, operation_mode";
					}
					else
					{
						$paramters = "profile_name, conn_type, interface, channels, group_num, context";
					}
				}
				else
				{
					if ($token[0] == "B700")
					{
						$paramters = "profile_name, conn_type, interface, channels, group_num, codec, operation_mode";
					}
					else
					{
						$paramters = "profile_name, conn_type, interface, channels, group_num";
					}
				}
				$where_param = "id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['profile_name'];
				$returned_value[1] = $row['conn_type'];
				$returned_value[2] = $row['interface'];
				$returned_value[3] = $row['channels'];
				$returned_value[4] = $row['group_num'];

				if ($_SESSION['dahdi'] == "True")
				{
					$returned_value[5] = $row['context'];
				}
				if ($token[0] == "B700")
				{
					$returned_value[6] = $row['codec'];
					$returned_value[7] = $row['operation_mode'];
				}
			}
		}
		elseif ($token[0] == "A200" || $token[0] == "A400" || $token[0] == "B600")
		{
			$table_name = $token[0] . "_" . $span . "_signalling";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
			//$db_location = "sqlite:sqlite/cardinfo.db";
			
			//echo $table_name;
			
			$totaltables = $this->check_for_table($db_location, $table_name);
			
	    	if ($totaltables < 2)
			{
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			}
			else
			{
				if ($_SESSION['dahdi'] == "True")
				{
					$paramters = "profile_name, codec, operation_mode, group_num, context, port_id";
				}
				else
				{
					$paramters = "profile_name, codec, operation_mode, group_num, port_id";
				}
				$where_param = "port_id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['profile_name'];
				$returned_value[1] = $row['codec'];
				$returned_value[2] = $row['operation_code'];
				$returned_value[3] = $row['group_num'];
				$returned_value[4] = $row['port_id'];

				if ($_SESSION['dahdi'] == "True")
				{
					$returned_value[5] = $row['context'];
				}
			}			
		}
		elseif ($token[0] == "B601")
		{
			$table_name = $token[0] . "_" . $span . "_signalling";
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
			
			//$db_location = "sqlite:sqlite/cardinfo.db";
			
			//echo $table_name;
			
			$totaltables = $this->check_for_table($db_location, $table_name);
			
	    	if ($totaltables < 2)
			{
				//Database does not exist, returned_value gets null values
				$returned_value = "";
			}
			else
			{
				if ($_SESSION['dahdi'] == "True")
				{
					$paramters = "profile_name, line_type, signalling, group_num, context, port_id, channels";
				}
				else
				{
					$paramters = "profile_name, line_type, signalling, group_num, port_id, channels";
				}
				$where_param = "port_id = " . $port;
				
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);

				$returned_value[0] = $row['line_type'];
				$returned_value[1] = $row['profile_name'];
				$returned_value[2] = $row['signalling'];
				$returned_value[3] = $row['group_num'];
				$returned_value[4] = $row['port_id'];

				if ($_SESSION['dahdi'] == "True")
				{
					$returned_value[5] = $row['context'];
				}
				$returned_value[6] = $row['channels'];
			}			
		}		
	
		//Returns the values from the database
		return $returned_value;
	}

	//Function that gets the hardware information that is displayed in a database
	function get_hardware_info($card, $port, $span,$relay_name)
	{
		$tok = strtok($card, "-");
	
		$count = 0;
		while ($tok !== false) 
		{
			$token[$count] = $tok;
		    $tok = strtok("-");
			$count++;
		}

		$table_name = $token[0] . "_" . $span;
		
		$db = database_selection($relay_name);
		$db_location = "sqlite:sqlite/" . $db;	
		
		//$db_location = "sqlite:sqlite/cardinfo.db";
	
		if ($token[0] == "A101" || $token[0] == "A102" || $token[0] == "A104" || $token[0] == "A108" || $token[0] == "A116" || $token[0] == "B601")
		{	
			$totaltables = $this->check_for_table($db_location, $table_name);

	    	if ($totaltables < 2)
			{
				//echo "Doesn't exist <br />";
				//Database does not exist, returned_value gets null values
				$returned_value[0] = "";
				$returned_value[1] = "";
				$returned_value[2] = "";
				$returned_value[3] = "";
				$returned_value[4] = "";
				$returned_value[5] = "";
				$returned_value[6] = "";
				$returned_value[7] = "";
	            $returned_value[8] = "";		
			}
			else
			{
				$paramters = "line_type, coding, framing, clock, ref_clock, echo, dtmf, fax, sigmode, port_id";
				$where_param = "port_id = " . $port;
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);
				
				$returned_value[0] = $row['line_type'];
				$returned_value[1] = $row['coding'];
				$returned_value[2] = $row['framing'];
				$returned_value[3] = $row['clock'];
				$returned_value[4] = $row['ref_clock'];
				$returned_value[5] = $row['echo'];
				$returned_value[6] = $row['dtmf'];
				$returned_value[7] = $row['fax'];	
                $returned_value[8] = $row['sigmode'];
				
				if ($token[0] == "B601")
				{
					if ($row['line_type'] == "" && $row['echo'] != "" )
					{
						$returned_value[0] = "Analog";
					}
					if ( $row['echo'] == "yes")
					{
						$returned_value[5] = "enable";
					}
					elseif ( $row['echo'] == "no")
					{
						$returned_value[5] = "disable";
					}
					if ( $row['dtmf'] == "yes")
					{
						$returned_value[6] = "enable";
					}
					elseif ( $row['dtmf'] == "no")
					{
						$returned_value[6] = "disable";
					}
					
					if ( $row['fax'] == "yes")
					{
						$returned_value[7] = "enable";
					}
					elseif ( $row['fax'] == "no")
					{
						$returned_value[7] = "disable";
					}
					
					$returned_value[9] = $row['port_id'];
				}
			}
		}
		if ($token[0] == "A500" || $token[0] == "A200" || $token[0] == "A400" || $token[0] == "B600" || $token[0] == "B700")
		{	
			$totaltables = $this->check_for_table($db_location, $table_name);

	    	if ($totaltables < 2)
			{
				//echo "Doesn't exist <br />";
				//Database does not exist, returned_value gets null values
				$returned_value[0] = "";
				$returned_value[1] = "";
				$returned_value[2] = "";
				$returned_value[3] = "";
			}
			else
			{
				if ($token[0] == "A200" || $token[0] == "A400" || $token[0] == "B600" || $token[0] == "B700")
				{
					$paramters = "port_id, hw_ec, hw_dtmf, hw_fax";
				}
				else
				{
					$paramters = "hw_ec, hw_dtmf, hw_fax";
				}
				$where_param = "port_id = " . $port;
				$row = $this->select_statement ($db_location, $table_name, $paramters, $where_param);
				
				//echo $row['hw_ec'] . "<br />";
				
				if ( $row['hw_ec'] == "yes")
				{
					$returned_value[0] = "enable";
				}
				elseif ( $row['hw_ec'] == "no")
				{
					$returned_value[0] = "disable";
				}
				else
				{
					$returned_value[0] = $row['hw_ec'];
				}
				
				if ( $row['hw_dtmf'] == "yes")
				{
					$returned_value[1] = "enable";
				}
				elseif ( $row['hw_dtmf'] == "no")
				{
					$returned_value[1] = "disable";
				}
				else
				{
					$returned_value[1] = $row['hw_dtmf'];
				}
				
				if ( $row['hw_fax'] == "yes")
				{
					$returned_value[2] = "enable";
				}
				elseif ( $row['hw_fax'] == "no")
				{
					$returned_value[2] = "disable";
				}
				else
				{
					$returned_value[2] = $row['hw_fax'];
				}
				
				if ($token[0] == "A200" || $token[0] == "A400" || $token[0] == "B600" || $token[0] == "B700")
				{
					$returned_value[3] = $row['port_id'];
				}
			}
		}
		
	
		//Returns the values from the database
		return $returned_value;
	}

	//Inserts Card Information Into card_present table
	function insert_card_database($object, $a, $x, $relay_name)
	{	
	
		$db = database_selection($relay_name);
		$db_location = "sqlite:sqlite/" . $db;	
		
		$database = new PDO($db_location);	

		//$db_location = "sqlite:sqlite/cardinfo.db";
		$table_name = "card_present";

		$table_exist = $this->check_for_table ($db_location, $table_name);

		if ($table_exist > 1 )
		{
			$param = "*";
			$where_param = "id = $a";
			$return = $this->select_statement ($db_location, $table_name, $param, $where_param);		
			
			if ($return['id'] == "")
			{
				$q = "INSERT INTO card_present (id, dev_name, pci_slot, pci_bus, num_ports, firmware, echo, analog_location, num_te, num_nt) VALUES ($a, \"$object->device_name-$x\", \"$object->pci_slot\", \"$object->pci_bus\", \"$object->port_num\", \"$object->firmware\", \"$object->echo\", \"$object->analog_port\", \"$object->num_te\", \"$object->num_nt\");";
				//echo $q;
				$database->exec($q);
			}
			elseif ($return['id'] != "")
			{
				$q = "UPDATE card_present SET id = $a, dev_name = \"$object->device_name-$x\", pci_slot = \"$object->pci_slot\", pci_bus = \"$object->pci_bus\", num_ports = \"$object->port_num\", firmware = \"$object->firmware\", echo = \"$object->echo\", analog_location = \"$object->analog_port\", num_te = \"$object->num_te\", num_nt = \"$object->num_te\" WHERE id = $a;";
				//echo $q;
				$database->exec($q);				
			}
		}
	}
	
	//Function that retrieves the t1/e1 profiles from the database and stores it in a multi-dimensional array
	function get_profiles($param,$relay_name=NULL)
	{
		if ($relay_name == "" || !isset($relay_name)) 
			$db_location = 'sqlite:../sqlite/cardinfo.db';
		else {
			$db = database_selection($relay_name);
			$db_location = "sqlite:sqlite/" . $db;	
		}
		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$where_param = "line_type = \"" . $_SESSION['line_type'] . "\"";
		$table_name = "t1e1_profile";
		$a = 0;

		$select = "SELECT " . $param . " FROM " . $table_name . " WHERE " . $where_param . ";";

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$array[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
		}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$_SESSION['counter'] = $a;
		return $array;
	}
	
	function get_BRI_profiles()
	{
		
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$a = 0;

		$select = "SELECT * FROM bri_profile"; 

		try
		{
			//open the database
			$db = new PDO($db_location);

			$result = $db->query($select);
		
		    foreach($result as $row)
		    {
				$array[$a] = $row;
				$a++;
			}
			// close the database connection
			$db = NULL;
			}
		catch(PDOException $e)
		{
			print 'Exception : '.$e->getMessage();
		}

		$_SESSION['counter'] = $a;
		return $array;
	}
	
	/**
	* Populates the finished ports table in the sqlite database. Used to display notifications in TDM Configuration
	*
	* @param $relay_type string
	*			Tells function whether the system is in standalone mode or relay mode
	* @param $relay_name string
	* 			If in relay mode, determines whether the system is a master system or slave system
	*
	*/
	public function populate_finihsed_ports_table ($relay_type = "standalone", $relay_name = "Master1") {

		if ($relay_result['machine_type'] == "standalone")
			$db = 'sqlite:sqlite/cardinfo.db';
		else {
			$proc_id = trim(substr($relay_name,5));
			if ($proc_id == 'r1')
				$db = 'sqlite:sqlite/cardinfo.db';
			else
				$db = 'sqlite:sqlite/cardinfo'.$proc_id.'.db';
		}
			
		$table_name = "finished_ports";
		$table = $this->check_for_table ($db, $table_name);
		if ($table > 1)
			$this->drop_table($db, $table_name);
	
		//Creates finished ports table
		$table_name = "finished_ports";
		$parameters = "id int primary key, card varchar(30), completed varchar(10), type varchar(50), mg_profile varchar(30), span int";
		$this->create_table($db, $table_name, $parameters);
	
		$counter = 1;
		//populate finished_ports before page renders
		$boards = $this->array_select_statement($db,'card_present','id,dev_name,num_ports','');
		if (!empty($boards)) {
			$span = 1;
			foreach ($boards as $board) {
				$tmpBoard = explode('-',$board['dev_name']);
				$name = $tmpBoard[1];
				$number = $board['id'];
		
				//Check to see if all applicable tables are populated
				$physical_table = $name . '_' . $number;
				$r2_table = $name . '_' . $number.'_r2_signalling';
				$pri_table = $name . '_' . $number.'_signalling';
				$m2ua_link_table = $name . '_' . $number.'_m2ua_link';
				$mg_table = $name.'_'.$number.'_m2ua_channels';
				$ss7_link_table = $name.'_'.$number.'_SS7_link';
				$ss7_ccspans_table = $name.'_'.$number.'_SS7_ccspans';
	
				/*echo $r2_table . "<br />";
				echo $pri_table . "<br />";
				echo "Board = $name, num ports = ". $board['num_ports'] . "<br />";*/
				
				for ($a = 1; $a <= $board['num_ports']; $a++) {
					$insert=false;
					$port_type = "";
					$phys = array();
					$ss7_link = array();
					$ss7_ccspans = array();
					$m2ua_link = array();
					$mg_link = array();
					$r2_link = array();
					$pri_link = array();
	
					$phys = $this->select_statement($db,$physical_table,'*','port_id='.$a);
					$ss7_link = $this->select_statement($db,$ss7_link_table,'*','port_id='.$a);
					$ss7_ccspans = $this->select_statement($db,$ss7_ccspans_table,'*','port_id='.$a);
					$m2ua_link = $this->select_statement($db,$m2ua_link_table,'*','port_id='.$a);
					$mg_link = $this->select_statement($db,$mg_table,'*','port_id='.$a);
					$r2_link = $this->select_statement($db,$r2_table,'*','port_id='.$a);
					$pri_link = $this->select_statement($db,$pri_table,'*','port_id='.$a);
	
					/*echo "physical<br />";
					print_r ($phys);
					echo "<br /> m2ua<br />";
					print_r ($m2ua_link);
					echo "<br />mg<br />";
					print_r ($mg_link);
					echo "<br />SS7 Link<br />";
					print_r ($ss7_link);	
					echo "<br />CCSPANS<br />";
					print_r ($ss7_ccspans);
					echo "<br />R2<br />";
					print_r ($r2_link);
					echo "<br />PRI<br />";
					print_r ($pri_link);														
					echo "<br />";*/
	
	
					//check if ss7 complete
					if ($ss7_link['link_name'] != "" && $ss7_ccspans['profile_name'] != "" && $phys['dev_name'] != "") {	
						$insert =true;
						if ($ss7_link['voice'] == "yes") 
							$port_type = "SS7 Voice Link";
						else
							$port_type = "SS7 Signalling Link";
					}
					elseif ($phys['dev_name'] != "" && $m2ua_link['link_name'] != "" && $mg_link['profile_name'] != "") {
						$insert = true;
						$port_type = "M2UA Signalling Gateway";
					}
					elseif ($phys['dev_name'] != "" && $mg_link['profile_name'] != "") {
						$insert = true;
						$port_type = "Media Gateway";
					}
					elseif ($phys['dev_name'] != "" && $r2_link['r2_profile'] != "") {
						$insert=true;
						$port_type="MFC/R2";
					}
					elseif ($phys['dev_name'] != "" && $pri_link['dev_name'] != "") {
						$insert=true;
						$port_type="PRI";
					}
					
					if ($insert) {
						//echo "Port type = $port_type<br />";
						//echo "SPAN = $span<br />";
						$insert_param = 'id,card,completed,type,mg_profile,span';
						$insert_values = $counter.',"'.$name.'_'.$number.'_'.$a.'","yes","'.$port_type.'","'.$mg_link['mg_profile'].'","'.$span.'"';
						$this->insert_statement($db,'finished_ports',$insert_param,$insert_values);
						$counter++;
					}
					$span++;
				}
			}
		}
		
	}
	
}


// Compare 2 tables.
// Return true if content is identical
// !! left and right table MUST have the same structure
// if not the case, use the left and right column list
// to make them match (count, order and name)
function compareTable( 
  $in_dbLocation,         // Database location
  $in_leftTable,          // Left table name to compare 
  $in_rightTable,         // Right table name to compare
  $in_leftColumn = "*",   // List of column to compare in left table
  $in_rightColumn = "*", $media)  // List of column to compare in right table
{
  // Out of sync counter 
  $uiOutOfSyncCount = 0;
  $db = new PDO($in_dbLocation);
  // Check for column list
  // Now compare the 2 tables
  //echo "left table = $in_leftTable and right table = $in_rightTable<br />";
  
 $select = "SELECT COUNT(*) AS out_of_sync FROM (" .
              "SELECT " . $in_leftColumn .  " FROM " . $in_leftTable . " " .
              "EXCEPT " .
              "SELECT " . $in_rightColumn . " FROM " . $in_rightTable . " " .
            ")";
  //echo $select . "<br />";
  if ( $selectResult = $db->query( $select ) )
  {
	//echo "here <br />";
    $selectConfigMismatchCount = $selectResult->fetch();
    // Check if some row mismatch !
	//echo "out of sync = " . $selectConfigMismatchCount['out_of_sync'] . "<br />";
    $uiOutOfSyncCount += $selectConfigMismatchCount['out_of_sync'];
	//echo "ui out of sync count = " . $uiOutOfSyncCount . "<br />";
  }
  else
  {
    // Something went wrong in the query, assume out of sync
    $uiOutOfSyncCount++;
  }
  
  $select = "SELECT COUNT(*) AS out_of_sync FROM (" .
              "SELECT " . $in_rightColumn .  " FROM " . $in_rightTable . " " .
              "EXCEPT " .
              "SELECT " . $in_leftColumn . " FROM " . $in_leftTable . " " .
            ")";
			//echo $select . "<br />";
  if ( $selectResult = $db->query( $select ) )
  {
	//echo "here <br />";
    $selectConfigMismatchCount = $selectResult->fetch();
    // Check if some row mismatch !
	//echo "out of sync = " . $selectConfigMismatchCount['out_of_sync'] . "<br />";
    $uiOutOfSyncCount += $selectConfigMismatchCount['out_of_sync'];
	//echo "ui out of sync count = " . $uiOutOfSyncCount . "<br />";
  }
  else
  {
    // Something went wrong in the query, assume out of sync
    $uiOutOfSyncCount++;
  }  
  
  //Run the reverse method for media processing to assure information is in sync
  if ($media == "yes")
  {
	  $select = "SELECT COUNT(*) AS out_of_sync FROM (" .
				  "SELECT " . $in_rightColumn . " FROM " . $in_rightTable . " " .
				  "EXCEPT " .
				  "SELECT " . $in_leftColumn .  " FROM " . $in_leftTable . " " .
				")";
				//echo $select . "<br />";
	  if ( $selectResult = $db->query( $select ) )
	  {
		$selectConfigMismatchCount = $selectResult->fetch();
		// Check if some row mismatch !
		$uiOutOfSyncCount += $selectConfigMismatchCount['out_of_sync'];
	  }
	  else
	  {
		// Something went wrong in the query, assume out of sync
		$uiOutOfSyncCount++;
	  }  
  }
  // Close database
  $db = NULL;
  
  //print( "Table " . $in_leftTable . " and " . $in_rightTable . " are " .(($uiOutOfSyncCount>0)?"<b>NOT</b> ":"")."identical\n<br />" ); 
  //echo "<br/>\n";
  
  return (0 == $uiOutOfSyncCount);
}

function isMediaConfigInSync( $in_dbLocation )
{
  // Out of sync counter 
  $uiOutOfSyncCount = 0;
  $db = new PDO($in_dbLocation);
  // No, so check configurations
  // Get all the table name that begin by perm
  $select = "SELECT name FROM sqlite_master ".
            "WHERE type='table' AND name LIKE 'transcode%'";
			//echo $select . "<br />";
  foreach ($db->query( $select ) as $scratchTable )
  {
    // Create the scratch table name based on the perm table name
    $scratchTableName = $scratchTable['name'];
    $permTableName = "perm_" . $scratchTableName; 
    // Now compare the 2 tables
    if ( !compareTable( $in_dbLocation,$permTableName, $scratchTableName, "*","*","yes" ) )
      $uiOutOfSyncCount++;
  }
  // Close database
  $db = NULL;
  return (0 == $uiOutOfSyncCount);
}

function isTdmConfigInSync($in_dbLocation )
{
  // Out of sync counter 
  $uiOutOfSyncCount = 0;

  // Check TDM configuration
  // Check what is finished but not generated
  if ( !compareTable( $in_dbLocation, "finished_ports", "generated_ports", "card", "card","yes" ) )
    $uiOutOfSyncCount++;

  // Card mistmatch ?
  if ( 0 == $uiOutOfSyncCount )
  {
    $db = new PDO($in_dbLocation);
    // No, so check configurations
    // Get all the table name that begin by perm (excluding transcode table)
    $select = "SELECT name FROM sqlite_master ".
      "WHERE type='table' AND name LIKE 'perm%' AND name NOT LIKE 'perm_transcode%' AND name NOT LIKE 'used_%' AND name NOT LIKE 'card_present%' AND name NOT LIKE 'bri_profile%' AND name NOT LIKE 't1e1_profile%' AND name NOT LIKE 'analog_profile%' AND name NOT LIKE 'configured_channels%' AND name NOT LIKE 'perm_configured_channels%' AND name NOT LIKE 'finished_ports' AND name NOT LIKE 'generated_ports'";
	//echo $select . "<br />";
    foreach ($db->query( $select ) as $permTable )
    {
      // Create the scratch table name based on the perm table name
      $permTableName = $permTable['name'];
      $scratchTableName = substr( $permTableName, strpos( $permTableName, "_" ) + 1 );
      // Now compare the 2 tables
      if ($permTableName == "perm_mg_profiles" && $scratchTableName == "mg_profiles")
		$param = 'id,name,ip_addr,port,protocol,domain,mid,term_prefix,megaco_version,rtp_ip,t38';
      else
		$param = "*";
      if ( !compareTable( $in_dbLocation,$permTableName, $scratchTableName,$param,$param,"yes" ) )
        $uiOutOfSyncCount++;
    }
    // Close database
    $db = NULL;
  }
  return (0 == $uiOutOfSyncCount);
}

function isMGConfigInSync($in_dbLocation)
{
  // Out of sync counter 
  $uiOutOfSyncCount = 0;
  $db = new PDO($in_dbLocation);
  // No, so check configurations
  // Get all the table name that begin by perm
  $select = "SELECT name FROM sqlite_master ".
            "WHERE type='table' AND name LIKE 'mg_profiles'";

  foreach ($db->query( $select ) as $scratchTable )
  {
    // Create the scratch table name based on the perm table name
    $scratchTableName = $scratchTable['name'];
    $permTableName = "perm_" . $scratchTableName; 
    // Now compare the 2 tables
    if ( !compareTable( $in_dbLocation,$permTableName, $scratchTableName, "*","*","yes" ) )
      $uiOutOfSyncCount++;
  }
  
  $select = "SELECT name FROM sqlite_master ".
            "WHERE type='table' AND name LIKE '%_peers' AND name NOT LIKE 'perm_%_peers'";

  foreach ($db->query( $select ) as $scratchTable )
  {
    // Create the scratch table name based on the perm table name
    $scratchTableName = $scratchTable['name'];
    $permTableName = "perm_" . $scratchTableName; 
    // Now compare the 2 tables
    if ( !compareTable( $in_dbLocation,$scratchTableName, $permTableName, "*","*","yes" ) )
      $uiOutOfSyncCount++;
  }
    
  // Close database
  $db = NULL;
  return (0 == $uiOutOfSyncCount);	
}

function isH323ConfigInSync ($db,$data) {
	 $info = $data->select_statement($db,'h323_db','*','id=1');

	 if ($info['status'] == "outofsync")
	 	return false;
	else
		return true;
}

function isSIPConfigInSync ($db,$data) {
	 $info = $data->select_statement($db,'sip_db','*','id=1');

	 if ($info['status'] == "outofsync")
	 	return false;
	else
		return true;
}

function database_selection($relay_name)
{
	//echo $relay_name . "<br />";
	if ($relay_name == "")
	{
		//Standalone machine
		$db = "cardinfo.db";
	}
	elseif ($relay_name != "")
	{
		//include the ssh class to determine what command to run
		require_once 'SSH_Class.php';
		require_once 'database_classes.php';
	
		$data = new database_class;
		$ssh_class = new ssh_class;
	
		//Pull relay information from database
		$relay_info = $data->select_statement('sqlite:sqlite/relay_info.db','relay_hosts','id',"relay_name = \"$relay_name\"");			
		
		if (preg_match("'\bMaster1\b'",$relay_name))
			$db = "cardinfo.db";
		else
			$db = "cardinfo" . $relay_info['id'] . ".db";
		
		unset($ssh_class);
		unset($data);	
		
	}	
	return $db;
}
