<?php
/*
	SMG WebGUI
	Version: 1.0

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/


class Dahdi_configuration
{
	
	//Class Private Variables
	private $rx_gain = "";				//chan_dahdi rx gain
	private $tx_gain = "";				//chan_dahdi tx gain
	private $switchtype = "";			//chan_dahdi switchtype
	private $signalling = "";			//chan_dahdi signalling type
	private $context = "";				//chan_dahdi context
	private $group = "";				//chan_dahdi group number
	private $framing = "";				//system.conf framing
	private $coding = "";				//system.conf coding
	private $span = "";					//system.conf span number
	private $sig_mode = "";				//system.conf signalling mode (CCS/CAS) E1 only
	private $start_chan = "";			//B Channel Start Channel
	private $end_chan = "";				//B Channel End Channel
	private $chan_map = "";				//B Channel Channel Map
	private $dchan = "";				//D Channel
	private $line_type = "";			//Line type to determine the channel calculation
	private $card_name = "";			//Gets the card name
	private $card_number = "";			//The Card number from the card_present table
	private $port_num = "";				//Port Number being writen
	private $slot = "";					//PCI Slot number
	private $bus = ""; 					//PCI Bus number
	private $analog_chan = array();		//Analog Channel Number array
	private $wanpipe = "";				//Wanpipe number
	public $b700_module = "";			//B700 Analog Module
	

	//Function that populates the dahdi variables
	function populate($card, $card_number, $span_num, $port_num, $data, $analog_channel_mapping, $wanpipe)
	{
		$this->port_num = $port_num;		
		$this->span = $span_num;
		$this->card_name = $card;
		$this->card_number = $card_number;
		$this->wanpipe = $wanpipe;
		
		//Database information
		$card_format = "AFT-" . $this->card_name . "-SH-" . $card_number;
		$db_location = "sqlite:sqlite/cardinfo.db";

		//Retrieve Card Information		
		$table_name = "card_present";
		$param = "pci_slot, pci_bus";
		$where_param = "id = \"" . $card_number . "\"";
		$card_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->slot = $card_info['pci_slot'];
		$this->bus = $card_info['pci_bus'];

		if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "B601" && $this->port_num == 1)
		{
			//Gets hardware information needed for dahdi config
			$table_name = $card . "_" . $card_number;
			$param = "rxgain, txgain, coding, framing, sigmode, line_type";
			$where_param = "port_id = $port_num";
			$hw_info = $data->select_statement ($db_location, $table_name, $param, $where_param);
	
			$this->rx_gain = $hw_info['rxgain'];
			$this->tx_gain = $hw_info['txgain'];
			$this->coding = $hw_info['coding'];
			$this->framing = $hw_info['framing'];
			$this->sig_mode = $hw_info['sigmode'];
			$this->line_type = $hw_info['line_type'];
			
			//Get the context from the signalling database
			$table_name = $card . "_" . $card_number . "_signalling";
			$param = "channels, context, group_num, signalling";
			$where_param = "port_id = $port_num";
			$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
			
			$this->context = $sig_info['context'];
			$this->group = $sig_info['group_num'];
			
			$table_name = "t1e1_profile";
			$param = "signalling, switchtype";
			$where_param = "profile_name = \"" . $sig_info['signalling'] . "\"";
			$profile_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
			
			//echo $profile_info['switchtype'] . "<br />";
			
			//Analyze the way signalling comes in and adjust accordingly for chan_dahdi.conf
			if ($profile_info['signalling'] == "PRI CPE")
			{
				$this->signalling = "pri_cpe";	
			}
			elseif ($profile_info['signalling'] == "PRI NET")
			{
				$this->signalling = "pri_net";
			}
			elseif ($profile_info['signalling'] == "E&MWink")
			{
				$this->signalling = "em";
			}
				
			if ($profile_info['switchtype'] == "NI2")
			{
				$this->switchtype = "national";
			}
			elseif ($profile_info['switchtype'] == "4ESS")
			{
				$this->switchtype = "4ess";
			}
			elseif ($profile_info['switchtype'] == "5ESS")
			{
				$this->switchtype = "5ess";
			}
			/*elseif ($profile_info['switchtype'] == "NTT")
			{
				$this->switchtype = 
			}*/
			elseif ($profile_info['switchtype'] == "QSIG")
			{
				$this->switchtype = "qsig";
			}
			elseif ($profile_info['switchtype'] == "EuroISDN")
			{
				$this->switchtype = "euroisdn";
			}
			elseif ($profile_info['switchtype'] == "E&MWink")
			{
				$this->switchtype = "em";
			}
					
			//Algorithm to calculate the b-channels & d-channels
			if ($this->span == 1)
			{
				$this->start_chan = 1;
				if ($this->line_type == "T1")
				{
					$this->end_chan = 23;
					$this->dchan = 24;
					$this->chan_map = $this->start_chan . "-" . $this->end_chan;
					
					//Store in session
					$_SESSION['bchan'] = $this->end_chan;
					$_SESSION['dchan'] = $this->dchan;
					$_SESSION['last_line'] = $this->line_type;
				}
				elseif ($this->line_type == "E1")
				{
					$this->end_chan = 31;
					$this->dchan = 16;
					$start_chan_calc = $this->start_chan + 14;
					$end_chan_calc = $this->end_chan - 14;
					$this->chan_map = $this->start_chan . "-" . $start_chan_calc . "," . $end_chan_calc . "-" . $this->end_chan;
					
					//Stores in session
					$_SESSION['bchan'] = $this->end_chan;
					$_SESSION['dchan'] = $this->dchan;				
					$_SESSION['last_line'] = $this->line_type;				
				}
			}
			elseif ($this->span > 1)
			{	
				if ($_SESSION['last_card'] == "A101" || $_SESSION['last_card'] == "A102" || $_SESSION['last_card'] == "A104" || $_SESSION['last_card'] == "A108" ||$_SESSION['last_card'] == "B601" && $_SESSION['last_port_number'] == 1)			
				{
					if ($this->line_type == "T1")			
					{
						if ($_SESSION['last_line'] == "T1")
						{
							$this->start_chan = $_SESSION['dchan'] + 1;
						}
						elseif ($_SESSION['last_line'] == "E1")
						{
							$this->start_chan = $_SESSION['bchan'] + 1;
						}
						$this->end_chan = $this->start_chan + 22;
						
						$this->dchan = $this->start_chan + 23;
						$this->chan_map = $this->start_chan . "-" . $this->end_chan;
						
						//Store in session
						$_SESSION['bchan'] = $this->end_chan;
						$_SESSION['dchan'] = $this->dchan;				
						$_SESSION['last_line'] = $this->line_type;				
					}
					if ($this->line_type == "E1")
					{
						if ($_SESSION['last_line'] == "T1")
						{
							$this->start_chan = $_SESSION['dchan'] + 1;
						}
						elseif ($_SESSION['last_line'] == "E1")
						{
							$this->start_chan = $_SESSION['bchan'] + 1;
						}
						
						$this->dchan = $this->start_chan + 15;
						$this->end_chan = $this->start_chan + 30;
						$start_chan_calc = $this->start_chan + 14;
						$end_chan_calc = $this->end_chan - 14;
						$this->chan_map = $this->start_chan . "-" . $start_chan_calc . "," . $end_chan_calc . "-" . $this->end_chan;
						
						//Store in session
						$_SESSION['bchan'] = $this->end_chan;
						$_SESSION['dchan'] = $this->dchan;				
						$_SESSION['last_line'] = $this->line_type;				
					}
				}
				else
				{
					if ($this->line_type == "T1")
					{
						$this->start_chan = $_SESSION['last_channel'] + 2;
						$this->end_chan = $this->start_chan + 22;
						$this->dchan = $this->start_chan + 23;
						$this->chan_map = $this->start_chan . "-" . $this->end_chan;
						
						//Store in session
						$_SESSION['bchan'] = $this->end_chan;
						$_SESSION['dchan'] = $this->dchan;				
						$_SESSION['last_line'] = $this->line_type;							
						
					}
					if ($this->line_type == "E1")
					{
						$this->start_chan = $_SESSION['last_channel'] + 2;
						$this->dchan = $this->start_chan + 15;
						$this->end_chan = $this->start_chan + 30;
						$start_chan_calc = $this->start_chan + 14;
						$end_chan_calc = $this->end_chan - 14;
						$this->chan_map = $this->start_chan . "-" . $start_chan_calc . "," . $end_chan_calc . "-" . $this->end_chan;
						
						//Store in session
						$_SESSION['bchan'] = $this->end_chan;
						$_SESSION['dchan'] = $this->dchan;				
						$_SESSION['last_line'] = $this->line_type;
					}
				}
			}
			$_SESSION['last_card'] = $this->card_name;
			$_SESSION['last_port_number'] = $this->port_num;
		}
		elseif ($this->card_name == "A200" || $this->card_name == "A400" || $this->card_name == "B600" || $this->card_name == "B601" && $this->port_num == 2)
		{	
			//Get the context and group number from the signalling table
			//Get the context from the signalling database
			$table_name = $card . "_" . $card_number . "_signalling";
			$param = "context, group_num";
			$where_param = "port_id = $port_num";
			$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
			
			$this->context = $sig_info['context'];
			$this->group = $sig_info['group_num'];			
		
			//Get the wanpipe number = span number ($this->span)
			$counter = 1;
			
			//echo "last channel = " . $_SESSION['last_channel'] . " Card = " . $card . "<br />";
			
			//Channel Calculations
			if ($_SESSION['last_card'] == "A101" || $_SESSION['last_card'] == "A102" || $_SESSION['last_card'] == "A104" || $_SESSION['last_card'] == "A108" ||$_SESSION['last_card'] == "B601" && $_SESSION['last_port_number'] == 1)
			{
				if ($_SESSION['last_line'] == "T1")
				{
					//last channel is the d-channel $_SESSION[dchan]
					if ($this->card_name == "B600" || $this->card_name == "B601" && $this->port_num == 2)
					{
						$last_chan = $_SESSION['dchan'] + 5;
						$chan = $_SESSION['dchan'] + 1;
						$_SESSION['first_chan'] = $chan;
					}
					else
					{
						$last_chan = $_SESSION['dchan'] + 24;
						$chan = $_SESSION['dchan'] + 1;
						$_SESSION['first_chan'] = $chan;
					}
									
					for ($a = $chan; $a <= $last_chan; $a++)
					{
						$this->analog_chan[$a] = $analog_channel_mapping[$counter];
						$counter++;
						//echo "$a = " . $this->analog_chan[$a] . "<br />";
					}
				}
				elseif ($_SESSION['last_line'] == "E1")
				{
					//Last channel is the last b-channel $_SESSION['bchan']
					if ($this->card_name == "B600" || $this->card_name == "B601" && $this->port_num == 2)
					{
						$last_chan = $_SESSION['bchan'] + 5;
						$chan = $_SESSION['bchan'] + 1;
						$_SESSION['first_chan'] = $chan;
					}
					else
					{				
						$last_chan = $_SESSION['bchan'] + 24;
						$chan = $_SESSION['bchan'] + 1;
						$_SESSION['first_chan'] = $chan;
					}
					
					for ($a = $chan; $a <= $last_chan; $a++)
					{
						$this->analog_chan[$a] = $analog_channel_mapping[$counter];
						$counter++;				
						//echo "$a = " . $this->analog_chan[$a] . "<br />";
					}
				}
			}
			else
			{
				//No T1/E1 Cards Found
				if ($this->card_name == "B600" || $this->card_name == "B601" && $this->port_num == 2)
				{
					$last_chan = $_SESSION['last_channel'] + 5;
					$_SESSION['first_chan'] = $_SESSION['last_channel'] + 1;
				}
				else
				{	
					$last_chan = $_SESSION['last_channel'] + 24;
					$_SESSION['first_chan'] = $_SESSION['last_channel'] + 1;
				}
				
				for ($a = $_SESSION['first_chan']; $a <= $last_chan; $a++)
				{
					$this->analog_chan[$a] = $analog_channel_mapping[$counter];
					$counter++;				
					//echo "$a = " . $this->analog_chan[$a] . "<br />";
				}
			}
			$_SESSION['last_card'] = $this->card_name;
			$_SESSION['last_port_number'] = $this->port_num;			
			if ($this->card_name == "B600")
			{
				$_SESSION['last_channel'] = $a+17;
			}
			elseif ($this->card_name == "B601" && $this->port_num == 2)
			{
				$_SESSION['last_channel'] = $a+18;
			}
			else
			{
				$_SESSION['last_channel'] = $a-1;		
			}
		}
		elseif ($this->card_name == "B700")
		{
			//Get the context and group number from the signalling table
			//Get the context from the signalling database
			$table_name = $card . "_" . $card_number . "_signalling";
			$param = "context, group_num";
			$where_param = "id = $port_num";
			$sig_info = $data->select_statement ($db_location, $table_name, $param, $where_param);	
			
			$this->context = $sig_info['context'];
			$this->group = $sig_info['group_num'];			
		
			//Get the wanpipe number = span number ($this->span)
			$counter = 1;
			
			//Channel Calculations
			if ($_SESSION['last_card'] == "A101" || $_SESSION['last_card'] == "A102" || $_SESSION['last_card'] == "A104" || $_SESSION['last_card'] == "A108" ||$_SESSION['last_card'] == "B601" && $_SESSION['last_port_number'] == 1)
			{			
				if ($_SESSION['last_line'] == "T1")
				{
					//last channel is the d-channel $_SESSION[dchan]
					$last_chan = $_SESSION['dchan'] + 2;
					$chan = $_SESSION['dchan'] + 1;
					$_SESSION['first_chan'] = $chan;
									
					for ($a = $chan; $a <= $last_chan; $a++)
					{
						$this->analog_chan[$a] = $this->b700_module;
						//$counter++;
						//echo "$a = " . $this->analog_chan[$a] . "<br />";
					}
				}
				elseif ($_SESSION['last_line'] == "E1")
				{
					//Last channel is the last b-channel $_SESSION['bchan']
					$last_chan = $_SESSION['bchan'] + 2;
					$chan = $_SESSION['dchan'] + 1;
					$_SESSION['first_chan'] = $chan;
					
					for ($a = chan; $a <= $last_chan; $a++)
					{
						$this->analog_chan[$a] = $this->b700_module;
						//$counter++;	
						//echo "$a = " . $this->analog_chan[$a] . "<br />";			
					}
				}
			}
			else
			{
				//No T1/E1 Cards Found
				$last_chan = $_SESSION['last_channel'] + 2;
				$_SESSION['first_chan'] = $_SESSION['last_channel'] + 1;
				
				for ($a = $_SESSION['first_chan']; $a <= $last_chan; $a++)
				{
					$this->analog_chan[$a] = $this->b700_module;
					//$counter++;		
					//echo "$a = " . $this->analog_chan[$a] . "<br />";		
				}
			}
			$_SESSION['last_card'] = $this->card_name;
			$_SESSION['last_port_number'] = $this->port_num;			
			$_SESSION['last_channel'] = $a-1;			
		}
	}
	
	function system_conf ($static)
	{
		if ($static == "")
		{
			$file_name = "system.conf";

			$filehandle = fopen($file_name, 'w') or die("can't open file");
			
			//Generate Static portion of system.conf
			$static_portion = "#autogenerated by SMG WebGUI do not hand edit
#autogenrated on " . date('l jS \of F Y h:i:s A') . "
#Dahdi Channels Configurations
#For detailed Dahdi options, view /etc/dahdi/system.conf.bak
loadzone=us
defaultzone=us";
			fwrite($filehandle, $static_portion);
			fclose($filehandle);			
		}
		if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "B601" && $this->port_num == 1)
		{
			if ($static != "")
			{
				//write the config file
				$file_name = "system.conf";		
				$filehandle = fopen($file_name, 'a') or die("can't open file");
			
				if ($this->line_type == "T1")
				{
					//System.conf card portion generation
					$card_portion = "
#Sangoma " . $this->card_name . " Port " . $this->port_num . " [slot: " . $this->slot . " bus: " . $this->bus . " span: " . $this->span . "] <wanpipe" . $this->wanpipe . ">
span=" . $this->span . "," . $this->span . ",0," . $this->framing . "," . $this->coding . "
bchan=" . $this->chan_map . "
echocanceller=mg2," . $this->chan_map . "
hardhdlc=" . $this->dchan;
				}
				elseif ($this->line_type == "E1")
				{
					//System.conf card portion generation
					$card_portion = "
#Sangoma " . $this->card_name . " Port " . $this->port_num . " [slot: " . $this->slot . " bus: " . $this->bus . " span: " . $this->span . "] <wanpipe" . $this->wanpipe . ">
span=" . $this->span . "," . $this->span . ",0," . $this->sig_mode . ",". $this->coding . "," . $this->framing . "
bchan=" . $this->chan_map . "
echocanceller=mg2," . $this->chan_map . "
hardhdlc=" . $this->dchan;
			//echo $card_portion;
				}
				fwrite($filehandle, $card_portion);
				fclose($filehandle);			
				
			}
		}
		elseif ($this->card_name == "A200" || $this->card_name == "A400" || $this->card_name == "B601" && $this->port_num == 2 || $this->card_name == "B600")
		{
			if ($static != "")
			{
				//write the config file
				$file_name = "system.conf";		
				$filehandle = fopen($file_name, 'a') or die("can't open file");
			
				//System.conf card portion generation
				$card_portion = "
#Sangoma " . $this->card_name . " [slot: " . $this->slot . " bus: " . $this->bus . " span: " . $this->span . "] <wanpipe" . $this->wanpipe . ">";
			
				for ($a = $_SESSION['first_chan']; $a <= $_SESSION['last_channel']; $a++)
				{
					if ($this->analog_chan[$a] == "FXO")
					{
						$card_portion .= "
fxsks=" . $a . "
echocanceller=mg2," . $a . "";
					}
					if ($this->analog_chan[$a] == "FXS")
					{
						$card_portion .= "
fxoks=" . $a . "
echocanceller=mg2," . $a . "";
					}					
				}
				//$_SESSION['last_channel'] = $a;	
				
				fwrite($filehandle, $card_portion);
				fclose($filehandle);			
			}
		}
		elseif ($this->card_name == "B700")
		{
			if ($static != "")
			{
				//write the config file
				$file_name = "system.conf";		
				$filehandle = fopen($file_name, 'a') or die("can't open file");
			
				//System.conf card portion generation
				$card_portion = "
#Sangoma " . $this->card_name . " [slot: " . $this->slot . " bus: " . $this->bus . " span: " . $this->span . "] <wanpipe" . $this->wanpipe . ">";
			
				//$last_channel = $_SESSION['last_channel'] + 1;
				
				for ($a = $_SESSION['first_chan']; $a <= $_SESSION['last_channel']; $a++)
				{
					if ($this->analog_chan[$a] == "FXO")
					{
						$card_portion .= "
fxsks=" . $a . "
echocanceller=mg2," . $a . "";
					}
					if ($this->analog_chan[$a] == "FXS")
					{
						$card_portion .= "
fxoks=" . $a . "
echocanceller=mg2," . $a . "";
					}					
				}
				
				//$_SESSION['last_channel'] = $last_channel;
				
				fwrite($filehandle, $card_portion);
				fclose($filehandle);			
			}
		}		
	}			
	
	function chan_dahdi_conf($static)
	{
		if ($static == "")
		{
			$file_name = "chan_dahdi.conf";

			$filehandle = fopen($file_name, 'w') or die("can't open file");
			
			//Generate Static portion of system.conf
			$static_portion = "
;autogenerated by SMG WebGUI do not hand edit
;autogenrated on " . date('l jS \of F Y h:i:s A') . "
;Dahdi Channels Configurations
;For detailed Dahdi options, view /etc/asterisk/chan_dahdi.conf.bak

[trunkgroups]

[channels]
context=default
usecallerid=yes
hidecallerid=no
callwaiting=yes
usecallingpres=yes
callwaitingcallerid=yes
threewaycalling=yes
transfer=yes
canpark=yes
cancallforward=yes
callreturn=yes
echocancel=yes
echocancelwhenbridged=yes
relaxdtmf=yes
group=1
callgroup=1
pickupgroup=1
immediate=no
rxgain=0
txgain=0

";
			fwrite($filehandle, $static_portion);
			fclose($filehandle);			
		}	
		elseif ($static != "")
		{
			//write the config file
			$file_name = "chan_dahdi.conf";		
			$filehandle = fopen($file_name, 'a') or die("can't open file");
			
			if ($this->card_name == "A101" || $this->card_name == "A102" || $this->card_name == "A104" || $this->card_name == "A108" || $this->card_name == "B601" && $this->port_num == 1)
			{
			
				//chan_dahdi.conf card portion generation
			$card_portion = ";Sangoma " . $this->card_name . " Port " . $this->port_num . " [slot: " . $this->slot . " bus: " . $this->bus . " span: " . $this->span . "] <wanpipe" . $this->wanpipe . ">						
switchtype=" . $this->switchtype . "
context=" . $this->context . "
group=" . $this->group ."
echocancel=yes
signalling=" . $this->signalling . "
channel =>" . $this->chan_map . "
";
			}
			elseif ($this->card_name == "A200" || $this->card_name == "A400" || $this->card_name == "B601" && $this->port_num == 2 || $this->card_name == "B600")
			{
				//System.conf card portion generation
				$card_portion = "
;Sangoma " . $this->card_name . " [slot: " . $this->slot . " bus: " . $this->bus . " span: " . $this->span . "] <wanpipe" . $this->wanpipe . ">";
			
				for ($a = $_SESSION['first_chan']; $a <= $_SESSION['last_channel']; $a++)
				{
					if ($this->analog_chan[$a] == "FXO")
					{
						$card_portion .= "
context=" . $this->context . "
group=" . $this->group ."
echocancel=yes
signalling=fxs_ks
channel =>" . $a . "
";
					}
					if ($this->analog_chan[$a] == "FXS")
					{
						$group = $this->group + 1;
						$card_portion .= "
context=" . $this->context . "
group=" . $group ."
echocancel=yes
signalling=fxo_ks
channel =>" . $a . "
";
					}
				}
			}
			elseif ($this->card_name == "B700")
			{
				//System.conf card portion generation
				$card_portion = "
;Sangoma " . $this->card_name . " [slot: " . $this->slot . " bus: " . $this->bus . " span: " . $this->span . "] <wanpipe" . $this->wanpipe . ">";
			
				for ($a = $_SESSION['first_chan']; $a <= $_SESSION['last_channel']; $a++)
				{
					if ($this->analog_chan[$a] == "FXO")
					{
						$card_portion .= "
context=" . $this->context . "
group=" . $this->group ."
echocancel=yes
signalling=fxs_ks
channel =>" . $a . "
";
					}
					if ($this->analog_chan[$a] == "FXS")
					{
						$group = $this->group + 1;
						$card_portion .= "
context=" . $this->context . "
group=" . $group ."
echocancel=yes
signalling=fxo_ks
channel =>" . $a . "
";
					}
				}
			}							
			//echo $card_portion;
			fwrite($filehandle, $card_portion);
			fclose($filehandle);			
		}		
	}
	
	//Adds dahdi_cfg to the wanrouter start boot
	function start_wanrouter_dahdi()
	{
		shell_exec("rm -f /etc/wanpipe/scripts/start");
		shell_exec("cp -f dahdi_config/start /etc/wanpipe/scripts");
	}
	
	//Removes and stop dahdi_cfg from starting with wanrouter
	function no_dahdi_cfg()
	{
		shell_exec("rm -f /etc/wanpipe/scripts/start");
	}
}

?>