<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/
session_start();

include "../fusionpbx/root.php";
if (!file_exists($_SERVER['DOCUMENT_ROOT'].PROJECT_PATH."/includes/config.php")){
	header("Location: ".PROJECT_PATH."/install.php");
	exit;
}
require_once "includes/config.php";
require_once "includes/checkauth.php";
require_once "sangoma/database_classes.php";
require_once "wanpipe_config/wanpipe.php";
require_once "production-test/prod-test-class.php";
require_once "display_class.php";
require_once "SSH_Class_new.php";
require_once "controls_helper.php";
	
// Prepare display
$display_common = new Display_common;
// Prepare database
$db_location = "sqlite:sqlite/cardinfo.db";
$data = new database_class;

// ************************************************************************************
// HEADER 
// ************************************************************************************
//print_r( $_SERVER );
//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
	unset($_SESSION['embedded']);
	
	//FusionPBX Integration
	require_once "includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
	//Includes required for ClearOS Integration
	include 'sqlite/database_creation.php';

	$_SESSION['embedded'] = "true";
	
	//ClearOS Integration
	$display_common->session_vars("sqlite:sqlite/cardinfo.db");
	$display_common->html_header();
	$display_common->html_title("Control panel", "/style.css","");		
}	

// ************************************************************************************
// BODY
// ************************************************************************************
// Enable dynamic Div 
if ($display_common->IsRenderingNonDynamicDiv())  
{
	$display_common->DynamicDivEnable();
  unset($_SESSION['execute_ctx']);
  //echo "POST=";
  //print_r( $_POST );
  //echo "<br/>";
  foreach( $_POST as $post_key => $post_param )
  {
    switch($post_key)
    {
    case 'ip_addr': $host_ip = $post_param; break;
    case 'ssh_port': $host_ssh_port = $post_param; break;
    case 'node_name': $node_name = $post_param; break;
    case 'self_page': $self_page = $post_param; break;
    case 'mode' : break; // just skip it
    default: $host_cmd = $post_key; break;
    }
  }

  // Figure out if loop is required
  if ($node_name == "all")
  {
    $index = 0;
    $_SESSION['execute_ctx']['batch'] = true;
    // Have to find out all nodes to apply command on
    // Rules are:
    //  - gateway_stop : Stop all slaves then master
    //  - gateway_start: Start master then all slaves
    //  - gateway restart : gateway_stop + gateway_start
    //  - tc_xx : order doesn't matter
    if ($host_cmd == 'gateway_stop' || $host_cmd == 'gateway_restart' )
    {
      $nodes = $data->array_select_statement("sqlite:sqlite/relay_info.db",
                          "relay_hosts",
                          "*",
                          "id NOT NULL ORDER BY id DESC");
      foreach($nodes as $node)
      {
        $_SESSION['execute_ctx']['jobs'][$index]['name'] = $node['relay_name'];
        $_SESSION['execute_ctx']['jobs'][$index]['cmd'] = "gateway_stop";
        $_SESSION['execute_ctx']['jobs'][$index]['ip_addr'] = $node['ip_addr'];
        $_SESSION['execute_ctx']['jobs'][$index]['ssh_port'] = $node['ssh_port'];
        $index+=1;
      }
      $nodes = null;
    } 
    if ($host_cmd == 'gateway_start' || $host_cmd == 'gateway_restart' )
    {
      $nodes = $data->array_select_statement("sqlite:sqlite/relay_info.db",
                          "relay_hosts",
                          "*",
                          "id NOT NULL ORDER BY id ASC");
      foreach($nodes as $node)
      {
        $_SESSION['execute_ctx']['jobs'][$index]['name'] = $node['relay_name'];
        $_SESSION['execute_ctx']['jobs'][$index]['cmd'] = "gateway_start";
        $_SESSION['execute_ctx']['jobs'][$index]['ip_addr'] = $node['ip_addr'];
        $_SESSION['execute_ctx']['jobs'][$index]['ssh_port'] = $node['ssh_port'];
        $index+=1;
      }
      $nodes = null;
    } 
    if ($host_cmd == 'tc_start' || $host_cmd == 'tc_stop' || $host_cmd == 'tc_restart' )
    {
      $nodes = $data->array_select_statement("sqlite:sqlite/relay_info.db",
                          "relay_hosts",
                          "*",
                          "id NOT NULL ORDER BY id ASC");
      foreach($nodes as $node)
      {
        $_SESSION['execute_ctx']['jobs'][$index]['name'] = $node['relay_name'];
        $_SESSION['execute_ctx']['jobs'][$index]['cmd'] = $host_cmd;
        $_SESSION['execute_ctx']['jobs'][$index]['ip_addr'] = $node['ip_addr'];
        $_SESSION['execute_ctx']['jobs'][$index]['ssh_port'] = $node['ssh_port'];
        $index+=1;
    }
      $nodes = null;
    } 
    if ($host_cmd == 'service_startup')
    {
      $nodes = $data->array_select_statement("sqlite:sqlite/relay_info.db",
                          "relay_hosts",
                          "*",
                          "id NOT NULL ORDER BY id ASC");
      foreach($nodes as $node)
      {
        $_SESSION['execute_ctx']['jobs'][$index]['name'] = $node['relay_name'];
        $_SESSION['execute_ctx']['jobs'][$index]['cmd'] = $host_cmd . "_" . $_POST['mode'];
        $_SESSION['execute_ctx']['jobs'][$index]['ip_addr'] = $node['ip_addr'];
        $_SESSION['execute_ctx']['jobs'][$index]['ssh_port'] = $node['ssh_port'];
        $index+=1;
      }
      $nodes = null;
    } 
  }
  else
  {
    // Command for a specific node 
    $_SESSION['execute_ctx']['batch'] = false;
    $_SESSION['execute_ctx']['jobs'][0]['name'] = $node_name;
    if ($host_cmd == 'service_startup')
      $_SESSION['execute_ctx']['jobs'][0]['cmd'] = $host_cmd . "_" . $_POST['mode'];
    else
      $_SESSION['execute_ctx']['jobs'][0]['cmd'] = $host_cmd;
    $_SESSION['execute_ctx']['jobs'][0]['ip_addr'] = $host_ip;
    $_SESSION['execute_ctx']['jobs'][0]['ssh_port'] = $host_ssh_port ;
  }
  $_SESSION['execute_ctx']['index']=0;
  $_SESSION['execute_ctx']['self_page']=$self_page;
  unset($_POST);
}
else
{
  // Do one job
  $job_index = $_SESSION['execute_ctx']['index'];
  //echo "Job index=" . $job_index . "<br/>";
  if ($job_index <= count($_SESSION['execute_ctx']['jobs']) ) 
  {
    // Get the job
    $job = $_SESSION['execute_ctx']['jobs'][$_SESSION['execute_ctx']['index']];
    // Execute and store result in context
    $_SESSION['execute_ctx']['result'][$job_index]['name'] = $job['name'];
    $_SESSION['execute_ctx']['result'][$job_index]['output'] = hostExecuteCommand($job['cmd'], $job['ip_addr'], $job['ssh_port']);
    // Next job on next loop
    $_SESSION['execute_ctx']['index'] = $job_index+1;
  }
  else
  {
    $_SESSION['execute_ctx']['done'] = true;
  }
}

// Render job result executed so far
if ( $display_common->IsRenderingNonDynamicDiv( ) 
  || $display_common->IsDynamicDivRefreshRequest('ExecuteDiv') )
{
  //print_r($_SESSION['execute_ctx']);
  // Get cached execute context
  $exec_rc = $_SESSION['execute_ctx'];
  $display_common->DynamicDivBegin( "ExecuteDiv", "", 500);
  echo "<table class='mytable' width='100%'>\n"; 
  echo "  <tr>\n";
  echo "   	<th class='widget-content-header ui-state-active ui-corner-top'";
  if ($exec_rc['batch'])
    echo "colspan='3'";
  else
    echo "colspan='2'";
  echo " align='left'>&nbsp;" .  $_SESSION['shortname'];
  if ($exec_rc['done'] )
    echo " Commands Executed";
  else
    echo " Executing commands...";
  echo "</th>\n";
  echo "  </tr>\n";
  // Loop around execution tasks status
  foreach($exec_rc['result'] as $job_rc)
  {
    foreach($job_rc['output'] as $cmd => $cmd_rc)
    {
      if ((($loop_index++)%2) == 0)
      {
        $bkColor = " style='background-color:". COLOR_ROW_EVEN ."' ";
      }
      else 
      {
        $bkColor = " style='background-color:". COLOR_ROW_ODD ."' ";
      }

      echo "  <tr " . $bkColor . ">\n";
      if ($exec_rc['batch'])
      {
        echo "    <td width='10%' valign='top'>\n<b>";
        echo      $job_rc['name'];
        echo "    </b></td>\n";
      }
      echo "    <td width='20%' valign='top'>\n";
      echo      $cmd;
      echo "    </td>\n";
      echo "    <td align='left'>\n";
      foreach($job_rc['output'][$cmd] as $rc_line)
      {
        $rc_line = trim($rc_line);
        if (strlen($rc_line))
        echo $rc_line . "<br/>\n";
      }
      echo "    </td>\n";
      echo "  </tr>\n";
    }
  }
  if (!$exec_rc['done'] )
  {
    echo "<tr>\n";
    echo "<td \n";
    if ($exec_rc['batch'])
      echo "colspan='3'";
    else
      echo "colspan='2'";
    echo ">\n";
    echo $display_common->LoadingIcon();
    echo "</td>\n";
    echo "</tr>\n";
  }
  echo "  <tr>\n";
  echo "   	<th class='widget-content-header ui-state-active ui-corner-bottom' ";
  if ($exec_rc['batch'])
    echo "colspan='3'";
  else
    echo "colspan='2'";
  echo " align='left'></th>\n";
  echo "  </tr>\n";
  echo "</table>\n"; 
  // Display back button
  if ($exec_rc['done'] )
    $button_class =  $_SESSION['button_class'];
  else
    $button_class =  "disabled='disabled' " . $_SESSION['disabled_button_class'];
  echo "<div align='right' width='100%'>\n";
  echo "<form name='execute_back' method='post' action='".$_SESSION['execute_ctx']['self_page']."'>\n"; 
  echo "  <input type='submit' name='back' value='back' ". $button_class ."/>\n";
  echo "</form>\n";
  echo "</div>\n";
  $display_common->DynamicDivEnd("ExecuteDiv");
}

// ************************************************************************************
// FOOTER
// ************************************************************************************
if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
{
  $QueryArgs = explode( "&", $_SERVER['QUERY_STRING'] );
  foreach ( $QueryArgs as $QueryArg )
  {
  $KeyValue = explode("=", $QueryArg );
  if ( "action" == $KeyValue[0] || "RefreshValueInSec" == $KeyValue[0] )
      continue;
    echo "<input type='hidden' name='" . $KeyValue[0] . "' value='" . $KeyValue[1] . "'/>\n";
  unset( $KeyValue );
  }
  unset( $QueryArgs );
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}

?>

