<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/
session_start();
require_once "display_class.php";

define(	"RELAY_TABLE", 					"ss7_relay"); //Table which contains the relay hosts

// Prepare display
$display_common = new Display_common;
if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
	if (empty($_POST))
		include ('check_referer.php');

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1") {
include "../fusionpbx/root.php";
if (!file_exists($_SERVER['DOCUMENT_ROOT'].PROJECT_PATH."/includes/config.php")){
  header("Location: ".PROJECT_PATH."/install.php");
	exit;
}
require_once "includes/config.php";
require_once "includes/checkauth.php";
require_once "sangoma/database_classes.php";
require_once "wanpipe_config/wanpipe.php";
require_once "production-test/prod-test-class.php";
require_once "SSH_Class_new.php";
require_once "relay/relay_questionnaire_class.php";

// Prepare database
$db_location = "sqlite:sqlite/cardinfo.db";
$data = new database_class;
$relay = new questionnaire;

// If running relay, created tabbed layout for master, create readonly layout for slave
$table_exists = $data->check_for_table("sqlite:sqlite/relay_info.db","ss7_relay");

if ($table_exists > 1)
{
  $relay_type = $data->select_statement("sqlite:sqlite/relay_info.db","ss7_relay","machine_type, relay_type","id = 1");
  if ($relay_type['machine_type'] == "")
  {
    //Does not allow control panel until relay questionaire answered
    //header('relay/relay_cfg.php');
	
	//Force to standalone mode
	$_REQUEST['option'] = "no";
	$relay->ss7_type_database($data,'ss7_relay', 'sqlite:sqlite/relay_info.db');
  }
}
elseif ($table_exists < 2)
{
  //Does not allow control panel until relay questionaire answered
  //header('Location:relay/relay_cfg.php');
	$_REQUEST['option'] = "no";
	$relay->ss7_type_database($data,'ss7_relay', 'sqlite:sqlite/relay_info.db');
  
}

// ************************************************************************************
// Getting a POST request ?
// ************************************************************************************
/*if ( isset($_POST) && sizeof($_POST) )
{
  header('Location:controls_execute.php');
}*/
	
// ************************************************************************************
// HEADER 
// ************************************************************************************

//Check to see which UI we are running in
if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
{
	unset($_SESSION['embedded']);
	
	//FusionPBX Integration
	require_once "includes/header.php";
}
elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
{
	//Includes required for ClearOS Integration
	include 'sqlite/database_creation.php';

	$_SESSION['embedded'] = "true";
	
	//ClearOS Integration
	$display_common->session_vars("sqlite:sqlite/cardinfo.db");
	$display_common->html_header();
	$display_common->html_title("Control panel", "/style.css","");		
}	

require_once "controls_helper.php";

// ************************************************************************************
// BODY 
// ************************************************************************************
echo "<a name='top'></a>\n";
// Enable dynamic Div 
if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded'])
  && $display_common->IsRenderingNonDynamicDiv( ) )  
{
	$display_common->DynamicDivEnable();
}

// Auto refresh dynamic Div 
// wadam: Remove auto-refresh 
//$display_common->DynamicDivAutoRefresh( "style='width:710px;'");

if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
{
  //echo "<br/>\n";
  
  echo "<table width='710px'>\n";
  echo "<tr>\n";
  echo "<td width='60%'";
  if ($relay_type['relay_type'] == "MASTER" )
    echo " rowspan='2' ";
  echo " valign='top'>\n";
}

// ************************************************************************************
// Port status Dynamic Div
// ************************************************************************************

if ($display_common->IsRenderingNonDynamicDiv( )  
  || $display_common->IsDynamicDivRefreshRequest('ControlPanelDiv') )
{
  if ($relay_type['machine_type'] == "relay" )
  {
    $colCount = 4;
    $processColWidth = '170px';
  }
  else
  {
    $colCount = 3;
    $processColWidth = '240px';
  }
  if ($relay_type['relay_type'] == "MASTER" )
  {
    // Retrieve all slave nodes
    $relay_slave = $data->array_select_statement("sqlite:sqlite/relay_info.db",
                            "relay_hosts",
                            "*",
                            //"relay_name LIKE 'Slave%' ORDER BY id");
                            "id NOT NULL ORDER BY id ASC");
  }
  else
  {
    // Prepare fake table with local info
    $relay_slave[0]['id'] = 1;
    $relay_slave[0]['relay_name'] = $relay_type['relay_type'];
  }

  $display_common->DynamicDivBegin( "ControlPanelDiv","width:500px", 500 );
  echo "<table border='1' width='500px' class='mytable'>\n";
  echo "   	<th class='widget-content-header ui-state-active ui-corner-top' colspan='".$colCount."' align='left'>" . $_SESSION['shortname'] . " Status</th>\n";
        
  echo "		<tr>\n";
  if ($relay_type['machine_type'] == "relay" )
    echo "     	<td class='mytableheader ui-state-active' align='center' width='70px'>Node</td>\n";
  echo "     	<td class='mytableheader ui-state-active' align='center' width='".$processColWidth ."'>Process</td>\n";
  echo "      <td class='mytableheader  ui-state-active' align='center' width='120px'>Status</td>\n";
  echo "      <td class='mytableheader  ui-state-active' align='center' width='125px'>Controls</td>\n";
  echo "    </tr>        \n";

  // Prepare SESSION variable to keep track of relay status checking
  if ($display_common->IsRenderingNonDynamicDiv( ) ) 
  {
    // Entering page, unset everything
    unset($_SESSION['relay_ctx']);
    foreach ($relay_slave as $slave)
    {
      $_SESSION['relay_ctx']['nodes'][$slave['relay_name']]['service']['ssh'] = "CONNECTING";
    }
    $_SESSION['relay_ctx']['current_slave'] = 0;
  }
  else
  {
    $_SESSION['relay_ctx']['current_slave']++;
    if ($_SESSION['relay_ctx']['current_slave']>count($relay_slave) )
      $_SESSION['relay_ctx']['current_slave'] = 0;
  }
  $start_time = time();
  // Display slave
  $loop_index = 0;
  foreach ($relay_slave as $slave)
  {
    // Get slave services status
    if ( $slave['relay_name']==$relay_slave[$_SESSION['relay_ctx']['current_slave']]['relay_name'] || $slave['id'] == "1" )
    {
      // Update relay status
      $_SESSION['relay_ctx']['nodes'][$slave['relay_name']]['service'] = hostGetServicesStatus( $slave['ip_addr'], $slave['ssh_port'] );
    }
    $service = $_SESSION['relay_ctx']['nodes'][$slave['relay_name']]['service'];

    // Prepare array to display
    if ( (($loop_index++)%2)  == 1)
    {
      $bkColor = " style='background-color:". COLOR_ROW_ODD ."' ";
    }
    else 
    {
      $bkColor = " style='background-color:". COLOR_ROW_EVEN ."' ";
    }

    echo "<tr " . $bkColor . ">\n";
    if ($relay_type['machine_type'] == "relay" )
    {
      // Node name
      echo "  <td rowspan='3' style='min-height:60px;height:60px'>\n";
      echo "    <b>\n";
      echo      $slave['relay_name'];
      echo "    </b>\n";
      echo "  </td>\n";
    }

    // Check if remote connection is up ?
    if ( $service['ssh'] == "up" )
    {
      // Media gateway row
      echo "<td>\n";
      echo "  <b>\n";
      echo " Media Gateway";
      echo "  </b>\n";
      echo "</td>\n";

      echo "<td align='center' style='background-color:";
      echo ($service['free'] == "up")?COLOR_OK:COLOR_ERROR;
      echo "'><font color='white'><b>";
      echo ($service['free'] == "up")?"STARTED":"STOPPED";
      echo "</b></td>";
      // Node control
      echo "  <td rowspan='2' align='center'>\n";
      // Prepare slave control form
      echo "<form name='gw_control".$slave['relay_name']."Gateway' ' method='post' action='controls_execute.php'>\n"; 
      echo "<input type='hidden' name='self_page' value='".$_SERVER['PHP_SELF']."'/>\n";
      // Add hidden form elements for ip_addr and ssh port
      echo "<input type='hidden' name='ip_addr' value='".$slave['ip_addr']."'/>\n"; 
      echo "<input type='hidden' name='ssh_port' value='".$slave['ssh_port']."'/>\n"; 
      if ($slave['id'] == '1')
        echo "<input type='hidden' name='node_name' value='local'/>\n"; 
      else
        echo "<input type='hidden' name='node_name' value='".$slave['relay_name']."'/>\n"; 
      if ( $service['wan'] == "down" && $service['free'] == "down" )
        echo "  <input type='submit' name='gateway_start' value='Start'" . $_SESSION['button_class'] ." />\n";
      else
        echo "  <input type='submit' name='gateway_stop' value='Stop'" . $_SESSION['button_class'] ." />\n";
      echo "  <input type='submit' name='gateway_restart' value='Restart'" . $_SESSION['button_class'] ." />\n";
      echo "</form>\n";
      echo "  </td>\n";

      // Node status
      echo "<tr " . $bkColor . ">\n";
      echo "<td>\n";
      echo "  <b>\n";
      echo " TDM Driver";
      echo "  </b>\n";
      echo "</td>\n";
      echo "<td align='center' style='background-color:";
	  
	  //Check if any port states inactive and set it to true if it does
	  unset($inactive_port);
	  
	  foreach ($service['wanpipe_summary'] as $line)
	  {
		  if (preg_match("'\bInactive\b'",$line))
			  $inactive_port = true;
	  }
	  
      //echo ($service['wan'] == "up")?COLOR_OK:COLOR_ERROR;
	  if ($service['wan'] == "up")
	  {
		  if ($inactive_port)
			  echo COLOR_WARNING;
		  else
			  echo COLOR_OK;
	  }
	  else
	  {
		  echo COLOR_ERROR;
	  }
      echo "'><font color='white'><b>";
      echo "<span title='"; 
        foreach ($service['wanpipe_summary'] as $tmpLine ) echo $tmpLine . "\n";
      echo "'>\n";
      //echo ($service['wan'] == "up")?"UP":"DOWN";
	  if ($service['wan'] == "up")
	  {
		  if ($inactive_port)
			  echo "ERROR";
		  else
			  echo "STARTED";
	  }
	  else
	  {
		  echo "STOPPED";
	  }	  
      echo "</span>";
      echo "</b></td>";
      // Node control
      echo "</tr>\n";

      // Node status
      echo "<tr " . $bkColor . ">\n";
      echo "<td>\n";
      echo "  <b>\n";
      echo "  Media Processing";
      echo "  </b>\n";
      echo "</td>\n";
      switch($service['sngtc'])
      {
        case "up":
        case "down":
          echo "<td align='center' style='background-color:";
          echo ($service['sngtc'] == "up")?COLOR_OK:COLOR_ERROR;
          echo "'>";
          echo "<font color='white'><b>";
          echo ($service['sngtc'] == "up")?"STARTED":"STOPPED";
          echo "</b></td>";
          // Node control
          echo "  <td align='center'>\n";
          // Prepare slave control form
          echo "<form name='gw_control".$slave['relay_name']."Media' ' method='post' action='controls_execute.php'>\n"; 
          echo "<input type='hidden' name='self_page' value='".$_SERVER['PHP_SELF']."'/>\n";
          // Add hidden form elements for ip_addr and ssh port
          echo "<input type='hidden' name='ip_addr' value='".$slave['ip_addr']."'/>\n"; 
          echo "<input type='hidden' name='ssh_port' value='".$slave['ssh_port']."'/>\n"; 
          if ($slave['id'] == '1')
            echo "<input type='hidden' name='node_name' value='local'/>\n"; 
          else
            echo "<input type='hidden' name='node_name' value='".$slave['relay_name']."'/>\n"; 
          if ($service['sngtc'] == "down" )
            echo "  <input type='submit' name='tc_start' value='Start'" . $_SESSION['button_class'] ." />\n";
          else
            echo "  <input type='submit' name='tc_stop' value='Stop'" . $_SESSION['button_class'] ." />\n";
          echo "  <input type='submit' name='tc_restart' value='Restart'" . $_SESSION['button_class'] ." />\n";
          echo "</form>\n";
          echo "  </td>\n";
          break;
        case "N/A":
          echo "<td align='center' style='background-color:" . COLOR_WARNING . "'/>\n";
          echo "<font color='white'><b>";
          echo "Not available";
          echo "</b></font></td>";
          echo "<td>\n";
          echo "</td>\n";
          break;
      }
      echo "</tr>\n";
    }
    else
    {
      // Not able to cummunicate with remote node
      echo "<td rowspan='3'>\n";
      echo "  <b>\n";
      echo ($service['ssh'] == "CONNECTING")?"Connecting...":"Connection failure";
      echo "  </b>\n";
      echo "</td>\n";
      //echo "</tr>\n";
      if ($service['ssh'] == "CONNECTING" )
      {
        echo "<td rowspan='3' align='center'>\n";
        $display_common->LoadingIcon();
        echo "</td>\n";
      }
      else
      {
        echo "<td rowspan='3' align='center' style='background-color:" . COLOR_WARNING . "'><font color='white'><b>".$service['ssh']."</b></font></td>";
      }
      echo "<td rowspan='3' align='center'>\n";
      echo "</td>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "</tr>\n";
      echo "<tr>\n";
      echo "</tr>\n";
      echo "</tr>\n";
    }
    echo "</tr>\n";
    unset($service);
  }
  echo "<th align='left' class='widget-content-header ui-state-active ui-corner-bottom' colspan='".$colCount."'>\n";
  echo "</table>\n";
  $display_common->DynamicDivEnd( "ControlPanelDiv" );
  // End port table
}

// ************************************************************************************
// Startup mode
// ************************************************************************************
if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
{
  // Wanpipe common functions
  $wanpipe_common_functions = new wanpipe_common;
  $serviceBoot = $wanpipe_common_functions->wanrouter_startup_check();
  $wanpipe_common_functions= null;
  echo "</td>\n";
  echo "<td align='center' valign='top'>\n";
  // Display options table
  echo " <table class='mytable' width='200px'>\n";
  echo "   <th class='widget-content-header ui-state-active ui-corner-top' colspan='2' align='left'>Gateway Options</th>\n";
  // Startup mode option
  echo " <tr>\n";
  echo "   <td class='mytableheader  ui-state-active' align='center'>\n";
  echo "   Startup Mode\n";  
  echo "   </td>\n";
  echo "   <td>\n";
  // Display control, start form
  echo "<form name='service_control' method='post' action='controls_execute.php'>\n"; 
  echo "<input type='hidden' name='self_page' value='".$_SERVER['PHP_SELF']."'/>\n";
  echo "     <table class='mytable-corner-none' width='100%'><tr><td>\n";
  echo "     <table width='100%'>\n";
  echo "       <tr>\n";
  echo "        <td align='center'>\n";
  echo "          <input type='radio' name='mode' value='boot'" . (($serviceBoot == true) ?"checked='checked'":"") . "/>\n";
  echo "        </td>\n";
  echo "        <td>\n";
  echo "          Boot\n";
  echo "        </td>\n";
  echo "       <td align='center' rowspan='2' border='1'>\n";
  echo "         <input type='submit' name='service_startup' value='Apply' " . $_SESSION['button_class'] . "/>\n";
  echo "        </td>\n";
  echo "      </tr>\n";
  echo "      <tr>\n";
  echo "        <td align='center'>\n";
  echo "         <input type='radio' name='mode' value='manual'" . (($serviceBoot == false) ?"checked='checked'":"") . "/>\n";
  echo "        </td>\n";
  echo "        <td>\n";
  echo "          Manual\n";
  echo "        </td>\n";
  echo "      </tr>\n";
  echo "     </table>\n";
  echo "</td></tr></table>\n";
  if ($relay_type['relay_type'] == "MASTER" )
    echo "  <input type='hidden' name='node_name' value='all'/>\n";
  echo "</form>\n";
  echo "   </td>\n";
  echo " </tr>\n";
  echo "<th class='widget-content-header ui-state-active ui-corner-bottom' colspan='2'/>\n";
  echo "</table>\n";
  echo "</td>\n";
  echo "</tr>\n";
  // Do we need to add the Relay nodes control panel ?
  if ($relay_type['relay_type'] == "MASTER" )
  {
    echo "<tr>\n";
    echo "<td align='center' valign='top'>\n";
    $display_common->DynamicDivBegin( "RelayControlDiv","width:100%", 500 );
    displayRelayControl($_SESSION['relay_ctx']['nodes']);
    $display_common->DynamicDivEnd( "RelayControlDiv" );
    echo "</td>\n";
    echo "<tr>\n";
  }
  echo "</table>\n";
}

if ($display_common->IsDynamicDivRefreshRequest('RelayControlDiv'))
{
  displayRelayControl($_SESSION['relay_ctx']['nodes']);
}

// ************************************************************************************
// Notification Dynamic Div
// ************************************************************************************
if ($display_common->IsRenderingNonDynamicDiv( )  
  || $display_common->IsDynamicDivRefreshRequest('NotificationDiv') )
{
  $display_common->DynamicDivBegin( "NotificationDiv","width:700px");
     
  $notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
  echo "<br/>\n";
  // Check if TDM configuration is in synch
  if ( !isTdmConfigInSync("sqlite:sqlite/cardinfo.db") )
  {
    $notif->add("TDM","Configuration out of sync" );
	if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		$embedded='?embedded=true';

	$_gateway_status = shell_exec('pidof ' . $_SESSION['gateway_script']);
	if ($_gateway_status == 0 || $_gateway_status == "")
		$_gateway_status = false;
	else
		$_gateway_status = true;
	
	if (!$_gateway_status) {
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
			$notif->add("TDM","<a href='/fusionpbx/sangoma/sng_config_manager.php'>Generate</a> TDM configuration." );
		else
			$notif->add("TDM","<a href='/admin/ss7_cfg_manager.php' target='_parent'>Generate</a> TDM configuration." );		
	}
    if  ( $wan == "up" || $free == "up" ) 
    {
      $notif->add("TDM","Stop the gateway," );
      $notif->add("TDM","Generate TDM configuration." );
    }
    else
    {
		if ($_SESSION['shortname'] == "NSG") {
			if($_gateway_status && isMGConfigInSync($db_location)) {
				if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
					$notif->add("TDM","<a href='/fusionpbx/sangoma/sng_config_manager.php'>Synchronize</a> configuration." );
				else
					$notif->add("TDM","<a href='/admin/ss7_profile_panel.php' target='_parent'>Synchronize</a> configuration." );
			}else{
				if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
					$notif->add("TDM","<a href='/fusionpbx/sangoma/sng_config_manager.php'>Generate</a> TDM configuration." );
				else
					$notif->add("TDM","<a href='/admin/ss7_cfg_manager.php' target='_parent'>Generate</a> TDM configuration." );
			}
		}
		elseif ($_SESSION['shortname'] == "NVG" && $_gateway_status )
    	{
    		  $notif->add("TDM","Stop the gateway," );
    		  $notif->add("TDM","Generate TDM configuration." );
    	}
	}
  }
  // Check for transcoding configuration
  if ($mediaCardCount 
    && !isMediaConfigInSync("sqlite:sqlite/cardinfo.db") )
  {
	  if (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
		$embedded='?embedded=true';
    $notif->add("Media","Configuration out of sync" );
    if ( $sngtc == "up" )
    {
      $notif->add("Media","Stop the Media processing," );
      $notif->add("Media","Generate Media configuration." );
    }
    else
    {
		if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	    	$notif->add("Media","<a href='/fusionpbx/sangoma/sng_config_manager.php'>Generate</a> Media configuration." );
		else
			$notif->add("Media","<a href='/admin/ss7_cfg_manager.php' target='_parent'>Generate</a> Media configuration." );
    }

  }
  if (isset($_SESSION['relay_ctx']) )
  {
    $slave_unreachable_count = 0;
    // loop around to see if some slaves are unreachable
    foreach($_SESSION['relay_ctx'] as $slave_relay_status )
    {
      if ( isset($slave_relay_status['service']['ssh']) )
      {
        if ( $slave_relay_status['service']['ssh'] != "CONNECTING" 
          &&
          $slave_relay_status['service']['ssh'] != "up" )
        {
          $slave_unreachable_count++;
        } 
      }
    }
  }
  if ( $slave_unreachable_count>0 )
  {
      $notif->add("Relay", $slave_unreachable_count . " Slave relay node(s) are unreachable." );
      $notif->add("Relay","Check slave relay node configuration." );
  }

  if (!isH323ConfigInSync('sqlite:sqlite/cardinfo.db',$data)) {
	  $notif->add("H.323",'Configuration out of sync.');
	  $notif->add("H.323",'Please restart the gateway in order for H.323 settings to come into effect.');
  }  
  if (!isSIPConfigInSync('sqlite:sqlite/cardinfo.db',$data)) {
	  $notif->add("SIP",'Configuration out of sync.');
	  $notif->add("SIP",'Please restart the gateway in order for SIP settings to come into effect.');
  }
  
	//CHECK LICENSE CONFLICTS	
  $mediaObj = new prod_test();
  $display_common->get_license_status($data,$mediaObj,$license_err, $channel_err,$trial_license_error);
  $mediaObj = NULL;	
  if ( isset($license_err) )
    $notif->add("License", $license_err);
  if ( isset($channel_err) )
    $notif->add("Channels", $channel_err);
	//$display_common->find_vocallo_firmware();

  if (isset($trial_license_error))
     $notif->add("Timed Trial", $trial_license_error);
  // Rendering dynamic
  echo $notif->getHtml();

  echo "<br />";
  require_once 'generic_functions.php';
  $sctp_status = false;
  $sig_ip_status = false;
  $rtp_ip_status = false;
  check_ip_exist($data,'sqlite:sqlite/cardinfo.db',$sctp_status, $sig_ip_status, $rtp_ip_status);
  $notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
  if (!$sctp_status)
	  $notif->add('SCTP',	'One of your SCTP Profiles contains an invalid IP Address. Please adjust your SCTP Profiles');
  if (!$sig_ip_status)
	  $notif->add('Media Gateway Profile','One of your Media Gateway profiles contains an invalid Signalling IP Address. Please adjust your Media Gateway Profiles');
  if (!$rtp_ip_status)
	  $notif->add('Media Gateway Profile','One of your Media Gateway profiles contains an invalid RTP IP Address. Please adjust your Media Gateway Profiles');
  $notif->display();
  unset($notif);
  
  // Close dynamic div
  $display_common->DynamicDivEnd( "NotificationDiv" );
}

if ( $display_common->IsRenderingNonDynamicDiv( ) ) 
{
  $QueryArgs = explode( "&", $_SERVER['QUERY_STRING'] );
  foreach ( $QueryArgs as $QueryArg )
  {
  $KeyValue = explode("=", $QueryArg );
  if ( "action" == $KeyValue[0] || "RefreshValueInSec" == $KeyValue[0] )
      continue;
    echo "<input type='hidden' name='" . $KeyValue[0] . "' value='" . $KeyValue[1] . "'/>\n";
  unset( $KeyValue );
  }
  unset( $QueryArgs );

	// ************************************************************************************
	// FOOTER
	// ************************************************************************************
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
    //FusionPBX Integration
		require_once "includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
}

function displayRelayControl($nodes_status)
{
  // loop around all node status to figure out global service status
  // Assume everything started and reachable
  $gw_node_started = true;
  $media_node_started = true;
  $all_node_reachable = true;

  foreach($nodes_status as $k=>$node)
  {
    // check for ssh 
    if ($node['service']['ssh'] != 'up')
      $all_node_reachable = false;
    // check for freeswitch and wanrouter
    if ($node['service']['free'] != 'up' || $node['service']['wan'] != 'up' )
      $gw_node_started = false;
    if ($node['service']['sngtc'] != 'up' || $node['service']['sngtc'] != 'N/A' )
      $media_node_started = false; 
  }

  if ($all_node_reachable)
    $button_class =  $_SESSION['button_class'];
  else
    $button_class =  "disabled='disabled' " . $_SESSION['disabled_button_class'];

  echo " <table class='mytable' width='200px'>\n";
  echo "   <th class='widget-content-header ui-state-active ui-corner-top' colspan='2' align='left'>Relay Nodes Control</th>\n";
  // Gateways control
  echo " <tr>\n";
  echo "   <td class='mytableheader  ui-state-active' align='center'>\n";
  echo "   Gateway\n";  
  echo "   </td>\n";
  echo "   <td>\n";
  // Display gateway control, start form
  echo "<form name='relay_gateway_control' method='post' action='controls_execute.php'>\n"; 
  echo "<input type='hidden' name='self_page' value='".$_SERVER['PHP_SELF']."'/>\n";
  echo "<input type='hidden' name='node_name' value='all'/>\n";
  echo "     <table width='100%' class='mytable-corner-none'>\n";
  echo "       <tr>\n";
  echo "        <td align='center'>\n";
  echo "         <input type='submit' name='gateway_start' value='Start All' ". $button_class ." />\n";
  echo "        </td>\n";
  echo "        <td align='center' valign='center' rowspan='2'>\n";
  echo "         <input type='submit' name='gateway_restart' value='Restart All' " . $button_class ." />\n";
  echo "        </td>\n";
  echo "      </tr>\n";
  echo "      <tr>\n";
  echo "        <td align='center'>\n";
  echo "         <input type='submit' name='gateway_stop' value='Stop All' ". $button_class ." />\n";
  echo "        </td>\n";
  echo "      </tr>\n";
  echo "  </table>\n";
  echo "</form>\n";
  echo "   </td>\n";
  echo " </tr>\n";
  // Medias control
  echo " <tr>\n";
  echo "   <td class='mytableheader  ui-state-active' align='center'>\n";
  echo "   Media\n";  
  echo "   </td>\n";
  echo "   <td>\n";
  // Display media control, start form
  echo "<form name='relay_media_control' method='post' action='controls_execute.php'>\n"; 
  echo "  <input type='hidden' name='self_page' value='".$_SERVER['PHP_SELF']."'/>\n";
  echo "  <input type='hidden' name='node_name' value='all'/>\n";
  echo "     <table width='100%' class='mytable-corner-none'>\n";
  echo "       <tr>\n";
  echo "        <td align='center'>\n";
  echo "          <input type='submit' name='tc_start' value='Start All' " . $button_class ." />\n";
  echo "        </td>\n";
  echo "        <td align='center' valign='center' rowspan='2'>\n";
  echo "          <input type='submit' name='tc_restart' value='Restart All' " . $button_class ." />\n";
  echo "        </td>\n";
  echo "      </tr>\n";
  echo "      <tr>\n";
  echo "        <td align='center'>\n";
  echo "          <input type='submit' name='tc_stop' value='Stop All' " . $button_class ." />\n";
  echo "        </td>\n";
  echo "      </tr>\n";
  echo "  </table>\n";
  echo "</form>\n";
  echo "   </td>\n";
  echo " </tr>\n";
  echo "<th class='widget-content-header ui-state-active ui-corner-bottom' colspan='2'/>\n";
  echo "</table>\n";
}

?>

