<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

session_start();
include "database_classes.php";
include "wanpipe_config/wanpipe.php";
include 'dahdi_config/dahdi_cfg.php';
include 'smg_ctrl/smg_ctrl.php';

$db_location = "sqlite:sqlite/cardinfo.db";

$data = new database_class;
$smg_ctrl = new BRI_SMG;
$dahdi_cfg = new Dahdi_configuration;
$wanpipe_common_functions = new wanpipe_common;

if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{

	if ($_REQUEST['auto_value'] == "" && $_SESSION['refresh'] == "")
	{
		$auto_refresh = "30";
		$_SESSION['refresh'] = $auto_refresh;
	}
	elseif ($_REQUEST['auto_value'] == "" && $_SESSION['refresh'] == 30)
	{
		$auto_refresh = "30";
		$_SESSION['refresh'] = $auto_refresh;
	}
	elseif ($_REQUEST['refresh_button'] == "Update Interval")
	{	
		$auto_refresh = $_REQUEST['auto_value'];
		$_SESSION['refresh'] = $auto_refresh;
	}
	elseif ($_SESSION['refresh'] != "")
	{
		$auto_refresh = $_SESSION['refresh'];
	}
		
	
	header("refresh: $auto_refresh; url=controls.php");
	
	if ($_REQUEST['gateway_options'] == "Change Gateway Options")
	{
		//Starts Wanrouter on system boot
		if ($_REQUEST['wanrouter'] == "YES")
		{
			$wanpipe_common_functions->wanrouter_start_script();
			
			$cmd = "chkconfig " . $_SESSION['gateway_script'] . " on";
			shell_exec ($cmd);
			
			$_SESSION['wanrouter'] = "YES";
		}
		elseif ($_REQUEST['wanrouter'] == "NO")
		{
			$wanpipe_common_functions->wanrouter_no_startup();
			$cmd = "chkconfig " . $_SESSION['gateway_script'] . " off";
			shell_exec ($cmd);

			$_SESSION['wanrouter'] = "NO";
		}
		
		//If run dahdi_cfg is selected, include the start file within the /etc/wanpipe/scripts directory
		if ($_REQUEST['dahdi_cfg'] == "YES")
		{
			$dahdi_cfg->start_wanrouter_dahdi();
			$_SESSION['dahdi_cfg'] = "YES";
		}
		elseif ($_REQUEST['dahdi_cfg'] == "NO")
		{
			$dahdi_cfg->no_dahdi_cfg();
			$_SESSION['dahdi_cfg'] = "NO";
		}
		
		//smg_bri functions
		if ($_REQUEST['smg_bri'] == "YES")
		{
			if ($input['dahdi_cfg'] == "YES")
			{
				$smg_ctrl->append_start_script();
			}
			else
			{
				shell_exec("cp smg_ctrl/start /etc/wanpipe/scripts");
			}
			$_SESSION['smg_bri'] = "YES";				
		}
		elseif ($_REQUEST['smg_bri'] == "NO")
		{
			if ($_REQUEST['dahdi_cfg'] == "YES")
			{
				shell_exec ("cp dahdi_config/start /etc/wanpipe/scripts");
			}
			else
			{
				shell_exec ("rm /etc/wanpipe/scripts/start");
			}
			$_SESSION['smg_bri'] = "NO";								
		}		
	}
	
	if ($_REQUEST['tc_stop'] == "Stop Media Processing")
	{
		$cmd = "/usr/sbin/" . $_SESSION['media_script'] . " stop";
		exec($cmd);
		exec("echo \$?",$output);
		
		//echo "Response was " . $output[0] . "<br />";
		
		if ($output[0] != 0)
		{
			$_SESSION['media_stop_error'] = "yes";
		}	
		else
		{
			unset($_SESSION['media_stop_error']);
			$cmd = "pidof " . $_SESSION['gateway_script'];
			exec ($cmd,$smg_status);
			
			if ($smg_status[0] > 0)
			{
				$cmd = "/usr/sbin/" . $_SESSION['cli'] . " -x \"unload mod_sangoma_codec\"";
				exec($cmd);
			}			
		}
				
		$_SESSION['reload'] = "yes";
		header( 'Location:controls.php' ) ;
	}
	if ($_REQUEST['gateway_stop'] == "Stop Gateway")
	{
		$cmd = "/etc/init.d/" . $_SESSION['gateway_script'] . " stop &> /dev/null";
		//echo $cmd;
		exec($cmd);	
		exec("/usr/sbin/wanrouter stop all &",$output);
				
		$_SESSION['reload'] = "yes";
		header( 'Location:controls.php' ) ;
	}
	
	if ($_REQUEST['tc_start'] == "Start Media Processing")
	{
		$cmd = $cmd = "/usr/sbin/" . $_SESSION['media_script'] . " start";
		exec($cmd);
		exec("echo \$?",$output);
		
		//echo "Response was " . $output[0] . "<br />";
		
		if ($output[0] != 0)
		{
			$_SESSION['media_start_error'] = "yes";
		}
		else
		{
			unset($_SESSION['media_start_error']);
			$cmd = "pidof " . $_SESSION['gateway_script'];
			exec ($cmd,$smg_status);
			
			if ($smg_status[0] > 0)
			{
				$cmd = "/usr/sbin/" .  $_SESSION['cli'] . " -x \"load mod_sangoma_codec\"";
				exec($cmd);
			}
		}
				
		$_SESSION['reload'] = "yes";
		header( 'Location:controls.php' ) ;
	}	
	if ($_REQUEST['gateway_start'] == "Start Gateway")
	{
		$cmd = "/usr/sbin/wanrouter start &> " . $_SESSION['smg_root_path'] . "/nginx/html/php/temp";
		exec($cmd, $output);
		exec ("grep -E 'ERROR|ioctl' -c temp", $output);
		exec ("rm -f temp");

		/*for ($a = 0; $a <= count($output); $a++)
		{
			echo "<pre>$output[$a]</pre>";
		}*/
		//exec("wanrouter start", $output);
		if ($output[0] > 0)
		{
			exec ("wanrouter stop all");
			$_SESSION['wanrouter_error'] = $output[0];
		}
		else
		{
			unset($_SESSION['wanrouter_error']);
		}
		//echo "starting\n";
		//shell_exec ("/etc/init.d/sangoma-media-gateway start &");
		$cmd = "/etc/init.d/" . $_SESSION['gateway_script'] . " start &> /dev/null";
		exec($cmd);
		//echo "done starting\n";
	
		//check exit status
		$cmd = "echo \$?";
		exec ($cmd,$output);
		
		//echo "exit status = " . $output[0] . "<br />";	
		
		if ($output[0] > 0)
		{
			$_SESSION['smg_error'] = "yes";
		}
		else
		{
			unset($_SESSION['smg_error']);
		}
					
		$_SESSION['reload'] = "yes";	
		header( 'Location:controls.php' ) ;
	}
	
	if ($_REQUEST['tc_restart'] == "Restart Media Processing")
	{
		$cmd = $cmd = "/usr/sbin/" . $_SESSION['media_script'] . " stop";
		exec($cmd);
		exec("echo $?",$output);
		
		if ($output[0] != 0)
		{
			$_SESSION['media_stop_error'] = "yes";
		}	
		else
		{
			unset($_SESSION['media_stop_error']);
			$cmd = "pidof " . $_SESSION['gateway_script'];
			exec ($cmd,$smg_status);
			
			if ($smg_status[0] > 0)
			{
				$cmd = "/usr/sbin/" . $_SESSION['cli'] . " -x \"unload mod_sangoma_codec\"";
				exec($cmd);
			}			
			
			$cmd = $cmd = "/usr/sbin/" . $_SESSION['media_script'] . " start";
			exec($cmd);
			exec("echo $?",$output);
			
			if ($output[0] != 0)
			{
				$_SESSION['media_start_error'] = "yes";
			}
			else
			{
				unset($_SESSION['media_start_error']);
				$cmd = "pidof " . $_SESSION['gateway_script'];
				exec ($cmd,$smg_status);
				
				if ($smg_status[0] > 0)
				{
					$cmd = "/usr/sbin/" . $_SESSION['cli'] . " -x \"load mod_sangoma_codec\"";
					exec($cmd);
				}				
			}		
		}	

		$_SESSION['reload'] = "yes";
		header( 'Location:controls.php' ) ;				
	}
	if ($_REQUEST['gateway_restart'] == "Restart Gateway")
	{
		$cmd = "/etc/init.d/" . $_SESSION['gateway_script'] . " stop";
		exec ($cmd);

		exec("/usr/sbin/wanrouter stop all &",$output);
		$cmd = "/usr/sbin/wanrouter start &> " . $_SESSION['smg_root_path'] . "/nginx/html/php/temp";
		exec($cmd, $output);
		exec ("grep -E 'ERROR|ioctl' -c temp", $output);
		exec ("rm -f temp");

		/*for ($a = 0; $a <= count($output); $a++)
		{
			echo "<pre>$output[$a]</pre>";
		}*/
		//exec("wanrouter start", $output);
		if ($output[0] > 0)
		{
			exec ("/usr/sbin/wanrouter stop all");
			$_SESSION['wanrouter_error'] = $output[0];
		}
		else
		{
			unset($_SESSION['wanrouter_error']);
		}
		
		$cmd = "/etc/init.d/" . $_SESSION['gateway_script'] . " start &> /dev/null";
		exec ($cmd);
		
		//check exit status
		$cmd = "echo \$?";
		exec ($cmd,$output);
		
		if ($output[0] > 0)
		{
			$_SESSION['smg_error'] = "yes";
		}
		else
		{
			unset($_SESSION['smg_error']);
		}
		
		$_SESSION['reload'] = "yes";
		header( 'Location:controls.php' ) ;
	}
	
	
	if ($_REQUEST['refresh'] == "Refresh")
	{
		header("location:controls.php");
	}

	//Checks if transcoding is enabled or disabled
	$table_name = "transcode_setup";
	
	$type = $data->select_statement($db_location, $table_name, "setup", "id = 1");	
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include 'sqlite/database_creation.php';
		//include 'database_classes.php';	
		include 'display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
		
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("Control Panel", "../../style.css","");		
	}	


	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
?>

<h2>CONTROL PANEL</h2>

<?php
	}
?>
<form method="" action="controls.php">
	<table width='70%' cellpadding='0' cellspacing='0' border='0'>
		<tr>
			<td width='50%'>
            	<table border="1" width="300px" class="mytable">
                	<th class="widget-content-header ui-state-active ui-corner-top" colspan="2" align="left"><?php echo $_SESSION['shortname']; ?> Status</th>
			
					<tr>
                    	<td class="mytableheader ui-state-active">Process</td>
                        <td class="mytableheader  ui-state-active">Status</td>
                    </tr>        
    <?php //<p><font color="red">NOTE: After starting the Sangoma Drivers and/or Sangoma Media Gateway, you must refresh the page or set the auto-refresh to shorter refresh intervals.</font></p> ?>

	   				 <tr>
						<td><b>Media Gateway</b></td>
<?php
	$cmd = "pidof " . $_SESSION['gateway_script'];
	exec($cmd,$output);
	if ($output[0] <= 0)
	{
		echo "<td align=\"center\" style=\"background-color:#FE0A10\"><font color=\"black\"><b>DOWN</b></td>";
		$free="down";
	}
	else
	{
		echo "<td align=\"center\" style=\"background-color:#00FF00\"><font color=\"black\"><b>UP</b></font></td>";
		$free="up";
	}

	unset($output);
?>
					</tr>
				    <tr>
	    			    <td><b>TDM Driver</b></td>
<?php
	exec ("wanrouter status | grep -c wanpipe", $output);
	
	if ($type['setup'] != "")
	{
		if ($output[0] == 0)
		{
			echo "<td align=\"center\" style=\"background-color:#FE0A10\"><font color=\"black\"><b>DOWN</b></font></td>";
			$wan="down";
		}
		else
		{
			echo "<td align=\"center\" style=\"background-color:#00FF00\"><font color=\"black\"><b>UP</b></font></td>";
			$wan="up";
		}
	}
	else
	{
		if ($output[0] == 0)
		{
			echo "<td align=\"center\" style=\"background-color:#FE0A10\" class=\"ui-corner-br\"><font color=\"black\"><b>DOWN</b></font></td>";
			$wan="down";
		}
		else
		{
			echo "<td align=\"center\" style=\"background-color:#00FF00\" class=\"ui-corner-br\"><font color=\"black\"><b>UP</b></font></td>";
			$wan="up";
		}
	}
	unset($output);

?>
					</tr>
<?php

	if ($type['setup'] != "")
	{
?>        
	    			<tr>
	        			<td class="ui-corner-bl"><b>Media Processing</b></td>
<?php	
	exec ("pidof sngtc_server", $sngtc);
	if ($sngtc[0] == 0)
	{
		echo "<td align=\"center\" style=\"background-color:#FE0A10\" class=\"ui-corner-br\"><font color=\"black\"><b>DOWN</b></font></td>";
		$wan="down";
	}
	else
	{
		echo "<td align=\"center\" style=\"background-color:#00FF00\" class=\"ui-corner-br\"><font color=\"black\"><b>UP</b></font></td>";
		$wan="up";
	}
	
	unset($output);

?>
					</tr> 
<?php
	}
?>
			</table>
            </td>
        	<td width='50%' align='right'>
	            <b>Auto Refresh</b>: <input type="text" name="auto_value" value="<?php echo $auto_refresh; ?>" style="width:30px" align="center" /> seconds<br />
                <input type='submit' name="refresh" value="Refresh" <?php echo $_SESSION['button_class']; ?>/>
	   			<input type='submit' name="refresh_button" value="Update Interval" <?php echo $_SESSION['button_class']; ?>/>
	        </td>
        </tr>
	</table>
	<br />
	<hr />    
	<h4>Gateway Controls</h4>
<?php
	if ($wan == "down" && $free == "down")
	{
?>		
	<input type="submit" name="gateway_start" value="Start Gateway" <?php echo $_SESSION['button_class']; ?> />
	<input type="submit" name="gateway_stop" value="Stop Gateway" <?php echo $_SESSION['disabled_button_class']; ?> disabled="disabled"/>    
	<input type="submit" name="gateway_restart" value="Restart Gateway" <?php echo $_SESSION['disabled_button_class']; ?> disabled="disabled"/>  
<?php
	}
	else
	{
?>  
	<input type="submit" name="gateway_start" value="Start Gateway" <?php echo $_SESSION['disabled_button_class']; ?> disabled="disabled"/>
	<input type="submit" name="gateway_stop" value="Stop Gateway" <?php echo $_SESSION['button_class']; ?>/>    
	<input type="submit" name="gateway_restart" value="Restart Gateway" <?php echo $_SESSION['button_class']; ?>/>  
<?php		
	}
	
	if ($type['setup'] != "")
	{
?>
	<br /><br />
	<h4>Media Processing Controls</h4>
<?php
		exec ("pidof sngtc_server", $sngtc);
		//echo "media variable = " . $sngtc[0] . "<br />";
		if ($sngtc[0] == "" )
		{
?>
	<input type="submit" name="tc_start" value="Start Media Processing" <?php echo $_SESSION['button_class']; ?>/>
	<input type="submit" name="tc_stop" value="Stop Media Processing" <?php echo $_SESSION['disabled_button_class']; ?>  disabled="disabled"/>    
	<input type="submit" name="tc_restart" value="Restart Media Processing" <?php echo $_SESSION['disabled_button_class']; ?>  disabled="disabled"/>      
<?php		

		}
		if ($sngtc[0] > 0)
		{
?>
	<input type="submit" name="tc_start" value="Start Media Processing" <?php echo $_SESSION['disabled_button_class']; ?>  disabled="disabled"/>
	<input type="submit" name="tc_stop" value="Stop Media Processing" <?php echo $_SESSION['button_class']; ?>/>    
	<input type="submit" name="tc_restart" value="Restart Media Processing" <?php echo $_SESSION['button_class']; ?>/>      
<?php
		}
	}
?>
		 <br /><br />
         <hr />
         <h4>Gateway Options</h4>
          Start the Gateway on System Boot:
          <br />
          YES: <input type="radio" name="wanrouter" value="YES" <?php if ($_SESSION['wanrouter'] == "YES" || $_SESSION['wanrouter'] == "") { ?> checked="checked" <?php } ?>/>
          NO: <input type="radio" name="wanrouter" value="NO" <?php if ($_SESSION['wanrouter'] == "NO") { ?> checked="checked" <?php } ?>/>               
          <br />
          <?php						
              if ($_SESSION['dahdi'] != "")
              {
                  if ($_SESSION['dahdi_device'] == "yes")
                  {
          ?>
          Run dahdi_cfg after starting the TDM Driver: 
          <br />
          YES: <input type="radio" name="dahdi_cfg" value="YES" <?php if ($_SESSION['dahdi_cfg'] == "YES" || $_SESSION['dahdi_cfg'] == "") { ?> checked="checked" <?php } ?>/>
          NO: <input type="radio" name="dahdi_cfg" value="NO" <?php if ($_SESSION['dahdi_cfg'] == "NO") { ?> checked="checked" <?php } ?> /> 
          <br />
          <?php
                  }
                  if ($_SESSION['bri_exists'] == "yes")
                  {
          ?>
          Run smg_ctrl after starting the TDM Driver:
          <br />
          YES: <input type="radio" name="smg_bri" value="YES" <?php if ($_SESSION['smg_bri'] == "YES" || $_SESSION['smg_bri'] == "") { ?> checked="checked" <?php } ?>/>
          NO: <input type="radio" name="smg_bri" value="NO" <?php if ($_SESSION['smg_bri'] == "NO") { ?> checked="checked" <?php } ?> /> 
          <br />
          <?php
                  }
              }
          ?>
          <br />
          <input type="submit" name="gateway_options" value="Change Gateway Options" <?php echo $_SESSION['button_class']; ?> />
	</form>

	
<?php
	if ($_REQUEST['gateway_options'] == "Change Gateway Options")
	{
		echo "<br />\n<hr />\n";
		if ($_SESSION['wanrouter'] == "YES")
		{
			echo "The Gateway <b>will</b> Start on system startup<br />";
		}
		elseif ($_SESSION['wanrouter'] == "NO")
		{
			echo "The Gateway <b>will not</b> Start on system startup<br />";
		}
		if ($_SESSION['dahdi'] != "" && $_SESSION['dahdi_cfg'] == "YES")
		{
			echo "dahdi_cfg <b>will</b> run after the TDM Driver has started<br />";
		}
		if ($_SESSION['dahdi'] != "" && $_SESSION['dahdi_cfg'] == "NO")
		{
			echo "dahdi_cfg <b>will not</b> run after the TDM Driver has started<br />";
		}
		if ($_SESSION['smg_bri'] != "" && $_SESSION['smg_bri'] == "YES" && $_SESSION['dahdi'] != "")
		{
			echo "smg_ctrl <b>will</b> run after the TDM Driver has started<br />";
		}
		if ($_SESSION['smg_bri'] != "" && $_SESSION['smg_bri'] == "NO" && $_SESSION['dahdi'] != "")
		{
			echo "smg_ctrl <b>will not</b> run after the TDM Driver has started<br />";
		}	
	}
	if ($_SESSION['wanrouter_error'] > 0)
	{
?>
<br />
<hr />
<br />
<?php

		//exec ("ln -s /var/log/messages messages");
		//exec ("ln -s /var/log/wanrouter wanrouter");
		//sleep(5);
		echo "<font color=\"red\"><b>ERROR</b></font><br />";
		echo "<font color=\"red\">THERE WAS AN ERROR STARTING THE MEDIA GATEWAY DRIVER. PLEASE CONSULT THE <a href=\"logs/messages\" target=\"_blank\">SYSTEM LOGS</a> OR THE <a href=\"logs/wanrouter\" target=\"_blank\">TDM DRIVER LOGS</a> FOR THE REASON OF THE ERROR</font><BR />";
		//exec ("rm -f messages");
		//exec ("rm -f wanrouter");
	}
	elseif ($_SESSION['media_stop_error'] == "yes")
	{
?>
<br />
<hr />
<br />
<?php

		echo "<font color=\"red\"><b>ERROR</b></font><br />";
		echo "<font color=\"red\">THERE WAS AN ERROR STOPPING THE MEDIA PROCESSING SERVICES. PLEASE CONSULT THE <a href=\"logs/messages\" target=\"_blank\">SYSTEM LOGS</a> OR THE <a href=\"logs/sngtc_server.log\" target=\"_blank\">MEDIA PROCESSING SERVER LOGS</a> FOR THE REASON OF THE ERROR</font><BR />";		
	}
	elseif($_SESSION['media_start_error'] == "yes")
	{
?>
<br />
<hr />
<br />
<?php

		echo "<font color=\"red\"><b>ERROR</b></font><br />";
		echo "<font color=\"red\">THERE WAS AN ERROR STARTING THE MEDIA PROCESSING SERVICES. PLEASE CONSULT THE <a href=\"logs/messages\" target=\"_blank\">SYSTEM LOGS</a> OR THE <a href=\"logs/sngtc_server.log\" target=\"_blank\">MEDIA PROCESSING SERVER LOGS</a> FOR THE REASON OF THE ERROR</font><BR />";
	}
	elseif ($_SESSION['smg_error'] == "yes")
	{
?>
<br />
<hr />
<br />
<?php

		//exec ("ln -s /var/log/messages messages");
		//exec ("ln -s /var/log/wanrouter wanrouter");
		//sleep(5);
		echo "<font color=\"red\"><b>ERROR</b></font><br />";
		echo "<font color=\"red\">THERE WAS AN ERROR STARTING THE MEDIA GATEWAY. PLEASE CONSULT THE <a href=\"../../../logs/sangomagw.log\" target=\"_blank\">GATEWAY LOG FILE</a> FOR THE REASON OF THE ERROR</font><BR />";		
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}
}
else
{
	header( 'Location:index.php' ) ;
}
?>
