<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

class t1e1_class
{
	
	//Class Variables
	private $error = array();			//Holds the errors created in the form
	public $error_count = "";			//Error counter variable;
	public $untoken_card_name = "";		//Card Name
	public $total_ports = "";			//Contains the total number of ports for that particular card
	private $pick = array();			//Contains the form return values
	public $port="";					//Port number being configured
	public $card_name="";				//Card name
	public $t1e1="";					//Stores whether configuring for t1 or e1
	public $database=array();			//Stores the returned values from the database
	public $card_num="";				//Stores the card number
	public $echo_exist="";				//Store the echo cancelation value
	public $num_ports="";				//Stores the number of ports on the card
	public $exist="";					//Contains value if the table for that card exists
	public $exist2="";					//Contains value if the table for that card exists	
	public $value="";
	public $proc_id="";					//Contains the SS7 Proc ID
	public $relay_type="";				//SS7 Relay type
	
	//Main Display Function
	function main()
	{
		$this->check();
		if ($this->database['line_type'] != "")
			$disable=true;
		else
			$disable=false;
	
		if ($disable) {
			echo "<br />";
			require_once ('../display_class.php');
			$notif = new NotificationBox( 'Warnings', NotificationBox::Warning );
			$notif->add("Line Type",$this->database['line_type']." has been chosen. In order to change the line type, please clear the span and return to this page.");
			$notif->display();
			unset($notif);
			echo "<br />";			
		}		
		?>
		
	<form name="select-type" method="post">
			<table class="mytable" width='100%'>
                <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left"><?php echo $this->card_name . " Port " . $this->port . " Configuration - " . $this->t1e1 . "\n"; ?></th>
            	<tr>
                	<td class="mytablesubheader" width='30%'>Link Type</td>
                    <td width='70%'>
    <?php
	
		if ($this->t1e1 == "T1") {
			if ($disable)
				//echo '<input type="submit" name="type" value="T1" style="color:black; background-color: #999; font-weight:bold" disabled="disabled" />';
				echo "<b>T1</b>";
			else
				echo '<input type="submit" name="type" value="T1" style="color:black; background-color: #999; font-weight:bold"/>';
		}
		else {
			if (!$disable)
				echo "<input type=\"submit\" name=\"type\" value=\"T1\" style=\"background-color: #CCC\"/>";
		}
		
		if ($this->t1e1 == "E1") {
			if ($disable)
				//echo '<input type="submit" name="type" value="E1" style="color:black; background-color: #999; font-weight:bold" disabled="disabled" />';
				echo "<b>E1</b>";
			else
				echo '<input type="submit" name="type" value="E1" style="color:black; background-color: #999; font-weight:bold"/>';
		}
		else {
			if (!$disable)
				echo "<input type=\"submit\" name=\"type\" value=\"E1\" style=\"background-color: #CCC\"/>";
		}



	?>
		<?php /*<input type="submit" name="type" value="J1" />*/ ?>
	        </td>
        </tr>
    </table>	
	</form>
    <form name ="options">        
	    <input type="hidden" name="type" value="<?php echo $this->t1e1; ?>" />
        <!-- Default to CCS always. Change if user chooses MFC/R2 for a span -->
        <input type="hidden" name="sig_mode" value="CCS" />
		<br />
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Standard Options</th>
			<tr>
				<td class="mytablesubheader" width='30%'>Framing</td>
				<td width='40%'>
					<select name="framing">
                    <?php
					if ($this->t1e1 == "T1")
					{
					?>                    
						<option value="esf" <?php if ($this->pick['framing_esf'] == "yes") { ?> selected="selected" <?php } ?> >ESF</option>
						<option value="d4" <?php if ($this->pick['framing_d4'] == "yes") { ?> selected="selected" <?php } ?> >D4</option>
                    <?php
					}
					elseif ($this->t1e1 == "E1")
					{
					?>
						<option value="crc4" <?php if ($this->pick['framing_crc4'] == "yes") { ?> selected="selected" <?php } ?> >CRC4</option>
						<option value="ncrc4" <?php if ($this->pick['framing_ncrc4'] == "yes") { ?> selected="selected" <?php } ?> >NCRC4</option>                    
					<?php
					}
					?>                                            
					</select>
				</td>
                <td width='30%'><?php echo $this->error['framing']; ?></td>
			</tr>                      
			<tr>
				<td class="mytablesubheader" width='30%'>Coding</td>
				<td width='40%'>
					<select name="coding">
                    <?php
					if ($this->t1e1 == "T1")
					{
					?>
						<option value="b8zs" <?php if ($this->pick['coding_b8zs'] == "yes") { ?> selected="selected" <?php } ?> >B8ZS</option>
						<option value="ami" <?php if ($this->pick['coding_ami'] == "yes") { ?> selected="selected" <?php } ?> >AMI</option>                        
                    <?php
					}
					elseif ($this->t1e1 == "E1")
					{
					?>
						<option value="hdb3" <?php if ($this->pick['coding_hdb3'] == "yes") { ?> selected="selected" <?php } ?>>HDB3</option>
                    <?php
					}
					?>
					</select>
				</td>
                <td width='30%'></td>
			</tr>
			<tr>
				<td class="mytablesubheader" width='30%'>Clock Source</td>
				<td width='40%'>
					<select name="clock">
						<option value="normal" <?php if ($this->pick['clock_normal'] == "yes") { ?> selected="selected" <?php } ?>>Normal</option>
						<option value="master" <?php if ($this->pick['clock_master'] == "yes") { ?> selected="selected" <?php } ?> >Master</option>
					</select>
				</td>
                <td width='30%'></td>
			</tr>
                <?php
					//Removed as per bug 7723. If MFC/R2 chosen, will switch to CAS
					//Will default to CCS always!
						/*if ($this->t1e1 == "E1")
						{
				?>                    
                <tr>
                	<td class="mytablesubheader" width='30%'>Signalling Mode</td>
                    <td width='40%'>
                    	<select name="sig_mode">
                        	<option value="CCS"  <?php if ($this->pick['sig_mode_ccs'] == "yes") { ?> selected="selected" <?php } ?> >CCS</option>
                			<option value="CAS" <?php if ($this->pick['sig_mode_cas'] == "yes") { ?> selected="selected" <?php } ?> >CAS</option>
                        </select>                     
                    </td>
                    <td width='30%'></td>
                </tr>
                <?php
						}*/
				?>              
        <?php 
			if ($_SESSION['card_clicked'] != "B601")
			{
		?>		    
			<tr>
    	        <td class="mytablesubheader" width='30%'>Reference Clock</td>        
    	        <td width='40%'>
    	           	<select name="ref_clock">
                    	<option value="0">No Reference Clock</option>
	    <?php
				for ($a = 1;$a <= $this->num_ports; $a++)
				{
					$return = "ref_clock_" . $a;
		?>
    	       			<option value="<?php echo $a; ?>" <?php if ($this->pick[$return] == "yes") { ?> selected="selected" <?php } ?>>Port <?php echo $a; ?></option>
        <?php
				}
		?>
    				</select>
                </td>
                <td width='30%'><?php echo $this->error['ref_clock']; ?></td>
			</tr>  
		<?php
			}
			//echo $returned_value[6];
			if ($this->echo_exist > 0)
			{
				?>
			<tr>
				<td class="mytablesubheader" width='30%'>Hardware Echo Cancellation</td>
				<td width='40%'>
					<select name="HW_EC" id="HW_EC" >
						<option value="enable" <?php if ($this->pick['echo_enable'] == "yes") { ?> selected="selected" <?php } ?> >Enable</option>
						<option value="disable" <?php if ($this->pick['echo_disable'] == "yes") { ?> selected="selected" <?php } ?> >Disable</option>
					</select>
				</td> 
                <td width='30%'></td>               
			</tr>
			<tr>
				<td class="mytablesubheader" width='30%'>HW DTMF Detection</td>
				<td width='40%'>

               		<select name="dtmf" id="DTMF" >
						<option value="enable" <?php if ($this->pick['dtmf_enable'] == "yes") { ?> selected="selected" <?php } ?> >Enable</option>
						<option value="disable" <?php if ($this->pick['dtmf_disable'] == "yes") { ?> selected="selected" <?php } ?> >Disable</option>
					</select>
                </td>
                <td width='30%'><?php echo $this->error['dtmf']; ?></td>
			</tr>
			<tr>
				<td class="mytablesubheader" width='30%'>HW Fax Detection</td>
				<td width='40%'>
					<select name="HW_FAX" id="HW_FAX" >
						<option value="disable" <?php if ($this->pick['fax_disable'] == "yes") { ?> selected="selected" <?php } ?> >Disable</option>                    
						<option value="enable" <?php if ($this->pick['fax_enable'] == "yes") { ?> selected="selected" <?php } ?> > Enable</option>
					</select>                
                </td>
                <td width='30%'><?php echo $this->error['fax']; ?></td>
			</tr>
		<?php
			}
		?>
        </table>
        <br />
		<div class="fakelink"
			id="show_e"
			onclick="this.style.display='none';
			document.getElementById('hide_e').style.display='block';
			document.getElementById('options').style.display='inline';
            ResizeFrame();
			">&raquo; Show Advanced Options</div>
		<div class="fakelink"
			id="hide_e"
			onclick="this.style.display='none';
			document.getElementById('show_e').style.display='block';
			document.getElementById('options').style.display='none';
            ResizeFrame();
			">&raquo; Hide Advanced Options</div>
		<div id="options">
        	<br />
            <font color="red">NOTE: These options are set to their default parameters and shouldn't be changed unless required.</font>
            <br />
			<br />
		<table class="mytable" width='100%'>
            <th colspan="5" class="widget-content-header ui-state-active ui-corner-top" align="left">Advanced Options</th> 
                <tr>
                	<td class="mytablesubheader" width='30%'>Inband DTMF Removal Buffer</td>
                    <td width='40%'><input type="text" name="pre_buffer_size" style="width:30px" value="<?php echo $this->pick['pre_buffer_size'];?>" /></td>
					<td width='30%'><?php echo $this->error['pre_buffer_size']; ?></td>
    			</tr>            
            	<tr>
                	<td class="mytablesubheader" width='30%'>LBO</td>
                    <td width='40%'>
                    	<select name="lbo">
                <?php
						if ($this->t1e1 == "T1")
						{
				?>                             
                        	<option value="0DB" <?php if ($this->pick['lbo_0db'] == "yes") { ?> selected="selected" <?php } ?>>0 DB</option>
                            <option value="7.5DB" <?php if ($this->pick['lbo_75db'] == "yes") { ?> selected="selected" <?php } ?> >7.5 DB</option>
                            <option value="15DB" <?php if ($this->pick['lbo_15db'] == "yes") { ?> selected="selected" <?php } ?> >22.5 DB</option>
                            <option value="0-110ft" <?php if ($this->pick['lbo_0ft'] == "yes") { ?> selected="selected" <?php } ?> >0-110 ft</option>
                            <option value="110-220ft" <?php if ($this->pick['lbo_110ft'] == "yes") { ?> selected="selected" <?php } ?> >110-220 ft</option>
                            <option value="220-330ft" <?php if ($this->pick['lbo_220ft'] == "yes") { ?> selected="selected" <?php } ?> >220-330 ft</option>
                            <option value="330-440ft" <?php if ($this->pick['lbo_330ft'] == "yes") { ?> selected="selected" <?php } ?> >330-440 ft</option>
                            <option value="440-550ft" <?php if ($this->pick['lbo_440ft'] == "yes") { ?> selected="selected" <?php } ?> >440-550 ft</option>
                            <option value="550-660ft" <?php if ($this->pick['lbo_550ft'] == "yes") { ?> selected="selected" <?php } ?> >550-660 ft</option>
                <?php
						}
						elseif ($this->t1e1 == "E1")
						{
				?>                               
                            <option value="120OH" <?php if ($this->pick['lbo_120oh'] == "yes") { ?> selected="selected" <?php } ?> >120 OH</option>
                            <option value="750OH" <?php if ($this->pick['lbo_750oh'] == "yes") { ?> selected="selected" <?php } ?> >750 OH</option>
				<?php
						}
				?>
						</select>
					</td> 
                    <td width='30%'></td>                                                   
                </tr>

                <tr>
                	<td class="mytablesubheader" width='30%'>TxTristate</td>
                    <td width='40%'>
                    	<select name="txtristate">
                        	<option value="enable" <?php if ($this->pick['txtristate_enable'] == "yes") { ?> selected="selected" <?php } ?> >Enable</option>
                            <option value="disable" <?php if ($this->pick['txtristate_disable'] == "yes") { ?> selected="selected" <?php } ?> >Disable</option>
                        </select>
                    </td>  
                    <td width='30%'></td>  
                </tr>              
                <tr>
                	<td class="mytablesubheader" width='30%'>High Impedence</td>
                    <td width='40%'>
                    	<select name="impedence">
                        	<option value="yes" <?php if ($this->pick['impedence_yes'] == "yes") { ?> selected="selected" <?php } ?> >Enable</option>
                            <option value="no" <?php if ($this->pick['impedence_no'] == "yes") { ?> selected="selected" <?php } ?> >Disable</option>
                        </select>
                    </td>
                    <td width='30%'></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>RX Level</td>
                    <td width='40%'>
                    	<select name="rx_level">
                        	<option value="120" <?php if ($this->pick['rx_level_120'] == "yes") { ?> selected="selected" <?php } ?> >120 DB</option>
                        	<option value="175" <?php if ($this->pick['rx_level_175'] == "yes") { ?> selected="selected" <?php } ?> >175 DB</option>
                            <option value="180" <?php if ($this->pick['rx_level_180'] == "yes") { ?> selected="selected" <?php } ?> >180 DB</option>
                            <option value="225" <?php if ($this->pick['rx_level_225'] == "yes") { ?> selected="selected" <?php } ?> >225 DB</option>
                            <option value="300" <?php if ($this->pick['rx_level_300'] == "yes") { ?> selected="selected" <?php } ?> >300 DB</option>
                <?php
						if ($this->t1e1 == "T1")
						{
				?>
                			<option value="360" <?php if ($this->pick['rx_level_360'] == "yes") { ?> selected="selected" <?php } ?> >360 DB</option>
                <?php
						}
						elseif ($this->t1e1 == "E1")
						{
				?>
                			<option value="430" <?php if ($this->pick['rx_level_430'] == "yes") { ?> selected="selected" <?php } ?> >430 DB</option>
                <?php
						}
				?>
                		</select>
                	</td>
					<td width='30%'><?php echo $this->error['rx']; ?></td>
                </tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>RX Gain</td>
                    <td width='40%'><input type="text" name="rxgain" style="width:30px" value="<?php echo $this->pick['rxgain'];?>" /></td>
					<td width='30%'><?php echo $this->error['rxgain']; ?></td>
    			</tr>
                <tr>
                	<td class="mytablesubheader" width='30%'>TX Gain</td>
	                <td width='40%'><input type="text" name="txgain" style="width:30px" value="<?php echo $this->pick['txgain'] ;?>" /></td>
					<td width='30%'><?php echo $this->error['txgain'];?></td>
                </tr>
            	<?php
					if ($this->echo_exist > 0)
					{
				?>
            	<tr>
                	<td class="mytablesubheader" width='30%'>HW Tone Removal</td>
                    <td width='40%'>
						<select name="dtmf_removal" id="dtmf_removal" >
                            <option value='YES' <?php if ($this->pick['dtmf_removal_enable'] == "yes") { ?> selected="selected" <?php } ?> />Enable</option>
                            <option value='NO' <?php if ($this->pick['dtmf_removal_disable'] == "yes") { ?> selected="selected" <?php } ?> />Disable</option>
                        </select>
                    </td> 
                    <td width='30%'><?=$this->error['dtmf_removal']?></td>                                                   
                </tr>                                    
				<?php
					}
				?>                   
			</table>                	
        </div>
        <br />
        <table width="100%">
        <tr>
    <?php
	//echo $this->relay_type;
	if ($this->relay_type == "SLAVE")
	{
	?>    
        	<td width="1%"><input type="submit" name="save" value="Apply to Port" disabled='disabled' <?php echo $_SESSION['disabled_button_class']; ?>/></td>
    <?php
		if ($_SESSION['card_clicked'] != "B601")
		{                                           
	?>
        	<td width="1%"><input type="submit" name="save-all" value="Apply to all Ports" disabled='disabled' <?php echo $_SESSION['disabled_button_class']; ?>/></td>
    <?php
		}
	?>
			<td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
    <?php		
	}
	else
	{
	?>    
        	<td width="1%"><input type="submit" name="save" value="Apply to Port" <?php echo $_SESSION['button_class']; ?>/></td>
    <?php
		if ($_SESSION['card_clicked'] != "B601")
		{                                           
	?>
        	<td width="1%"><input type="submit" name="save-all" value="Apply to all Ports" <?php echo $_SESSION['button_class']; ?>/></td>
    <?php
		}
	?>
			<td align="right"><input type="submit" name="cancel" value="Cancel Configuration" <?php echo $_SESSION['button_class']; ?>/></td>
    <?php
	}
	?>
         </tr>
         </table>
	</form>
	<br />  
        <?php
	}
	
	//function that validates the form data
	function validate()
	{
		//Validate Clocking
		if ($_REQUEST['clock'] == "normal" && $_REQUEST['ref_clock'] != 0)
		{
			$this->error_count++;
			$this->error['ref_clock'] = "<font color=\"red\">Cannot use a <b>Reference clock</b> if using <b>Normal</b> Clocking</font>";
		}
		
		if ($_REQUEST['HW_EC'] == "disable" && $_REQUEST['dtmf'] == "enable")
		{
			$this->error_count++;
			$this->error['dtmf'] = "<font color=\"red\"><b>DTMF</b> cannot be enabled if <b>echo cancellation</b> is disabled</font>";
		}
		
		if ($_REQUEST['HW_EC'] == "disable" && $_REQUEST['HW_FAX'] == "enable")
		{
			$this->error_count++;
			$this->error['fax'] = "<font color=\"red\"><b>Fax Detection</b> cannot be enabled if <b>Echo Cancellation</b> is disabled</font>";
		}
		
		if ($_REQUEST['dtmf'] == "disable" && $_REQUEST['dtmf_removal'] == "YES") {
			$this->error_count++;
			$this->error['dtmf_removal'] = "<font color='red'><b>DTMF REMOVAL</b> can only be enabled if Hardware DTMF is enabled</font>";
		}
		
		//Validate High Impedence and Rx Level
		//echo "type = $this->t1e1<br />";
		if ($this->t1e1 == "T1" || $this->t1e1 == "J1")
		{
			if ($_REQUEST['impedence'] == "no" && $_REQUEST['rx_level'] != "360") 
			{
				$this->error_count++;
				$this->error['rx'] = "<font color=\"red\">Cannot change the <b>RX Level</b> if <b>High Impedence</b> is disabled</font>";
			}
		}
		elseif ($this->t1e1 == "E1")
		{
			if ($_REQUEST['impedence'] == "no" && $_REQUEST['rx_level'] != "430") 
			{
				$this->error_count++;
				$this->error['rx'] = "<font color=\"red\">Cannot change the <b>RX Level</b> if <b>High Impedence</b> is disabled</font>";
			}
		}
		
		//Validates the RX Gain
		if (is_numeric($_REQUEST['rxgain']))
		{
			if ($_REQUEST['rxgain'] < -50 || $_REQUEST['rxgain'] > 50)
			{
				$this->error_count++;
				$this->error['rxgain'] = "<font color=\"red\"><b>RX Gain</b> must be between <b>-50 and 50</b></font>\n";
			}
		}
		else
		{
			$this->error_count++;			
			$this->error['rxgain'] = "<font color=\"red\"><b>RX Gain</b> must be <b>numeric</b></font>\n";
		}
		
		//Validates the TX Gain
		if (is_numeric($_REQUEST['txgain']))
		{
			if ($_REQUEST['txgain'] < -50 || $_REQUEST['txgain'] > 50)
			{
				$this->error_count++;
				$this->error['txgain'] = "<font color=\"red\"><b>TX Gain</b> must be between <b>-50 and 50</b></font>\n";
			}
		}
		else
		{
			$this->error_count++;			
			$this->error['txgain'] = "<font color=\"red\"><b>TX Gain</b> must be <b>numeric</b></font>\n";
		}				  
  		
		//B8ZS only with ESF
		if ($_REQUEST['coding'] == "b8zs" && $_REQUEST['framing'] == "d4")
		{
			$this->error['framing'] = "<font color=\"red\"><b>B8ZS</b> coding can only be used with <b>ESF</b> framing</font>";
			$this->error_count++;
		}
		
		//AMI only with D4
		if ($_REQUEST['coding'] == "ami" && $_REQUEST['framing'] == "esf")
		{
			$this->error['framing'] = "<font color=\"red\"><b>AMI</b> coding can only be used with <b>D4</b> framing</font>";
			$this->error_count++;
		}		
		
		//Pre-Buffer Size
		if ($_REQUEST['pre_buffer_size'] == "") {
			$this->error['pre_buffer_size'] = "<font color='red'><b>TDM Pre-Buffer</b> MUST have an entry.</font>";
			$this->error_count++;
		}
		elseif (!is_numeric($_REQUEST['pre_buffer_size'])) {
			$this->error['pre_buffer_size'] = "<font color='red'><b>TDM Pre-Buffer</b> MUST be a numeric value.</font>";
			$this->error_count++;
		}
		else {		
			if ($_REQUEST['pre_buffer_size'] < 0 || $_REQUEST['pre_buffer_size'] > 200) {
				$this->error['pre_buffer_size'] = "<font color='red'><b>TDM Pre-Buffer</b> MUST be between 0 and 200</font>";
				$this->error_count++;
			}
		}	
	}
	
	
	//Checks what values to display within the form
	function check()
	{
		$this->card_name = $_SESSION['card_clicked'];
				
		//DTMF Removal
		if ($_REQUEST['dtmf_removal'] == "YES")
			$this->pick['dtmf_removal_enable'] = "yes";
		elseif ($_REQUEST['dtmf_removal'] == "NO")	
			$this->pick['dtmf_removal_disable'] = "yes";
		elseif ($this->database['dtmf_removal'] == "YES")
			$this->pick['dtmf_removal_enable'] = "yes";
		elseif ($this->database['dtmf_removal'] == "NO")
			$this->pick['dtmf_removal_disable'] = "yes";
		elseif ($this->database['dtmf_removal'] == "" && $_REQUEST['dtmf_removal'] == "")
			$this->pick['dtmf_removal_disable'] = "yes";
						
		//Coding
		if ($_REQUEST['coding'] == "b8zs")
			$this->pick['coding_b8zs'] = "yes";
		elseif ($_REQUEST['coding'] == "hdb3")
			$this->pick['coding_hdb3'] = "yes";
		elseif ($_REQUEST['coding'] == "ami")
			$this->pick['coding_ami'] = "yes";
		elseif ($this->database['coding'] == "b8zs")
			$this->pick['coding_b8zs'] = "yes";
		elseif ($this->database['coding'] == "hdb3")
			$this->pick['coding_hdb3'] = "yes";
		elseif ($this->database['coding'] == "ami")
			$this->pick['coding_ami'] = "yes";					
		
		//framing
		if ($_REQUEST['framing'] == "esf")
			$this->pick['framing_esf'] = "yes";
		elseif ($_REQUEST['framing'] == "d4")
			$this->pick['framing_d4'] = "yes";
		elseif ($_REQUEST['framing'] == "crc4")
			$this->pick['framing_crc4'] = "yes";
		elseif ($_REQUEST['framing'] == "ncrc4")
			$this->pick['framing_ncrc4'] = "yes";
		elseif ($this->database['framing'] =="esf")
			$this->pick['framing_esf'] = "yes";
		elseif ($this->database['framing'] =="d4")
			$this->pick['framing_d4'] = "yes";
		elseif ($this->database['framing'] =="crc4")
			$this->pick['framing_crc4'] = "yes";
		elseif ($this->database['framing'] =="ncrc4")
			$this->pick['framing_ncrc4'] = "yes";
		elseif ($_REQUEST['framing'] == "" && $this->database['framing'] == "" && $this->t1e1 == "E1")
			$this->pick['framing_ncrc4'] = "yes";								
		
		//Clock
		if ($_REQUEST['clock'] == "normal")
			$this->pick['clock_normal'] = "yes";
		elseif ($_REQUEST['clock'] == "master")
			$this->pick['clock_master'] = "yes";
		elseif ($this->database['clock'] == "normal")
			$this->pick['clock_normal'] = "yes";
		elseif ($this->database['clock'] == "master")
			$this->pick['clock_master'] = "yes";
		
		//Refernce Clock
		for ($a = 1;$a <= $this->num_ports; $a++)
		{
			$return = "ref_clock_" . $a;
			if ($_REQUEST['ref_clock'] == $a)
				$this->pick[$return] = "yes";
			elseif ($this->database['ref_clock'] == $a)
				$this->pick[$return] = "yes";					
		}
		
		//echo cancellation
		if ($_REQUEST['HW_EC'] == "enable")
			$this->pick['echo_enable'] = "yes";
		if ($_REQUEST['HW_EC'] == "disable")
			$this->pick['echo_disable'] = "yes";
		elseif ($this->database['echo'] == "enable")
			$this->pick['echo_enable'] = "yes";
		elseif ($this->database['echo'] == "disable")
			$this->pick['echo_disable'] = "yes";
		elseif ($_REQUEST['echo'] == "" && $this->database['echo'] == "")
			$this->pick['echo_enable'] = "yes";
		
		//DTMF
		if ($_REQUEST['dtmf'] == "enable")
			$this->pick['dtmf_enable'] = "yes";
		elseif ($_REQUEST['dtmf'] == "disable")
			$this->pick['dtmf_disable'] = "yes";				
		elseif ($this->database['dtmf'] == "enable")
			$this->pick['dtmf_enable'] = "yes";
		elseif ($this->database['dtmf'] == "disable")
			$this->pick['dtmf_disable'] = "yes";
		elseif ($_REQUEST['dtmf'] == "" && $this->database['dtmf'] == "")
			$this->pick['dtmf_enable'] = "yes";		
		
		//Fax Detection
		if ($_REQUEST['HW_FAX'] == "enable")
			$this->pick['fax_enable'] = "yes";
		elseif ($_REQUEST['HW_FAX'] == "disable")
			$this->pick['fax_disable'] = "yes";
		elseif ($this->database['fax'] == "enable")
			$this->pick['fax_enable'] = "yes";
		elseif ($this->database['fax'] == "disable")
			$this->pick['fax_disable'] = "yes";								
		elseif ($_REQUEST['HW_FAX'] == "" && $this->database['fax'] == "")
			$this->pick['fax_disable'] = "yes";
		
		//LBO
		if ($_REQUEST['lbo'] == "0DB")
			$this->pick['lbo_0db'] = "yes";
		elseif ($_REQUEST['lbo'] == "7.5DB")
			$this->pick['lbo_75db'] = "yes";
		elseif ($_REQUEST['lbo'] == "15DB")
			$this->pick['lbo_15db'] = "yes";
		elseif ($_REQUEST['lbo'] == "0-110ft")
			$this->pick['lbo_0ft'] = "yes";	
		elseif ($_REQUEST['lbo'] == "110-220ft")
			$this->pick['lbo_110ft'] = "yes";
		elseif ($_REQUEST['lbo'] == "220-330ft")
			$this->pick['lbo_220ft'] = "yes";				
		elseif ($_REQUEST['lbo'] == "330-440ft")
			$this->pick['lbo_330ft'] = "yes";				
		elseif ($_REQUEST['lbo'] == "440-550ft")
			$this->pick['lbo_440ft'] = "yes";
		elseif ($_REQUEST['lbo'] == "550-660ft")
			$this->pick['lbo_550ft'] = "yes";				
		elseif ($_REQUEST['lbo'] == "120OH")
			$this->pick['lbo_120oh'] = "yes";				
		elseif ($_REQUEST['lbo'] == "750OH")
			$this->pick['lbo_750oh'] = "yes";				
		elseif ($this->database['lbo'] == "0DB")
			$this->pick['lbo_0db'] = "yes";
		elseif ($this->database['lbo'] == "7.5DB")
			$this->pick['lbo_75db'] = "yes";
		elseif ($this->database['lbo'] == "15DB")
			$this->pick['lbo_15db'] = "yes";
		elseif ($this->database['lbo'] == "0-110ft")
			$this->pick['lbo_0ft'] = "yes";				
		elseif ($this->database['lbo'] == "110-220ft")
			$this->pick['lbo_110ft'] = "yes";				
		elseif ($this->database['lbo'] == "220-330ft")
			$this->pick['lbo_220ft'] = "yes";				
		elseif ($this->database['lbo'] == "330-440ft")
			$this->pick['lbo_330ft'] = "yes";				
		elseif ($this->database['lbo'] == "440-550ft")
			$this->pick['lbo_440ft'] = "yes";				
		elseif ($this->database['lbo'] == "550-660ft")
			$this->pick['lbo_550ft'] = "yes";				
		elseif ($this->database['lbo'] == "120OH")
			$this->pick['lbo_120oh'] = "yes";				
		elseif ($this->database['lbo'] == "750OH")
			$this->pick['lbo_750oh'] = "yes";															
		elseif ($_REQUEST['lbo'] == "" && $this->database['lbo'] == "" && $this->t1e1 == "T1")
			$this->pick['lbo_0db'] = "yes";
		elseif ($_REQUEST['lbo'] == "" && $this->database['lbo'] == "" && $this->t1e1 == "E1")
			$this->pick['lbo_120oh'] = "yes";
			
		//txtristate
		if ($_REQUEST['txtristate'] == "enable")
			$this->pick['txtristate_enable'] = "yes";
		elseif ($_REQUEST['txtristate'] == "disable")
			$this->pick['txtristate_disable'] = "yes";
		elseif ($this->database['txtristate'] == "enable")
			$this->pick['txtristate_enable'] = "yes";
		elseif ($this->database['txtristate'] == "disable")
			$this->pick['txtristate_disable'] = "yes";
		elseif ($_REQUEST['txtristate'] == "" && $this->database['txtristate'] == "")
			$this->pick['txtristate_disable'] = "yes";

		//sig_mode
		if ($_REQUEST['sig_mode'] == "CCS")
			$this->pick['sig_mode_ccs'] = "yes";
		elseif ($_REQUEST['sig_mode'] == "CAS")
			$this->pick['sig_mode_cas'] = "yes";
		elseif ($this->database['sigmode'] == "CCS")
			$this->pick['sig_mode_ccs'] = "yes";
		elseif ($this->database['sigmode'] == "CAS")
			$this->pick['sig_mode_cas'] = "yes";
		
		//impedence
		if ($_REQUEST['impedence'] == "yes")
			$this->pick['impedence_yes'] = "yes";
		elseif ($_REQUEST['impedence'] == "no")
			$this->pick['impedence_no'] = "yes";
		elseif ($this->database['impedence'] == "yes")
			$this->pick['impedence_yes'] = "yes";
		elseif ($this->database['impedence'] == "no")
			$this->pick['impedence_no'] = "yes";
		elseif ($_REQUEST['impedence'] == "" && $this->database['impedence'] == "")
			$this->pick['impedence_no'] = "yes";
		
		//rx_level
		if ($_REQUEST['rx_level'] == "120")
			$this->pick['rx_level_120'] = "yes";
		elseif ($_REQUEST['rx_level'] == "175")
			$this->pick['rx_level_175'] = "yes";
		elseif ($_REQUEST['rx_level'] == "180")
			$this->pick['rx_level_180'] = "yes";
		elseif ($_REQUEST['rx_level'] == "225")
			$this->pick['rx_level_225'] = "yes";
		elseif ($_REQUEST['rx_level'] == "300")
			$this->pick['rx_level_300'] = "yes";
		elseif ($_REQUEST['rx_level'] == "360")
			$this->pick['rx_level_360'] = "yes";
		elseif ($_REQUEST['rx_level'] == "430")
			$this->pick['rx_level_430'] = "yes";
		elseif ($this->database['rx_level'] == "120")
			$this->pick['rx_level_120'] = "yes";
		elseif ($this->database['rx_level'] == "175")
			$this->pick['rx_level_175'] = "yes";
		elseif ($this->database['rx_level'] == "180")
			$this->pick['rx_level_180'] = "yes";
		elseif ($this->database['rx_level'] == "225")
			$this->pick['rx_level_225'] = "yes";
		elseif ($this->database['rx_level'] == "300")
			$this->pick['rx_level_300'] = "yes";
		elseif ($this->database['rx_level'] == "360")
			$this->pick['rx_level_360'] = "yes";
		elseif ($this->database['rx_level'] == "430")
			$this->pick['rx_level_430'] = "yes";
		elseif ($_REQUEST['rx_level'] == "" && $this->database['rx_level'] == "" && $this->t1e1 == "T1")
			$this->pick['rx_level_360'] = "yes";
		elseif ($_REQUEST['rx_level'] == "" && $this->database['rx_level'] == "" && $this->t1e1 == "E1")
			$this->pick['rx_level_430'] = "yes";
		
		//RX Gain
		if ($_REQUEST['rxgain'] != "")
			$this->pick['rxgain'] = $_REQUEST['rxgain'];
		elseif ($this->database['rxgain'] != "")
			$this->pick['rxgain'] = $this->database['rxgain'];
		elseif ($_REQUEST['rxgain'] == "")
			$this->pick['rxgain'] = "0.0";	

		//TX Gain
		if ($_REQUEST['txgain'] != "")
			$this->pick['txgain'] = $_REQUEST['txgain'];
		elseif ($this->database['txgain'] != "")
			$this->pick['txgain'] = $this->database['txgain'];
		elseif ($_REQUEST['txgain'] == "")
			$this->pick['txgain'] = "0.0";					
			
		//TDM Pre-Buffer Size
		if ($_REQUEST['pre_buffer_size'] != "")
			$this->pick['pre_buffer_size'] = $_REQUEST['pre_buffer_size'];
		elseif ($this->database['pre_buffer_size'] != "")
			$this->pick['pre_buffer_size'] = $this->database['pre_buffer_size'];
		elseif ($_REQUEST['pre_buffer_size'] == "")
			$this->pick['pre_buffer_size'] = "140";
	}
	
	//Stores Database Information inside a variable (Used in the configuration Pages)
	function display_database($db_location,$data)
	{	
		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = "card_present";
		$param = "*";
		$where_param = "id = ". $this->card_num;
		$return = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		$this->echo_exist = $return['echo'];
		$this->num_ports = $return['num_ports'];		
	}
	

	function get_information($db_location,$data)
	{
		//Database Information
		//$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $this->card_name . "_" . $this->card_num;		
		$totaltables = $data->check_for_table($db_location, $table_name);
		
		if ($totaltables > 1)
		{ 	
			//Gets the information from the database
			$param = "*";
			$where_param = "port_id = " . $this->port;
			
			$this->database = $data->select_statement ($db_location, $table_name, $param, $where_param);
		}
		
		$this->exist = $totaltables;
	}
	
	
	function check_ss7_database($data)
	{
		//Database Information
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $this->card_name . "_" . $this->card_num . "_SS7_link";		
		$totaltables = $data->check_for_table($db_location, $table_name);
				
		$this->exist2 = $totaltables;
	}
	
	function check_ss7_port($data)
	{
		//Database Information
		$db_location = "sqlite:../sqlite/cardinfo.db";
		$table_name = $this->card_name . "_" . $this->card_num . "_SS7_link";
		$where_param = "port_id = " . $this->port;
		$param = "port_id";
		
		$this->value = $data->select_statement($db_location, $table_name, $param, $where_param);
		
	}
}


?>
