<?php
/*
	NSG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Starts PHP Session
session_start();

//Page Authentication
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	$_SESSION['first_time'] = "true";
	
	//Includes the File which contains classes
	include '../classes.php';
	include '../database_classes.php';
	include 'configure_t1e1_class.php';
	
	//Class Constructors
	//$display_common = new Display_common;
	$data = new database_class;
	$t1e1 = new t1e1_class;
	
	//Loads information from session variables
	$t1e1->card_name = $_SESSION['card_clicked'];
	$t1e1->card_num = $_SESSION['card_num'];
	$t1e1->port = $_SESSION['port_num_clicked'];
	$t1e1->proc_id = $_SESSION['proc_id'];
	
	//Database related variables
	if ($t1e1->proc_id == 1)
		$db_location = "sqlite:../sqlite/cardinfo.db";	
	elseif ($t1e1->proc_id > 1)
		$db_location = "sqlite:../sqlite/cardinfo" . $t1e1->proc_id . ".db";
	
	//Check relay_type
	$table_exist = $data->check_for_table('sqlite:../sqlite/relay_info.db',"ss7_relay");
	if ($table_exist > 1)
	{
		$relay = $data->select_statement('sqlite:../sqlite/relay_info.db',"ss7_relay","relay_type","id = 1");
		$t1e1->relay_type = $relay['relay_type'];
	}
	
	//$db_location="sqlite:../sqlite/cardinfo.db";
	$table_name = $t1e1->card_name . "_" . $t1e1->card_num;
	
	//echo $t1e1->proc_id;
	//echo $db_location;
	
	//Get information out of the card_present table
	$t1e1->display_database($db_location,$data);
	
	//Check to see if there is anything for the port in question within it's table
	$t1e1->get_information($db_location,$data);
	
	if ($_REQUEST['type'])
	{
		$t1e1->t1e1 = $_REQUEST['type'];
		unset($t1e1->database);
	}
	elseif ($t1e1->database['line_type'])
		$t1e1->t1e1 = $t1e1->database['line_type'];
	elseif ($_SESSION['hw_line'] != "")
		$t1e1->t1e1 = $_SESSION['hw_line'];
	else
		$t1e1->t1e1 = "E1";
		
	
	//Validates and redirects
	if ($_REQUEST['save'] == "Apply to Port" || $_REQUEST['save-all'] == "Apply to all Ports")
	{
		//Validate the form
		$t1e1->validate();
	
		//If there are no errors, place into the database
		if ($t1e1->error_count == 0)
		{
			//echo $t1e1->exist . "<br />";
			if ($t1e1->exist < 2)
			{
				//Table does not exist
				$parameters = "port_id int primary key, dev_name varchar(60), line_type varchar(10), coding varchar(10), framing varchar(10), clock varchar(30), ref_clock int, echo varchar(30), dtmf varchar(30), dtmf_removal varchar(30), fax varchar(30), lbo varchar(30), txtristate varchar(30), sigmode varchar(10), impedence varchar(30), rx_level varchar(30), rxgain decimal(10,2), txgain decimal(10,2), pre_buffer_size int";
				
				$data->create_table($db_location, $table_name, $parameters);
			}
			else {
				//check if all the table elements are there
				//pre_buffer_size
			 	$parameters = "port_id int primary key, dev_name varchar(60), line_type varchar(10), coding varchar(10), framing varchar(10), clock varchar(30), ref_clock int, echo varchar(30), dtmf varchar(30), dtmf_removal varchar(30), fax varchar(30), lbo varchar(30), txtristate varchar(30), sigmode varchar(10), impedence varchar(30), rx_level varchar(30), rxgain decimal(10,2), txgain decimal(10,2), pre_buffer_size int";
				$insert_parameters = "port_id, dev_name, line_type, coding, framing, clock, ref_clock, echo, dtmf, fax, lbo, txtristate, sigmode, impedence, rx_level, rxgain, txgain, dtmf_removal";
				$data->check_schema($db_location, $table_name, $parameters, "19", $insert_parameters);
			}
			
			if ($_REQUEST['save'] == "Apply to Port")
			{
				//Check if the line exists
				$param = "port_id";
				$where_param = "port_id = " . $t1e1->port;
				
				
				$result = $data->select_statement ($db_location, $table_name, $param, $where_param);

				if ($result['port_id'] != "")
				{
					//update
					$update_param = "port_id = " . $t1e1->port . ", dev_name = \"" . $t1e1->card_name . "\", line_type = \"" . $t1e1->t1e1 . "\", coding = \"" .$_REQUEST['coding'] . "\", framing = \"" . $_REQUEST['framing'] . "\", clock = \"" . $_REQUEST['clock'] . "\", ref_clock = \"" . $_REQUEST['ref_clock'] . "\", echo = \"" .$_REQUEST['HW_EC']. "\", dtmf = \"" . $_REQUEST['dtmf'] . "\", fax = \"" . $_REQUEST['HW_FAX'] . "\", lbo = \"" . $_REQUEST['lbo'] . "\", txtristate = \"" . $_REQUEST['txtristate'] . "\", sigmode = \"" . $_REQUEST['sig_mode'] . "\", impedence = \"" . $_REQUEST['impedence'] . "\", rx_level = \"" . $_REQUEST['rx_level'] . "\", rxgain = \"" . $_REQUEST['rxgain'] . "\", txgain = \"" . $_REQUEST['txgain'] . "\", dtmf_removal = \"" .$_REQUEST['dtmf_removal'] . "\", pre_buffer_size=\"" . $_REQUEST['pre_buffer_size'] . "\"";
					
					$where_param = "port_id = " . $t1e1->port;
					$data->update_table ($db_location, $table_name, $update_param, $where_param);
				}
				else
				{
					$insert_parameters = "port_id, dev_name, line_type, coding, framing, clock, ref_clock, echo, dtmf, fax, lbo, txtristate, sigmode, impedence, rx_level, rxgain, txgain, dtmf_removal, pre_buffer_size";	
					$values = $t1e1->port . ", \"" . $t1e1->card_name . "\", \"" . $t1e1->t1e1 . "\", \"" .$_REQUEST['coding'] . "\", \"" . $_REQUEST['framing'] . "\", \"" . $_REQUEST['clock'] . "\",\"" . $_REQUEST['ref_clock'] . "\", \"" .$_REQUEST['HW_EC']. "\", \"" . $_REQUEST['dtmf'] . "\", \"" . $_REQUEST['HW_FAX'] . "\", \"" . $_REQUEST['lbo'] . "\", \"" . $_REQUEST['txtristate'] . "\", \"" . $_REQUEST['sig_mode'] . "\", \"" . $_REQUEST['impedence'] . "\", \"" . $_REQUEST['rx_level'] . "\", \"" . $_REQUEST['rxgain'] . "\", \"" . $_REQUEST['txgain'] . "\", \"" . $_REQUEST['dtmf_removal'] . "\", \"" . $_REQUEST['pre_buffer_size'] . "\"";
										
					$data->insert_statement($db_location, $table_name, $insert_parameters, $values);
				}
				
				//redirect to status page
				if ($_SESSION['msbg'] == "yes")
					header( 'Location:../wanrouterhwprobe.php' );								
				elseif ($_SESSION['nbess7']=="yes")
				{
					//If no signalling configuration done for the port, go to ss7 link configuration, else, return to tdm configuration page
					$t1e1->check_ss7_database($data);
					
					if ($t1e1->exist2 < 2)
						header( 'Location:../SS7/decide_ss7_linktype.php' );
					else
					{
						//check if port exists
						$t1e1->check_ss7_port($data);
						if ($t1e1->value['port_id'] == "")
							header( 'Location:../SS7/decide_ss7_linktype.php' );
						else
							header( 'Location:../SS7/decide_ss7_linktype.php' );
					}
				}
			}
			elseif ($_REQUEST['save-all'] == "Apply to all Ports")
			{
				for ($a = 1; $a <= $t1e1->num_ports; $a++)
				{
					//Check if the line exists
					$param = "port_id";
					$where_param = "port_id = " . $a;
					$result = $data->select_statement ($db_location, $table_name, $param, $where_param);
					
					if ($result['port_id'] == "")
					{
						$insert_parameters = "port_id, dev_name, line_type, coding, framing, clock, ref_clock, echo, dtmf, dtmf_removal, fax, lbo, txtristate, sigmode, impedence, rx_level, rxgain, txgain, pre_buffer_size";	
						$values = $a . ", \"" . $t1e1->card_name . "\", \"" . $t1e1->t1e1 . "\", \"" .$_REQUEST['coding'] . "\", \"" . $_REQUEST['framing'] . "\", \"" . $_REQUEST['clock'] . "\",\"" . $_REQUEST['ref_clock'] . "\", \"" .$_REQUEST['HW_EC']. "\", \"" . $_REQUEST['dtmf'] . "\", \"" . $_REQUEST['dtmf_removal'] . "\", \"" . $_REQUEST['HW_FAX'] . "\", \"" . $_REQUEST['lbo'] . "\", \"" . $_REQUEST['txtristate'] . "\", \"" . $_REQUEST['sig_mode'] . "\", \"" . $_REQUEST['impedence'] . "\", \"" . $_REQUEST['rx_level'] . "\", \"" . $_REQUEST['rxgain'] . "\", \"" . $_REQUEST['txgain'] . "\", \"" . $_REQUEST['pre_buffer_size'] . "\"";	
					
						//Insert into database
						$data->insert_statement($db_location, $table_name, $insert_parameters, $values);							
					}	
					else
					{
						$update_param = "port_id = " . $a . ", dev_name = \"" . $t1e1->card_name . "\", line_type = \"" . $t1e1->t1e1 . "\", coding = \"" .$_REQUEST['coding'] . "\", framing = \"" . $_REQUEST['framing'] . "\", clock = \"" . $_REQUEST['clock'] . "\", ref_clock = \"" . $_REQUEST['ref_clock'] . "\", echo = \"" .$_REQUEST['HW_EC']. "\", dtmf = \"" . $_REQUEST['dtmf'] . "\", fax = \"" . $_REQUEST['HW_FAX'] . "\", lbo = \"" . $_REQUEST['lbo'] . "\", txtristate = \"" . $_REQUEST['txtristate'] . "\", sigmode = \"" . $_REQUEST['sig_mode'] . "\", impedence = \"" . $_REQUEST['impedence'] . "\", rx_level = \"" . $_REQUEST['rx_level'] . "\", rxgain = \"" . $_REQUEST['rxgain'] . "\", txgain = \"" . $_REQUEST['txgain'] . "\", dtmf_removal = \"" . $_REQUEST['dtmf_removal'] . "\", pre_buffer_size = \"" . $_REQUEST['pre_buffer_size'] . "\"";
							
						$where_param = "port_id = " . $a;
						
						//Update the table with the new values
						$data->update_table ($db_location, $table_name, $update_param, $where_param);
					}
				}
	
				//redirect to status page
				header( 'Location:../wanrouterhwprobe.php' );													
			}
		}
		
	}
	//If Cancel is clicked
	if ($_REQUEST['cancel'] == "Cancel Configuration")
	{
		//Redirects to the profile creation page
		header( 'Location:../wanrouterhwprobe.php' );
	}	
			
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:../sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("T1/E1 Configuration", "../../../style.css","");		
	}	
	
	//Displays options for T1/E1/J1
	$t1e1->main();		
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer(true);	
	}

}
else
{
	header( 'Location:../index.php' ) ;
}	
?>
          