<?php
/*
	SMG WebGUI

	Software distributed under the License is distributed on an "AS IS" basis,
	WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
	for the specific language governing rights and limitations under the
	License.
	
	Licence information can be found within the file LICENCE.php
	
	The Original Code is SMG WebGUI

	The Initial Developer of the Original Code is
	Shaunt Libarian <shaunt@sangoma.com>

	Contributor(s):
	Shaunt Libarian <shaunt@sangoma.com>
*/

//Start Session
session_start();

//Page Authentication
if ($_SESSION['username'] != "" || $_SERVER['REMOTE_ADDR'] == "127.0.0.1")
{
	//Class Includes
	include "bri_config_class.php";
	include "../database_classes.php";
	
	//Class Constructors
	$bri = new bri_class;
	$data = new database_class;
	
	//SQLite information
	$table_name = $_SESSION['card_clicked'] . "_" .  $_SESSION['card_num'];
	$bri->untoken_card_name = $_SESSION['card_clicked'];
	
	$db_location = "sqlite:../sqlite/cardinfo.db";
	
	//Gets the number of ports for this card from the card_present table
	$where_param = "id = " . $_SESSION['card_num'];
	$return = $data->select_statement ($db_location, "card_present", "echo, num_ports", $where_param);
	$bri->echo_cancel = $return[0];
	$bri->total_ports = $return[1];
	
	//echo $_SESSION['bri_type'] . ", " . $_SESSION['port_num_clicked'] . ", " . $_SESSION['card_clicked'] . ", " . $_SESSION['card_num'];
	
	//Check the database. If the database exists, use that information to display
	$table_exists = $data->check_for_table ($db_location, $table_name);
	
	if ($table_exists > 1)
	{
		$param = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, rxgain, txgain";
		$where_param = "port_id = " . $_SESSION['port_num_clicked'];
		
		//Grab the information for that port
		$return = $data->select_statement ($db_location, $table_name, $param, $where_param);
		
		//Place them within the class
		$bri->conn = $return['conn_type'];
		$bri->echo = $return['hw_ec'];
		$bri->dtmf = $return['hw_dtmf'];
		$bri->fax = $return['hw_fax'];
		$bri->rxgain = $return['rxgain'];
		$bri->txgain = $return['txgain'];
		//echo $bri->echo . ", " . $bri->dtmf . ", " . $bri->fax . "<br />";
	}
	
	//if the form is submitted, populate the values of the form in the class
	if ($_REQUEST['apply'] == "Apply to Port" || $_REQUEST['apply-all'] == "Apply to all Ports")
	{
		//echo "I am here<br />";
		//Populate class variables
		if ($bri->echo_cancel == 0)
		{
			$bri->echo = "no";
			$bri->dtmf = "no";
			$bri->fax = "no";		
		}
		else
		{
			$bri->echo = $_REQUEST['hw_ec'];
			$bri->dtmf = $_REQUEST['hw_dtmf'];
			$bri->fax = $_REQUEST['hw_fax'];
		}	
		
	
		$bri->rxgain = $_REQUEST['rxgain'];
		$bri->txgain = $_REQUEST['txgain'];	
			
		//Validate Information from the form
		$bri->validate();
	
		if ($bri->error_count == 0)
		{
			//Check if the database needs to be created		
			if ($table_exists < 2)
			{
				$param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
				$data->create_table($db_location, $table_name, $param);
			}
			//If user clicks on Apply
			if ($_REQUEST['apply'] == "Apply to Port")
			{
				//Place in database
				if ($table_exists > 1)
				{
					$create_param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
					$insert_parameters = "port_id,  conn_type , dev_name , hw_ec , hw_dtmf , hw_fax , rxgain , txgain ";
					$data->check_schema($db_location, $table_name, $create_param, "8", $insert_parameters);
					
					//Check if the line exists
					$param = "port_id";
					$where_param = "port_id = " . $_SESSION['port_num_clicked'];
					$result = $data->select_statement ($db_location, $table_name, $param, $where_param);
					
					if ($result['port_id'] != "")
					{
						//update
						$parameters = "port_id = \"" .  $_SESSION['port_num_clicked'] . "\", dev_name = \"" . $bri->card_name . "\", hw_ec = \"" . $bri->echo . "\", hw_dtmf = \"" . $bri->dtmf . "\", hw_fax = \"" . $bri->fax . "\", rxgain =  \"" . $bri->rxgain ."\", txgain =  \"" . $bri->txgain . "\"";
						$where_param = "port_id = " . $_SESSION['port_num_clicked'];
						$data->update_table ($db_location, $table_name, $parameters, $where_param);
					}
					else
					{
						$parameters = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, rxgain, txgain";
						$values = $_SESSION['port_num_clicked'] . ", \"" . $bri->card_name . "\",\"" . $bri->echo . "\", \"" . $bri->dtmf . "\", \"" . $bri->fax . "\", \"" . $bri->rxgain ."\", \"" . $bri->txgain . "\"";				
						$data->insert_statement($db_location, $table_name, $parameters, $values);
					}
				}
				elseif ($table_exists < 2)
				{
					//insert
					//$insert = "INSERT INTO " . $table_name . " ( " . $parameters . " ) VALUES (" . $values . ");"
					$parameters = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, rxgain, txgain";
					$values = $_SESSION['port_num_clicked'] . ", \"" . $bri->card_name . "\", \"" . $bri->echo . "\", \"" . $bri->dtmf . "\", \"" . $bri->fax . "\", \"" . $bri->rxgain ."\", \"" . $bri->txgain . "\"";				
					$data->insert_statement($db_location, $table_name, $parameters, $values);
					
				}
				//Return to wanrouterhwprobe.php
				header( 'Location:../wanrouterhwprobe.php' ) ;
			}
			//If user clicks on Apply to all ports
			elseif ($_REQUEST['apply-all'] == "Apply to all Ports")
			{
	
				$create_param = "port_id int primary key, conn_type varchar(10), dev_name varchar(30), hw_ec varchar(10), hw_dtmf varchar(10), hw_fax varchar(10), rxgain decimal(10,2), txgain decimal(10,2)";
				$insert_parameters = "port_id,  conn_type , dev_name , hw_ec , hw_dtmf , hw_fax , rxgain , txgain ";
				$data->check_schema($db_location, $table_name, $create_param, "8", $insert_parameters);					
				
				$bri->get_ports();
				
				for ($b = 0; $b < count($bri->total_ports); $b++)
				{
					$param = "port_id, dev_name";
					$where_param = "port_id = " . $bri->total_ports[$b]['port_id'];
		
					$port = $bri->total_ports[$b]['port_id'];
			
					//Grab the information for that port
					$return = $data->select_statement ($db_location, $table_name, $param, $where_param);				
					//echo "device = " . $return['dev_name'] . ", port = $port<br />";
					//Place in database 
					if ($return['dev_name'] == "")
					{
						//update
						$parameters = "port_id = \"" .  $port . "\", dev_name = \"" . $bri->card_name . "\",  hw_ec = \"" . $bri->echo . "\", hw_dtmf = \"" . $bri->dtmf . "\", hw_fax = \"" . $bri->fax . "\", rxgain =  \"" . $bri->rxgain ."\", txgain =  \"" . $bri->txgain . "\"";
						$where_param = "port_id = " . $port;
						$data->update_table ($db_location, $table_name, $parameters, $where_param);					
					}
					elseif ($return[dev_name] != "")
					{
						$parameters = "port_id, dev_name, hw_ec, hw_dtmf, hw_fax, rxgain, txgain";
	
						//insert
						$values = $port . ", \"" . $bri->card_name . "\", \"" . $bri->echo . "\", \"" . $bri->dtmf . "\", \"" . $bri->fax . "\", \"" . $bri->rxgain ."\", \"" . $bri->txgain . "\"";				
						$data->insert_statement($db_location, $table_name, $parameters, $values);
					}			
				}
				
				//Return to wanrouterhwprobe.php
				header( 'Location:../wanrouterhwprobe.php' ) ;			
			}		
		}	
	}
	
	//If the user clicks cancel
	if ($_REQUEST['cancel'] == "Cancel Configuration")
	{
		header( 'Location:../wanrouterhwprobe.php' ) ;
	}
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/header.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//Includes required for ClearOS Integration
		include '../sqlite/database_creation.php';
		//include 'database_classes.php';	
		include '../display_class.php';
		
		$display_common = new Display_common;
		
		$_SESSION['embedded'] = "true";
	
		//ClearOS Integration
		$display_common->session_vars("sqlite:sqlite/cardinfo.db");
		$display_common->html_header();
		$display_common->html_title("BRI Configuration", "../../../style.css");		
	}	
	
	//Main BRI Configuration Page
	$bri->main();
	
	//Check to see which UI we are running in
	if (!isset($_REQUEST['embedded']) && !isset($_SESSION['embedded']))
	{
		unset($_SESSION['embedded']);
		
		//FusionPBX Integration
		require_once "../fusionpbx/includes/footer.php";
	}
	elseif (isset($_REQUEST['embedded']) || isset($_SESSION['embedded']))
	{
		//ClearOS Integration
		$display_common->html_footer();	
	}

}
else
{
	header( 'Location:../index.php' ) ;
}	
?>